package test.org.itscool.stylist.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;

import junit.framework.TestCase;

import org.itscool.stylist.io.HtmlConfigReader;
import org.itscool.stylist.tag.HtmlRootTag;

public class TestHtmlConfigReader extends TestCase{
	public void testParseSuccess1(){
		System.out.println("***************** testParseSuccess1 **********************");
		HtmlConfigReader reader = new HtmlConfigReader();
		HtmlRootTag html = new HtmlRootTag("Shift_JIS");
		try{
			reader.create("j2src/test/test/org/itscool/stylist/io/Sample1.html", html);
			System.out.println(html.toString(1, " "));
		}catch(Exception e){
			fail(e.getMessage());
			e.printStackTrace();
		}
	}
	
	public void testParseSuccess2(){
		System.out.println("***************** testParseSuccess2 **********************");
		HtmlConfigReader reader = new HtmlConfigReader();
		HtmlRootTag html = new HtmlRootTag("Shift_JIS");
		try{
			reader.create("j2src/test/test/org/itscool/stylist/io/Sample2.html", html);
			System.out.println(html.toString(1, " "));
		}catch(Exception e){
			e.printStackTrace();
			fail(e.getMessage());
		}
	}
	
	public static void testParseSuccess3(){
		System.out.println("***************** testParseSuccess3 **********************");
		HtmlConfigReader reader = new HtmlConfigReader();
		HtmlRootTag html = new HtmlRootTag("Shift_JIS");
		try{
			ByteArrayOutputStream bout = new ByteArrayOutputStream();
	    	BufferedReader br = new BufferedReader(new FileReader("j2src/test/test/org/itscool/stylist/io/Sample1.html"));
	    	String line ;
	    	while((line=br.readLine()) != null){
	    		bout.write(line.getBytes());
	    	}
			reader.create("j2src/test/test/org/itscool/stylist/io/Sample1.html",
				bout.toByteArray(), html);
			System.out.println(html.toString(1, " "));
		}catch(Exception e){
			e.printStackTrace();
			fail(e.getMessage());
		}
	}
	
	public static void testParseSuccess4(){
		System.out.println("***************** testParseSuccess4 **********************");
		HtmlConfigReader reader = new HtmlConfigReader();
		HtmlRootTag html = new HtmlRootTag("Shift_JIS");
		try{
			ByteArrayOutputStream bout = new ByteArrayOutputStream();
	    	BufferedReader br = new BufferedReader(new FileReader("j2src/test/test/org/itscool/stylist/io/Sample2.html"));
	    	String line ;
	    	while((line=br.readLine()) != null){
	    		bout.write(line.getBytes());
	    	}
			reader.create("j2src/test/test/org/itscool/stylist/io/Sample2.html",
				bout.toByteArray(), html);
			System.out.println(html.toString(1, " "));
		}catch(Exception e){
			e.printStackTrace();
			fail(e.getMessage());
		}
	}
	
	public void testParseSuccess5(){
		System.out.println("***************** testParseSuccess5 **********************");
		HtmlConfigReader reader = new HtmlConfigReader();
		HtmlRootTag html = new HtmlRootTag("Shift_JIS");
		try{
			reader.create("j2src/test/test/org/itscool/stylist/io/Sample3.html", html);
			System.out.println(html.toString(1, " "));
		}catch(Exception e){
			e.printStackTrace();
			fail("testParseError1()");
		}
	}
	
	public void testParseError1(){
		System.out.println("***************** testParseError1 **********************");
		HtmlConfigReader reader = new HtmlConfigReader();
		HtmlRootTag html = new HtmlRootTag("Shift_JIS");
		try{
			reader.create("j2src/test/test/org/itscool/stylist/io/ParseError.html", html);
			System.out.println(html.toString(1, " "));
			fail("testParseError1()");
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	public void testFileNotFound(){
		System.out.println("***************** testFileNotFound **********************");
		HtmlConfigReader reader = new HtmlConfigReader();
		HtmlRootTag html = new HtmlRootTag("Shift_JIS");
		try{
			reader.create("FileNotFound.html", html);
			System.out.println(html.toString(1, " "));
			fail("testFileNotFound()");
		}catch(Exception e){
			
			e.printStackTrace();
		}
	}
}
