package test.org.itscool.weber.user;

import java.util.List;

import org.itscool.commons.connection.TransactionUtil;
import org.itscool.weber.testcase.WeberDbTestCase;
import org.itscool.weber.user.UserRole;
import org.itscool.weber.user.UserRoleDao;

public class TestUserRoleDao extends WeberDbTestCase{
    
    public void setUp(){
        this.initTables("test-db-data.xml");
    }
    
    public void testAllData(){
    	UserRoleDao roleDao = new UserRoleDao();
    	List list = roleDao.getAllData();
    	
    	assertNotNull(list);
    	
    	if( list.size() > 0){
    		if(!(list.get(0) instanceof UserRole)){
    			fail("UserRoleDao.getAllData()Ŏ擾CX^XUser^łȂ");
    		}
    	}
    }
    
    public void testGetUserRole(){
    	UserRoleDao roleDao = new UserRoleDao();
    	UserRole role = roleDao.getRole("test_role");
    	
    	assertEquals("test_role", role.getName());
    	assertEquals(1, role.getId());
    }
    
    public void testSave(){
    	UserRoleDao roleDao = new UserRoleDao();
    	UserRole role = new UserRole();
    	role.setName("test-role-10");
    	roleDao.save(role);
    	
    	try{
    		TransactionUtil.commitTransaction();
    	}catch(Exception e){
    		fail(e.getMessage());
    	}
    }
    
    public void testUpdate(){
    	UserRoleDao roleDao = new UserRoleDao();
    	UserRole role = roleDao.getRole("test_role");
    	
    	role.setName("test-role-11");
    	roleDao.update(role);
    	
    	try{
    		TransactionUtil.commitTransaction();
    	}catch(Exception e){
    		fail(e.getMessage());
    	}
    }
    
    public void testDelete(){
    	UserRoleDao roleDao = new UserRoleDao();
    	UserRole role = new UserRole();
    	role.setName("test-role-12");
    	roleDao.save(role);
    	
    	try{
    		TransactionUtil.commitTransaction();
    	}catch(Exception e){
    		fail(e.getMessage());
    	}
    	
    	roleDao.delete(role);
    	try{
    		TransactionUtil.commitTransaction();
    	}catch(Exception e){
    		fail(e.getMessage());
    	}
    }
}
