package test.org.itscool.webersample.dao;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.itscool.commons.connection.TransactionUtil;
import org.itscool.weber.testcase.WeberDbTestCase;
import org.itscool.webersample.bean.Post;
import org.itscool.webersample.dao.PostDao;

/**
 * 쐬: 2005/06/28
 * @author kanoum
 */
public class TestPostDao extends WeberDbTestCase{
    
    public void setUp(){
        this.initTables("test-db-data.xml");
		this.clearTables();
    }
    
    public void testSave(){
        PostDao dao = new PostDao();
        Post post = new Post();
        post.setName("֐cƏ");
        post.setTel("123-456");
        post.setTel2("444-555");
        post.setPostId("400");
        
        try{
            dao.save(post);
            //R~bgȂ
            TransactionUtil.rollbackTransaction();
        }catch(Exception e){
            fail(e.getMessage());
        }
        
    }
    
    public void testSave2(){
        PostDao dao = new PostDao();
        Post post = new Post();
        post.setName("Ə");
        post.setTel("123-456");
        post.setTel2("444-555");
        post.setPostId("400");
        
        try{
            dao.save(post);
            TransactionUtil.rollbackTransaction();
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    public void testUpdate(){
        PostDao dao = new PostDao();
        Post post = new Post();
        post.setName("֐cƏ");
        post.setTel("123-456");
        post.setTel2("444-555");
        post.setPostId("400");
        
        try{
            dao.save(post);
            
            int id = post.getId();
            
            post.setName("cƏ");
            dao.update(post);
            
            Post changePost = dao.getPost(post.getId());
            if(changePost == null){
                fail("POSTf[^擾0");
                return;
            }
            
            //INSERTOID傩H
            if( id != post.getId() ){
                fail("IDsv before["+id+"] after[" + post.getId() +"]");
            }
            assertEquals("cƏ", changePost.getName());
            TransactionUtil.rollbackTransaction();
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    public void testDelete(){
        PostDao dao = new PostDao();
        Post post = new Post();
        post.setName("Ə");
        post.setTel("123-456");
        post.setTel2("444-555");
        post.setPostId("400");
        
        try{
            dao.save(post);
            dao.delete(post);
            TransactionUtil.rollbackTransaction();
        }catch(Exception e){
        	e.printStackTrace();
            fail(e.getMessage());
        }
    }
    
	public static Test suite() {
		return new TestSuite(TestPostDao.class);
	}
}
