package org.itscool.commons.bean;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;

/**
 * Bean[eBeBNX<br/>
 * JavaBeans̐A\bh̎ssNXłB
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 * @version 1.10A 2005/01/18 createInstance(String , String[] , Object[] ) ǉ
 */
public class BeanUtil{
	/**
	 * classNameŎw肳ꂽNXgetInstance\bhs܂B
	 * @param className NX̊SC
	 * @return getInstanceŐꂽIuWFNgԂ܂
	 */
    public static Object getInstance(String className){
    	Object obj = null;
    	try{
    		//NX擾
    		Class cls = Class.forName(className);
            
    		// \bh擾
    		Method method = cls.getMethod("getInstance", null);
            
            
    		// \bhs
    		obj = method.invoke(null, null);
        }catch( Exception e){
            String err = "[" + className + ":" + "getInstance" + "]" + 
                "getProperty() failed (" + BeanUtil.class.getName() + ") (" +
                e.getMessage() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        return obj;
    }
    
    /**
     * JavaBeansCX^X̐<BR>
     * w肳ꂽNXJavaBeansCX^X𐶐܂B
     * @param className NX
     * @return Object ꂽJavaBeansCX^XԂ܂
     */
    public static Object createInstance(String className)
    throws BeanUtilRuntimeException{
        Object obj = null;
        
        try{
            // NX擾
            Class cls = Class.forName(className);
            
            //IuWFNg̐
            obj = cls.newInstance();
        }catch( InstantiationException ie ){
            String err = "[" + className + "]" + 
                "InstantiationException (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }catch( ClassNotFoundException cnfe ){
            String err = "[" + className + "]" + 
                "ClassNotFoundException (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }catch( IllegalAccessException iae){
            String err = "[" + className + "]" + 
                "IllegalAccessExceptio (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        return obj;
    }
    
//add 2005/01/18 start
    /**
     * JavaBeansCX^X̐<BR>
     * w肳ꂽNXJavaBeansCX^Xt
     * RXgN^Ő܂B
     * @param className NX
     * @param argTypes ̌^Xg
     * @param argValues ̒lXg
     * @return Object ꂽJavaBeansCX^XԂ܂
     */
    public static Object createInstance(String className, String[] argTypes, Object[] argValues)
    throws BeanUtilRuntimeException{
        Object obj = null;
        
        try{
            // NX擾
            Class cls = Class.forName(className);
            
            Class arg_classes[] = new Class[argTypes.length];
            for( int i=0; i<argTypes.length; i++ ){
            	arg_classes[i] = Class.forName(argTypes[i]);
            }
            Constructor constructor = cls.getConstructor(arg_classes); 

            //IuWFNg̐
            obj = constructor.newInstance(argValues);
        }catch( InstantiationException ie ){
            String err = "[" + className + "]" + 
                "InstantiationException (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }catch( ClassNotFoundException cnfe ){
            String err = "[" + className + "]" + 
                "ClassNotFoundException (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }catch( IllegalAccessException iae){
            String err = "[" + className + "]" + 
                "IllegalAccessExceptio (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }catch( NoSuchMethodException e){
        	String err = "[" + className + "]" + 
            "NoSuchMethodException (" + BeanUtil.class.getName() + ")";
        	throw new BeanUtilRuntimeException(err);
        }catch( InvocationTargetException e){
        	String err = "[" + className + "]" + 
            "InvocationTargetException (" + BeanUtil.class.getName() + ")";
        	throw new BeanUtilRuntimeException(err);
        }
        return obj;
    }
//add 2005/01/18 end
    
    /**
     * get\bhsʂint^ŕԂ܂B<BR>
     * @param obj get\bh񋟂CX^X
     * @param propertyName vpeB
     * @return sʂint^ŕԂ܂B
     */
    public static int getIntValue(Object obj, String propertyName)
    throws BeanUtilRuntimeException{
        int value = ((Integer)getProperty(obj, propertyName)).intValue();
        return value;
    }
    
    /**
     * get\bhsʂlong^ŕԂ܂B<BR>
     * @param obj get\bh񋟂CX^X
     * @param propertyName vpeB
     * @return sʂlong^ŕԂ܂B
     */
    public static long getLongValue(Object obj, String propertyName)
    throws BeanUtilRuntimeException{
        long value = ((Long)getProperty(obj, propertyName)).longValue();
        return value;
    }
    
    /**
     * get\bhsʂdouble^ŕԂ܂B<BR>
     * @param obj get\bh񋟂CX^X
     * @param propertyName vpeB
     * @return sʂdouble^ŕԂ܂B
     */
    public static double getDoubleValue(Object obj, String propertyName)
    throws BeanUtilRuntimeException{
        double value = ((Double)getProperty(obj, propertyName)).doubleValue();
        return value;
    }
    
    /**
     * get\bhsʂfloat^ŕԂ܂B<BR>
     * @param obj get\bh񋟂CX^X
     * @param propertyName vpeB
     * @return sʂfloat^ŕԂ܂B
     */
    public static float getFloatValue(Object obj, String propertyName)
    throws BeanUtilRuntimeException{
        float value = ((Float)getProperty(obj, propertyName)).floatValue();
        return value;
    }
    
    /**
     * get\bhsʂshort^ŕԂ܂B<BR>
     * @param obj get\bh񋟂CX^X
     * @param propertyName vpeB
     * @return sʂshort^ŕԂ܂B
     */
    public static short getShortValue(Object obj, String propertyName)
    throws BeanUtilRuntimeException{
        short value = ((Short)getProperty(obj, propertyName)).shortValue();
        return value;
    }
    
    /**
     * get\bhsʂboolean^ŕԂ܂B<BR>
     * @param obj get\bh񋟂CX^X
     * @param propertyName vpeB
     * @return sʂboolean^ŕԂ܂B
     * @throws BeanUtilRuntimeException BeanUtilRuntimeException
     */
    public static boolean getBooleanValue(Object obj, String propertyName)
    throws BeanUtilRuntimeException{
        boolean value = ((Boolean)getProperty(obj, propertyName)).
            booleanValue();
        return value;
    }
    
    /**
     * get\bhs܂B<BR>
     * v~eBu^get\bhsꍇ́ÃbpNX̃CX^X
     * ߂lƂĕԂ܂B
     * @param obj get\bh񋟂CX^X
     * @param propertyName vpeB
     * @return sʂObjectŕԂ܂B
     */
    public static Object getProperty(Object obj, String propertyName)
    throws BeanUtilRuntimeException{
        Object property = null;
        
        String getterName = getGetterName(propertyName);
        if( getterName == null ){
            return null;
        }
        
        try{
            // \bh擾
            Method method = obj.getClass().getMethod(getterName, null);
            
            
            //\bh̖߂lz̏ꍇ
            if( method.getReturnType().isArray() ){
                Object[] collection = (Object[])method.invoke(obj,null);
                Iterator iterator = Arrays.asList(collection).iterator();
                property = iterator;
            }else{
                // \bhs
                property = method.invoke(obj,null);
            }
        }catch( Exception e){
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "]" + 
                "getProperty() failed (" + BeanUtil.class.getName() + ") (" +
                e.getMessage() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        return property;
    }
    
    /**
     * set\bhs܂B<br>
     * set\bhJavaBeans̃R[fBOKɊÂAP̈
     * ANZbT\bhłB<BR>
     * set\bḧ̌^́A΂ɂȂget\bh̖߂ľ^画肵܂B<BR>
     * v~eBu^̃vpeBset\bḧɓnꍇ́Aproperty̌^
     * String^łׂłB<BR>
     * setProperty\bhget\bh̖߂lɊÂAString^property
     * v~eBu^NX̃bpNXpropertyCX^Xč쐬A
     * propertyCX^Xset\bhɈɊ蓖Ă܂B
     * 
     * @param obj set\bhsCX^Xw肵Ă
     * @param propertyName set\bh̑ΏۂƂȂvpeBw肵ĂB
     * @param property set\bḧɓnCX^Xw肵ĂB
     * @return Object set\bhɖ߂l΂͎sʂԂ܂
     */
    public static Object setProperty(Object obj, String propertyName, Object property)
    {
        Class[] propertyTypes = new Class[1];
        
        //v~eBu̔
        //getter\bh̖߂ľ^setter\bȟ^ƂȂB
        /*
        Method chkMethod = getMethod(obj, propertyName);
        if(chkMethod.getReturnType().equals(int.class)){
            propertyTypes[0] = int.class;
        }else if(chkMethod.getReturnType().equals(long.class)){
            propertyTypes[0] = long.class;
        }else if(chkMethod.getReturnType().equals(double.class)){
            propertyTypes[0] = double.class;
        }else if(chkMethod.getReturnType().equals(float.class)){
            propertyTypes[0] = float.class;
        }else if(chkMethod.getReturnType().equals(short.class)){
            propertyTypes[0] = short.class;
        }else{
            propertyTypes[0] = property.getClass();    
        }
        */
        Method chkMethod = getMethod(obj, propertyName);
        if( chkMethod == null ){
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "@no getterMethod]" + 
            "setProperty() failed(" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        propertyTypes[0] = chkMethod.getReturnType();
        String setterName = getSetterName(propertyName);
        if( setterName == null ){
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "@no setterMethod]" + 
            "setProperty() failed(" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        
        try{
            // \bh擾
            Method method = obj.getClass().getMethod(setterName, propertyTypes);
            //set\bḧ̌^`FbN
            //v~eBu^̏ꍇ́Ãbp[NX̃CX^X
            //ɃZbgĂKvB
            Object[] properties = null;
            property = getNullData(property, chkMethod.getReturnType().getName());
            if( property == null ){
            	return property;
            }
            if(chkMethod.getReturnType().equals(int.class) ||
			chkMethod.getReturnType().equals(Integer.class)){
                properties = new Integer[1];
                if( property == null || property.toString().length() == 0 ){
                    properties[0] = new Integer(0);
                }else{
                    //properties[0] = Integer.valueOf((String)property);
	                properties[0] = Integer.valueOf(property.toString());
                }
            }else if(chkMethod.getReturnType().equals(long.class)||
			chkMethod.getReturnType().equals(Long.class)){
                properties = new Long[1];
                if( property == null || property.toString().length() == 0 ){
                    properties[0] = new Long(0);
                }else{
                    //properties[0] = Long.valueOf((String)property);
                    properties[0] = Long.valueOf(property.toString());
                }
            }else if(chkMethod.getReturnType().equals(double.class)||
			chkMethod.getReturnType().equals(Double.class)){
                properties = new Double[1];
                if( property == null || property.toString().length() == 0 ){
                    properties[0] = new Double(0);
                }else{
	                //properties[0] = Double.valueOf((String)property);
	                properties[0] = Double.valueOf(property.toString());
                }
            }else if(chkMethod.getReturnType().equals(float.class)||
			chkMethod.getReturnType().equals(Float.class)){
                properties = new Float[1];
                if( property == null || property.toString().length() == 0 ){
                    properties[0] = new Float(0);
                }else{
                    //properties[0] = Float.valueOf((String)property);
                    properties[0] = Float.valueOf(property.toString());
                }
            }else if(chkMethod.getReturnType().equals(short.class)||
			chkMethod.getReturnType().equals(Short.class)){
                properties = new Short[1];
                if( property == null || property.toString().length() == 0 ){
                    properties[0] = new Short("0");
                }else{
	                //properties[0] = Short.valueOf((String)property);
	                properties[0] = Short.valueOf(property.toString());
                }
            }else if(chkMethod.getReturnType().equals(boolean.class)||
			chkMethod.getReturnType().equals(Boolean.class)){
                properties = new Boolean[1];
                if( property == null || property.toString().length() == 0 ){
                    properties[0] = new Boolean(false);
                }else{
	                //properties[0] = Boolean.valueOf((String)property);
	                properties[0] = Boolean.valueOf(property.toString());
                }
            }else{
                properties = new Object[1];
                properties[0] = property;
            }
            
            //\bhs
            method.invoke(obj, properties);
        }catch( NoSuchMethodException e){
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "]" + 
                "setProperty() failed(" + BeanUtil.class.getName() + ") (" +
                e.getMessage() + ")";
            throw new BeanUtilRuntimeException(err);
        }catch( IllegalAccessException e){
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "]" + 
            "setProperty() failed(" + BeanUtil.class.getName() + ") (" +
            e.getMessage() + ")";
            throw new BeanUtilRuntimeException(err);
        }catch( InvocationTargetException e){
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "]" + 
            "setProperty() failed(" + BeanUtil.class.getName() + ") (" +
            e.getMessage() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        return property;
    }
    
    public static Class getReturnType(Object obj, String propertyName)
    throws BeanUtilRuntimeException{
        Class[] propertyTypes = new Class[1];
        Method chkMethod = getMethod(obj, propertyName);
        if( chkMethod == null ){
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "@no getterMethod]" + 
            "setProperty() failed(" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        propertyTypes[0] = chkMethod.getReturnType();
        String setterName = getSetterName(propertyName);
        if( setterName == null ){
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "@no setterMethod]" + 
            "setProperty() failed(" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        
        try{
        	return chkMethod.getReturnType();
        }catch( Exception e){
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "]" + 
                "setProperty() failed(" + BeanUtil.class.getName() + ") (" +
                e.getMessage() + ")";
            throw new BeanUtilRuntimeException(err);
        }
    }
    
    /**
     * vpeB̒l܂B
     * vpeB̒lNULL̏ꍇclazzTypeɎw肳ꂽ^ɂftHg
     * l쐬܂B
    */
    private static Object getNullData(Object property, String clazzType){
        Object ret;
        if( property != null){
            return property;
        }
        if( clazzType.equals(int.class.getName()) ||
                clazzType.equals(long.class.getName()) ||
                clazzType.equals(double.class.getName()) ||
                clazzType.equals(float.class.getName()) ){
            ret = new Integer("0");
        }else if(clazzType.equals(boolean.class.getName())){
            ret = new Boolean("false");
        }else if(clazzType.equals(String.class.getName())){
            ret = new String("");
        }else{
        	return null;
        }
        return ret.toString();
    }
    
    /**
     * propertyNamegetMethod擾܂B<BR>
     * <BR>
     * igp)<BR>
     * getterName = getGetterName("address");<BR>
     * <BR>
     * getterNameɂgetAddressA܂B<BR>
     * 
     * @param propertyName vpeB
     * @return get\bh
     */
    public static String getGetterName(String propertyName){
        String methodName = 
            propertyName.substring(0,1).toUpperCase() +
            propertyName.substring(1, propertyName.length());
        
        methodName = "get" + methodName;
        
        return methodName;
    }
    
    /**
     * propertyNamesetMethod擾܂B<BR>
     * <BR>
     * igp)<BR>
     * setterName = setGetterName("address");<BR>
     * <BR>
     * setterNameɂsetAddressA܂B<BR>
     * 
     * @param propertyName vpeB
     * @return set\bh
     */
    public static String getSetterName(String propertyName){
        String methodName = 
            propertyName.substring(0,1).toUpperCase() +
            propertyName.substring(1, propertyName.length());
            
        methodName = "set" + methodName;
        
        return methodName;
    }
    
    /**
     * getMethod擾܂B
     * @param obj 
     * @param propertyName
     * @return
     */
    private static Method getMethod(Object obj, String propertyName)
    throws BeanUtilRuntimeException{
        Method method = null;
        String getterName = getGetterName(propertyName);
        if( getterName == null ){
            return null;
        }
        
        try{
            // \bh擾
            method = obj.getClass().getMethod(getterName, null);
            
        }catch( Exception e){
            String err = "[" +obj.getClass().getName() + ":" +  propertyName + "]" + 
                "getMethod() failed (" + BeanUtil.class.getName() + ") (" +
                e.getMessage() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        return method;
    }

    /**
     * ^̈قȂIuWFNg̃Rs[쐬܂B
     * srcClassNameŎw肵NX^CṽCX^X쐬܂
     * srcClassNameɃZbgvpeB͈dstŎw肵IuWFNg
     * ĂvpeB̃Rs[Zbg܂B
     * srcClassNameɎw肳ꂽvpeBdstɖꍇ́AftHgl
     * Zbg܂
     * 
     * @param dst Rs[IuWFNg
     * @param srcClassName Rs[IuWFNg̃NX
     * @return Rs[IuWFNgԂ܂
     */
    public static Object copyInstance( Object dst, String srcClassName){
        Object src = BeanUtil.createInstance(srcClassName);
        Field[] fields = src.getClass().getDeclaredFields();
        for( int i=0; i<fields.length; i++){
            Field field = fields[i];
            //System.out.println( field.getType());
            int modifier = field.getModifiers();
            if( Modifier.PRIVATE == modifier ||
                Modifier.PROTECTED == modifier){
                String propertyName = field.getName();
    
                Field chkField = null;
                chkField = getField( dst.getClass(), propertyName);
                
                if( chkField == null ){
                    continue;
                }
    
                Object property = BeanUtil.getProperty(dst, propertyName);
                BeanUtil.setProperty(src, propertyName, property);
            }
        }
        return src;
    }
    
    /**
     * clazzŎw肳ꂽNXApropertyNameŎw肳ꂽo
     * 擾܂
     * @param clazz NX
     * @param propertyName vpeB
     * @return Field^̃oԂ܂
     */
    public static Field getField( Class clazz, String propertyName) {
        Field chkField = null;
        try{
            chkField = clazz.getDeclaredField(propertyName);
        }catch( NoSuchFieldException nsfe ){
        }
        if( chkField == null ){
            Class superClazz = clazz.getSuperclass();
            if( superClazz == null ){
                return null;
            }
            chkField = getField(superClazz, propertyName);
        }
        return chkField;
    }
}
