package org.itscool.commons.connection;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;

/**
 * gUNVptB^<BR>
 * RlNVv[̏yуf[^ANZXwŎsꂽgUNV
 * ̎sʂR~bg/[obNstB^łB
 * 
 * @author kanou
 *
 */
public class TransactionFilter implements Filter{
	private AbstractLog log;
	private boolean initFlag = false;
	
	/**
	 * RlNVv[̏s܂<BR>
	 * BeanFactoryCX^XgāAweb.xml̃ReLXgp[^udi-config-frameworkv
	 * Ɏw肳ꂽBean`t@CConnectionMangaerCX^X擾܂B
	 * BeanFactoryCX^XStartupFilterł炩ߏĂKv܂B
	 * 
	 * @param filterConfig FilterConfigCX^X
	 */
	public void init(FilterConfig filterConfig) throws ServletException {
//		System.out.println("-- Starting " + this.getClass().getName() + " --");
//		ServletContext context = filterConfig.getServletContext();
//		String configName = context.getInitParameter("di-config");
//		String rootPath = context.getRealPath("/");
//		String configPath = rootPath + configName;
//		System.out.println("-- Create ConnectionPool Instance --");
        
        BeanFactory factory = BeanFactory.getInstance();
		if( !factory.isInit() ){
			try{
        		factory.createForUrl("di-config.xml");
        	}catch(Exception ex){
        		ex.printStackTrace();
            	throw new ServletException(ex.getMessage());
        	}    
		}
		
//modify 2006/03/12 kano start
		try{
			log = (AbstractLog)factory.getInstance("Log");
        	if(!log.isInit()){
        		log = (AbstractLog)factory.createInstance("Log");
        	}
        }catch(Exception ioe){
        	log = SimpleLog.getInstance();
        	log.info(ioe.getMessage());
        }
//modify 2006/03/12 kano end
        
        try{
        	//log = (Log)factory.createInstance("Log");
        	ConnectionManager manager = (ConnectionManager)factory.createInstance("ConnectionManager");
            manager.init();
            log.info("completed initialize instance='" + manager.getClass().getName() + "'" );
            log.info("ConnectionManager Info="+manager.toString());
            initFlag = true;
        }catch(Exception ex){
        	log.error(ex.getMessage());
            //throw new ServletException(ex.getMessage());
        }
    }
	
	/**
	 * chain.doFilter()sɃgUNṼR~bg/[obNs܂<BR>
	 * gUNV͈ȉ̗ōs܂<BR>
	 * (1) chain.doFilter()̌Ăяo<BR>
	 * (2) TransactionUtil.getTransaction()ThreadLocalɃZbgĂTransaction
	 * CX^X擾<BR>
	 * (3) TransactionCX^X̃Xe[^X擾<BR>
	 * (4) Xe[^XPLEASE_COMMIT̏ꍇ̓R~bgs܂<BR>
	 * (4)' Xe[^XPLEASE_ROLLBACK̏ꍇ̓[obNs܂<BR>
	 * (4)'' Exceptionꍇ[obNs܂<BR>
	 * (4)''' ȊȌꍇ͉s܂<BR>
	 * (5) ThreadLocalɃZbgꂽgUNVRlNVv[ɖ߂܂<BR>
	 * 
	 * @param request ServletRequestCX^X
	 * @param response ServletResponseCX^X
	 */
    public void doFilter(ServletRequest request, ServletResponse response,
    FilterChain chain)
    throws IOException, ServletException {

        try {
        	if( initFlag == true ){
	        	//gUNVJn܂B
	        	TransactionUtil.beginTransaction();
	        	//ƖWbNs܂B
	            chain.doFilter(request, response);
	            //gUNVXe[^XPLEASE_COMMITȂR~bgs
	            if(TransactionUtil.getTransaction().getTranStatus() == Transaction.PLEASE_COMMIT ){
	            	TransactionUtil.commitTransaction();
	            	log.debug("COMMIT TRANSACTION");
	            }else if(TransactionUtil.getTransaction().getTranStatus() == Transaction.PLEASE_ROLLBACK){
	            	TransactionUtil.rollbackTransaction();
	            	log.debug("ROLLBACK TRANSACTION");
	            }
        	}else{
        		log.warn("ConnectionManager is not initialized");
        		//ƖWbNs܂B
	            chain.doFilter(request, response);
        	}
        }catch(IOException ioe){
          	TransactionUtil.rollbackTransaction();
          	TransactionUtil.returnTransaction();
          	log.debug("ROLLBACK TRANSACTION");
          	log.error(ioe);
//          	ioe.printStackTrace();
            throw ioe;
            
        }catch(ServletException se){
          	TransactionUtil.rollbackTransaction();
          	TransactionUtil.returnTransaction();
          	log.debug("ROLLBACK TRANSACTION");
          	log.error(se);
//          	se.printStackTrace();
            throw se;
//add 2005/09/27 kano start
        } catch (NullPointerException e) {
        	TransactionUtil.rollbackTransaction();
        	TransactionUtil.returnTransaction();
        	log.debug("ROLLBACK TRANSACTION");
        	log.error(e);
//        	e.printStackTrace();
			throw new ServletException(e.getMessage());
		}catch(RuntimeException re){
        	TransactionUtil.rollbackTransaction();
        	TransactionUtil.returnTransaction();
          	log.debug("ROLLBACK TRANSACTION");
          	log.error(re);
          	re.printStackTrace();
            throw new ServletException(re.getMessage());
        }catch(Exception e){
        	TransactionUtil.rollbackTransaction();
        	TransactionUtil.returnTransaction();
          	log.debug("ROLLBACK TRANSACTION");
          	log.error(e);
//          	e.printStackTrace();
            throw new ServletException(e.getMessage());
        }catch(Error e){
            	TransactionUtil.rollbackTransaction();
            	TransactionUtil.returnTransaction();
              	log.debug("ROLLBACK TRANSACTION");
              	log.error(e);
//              	e.printStackTrace();
                throw new ServletException(e.getMessage());
//add 2005/09/27 kano end
        } finally {
        	//gUNVI܂B
        	TransactionUtil.returnTransaction();
        }
    }
    
    /**
     * SẴRlNVARlNVv[J܂ 
     */
    public void destroy() {
    	BeanFactory factory = BeanFactory.getInstance();
        ConnectionManager manager = (ConnectionManager)factory.createInstance("ConnectionManager");
        manager.destroy();
    }
}
