package org.itscool.commons.document;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/**
 * RtBOt@CǂݍރNX<BR>
 * XMLhLgǂݏo{ۃNXł
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public abstract class XmlConfigReader {
	protected AbstractLog log = SimpleLog.getInstance();
    protected File xmlFile;
    protected DocumentBuilderFactory factory;
    protected DocumentBuilder builder;
    protected Document document;
    protected String configName;
	
	public String getConfigName(){
		return configName;
	}
	
	public void setConfigName(String configName ){
		this.configName = configName;
	}
	
	public void create(HashMap nodeList ) throws IOException{
    	ClassLoader parent = Thread.currentThread().getContextClassLoader(); 
		URL url = parent.getResource(configName);
	    //URL url = ConfigReader.class.getResource(fileName);
		if( url == null ){
			throw new IOException(configName + " is not found.");
		}
		log.info("load config is " + url.getFile());
		create(url.getFile(), nodeList);
    }
	
	public void create(LinkedList nodeList ) throws IOException{
    	ClassLoader parent = Thread.currentThread().getContextClassLoader(); 
		URL url = parent.getResource(configName);
	    //URL url = ConfigReader.class.getResource(fileName);
		if( url == null ){
			throw new IOException(configName + " is not found.");
		}
		log.info("load config is " + url.getFile());
		create(url.getPath(), nodeList);
    }
    
    /**
     * DocumentBuildergXMLt@Cǂݍ݂܂
     * @param path RtBOt@C̃pXw肵܂
     * @param nodeList ǂݍDOMi[CX^Xw肵܂
     * @throws Exception t@C̓ǂݍ݂Ɏsꍇ͗OExceptionX[܂
     */
    public void create(String path, HashMap nodeList ) throws IOException{
    	File xmlFile = new File( path );
        if( !xmlFile.isFile()) {
            String err = "Can not found file at config file(" + path +")";
            throw new IOException(err);
        }
        try{
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
			//G[Enh̓o^
            XmlConfigExceptionHandler handler = new XmlConfigExceptionHandler();
            handler.setFileName(path);
			builder.setErrorHandler(handler);
            document = builder.parse ( xmlFile);    //hLg
        }catch( Exception e){
            throw new IOException(e.getMessage());
        }
        doCreate(nodeList);
    }
    
    /**
     * DocumentBuildergXMLt@Cǂݍ݂܂
     * @param path RtBOt@C̃pXw肵܂
     * @param nodeList ǂݍDOMi[CX^Xw肵܂
     * @throws Exception t@C̓ǂݍ݂Ɏsꍇ͗OExceptionX[܂
     */
    public void create(String path, LinkedList nodeList ) throws IOException{
        File xmlFile = new File( path );
        if( !xmlFile.isFile()) {
            String err = "[" + path + "]" + 
                "Can not found file  at config file(" + 
                XmlConfigReader.class.getName()+")";
            throw new IOException(err);
        }
        try{
            factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            builder = factory.newDocumentBuilder();
			//G[Enh̓o^
            XmlConfigExceptionHandler handler = new XmlConfigExceptionHandler();
            handler.setFileName(path);
			builder.setErrorHandler(handler);
            document = builder.parse ( xmlFile);    //hLg
        }catch( SAXException e){
			throw new IOException(e.getMessage());
			
		}catch( Exception e){
			e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        doCreate(nodeList);
    }
    
    /**
	 * w肳ꂽHTML͂܂
	 * @param uri NGXgURI
	 * @param buf HTML
	 * @return List nodeList ͌
	*/
	public void create(String uri, byte[] buf, HashMap nodeList ) throws IOException{
		
		try{
			ByteArrayInputStream bIn = new ByteArrayInputStream(buf);
			
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
			//G[Enh̓o^
            XmlConfigExceptionHandler handler = new XmlConfigExceptionHandler();
            handler.setFileName(uri);
			builder.setErrorHandler(handler);
            document = builder.parse(bIn);    //hLg
        }catch( SAXException e){
			throw new IOException(e.getMessage());
			
		}catch( Exception e){
            throw new IOException(e.getMessage());
        }
		doCreate(nodeList);
	}
	
    /**
	 * w肳ꂽHTML͂܂
	 * @param uri NGXgURI
	 * @param buf HTML
	 * @return List nodeList ͌
	*/
	public void create(String uri, byte[] buf, LinkedList nodeList ) throws IOException{
		
		try{
			ByteArrayInputStream bIn = new ByteArrayInputStream(buf);
			
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
			//G[Enh̓o^
            XmlConfigExceptionHandler handler = new XmlConfigExceptionHandler();
            handler.setFileName(uri);
			builder.setErrorHandler(handler);
            document = builder.parse(bIn);    //hLg
        }catch( SAXException e){
        	String msg = e.getMessage() + System.getProperty("line.separator") + new String(buf);
        	throw new IOException(msg);
			
		}catch( Exception e){
			String msg = e.getMessage() + System.getProperty("line.separator") + new String(buf);
        	throw new IOException(msg);
        }
		doCreate(nodeList);
	}
	
    /**
     * XMLt@Cvf͂܂<br>
     * ͌ʂnodeListɃZbg܂<br>
     * @param nodeList XML̉͌
    */
    protected void doCreate(HashMap nodeList) throws IOException{}
    
    /**
     * XMLt@Cvf͂܂<br>
     * ͌ʂnodeListɃZbg܂<br>
     * @param nodeList XML̉͌
    */
    protected void doCreate(LinkedList nodeList) throws IOException{}
}


