package org.itscool.commons.threadpool;

/**
 * This class implements the Thread Pool.
 * @author Ashwin Desai.
 * @version 1.10A 2002.06.23 [ [ L[̃obt@TCY̎wǉ
 */
public class ThreadPool {
    /** Default Number of Threads in the pool */
    public static final int DEFAULT_MAX_THREADS = 10;
    /** Max Number of Threads in the pool. */
    private int maxThreads;
    /** Threads array. */
    private WorkerThread[] threadPool;
    /** Request Buffer.*/
    private FIFOQueue workQueue;

    /**
     * @link
     * @shapeType PatternLink
     * @pattern TestCase
     * @clientRole tested
     * @supplierRole tests
     * @hidden 
     */
    /*# private TestThreadPool _testThreadPool; */

    /**
     * Creates a new ThreadPool with 'maxthreadcount' number of threads.
     * Xbh́umaxthreadcountvio[ŐVThreadPoolo܂B
     * @param maxthreadcount Xbhw肵܂
     */
    public ThreadPool(int maxthreadcount) {
        this.maxThreads = maxthreadcount;
        threadPool = new WorkerThread[maxThreads];
        workQueue = new FIFOQueue();
        initThreads();
    }

    /**
    * Xbhv[̐ <BR>
    * L[̃TCYƃobt@̃TCYw肷B<BR>
    * TCY̎ẃy L[̃TCY  obt@̃TCYzƂȂ悤
    * w肷邱Ƃ𐄏B<BR>
    *   (L[ɒǉXbhAobt@TCY𒴂Thread
    * BufferExceptionX[邽߁jB
    * @param maxthreadcount : L[̃TCY
    * @param maxbuffersize : obt@̃TCY
    */
    public ThreadPool(int maxthreadcount, int maxbuffersize) {
        this.maxThreads = maxthreadcount;
        threadPool = new WorkerThread[maxThreads];
        workQueue = new FIFOQueue(maxbuffersize);
        initThreads();
    }

    /**
     * Creates a new ThreadPool with 2 threads (default).
     * DEFAULT_MAX_THREADS̃XbhDEFAULT_BUFFER_SIZẼNGXg
     * obt@VThreadPoolo܂(ftHg)B
     */
    public ThreadPool() {
        this(DEFAULT_MAX_THREADS, FIFOQueue.DEFAULT_BUFFER_SIZE);
    }

    /**
     * Creates a new WorkerThread for each thread in the array.
     * zɂꂼ̃Xbĥ߂̐VWorkerThreado܂B
     */
    private void initThreads() {
        for (int i = 0; i < threadPool.length; i++) {
            threadPool[i] = new WorkerThread(workQueue);
        }
    }

    /**
     * Adds a new Request to the Queue.
     * L[ɐVNGXg܂B
     * @param target Xbhw肵܂
     * @throws ClosedException if the request queue is already closed.
     * NGXgEL[łɕCloseException𓊂B
     */
    public void addRequest(Runnable target)
        throws ClosedException, ThreadBufferException {
        try {
            workQueue.add(target);
        } catch (ClosedException ce) {
            throw ce;
        } catch (ThreadBufferException tbe) {
            throw tbe;
        }
    }

    /**
     * Closes the Thread Pool. This method does the following.
     * <br>1) Stops the worker threads by calling setStopped() on each workerThread.
     * <br>2) Closes the request buffer.
     * XbhEv[܂B̃\bh͈ȉ܂B
     * P)J҂ꂼworkerThreadsetStopped ()ĂԂƂɂĎʂXgbvB
     * Q)NGXgEobt@[܂B
     */
    public void close() {
        stopThreads();
        workQueue.close();
    }

    /**
     * Closes the Thread Pool. This method does the following.
     * <br>1) Stops the worker threads by calling setStopped() on each workerThread.
     * <br>2) Closes the request buffer.
     * XbhEv[܂B̃\bh͈ȉ܂B
     * P)J҂ꂼworkerThreadsetStopped ()ĂԂƂɂĎʂXgbvB
     * Q)NGXgEobt@[܂B
     * @param waitTime ҂Ԃw肵܂
     * @return waitCountԂ܂
     */
    public int close(int waitTime) {
        this.close();

        int sleepTime = 1000;
        int waitCount = 0;
        int i = 0;
        for (; sleepTime * i < waitTime; i++) {
            if (workQueue.requestEmpty()){
                break;
            }
            
            try {
                Thread.sleep(sleepTime);
            } catch (InterruptedException interruptedexception) {
                /* empty */
            }
        }

        for (; sleepTime * i < waitTime; i++) {
            for (waitCount = 0; waitCount < threadPool.length; waitCount++) {
                if (threadPool[waitCount].getWaitStatus()
                    == WorkerThread.AN_WAIT){
                    break;
                }
            }
            if (waitCount >= threadPool.length){
                break;
            }
            
            try {
                Thread.sleep(sleepTime);
            } catch (InterruptedException interruptedexception) {
                /* empty */
            }
            //            System.out.println("close Wait waitCount = " + waitCount);
        }
        return waitCount;
    }

    /**
     * Stops the worker threads by calling setStopped() on each workerThread.
     * ꂼworkerThreadsetStopped ()ĂԂƂɂă[J[Xbh
     * ~B
     */
    private void stopThreads() {
        for (int i = 0; i < threadPool.length; i++) {
            threadPool[i].setStopped();
        }
    }

    /**
     * For Debug info.
     */
    public void printStats() {
        System.out.println("Thread Usage ");
        for (int i = 0; i < threadPool.length; i++) {
            System.out.println(threadPool[i].toString());
        }
    }
}
