package org.itscool.stylist.tag;

import java.io.IOException;

/**
 * [gvf킷Html^O
 * @author kano
 * @version 1.00A 2006/08/09 VK쐬
 */
public class HtmlRootTag extends HtmlTag{
	/**
	 * XMLwb_
	 */
	private String xml="";
	/**
	 * GR[hw
	 */
	private String encode;
	/**
	 * DTD
	 */
	private String dtd="";
	
	public HtmlRootTag(String encode){
		this.encode = encode;
	}
	
	/**
	 * HTML̃m[hString`Ŏ擾܂
	 * @param int floor m[h̊Kw
	 * @param String tab KwTAB
	 * @return HTML̃m[h
	*/
	public String toString(int floor, String tab){
		String line = System.getProperty("line.separator");
		StringBuffer sb = new StringBuffer();
		
		if(xml != null){
			sb.append(xml).append(line);
		}
		if(dtd != null){
			sb.append(dtd).append(line);
		}
		if( this.size() > 0 ){
			sb.append(super.toString(floor, tab));
		}
		return sb.toString();
	}
	
	/**
	 * DTD擾܂
	 * @return DTD
	 */
	public String getDtd() {
		return dtd;
	}
	
	/**
	 * DTDZbg܂
	 * @param dtd DTD
	 */
	public void setDtd(String dtd) {
		this.dtd = dtd;
	}
	
	/**
	 * XMLwb_擾܂
	 * @return XMLwb_
	 */
	public String getXml() {
		return xml;
	}
	
	/**
	 * XMLwb_Zbg܂
	 * @param xml XMLwb_
	 */
	public void setXml(String xml) throws IOException{
		int encStartPos = xml.indexOf("encoding=\"");
		if( encStartPos < 0 ){
			throw new IOException("No defined encoding to xml tag.");
		}
		String stack = xml.substring(encStartPos+("encoding=\"").length());
		int encEndPos = stack.indexOf("\"");
		if( encEndPos < 0 ){
			throw new IOException("Can't convert encoding to xml tag.");
		}
		String encode = stack.substring(0, encEndPos);
		this.setEncode(encode);
		this.xml = xml;
	}
	
	/**
	 * GR[hw擾܂
	 * @return GR[hw
	 */
	public String getEncode() {
		return encode;
	}
	
	/**
	 * GR[hwZbg܂
	 * @param encode GR[hw
	 */
	public void setEncode(String encode) {
		this.encode = encode;
	}
}
