package org.itscool.weber.action;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.itscool.commons.bean.InitParamMap;
import org.itscool.commons.request.GeneralForm;
import org.itscool.commons.request.UploadFile;
import org.w3c.dom.Document;


/**
 * Action.execute()bvNX
 * file name : ActionBucket.java <BR>
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
*/
public class ActionBucket {
	/** T[ubgCX^X */
	private FrontServlet lnkServlet;
	
    /** HttpServletRequestCX^X */
    private HttpServletRequest request;
    
    /** HttpServletResponseCX^X */
    private HttpServletResponse response;
    
    /** NGXgp[^ۗLIuWFNg */
    private Object form;
    
    /** ANV錠Xg */
    private HashMap roles;
    
    /**
     * T[ubgReLXgRealPath擾܂
     * @param path ΃pX
     * @return T[ubgReLXgRealPathԂ܂
     */
    public String getRealPath(String path){
    	ServletContext context = lnkServlet.getServletContext();
        path = context.getRealPath(path);
        return path;
    }
    
    /**
     * NG[擾܂
     * @return NG[
     */
    public String getQueryString(){
        return request.getQueryString();
    }
    
	/**
	 * FrontServletCX^X擾܂
	 * @return FrontServletCX^X
	 */
	public FrontServlet getServlet() {
		return lnkServlet;
	}

	/**
	 * FrontServletCX^XZbg܂
	 * @param servlet FrontServletCX^X
	 */
	public void setServlet(FrontServlet servlet) {
		this.lnkServlet = servlet;
	}
	
//    /**
//     * HttpServletRequestCX^X̎擾
//     * @return HttpServletRequestCX^X
//     */
//    public HttpServletRequest getRequest() {
//        return request;
//    }

//    /**
//     * HttpServletResponseCX^X̎擾
//     * @return HttpServletResponseCX^X
//     */
//    public HttpServletResponse getResponse() {
//        return response;
//    }
    
	/**
	 * p[^Ŏw肳ꂽeLXgo͂܂
	 * @param buff eLXg
	 */
	public void print(String buff) throws IOException{
//		ServletInformation info = ServletInformation.getInstance();
		InitParamMap info = InitParamMap.getInstance();
		String encode = (String) info.getParam("encoding");
		if( encode != null ){
//			response.setCharacterEncoding(encode);
			response.setContentType("text/html; charset=" + encode);
		}
		PrintWriter writer = response.getWriter();
        writer.write(buff);
        writer.flush();
        writer.close();
	}
	
	/**
	 * p[^Ŏw肳ꂽXMLhLgo͂܂
	 * @param document XMLhLg
	 * @throws Exception
	 */
	public void printXml(Document document) throws Exception{
		String version = System.getProperty("java.version");
		if( version.indexOf("1.4") != 0 ){
			System.setProperty("javax.xml.transform.TransformerFactory", 
				"com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
		}
		//application/xml or text/xml
		InitParamMap info = InitParamMap.getInstance();
		String encode = (String) info.getParam("encoding");
		if( encode != null ){
//modify 2006/11/28 kano start
//			response.setCharacterEncoding(encode);
//			response.setContentType("text/html; charset=" + encode);
			response.setContentType("text/xml; charset=" + encode);
//modify 2006/11/28 kano end
		}
		ServletOutputStream out = response.getOutputStream();
		// 쐬hLgHttpServletResponseŕԂ
		TransformerFactory transFactory = TransformerFactory.newInstance();
		Transformer transformer = transFactory.newTransformer();
		if( encode != null && encode.length() > 0 ){
			Properties properties = new Properties();
			properties.setProperty("encoding", encode);
	        transformer.setOutputProperties(properties);
	        transformer.setOutputProperty(OutputKeys.INDENT, "yes");
		}
		DOMSource source = new DOMSource(document);
		StreamResult result = new StreamResult(out); 
		transformer.transform(source, result);
		out.flush();
		out.close();
	}
	
    /**
     * HttpServletRequestCX^X̐ݒ
     * @param request HttpServletRequestCX^X
     */
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    /**
     * HttpServletResponseCX^X̐ݒ
     * @param response HttpServletResponseCX^X
     */
    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }
    
    /**
     * 񃊃Xg擾܂
     * @return roles 񃊃Xg
     */
    public HashMap getRoles() {
        return roles;
    }
    /**
     * 񃊃XgZbg܂
     * @param roles 񃊃Xg
     */
    public void setRoles(HashMap roles) {
        this.roles = roles;
    }
	/**
	 * tH[IuWFNg擾܂
	 * @return tH[IuWFNg
	 */
	public Object getForm() {
		return form;
	}

	/**
	 * tH[IuWFNgZbg܂
	 * @param object tH[IuWFNg
	 */
	public void setForm(Object object) {
		form = object;
	}
	
	/**
	 * NGXgXR[vɃIuWFNgZbg܂
	 * @param key p[^̃L[
	 * @param val p[^ 
	*/
	public void setAttribute(String key, Object val){
		request.setAttribute(key, val);
	}
	
	/**
	 * NGXgXR[vIuWFNg擾܂
	 * @param key p[^̃L[
	 * @return NGXgp[^
	 */
	public Object getAttribute(String key){
		return request.getAttribute(key);
	}
	
	/**
	 * ZbVXR[vɃIuWFNgZbg܂
	 * @param key p[^̃L[
	 * @param val p[^ 
	*/
	public void setAttributeFromSession(String key, Object val){
		HttpSession session = request.getSession();
		if (session.isNew()) {
			//ZbV^CAEg̒lbŎw
			InitParamMap info = InitParamMap.getInstance();
			int sessionTimeout = Integer.parseInt(info.getParam("session-timeout"));
		    session.setMaxInactiveInterval(sessionTimeout);
		}

		session.setAttribute(key, val);	
	}
	
	/**
	 * ZbVXR[vIuWFNg擾܂
	 * @param key p[^̃L[
	 * @return NGXgp[^
	 */
	public Object getAttributeFromSession(String key){
		HttpSession session = request.getSession();
		if (session.isNew()) {
			//ZbV^CAEg̒lbŎw
			InitParamMap info = InitParamMap.getInstance();
			int sessionTimeout = Integer.parseInt(info.getParam("session-timeout"));
		    session.setMaxInactiveInterval(sessionTimeout);
		}
		
		return session.getAttribute(key);	
	}
	
	/**
	 * AvP[VXR[vɃIuWFNgZbg܂
	 * @param key p[^̃L[
	 * @param val p[^ 
	*/
	public void setAttributeFromContext(String key, Object val){
		ServletContext context = lnkServlet.getServletContext();
		context.setAttribute(key, val);	
	}

	/**
	 * AvP[VXR[vIuWFNg擾܂
	 * @param key p[^̃L[
	 * @return NGXgp[^
	 */
	public Object getAttributeFromContext(String key){
		ServletContext context = lnkServlet.getServletContext();
		return context.getAttribute(key);	
	}
	
	/**
	 * NGXgXR[vIuWFNg擾܂
	 * @param key p[^̃L[
	 * @return NGXgp[^
	 */
	public void removeAttribute(String key){
		request.removeAttribute(key);
	}
	
	/**
	 * ZbVXR[vIuWFNg擾܂
	 * @param key p[^̃L[
	 * @return NGXgp[^
	 */
	public void removeAttributeFromSession(String key){
		HttpSession session = request.getSession();
		session.removeAttribute(key);	
	}
	
	/**
	 * AvP[VXR[vIuWFNg擾܂
	 * @param key p[^̃L[
	 * @return NGXgp[^
	 */
	public void removeAttributeFromContext(String key){
		ServletContext context = lnkServlet.getServletContext();
		context.removeAttribute(key);	
	}
	
	/**
     * tH[G[̍ē͏
     * NGXgp[^̒lăZbgȂ
     * @param req HttpServletRequestCX^X
     */
	public void setRetryInputParam(GeneralForm generalForm) {
		Set keySet = generalForm.keySet();
        Iterator it = keySet.iterator();

        while( it.hasNext() ){
            String paramName = (String)it.next();
            Object paramValue = generalForm.getParameter(paramName);
            if(paramValue instanceof UploadFile){
                UploadFile file = (UploadFile)paramValue;
                String value = file.getPath() + System.getProperty("file.separator")
                    + file.getFileName();
                request.setAttribute(paramName, value);
            }else{
                request.setAttribute(paramName, paramValue);
            }
        }
	}

	
}
