package org.itscool.weber.tagex;

import java.io.IOException;
import java.util.Calendar;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.util.DateFormatUtil;
import org.itscool.commons.util.JspTagUtil;

/**
 * J_[\R|[lg
 */
public class CalendarTag extends TagSupport {
	/** ^u */
	protected static final String TAB = "    ";
	/** sR[h */
	protected static final String LINE = System.getProperty("line.separator");
	/** J_[CX^X */
	protected String calendar;
	//protected int year;
	//protected int month;
	/** Z̕ */
	protected String celWidth = "10";
	/** Z̍ */
	protected String celHeight= "10";
	/** Zʒu() */
	protected String align="center";
	/** Zʒu(c) */
	protected String valign="center";
	/** wb_[X^C */
	protected String headerStyle = "\"FONT-SIZE:12;BACKGROUND:silver;\"";
	/** f[^X^C */
	protected String dataStyle = "\"FONT-SIZE:12;BACKGROUND:white;\"";
	/** yX^C */
	protected String donichiStyle = "\"FONT-SIZE:12;BACKGROUND:#FF99CC;\"";
	/** jX^C */
	protected String holidayStyle = "\"FONT-SIZE:12;BACKGROUND:#FF99CC;\"";
	/** X^C */
	protected String todayStyle = "\"FONT-SIZE:12;BACKGROUND:#66FF33;\"";
	/** ҏW[h */
	protected boolean enable = false;
	/** T[ubgpX */
	protected String path = "";
	/** NG[ */
	protected String queryString = "";
	/** NG[쐬pp[^ */
	protected String queryParams = "";
	/** XR[v */
	protected String scope;
	/** `NX̎w */
	protected String paintClass;
	
	protected DrawComponent drawObj;
	
	public int doStartTag() throws JspException {
        try {
        	if(paintClass != null && paintClass.length() > 0){
        		drawObj = (DrawComponent)BeanUtil.createInstance(paintClass);
        		drawObj.setAlign(align);
        		drawObj.setCelHeight(celHeight);
        		drawObj.setCelWidth(celWidth);
        		drawObj.setValign(valign);
        		drawObj.setHeaderStyle(headerStyle);
        		drawObj.setDataStyle(dataStyle);
        		drawObj.setDonichiStyle(donichiStyle);
        		drawObj.setHolidayStyle(holidayStyle);
        		drawObj.setTodayStyle(todayStyle);
        		drawObj.init(path, pageContext);
        	}
        	//doInit();
        	render();
        } catch (Exception e) {
            throw new JspException(e.getMessage());
        }
        return SKIP_BODY;
    }
	
	/**
	 * J_[e[u̕`揈s܂
	 * @throws IOException
	 */
	protected void render() throws IOException, JspException{
		Calendar cal = null;
		MonthTable mTable = null;
		if(calendar != null && calendar.length() > 0 ){
			cal = (Calendar)JspTagUtil.findObject(pageContext, calendar, scope);
		}
		//MonthTablȅ
		if(cal == null){
			//cal = Calendar.getInstance();
			mTable = new MonthTable();
		}else{
			int year = cal.get(Calendar.YEAR);
			int month = cal.get(Calendar.MONTH) + 1;
			mTable = new MonthTable(year, month);
		}
		
		StringBuffer sb = new StringBuffer();
		sb.append("<TABLE");
		int height = Integer.parseInt(celHeight);
		int width = Integer.parseInt(celWidth);
		if( height > 0 ){
			sb.append(" HEIGHT=").append( height * 8 + 10);
		}
		if( width > 0 ){
			sb.append(" WIDTH=").append( width * 7 + 10);
		}
		sb.append(" border=1 cellSpacing=0 cellPadding=0 >");
		sb.append(LINE);
		sb.append(createHeader());
		//挎󔒂ŃpfBO
		DateElement date = mTable.getDay(mTable.getYear(), mTable.getMonth(), 1);
		int firstYobi = date.getYobi();
		if(firstYobi != Calendar.SUNDAY){
//			sb.append("<TR HEIGHT=").append(celHeight).append(">");
//			sb.append(LINE);
			cal = DateFormatUtil.getLastMonthWeek(mTable.getYear(), mTable.getMonth());
			for(int i=1; i<firstYobi; i++, cal.add(Calendar.DAY_OF_MONTH, 1)){
				date = mTable.getDay(cal);
				sb.append(createData(mTable, date));
			}
//			for(int j=1; j<date.getYobi(); j++){
//				sb.append(TAB);
//				sb.append("<TD ").append(" STYLE=").append(dataStyle).append(">@</TD>");
//				sb.append(LINE);
//			}
		}
		//̃J_[쐬
		for(int i=0; i<mTable.getMaxday(); i++){
			date = mTable.getDay(mTable.getYear(), mTable.getMonth(), (i+1));
			sb.append(createData(mTable, date));
		}
		//󔒂ŃpfBO
		DateElement lastDay = mTable.getDay(mTable.getYear(), mTable.getMonth(), mTable.getMaxday());
		if(lastDay.getYobi() != Calendar.SATURDAY){
//			for(int i=lastDay.getYobi(); i<Calendar.SATURDAY; i++){
//				sb.append(TAB);
//				sb.append("<TD ").append(" STYLE=").append(dataStyle).append(">@</TD>");
//				sb.append(LINE);
//			}
//			sb.append("</TR>").append(LINE);
			cal = Calendar.getInstance();
			cal.set(Calendar.YEAR, mTable.getYear());
			cal.set(Calendar.MONTH, mTable.getMonth()-1);
			cal.set(Calendar.DAY_OF_MONTH, mTable.getMaxday());
			for(int i=lastDay.getYobi(); i<Calendar.SATURDAY; i++, cal.add(Calendar.DAY_OF_MONTH, 1)){
				date = mTable.getDay(cal);
				sb.append(createData(mTable, date));
			}
			
		}
		sb.append("</TABLE>");
		pageContext.getOut().print(sb.toString());
	}
	
	/**
	 * J_[e[ũwb_쐬
	 * @return J_[e[ũwb_
	 */
	protected String createHeader(){
		StringBuffer sb = new StringBuffer();
		sb.append("<TR HEIGHT=").append(celHeight).append(">");
		sb.append(LINE);
		StringBuffer td = new StringBuffer();
		td.append(TAB);
		td.append("<TD WIDTH=").append(celWidth);
		td.append(" ALIGN=").append("center");
		td.append(" STYLE=").append(headerStyle);
		td.append(">");
		
		sb.append(td.toString()).append("").append("</TD>");
		sb.append(LINE);
		sb.append(td.toString()).append("").append("</TD>");
		sb.append(LINE);
		sb.append(td.toString()).append("").append("</TD>");
		sb.append(LINE);
		sb.append(td.toString()).append("").append("</TD>");
		sb.append(LINE);
		sb.append(td.toString()).append("").append("</TD>");
		sb.append(LINE);
		sb.append(td.toString()).append("").append("</TD>");
		sb.append(LINE);
		sb.append(td.toString()).append("y").append("</TD>");
		sb.append(LINE);
		sb.append("</TR>").append(LINE);
		return sb.toString();
	}
	
	/**
	 * J_[e[u1̃f[^쐬
	 * @param mTable 
	 * @param day 
	 * @return J_[e[u1̃f[^Ԃ
	 */
	protected String createData(MonthTable mTable, DateElement date) throws JspException{
		StringBuffer sb = new StringBuffer();
		
		if( date.getYobi() == Calendar.SUNDAY){
			sb.append("<TR HEIGHT=").append(celHeight).append(">");
			sb.append(LINE);
		}
		
		StringBuffer td = new StringBuffer();
		td.append(TAB);
		td.append("<TD ");
		td.append(" ALIGN=").append(align);
		td.append(" VALIGN=").append(valign);
		if( date.isToday() ){
			td.append(" STYLE=").append(todayStyle);
		}else if( date.isHoliday() ){
			td.append(" STYLE=").append(holidayStyle);
		}else if( date.getYobi() == Calendar.SUNDAY || date.getYobi() == Calendar.SATURDAY ){
			td.append(" STYLE=").append(donichiStyle);
		}else{
			td.append(" STYLE=").append(dataStyle);
		}
		td.append(">");
		
		sb.append(td.toString());
		
		if( enable == true && path != null && path.length() > 0 ){
			sb.append(createHrefData(date));
		}else{
			sb.append(date.getDay());
			//sb.append(doAddCellData(date));
			if( drawObj != null){
				sb.append(drawObj.doPaint(date));
			}
		}
		td.append(LINE).append(TAB);
		sb.append("</TD>");
		sb.append(LINE);
		if( date.getYobi() == Calendar.SATURDAY ){
			sb.append("</TR>").append(LINE);
		}
		return sb.toString();
	}
	
	/**
	 * HREF쐬܂
	 * @param date DateElementCX^X
	 * @return HFREFԂ܂
	 * @throws JspException
	 */
	protected String createHrefData(DateElement date) throws JspException{
		StringBuffer sb = new StringBuffer();
		sb.append(LINE).append(TAB).append(TAB);
		sb.append("<A HREF=\"").append(createPath(date)).append("\"");
		sb.append(">");
		sb.append(date.getDay());
		//sb.append(doAddCellData(date));
		if( drawObj != null){
			sb.append(drawObj.doPaint(date));
		}
		sb.append("</A>");
		return sb.toString();
	}
	
	/**
	 * pX쐬܂
	 * @param date DateElementCX^X
	 * @return pXԂ܂
	 * @throws JspException
	 */
	protected String createPath(DateElement date) throws JspException{
		StringBuffer retPath = new StringBuffer();
		if( path.indexOf("/") != 0 ){
			path += "/";
		}
        HttpServletRequest req = (HttpServletRequest)pageContext.getRequest();
        String queryParamStr = JspTagUtil.createQueryString(pageContext, queryParams, scope);
        String contextPath = req.getContextPath();
        retPath.append(contextPath).append(path);
        if( queryParamStr != null && queryParamStr.length() > 0 ){
        	retPath.append(queryParamStr);
        	retPath.append("&");
        }else{
        	retPath.append("?");
        }
        if( queryString != null && queryString.length() > 0 ){
        	retPath.append(queryString);
        	retPath.append("&");
        }
        retPath.append("year=").append(date.getYear());
		retPath.append("&month=").append(date.getMonth());
		retPath.append("&day=").append(date.getDay());
		if( queryString != null && queryString.length() > 0){
			retPath.append("&").append(queryString);
		}
		return retPath.toString();
	}
	
    public int doEndTag() {
        return EVAL_PAGE;
    }

	public String getAlign() {
		return align;
	}

	public void setAlign(String align) {
		this.align = align;
	}

	public String getCelHeight() {
		return celHeight;
	}

	public void setCelHeight(String celHeight) {
		this.celHeight = celHeight;
	}

	public String getCelWidth() {
		return celWidth;
	}

	public void setCelWidth(String celWidth) {
		this.celWidth = celWidth;
	}

	public String getDataStyle() {
		return dataStyle;
	}

	public void setDataStyle(String dataStyle) {
		this.dataStyle = dataStyle;
	}

	public String getDonichiStyle() {
		return donichiStyle;
	}

	public void setDonichiStyle(String donichiStyle) {
		this.donichiStyle = donichiStyle;
	}

	public boolean isEnable() {
		return enable;
	}

	public void setEnable(boolean enable) {
		this.enable = enable;
	}

	public String getHeaderStyle() {
		return headerStyle;
	}

	public void setHeaderStyle(String headerStyle) {
		this.headerStyle = headerStyle;
	}

	public String getHolidayStyle() {
		return holidayStyle;
	}

	public void setHolidayStyle(String holidayStyle) {
		this.holidayStyle = holidayStyle;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getQueryParams() {
		return queryParams;
	}

	public void setQueryParams(String queryParams) {
		this.queryParams = queryParams;
	}

	public String getQueryString() {
		return queryString;
	}

	public void setQueryString(String queryString) {
		this.queryString = queryString;
	}

	public String getScope() {
		return scope;
	}

	public void setScope(String scope) {
		this.scope = scope;
	}

	public String getTodayStyle() {
		return todayStyle;
	}

	public void setTodayStyle(String todayStyle) {
		this.todayStyle = todayStyle;
	}

	public String getValign() {
		return valign;
	}

	public void setValign(String valign) {
		this.valign = valign;
	}
	public String getCalendar() {
		return calendar;
	}

	public void setCalendar(String calender) {
		this.calendar = calender;
	}
	
	/** 
	 * 1̐l2\L̕ŕԂ 
	 * @param number int
	 * @return String
	 */
	protected String convertStrToNum(int number){
		String ret = String.valueOf(number);;
		if( number < 10 ){
			ret = "0" + ret;
		}
		return ret;
		//return String.valueOf( number );
	}

	public String getPaintClass() {
		return paintClass;
	}

	public void setPaintClass(String drawCellClass) {
		this.paintClass = drawCellClass;
	}
		
}
