package org.itscool.weber.tagex;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;

import org.itscool.commons.util.DateFormatUtil;

/**
 * ʃJ_[ێe[u
 */
public class MonthTable {
	/** DateElementXg */
	private HashMap days = new HashMap();
	/** N */
	private int year;
	/**  */
	private int month;
	/** ő */
	private int maxday;
	
	/**
	 * ʃJ_[e[u쐬܂
	 */
	public MonthTable(){
		Calendar cal = Calendar.getInstance();
		
		this.year = cal.get(Calendar.YEAR);
		this.month = cal.get(Calendar.MONTH) + 1;
		init(year, month);
	}
	
	/**
	 * ʃJ_[e[u쐬܂
	 * @param year N
	 * @param month 
	 */
	public MonthTable(int year, int month){
		init(year, month);
	}
	
	/**
	 * ʃJ_[e[u쐬̂߂̏֐ł
	 * @param year N
	 * @param month 
	 */
	public void init(int year, int month){
		Calendar cal = Calendar.getInstance();
		if( year > 0 ){
			cal.clear();
			cal.set(Calendar.YEAR, year);
			cal.set(Calendar.MONTH, month-1);
			this.year = year;
			this.month = month;
		}else{
			this.year = cal.get(Calendar.YEAR);
			this.month = cal.get(Calendar.MONTH) + 1;
		}
		
		//̓擾
		this.maxday = DateFormatUtil.getMaxDay(cal);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		//挎f[^̍쐬
		int yobi = cal.get(Calendar.DAY_OF_WEEK);
		if( yobi != Calendar.SUNDAY){
			cal.set(Calendar.DAY_OF_WEEK, Calendar.SUNDAY);
			for(int i=Calendar.SUNDAY; i<yobi; i++, cal.add(Calendar.DAY_OF_MONTH, 1)){
				addDay(new DateElement(cal, false));
			}
		}
		//f[^̍쐬
		for(int i=0; i<maxday; i++){
			addDay(new DateElement(cal, false));
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		//jݒ
		initHoliday(getYear(), getMonth());
		//f[^̍쐬
		cal.add(Calendar.DAY_OF_MONTH, -1);
		yobi = cal.get(Calendar.DAY_OF_WEEK);
		if( yobi != Calendar.SATURDAY ){
			for(int i=yobi; i<=(Calendar.SATURDAY); i++, cal.add(Calendar.DAY_OF_MONTH, 1)){
				addDay(new DateElement(cal, false));
			}
		}
		
	}
	
	/**
	 * jZbg܂
	 * @param year N
	 * @param month 
	 */
	public void initHoliday(int year, int month){
		switch(month){
		case 1:
			//
			addDay(new DateElement(year, 1, 1, true));
			//l̓iPQj
			DateElement holiday2 = getHoliday(year, 1, 2, Calendar.MONDAY);
			addDay(holiday2);
			break;
		case 3:
			//t̓
			DateElement holiday3 = getHolidayEx(year, 3, 20.69115);
			addDay(holiday3);
			break;
		case 4:
			addDay(new DateElement(year, 4, 29, true));	//݂ǂ̓
			break;
		case 5:
			addDay(new DateElement(year, 5, 3, true));	//@LO
			addDay(new DateElement(year, 5, 4, true));	//̋x
			addDay(new DateElement(year, 5, 5, true));	//ǂ̓
			break;
		case 7:
			//C̓iVRjj
			DateElement holiday7 = getHoliday(year, 7, 3, Calendar.MONDAY);
			addDay(holiday7);
			break;
		case 9:
			//hV̓iXRjj
			DateElement holiday9 = getHoliday(year, 9, 3, Calendar.MONDAY);
			addDay(holiday9);
			//H̓
			DateElement holiday9_2 = getHolidayEx(year, 9, 23.09);
			addDay(holiday9_2);
			break;
		case 10:
			//̈̓iPOQjj
			DateElement holiday10 = getHoliday(year, 10, 2, Calendar.MONDAY);
			addDay(holiday10);
			break;
		case 11:
			addDay(new DateElement(year, 11, 3, true));	//̓
			addDay(new DateElement(year, 11, 23, true));	//ΘJӂ̓
			break;
		case 12:
			addDay(new DateElement(year, 12, 23, true));	//Vc̒a
			break;
		}
		//Uւx̐ݒ
		for(int i=0; i<31; i++){
			DateElement day = getDay(year, month, i+1);
			if( day == null ) break;
			if( !day.isHoliday() )continue;
			if( day.getYobi() != Calendar.SUNDAY ) continue;
			DateElement monday = getDay(year, month, i+2);
			if( monday == null ) break;
			monday.setHoliday(true);
		}
	}
	
	/**
	 * j擾܂
	 * @param year N
	 * @param month 
	 * @param weekOfMonth ̉Tڂw肵܂
	 * @param youbi j
	 * @return DateElementCX^XԂ܂
	 */
	public static DateElement getHoliday(int year, int month, int weekOfMonth, int youbi){
		Calendar cal = new GregorianCalendar();
		cal.clear();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, month-1);
		//cal.set(Calendar.WEEK_OF_MONTH, weekOfMonth);
		cal.set(Calendar.DAY_OF_WEEK, youbi);
		cal.add(Calendar.WEEK_OF_MONTH, weekOfMonth-1);
		int tmpYear = cal.get(Calendar.YEAR);
		int tmpMonth = cal.get(Calendar.MONDAY) + 1;
		int tmpDay = cal.get(Calendar.DAY_OF_MONTH);
		
		return new DateElement(tmpYear, tmpMonth, tmpDay, true);
	}
	
	/**
	 * HAt̓vZAwj̓t擾܂<BR>
	 * throwDay = 20.69115;	//2000N̑z̏t_ʉߓ<BR>
	 * throwDay = 23.09;	//2000N̑z̏H_ʉߓ<BR>
	 * @param year N
	 * @param month 
	 * @param throwDay t(H)_ʉߓ
	 * @return DateElementCX^XԂ܂
	 */
	public static DateElement getHolidayEx(int year, int month, double throwDay){
		//PNƂ̏t_ʉߓ̈ړ
		double moveQt = (double)((year-2000) * 0.2421904);
		//[Nɂ郊Zbg
		int resetQt = (int)((year-2000) / 4);
		//߂N̏ťvZ
		int day = (int)(throwDay+moveQt-resetQt);
		
		return new DateElement(year, month, day, true);
	}
	
	/**
	 * tZbg܂
	 * @param day DateElementCX^X
	 */
	public void addDay(DateElement day){
		StringBuffer key = new StringBuffer();
		key.append(day.getYear());
		key.append(day.getMonth());
		key.append(day.getDay());
		days.put(key.toString(), day);
	}
	
	/**
	 * t擾܂
	 * @param year N
	 * @param month 
	 * @param day 
	 * @return DateElementCX^X
	 */
	public DateElement getDay(int year, int month, int day){
		StringBuffer key = new StringBuffer();
		key.append(year);
		key.append(month);
		key.append(day);
		DateElement date = (DateElement)days.get(key.toString());
		return date;
	}
	
	/**
	 * t擾܂
	 * @param cal CalendarCX^X
	 * @return DateElementCX^X
	 */
	public DateElement getDay(Calendar cal){
		int tmpYear = cal.get(Calendar.YEAR);
		int tmpMonth = cal.get(Calendar.MONTH)+1;
		int tmpDay = cal.get(Calendar.DAY_OF_MONTH);
		
		DateElement date = getDay(tmpYear, tmpMonth, tmpDay);
		return date;
	}
	
	/**
	 * t񃊃Xg擾܂
	 * @return DateElement̃XgHashMapŎ擾܂
	 */
	public HashMap getDays() {
		return days;
	}
	
	/**
	 * ̍ő擾܂
	 * @return ő
	 */
	public int getMaxday() {
		return maxday;
	}
	
	/**
	 * N擾܂
	 * @return N
	 */
	public int getYear() {
		return year;
	}
	
	/**
	 * NZbg܂
	 * @param year N
	 */
	public void setYear(int year) {
		this.year = year;
	}

	/**
	 * 擾܂
	 * @return 
	 */
	public int getMonth() {
		return month;
	}
	
	/**
	 * Zbg܂
	 * @param month 
	 */
	public void setMonth(int month) {
		this.month = month;
	}
}