package org.itscool.weber.tagex;

import java.util.Calendar;

import org.itscool.commons.util.DateFormatUtil;

/**
 * MonthTableNX̃fobOpCNX 
 */
public class MonthTableMain {
	public static void toDisplay(MonthTable month){
		StringBuffer sb = new StringBuffer();
		DateElement day = month.getDay(month.getYear(), month.getMonth(), 1);
		String sp = "|";
		String line = System.getProperty("line.separator");
		
		sb.append(month.getYear()).append("/");
		sb.append(month.getMonth()).append(line);
		sb.append("---+---+---+---+---+---+---+");
		sb.append(line);
		sb.append("sun|mon|tue|wen|thr|fri|sat|");
		sb.append(line);
		sb.append("---+---+---+---+---+---+---+");
		sb.append(line);
		
		int firstYobi = day.getYobi();
		if(firstYobi != Calendar.SUNDAY){
//			Calendar cal = Calendar.getInstance();
//			cal.set(Calendar.YEAR, month.getYear());
//			cal.set(Calendar.MONTH, month.getMonth()-1);
//			cal.set(Calendar.DAY_OF_MONTH, 1);
//			cal.add(Calendar.DAY_OF_MONTH, -( firstYobi-1 ));
			Calendar cal = DateFormatUtil.getLastMonthWeek(month.getYear(), month.getMonth());
			for(int i=1; i<firstYobi; i++, cal.add(Calendar.DAY_OF_MONTH, 1)){
				day = month.getDay(cal);
				if( day.getDay() < 10 ){
					sb.append(" ");
				}
				sb.append(day.getDay());
				sb.append("-").append(sp);
			}
		}
		for(int i=0; i<month.getMaxday(); i++){
			day = month.getDay(month.getYear(), month.getMonth(), i+1);
			if( day.getDay() < 10 ){
				sb.append(" ");
			}
			sb.append(day.getDay());
			if( day.isHoliday() ){
				sb.append("*").append(sp);
			}else{
				sb.append(" ").append(sp);
			}
			if( day.getYobi() == Calendar.SATURDAY ){
				sb.append(line);
			}
		}
		DateElement lastDay = month.getDay(month.getYear(), month.getMonth(), month.getMaxday());
		if(lastDay.getYobi() != Calendar.SATURDAY){
			Calendar cal = Calendar.getInstance();
			cal.set(Calendar.YEAR, month.getYear());
			cal.set(Calendar.MONTH, month.getMonth()-1);
			cal.set(Calendar.DAY_OF_MONTH, month.getMaxday());
			for(int i=lastDay.getYobi(); i<Calendar.SATURDAY; i++, cal.add(Calendar.DAY_OF_MONTH, 1)){
				day = month.getDay(cal);
				if( day.getDay() < 10 ){
					sb.append(" ");
				}
				sb.append(day.getDay());
				sb.append("+").append(sp);
				//sb.append(space).append(sp);
			}
			sb.append(line);
		}
		sb.append("---+---+---+---+---+---+---+");
		sb.append(line);
		System.out.println( sb.toString() );
	}
	
	public static void main(String[] argv){
		for( int i=0; i<12; i++ ){
			MonthTable month = new MonthTable(2005, (i+1));
			toDisplay(month);
		}
	}
}
