package org.itscool.weber.testcase;

import junit.framework.TestCase;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.weber.action.Action;
import org.itscool.weber.action.Globals;
import org.itscool.weber.user.User;

/**
 * <p>
 * JUnitgWebert[[NpeXgNXł<br/>
 * </p>
 * 
 * <p>
 * WeberTestCaseNX́Aorg.itscool.weber.action.ActionNX
 * pč쐬ꂽANVNXdoExecute()\bh
 * doValidate()\bh̒P̃eXgs߂̒ۃeXgNXł<br/>
 * </p>
 * 
 * <p>
 * ̃NX̓Reiˑł邽߁AJUnitCuJava̎s
 * ΁AP̃eXg̎{\łB<br/>
 * ȉɃeXgP[X̃Tv܂B<br/>
 * </p>
 * 
 * <p>eXgP[X̃Tv<hr></p>
 * <PRE>
 * import org.itscool.weber.testcase.WeberTestCase;
 * 
 * public class TestSampleAction extends WeberTestCase{
 *     public void testDoExecute(){
 *         //NCAg|XgꂽʐtH[
 *         //CX^X𐶐܂
 *         SampleForm form = new SampleForm();
 *         form.setId(1);
 *         form.setName("hogehoge");
 * 
 *         //WeberTestCaseNXɂ́AÖكIuWFNgƂ
 *         //MockActionBucketCX^X񋟂Ă܂B
 *         //̃CX^XɐقǍ쐬tH[CX
 *         //^XZbg܂B
 *         bucket.setForm(form);
 *         
 *         //eXgΏۂƂȂANVCX^X𐶐܂
 *         SampleAction action = new SampleAction();
 * 
 *         //ANVNXdoExecute؂܂
 *         assertDoExecute(action, form, "success");
 *     }
 * 
 *     public void testDoValidate(){
 *         //doValidate()؂ꍇrequestIuWFNgɃp[^
 *         //ZbgȂ΂Ȃ܂B
 *         //̏ꍇ́AMockPostGereralFormCX^Xgp܂B
 *         //WeberTestCaseNXɂ́AÖكIuWFNgƂ
 *         //requestCX^Xgp邱Ƃł܂B
 *         request.addParameter("id", "lȊÕIuWFNgZbg");
 *         
 *         //eXgΏۂƂȂANVCX^X𐶐܂
 *         SampleAction action = new SampleAction();
 * 
 *         //ANVNXdoValidate\bh؂܂
 *         assertValidate(action, "org.itscool.weber.INPUT_ERROR");
 *     }
 * }
 * </PRE>
 * 
 * <p>
 * WeberTestCase𗘗peXgsꍇAʓrJUnitNXCu
 * Kvł
 * </p>
 * 
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2005/08/01
 */
public abstract class WeberTestCase extends TestCase{
	
	protected BeanFactory factory = BeanFactory.getInstance();
    /** 
     * ActionBucket̃bNIuWFNg𐶐
     */
    protected MockActionBucket bucket = new MockActionBucket();
    /**
     * AbstractPostRequest̃bNIuWFNg𐶐
     */
    protected MockGeneralForm request = new MockGeneralForm(); 
    
    protected static AbstractLog log = SimpleLog.getInstance();
	
	static{
		BeanFactory factory = BeanFactory.getInstance();
		try{
        	if(!log.isInit()){
        		log = (AbstractLog)factory.createInstance("Log");
        	}
        }catch(Exception ioe){}
	}
	
    /**
     * ANVdoExecute\bh؂܂B
     * @param action Action ANVIuWFNg
     * @param form Form tH[IuWFNg
     * @param forward ANV̎sʂ̗\l
     */
    public void assertDoExecute(Action action, Object form, String forward){
    	bucket.setForm(form);
    	action.setGeneralForm(request);
    	
    	//doExcecute\bh̃eXg{
        String result = "";
        try{
        	result = action.doExecute(bucket);
        }catch(Exception e){
        	log.error(e.getMessage());
        	fail(e.getMessage());
        }
        assertEquals(forward, result);
    }
    
    /**
     * ANVcheckUserRole\bh؂܂B
     * @param action Action ANVIuWFNg
     * @param form Form tH[IuWFNg
     * @param forward ANV̎sʂ̗\l
     */
    //public void assertValidate(Action action, Object form, String forward){
    public void assertCheckUserRole(Action action, User user, boolean ret){
        //bucket.setForm(form);
    	action.setGeneralForm(request);
    	bucket.setAttributeFromSession(Globals.REQ_PARAM_USER, user);
    	
    	//doExcecute\bh̃eXg{
        try{
        	boolean isUser = action.checkUserRole(bucket);
        	assertEquals(ret, isUser);
        }catch(Exception e){
        	log.error(e.getMessage());
        	fail(e.getMessage());
        }
    }
    
    /**
     * ANVvalidate\bh؂܂B
     * @param action Action ANVIuWFNg
     * @param form Form tH[IuWFNg
     * @param forward ANV̎sʂ̗\l
     */
    //public void assertValidate(Action action, Object form, String forward){
    public void assertValidate(Action action, String forward){
        //bucket.setForm(form);
    	action.setGeneralForm(request);
    	
    	//doExcecute\bh̃eXg{
        try{
        	String ret = action.validate(bucket);
            assertEquals( forward, ret);
        }catch(Exception e){
        	log.error(e.getMessage());
        	fail(e.getMessage());
        }
    }
    
    
//    public static void main(String[] argv) throws Exception{
//    	String rootPath = System.getProperty("user.dir");
//    	String path = rootPath + "/WEB-INF/web.xml";
//    	HashMap map = new HashMap();
//    	WebReader reader = new WebReader();
//    	reader.create(path, map);
//    	
//    	Set set = map.keySet();
//    	Iterator it = set.iterator();
//    	while(it.hasNext()){
//    		Object key = it.next();
//    		String value = (String)map.get(key);
//    		System.out.println(key+"->"+value);
//    	}
//    }
}
