package org.itscool.weber.user;

import java.util.List;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.util.DataInUtil;

/**
 * f[^x[Xɒ`Ă郆[Ue[uɃ[Uo^
 * ׂ̃R}hNXł<p>
 *
 * yR}h̏z<p>
 *
 * java org.itscool.weber.tool.CreateUser |[-c][-d][-l]| [PATH] [ROLE] [USER] <p>
 *
 * yp[^̉z<p>
 *
 * PATH F di-config-framework.xml̃pXw肵܂(K{)<br>
 * -u   F t@CɃ[Uǉ܂<br>
 * -c   F t@CɃ[UVKɍ쐬܂<br>
 *         t@C݂΂͏㏑܂<br>
 *         (w肵Ȃꍇ͒ǉ܂)<br>
 * -d   F w肳ꂽ[U폜܂<br>
 * -l   F t@Cɓo^Ă郆[Üꗗ\܂<br>
 * ROLE F w肵܂(K{)
 * USER F [Uw肵܂(K{)
 * 
 * <p>
 * ̃R}h𗘗p邽߂ɂ͂炩߈ȉ̒`di-config.xml
 * ݒ肵ĂKv܂B<br/>
 * </p>
 * <pre>
 * &lt;bean id="RoleManager" type="org.itscool.weber.user.RoleDbManager" singleton="true"/&gt;
 * </pre>
 * <br/>
 * 
 * <p>
 * ÃNX̓RlNV̎擾org.itscool.commons.TransactionUtilNX
 * gpĂ܂B<br/>
 * TransactionUtilʂɍ쐬邱Ƃ\łAorg.itscool.commons.ConnectionManager
 * NX𗘗p΁A̎ԂȂƂł܂B<br/>
 * </p>
 * 
 * <p>
 * ConnectionManager̓o^di-config.xmlōs܂B<br/>
 * JDBCDataSourcêǂ𗘗p邩Őݒeς܂B
 * </p>
 * 
 * <p>ȉ́AJDBC𗘗pꍇ̐ݒł</p>
 * <pre>
 * &lt;bean id="ConnectionManager" type="org.itscool.commons.connection.OriginalConnectionManager" singleton="true"&gt;
 *   &lt;property name="url" value="jdbc:hsqldb:hsql://localhost"/&gt;
 *   &lt;property name="user" value="sa"/&gt;
 *   &lt;property name="pwd" value=""/&gt;
 *   &lt;property name="drvname" value="org.hsqldb.jdbcDriver"/&gt;    
 *   &lt;property name="timeout" value="300"/&gt;    
 *   &lt;property name="initSize" value="3"/&gt;    
 *   &lt;property name="maxSize" value="10"/&gt;
 *   &lt;property name="mode" value="false"/&gt;    
 *   &lt;property name="showSql" value="false"/&gt;
 * &lt;/bean&gt;
 * </pre><br/>
 * 
 * <p>ȉ́ADataSource𗘗pꍇ̐ݒł</p>
 * <pre>
 * &lt;bean id="ConnectionManager" type="org.itscool.commons.connection.DataSourceManager" singleton="true"&gt;
 *   &lt;property name="dsName" value="java:comp/env/weber-jndi"/&gt;    
 *   &lt;property name="mode" value="false"/&gt;    
 *   &lt;property name="showSql" value="true"/&gt;
 * &lt;/bean&gt; 
 * </pre>
 * 
 * <p>ConnectionManagerC^[tF[Xitscool-commons.jarɊ܂܂Ă܂</p>
 * 
 * <p>
 * [Uf[^x[XŊǗ邽߂ɂ́A炩߈ȉ̃e[u
 * Kv܂<br>
 * </p>
 * 
 * <p>
 * (1) e[uiWEBER_ROLE)
 * <table border="1">
 * <tr>
 * 		<td>tB[h</td>
 * 		<td>^</td>
 * 		<td>l</td>
 * 		<td>K{</td>
 * 		<td>TCY</td>
 * 		<td>L[</td>
 * 		<td>Qƃe[u</td>
 * 		<td>QƃL[</td>
 * </tr>
 * <tr>
 * 		<td>ID</td>
 * 		<td>Integer</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * </tr>
 * <tr>
 * 		<td>NAME</td>
 * 		<td>VARCHAR(CHAR)</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>Cӂ̃TCY(255oCg𐄏)</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * </tr>
 * </table>
 * </p><br/>
 * 
 * <p>
 * (2) [Ue[uiWEBER_USER)
 * <table border="1">
 * <tr>
 * 		<td>tB[h</td>
 * 		<td>^</td>
 * 		<td>l</td>
 * 		<td>K{</td>
 * 		<td>TCY</td>
 * 		<td>L[</td>
 * 		<td>Qƃe[u</td>
 * 		<td>QƃL[</td>
 * </tr>
 * <tr>
 * 		<td>ID</td>
 * 		<td>Integer</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * </tr>
 * <tr>
 * 		<td>NAME</td>
 * 		<td>VARCHAR(CHAR)</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>Cӂ̃TCY(255oCg𐄏)</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * </tr>
 * <tr>
 * 		<td>PASSWORD</td>
 * 		<td>VARCHAR(CHAR)</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>Cӂ̃TCY(255oCg𐄏)</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * 		<td>@</td>
 * </tr>
 * <tr>
 * 		<td>ROLE_ID</td>
 * 		<td>Integer</td>
 * 		<td>@</td>
 * 		<td>true</td>
 * 		<td>@</td>
 * 		<td></td>
 * 		<td>WEBER_ROLE</td>
 * 		<td>ID</td>
 * </tr>
 * </table>
 * </p><br/>
 * 
 * <p>
 * e[uɂWebAvP[Vŗp\ȃ[`܂<br/>
 * [Ue[uɂWebAvP[Vŗp\ȃ[UƃpX[h
 * `܂B<br>
 * </p>
 * 
 * <p>
 * [Ue[uɓo^pX[h͈Í܂B<br/>
 * </p>
 * 
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class CreateUserForDb {
    /** R}hIvVi[U̒ǉj*/
    static final String OPTION_UP = "-u";
    /** R}hIvVi[Ȕ㏑j*/
    static final String OPTION_NEW = "-c";
    /** R}hIvVi[U̍폜j*/
    static final String OPTION_DEL = "-d";
    /** R}hIvVi[UXg̕\j*/
    static final String OPTION_LIST = "-l";
    
    /**
     * CreateUserR}hs܂
     * @param argv R}hC
    */
    public static void main(String[] argv)throws Exception{
        boolean append = true;
        String user ="";
        String role ="";
        String path ="";
        //`FbN
        if( argv.length < 3){
            showParamError();
            return;
        }
        
        //R}hp[^̎擾
        if( argv[0].equals(CreateUserForDb.OPTION_NEW)){
            append = false;
        }
        
        path = argv[1];
        BeanFactory factory = BeanFactory.getInstance();
		factory.create(path);
        ConnectionManager conMgr = (ConnectionManager)factory.createInstance("ConnectionManager");
        conMgr.init();
        
        if( argv[0].equals(CreateUserForDb.OPTION_NEW) ||
            argv[0].equals(CreateUserForDb.OPTION_UP)){
        	role = argv[2];
            user = argv[3];
            createUser(role, user, append);
        }else if( argv[0].equals(CreateUserForDb.OPTION_DEL) ){
        	role = argv[2];
        	user = argv[3];
            deleteUser(role, user);
        }else if( argv[0].equals(CreateUserForDb.OPTION_LIST) ){
            showUserList(path);
        }else{
            showParamError();
            return;
        }
        
        conMgr.destroy();
    }
    
    /**
     * w肳ꂽpXɌǉ܂<br>
     * pX[h͈Í܂<br>
     * Í̌J̓[Ugp܂
     * @param roleName 
     * @param userName [U
     * @param append ǋL[hBfalsȅꍇ͏㏑܂
    */
    public static void createUser(String roleName, String userName, boolean append)
    throws Exception{
        String pwd = DataInUtil.askString("pX[h͂Ă");
        if( !DataInUtil.askString("ēx͂Ă").equals(pwd) ){
            System.out.println("pX[hႢ܂");
            return;
        }
        RoleDbManager roleDbManager = RoleDbManager.getInstance();
        
        if( roleDbManager.add(roleName, userName, pwd) ){
        	TransactionUtil.commitTransaction();
            System.out.println("[U1ǉ܂");
        }else{
        	System.out.println("̃[U͊ɑ݂܂");
        }
    }
    
    /**
     * w肳ꂽpX猠폜܂<br>
     * @param roleName 
     * @param userName [U
    */
    public static void deleteUser(String roleName, String userName)
    throws Exception{
        boolean ret = DataInUtil.askBoolean("[" + userName + "] 폜ĂłH[y/n]", "y");
        if( !ret ){
            System.out.println("𒆎~܂");
            return;
        }
        RoleDbManager roleDbManager = RoleDbManager.getInstance();
        
        roleDbManager.delete(roleName, userName);
        TransactionUtil.commitTransaction();
        System.out.println("[U1폜܂");
    }
    
    /**
     * w肳ꂽpX猠\܂<br>
     * @param path t@C̃pX
    */
    public static void showUserList(String path)
    throws Exception{
        
        UserDao dao = new UserDao();
        List userList = dao.getAllData();
        
        System.out.println("[[Uꗗ]");
        for( int i=0; i<userList.size(); i++ ){
        	User user = (User)userList.get(i);
        	System.out.println(user.getName());
        }
    }
    
    public static void showParamError(){
        System.out.println("R}hp[^Ⴂ܂");
        System.out.println("");
        System.out.println("yR}h̏");
        System.out.println("");
        System.out.println(" java org.itscool.weber.tool.CreateUser " + 
            "|[-u][-c][-d][-l]| [PATH] [USER]");
        System.out.println("");
        System.out.println(" yp[^̉");
        System.out.println("");
        System.out.println("  PATH F t@C̏o͐w肵܂(K{)");
        System.out.println("  -u   F t@CɃ[Uǉ܂");
        System.out.println("  -c   F t@CɃ[UVKɍ쐬܂");
        System.out.println("          t@C݂΂͏㏑܂");
        System.out.println("          (w肵Ȃꍇ͒ǉ܂)");
        System.out.println("  -d   F w肳ꂽ[U폜܂");
        System.out.println("  -l   F t@Cɓo^Ă郆[Üꗗ\܂");
        System.out.println("  USER F [Uw肵܂(K{)");
        System.out.println("");
    }
}
