<?php
// 
// WHLX CMS - whlx_init.php
// 
// 20040330 - 0.00 alpha
// 




include_once  './whlx_utilities.php';
include_once  './whlx_formdata.php';
include_once  './whlx_domxml.php';


define( 'WHLX_XML_FILEMODE', 0766              );    // 
define( 'WHLX_XML_VERSION' , '1.0'             );    // 
define( 'WHLX_INITIALIZER' , './whlx_init.ini' );    // 

$error   =  1;
$message =  'FAILED    : 初期化に失敗しました. ';
$others  =  '';

$result =  WHLX_Initializer    ( $error, $message, $others );
$result =  WHLX_ResponseHeader ( $error, $message, $others );
$output =  WHLX_PostingResponse( $error, $message, $others );
print  $output;

exit;




function  WHLX_Initializer( &$error, &$message, &$others )
{
//	$formclass             =  new WHLX_Formdata();     // class WHLX_Formdata は './whlx_utilities.php' の中で記述されている補助クラスです. 
//	$form                  =  $formclass->form  ();    // Formdata::form()   でスクリプトに送信された フォーム・データ を取得できます. 返値は配列になります. 
//	$header                =  $formclass->header();    // Formdata::header() でスクリプトに送信された HTTPリクエスト   を取得できます. 返値は配列になります. 

	$whlx_initializer_data =  parse_ini_file( WHLX_INITIALIZER, true );
//	$whlx_initializer_data =  parse_ini_file( './whlx_init.ini', true );
//	$whlx_initializer_data =  parse_ini_file( $whlx_initializer_file, true );

	WHLX_Initializer_ListCategories     ( $whlx_initializer_data );
	WHLX_Initializer_ListArticles       ( $whlx_initializer_data );
	WHLX_Initializer_ListComments       ( $whlx_initializer_data );
	WHLX_Initializer_ListTrackbacks     ( $whlx_initializer_data );
	WHLX_Initializer_ListCategoryInitial( $whlx_initializer_data );
	WHLX_Initializer_ListArticleInitial ( $whlx_initializer_data );
	WHLX_Initializer_ListInformations   ( $whlx_initializer_data );
	WHLX_Initializer_ListOthers         ( $whlx_initializer_data );

	$error   =  0;
	$message =  'SUCCEEDED : 初期化に成功しました. ';
	$others  =  '';

	return true;
}


function  WHLX_Initializer_ListCategories     ( $ini )
{
	$dom_root            =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$txt_pi_xslt         =  WHLX_DomXML_RegisterXSLT ( $dom_root, $ini[ 'xslt' ][ 'categories'   ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$dom_whlx            =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_root      , 'whlx'      , '' );    
	$dom_categories      =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_whlx      , 'categories', '' );    
	$dom_mark            =  WHLX_DomXML_CreateComment( $dom_root, $dom_categories, ' mark '         );    
	$dom_item            =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_categories, 'item'      , '' );    

	$title_categories =  'Categories';    

	$dom_whlx ->set_attribute( 'series'  , '0001'            );    
//	$dom_whlx ->set_attribute( 'category', '0001'            );    
	$dom_whlx ->set_attribute( 'title'   , $title_categories );    
	$dom_item ->set_attribute( 'id'      , '0001'                                );    
	$dom_item ->set_attribute( 'resource', $ini[ 'initial_category' ][ 'url'   ] );    
	$dom_item ->set_attribute( 'title'   , $ini[ 'initial_category' ][ 'title' ] );    

	return WHLX_DomXML_Output( $dom_root, $ini[ 'filename' ][ 'categories'   ], 0766 );    
}


function  WHLX_Initializer_ListArticles       ( $ini )
{
	$dom_root            =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$txt_pi_xslt         =  WHLX_DomXML_RegisterXSLT ( $dom_root, $ini[ 'xslt' ][ 'articles'     ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$dom_whlx            =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_root      , 'whlx'      , '' );    
	$dom_articles        =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_whlx      , 'articles  ', '' );    
	$dom_mark            =  WHLX_DomXML_CreateComment( $dom_root, $dom_articles  , ' mark '         );    
	$dom_item            =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_articles  , 'item'      , '' );    

	$title_articles   =  'Articles';    

	$dom_whlx ->set_attribute( 'series'  , '0001'                                );    
//	$dom_whlx ->set_attribute( 'category', '0001'                                );    
	$dom_whlx ->set_attribute( 'title'   , $ini[ 'title' ][ 'articles'   ]       );    
	$dom_item ->set_attribute( 'id'      , '0001'                                );    
	$dom_item ->set_attribute( 'resource', $ini[ 'initial_article'  ][ 'url'   ] );    
	$dom_item ->set_attribute( 'title'   , $ini[ 'initial_article'  ][ 'title' ] );    

	return WHLX_DomXML_Output( $dom_root, $ini[ 'filename' ][ 'articles'     ], 0766 );    
}


function  WHLX_Initializer_ListComments       ( $ini )
{
	$dom_root            =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$txt_pi_xslt         =  WHLX_DomXML_RegisterXSLT ( $dom_root, $ini[ 'xslt' ][ 'comments'     ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$dom_whlx            =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_root      , 'whlx'         , '' );    
	$dom_comments        =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_whlx      , 'comments  '   , '' );    
	$dom_mark            =  WHLX_DomXML_CreateComment( $dom_root, $dom_comments  , ' mark '            );    

	$title_comments   =  'Comments';    

	$dom_whlx ->set_attribute( 'series'  , '0001'                                );    
//	$dom_whlx ->set_attribute( 'category', '0001'                                );    
	$dom_whlx ->set_attribute( 'title'   , $ini[ 'title' ][ 'comments'   ]       );    

	return WHLX_DomXML_Output( $dom_root, $ini[ 'filename' ][ 'comments'     ], 0766 );     
}


function  WHLX_Initializer_ListTrackbacks     ( $ini )
{
	$dom_root            =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$txt_pi_xslt         =  WHLX_DomXML_RegisterXSLT ( $dom_root, $ini[ 'xslt' ][ 'trackbacks'   ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$dom_whlx            =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_root      , 'whlx'         , '' );    
	$dom_trackbacks      =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_whlx      , 'trackbacks'   , '' );    
	$dom_mark            =  WHLX_DomXML_CreateComment( $dom_root, $dom_trackbacks, ' mark '            );    

	$dom_whlx ->set_attribute( 'series'  , '0001'            );    
//	$dom_whlx ->set_attribute( 'category', '0001'            );    
	$dom_whlx ->set_attribute( 'title'   , $ini[ 'title' ][ 'trackbacks' ]       );    

	return WHLX_DomXML_Output( $dom_root, $ini[ 'filename' ][ 'trackbacks'   ], 0766 );     
}


function  WHLX_Initializer_ListCategoryInitial( $ini )
{
	$dom_root            =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$txt_pi_xslt         =  WHLX_DomXML_RegisterXSLT ( $dom_root, $ini[ 'xslt' ][ 'cat_0001'     ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$dom_whlx            =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_root      , 'whlx'         , '' );    
	$dom_category        =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_whlx      , 'category  '   , '' );    
	$dom_mark            =  WHLX_DomXML_CreateComment( $dom_root, $dom_category  , ' mark '            );    
	$dom_item            =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_category  , 'item'         , '' );    

	$dom_whlx ->set_attribute( 'series'  , '0001'                                );    
//	$dom_whlx ->set_attribute( 'category', '0001'                                );    
	$dom_whlx ->set_attribute( 'title'   , $ini[ 'title' ][ 'cat_0001'   ]       );    
	$dom_item ->set_attribute( 'id'      , '0001'                                );    
	$dom_item ->set_attribute( 'resource', $ini[ 'initial_article'  ][ 'url'   ] );    
	$dom_item ->set_attribute( 'title'   , $ini[ 'title' ][ 'art_0001'   ]       );    

	return WHLX_DomXML_Output( $dom_root, $ini[ 'filename' ][ 'cat_0001'     ], 0766 );    
}


function  WHLX_Initializer_ListArticleInitial ( $ini )
{
	$dom_root            =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$txt_pi_xslt         =  WHLX_DomXML_RegisterXSLT ( $dom_root, $ini[ 'xslt' ][ 'art_0001'     ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$dom_whlx            =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_root      , 'whlx'        , ''                                        );    
	$dom_items           =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_whlx      , 'items'       , ''                                        );    
	$dom_item1           =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_items     , 'item'        , ''                                        );    
	$dom_mark            =  WHLX_DomXML_CreateComment( $dom_root, $dom_items     , ' mark '                                                  );    
	$dom_item1_title     =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_item1     , 'title    '   , $ini[ 'initial_article'  ][ 'title'     ] );    
	$dom_item1_url       =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_item1     , 'url      '   , $ini[ 'initial_article'  ][ 'url'       ] );    
	$dom_item1_text      =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_item1     , 'text     '   , $ini[ 'initial_article'  ][ 'text'      ] );    
	$dom_item1_creator   =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_item1     , 'creator  '   , $ini[ 'initial_article'  ][ 'creator'   ] );    
	$dom_item1_date      =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_item1     , 'date     '   , WHLX_DateTimeString()                     );    
	$dom_item1_trackback =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_item1     , 'trackback'   , $ini[ 'initial_article'  ][ 'trackback' ] );    

	$dom_whlx ->set_attribute( 'series'  , '0001'                                );    
	$dom_whlx ->set_attribute( 'category', '0001'                                );    
	$dom_whlx ->set_attribute( 'title'   , $ini[ 'title' ][ 'art_0001'   ]       );    
	$dom_item1->set_attribute( 'id'      , '0001'                                );    

	return WHLX_DomXML_Output( $dom_root, $ini[ 'filename' ][ 'art_0001'     ], 0766 );    
}


function  WHLX_Initializer_ListInformations   ( $ini )
{
	$dom_root            =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$txt_pi_xslt         =  WHLX_DomXML_RegisterXSLT ( $dom_root, $ini[ 'xslt' ][ 'informations' ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$dom_whlx            =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_root, 'whlx'        , '' );    $dom_whlx           ->set_attribute( 'series', '0001' );    $dom_whlx           ->set_attribute( 'title', 'サイトの情報 etc.' );    
	$dom_info            =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_whlx, 'informations', '' );    
	$dom_infotitle       =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_info, 'item'        , '' );    $dom_infotitle      ->set_attribute( 'id',     '0001' );    $dom_infotitle      ->set_attribute( 'title', 'title'             );    $dom_infotitle      ->set_attribute( 'value', $ini[ 'informations'  ][ 'title'       ]  );    
	$dom_infolink        =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_info, 'item'        , '' );    $dom_infolink       ->set_attribute( 'id',     '0002' );    $dom_infolink       ->set_attribute( 'title', 'link'              );    $dom_infolink       ->set_attribute( 'value', $ini[ 'informations'  ][ 'link'        ]  );    
	$dom_infodescription =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_info, 'item'        , '' );    $dom_infodescription->set_attribute( 'id',     '0003' );    $dom_infodescription->set_attribute( 'title', 'description'       );    $dom_infodescription->set_attribute( 'value', $ini[ 'informations'  ][ 'description' ]  );    
	$dom_infodate        =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_info, 'item'        , '' );    $dom_infodate       ->set_attribute( 'id',     '0004' );    $dom_infodate       ->set_attribute( 'title', 'date'              );    $dom_infodate       ->set_attribute( 'value', WHLX_DateTimeString()                     );    
	$dom_infocreator     =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_info, 'item'        , '' );    $dom_infocreator    ->set_attribute( 'id',     '0005' );    $dom_infocreator    ->set_attribute( 'title', 'creator'           );    $dom_infocreator    ->set_attribute( 'value', $ini[ 'informations'  ][ 'creator'     ]  );    
	$dom_infopublisher   =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_info, 'item'        , '' );    $dom_infopublisher  ->set_attribute( 'id',     '0006' );    $dom_infopublisher  ->set_attribute( 'title', 'publisher'         );    $dom_infopublisher  ->set_attribute( 'value', $ini[ 'informations'  ][ 'publisher'   ]  );    
	$dom_inforights      =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_info, 'item'        , '' );    $dom_inforights     ->set_attribute( 'id',     '0007' );    $dom_inforights     ->set_attribute( 'title', 'rights'            );    $dom_inforights     ->set_attribute( 'value', $ini[ 'informations'  ][ 'rights'      ]  );    
	$dom_infolanguage    =  WHLX_DomXML_CreateChild  ( $dom_root, $dom_info, 'item'        , '' );    $dom_infolanguage   ->set_attribute( 'id',     '0008' );    $dom_infolanguage   ->set_attribute( 'title', 'language'          );    $dom_infolanguage   ->set_attribute( 'value', $ini[ 'informations'  ][ 'language'    ]  );    

	return WHLX_DomXML_Output( $dom_root, $ini[ 'filename' ][ 'informations' ], 0766 );    
}

function  WHLX_Initializer_ListOthers    ( $ini )
{
	$contents =  
		'	<contents> '                                                         .  "\r\n".    
		'		<item title="Index"        resource="./index.xml"        /> '.  "\r\n".    
		'		<item title="Recents"      resource="./recents.xml"      /> '.  "\r\n".    
		'		<item title="Excerpts"     resource="./excerpts.xml"     /> '.  "\r\n".    
		'		<item title="Contents"     resource="./contents.xml"     /> '.  "\r\n".    
		'		<item title="Informations" resource="./informations.xml" /> '.  "\r\n".    
		'		<item title="Categories"   resource="./categories.xml"   /> '.  "\r\n".    
		'		<item title="Articles"     resource="./articles.xml"     /> '.  "\r\n".    
		'		<item title="Comments"     resource="./comments.xml"     /> '.  "\r\n".    
		'		<item title="Trackbacks"   resource="./trackbacks.xml"   /> '.  "\r\n".    
	//	'		<item title="HTML"         resource="./html.xml"         /> '.  "\r\n".    
		'		<item title="初期化"       resource="./init.php"         /> '.  "\r\n".    
	//	'		<item title="新規投稿"     resource="./new.php"          /> '.  "\r\n".    
	//	'		<item title="返事"         resource="./tb.php"           /> '.  "\r\n".    
	//	'		<item title="編集"         resource="./edit.php"         /> '.  "\r\n".    
		'	</contents> '                                                        .  "\r\n";    

	$htmlhead =  
		'	<html> '                                                                                          .  "\r\n".    
		'		<base href="http://whlx.sourceforge.jp/whlx/" /> '                                        .  "\r\n".    
		'		<meta http-equiv="Content-Type"        content="application/xhtml+xml; charset=UTF-8" /> '.  "\r\n".    
		'		<meta http-equiv="Content-Language"    content="ja"                                   /> '.  "\r\n".    
		'		<meta http-equiv="Content-Script-Type" content="text/javascript;       charset=UTF-8" /> '.  "\r\n".    
		'		<meta http-equiv="Content-Style-Type"  content="text/css;              charset=UTF-8" /> '.  "\r\n".    
		'		<link rel="stylesheet" type="text/css"              href="./_default.css"     /> '        .  "\r\n".    
		'		<link rel="index"      type="application/xhtml+xml" href="./index.xml"        /> '        .  "\r\n".    
		'		<link rel="contents"   type="application/xhtml+xml" href="./contents.xml"     /> '        .  "\r\n".    
		'		<link rel="appendix"   type="application/xhtml+xml" href="./informations.xml" /> '        .  "\r\n".    
		'		<link rel="copyright"  type="application/xhtml+xml" href="./informations.xml" /> '        .  "\r\n".    
		'	</html> '                                                                                         .  "\r\n";    

	$filedata_index    =  '<?xml version="1.0" encoding="UTF-8" ?> '.  "\r\n".  '<?xml-stylesheet version="1.0" encoding="UTF-8" type="text/xsl" href="./_default.xsl" ?> '.  "\r\n".  '<whlx title="Index">          '.  "\r\n".  '<index />    '.  '</whlx> ';
	$filedata_recents  =  '<?xml version="1.0" encoding="UTF-8" ?> '.  "\r\n".  '<?xml-stylesheet version="1.0" encoding="UTF-8" type="text/xsl" href="./_default.xsl" ?> '.  "\r\n".  '<whlx title="Recent Entries"> '.  "\r\n".  '<recents />  '.  '</whlx> ';
	$filedata_excerpts =  '<?xml version="1.0" encoding="UTF-8" ?> '.  "\r\n".  '<?xml-stylesheet version="1.0" encoding="UTF-8" type="text/xsl" href="./_default.xsl" ?> '.  "\r\n".  '<whlx title="Excerptions">    '.  "\r\n".  '<excerpts /> '.  '</whlx> ';
	$filedata_contents =  '<?xml version="1.0" encoding="UTF-8" ?> '.  "\r\n".  '<?xml-stylesheet version="1.0" encoding="UTF-8" type="text/xsl" href="./_default.xsl" ?> '.  "\r\n".  '<whlx title="Contents">       '.  "\r\n".  $contents      .  '</whlx> ';
	$filedata_html     =  '<?xml version="1.0" encoding="UTF-8" ?> '.  "\r\n".  '<?xml-stylesheet version="1.0" encoding="UTF-8" type="text/xsl" href="./_default.xsl" ?> '.  "\r\n".  '<whlx title="HTML Headers">   '.  "\r\n".  $htmlhead      .  '</whlx> ';
	WHLX_FileOutput( $filedata_index   , '../whlx/index.xml'   , 0766 );
	WHLX_FileOutput( $filedata_recents , '../whlx/recents.xml' , 0766 );
	WHLX_FileOutput( $filedata_excerpts, '../whlx/excerpts.xml', 0766 );
	WHLX_FileOutput( $filedata_contents, '../whlx/contents.xml', 0766 );
	WHLX_FileOutput( $filedata_html    , '../whlx/html.xml'    , 0766 );
}




?>
