<?xml            version="1.0" encoding="UTF-8" ?> 

<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"> 
	<xsl:output method="xml" indent="yes" encoding="UTF-8" media-type="application/xhtml+xml" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" /> 

	<xsl:template match="/"> 
		<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" dir="ltr"> 
			<head> 
				<title> <xsl:value-of select="/response/others/title" /> </title> 
				<base href="http://whlx.sourceforge.jp/whlx/script/" /> 
				<meta http-equiv="Content-Type"        content="application/xhtml+xml; charset=UTF-8" /> 
				<meta http-equiv="Content-Language"    content="ja"                                   /> 
				<meta http-equiv="Content-Script-Type" content="text/javascript;       charset=UTF-8" /> 
				<meta http-equiv="Content-Style-Type"  content="text/css;              charset=UTF-8" /> 
				<link rel="stylesheet" type="text/css" href="./_script.css" /> 
				<link rel="stylesheet" type="text/css" href="../_default.css" /> 
			</head> 

			<body class="whlx_base"> 
				<div class="whlx_head"> 
<!-- head --> 
<h1> <xsl:value-of select="/response/others/title" /> </h1> 
<!-- head --> 
				</div> 
				<div class="whlx_body"> 
					<div class="whlx_main"> 
<!-- main --> 
<xsl:apply-templates select="/response         " /> 
<!-- main --> 
					</div> 
					<div class="whlx_menu"> 
<!-- menu --> 
<!-- menu --> 
					</div> 
				</div> 
				<div class="whlx_foot"> 
<!-- foot --> 
<!-- foot --> 
				</div> 
			</body> 
		</html> 
	</xsl:template> 




	<xsl:template match="/response"> 
		<div class="note_head"> 
			<a href="../index.xml" class="note_fwrd"> Index                                            </a> 
		</div> 
		<div class="note_body"> 
			<div class="resp_base"> 
				<h2> スクリプト実行結果 </h2> 
				<h3  class="resp_head"> <xsl:copy-of  select="./error  /text() | ./error  /* | ./error  /@* " /> ( 1:エラー, 0:成功 ) </h3>  
				<div class="resp_body"> <xsl:copy-of  select="./message/text() | ./message/* | ./message/@* " />                      </div> 
			</div> 
			<xsl:apply-templates select="/response/others/form  " /> 
			<xsl:apply-templates select="/response/others/result" /> 
		</div> 
	</xsl:template> 




	<!-- form レスポンス --> 
	<xsl:template match="/response/others/form  "> 
		<xsl:apply-templates select="./profile  " /> 
		<xsl:apply-templates select="./tb_id    " /> 
		<xsl:apply-templates select="./comment  " /> 

		<form class="post_base" action="{./action}" method="post" accept="text/plain" accept-charset="UTF-8" enctype="application/x-www-form-urlencoded" lang="ja"> 
			<h2> フォーム </h2> 
			<xsl:apply-templates select="./title    " /> 
			<xsl:apply-templates select="./url      " /> 
			<xsl:apply-templates select="./text     " /> 
			<xsl:apply-templates select="./style_br " /> 
			<xsl:apply-templates select="./style_tg " /> 
			<xsl:apply-templates select="./excerpt  " /> 
			<xsl:apply-templates select="./ping     " /> 
			<xsl:apply-templates select="./creator  " /> 
			<xsl:apply-templates select="./name     " /> 
			<xsl:apply-templates select="./date     " /> 
			<xsl:apply-templates select="./trackback" /> 
			<xsl:apply-templates select="./category " /> 
			<xsl:apply-templates select="./@password" /> 
			<label class="post_label"> Submit <input class="post_input" type="submit" value="{./action}" /> </label> <br /> 
		</form> 
	</xsl:template> 

	<!-- form 変数取得系 --> 
	<xsl:template match="/response/others/form/profile  "> </xsl:template> 
	<xsl:template match="/response/others/form/tb_id    "> </xsl:template> 
	<xsl:template match="/response/others/form/comment  "> </xsl:template> 

	<!-- form 項目入力系 --> 
	<xsl:template match="/response/others/form/@password"> <label class="post_label"> Password  <input    class="post_input" type="password"       name="password"  value=""                  />                         </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/title    "> <label class="post_label"> Title     <input    class="post_input" type="text"           name="title"     value="{text() | * | @*}" />                         </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/url      "> <label class="post_label"> URL       <input    class="post_input" type="text"           name="url"       value="{text() | * | @*}" />                         </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/text     "> <label class="post_label"> Text      <textarea class="post_input" rows="10" wrap="off"  name="text"      ><xsl:copy-of select="text() | * | @*" /></textarea> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/excerpt  "> <label class="post_label"> Excerpt   <textarea class="post_input" rows="10" wrap="off"  name="excerpt"   ><xsl:copy-of select="text() | * | @*" /></textarea> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/ping     "> <label class="post_label"> Ping      <textarea class="post_input" rows="4"  wrap="off"  name="ping"      ><xsl:copy-of select="text() | * | @*" /></textarea> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/creator  "> <label class="post_label"> Creator   <input    class="post_input" type="text"           name="creator"   value="{text() | * | @*}" />                         </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/name     "> <label class="post_label"> Name      <input    class="post_input" type="text"           name="blog_name" value="{text() | * | @*}" />                         </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/date     "> <label class="post_label"> Date      <xsl:copy-of select="text() | * | @*" />                                                                                 </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/trackback"> <label class="post_label"> Trackback <input    class="post_input" type="text"           name="trackback" value="{text() | * | @*}" />                         </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/style_br "> <label class="post_label"> CR/LF     <input    class="post_input" type="checkbox"       name="style_br"  value="true"              />                         </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/style_tg "> <label class="post_label"> XHTML TAG <input    class="post_input" type="checkbox"       name="style_tg"  value="true"              />                         </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/category "> <label class="post_label"> Category  <input    class="post_input" type="text"           name="category"  value="0001"              />                         </label> <br /> </xsl:template> 




	<xsl:template match="/response/others/result"> 
		<div class="main_base"> 
			<xsl:apply-templates select="./item/title    " /> 
			<xsl:apply-templates select="./item/text     " /> 
			<xsl:apply-templates select="./item/excerpt  " /> 
			<xsl:apply-templates select="./item/creator  " /> 
			<xsl:apply-templates select="./item/name     " /> 
			<xsl:apply-templates select="./item/date     " /> 
			<xsl:apply-templates select="./item/trackback" /> 
		</div> 
	</xsl:template> 

	<xsl:template match="/response/others/result/item/title    "> <h2  class="main_head"> <xsl:value-of select="* | @* | text()" /> </h2>  </xsl:template> 
	<xsl:template match="/response/others/result/item/text     "> <div class="main_body"> <xsl:copy-of  select="* | @* | text()" /> </div> </xsl:template> 
	<xsl:template match="/response/others/result/item/excerpt  "> <div class="main_body"> <xsl:copy-of  select="* | @* | text()" /> </div> </xsl:template> 
	<xsl:template match="/response/others/result/item/creator  "> <h3  class="main_foot"> <xsl:value-of select="* | @* | text()" /> </h3>  </xsl:template> 
	<xsl:template match="/response/others/result/item/name     "> <h3  class="main_foot"> <xsl:value-of select="* | @* | text()" /> </h3>  </xsl:template> 
	<xsl:template match="/response/others/result/item/date     "> <h3  class="main_foot"> <xsl:value-of select="* | @* | text()" /> </h3>  </xsl:template> 
	<xsl:template match="/response/others/result/item/trackback"> <h3  class="main_foot"> <xsl:value-of select="* | @* | text()" /> </h3>  </xsl:template> 




</xsl:stylesheet> 

