#!/usr/bin/perl
###
chdir("..");
###
require "package/ReadForm.pl";
require "package/ReadTheme.pl";
require "package/UrlUnescape.pl";
require "package/PrintHtml.pl";
require "package/InsertString.pl";
###
&WriteConfig if($FORM{'CMD'}==1);
require "package/ReadConfig.pl";
&ReadTheme::read('default');
require "package/ReadLang.pl";
&UserUpdate if($FORM{'CMD'}==2);
require "package/ReadUser.pl";
&PingUpdate if($FORM{'CMD'}==5);
&PrintHtml::ExitScript(&UserList) if($FORM{'CMD'}==2 || $FORM{'CMD'}==3);
&PrintHtml::ExitScript(&PingList) if($FORM{'CMD'}==4 || $FORM{'CMD'}==5);
&PrintHtml::ExitScript(&MakeHtml);
###
sub WriteConfig{
	open(FILE,"+>admin/config.dat");
	print FILE "WikiName=".&UrlUnescape::unescape($FORM{'WikiName'})."\n";
	print FILE "Description=".&UrlUnescape::unescape($FORM{'Description'})."\n";
	print FILE "Keywords=".&UrlUnescape::unescape($FORM{'Keywords'})."\n";
	print FILE "DefaultTheme=".&UrlUnescape::unescape($FORM{'DefaultTheme'})."\n";
	print FILE "LangagePack=".&UrlUnescape::unescape($FORM{'LangagePack'})."\n";
	print FILE "AdminIP=".$FORM{'AdminIP'}."\n";
	print FILE "SiteTop=".&UrlUnescape::unescape($FORM{'SiteTop'})."\n";
	print FILE "WritePermission=".($FORM{'WritePermission'}||0)."\n";
	close(FILE);
}
###
sub MakeHtml{
	my($i,$result,@wp,$wp,$dt,$lp);
	@wp=('all','admin','user');
	for($i=0;$i<=$#wp;$i++){
		if($i==$CONFIG{'WritePermission'}){
			$wp.="<option value='$i' selected>$wp[$i]</option>";
		}else{
			$wp.="<option value='$i'>$wp[$i]</option>";
		}
	}
	opendir(DIR,"theme");
	foreach(readdir(DIR)){
		next if(!/^([^\.]+)$/);
		if($1 eq $CONFIG{'DefaultTheme'}){
			$dt.="<option value='$1' selected>$1</option>";
		}else{
			$dt.="<option value='$1'>$1</option>";
		}
	}
	close(DIR);
	opendir(DIR,"language");
	foreach(readdir(DIR)){
		next if(!/^([^\.]+)\.dat$/);
		if($1 eq $CONFIG{'LangagePack'}){
			$lp.="<option value='$1' selected>$1</option>";
		}else{
			$lp.="<option value='$1'>$1</option>";
		}
	}
	close(DIR);
	$result=&InsertString::insert($ReadTheme::Theme{'admin0'},$CONFIG{'WikiName'},$CONFIG{'Description'},$CONFIG{'Keywords'},$dt,$CONFIG{'AdminIP'},$wp,$lp,$CONFIG{'SiteTop'});
	$result=&InsertString::insert($ReadTheme::Theme{'admin'},$result);
	return($result);
}
###
sub PingList{
	my($result,$list);
	open(FILE,"admin/upingsv.dat");
	$list=join('',<FILE>);
	close(FILE);
	$result=&InsertString::insert($ReadTheme::Theme{'admin3'},$list);
	$result=&InsertString::insert($ReadTheme::Theme{'admin'},$result);
	return($result);
}
###
sub PingUpdate{
	my($list);
	$list=&UrlUnescape::unescape($FORM{'ServerList'});
	$list=~s/\r//g;
	open(FILE,"+>admin/upingsv.dat");
	print FILE $list;
	close(FILE);
}
###
sub UserList{
	my($result,$list);
	foreach(keys(%ReadUser::User)){
		$list.=&InsertString::insert($ReadTheme::Theme{'admin2'},$_,$ReadUser::User{$_});
	}
	$result=&InsertString::insert($ReadTheme::Theme{'admin1'},$list);
	$result=&InsertString::insert($ReadTheme::Theme{'admin'},$result);
	return($result);
}
###
sub UserUpdate{
	my($i);
	open(FILE,"+>admin/userlist.dat");
	for($i=0;$i<=$#{$FORM->{'name'}};$i++){
		next if(${$FORM->{'name'}}[$i] eq '' || ${$FORM->{'pass'}}[$i] eq '' || ${$FORM->{'name'}}[$i]=~/\W/ || ${$FORM->{'pass'}}[$i]=~/\W/);
		print FILE ${$FORM->{'name'}}[$i].'='.${$FORM->{'pass'}}[$i]."\n";
	}
	close(FILE);
}
###

