#!/usr/bin/perl
###
require "package/ReadConfig.pl";
require "package/PrintHtml.pl";
require "package/Base64.pl";
require "package/ReadTheme.pl";
require "package/InsertString.pl";
require "package/UrlUnescape.pl";

require "package/PageInfo.pl";

require "package/CheckPermission.pl";
require "package/HtmlDelete.pl";
require "package/UpdatePing.pl";
###
&PrintHtml::ExitScript(&XmlRpc,'application/xml') if($ENV{'QUERY_STRING'} eq 'xml-rpc');
&PrintHtml::ExitScript(&Trackback,'application/xml') if($ENV{'QUERY_STRING'}=~/^trackback=/);
###
###
sub Trackback{
	my($file,$res,@mes,$error,$result,$title,$excerpt,$url,$blog);
	require "package/ReadForm.pl";
	($file)=$ENV{'QUERY_STRING'}=~/^trackback=(.+)/;
	open(FILE,"api/trackback/response.dat");
	$res=join('',<FILE>);
	close(FILE);
	$error=0;
	$title=&UrlUnescape::unescape($FORM{'title'});
	$excerpt=&UrlUnescape::unescape($FORM{'excerpt'});
	$url=&UrlUnescape::unescape($FORM{'url'});
	$blog=&UrlUnescape::unescape($FORM{'blog_name'});
	$title=~s/</&lt;/g;
	$title=~s/>/&gt;/g;
	$excerpt=~s/</&lt;/g;
	$excerpt=~s/>/&gt;/g;
	$url=~s/</&lt;/g;
	$url=~s/>/&gt;/g;
	$blog=~s/</&lt;/g;
	$blog=~s/>/&gt;/g;
	return(&InsertString::insert($res,1)) if(!-e("trackback/$file.dat"));
	return(&InsertString::insert($res,1)) if($title eq '' || length($title)>255);
	return(&InsertString::insert($res,1)) if($excerpt eq '' || length($excerpt)>255);
	return(&InsertString::insert($res,1)) if($url eq '' || length($url)>255);
	return(&InsertString::insert($res,1)) if($blog eq '' || length($blog)>255);
	open(FILE,">>trackback/$file.dat");
	print FILE "$title>$excerpt>$url>$blog>".time.">\n";
	close(FILE);
	&HtmlDelete::delete;
	return(&InsertString::insert($res,0));
}
###
sub XmlRpc{
	my($result,$pd,$methodName,$faultCode,@faultString,$top,$frame,$list,@string,@config,$params,@param,@file,$file,@line,$i);
	$faultString[2]="Can't this action";
	$faultString[3]="Required item is not input";
	$top="http://$ENV{'SERVER_NAME'}$ENV{'REQUEST_URI'}";
	$top=~s/[^\/]+$//;
	read(STDIN,$pd,$ENV{'CONTENT_LENGTH'});
	$pd=~s/\r//g;
	$pd=~s/\n/&#10;/g;
	($methodName)=$pd=~/<methodName>(.+)<\/methodName>/;
	open(FILE,"api/xml-rpc/$methodName/list.dat");
	$list=join('',<FILE>);
	close(FILE);
	open(FILE,"api/xml-rpc/$methodName/frame.dat");
	$frame=join('',<FILE>);
	close(FILE);
	($params)=$pd=~/<params>(.+)<\/params>/;
	$params=~s/<\/param>/<\/param>\n/g;
	while($params=~/<param>[^<]*<value>[^<]*<[^>]+>(.+)<\/[^>]+>[^<]*<\/value>[^<]*<\/param>/g){
		push(@param,$1);
	}
	if($methodName eq 'blogger.getUsersBlogs'){
		opendir(DIR,'blog');
		foreach(readdir(DIR)){
			next if(!/^(.+)\.dat$/);
			$string[2]=$1;
			open(FILE,"blog/$string[2].dat");
			@config=split(/</,<FILE>);
			close(FILE);
			$string[1]=$config[0]||$config[7];
			if($string[1] eq ''){
				$string[1]=&Base64::decode($string[2]);
				$string[1]=~s/&/&amp;/g;
				$string[1]=~s/</&lt;/g;
				$string[1]=~s/>/&gt;/g;
			}
			$string[0]=$config[1]||$config[6];
			$string[0]="html/$PAGEINFO{'theme'}/$string[0].html" if($string[0] ne '');
			$string[0]=$top.$string[0];
			$result.=&InsertString::insert($list,@string);
		}
		closedir(DIR);
		$result=&InsertString::insert($frame,$result);
	}elsif($methodName eq 'mt.getCategoryList'){
		opendir(DIR,'blog');
		foreach(readdir(DIR)){
			next if(!/^(.+)\.dat$/);
			$string[0]=$1;
			open(FILE,"blog/$string[0].dat");
			@config=split(/</,<FILE>);
			close(FILE);
			$string[1]=$config[7]||$config[0];
			if($string[1] eq ''){
				$string[1]=&Base64::decode($string[0]);
				$string[1]=~s/&/&amp;/g;
				$string[1]=~s/</&lt;/g;
				$string[1]=~s/>/&gt;/g;
			}
			$result.=&InsertString::insert($list,@string);
		}
		closedir(DIR);
		$result=&InsertString::insert($frame,$result);
	}elsif($methodName eq 'metaWeblog.getRecentPosts'){
		open(FILE,"blog/$param[0].dat");
		@file=<FILE>;
		close(FILE);
		shift(@file);
		$#file=$param[3]-1 if($param[3]>0);
		for($i=0;$i<20 && $file[$i];$i++){
			@line=split(/[<\n]/,$file[$i]);
			$string[0]=$line[1];
			$string[1]=&Base64::decode($line[1]);
			$string[1]=~s/&/&amp;/g;
			$string[1]=~s/</&lt;/g;
			$string[1]=~s/>/&gt;/g;
			$string[2]=$top.$string[0].".html";
			$string[3]=$string[2];
			@time=localtime($line[0]);
			$time[5]+=1900;
			$time[4]++;
			for(0..4){
				$time[$_]="0$time[$_]" if(length($time[$_])==1);
			}
			$string[4]="$time[5]-$time[4]-$time[3]";
			$string[5]=$param[1];
			open(FILE,"data/$string[0].dat");
			$file=join('',<FILE>);
			close(FILE);
			$file=~s/\r//g;
			($string[6])=$file=~/\n&blogcontent\(+\n(.+)\n\)+;\n/s;
			$string[6]=$1 if($string[6]=~/^&nc\(+\n(.+)\n\)+$/s);
			$string[6]=~s/&/&amp;/g;
			$string[6]=~s/"/&quot;/g;
			$string[6]=~s/</&lt;/g;
			$string[6]=~s/>/&gt;/g;
			$result.=&InsertString::insert($list,@string);
		}
		closedir(DIR);
		$result=&InsertString::insert($frame,$result);
	}elsif($methodName eq 'metaWeblog.newPost'){
		while($param[3]=~/<name>([^<]+)<\/name>[^<]*<value>[^<]*<[^>]+>([^<]+)<\/[^>]+>[^<]*<\/value>/g){
			$param[4]=$2 if($1 eq 'title');
			$param[5]=$2 if($1 eq 'description');
		}
		$faultCode=&WriteBlog($param[0],$param[1],$param[2],$param[4],$param[5]);
		$result=&InsertString::insert($frame,$PAGEINFO{'fileid'}) if(!$faultCode);
	}elsif($methodName eq 'metaWeblog.editPost'){
		while($param[3]=~/<name>([^<]+)<\/name>[^<]*<value>[^<]*<[^>]+>([^<]+)<\/[^>]+>[^<]*<\/value>/g){
			$param[4]=$2 if($1 eq 'title');
			$param[5]=$2 if($1 eq 'description');
		}
		$faultCode=&WriteBlog("",$param[1],$param[2],$param[4],$param[5],$param[0]);
		$result=&InsertString::insert($frame,"true") if(!$faultCode);
	}elsif($methodName eq 'mt.getPostCategories'){
		open(FILE,"data/$param[0].dat");
		while(<FILE>){
			if(/^&blogheader\((.+)\);/){
				$string[0]=$1;
				$string[1]=&Base64::encode($string[0]);
				$result.=&InsertString::insert($list,@string);
				$result=&InsertString::insert($frame,$result);
				last;
			}
		}
		close(FILE);
		$faultCode=6 if(!$result);
	}elsif($methodName eq 'mt.publishPost'){
		$result=&InsertString::insert($frame);
	}elsif($methodName eq 'mt.setPostCategories'){
		$result=&InsertString::insert($frame);
	}else{
		$faultCode=1;
	}
	if($faultCode){
		open(FILE,"+>log/XmlRpc.log");
		print FILE $pd;
		close(FILE);
		open(FILE,"api/xml-rpc/fault.dat");
		$frame=join('',<FILE>);
		close(FILE);
		$faultString[1]="Unknown method - $methodName" if($faultCode==1);
		$result.=&InsertString::insert($frame,$faultString[$faultCode],$faultCode);
	}
	open(FILE,"+>log/XmlRpc.log");
	print FILE "$pd\n\n$result";
	close(FILE);
	return($result);
}
###
sub WriteBlog{
	my($c,$log,$pid,$category,$subject,$content,$file,$num,$data,$user,$pass);
	($log,$user,$pass,$subject,$content,$pid)=@_;
	return(2) if(!&CheckPermission::write($user,$pass));
	if($pid){
		open(FILE,"data/$pid.dat");
		while(<FILE>){
			if(/^&blogheader\((.+)\);/){
				$log=&Base64::encode($1);
				last;
			}
		}
		close(FILE);
		return(5) if(!$log);
	}
	return(4) if(!-f("blog/$log.dat"));
	return(3) if($content eq '' || $subject eq '');
	unlink("data/$pid.dat") if($pid);
	&ReadTheme::read($PAGEINFO{'theme'});
	$category=&Base64::decode($log);
	$category=~s/\\/&#92;/g;
	$category=~s/,/\\,/g;
	$category=~s/\)/\\\)/g;
	$content=~s/&lt;/</g;
	$content=~s/&gt;/>/g;
	$content=~s/&quot;/"/g;
	$content=~s/&#10;/\n/g;
	$content=~s/&amp;/&/g;
	$c=1;
	while($content=~/\){$c}/){
		$c++;
	}
	$content="&nc"."("x$c."\n$content\n".")"x$c if($content=~/</);
	$c=1;
	while($content=~/\){$c}/){
		$c++;
	}
	$content="("x$c."\n$content\n".")"x$c;
	$file=&Base64::encode($subject);
	if(-e("data/$file.dat")){
		$num=1;
		while(-e("data/$file.$num.dat")){
			$num++;
		}
		$file.=".$num";
	}
	$data=&InsertString::insert($ReadTheme::Theme{"blog-page"},$category,$file,$content);
	open(FILE,"+>data/$file.dat");
	print FILE $data;
	close(FILE);
	&HtmlDelete::delete;
	require "plugin/blogitem.pl";
	$PAGEINFO{'fileid'}=$file;
	$Api=1;
	&blogitem::blogitem(&Base64::decode($log));
	&UpdatePing::PingPost;
	return;
}
###

