#!/usr/bin/perl
###
require "package/ReadConfig.pl";
require "package/ApInfo.pl";
require "package/ReadForm.pl";
require "package/PrintRedirect.pl";
require "package/PrintHtml.pl";
require "package/Base64.pl";
require "package/ReadTheme.pl";
require "package/ReadLang.pl";
require "package/InsertString.pl";
require "package/WikiEngine.pl";
require "package/UrlUnescape.pl";
require "package/ReadPlugin.pl";

require "package/CheckPermission.pl";
require "package/PageInfo.pl";
###
$include::Include=1;
&PrintHtml::ExitScript(&MakeXml,'application/xml');
###
sub MakeXml{
	my($type,$max,$result,$i,$title,$file,@time,$name,$url,$path,$theme,$content);
	$type=$FORM{'TYPE'};
	die('error') if($type=~/\// || $type=~/^\./);
	$max=$FORM{'MAX'} || 20;
	$theme=$FORM{'THEME'} || $CONFIG{'DefaultTheme'} || 'default';
	$path=$ENV{'SCRIPT_NAME'};
	$path=~s/[^\/]*$//;
	&ReadTheme::read($type,1);
	opendir(DIR,'data');
	foreach(sort {-M("data/$a") <=> -M("data/$b")} readdir(DIR)){
		if(/^(.+)\.dat$/){
			$file=$1;
			$name=&Base64::decode($file);
			$name=~s/&/&amp;/g;
			$name=~s/</&lt;/g;
			$name=~s/>/&gt;/g;
			@time=localtime((stat("data/$file.dat"))[9]);
			$time[5]+=1900;
			$time[4]++;
			$time[0]="0".$time[0] if(length($time[0])==1);
			$time[1]="0".$time[1] if(length($time[1])==1);
			$time[2]="0".$time[2] if(length($time[2])==1);
			$time[3]="0".$time[3] if(length($time[3])==1);
			$time[4]="0".$time[4] if(length($time[4])==1);
			$url="http://$ENV{'SERVER_NAME'}${path}html/${theme}/${file}.html";
			$content="";
			if($ReadTheme::Theme{'content'} ne '' && $i<100){
				open(FILE,"data/$file.dat");
				$content=join('',<FILE>);
				close(FILE);
				$content=&WikiEngine::wiki($content);
				$content=~s/&/&amp;/g;
				$content=~s/<[^>]*>/ /g;
				$content=~s/</ /g;
				$content=~s/>/ /g;
				$content=&InsertString::insert($ReadTheme::Theme{'content'},$content);
			}
			$result.=&InsertString::insert($ReadTheme::Theme{'item'},$url,$file,$name,$time[0],$time[1],$time[2],$time[3],$time[4],$time[5],$content);
			$i++;
			last if($i>=$max);
		}
	}
	closedir(DIR);
	$url="http://$ENV{'SERVER_NAME'}${path}";
	$name=$CONFIG{'WikiName'}||'Wiki';
	$name=~s/&/&amp;/g;
	$name=~s/</&lt;/g;
	$name=~s/>/&gt;/g;
	$result=&InsertString::insert($ReadTheme::Theme{'frame'},$result,$name,$url);
	return($result);
}
###

