/* 
   $Id: main.c,v 1.10 2008/06/09 13:29:01 masahino Exp $
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <X11/X.h>
#include <X11/xpm.h>
#include <X11/Xlib.h>
#include <X11/Xlocale.h>
#include <unistd.h>
#include <string.h>

#include "wmgeneral.h"
#include "uim-helper-wm.h"
#include "pixmaps.h"

#include <uim.h>
#include <uim-helper.h>
#include <uim-im-switcher.h>

#include <iconv.h>

#ifdef MEMCHECK
#include <memcheck.h>
#endif /* MEMCHECK */


/* Prototypes */
void dprintf(const char *fmt, ...);
static void print_usage(void);
static void ParseCMDLine(int argc, char *argv[]);

/*#define DEFAULT_FONT "-shinonome-gothic-medium-r-normal--12-*-*-*-*-*"*/
#define DEFAULT_FONT "-misc-sazanami gothic-medium-r-normal--12-*-*-*-*-*"
#define SUBSTITUTE_FONT "-misc-fixed-medium-r-normal--12-*-*-*-*-*"

Bool use_fontset;
Bool debug;
Bool graphical_mode;

/* Global variable */
Display	*display;
Window   Root;
GC       NormalGC;
XpmIcon  wmgen;
XpmIcon  text_pixmap;
XFontSet fontset;


void dprintf(const char *fmt, ...)
{
     va_list ap;
     if (debug) {
	  va_start(ap, fmt);
	  vfprintf(stderr, fmt, ap);
	  va_end(ap);
/*		fprintf(stderr, "\n");*/
     }
}
static void print_usage(void)
{
     printf("\nwmuim version: %s\n", VERSION);
     printf("usage:\n");
     printf("wmuim [-d] [-p uim-pref name] [-s uim-im-switcher name]\n");
}

static void ParseCMDLine(int argc, char *argv[])
{
     int i;

     for (i = 1; i < argc; i++) {
	  if (strcmp(argv[i], "-d") == 0) {
	       debug = True;
#ifdef USE_IMLIB2
	  } else if (strcmp(argv[i], "-g") == 0) {
	       graphical_mode = True;
#endif /* USE_IMLIB2 */
	  } else if (strcmp(argv[i], "-p") == 0) { 
	       /* uim-prep-xxx */
	       i++;
	       if (wmuim_set_uim_pref_cmd(argv[i]) < 0) {
		    print_usage();
		    exit(1);
	       }
	  } else if (strcmp(argv[i], "-s") == 0) {
	       /* uim-im-switcher-xxx */
	       i++;
	       if (wmuim_set_uim_im_switcher_cmd(argv[i]) < 0) {
		    print_usage();
		    exit(1);
	       }
	  } else {
	       print_usage();
	       exit(1);
	  }
     }
}

static void check_xevent()
{
     XEvent	event;
     int tmpButtonStatus;

     while (XPending(display)) {
	  XNextEvent(display, &event);
	  switch (event.type) {
	  case Expose:
	       RedrawWindow();
	       break;
	  case ButtonPress:
	       tmpButtonStatus = 
		    CheckMouseRegion(event.xbutton.x,
				     event.xbutton.y);
	       dprintf("ButtonPress %d,%d(%d, %d)\n", 
		       tmpButtonStatus, event.xbutton.button,
		       event.xbutton.x, event.xbutton.y);
	       wmuim_button_press(tmpButtonStatus, 
				  event.xbutton.button);
	       break;
	  case ButtonRelease:
	       break;
	  case EnterNotify:
	       tmpButtonStatus =
		    CheckMouseRegion(event.xbutton.x,
				     event.xbutton.y);
	       dprintf("EntryNotift %d(%d, %d)\n", 
		       tmpButtonStatus,
		       event.xbutton.x, event.xbutton.y);
	       /*dockitem_show_tooltips(dock->mouse_region[s].item);*/
	       break;
	  case LeaveNotify:
	       dprintf("LeaveNotift \n");
	       /*dockitem_hide_tooltips(dock);*/
	       break;
	  default:
	       break;
	  }
     }
}

int main(int argc, char **argv)
{
     char **miss, *def;
     int n_miss; 
     int white, black;
     int uim_fd;
     char *loc;

     uim_fd = wmuim_init();
     debug = False;
     graphical_mode = False;

     ParseCMDLine(argc, argv);

     /* taken from twm.c */
     loc = setlocale(LC_ALL, "");
     if (!loc || !strcmp(loc, "C") || !strcmp(loc, "POSIX") ||
	 !XSupportsLocale()) {
	  use_fontset = False;
     } else {
	  use_fontset = True;
     }

     if (graphical_mode == True) {
	  dprintf("graphical_mode = %d\n", graphical_mode);
	  openXwindow(argc, argv, xpm_master_graphical, NULL,
		      xpm_mask_width, xpm_mask_height);
     } else {
	  openXwindow(argc, argv, xpm_master, xpm_mask_bits,
		      xpm_mask_width, xpm_mask_height);
     }
     GetXPM(&text_pixmap, text_xpm);
     fontset = XCreateFontSet(display, 
			      DEFAULT_FONT
			      , &miss, &n_miss, &def); 
     if (fontset == NULL)
	  fontset = XCreateFontSet(display, 
				   SUBSTITUTE_FONT
				   , &miss, &n_miss, &def); 
     white = WhitePixel(display, 0); 
     black = BlackPixel(display, 0); 
     XSetForeground(display, NormalGC, white);
     XSetBackground(display, NormalGC, black);

/*
  font_uni = XLoadQueryFont(display, FONT_NAME_UNI);
  XSetFont(display, NormalGC, font_uni->fid);
*/
     dprintf("%s\n", XBaseFontNameListOfFontSet(fontset));
     dprintf("%s\n", XLocaleOfFontSet(fontset));

     /* graphical mode */
     if (graphical_mode == True) {
	  wmuim_set_icon_buttons();
     }
     wmuim_set_mouse_region();

     /* Loop Forever */
     while (1) {
	  wmuim_periodic_function();
	  check_xevent();
	  usleep(10000);
     }

     /* we should never get here */
     return (0);
}


/*

  prop_label_update
  charset=UTF-8
  S       直接入力


  prop_list_update
  charset=UTF-8
  branch  S       直接入力
  leaf    え      ひらがな        ひらがなモード  prop_skk_hiragana
  leaf    エ      カタカナ        カタカナモード  prop_skk_katakana
  leaf    エ       半角カタカナ    半角カタカナモード      prop_skk_hankana
  leaf    S       直接入力        直接入力モード  prop_skk_latin  *
  leaf    Ｓ      全角英数        全角英数モード  prop_skk_wide_latin


  focus_out


  focus_in

*/

