#include <stdio.h>
#include <config.h>
#ifdef USE_IMLIB2
#include <Imlib2.h>
#endif
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "wmgeneral.h"
#include "wm-imlib.h"

extern Display *display;
extern XpmIcon wmgen;

void drawImage(int dest_x, int dest_y, int width, int height,
			     const char *file_name)
{
#ifdef USE_IMLIB2
	Imlib_Image image;
	Visual  *vis;

	vis   = DefaultVisual(display, DefaultScreen(display));

	imlib_context_set_display(display);
	imlib_context_set_visual(vis);

	imlib_context_set_drawable(wmgen.pixmap);

	image = imlib_load_image(file_name);

	imlib_context_set_image(image);
	dprintf("dest_x = %d, desty = %d\n", dest_x, dest_y);
	imlib_render_image_on_drawable_at_size(dest_x, dest_y,
					       width, height);
#endif /* USE_IMLIB2 */
}


