/* File: birth.c */

/* Purpose: create a player character */

/*
 * Copyright (c) 1989 James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 */

#include "angband.h"

/*
 * How often the autoroller will update the display and pause
 * to check for user interuptions.
 * Bigger values will make the autoroller faster, but slower
 * system may have problems because the user can't stop the
 * autoroller for this number of rolls.
 */
#define AUTOROLLER_STEP		5431L

/*
 * Maximum number of tries for selection of a proper quest monster
 */
#define MAX_TRIES 100

/*
 * A structure to hold "rolled" information
 */
typedef struct hist_type hist_type;

/*
 * Player background information
 */
struct hist_type
{
	cptr info;			    /* Textual History */

	byte roll;			    /* Frequency of this entry */
	byte chart;			    /* Chart index */
	byte next;			    /* Next chart index */
	byte bonus;			    /* Social Class Bonus + 50 */
};

/*
 * Background information (see below)
 *
 * Chart progression by race:
 *   Human         -->  1 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Half-Elf      -->  4 -->  1 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Elf/High-Elf  -->  7 -->  8 -->  9 --> 54 --> 55 --> 56
 *   Hobbit        --> 10 --> 11 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Gnome         --> 13 --> 14 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Dwarf         --> 16 --> 17 --> 18 --> 57 --> 58 --> 59 --> 60 --> 61
 *   Half-Orc      --> 19 --> 20 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Half-Troll    --> 22 --> 23 --> 62 --> 63 --> 64 --> 65 --> 66
 *
 * XXX XXX XXX This table *must* be correct or drastic errors may occur!
 */
static hist_type bg[] =
{
#ifdef JP
	{"ʢλҤǧΤ餵Ƥޤ",			 10, 2, 3, 25},
	{"ʢλҤǤǧΤϤƤޤ",			 20, 2, 3, 35},
	{"ͤλҶΤΰͤǤ",			 95, 2, 3, 45},
	{"ĹҤǤ",						100, 2, 3, 50},
#else
	{"You are the illegitimate and unacknowledged child ",   10, 1, 2, 25},
	{"You are the illegitimate but acknowledged child ",     20, 1, 2, 35},
	{"You are one of several children ",                     95, 1, 2, 45},
	{"You are the first child ",                            100, 1, 2, 50},
#endif

#ifdef JP
	{"ʤۤ",					 40, 1, 2, 65},
	{"ʤϼ",					 65, 1, 2, 80},
	{"ʤĮͤ",					 80, 1, 2, 90},
	{"ʤϿͤ",					 90, 1, 2,105},
	{"ʤεΤ",				 96, 1, 2,120},
	{"ʤϺ٤εμ̤߰뵮²",				 100, 1, 2,130},
#else
	{"of a Serf.  ",                                         40, 2, 3, 65},
	{"of a Yeoman.  ",                                       65, 2, 3, 80},
	{"of a Townsman.  ",                                     80, 2, 3, 90},
	{"of a Guildsman.  ",                                    90, 2, 3, 105},
	{"of a Landed Knight.  ",                                96, 2, 3, 120},
	{"of a Noble Family in the Courts of Chaos.  ",         100, 2, 3, 130},
#endif

#ifdef JP
	{"ʤϰȤΤʪǤ",				 20, 3,50, 20},
	{"ʤϰȤθؤǤ",				 80, 3,50, 55},
	{"ʤϲ²ڤˤƤޤ",			100, 3,50, 60},
#else
	{"You are the black sheep of the family.  ",             20, 3, 50, 20},
	{"You are a credit to the family.  ",                    80, 3, 50, 55},
	{"You are a well liked child.  ",                       100, 3, 50, 60},
#endif

#ifdef JP
	{"ʤϥƥ²ΥդǤ",		 40, 4, 1, 50},
	{"ʤϥƥ²ΥդǤ",		 75, 4, 1, 55},
	{"ʤϥΥɡ²ΥդǤ",		 90, 4, 1, 55},
	{"ʤϥΥɡ²ΥդǤ",		 95, 4, 1, 60},
	{"ʤϥ䡼²ΥդǤ",		 98, 4, 1, 65},
	{"ʤϥ䡼²ΥդǤ",				100, 4, 1, 70},
#else
	{"Your mother was of the Teleri.  ",			 40, 4, 1, 50},
	{"Your father was of the Teleri.  ",			 75, 4, 1, 55},
	{"Your mother was of the Noldor.  ",		 	 90, 4, 1, 55},
	{"Your father was of the Noldor.  ",		 	 95, 4, 1, 60},
	{"Your mother was of the Vanyar.  ",			 98, 4, 1, 65},
	{"Your father was of the Vanyar.  ",			100, 4, 1, 70},
#endif

#ifdef JP
	{"ͤλҶΤΰͤǤ",			 60, 9, 54, 50},
	{"γǤ",					100, 9, 54, 55},
#else
	{"You are one of several children ",			 60, 7, 8, 50},
	{"You are the only child ",					100, 7, 8, 55},
#endif

#ifdef JP
	{"ʤϥƥ²Υդ",				 75, 7, 8, 50},
	{"ʤϥΥɡ²Υդ",			 95, 7, 8, 55},
	{"ʤϥ䡼²Υդ",			100, 7, 8, 60},
#else
	{"of a Teleri ",						 75, 8, 9, 50},
	{"of a Noldor ",						 95, 8, 9, 55},
	{"of a Vanyar ",						100, 8, 9, 60},
#endif

#ifdef JP
	{"󥸥㡼",					 40, 8,9, 80},
	{"㡼",					 70, 8,9, 90},
	{"Τ",						 87, 8,9,110},
	{"ᥤ",						 95, 8,9,125},
	{"Ҥ",						 99, 8,9,140},
	{"",						100, 8,9,145},
#else
	{"Ranger.  ",						 40, 9, 54, 80},
	{"Archer.  ",						 70, 9, 54, 90},
	{"Warrior.  ",						 87, 9, 54, 110},
	{"Mage.  ",							 95, 9, 54, 125},
	{"Prince.  ",						 99, 9, 54, 140},
	{"King.  ",							100, 9, 54, 145},
#endif

#ifdef JP
	{"ۥӥåȤβͤλҶΤΰͤǤ",		 85,11,3, 45},
	{"ۥӥåȤΰγǤ",			        100,11,3, 55},
#else
	{"You are one of several children of a Hobbit ",		 85, 10, 11, 45},
	{"You are the only child of a Hobbit ",		        100, 10, 11, 55},
#endif

#ifdef JP
	{"ʤϸ𿩤",							 20,10,11, 55},
	{"ʤϵ򲰤Ź",						 30,10,11, 80},
	{"ʤʴ",							 40,10,11, 90},
	{"ʤϲȼ",							 50,10,11,100},
	{"ʤͤ",							 80,10,11,110},
	{"ʤΤ",							 95,10,11,115},
	{"ʤϥᥤ",							 99,10,11,125},
	{"ʤϰ²Ĺ",							100,10,11,140},
#else
	{"Bum.  ",							 20, 11, 3, 55},
	{"Tavern Owner.  ",						 30, 11, 3, 80},
	{"Miller.  ",						 40, 11, 3, 90},
	{"Home Owner.  ",						 50, 11, 3, 100},
	{"Burglar.  ",						 80, 11, 3, 110},
	{"Warrior.  ",						 95, 11, 3, 115},
	{"Mage.  ",							 99, 11, 3, 125},
	{"Clan Elder.  ",						100, 11, 3, 140},
#endif

#ifdef JP
	{"ΡδͤλҶΤΰͤǤ",		 85,14,3, 45},
	{"ΡΰγǤ",			        100,14,3, 55},
#else
	{"You are one of several children of a Gnome ",		 85, 13, 14, 45},
	{"You are the only child of a Gnome ",			100, 13, 14, 55},
#endif

#ifdef JP
	{"ʤʪ𤤤",							 20,13,14, 55},
	{"ʤϥۥ᤭",							 50,13,14, 70},
	{"ʤϤĴҼԤ",							 75,13,14, 85},
	{"ʤΤ",							 95,13,14,100},
	{"ʤϥᥤ",							100,13,14,125},
#else
	{"Beggar.  ",						 20, 14, 3, 55},
	{"Braggart.  ",						 50, 14, 3, 70},
	{"Prankster.  ",						 75, 14, 3, 85},
	{"Warrior.  ",						 95, 14, 3, 100},
	{"Mage.  ",							100, 14, 3, 125},
#endif

#ifdef JP
	{"ɥդͤλҶΤΰͤǤ",		 25,17,18, 40},
	{"ɥդΰγǤ",			        100,17,18, 50},
#else
	{"You are one of two children of a Dwarven ",		 25, 16, 17, 40},
	{"You are the only child of a Dwarven ",			100, 16, 17, 50},
#endif

#ifdef JP
	{"ʤť",							 10,16,17, 60},
	{"ʤϴ֤",							 25,16,17, 75},
	{"ʤϹפ",							 75,16,17, 90},
	{"ʤΤ",							 90,16,17,110},
	{"ʤϥץ꡼Ȥ",					 99,16,17,130},
	{"ʤϲ",							100,16,17,150},
#else
	{"Thief.  ",						 10, 17, 18, 60},
	{"Prison Guard.  ",						 25, 17, 18, 75},
	{"Miner.  ",						 75, 17, 18, 90},
	{"Warrior.  ",						 90, 17, 18, 110},
	{"Priest.  ",						 99, 17, 18, 130},
	{"King.  ",							100, 17, 18, 150},
#endif

#ifdef JP
	{"ʤϰȤΤʪǤ",						 15,18,57,10},
	{"ʤϰȤθؤǤ",						 85,18,57, 50},
	{"ʤϲ²ڤˤƤޤ",				100,18,57, 55},
#else
	{"You are the black sheep of the family.  ",		 15, 18, 57, 10},
	{"You are a credit to the family.  ",			 85, 18, 57, 50},
	{"You are a well liked child.  ",				100, 18, 57, 55},
#endif

#ifdef JP
	{"ʤϥǤ̩ˤƤޤ",	 25,19,20, 25},
	{"ʤϥǤ̩ˤƤޤ",	100,19,20, 25},
#else
	{"Your mother was an Orc, but it is unacknowledged.  ",	 25, 19, 20, 25},
	{"Your father was an Orc, but it is unacknowledged.  ",	100, 19, 20, 25},
#endif

#ifdef JP
	{"ʤܻۤҤǤ",						 40,20, 3, 65},
	{"ʤϼܻҤǤ",						 65,20, 3, 80},
	{"ʤĮܻͤҤǤ",						 80,20, 3, 90},
	{"ʤϿܻͤҤǤ",						 90,20, 3,105},
	{"ʤεΤܻҤǤ",					 96,20, 3,120},
	{"ʤϼ̤߰뵮²ܻҤǤ",				 99,20, 3,130},
	{"ʤϲȤηԤܻҤǤ",			100,20, 3,140},
#else
	{"You are the adopted child ",				100, 20, 2, 50},
#endif

#ifdef JP
	{"ʤƶȥ",				 30,22,23, 20},
	{"ʤƶȥ",				 60,22,23, 25},
	{"ʤϵ֥ȥ",					 75,22,23, 30},
	{"ʤϵ֥ȥ",					 90,22,23, 35},
	{"ʤϿȥ",					 95,22,23, 40},
	{"ʤϿȥ",					100,22,23, 45},
#else
	{"Your mother was a Cave-Troll ",				 30, 22, 23, 20},
	{"Your father was a Cave-Troll ",				 60, 22, 23, 25},
	{"Your mother was a Hill-Troll ",				 75, 22, 23, 30},
	{"Your father was a Hill-Troll ",				 90, 22, 23, 35},
	{"Your mother was a Water-Troll ",				 95, 22, 23, 40},
	{"Your father was a Water-Troll ",				100, 22, 23, 45},
#endif

#ifdef JP
	{"åǤ",							  5,23,62, 60},
	{"ΤǤ",							 95,23,62, 55},
	{"ѻդǤ",							 99,23,62, 65},
	{"²ĹǤ",						100,23,62, 80},
#else
	{"Cook.  ",							  5, 23, 62, 60},
	{"Warrior.  ",						 95, 23, 62, 55},
	{"Shaman.  ",						 99, 23, 62, 65},
	{"Clan Chief.  ",						100, 23, 62, 80},
#endif

#ifdef JP
	{"ʤϿ֥饦Ʒ",				 20,50,51, 50},
	{"ʤϥ֥饦Ʒ",					 60,50,51, 50},
	{"ʤøƷ",					 70,50,51, 50},
	{"ʤϥ꡼Ʒ",					 80,50,51, 50},
	{"ʤĤƷ",						 90,50,51, 50},
	{"ʤϥ֥롼쥤Ʒ",				100,50,51, 50},
#else
	{"You have dark brown eyes, ",				 20, 50, 51, 50},
	{"You have brown eyes, ",					 60, 50, 51, 50},
	{"You have hazel eyes, ",					 70, 50, 51, 50},
	{"You have green eyes, ",					 80, 50, 51, 50},
	{"You have blue eyes, ",					 90, 50, 51, 50},
	{"You have blue-gray eyes, ",				100, 50, 51, 50},
#endif

#ifdef JP
	{"ʤ餫",							 70,51,52, 50},
	{"Ǥä",							 90,51,52, 50},
	{"뤷",							100,51,52, 50},
#else
	{"straight ",						 70, 51, 52, 50},
	{"wavy ",							 90, 51, 52, 50},
	{"curly ",							100, 51, 52, 50},
#endif

#ifdef JP
	{"ȱ",						 30,52,53, 50},
	{"ȱ",						 70,52,53, 50},
	{"Ȥӿȱ",					 80,52,53, 50},
	{"֤ȱ",						 90,52,53, 50},
	{"֥ɤȱ",				100,52,53, 50},
#else
	{"black hair, ",						 30, 52, 53, 50},
	{"brown hair, ",						 70, 52, 53, 50},
	{"auburn hair, ",						 80, 52, 53, 50},
	{"red hair, ",						 90, 52, 53, 50},
	{"blond hair, ",						100, 52, 53, 50},
#endif

#ifdef JP
	{"ȩ򤷤Ƥޤ",					 10,53, 0, 50},
	{"ȩ򤷤Ƥޤ",					 30,53, 0, 50},
	{"̤ȩ򤷤Ƥޤ",				 80,53, 0, 50},
	{"ȩ򤷤Ƥޤ",					 90,53, 0, 50},
	{"Ʃ̤褦ȩ򤷤Ƥޤ",		100,53, 0, 50},
#else
	{"and a very dark complexion.",				 10, 53, 0, 50},
	{"and a dark complexion.",					 30, 53, 0, 50},
	{"and an average complexion.",				 80, 53, 0, 50},
	{"and a fair complexion.",					 90, 53, 0, 50},
	{"and a very fair complexion.",				100, 53, 0, 50},
#endif

#ifdef JP
	{"ʤ뤤졼Ʒ",					 85,54,55, 50},
	{"ʤ뤤֥롼Ʒ",					 95,54,55, 50},
	{"ʤ뤤꡼Ʒ",					100,54,55, 50},
#else
	{"You have light grey eyes, ",				 85, 54, 55, 50},
	{"You have light blue eyes, ",				 95, 54, 55, 50},
	{"You have light green eyes, ",				100, 54, 55, 50},
#endif

#ifdef JP
	{"ʤ餫",							 75,55,56, 50},
	{"Ǥä",							100,55,56, 50},
#else
	{"straight ",						 75, 55, 56, 50},
	{"wavy ",							100, 55, 56, 50},
#endif

#ifdef JP
	{"ȱȩ򤷤Ƥޤ",				 75,56, 0, 50},
	{"ȱȩ򤷤Ƥޤ",				 85,56, 0, 50},
	{"֥ɤȱȩ򤷤Ƥޤ",				 95,56, 0, 50},
	{"ȱȩ򤷤Ƥޤ",				100,56, 0, 50},
#else
	{"black hair, and a fair complexion.",			 75, 56, 0, 50},
	{"brown hair, and a fair complexion.",			 85, 56, 0, 50},
	{"blond hair, and a fair complexion.",			 95, 56, 0, 50},
	{"silver hair, and a fair complexion.",			100, 56, 0, 50},
#endif

#ifdef JP
	{"ʤϿ֥饦Ʒ",					 99,57,58, 50},
	{"ʤϵ֤Ʒ",					100,57,58, 60},
#else
	{"You have dark brown eyes, ",				 99, 57, 58, 50},
	{"You have glowing red eyes, ",				100, 57, 58, 60},
#endif

#ifdef JP
	{"ʤ餫",							 90,58,59, 50},
	{"Ǥä",							100,58,59, 50},
#else
	{"straight ",						 90, 58, 59, 50},
	{"wavy ",							100, 58, 59, 50},
#endif

#ifdef JP
	{"ȱ",						 75,59,60, 50},
	{"ȱ",						100,59,60, 50},
#else
	{"black hair, ",						 75, 59, 60, 50},
	{"brown hair, ",						100, 59, 60, 50},
#endif

#ifdef JP
	{" 30cm ۤɤΥҥ",						 25,60,61, 50},
	{" 60cm ۤɤΥҥ",						 60,60,61, 51},
	{" 90cm ۤɤΥҥ",					 90,60,61, 53},
	{" 1m20cm ۤɤΥҥ ",						100,60,61, 55},
#else
	{"a one foot beard, ",					 25, 60, 61, 50},
	{"a two foot beard, ",					 60, 60, 61, 51},
	{"a three foot beard, ",					 90, 60, 61, 53},
	{"a four foot beard, ",					100, 60, 61, 55},
#endif

#ifdef JP
	{"ȩ򤷤Ƥޤ",					100,61, 0, 50},
#else
	{"and a dark complexion.",					100, 61, 0, 50},
#endif

#ifdef JP
	{"ʤϥ٥ȤĤ褦ФƷ",					 60,62,63, 50},
	{"ʤϱʪΤ褦ʲƷ",					 85,62,63, 50},
	{"ʤĤäƷ",				 99,62,63, 50},
	{"ʤϵ֤Ʒ",					100,62,63, 55},
#else
	{"You have slime green eyes, ",				 60, 62, 63, 50},
	{"You have puke yellow eyes, ",				 85, 62, 63, 50},
	{"You have blue-bloodshot eyes, ",				 99, 62, 63, 50},
	{"You have glowing red eyes, ",				100, 62, 63, 55},
#endif

#ifdef JP
	{"餷",							 33,63,64, 50},
	{"Է",							 66,63,64, 50},
	{"餮ä",							100,63,64, 50},
#else
	{"dirty ",							 33, 63, 64, 50},
	{"mangy ",							 66, 63, 64, 50},
	{"oily ",							100, 63, 64, 50},
#endif

#ifdef JP
	{"參ͤȱ",					 33,64,65, 50},
	{"뤤ֿȱ",						 66,64,65, 50},
	{"Ť翧ȱ",						100,64,65, 50},
#else
	{"sea-weed green hair, ",					 33, 64, 65, 50},
	{"bright red hair, ",					 66, 64, 65, 50},
	{"dark purple hair, ",					100, 64, 65, 50},
#endif

#ifdef JP
	{"п",							 25,65,66, 50},
	{"Ĥ",							 50,65,66, 50},
	{"",							 75,65,66, 50},
	{"",							100,65,66, 50},
#else
	{"and green ",						 25, 65, 66, 50},
	{"and blue ",						 50, 65, 66, 50},
	{"and white ",						 75, 65, 66, 50},
	{"and black ",						100, 65, 66, 50},
#endif

#ifdef JP
	{"֥ĥ֥Ĥȩ򤷤Ƥޤ",						 33,66, 0, 50},
	{"֥餱ȩ򤷤Ƥޤ",						 66,66, 0, 50},
	{"ȩ򤷤Ƥޤ",						100,66, 0, 50},
#else
	{"ulcerous skin.",						 33, 66, 0, 50},
	{"scabby skin.",						 66, 66, 0, 50},
	{"leprous skin.",                       100, 66, 0, 50},
#endif

#ifdef JP
	{"ͤλҶΤΰͤǤ",      85, 70, 71, 45},
	{"γǤ",         	 100, 70, 71, 55},

	{"ʤϥդΤ", 50, 69, 70, 60 },
	{"ʤϥդѻΤ", 80, 69, 70, 75 },
	{"ʤϥդε²", 100,  69, 70, 95 },
#else
	{"You are one of several children of a Dark Elven ",      85, 69, 70, 45},
	{"You are the only child of a Dark Elven ",          100, 69, 70, 55},

	{"Warrior.  ", 50, 70, 71, 60 },
	{"Warlock.  ", 80, 70, 71, 75 },
	{"Noble.  ", 100, 70, 71, 95 },
#endif

#ifdef JP
	{"ʤϹƷ", 100, 71, 72, 50},
#else
	{"You have black eyes, ", 100, 71, 72, 50},
#endif

#ifdef JP
	{"ʤ餫",                        70, 72, 73, 50},
	{"Ǥä",                            90, 72, 73, 50},
	{"뤷",                          100, 72, 73, 50},

	{"ȱƤȤƤŤȩ򤷤Ƥޤ", 100, 73, 0, 50 },
#else
	{"straight ",                        70, 72, 73, 50},
	{"wavy ",                            90, 72, 73, 50},
	{"curly ",                          100, 72, 73, 50},

	{"black hair and a very dark complexion.", 100, 73, 0, 50 },
#endif

#ifdef JP
	{"ʤƤϥǤ̩ˤƤޤ", 25, 74, 20, 25},
	{"ʤƤϥǤ̩ˤƤޤ", 100, 74, 20, 25},
#else
	{"Your mother was an Ogre, but it is unacknowledged.  ", 25, 74, 20, 25},
	{"Your father was an Ogre, but it is unacknowledged.  ", 100, 74, 20, 25},
#endif

#ifdef JP
	{"ʤƤϵ֥㥤ȤǤ", 10, 75, 20, 50},
	{"ʤƤϥե㥤ȤǤ", 12, 75, 20, 55},
	{"ʤƤϥեȡ㥤ȤǤ", 20, 75, 20, 60},
	{"ʤƤϥ饦ɡ㥤ȤǤ", 23, 75, 20, 65},
	{"ʤƤϥȡࡦ㥤ȤǤ", 25, 75, 20, 70},
	{"ʤƤϵ֥㥤ȤǤ",  60, 75, 20, 50},
	{"ʤƤϥե㥤ȤǤ",  70, 75, 20, 55},
	{"ʤƤϥեȡ㥤ȤǤ",  80, 75, 20, 60},
	{"ʤƤϥ饦ɡ㥤ȤǤ",  90, 75, 20, 65},
	{"ʤƤϥȡࡦ㥤ȤǤ", 100, 75, 20, 70},
#else
	{"Your mother was a Hill Giant.  ", 10, 75, 20, 50},
	{"Your mother was a Fire Giant.  ", 12, 75, 20, 55},
	{"Your mother was a Frost Giant.  ", 20, 75, 20, 60},
	{"Your mother was a Cloud Giant.  ", 23, 75, 20, 65},
	{"Your mother was a Storm Giant.  ", 25, 75, 20, 70},
	{"Your father was a Hill Giant.  ",  60, 75, 20, 50},
	{"Your father was a Fire Giant.  ",  70, 75, 20, 55},
	{"Your father was a Frost Giant.  ",  80, 75, 20, 60},
	{"Your father was a Cloud Giant.  ",  90, 75, 20, 65},
	{"Your father was a Storm Giant.  ", 100, 75, 20, 70},
#endif

#ifdef JP
	{"ʤƤ̾Τ̥Ǥ", 75, 76, 20, 50 },
	{"ʤƤϥƥߥǤ",        80, 76, 20, 100 },
	{"ʤƤϥΥǤ",     85, 76, 20, 100 },
	{"ʤƤϥΥǤ",      90, 76, 20, 100 },
	{"ʤƤϥꥦǤ",         95, 76, 20, 100 },
	{"ʤƤϥϥڥꥪǤ",      98, 76, 20, 125 },
	{"ʤƤϥΥǤ",       100, 76, 20, 150 },
#else
	{"Your father was an unknown Titan.  ", 75, 76, 20, 50 },
	{"Your mother was Themis.  ",        80, 76, 20, 100 },
	{"Your mother was Mnemosyne.  ",     85, 76, 20, 100 },
	{"Your father was Okeanoas.  ",      90, 76, 20, 100 },
	{"Your father was Crius.  ",         95, 76, 20, 100 },
	{"Your father was Hyperion.  ",      98, 76, 20, 125 },
	{"Your father was Kronos.  ",       100, 76, 20, 150 },
#endif

#ifdef JP
	{"ʤ̾Τ̥ץλ¹Ǥ", 90, 77, 109, 50 },
	{"ʤϥݥե⥹λҶǤ", 98, 77, 109, 80 },
	{"ʤϥΥλҶǤ", 100, 77, 109, 135 },
#else
	{"You are the offspring of an unknown Cyclops.  ", 90, 77, 109, 50 },
	{"You are Polyphemos's child.  ", 98, 77, 109, 80 },
	{"You are Uranos's child.  ", 100, 77, 109, 135 },
#endif

#ifdef JP
	{"ͤλҶΤΰͤǤ", 100, 79, 80, 50 },

	{"ʤϥ֥饦󡦥", 		50, 78, 79, 50 },
	{"ʤϥ֥롼", 		75, 78, 79, 50 },
	{"ʤϥޥ", 		95, 78, 79, 85 },
	{"ʤϥβإܥɡ٤",   100, 78, 79, 120 },
#else
	{"You are one of several children of ", 100, 78, 79, 50 },

	{"a Brown Yeek. ", 50, 79, 80, 50 },
	{"a Blue Yeek.  ", 75, 79, 80, 50 },
	{"a Master Yeek.  ", 95, 79, 80, 85 },
	{"Boldor, the King of the Yeeks.  ", 100, 79, 80, 120 },
#endif

#ifdef JP
	{"ʤĤƷ",    25, 80, 81, 50 },
	{"ʤϸƷ",    50, 80, 81, 50 },
	{"ʤϾʹƷ",    75, 80, 81, 50 },
	{"ʤϹƷ",    100, 80, 81, 50 },

	{"ȱΤʤƬ",        20, 81, 65, 50 },
	{"ûȱ",        40, 81, 65, 50 },
	{"Ĺȱ",        60, 81, 65, 50 },
	{"ǳ褦֤ȱ",        80, 81, 65, 50 },
	{"Τʤȱ",        100, 81, 65, 50 },
#else
	{"You have pale eyes, ",    25, 80, 81, 50 },
	{"You have glowing eyes, ",    50, 80, 81, 50 },
	{"You have tiny black eyes, ",    75, 80, 81, 50 },
	{"You have shining black eyes, ",    100, 80, 81, 50 },

	{"no hair at all, ",        20, 81, 65, 50 },
	{"short black hair, ",        40, 81, 65, 50 },
	{"long black hair, ",        60, 81, 65, 50 },
	{"bright red hair, ",        80, 81, 65, 50 },
	{"colourless albino hair, ",        100, 81, 65, 50 },
#endif

#ifdef JP
	{"βͤλҶΤΰͤǤ ", 100, 83, 80, 50 },

	{"ʤϥ⡼롦ܥ",   	40, 82, 83, 50 },
	{"ʤϥܥ",         		75, 82, 83, 55 },
	{"ʤϥ顼ܥ",   		95, 82, 83, 65 },
	{"ʤϥܥɤβإ६",   100, 82, 83, 100 },
#else
	{"You are one of several children of ", 100, 82, 83, 50 },

	{"a Small Kobold.  ",   40, 83, 80, 50 },
	{"a Kobold.  ",         75, 83, 80, 55 },
	{"a Large Kobold.  ",   95, 83, 80, 65 },
	{"Mughash, the Kobold Lord.  ",     100, 83, 80, 100 },
#endif

#ifdef JP
	{"ʤϽåβͤλҶΤΰͤǤ"
	, 100, 84, 85, 50 },

	{"ʤ֤ȩ", 40, 85, 86, 50 },
	{"ʤϹȩ", 90, 85, 86, 50 },
	{"ʤϲȩ", 100, 85, 86, 50 },

	{"ܤ򤷤Ƥޤ", 100, 86, 0, 50 },
#else
	{"You are one of several children of a Klackon hive queen.  "
	, 100, 84, 85, 50 },

	{"You have red skin, ", 40, 85, 86, 50 },
	{"You have black skin, ", 90, 85, 86, 50 },
	{"You have yellow skin, ", 100, 85, 86, 50 },

	{"and black eyes.", 100, 86, 0, 50 },
#endif

#ifdef JP
	{"βͤλҶΤΰͤǤ", 100, 88, 18, 89 },

	{"ʤϥˡ٥󥰤", 30,	87, 88, 20 },
	{"ʤϥˡ٥󥰤±", 50, 	87, 88, 40 },
	{"ʤϥˡ٥󥰤결", 70, 	87, 88, 60 },
	{"ʤϥˡ٥󥰤ι", 90, 	87, 88, 75 },
	{"ʤϥˡ٥󥰤Υ㡼ޥ", 95,87, 88, 100 },
	{"ʤϥˡ٥󥰤βإߡ", 100,87, 88, 100 },
#else
	{"You are one of several children of ", 100, 87, 88, 89 },

	{"a Nibelung Slave.  ", 30, 88, 18, 20 },
	{"a Nibelung Thief.  ", 50, 88, 18, 40 },
	{"a Nibelung Smith.  ", 70, 88, 18, 60 },
	{"a Nibelung Miner.  ", 90, 88, 18, 75 },
	{"a Nibelung Shaman.  ", 95, 88, 18, 100 },
	{"Mime, the Nibelung.  ", 100, 88, 18, 100 },
#endif

#ifdef JP
	{"ʤϥɥ饳˥", 100, 89, 90, 50 },

	{"ĹҤǤ", 30, 135, 91, 55 },
	{"ҤǤ", 50, 135, 91, 50 },
	{"ܻҤǤ", 55, 135, 91, 50 },
	{"θɻǤ", 60, 135, 91, 45 },
	{"δͤλҶΤΰͤǤ", 85, 135, 91, 50 },
	{"ΰγǤ", 100, 135, 91, 55 },

	{"", 10, 90, 135, 20 },
	{"±", 21, 90, 135, 30 },
	{"", 26, 90, 135, 45 },
	{"ʼ", 42, 90, 135, 45 },
	{"", 73, 90, 135, 50 },
	{"", 78, 90, 135, 50 },
	{"", 85, 90, 135, 55 },
	{"Ų", 89, 90, 135, 60 },
	{"η", 94, 90, 135, 65 },
	{"ѻ", 97, 90, 135, 70 },
	{"ؼ", 99, 90, 135, 80 },
	{"²", 100, 90, 135, 100 },

	{"ʤ", 100, 91, 136, 50 },

	{"ϹȩƳʢ򤷤Ƥޤ", 11, 136, 0, 50 },
	{"֥󥺿ȩƼʢ򤷤Ƥޤ", 16, 136, 0, 50 },
	{"ȩ򤷤Ƥޤ", 24, 136, 0, 50 },
	{"ȩ򤷤Ƥޤ", 26, 136, 0, 60 },
	{"Ĥȩƿ忧ʢ򤷤Ƥޤ", 32, 136, 0, 50 },
	{"ȩǤ", 33, 136, 0, 70 },
	{"㿧㿧ȩ򤷤Ƥޤ", 37, 136, 0, 45 },
	{"ȩʢ򤷤Ƥޤ", 41, 136, 0, 50 },
	{"翧ȩʢ򤷤Ƥޤ", 48, 136, 0, 50 },
	{"пȩƲʢ򤷤Ƥޤ", 65, 136, 0, 50 },
	{"ппȩ򤷤Ƥޤ", 75, 136, 0, 50 },
	{"֤֤ȩ򤷤Ƥޤ", 88, 136, 0, 50 },
	{"ȩ򤷤Ƥޤ", 94, 136, 0, 50 },
	{"᤯°Ūȩ򤷤Ƥޤ", 100, 136, 0, 55},
#else
	{"You are ", 100, 89, 135, 50 },

	{"the oldest child of a Draconian ", 30, 135, 90, 55 },
	{"the youngest child of a Draconian ", 50, 135, 90, 50 },
	{"the adopted child of a Draconian ", 55, 135, 90, 50 },
	{"an orphaned child of a Draconian ", 60, 135, 90, 45 },
	{"one of several children of a Draconian ", 85, 135, 90, 50 },
	{"the only child of a Draconian ", 100, 135, 90, 55 },

	{"Beggar.  ", 10, 90, 91, 20 },
	{"Thief.  ", 21, 90, 91, 30 },
	{"Sailor.  ", 26, 90, 91, 45 },
	{"Mercenary.  ", 42, 90, 91, 45 },
	{"Warrior.  ", 73, 90, 91, 50 },
	{"Merchant.  ", 78, 90, 91, 50 },
	{"Artisan.  ", 85, 90, 91, 55 },
	{"Healer.  ", 89, 90, 91, 60 },
	{"Priest.  ", 94, 90, 91, 65 },
	{"Mage.  ", 97, 90, 91, 70 },
	{"Scholar.  ", 99, 90, 91, 80 },
	{"Noble.  ", 100, 90, 91, 100 },

	{"You have ", 100, 91, 136, 50 },

	{"charcoal wings, charcoal skin and a smoke-gray belly.", 11, 136, 0, 50 },
	{"bronze wings, bronze skin, and a copper belly.", 16, 136, 0, 50 },
	{"golden wings, and golden skin.", 24, 136, 0, 50 },
	{"white wings, and white skin.", 26, 136, 0, 60 },
	{"blue wings, blue skin, and a cyan belly.", 32, 136, 0, 50 },
	{"multi-hued wings, and multi-hued skin.", 33, 136, 0, 70 },
	{"brown wings, and brown skin.", 37, 136, 0, 45 },
	{"black wings, black skin, and a white belly.", 41, 136, 0, 50 },
	{"lavender wings, lavender skin, and a white belly.", 48, 136, 0, 50 },
	{"green wings, green skin and yellow belly.", 65, 136, 0, 50 },
	{"green wings, and green skin.", 75, 136, 0, 50 },
	{"red wings, and red skin.", 88, 136, 0, 50 },
	{"black wings, and black skin.", 94, 136, 0, 50 },
	{"metallic skin, and shining wings.", 100, 136, 0, 55},
#endif

#ifdef JP
	{"ʤϰʤĹϷǾ̣⤫ǤʤӤǥޥ㥯Ȥޤޤʤϥ̥̥뤷ȩȵܤ򤷤Ƥơ", 100, 92, 93, 80 },
	{"μ˻ܤο꤬Ƥޤ", 20, 93, 0, 45 },
	{"μ˻ܤο꤬Ƥޤ", 80, 93, 0, 50 },
	{"μ˸ܤο꤬Ƥޤ", 100, 93, 0, 55 },
#else
	{"You have slimy skin, empty glowing eyes, and ", 100, 92, 93, 80 },
	{"three tentacles around your mouth.", 20, 93, 0, 45 },
	{"four tentacles around your mouth.", 80, 93, 0, 50 },
	{"five tentacles around your mouth.", 100, 93, 0, 55 },
#endif

#ifdef JP
	{"ʤ", 100, 94, 95, 50 },

	{"ʤϹʪǤ", 30, 95, 96, 20 },
	{"鰭Ǥ", 60, 95, 96, 50 },
	{"鰭Ǥ", 90, 95, 96, 75 },
	{"ⲦǤ", 100, 95, 96, 99 },

	{"ʤ֤ȩ", 50, 96, 97, 50 },
	{"ʤ㿧ȩ", 100, 96, 97, 50},

	{"֤ǳƷ򤷤ƤơޤȲȻɤƤޤ", 40, 97, 0, 50 },
	{"֤ǳƷ򤷤ƤơޤȲ礬Ƥޤ", 70, 97, 0, 50 },
	{"֤ǳƷ򤷤ƤơޤƤޤ", 100, 97, 0, 50 },
#else
	{"You ancestor was ", 100, 94, 95, 50 },

	{"a mindless demonic spawn.  ", 30, 95, 96, 20 },
	{"a minor demon.  ", 60, 95, 96, 50 },
	{"a major demon.  ", 90, 95, 96, 75 },
	{"a demon lord.  ", 100, 95, 96, 99 },

	{"You have red skin, ", 50, 96, 97, 50 },
	{"You have brown skin, ", 100, 96, 97, 50},

	{"claws, fangs, spikes, and glowing red eyes.", 40, 97, 0, 50 },
	{"claws, fangs, and glowing red eyes.", 70, 97, 0, 50 },
	{"claws, and glowing red eyes.", 100, 97, 0, 50 },
#endif

#ifdef JP
	{"ʤϥХѤˤä", 40,	98, 99, 50 },
	{"ʤˡȤˤä", 65, 	98, 99, 50 },
	{"ʤϣѻդˤä",	     90,	98, 99, 50},
	{"ʤηˤä", 100,	98, 99, 60},

	{"臘", 10, 99, 100, 65 },
	{"",		 100,  99, 100, 50 },

	{"Ǵڤ", 40, 100, 101, 50 },
	{"Ф", 80, 100, 101, 50 },
	{"ڤ", 85, 100, 101, 40 },
	{"Ŵ", 99, 100, 101, 50 },
	{"⤫", 100, 100, 101, 100},

	{"Фޤ", 100,101, 0, 50 },
#else
	{"You were shaped from ", 100, 98, 99, 50 },

	{"clay ", 40, 99, 100, 50 },
	{"stone ", 80, 99, 100, 50 },
	{"wood ", 85, 99, 100, 40 },
	{"iron ", 99, 99, 100, 50 },
	{"pure gold ", 100, 99, 100, 100},

	{"by a Kabbalist", 40, 100, 101, 50 },
	{"by a Wizard", 65, 100, 101, 50 },
	{"by an Alchemist", 90, 100, 101, 50},
	{"by a Priest", 100, 100, 101, 60},

	{" to fight evil.", 10, 101, 0, 65 },
	{".", 100, 101, 0, 50 },
#endif

#ifdef JP
	{"ʤ", 100, 102, 103, 50 },

	{"ѻΤˤФޤ", 30, 103, 104, 50 },
	{"ˡμ¸ˤФޤ", 50, 103, 104, 50 },
	{"ٰηˤФޤ", 70, 103, 104, 50 },
	{"Ȥηˤ߽Фޤ", 75, 103, 104, 50 },
	{"ޤޤ", 85, 103, 104, 50 },
	{"ޤޤ", 95, 103, 104, 30 },
	{"̾Ѥˤ߽Фޤ", 100, 103, 104, 50 },

	{"ʤ", 100, 104, 105, 50 },
	{"Ť줿ǽƤơ", 40, 105, 106, 50 },
	{"äǽƤơ", 60, 105, 106, 50 },
	{"줿㿧ǽƤơ", 80, 105, 106, 50 },
	{"򤯵ǽƤơ", 100, 105, 106, 50 },

	{"ܤ򤷤Ƥޤ", 30, 106, 0, 50 },
	{"ϹιФǳܤ򤷤Ƥޤ", 50, 106, 0, 50 },
	{"ݤϤäݤǤ", 100, 106, 0, 50 },
#else
	{"You were created by ", 100, 102, 103, 50 },

	{"a Necromancer.  ", 30, 103, 104, 50 },
	{"a magical experiment.  ", 50, 103, 104, 50 },
	{"an Evil Priest.  ", 70, 103, 104, 50 },
	{"a pact with the demons.  ", 75, 103, 104, 50 },
	{"a restless spirit.  ", 85, 103, 104, 50 },
	{"a curse.  ", 95, 103, 104, 30 },
	{"an oath.  ", 100, 103, 104, 50 },

	{"You have ", 100, 104, 105, 50 },
	{"dirty, dry bones, ", 40, 105, 106, 50 },
	{"rotten black bones, ", 60, 105, 106, 50 },
	{"filthy, brown bones, ", 80, 105, 106, 50 },
	{"shining white bones, ", 100, 105, 106, 50 },

	{"and glowing eyes.", 30, 106, 0, 50 },
	{"and eyes which burn with hellfire.", 50, 106, 0, 50 },
	{"and empty eyesockets.", 100, 106, 0, 50 },
#endif

#ifdef JP
	{"ʤ", 100, 107, 108, 50 },

	{"ѻΤˤ߽Фޤ", 30, 108, 62, 50 },
	{"ˡȤˤ߽Фޤ", 50, 108, 62, 50 },
	{"ޤޤ",60, 108, 62, 50 },
	{"ٰηˤ߽Фޤ", 70, 108, 62, 50 },
	{"Ȥηˤ߽Фޤ", 80, 108, 62, 50 },
	{"ޤޤ", 95, 108, 62, 30 },
	{"̾Ѥˤ߽Фޤ", 100, 108, 62, 50 },

	{"ʤϰų쿧Ʒ",               20, 109, 110, 50},
	{"ʤϳ쿧Ʒ",                    60, 109, 110, 50},
	{"ʤ㿧Ʒ",                    70, 109, 110, 50},
	{"ʤпƷ",                    80, 109, 110, 50},
	{"ʤĤƷ",                     90, 109, 110, 50},
	{"ʤøĿƷ",               100, 109, 110, 50}, /* tansei.cc.u-tokyoͳ */

	{"ʤ餫",                        70, 110, 111, 50},
	{"Ǥä",                            90, 110, 111, 50},
	{"뤷",                          100, 110, 111, 50},

	{"ȱ",                         30, 111, 112, 50},
	{"㿧ȱ",                         70, 111, 112, 50},
	{"㿧ȱ",                        80, 111, 112, 50},
	{"֤ȱ",                       90, 111, 112, 50},
	{"ȱ",                        100, 111, 112, 50},

	{"ƤȤƤŤȩ򤷤Ƥޤ",              10, 112, 0, 50},
	{"ưŤȩ򤷤Ƥޤ",                   30, 112, 0, 50},
	{"ʿŪȩο򤷤Ƥޤ",               80, 112, 0, 50},
	{"Ʒ쿧Τȩ򤷤Ƥޤ",                   90, 112, 0, 50},
	{"ƤȤƤ쿧Τȩ򤷤Ƥޤ",             100, 112, 0, 50},
#else
	{"You were created by ", 100, 107, 108, 50 },

	{"a Necromancer.  ", 30, 108, 62, 50 },
	{"a Wizard.  ", 50, 108, 62, 50 },
	{"a restless spirit.  ", 60, 108, 62, 50 },
	{"an Evil Priest.  ", 70, 108, 62, 50 },
	{"a pact with the demons.  ", 80, 108, 62, 50 },
	{"a curse.  ", 95, 108, 62, 30 },
	{"an oath.  ", 100, 108, 62, 50 },

	{"You have a dark brown eye, ",               20, 109, 110, 50},
	{"You have a brown eye, ",                    60, 109, 110, 50},
	{"You have a hazel eye, ",                    70, 109, 110, 50},
	{"You have a green eye, ",                    80, 109, 110, 50},
	{"You have a blue eye, ",                     90, 109, 110, 50},
	{"You have a blue-gray eye, ",               100, 109, 110, 50},

	{"straight ",                        70, 110, 111, 50},
	{"wavy ",                            90, 110, 111, 50},
	{"curly ",                          100, 110, 111, 50},

	{"black hair, ",                         30, 111, 112, 50},
	{"brown hair, ",                         70, 111, 112, 50},
	{"auburn hair, ",                        80, 111, 112, 50},
	{"red hair, ",                       90, 111, 112, 50},
	{"blond hair, ",                        100, 111, 112, 50},

	{"and a very dark complexion.",              10, 112, 0, 50},
	{"and a dark complexion.",                   30, 112, 0, 50},
	{"and an average complexion.",               80, 112, 0, 50},
	{"and a fair complexion.",                   90, 112, 0, 50},
	{"and a very fair complexion.",             100, 112, 0, 50},
#endif

#ifdef JP
	{"ʤäΤʤ椫ᴤޤ", 20, 113, 114, 50 },
	{"ʤɴǤʥХѥɤα¿ȤʤäƤޤޤ", 40, 113, 114, 50 },
	{"ʤϥХѥϥ󥿡Ǥα¿ȤʤäƤޤޤ", 60, 113, 114, 50 },
	{"ʤϻѻΤǤ", 80, 113, 114, 50 },
	{"ʤ϶ʵ²Ǥ", 95, 113, 114, 50 },
	{"ʤ϶ǻǦǤ", 100, 113, 114, 50 },
#else
	{"You arose from an unmarked grave.  ", 20, 113, 114, 50 },
	{"In life you were a simple peasant, the victim of a powerful Vampire Lord.  ", 40, 113, 114, 50 },
	{"In life you were a Vampire Hunter, but they got you.  ", 60, 113, 114, 50 },
	{"In life you were a Necromancer.  ", 80, 113, 114, 50 },
	{"In life you were a powerful noble.  ", 95, 113, 114, 50 },
	{"In life you were a powerful and cruel tyrant.  ", 100, 113, 114, 50 },
#endif

#ifdef JP
	{"ʤ", 100, 114, 115, 50 },

	{"ȱ", 25, 115, 116, 50 },
	{"Ĥ줿֥饦ȱ", 50, 115, 116, 50 },
	{"ȱ", 75, 115, 116, 50 },
	{"ȱΤʤƬ", 100, 115, 116, 50 },
#else
	{"You have ", 100, 114, 115, 50 },

	{"jet-black hair, ", 25, 115, 116, 50 },
	{"matted brown hair, ", 50, 115, 116, 50 },
	{"white hair, ", 75, 115, 116, 50 },
	{"a hairless head, ", 100, 115, 116, 50 },
#endif

#ifdef JP
	{"ǳúΤ褦Ʒ", 25, 116, 117, 50 },
	{"ƷΤʤܡ", 50, 116, 117, 50 },
	{"˽ʲƷ", 75, 116, 117, 50 },
	{"ä֤Ʒ", 100, 116, 117, 50 },

	{"ƻͤΤ褦Ĥ᤿ȩ򤷤Ƥޤ", 100, 117, 0, 50 },
#else
	{"eyes like red coals, ", 25, 116, 117, 50 },
	{"blank white eyes, ", 50, 116, 117, 50 },
	{"feral yellow eyes, ", 75, 116, 117, 50 },
	{"bloodshot red eyes, ", 100, 116, 117, 50 },

	{"and a deathly pale complexion.", 100, 117, 0, 50 },
#endif

#ifdef JP
	{"ʤ", 100, 118, 119, 50 },

	{"ѻΤˤФޤ", 30, 119, 134, 50 },
	{"ˡμ¸ˤФޤ", 50, 119, 134, 50 },
	{"ٰηˤФޤ", 70, 119, 134, 50 },
	{"Ȥηˤ߽Фޤ", 75, 119, 134, 50 },
	{"ޤޤ", 85, 119, 134, 50 },
	{"ޤޤ", 95, 119, 134, 30 },
	{"̾Ѥˤ߽Фޤ", 100, 119, 134, 50 },
#else
	{"You were created by ", 100, 118, 119, 50 },

	{"a Necromancer.  ", 30, 119, 134, 50 },
	{"a magical experiment.  ", 50, 119, 134, 50 },
	{"an Evil Priest.  ", 70, 119, 134, 50 },
	{"a pact with the demons.  ", 75, 119, 134, 50 },
	{"a restless spirit.  ", 85, 119, 134, 50 },
	{"a curse.  ", 95, 119, 134, 30 },
	{"an oath.  ", 100, 119, 134, 50 },
#endif

#ifdef JP
	{"ȱ", 25, 120, 121, 50 },
	{"Ĥ줿֥饦ȱ", 50, 120, 121, 50 },
	{"ȱ", 75, 120, 121, 50 },
	{"ȱΤʤƬ", 100, 120, 121, 50 },
#else
	{"jet-black hair, ", 25, 120, 121, 50 },
	{"matted brown hair, ", 50, 120, 121, 50 },
	{"white hair, ", 75, 120, 121, 50 },
	{"a hairless head, ", 100, 120, 121, 50 },
#endif

#ifdef JP
	{"ǳúΤ褦Ʒ", 25, 121, 122, 50 },
	{"ƷΤʤܡ", 50, 121, 122, 50 },
	{"˽ʲƷ", 75, 121, 122, 50 },
	{"ä֤Ʒ", 100, 121, 122, 50 },
#else
	{"eyes like red coals, ", 25, 121, 122, 50 },
	{"blank white eyes, ", 50, 121, 122, 50 },
	{"feral yellow eyes, ", 75, 121, 122, 50 },
	{"bloodshot red eyes, ", 100, 121, 122, 50 },
#endif

#ifdef JP
	{"ƻͤΤ褦ڿȩ򤷤Ƥޤ", 100, 122, 123, 50 },
	{"ʤμˤԵ̣пΥ餬äƤޤ", 100, 123, 0, 50 },
#else
	{" and a deathly gray complexion. ", 100, 122, 123, 50 },
	{"An eerie green aura surrounds you.", 100, 123, 0, 50 },
#endif

#ifdef JP
	{"ʤξƤ", 100, 124, 125, 50 },

	{"ԥǤ", 20, 125, 126, 35 },
	{"˥Ǥ", 30, 125, 126, 25 },
	{"Ǥ", 75, 125, 126, 50 },
	{"Ǥ", 90, 125, 126, 75 },
	{"ε²Ǥ", 100, 125, 126, 85 }, 
#else
	{"Your parents were ", 100, 124, 125, 50 },

	{"pixies.  ", 20, 125, 126, 35 },
	{"nixies.  ", 30, 125, 126, 25 },
	{"wood sprites.  ", 75, 125, 126, 50 },
	{"wood spirits.  ", 90, 125, 126, 75 },
	{"noble faerie folk.  ", 100, 125, 126, 85 },
#endif

#ifdef JP
	{"ʤ˥饤ȥ֥롼αƤơ", 100, 126, 127, 50 },

	{"ʤ餫ʶȱ",                        80, 127, 128, 50},
	{"Ǥäȱ",                            100, 127, 128, 50},

	{"ĤƷȤȩ򤷤Ƥޤ", 100, 128, 0, 50},
#else
	{"You have light blue wings attached to your back, ", 100, 126, 127, 50 },

	{"straight blond hair, ",                        80, 127, 128, 50},
	{"wavy blond hair, ",                            100, 127, 128, 50},

	{"blue eyes, and a very fair complexion.", 100, 128, 0, 50},
#endif

#ifdef JP
	{"ʤˡμ¸ˤ߽Фޤ", 30, 129, 130, 40},
	{"ʤϻҶ塢򤫤ˤ륹˼ͤùǤޤޤ",
	50, 129, 130, 50 }, 
	{"륫ⲦͷӤǤʤ夲ޤ",
	60, 129, 130, 60 },
	{"ʤˡˤݤ蘆줿ưʪȿʹ֤λҶǤ", 75, 129, 130, 50},
	{"ʤϸ⤪ޤʪŪʳݤ碌ˤޤޤ", 100, 129, 130, 30},
#else
	{"You were produced by a magical experiment.  ", 30, 129, 130, 40},
	{"In your childhood, you were stupid enough to stick your head in raw Logrus.  ",
	50, 129, 130, 50 },
	{"A Demon Lord of Chaos decided to have some fun, and so he created you.  ",
	60, 129, 130, 60 },
	{"You are the magical crossbreed of an animal and a man.  ", 75, 129, 130, 50},
	{"You are the blasphemous crossbreed of unspeakable creatures of chaos.  ", 100, 129, 130, 30},
#endif

#ifdef JP
	{"ʤп",              60, 130, 131, 50},
	{"ʤϹĻ",                    85, 130, 131, 50},
	{"ʤϥ󥸿ǭ",            99, 130, 131, 50},
	{"ʤǳ褦ʰ",          100, 130, 131, 55},
#else
	{"You have green reptilian eyes, ",              60, 130, 131, 50},
	{"You have the black eyes of a bird, ",              85, 130, 131, 50},
	{"You have the orange eyes of a cat, ",               99, 130, 131, 50},
	{"You have the fiery eyes of a demon, ",             100, 130, 131, 55},
#endif

#ifdef JP

	{"ȱΤʤƬ",                 10, 131, 133, 50},
	{"򤷤Ƥơ",                     33, 131, 132, 50},
	{"򤷤Ƥơߤܤ餷",             66, 131, 132, 50},
	{"򤷤ƤơƤä",                100, 131, 132, 50},
#else
	{"no hair at all, ",                 10, 131, 133, 50 },
	{"dirty ",                           33, 131, 132, 50},
	{"mangy ",                           66, 131, 132, 50},
	{"oily ",                           100, 131, 132, 50},
#endif

#ifdef JP

	{"㿧",                    33, 132, 133, 50},
	{"",                    66, 132, 133, 50},
	{"",                     100, 132, 133, 50},
#else
	{"brown fur, ",                    33, 132, 133, 50},
	{"gray fur, ",                    66, 132, 133, 50},
	{"albino fur, ",                  100, 132, 133, 50},
#endif

#ifdef JP
	{"Ӥޤ",      50, 133, 0, 50 },
	{"ʹ֤­Ƥޤ",  75, 133, 0, 50 },
	{"Ļ­Ƥޤ",    85, 133, 0, 50 },
	{"­Ƥޤ",90, 133, 0, 50 },
	{"­Ƥޤ",    95, 133, 0, 50 },
	{"ǭ­Ƥޤ",    97, 133, 0, 50 },
	{"­Ƥޤ",   100, 133, 0, 50 },

	{"ʤ", 100, 134, 120, 50 },
#else
	{"and the hooves of a goat.",      50, 133, 0, 50 },
	{"and human feet.",        75, 133, 0, 50 },
	{"and bird's feet.",       85, 133, 0, 50 },
	{"and reptilian feet.",    90, 133, 0, 50 },
	{"and bovine feet.",       95, 133, 0, 50 },
	{"and feline feet.",       97, 133, 0, 50 },
	{"and canine feet.",       100, 133, 0, 50 },

	{"You have ", 100, 134, 120, 50 },
#endif
};

/*
 * Choose from one of the available magical realms
 */
static byte choose_realm(byte choices)
{
	int picks[MAX_REALM] = {0};
	int k, i, n, cs, os;
	int count = 0;
	byte auto_select = REALM_NONE;
	char c;
	char sym[MAX_REALM];
	char p2 = ')';
	char buf[80], cur[80];

	/* Count the choices */
	if (choices & CH_LIFE)
	{
		count++;
		auto_select = REALM_LIFE;
	}
	if (choices & CH_SORCERY)
	{
		count++;
		auto_select = REALM_SORCERY;
	}
	if (choices & CH_MUSOU)
	{
		count++;
		auto_select = REALM_MUSOU;
	}
	if (choices & CH_HEX)	/* Hex */
	{
		count++;
		auto_select = REALM_HEX;
	}

	/* Auto-select the realm */
	if (count < 2) return auto_select;

	/* Extra info */
#ifdef JP
	put_str ("աˡΰˤꤢʤʸΥפޤޤ", 23, 5);
#else
	put_str ("Note: The realm of magic will determine which spells you can learn.", 23, 5);
#endif

#if 0
	cs = n = 0;
#else
	n = 0;
#endif
	for (i = 0; i<16; i++)
	{
		/* Analize realms */
		if (choices & (1 << i))
		{
#if 0
			if (p_ptr->realm1 == i+1)
			{
				if (p_ptr->realm2 == 255)
					cs = n;
				else
					continue;
			}
			if (p_ptr->realm2 == i+1)
				cs = n;
#endif
			if (n < 26)
				sym[n] = I2A(n);
			else
				sym[n] = ('A' + n - 26);
			sprintf(buf, "%c%c %s", sym[n], p2, realm_names[i+1]);
			put_str(buf, 12 + (n/5), 2 + 15 * (n%5));
			picks[n++] = i+1;
		}
	}
#ifdef JP
	sprintf(cur, "%c%c %s", '*', p2, "");
#else
	sprintf(cur, "%c%c %s", '*', p2, "Random");
#endif

	/* Get a realm */
	k = -1;
	cs = 0;
	os = n;
	while (1)
	{
		/* Move Cursol */
		if (cs != os)
		{
			c_put_str(TERM_WHITE, cur, 12 + (os/5), 2 + 15 * (os%5));
			put_str("                                   ", 3, 40);
			put_str("                                   ", 4, 40);

			if(cs == n)
			{
#ifdef JP
				sprintf(cur, "%c%c %s", '*', p2, "");
#else
				sprintf(cur, "%c%c %s", '*', p2, "Random");
#endif
			}
			else
			{
				sprintf(cur, "%c%c %s", sym[cs], p2, realm_names[picks[cs]]);
			}
			c_put_str(TERM_YELLOW, cur, 12 + (cs/5), 2 + 15 * (cs%5));
			os = cs;
		}

		if (k >= 0) break;

#ifdef JP
		sprintf(buf, "ΰǲ(%c-%c) ('='ץ): ", sym[0], sym[n-1]);
#else
		sprintf(buf, "Choose a realm (%c-%c) ('=' for options): ", sym[0], sym[n-1]);
#endif

		put_str(buf, 10, 10);
		c = inkey();
		if (c == '8')
		{
			if (cs >= 5) cs -= 5;
			continue;
		}
		if (c == '4')
		{
			if (cs > 0) cs--;
			continue;
		}
		if (c == '6')
		{
			if (cs < n) cs++;
			continue;
		}
		if (c == '2')
		{
			if ((cs + 5) <= n) cs += 5;
			continue;
		}
		if (c == ' ' || c == '\r' || c == '\n')
		{
			if(cs == n)
			{
				k = randint0(n);
				break;
			}
			else
			{
				k = cs;
				break;
			}
		}
		if (c == '*')
		{
			k = randint0(n);
			break;
		}
		if (c == 'Q')
		{
			remove_loc();
			quit(NULL);
		}
		if (c == 'S') return 255;
		k = (islower(c) ? A2I(c) : -1);
		if ((k >= 0) && (k < n))
		{
			cs = k;
			continue;
		}
		k = (isupper(c) ? (26 + c - 'A') : -1);
		if ((k >= 26) && (k < n))
		{
			cs = k;
			continue;
		}
		else k = -1;
		if (c == '?') do_cmd_help();
		else if (c == '=')
		{
			screen_save();
#ifdef JP
			do_cmd_options_aux(6, "ץ");
#else
			do_cmd_options_aux(6, "Startup Options");
#endif
			screen_load();
		}
		else bell();
	}

	/* Clean up */
	clear_from(10);

	return (picks[k]);
}


/*
 * Choose the magical realms
 */
static bool get_player_realms(void)
{
	/* Snatcher */
	if (p_ptr->pclass == CLASS_SNATCHER)
	{
		set_first_monster_race();
		return (TRUE);
	}

	/* Select the first realm */
	if (p_ptr->pclass == CLASS_ELEMENTALIST)
		p_ptr->realm1 = choose_element();
	else
		p_ptr->realm1 = choose_realm(realm_choices1[p_ptr->pclass]);

	if (255 == p_ptr->realm1) return FALSE;
	if (p_ptr->realm1)
	{
		/* Print the realm */
#ifdef JP
		put_str("ˡ        :", 6, 1);
#else
		put_str("Magic       :", 6, 1);
#endif

		if (p_ptr->pclass == CLASS_ELEMENTALIST)
			c_put_str(TERM_L_BLUE, element_realm_name(), 6, 15);
		else
			c_put_str(TERM_L_BLUE, realm_names[p_ptr->realm1], 6, 15);

		/* Select the second realm */
		p_ptr->realm2 = choose_realm(realm_choices2[p_ptr->pclass]);

		/* Print the realm */
		if (255 == p_ptr->realm2) return FALSE;
		if (p_ptr->realm2)
			c_put_str(TERM_L_BLUE, format("%s, %s", realm_names[p_ptr->realm1], realm_names[p_ptr->realm2]), 6, 15);
	}

	return (TRUE);
}


/*
 * Save the current data for later
 */
static void save_prev_data(birther *birther_ptr)
{
	int i;

	/* Save the data */
	birther_ptr->psex = p_ptr->psex;
	birther_ptr->prace = p_ptr->prace;
	birther_ptr->pclass = p_ptr->pclass;
	birther_ptr->realm1 = p_ptr->realm1;
	birther_ptr->realm2 = p_ptr->realm2;
	birther_ptr->age = p_ptr->age;
	birther_ptr->ht = p_ptr->ht;
	birther_ptr->wt = p_ptr->wt;
	birther_ptr->sc = p_ptr->sc;
	birther_ptr->au = p_ptr->au;

	/* Save the stats */
	for (i = 0; i < 6; i++)
	{
		birther_ptr->stat_max[i] = p_ptr->stat_max[i];
	}

	/* Save the hp */
	for (i = 0; i < PY_MAX_LEVEL; i++)
	{
		birther_ptr->player_hp[i] = player_hp[i];
	}

	birther_ptr->chaos_patron = 0;

	/* Save the history */
	for (i = 0; i < 4; i++)
	{
		strcpy(birther_ptr->history[i], history[i]);
	}
}


/*
 * Load the previous data
 */
static void load_prev_data(bool swap)
{
	int i;

	birther	temp;

	/*** Save the current data ***/
	if (swap) save_prev_data(&temp);


	/*** Load the previous data ***/

	/* Load the data */
	p_ptr->psex = previous_char.psex;
	p_ptr->prace = previous_char.prace;
	p_ptr->pclass = previous_char.pclass;
	p_ptr->realm1 = previous_char.realm1;
	p_ptr->realm2 = previous_char.realm2;
	p_ptr->age = previous_char.age;
	p_ptr->ht = previous_char.ht;
	p_ptr->wt = previous_char.wt;
	p_ptr->sc = previous_char.sc;
	p_ptr->au = previous_char.au;

	/* Load the stats */
	for (i = 0; i < 6; i++)
	{
		p_ptr->stat_cur[i] = p_ptr->stat_max[i] = previous_char.stat_max[i];
	}

	/* Load the hp */
	for (i = 0; i < PY_MAX_LEVEL; i++)
	{
		player_hp[i] = previous_char.player_hp[i];
	}
	p_ptr->mhp = player_hp[0];
	p_ptr->chp = player_hp[0];

	p_ptr->chaos_patron = 0;

	/* Load the history */
	for (i = 0; i < 4; i++)
	{
		strcpy(history[i], previous_char.history[i]);
	}

	/*** Save the previous data ***/
	if (swap)
	{
		COPY(&previous_char, &temp, birther);
	}
}

/*
 * Returns adjusted stat -JK-  Algorithm by -JWT-
 *
 * auto_roll is boolean and states maximum changes should be used rather
 * than random ones to allow specification of higher values to wait for
 *
 * The "maximize" code is important	-BEN-
 */
static int adjust_stat(int value, int amount, int auto_roll)
{
	int i;

	/* Negative amounts */
	if (amount < 0)
	{
		/* Apply penalty */
		for (i = 0; i < (0 - amount); i++)
		{
			if (value >= 18+10)
			{
				value -= 10;
			}
			else if (value > 18)
			{
				value = 18;
			}
			else if (value > 3)
			{
				value--;
			}
		}
	}

	/* Positive amounts */
	else if (amount > 0)
	{
		/* Apply reward */
		for (i = 0; i < amount; i++)
		{
			if (value < 18)
			{
				value++;
			}
			else if (maximize_mode)
			{
				value += 10;
			}
			else if (value < 18+70)
			{
				value += ((auto_roll ? 15 : randint1(15)) + 5);
			}
			else if (value < 18+90)
			{
				value += ((auto_roll ? 6 : randint1(6)) + 2);
			}
			else if (value < 18+100)
			{
				value++;
			}
		}
	}

	/* Return the result */
	return (value);
}

/*
 * Roll for a characters stats
 *
 * For efficiency, we include a chunk of "calc_bonuses()".
 */
static void get_stats(void)
{
	/* Roll and verify some stats */
	while (TRUE)
	{
		int i;
		int sum = 0;

		/* Roll some dice */
		for (i = 0; i < 2; i++)
		{
			s32b tmp = randint0(60*60*60);
			int val;

			/* Extract 5 + 1d3 + 1d4 + 1d5 */
			val = 5 + 3;
			val += tmp % 3; tmp /= 3;
			val += tmp % 4; tmp /= 4;
			val += tmp % 5; tmp /= 5;

			/* Save that value */
			sum += val;
			p_ptr->stat_cur[3*i] = p_ptr->stat_max[3*i] = (maximize_mode ? val : adjust_stat(val, rp_ptr->r_adj[3*i] + cp_ptr->c_adj[3*i], FALSE));

			/* Extract 5 + 1d3 + 1d4 + 1d5 */
			val = 5 + 3;
			val += tmp % 3; tmp /= 3;
			val += tmp % 4; tmp /= 4;
			val += tmp % 5; tmp /= 5;

			/* Save that value */
			sum += val;
			p_ptr->stat_cur[3*i+1] = p_ptr->stat_max[3*i+1] = (maximize_mode ? val : adjust_stat(val, rp_ptr->r_adj[3*i+1] + cp_ptr->c_adj[3*i+1], FALSE));

			/* Extract 5 + 1d3 + 1d4 + 1d5 */
			val = 5 + 3;
			val += tmp % 3; tmp /= 3;
			val += tmp % 4; tmp /= 4;
			val += tmp;

			/* Save that value */
			sum += val;
			p_ptr->stat_cur[3*i+2] = p_ptr->stat_max[3*i+2] = (maximize_mode ? val : adjust_stat(val, rp_ptr->r_adj[3*i+2] + cp_ptr->c_adj[3*i+2], FALSE));
		}

		/* Verify totals */
		if ((sum > 42+5*6) && (sum < 57+5*6)) break;
		/* 57 was 54... I hate 'magic numbers' :< TY */
	}
}

/*
 * Roll for some info that the auto-roller ignores
 */
static void get_extra(bool roll_hitdie)
{
	/* Experience factor */
	p_ptr->expfact = rp_ptr->r_exp + cp_ptr->c_exp;

	/* Hitdice */
	p_ptr->hitdie = rp_ptr->r_mhp + cp_ptr->c_mhp;

	/* Initial hitpoints */
	p_ptr->mhp = p_ptr->hitdie;

	/* Roll for hit point unless quick-start */
	if (roll_hitdie)
	{
		do_cmd_rerate(FALSE);
	}
}

/*
 * Get the racial history, and social class, using the "history charts".
 */
static void get_history(void)
{
	int i, n, chart, roll, social_class;

	char *s, *t;

	char buf[240];

	/* Clear the previous history strings */
	for (i = 0; i < 4; i++) history[i][0] = '\0';

	/* Clear the history text */
	buf[0] = '\0';

	/* Initial social class */
	social_class = randint1(4);

	/* Starting place */
	switch (p_ptr->prace)
	{
		case RACE_HUMAN:
		case RACE_DUNADAN:
		case RACE_BARBARIAN:
		{
			chart = 1;
			break;
		}
		case RACE_HALF_ELF:
		{
			chart = 4;
			break;
		}
		case RACE_ELF:
		case RACE_HIGH_ELF:
		{
			chart = 7;
			break;
		}
		case RACE_HOBBIT:
		{
			chart = 10;
			break;
		}
		case RACE_GNOME:
		{
			chart = 13;
			break;
		}
		case RACE_DWARF:
		{
			chart = 16;
			break;
		}
		case RACE_HALF_ORC:
		{
			chart = 19;
			break;
		}
		case RACE_HALF_TROLL:
		{
			chart = 22;
			break;
		}
		case RACE_DARK_ELF:
		{
			chart = 69;
			break;
		}
		case RACE_HALF_OGRE:
		{
			chart = 74;
			break;
		}
		case RACE_HALF_GIANT:
		{
			chart = 75;
			break;
		}
		case RACE_HALF_TITAN:
		{
			chart = 76;
			break;
		}
		case RACE_CYCLOPS:
		{
			chart = 77;
			break;
		}
		case RACE_YEEK:
		{
			chart = 78;
			break;
		}
		case RACE_KOBOLD:
		{
			chart = 82;
			break;
		}
		case RACE_KLACKON:
		{
			chart = 84;
			break;
		}
		case RACE_NIBELUNG:
		{
			chart = 87;
			break;
		}
		case RACE_DRACONIAN:
		{
			chart = 89;
			break;
		}
		case RACE_MIND_FLAYER:
		{
			chart = 92;
			break;
		}
		case RACE_IMP:
		{
			chart = 94;
			break;
		}
		case RACE_GOLEM:
		{
			chart = 98;
			break;
		}
		case RACE_SKELETON:
		{
			chart = 102;
			break;
		}
		case RACE_ZOMBIE:
		{
			chart = 107;
			break;
		}
		case RACE_VAMPIRE:
		{
			chart = 113;
			break;
		}
		case RACE_SPECTRE:
		{
			chart = 118;
			break;
		}
		case RACE_SPRITE:
		{
			chart = 124;
			break;
		}
		case RACE_BEASTMAN:
		{
			chart = 129;
			break;
		}
		default:
		{
			chart = 0;
			break;
		}
	}


	/* Process the history */
	while (chart)
	{
		/* Start over */
		i = 0;

		/* Roll for nobility */
		roll = randint1(100);


		/* Access the proper entry in the table */
		while ((chart != bg[i].chart) || (roll > bg[i].roll)) i++;

		/* Acquire the textual history */
		(void)strcat(buf, bg[i].info);

		/* Add in the social class */
		social_class += (int)(bg[i].bonus) - 50;

		/* Enter the next chart */
		chart = bg[i].next;
	}



	/* Verify social class */
	if (social_class > 100) social_class = 100;
	else if (social_class < 1) social_class = 1;

	/* Save the social class */
	p_ptr->sc = social_class;


	/* Skip leading spaces */
	for (s = buf; *s == ' '; s++) /* loop */;

	/* Get apparent length */
	n = strlen(s);

	/* Kill trailing spaces */
	while ((n > 0) && (s[n-1] == ' ')) s[--n] = '\0';


#ifdef JP
       {
		char temp[64*4];
		roff_to_buf(s, 60, temp, sizeof(temp));
		t = temp;
		for (i = 0 ; i < 4; i++){
			if (t[0] == 0) break; 
			strcpy(history[i], t);
			t += strlen(t)+1;
		}
       }
#else
	/* Start at first line */
	i = 0;

	/* Collect the history */
	while (TRUE)
	{
		/* Extract remaining length */
		n = strlen(s);

		/* All done */
		if (n < 60)
		{
			/* Save one line of history */
			strcpy(history[i++], s);

			/* All done */
			break;
		}

		/* Find a reasonable break-point */
		for (n = 60; ((n > 0) && (s[n-1] != ' ')); n--) /* loop */;

		/* Save next location */
		t = s + n;

		/* Wipe trailing spaces */
		while ((n > 0) && (s[n-1] == ' ')) s[--n] = '\0';

		/* Save one line of history */
		strcpy(history[i++], s);

		/* Start next line */
		for (s = t; *s == ' '; s++) /* loop */;
	}
#endif

}


/*
 * Computes character's age, height, and weight
 */
void get_ahw(bool newage)
{
	int h_percent; 

	/* Calculate the age */
	if (newage) p_ptr->age = rp_ptr->b_age + randint1(rp_ptr->m_age);

	/* Calculate the height/weight for males */
	if (p_ptr->psex == SEX_MALE)
	{
		p_ptr->ht = randnor(rp_ptr->m_b_ht, rp_ptr->m_m_ht);
		h_percent = (int)(p_ptr->ht) * 100 / (int)(rp_ptr->m_b_ht);
		p_ptr->wt = randnor((int)(rp_ptr->m_b_wt) * h_percent / 100,
			(int)(rp_ptr->m_m_wt) * h_percent / 300 );
	}
	/* Calculate the height/weight for females */
	else if (p_ptr->psex == SEX_FEMALE)
	{
		p_ptr->ht = randnor(rp_ptr->f_b_ht, rp_ptr->f_m_ht);
		
		h_percent = (int)(p_ptr->ht) * 100 / (int)(rp_ptr->f_b_ht);
		p_ptr->wt = randnor((int)(rp_ptr->f_b_wt) * h_percent / 100,
			(int)(rp_ptr->f_m_wt) * h_percent / 300 );
	}
}




/*
 * Get the player's starting money
 */
static void get_money(void)
{
	int i, gold;

	/* Social Class determines starting gold */
	gold = (p_ptr->sc * 6) + randint1(100) + 300;

	/* Process the stats */
	for (i = 0; i < A_MAX; i++)
	{
		/* Mega-Hack -- reduce gold for high stats */
		if (p_ptr->stat_max[i] >= 18 + 50) gold -= 300;
		else if (p_ptr->stat_max[i] >= 18 + 20) gold -= 200;
		else if (p_ptr->stat_max[i] > 18) gold -= 150;
		else gold -= (p_ptr->stat_max[i] - 8) * 10;
	}

	/* Archaeologists can get more much money */
	if (p_ptr->pclass == CLASS_ARCHAEOLOGIST) gold += 2000;

	/* Minimum 100 gold */
	if (gold < 100) gold = 100;

	/* Save the gold */
	p_ptr->au = gold;
}



#if 0
/*
 * Display stat values, subset of "put_stats()"
 *
 * See 'display_player()' for screen layout constraints.
 */
static void birth_put_stats(void)
{
	int i, p;
	int col = 42;
	byte attr;
	char buf[80];


	/* Put the stats (and percents) */
	for (i = 0; i < A_MAX; i++)
	{
		/* Put the stat */
		cnv_stat(stat_use[i], buf);
		c_put_str(TERM_L_GREEN, buf, 3+i, col+24);

		/* Put the percent */
		if (stat_match[i])
		{
			p = 1000L * stat_match[i] / auto_round;
			attr = (p < 100) ? TERM_YELLOW : TERM_L_GREEN;
			sprintf(buf, "%3d.%d%%", p/10, p%10);
			c_put_str(attr, buf, 3+i, col+13);
		}

		/* Never happened */
		else
		{
#ifdef JP
			c_put_str(TERM_RED, "(ʤ)", 3+i, col+13);
#else
			c_put_str(TERM_RED, "(NONE)", 3+i, col+13);
#endif

		}
	}
}

#endif /* 0 */

/*
 * Clear all the global "character" data
 */
static void player_wipe(void)
{
	int i;


	/* Hack -- zero the struct */
	(void)WIPE(p_ptr, player_type);

	/* Wipe the history */
	for (i = 0; i < 4; i++)
	{
		strcpy(history[i], "");
	}

	/* Wipe the quests */
	for (i = 0; i < max_quests; i++)
	{
		quest[i].status = QUEST_STATUS_UNTAKEN;

		quest[i].cur_num = 0;
		quest[i].max_num = 0;
		quest[i].type = 0;
		quest[i].level = 0;
		quest[i].r_idx = 0;
		quest[i].complev = 0;
	}

	/* No weight */
	p_ptr->total_weight = 0;

	/* No items */
	inven_cnt = 0;
	equip_cnt = 0;

	/* Clear the inventory */
	for (i = 0; i < INVEN_TOTAL; i++)
	{
		object_wipe(&inventory[i]);
	}


	/* Start with no artifacts made yet */
	for (i = 0; i < max_a_idx; i++)
	{
		artifact_type *a_ptr = &a_info[i];
		a_ptr->cur_num = 0;
	}

	/* Reset the objects */
	k_info_reset();

	/* Reset the "monsters" */
	for (i = 1; i < max_r_idx; i++)
	{
		monster_race *r_ptr = &r_info[i];

		/* Hack -- Reset the counter */
		r_ptr->cur_num = 0;

		/* Hack -- Reset the max counter */
		r_ptr->max_num = 100;

		/* Hack -- Reset the max counter */
		if (r_ptr->flags1 & RF1_UNIQUE) r_ptr->max_num = 1;
		if (r_ptr->flags3 & RF3_UNIQUE_7) r_ptr->max_num = 7;

		/* Clear player kills */
		r_ptr->r_pkills = 0;
	}


	/* Hack -- Well fed player */
	p_ptr->food = PY_FOOD_FULL - 1;


	/* Wipe the spells */
	spell_learned1 = spell_learned2 = 0L;
	spell_worked1 = spell_worked2 = 0L;
	spell_forgotten1 = spell_forgotten2 = 0L;
	for (i = 0; i < 64; i++) spell_order[i] = 99;

	/* Clean the mutation count */
	mutant_regenerate_mod = 100;

	/* Clear "cheat" options */
	cheat_peek = FALSE;
	cheat_hear = FALSE;
	cheat_room = FALSE;
	cheat_xtra = FALSE;
	cheat_know = FALSE;
	cheat_live = FALSE;

	/* Assume no winning game */
	total_winner = FALSE;

	/* Assume no panic save */
	panic_save = 0;

	/* Assume no cheating */
	noscore = 0;
	wizard = FALSE;

	/* Default pet command settings */
	p_ptr->pet_follow_distance = PET_FOLLOW_DIST;
	p_ptr->pet_open_doors = FALSE;
	p_ptr->pet_pickup_items = FALSE;

	/* Level one */
	p_ptr->max_plv = p_ptr->lev = 1;

	/* Initialize arena and rewards information -KMW- */
	p_ptr->arena_number = 0;
	p_ptr->inside_arena = 0;
	p_ptr->inside_quest = 0;
	p_ptr->exit_bldg = TRUE; /* only used for arena now -KMW- */

	/* Reset rewards */
	for (i = 0; i < MAX_BACT; i++)
	{
		p_ptr->rewards[i] = 0;
	}

	/* Reset mutations */
	p_ptr->muta = 0;

	/* Reset snatches */
	p_ptr->r_idx = 0;
}

/*
 *  Initialize random quests and final quests
 */
static void init_dungeon_quests(int number_of_quests)
{
	int i;
	monster_race    *r_ptr;

	/* Init the random quests */
	init_flags = INIT_ASSIGN;
	p_ptr->inside_quest = MIN_RANDOM_QUEST;
	process_dungeon_file("q_info.txt", 0, 0, 0, 0);

	p_ptr->inside_quest = 0;

	/* Prepare allocation table */
	get_mon_num_prep(monster_quest, NULL);

	/* Generate quests */
	for (i = MIN_RANDOM_QUEST + number_of_quests - 1; i >= MIN_RANDOM_QUEST; i--)
	{
		quest_type      *q_ptr = &quest[i];
		monster_race    *quest_r_ptr;
		int             r_idx;

		q_ptr->status = QUEST_STATUS_TAKEN;

		/* You have only once cheance to complete Random Quest */
		q_ptr->flags |= QUEST_FLAG_ONCE;

		while (TRUE)
		{
			/*
			 * Random monster 5 - 10 levels out of depth
			 * (depending on level)
			 */
			r_idx = get_mon_num(q_ptr->level + 4 + randint1(q_ptr->level / 10));
			r_ptr = &r_info[r_idx];

			/* Accept Only Unique Monster */
			if(!(r_ptr->flags1 & RF1_UNIQUE)) continue;

			if (r_ptr->flags1 & RF1_QUESTOR) continue;

			/*
			 * Accept monsters that are 2 - 6 levels
			 * out of depth depending on the quest level
			 */
			if (r_ptr->level > (q_ptr->level + (q_ptr->level / 20) + 1)) break;
		}

		q_ptr->r_idx = r_idx;
		quest_r_ptr = &r_info[q_ptr->r_idx];

		/* Mark uniques */
		quest_r_ptr->flags1 |= RF1_QUESTOR;

		q_ptr->max_num = 1;
	}

	/* Init the two main quests (Oberon + Serpent) */
	init_flags = INIT_ASSIGN;
	p_ptr->inside_quest = QUEST_OBERON;
	process_dungeon_file("q_info.txt", 0, 0, 0, 0);

	quest[QUEST_OBERON].status = QUEST_STATUS_TAKEN;

	p_ptr->inside_quest = QUEST_SERPENT;
	process_dungeon_file("q_info.txt", 0, 0, 0, 0);

	quest[QUEST_SERPENT].status = QUEST_STATUS_TAKEN;
	p_ptr->inside_quest = 0;
}

/*
 * Reset turn
 */
static void init_turn(void)
{
	/* We cannot choose undeads on birth, so initial turn is 1 */
	turn = 1;
}

/*
 * Each player starts out with a few items, given as tval/sval pairs.
 * In addition, he always has some food and a few torches.
 */
static byte player_init[MAX_CLASS][3][2] =
{
	{
		/* Warrior */
		{ TV_RING, SV_RING_RES_FEAR }, /* Warriors need it! */
		{ TV_SWORD, SV_BASTARD_SWORD },
		{ TV_HARD_ARMOR, SV_CHAIN_MAIL }
	},

	{
		/* Mage */
		{ TV_SORCERY_BOOK, 0 }, /* Hack: for realm1 book */
		{ TV_SORCERY_BOOK, 1 },
		{ TV_SWORD, SV_DAGGER },
#if 0
		{ TV_DEATH_BOOK, 0 } /* Hack: for realm2 book */
#endif
	},

	{
		/* Priest */
		{ TV_SORCERY_BOOK, 0 }, /* Hack: for Life / Death book */
		{ TV_SORCERY_BOOK, 1 },
		{ TV_HAFTED, SV_MACE },
#if 0
		{ TV_DEATH_BOOK, 0 } /* Hack: for realm2 book */
#endif
	},

	{
		/* Ranger */
		{ TV_SORCERY_BOOK, 0 }, /* Hack: for realm1 book */
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR },
		{ TV_SWORD, SV_SHORT_SWORD },
#if 0
		{ TV_DEATH_BOOK, 0 }		/* Hack: for realm2 book */
#endif
	},

	{
		/* Paladin */
		{ TV_SORCERY_BOOK, 0 },
		{ TV_SWORD, SV_BROAD_SWORD },
		{ TV_SCROLL, SV_SCROLL_PROTECTION_FROM_EVIL }
	},

	{
		/* Warrior-Mage */
		{ TV_SORCERY_BOOK, 0 }, /* Hack: for realm1 book */
		{ TV_SOFT_ARMOR, SV_LEATHER_SCALE_MAIL },
		{ TV_SWORD, SV_LONG_SWORD },
#if 0
		{ TV_DEATH_BOOK, 0 } /* Hack: for realm2 book */
#endif
	},

	{
		/* Mindcrafter */
		{ TV_SWORD, SV_SMALL_SWORD },
		{ TV_POTION, SV_POTION_RESTORE_MANA },
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR },
	},

	{
		/* Archer */
		{ TV_SWORD, SV_SHORT_SWORD },
		{ TV_SOFT_ARMOR, SV_LEATHER_SCALE_MAIL },
		{ TV_BOW, SV_LONG_BOW },
	},

	{
		/* Archaeologist */
		{ TV_SORCERY_BOOK, 0 },
		{ TV_DIGGING, SV_SHOVEL },
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR },
	},

	{
		/* Elementalist */
		{ TV_SWORD, SV_DAGGER },
		{ TV_POTION, SV_POTION_RESTORE_MANA },
		{ TV_WAND, SV_WAND_MAGIC_MISSILE },
	},

	{
		/* Sniper */
		{ TV_SWORD, SV_SHORT_SWORD },
		{ TV_SOFT_ARMOR, SV_LEATHER_SCALE_MAIL },
		{ TV_BOW, SV_LIGHT_XBOW },
	},

	{
		/* Snatcher */
		{ TV_SWORD, SV_SHORT_SWORD },
		{ TV_SOFT_ARMOR, SV_LEATHER_SCALE_MAIL },
		{ TV_WAND, SV_WAND_MAGIC_MISSILE },
	},

	{
		/* Artificer */
		{ TV_SWORD, SV_SHORT_SWORD },
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR },
		{ TV_WAND, SV_WAND_MAGIC_MISSILE },
	},
};


/*
 * Add an outfit object
 */
static void add_outfit(object_type *o_ptr)
{
	s16b slot;

	object_aware(o_ptr);
	object_known(o_ptr);

	/* These objects are "storebought" */
	o_ptr->ident |= IDENT_STORE;

	slot = inven_carry(o_ptr);

	/* Auto-inscription */
	autopick_alter_item(slot, FALSE);
}


/*
 * Init players with some belongings
 *
 * Having an item makes the player "aware" of its purpose.
 */
void player_outfit(void)
{
	int i, tv, sv;

	object_type	forge;
	object_type	*q_ptr;


	/* Get local object */
	q_ptr = &forge;

	/* Give the player some food */
	switch (p_ptr->prace)
	{
		case RACE_GOLEM:
		case RACE_SKELETON:
		case RACE_ZOMBIE:
		case RACE_VAMPIRE:
		case RACE_SPECTRE:
		{
			/* Scrolls of satisfy hunger */
			object_prep(q_ptr, lookup_kind(TV_SCROLL, SV_SCROLL_SATISFY_HUNGER));
			q_ptr->number = (byte)rand_range(2, 5);

			add_outfit(q_ptr);

			break;
		}
		default:
		{
			/* Food rations */
			object_prep(q_ptr, lookup_kind(TV_FOOD, SV_FOOD_RATION));
			if (p_ptr->pclass == CLASS_ARCHAEOLOGIST)
				q_ptr->number = (byte)rand_range(8, 10);
			else
				q_ptr->number = (byte)rand_range(3, 7);

			add_outfit(q_ptr);
		}
	}

	/* Get local object */
	q_ptr = &forge;

	if (p_ptr->prace == RACE_VAMPIRE)
	{
		/* Vampire can't birth on XAngband */
	}
	else if (p_ptr->pclass == CLASS_ARCHAEOLOGIST)
	{
		/* Hack -- Give the player some torches */
		object_prep(q_ptr, lookup_kind(TV_LITE, SV_LITE_LANTERN));
		q_ptr->xtra3 = 15000;

		add_outfit(q_ptr);
	}
	else
	{
		/* Hack -- Give the player some torches */
		object_prep(q_ptr, lookup_kind(TV_LITE, SV_LITE_TORCH));
		q_ptr->number = (byte)rand_range(3, 7);
		q_ptr->xtra3 = rand_range(3, 7) * 500;

		add_outfit(q_ptr);
	}

	/* Get local object */
	q_ptr = &forge;

	if (p_ptr->pclass == CLASS_RANGER)
	{
		/* Hack -- Give the player some arrows */
		object_prep(q_ptr, lookup_kind(TV_ARROW, SV_AMMO_NORMAL));
		q_ptr->number = (byte)rand_range(15, 20);

		add_outfit(q_ptr);

		/* Hack -- Give the player some arrows */
		object_prep(q_ptr, lookup_kind(TV_BOW, SV_SHORT_BOW));

		add_outfit(q_ptr);
	}
	else if (p_ptr->pclass == CLASS_HIGH_MAGE)
	{
		/* Hack -- Give the player some arrows */
		object_prep(q_ptr, lookup_kind(TV_WAND, SV_WAND_MAGIC_MISSILE));
		q_ptr->number = 1;
		q_ptr->pval = (byte)rand_range(25, 30);

		add_outfit(q_ptr);
	}
	else if (p_ptr->pclass == CLASS_ARCHER)
	{
		/* Hack -- Give the player some arrows */
		object_prep(q_ptr, lookup_kind(TV_ARROW, SV_AMMO_NORMAL));
		q_ptr->number = (byte)rand_range(15, 20);

		add_outfit(q_ptr);
	}
	else if (p_ptr->pclass == CLASS_SNIPER)
	{
		/* Hack -- Give the player some arrows */
		object_prep(q_ptr, lookup_kind(TV_BOLT, SV_AMMO_LIGHT));
		q_ptr->number = (byte)rand_range(15, 20);

		add_outfit(q_ptr);
	}
	else if (p_ptr->pclass == CLASS_ARCHAEOLOGIST)
	{
		/* Hack -- Give the player some flasks */
		object_prep(q_ptr, lookup_kind(TV_FLASK, 0));
		q_ptr->number = (byte)rand_range(3, 5);

		add_outfit(q_ptr);

		/* Hack -- Give the player some spikes */
		object_prep(q_ptr, lookup_kind(TV_SPIKE, 0));
		q_ptr->number = (byte)rand_range(27, 32);

		add_outfit(q_ptr);

		/* Hack -- Give the player some scroll of magic mapping */
		object_prep(q_ptr, lookup_kind(TV_SCROLL, SV_SCROLL_MAPPING));
		q_ptr->number = (byte)rand_range(10, 12);

		add_outfit(q_ptr);
	}
	else if (p_ptr->pclass == CLASS_ARTIFICER)
	{
		/* Hack -- Give the player some scrolls of recharging */
		object_prep(q_ptr, lookup_kind(TV_SCROLL, SV_SCROLL_RECHARGING));
		q_ptr->number = (byte)rand_range(5, 8);

		add_outfit(q_ptr);

		/* Hack -- Give the player a staff of cure light wounds */
		object_prep(q_ptr, lookup_kind(TV_STAFF, SV_STAFF_CURE_LIGHT));
		q_ptr->number = 1;
		q_ptr->pval = (byte)rand_range(20, 25);

		add_outfit(q_ptr);
	}

	/* Hack -- Give the player three useful objects */
	for (i = 0; i < 3; i++)
	{
		/* Look up standard equipment */
		tv = player_init[p_ptr->pclass][i][0];
		sv = player_init[p_ptr->pclass][i][1];

		/* Hack to initialize spellbooks */
		if (tv == TV_SORCERY_BOOK) tv = TV_LIFE_BOOK + p_ptr->realm1 - 1;
#if 0
		else if (tv == TV_DEATH_BOOK) tv = TV_LIFE_BOOK + p_ptr->realm2 - 1;
#endif

		else if (tv == TV_RING && sv == SV_RING_RES_FEAR &&
		    p_ptr->prace == RACE_BARBARIAN)
			/* Barbarians do not need a ring of resist fear */
			sv = SV_RING_SUSTAIN_STR;

		/* Get local object */
		q_ptr = &forge;

		/* Hack -- Give the player an object */
		object_prep(q_ptr, lookup_kind(tv, sv));

		add_outfit(q_ptr);
	}
}


/*
 * Player race
 */
static bool get_player_race(void)
{
	int     k, n, cs, os;
	int		mr, i2r[MAX_RACES];
	cptr    str;
	char    c;
	char	sym[MAX_RACES];
	char    p2 = ')';
	char    buf[80], cur[80];


	/* Extra info */
#ifdef JP
	put_str("աԼ²դˤäƥ饯ŷŪʻܡʥѲޤ", 23, 5);
#else
	put_str("Note: Your 'race' determines various intrinsic factors and bonuses.", 23 ,5);
#endif

	hack_mutation = FALSE;

	/* Dump races */
	for (n = 0, mr = 0; n < MAX_RACES; n++)
	{
		/* Analyze */
		p_ptr->prace = n;
		rp_ptr = &race_info[p_ptr->prace];

		/* Hack -- ٤ʤ²can_birthե饰Ƚ */
		if (!rp_ptr->can_birth) continue;

		i2r[mr] = n;
		str = rp_ptr->title;

		/* Display */
		if (n < 26)
			sym[mr] = I2A(mr);
		else
			sym[mr] = ('A' + mr - 26);
#ifdef JP
		sprintf(buf, "%c%c%s", sym[mr], p2, str);
#else
		sprintf(buf, "%c%c %s", sym[mr], p2, str);
#endif
		put_str(buf, 12 + (mr/4), 1 + 20 * (mr%4));

		mr++;
	}

#ifdef JP
	sprintf(cur, "%c%c%s", '*', p2, "");
#else
	sprintf(cur, "%c%c %s", '*', p2, "Random");
#endif

	/* Choose */
	k = -1;
	cs = 0;
	os = mr;
	while (1)
	{
		/* Move Cursol */
		if (cs != os)
		{
			c_put_str(TERM_WHITE, cur, 12 + (os/4), 1 + 20 * (os%4));
			put_str("                                   ", 3, 40);
			if(cs == mr)
			{
#ifdef JP
				sprintf(cur, "%c%c%s", '*', p2, "");
#else
				sprintf(cur, "%c%c %s", '*', p2, "Random");
#endif
				put_str("                                   ", 4, 40);
				put_str("                                   ", 5, 40);
			}
			else
			{
				rp_ptr = &race_info[i2r[cs]];
				str = rp_ptr->title;
#ifdef JP
				sprintf(cur, "%c%c%s", sym[cs], p2, str);
				c_put_str(TERM_L_BLUE, rp_ptr->title, 3, 40);
				put_str("μ²", 3, 40+strlen(rp_ptr->title));
				put_str(" ǽ   ѵ ̥ и ", 4, 40);
#else
				sprintf(cur, "%c%c %s", sym[cs], p2, str);
				c_put_str(TERM_L_BLUE, rp_ptr->title, 3, 40);
				put_str(": Race modification", 3, 40+strlen(rp_ptr->title));
				put_str("Str  Int  Wis  Dex  Con  Chr   EXP ", 4, 40);
#endif
				sprintf(buf, "%+3d  %+3d  %+3d  %+3d  %+3d  %+3d %+4d%% ",
					rp_ptr->r_adj[0], rp_ptr->r_adj[1], rp_ptr->r_adj[2], rp_ptr->r_adj[3],
					rp_ptr->r_adj[4], rp_ptr->r_adj[5], (rp_ptr->r_exp - 100));
				c_put_str(TERM_L_BLUE, buf, 5, 40);
			}
			c_put_str(TERM_YELLOW, cur, 12 + (cs/4), 1 + 20 * (cs%4));
			os = cs;
		}

		if (k >= 0) break;

#ifdef JP
		sprintf(buf, "²ǲ (%c-%c) ('='ץ): ", sym[0], sym[mr-1]);
#else
		sprintf(buf, "Choose a race (%c-%c) ('=' for options): ", sym[0], sym[mr-1]);
#endif

		put_str(buf, 10, 10);
		c = inkey();
		if (c == '8')
		{
			if (cs >= 4) cs -= 4;
			continue;
		}
		if (c == '4')
		{
			if (cs > 0) cs--;
			continue;
		}
		if (c == '6')
		{
			if (cs < mr) cs++;
			continue;
		}
		if (c == '2')
		{
			if ((cs + 4) <= mr) cs += 4;
			continue;
		}
		if (c == ' ' || c == '\r' || c == '\n')
		{
			if(cs == mr)
			{
				k = randint0(mr);
				cs = k;
				continue;
			}
			else
			{
				k = cs;
				break;
			}
		}
		if (c == '*')
		{
			k = randint0(mr);
			cs = k;
			continue;
		}
		if (c == 'Q')
		{
			remove_loc();
			quit(NULL);
		}
		if (c == 'S') return (FALSE);
		k = (islower(c) ? A2I(c) : -1);
		if ((k >= 0) && (k < mr))
		{
			cs = k;
			continue;
		}
		k = (isupper(c) ? (26 + c - 'A') : -1);
		if ((k >= 26) && (k < mr))
		{
			cs = k;
			continue;
		}
		else k = -1;
		if (c == '?') do_cmd_help();
		else if (c == '=')
		{
			screen_save();
#ifdef JP
			do_cmd_options_aux(6, "ץ");
#else
			do_cmd_options_aux(6, "Startup Options");
#endif
			screen_load();
		}
		else bell();
	}

	/* Set race */
	p_ptr->prace = i2r[k];

	/* Give beastman a mutation at character birth */
	if (p_ptr->prace == RACE_BEASTMAN)
		hack_mutation = TRUE;

	rp_ptr = &race_info[p_ptr->prace];
	str = rp_ptr->title;

	/* Display */
#ifdef JP
	put_str("²        :", 4, 1);
#else
	put_str("Race        :", 4, 1);
#endif
	put_str("                                   ", 3, 40);
	put_str("                                   ", 4, 40);
	put_str("                                   ", 5, 40);

	c_put_str(TERM_L_BLUE, str, 4, 15);

	/* Success */
	return TRUE;
}


/*
 * Player class
 */
static bool get_player_class(void)
{
	int     k, n, cs, os;
	char    c;
	char	sym[MAX_CLASS];
	char    p2 = ')';
	char    buf[80], cur[80];
	cptr    str;


	/* Extra info */
#ifdef JP
	put_str("աԿȡդˤäƥ饯ŷŪǽϤܡʥѲޤ", 23, 5);
#else
	put_str("Note: Your 'class' determines various intrinsic abilities and bonuses.", 23, 5);
#endif

#ifdef JP
	put_str("()ǰϤޤ줿Ϥμ²ˤϻʤȤǤ", 11, 10);
#else
	put_str("Any entries in parentheses should only be used by advanced players.", 11, 5);
#endif


	/* Dump classes */
	for (n = 0; n < MAX_CLASS; n++)
	{
		/* Analyze */
		p_ptr->pclass = n;
		cp_ptr = &class_info[p_ptr->pclass];
		mp_ptr = &m_info[p_ptr->pclass];
		str = cp_ptr->title;
		if (n < 26)
			sym[n] = I2A(n);
		else
			sym[n] = ('A' + n - 26);

		/* Display */
		if (!(rp_ptr->choice & (1L << n)))
#ifdef JP
			sprintf(buf, "%c%c(%s)", sym[n], p2, str);
#else
			sprintf(buf, "%c%c (%s)", sym[n], p2, str);
#endif
		else
#ifdef JP
			sprintf(buf, "%c%c%s", sym[n], p2, str);
#else
			sprintf(buf, "%c%c %s", sym[n], p2, str);
#endif

		put_str(buf, 13+ (n/4), 2 + 19 * (n%4));
	}

#ifdef JP
	sprintf(cur, "%c%c%s", '*', p2, "");
#else
	sprintf(cur, "%c%c %s", '*', p2, "Random");
#endif

	/* Get a class */
	k = -1;
	cs = 0;
	os = MAX_CLASS;
	while (1)
	{
		/* Move Cursol */
		if (cs != os)
		{
			c_put_str(TERM_WHITE, cur, 13 + (os/4), 2 + 19 * (os%4));
			put_str("                                   ", 3, 40);
			if(cs == MAX_CLASS)
			{
#ifdef JP
				sprintf(cur, "%c%c%s", '*', p2, "");
#else
				sprintf(cur, "%c%c %s", '*', p2, "Random");
#endif
				put_str("                                   ", 4, 40);
				put_str("                                   ", 5, 40);
			}
			else
			{
				cp_ptr = &class_info[cs];
				mp_ptr = &m_info[cs];
				str = cp_ptr->title;
				if (!(rp_ptr->choice & (1L << cs)))
#ifdef JP
					sprintf(cur, "%c%c(%s)", sym[cs], p2, str);
#else
					sprintf(cur, "%c%c (%s)", sym[cs], p2, str);
#endif
				else
#ifdef JP
					sprintf(cur, "%c%c%s", sym[cs], p2, str);
#else
					sprintf(cur, "%c%c %s", sym[cs], p2, str);
#endif
#ifdef JP
					c_put_str(TERM_L_BLUE, cp_ptr->title, 3, 40);
					put_str("οȽ", 3, 40+strlen(cp_ptr->title));
					put_str(" ǽ   ѵ ̥ и ", 4, 40);
#else
					c_put_str(TERM_L_BLUE, cp_ptr->title, 3, 40);
					put_str(": Class modification", 3, 40+strlen(cp_ptr->title));
					put_str("Str  Int  Wis  Dex  Con  Chr   EXP ", 4, 40);
#endif
					sprintf(buf, "%+3d  %+3d  %+3d  %+3d  %+3d  %+3d %+4d%% ",
						cp_ptr->c_adj[0], cp_ptr->c_adj[1], cp_ptr->c_adj[2], cp_ptr->c_adj[3],
						cp_ptr->c_adj[4], cp_ptr->c_adj[5], cp_ptr->c_exp);
					c_put_str(TERM_L_BLUE, buf, 5, 40);
			}
			c_put_str(TERM_YELLOW, cur, 13 + (cs/4), 2 + 19 * (cs%4));
			os = cs;
		}

		if (k >= 0) break;

#ifdef JP
		sprintf(buf, "Ȥǲ (%c-%c) ('='ץ): ", sym[0], sym[MAX_CLASS-1]);
#else
		sprintf(buf, "Choose a class (%c-%c) ('=' for options): ",  sym[0], sym[MAX_CLASS-1]);
#endif

		put_str(buf, 10, 10);
		c = inkey();
		if (c == '8')
		{
			if (cs >= 4) cs -= 4;
			continue;
		}
		if (c == '4')
		{
			if (cs > 0) cs--;
			continue;
		}
		if (c == '6')
		{
			if (cs < MAX_CLASS) cs++;
			continue;
		}
		if (c == '2')
		{
			if ((cs + 4) <= MAX_CLASS) cs += 4;
			continue;
		}
		if (c == ' ' || c == '\r' || c == '\n')
		{
			if(cs == MAX_CLASS)
			{
				k = randint0(MAX_CLASS);
				cs = k;
				continue;
			}
			else
			{
				k = cs;
				break;
			}
		}
		if (c == '*')
		{
			k = randint0(MAX_CLASS);
			break;
		}
		if (c == 'Q')
		{
			remove_loc();
			quit(NULL);
		}
		if (c == 'S') return (FALSE);
		k = (islower(c) ? A2I(c) : -1);
		if ((k >= 0) && (k < MAX_CLASS))
		{
			cs = k;
			continue;
		}
		k = (isupper(c) ? (26 + c - 'A') : -1);
		if ((k >= 26) && (k < MAX_CLASS))
		{
			cs = k;
			continue;
		}
		else k = -1;
		if (c == '?') do_cmd_help();
		else if (c == '=')
		{
			screen_save();
#ifdef JP
			do_cmd_options_aux(6, "ץ");
#else
			do_cmd_options_aux(6, "Startup Options");
#endif

			screen_load();
		}
		else bell();
	}

	/* Set class */
	p_ptr->pclass = k;
	cp_ptr = &class_info[p_ptr->pclass];
	mp_ptr = &m_info[p_ptr->pclass];
	str = cp_ptr->title;

	/* Display */
#ifdef JP
	put_str("        :", 5, 1);
#else
	put_str("Class       :", 5, 1);
#endif

#ifdef JP
	c_put_str(TERM_L_BLUE, str, 5, 15);
#else
	c_put_str(TERM_L_BLUE, cp_ptr->title, 5, 15);
#endif
	put_str("                                   ", 3, 40);
	put_str("                                   ", 4, 40);
	put_str("                                   ", 5, 40);

	return TRUE;
}

static bool do_quick_start = FALSE;
static int number_of_rquests = 0;

/*
 * Helper function for 'player_birth()'.
 *
 * This function allows the player to select a sex, race, and class, and
 * modify options (including the birth options).
 */
static bool player_birth_aux_1(void)
{
	int k, n, cs, os;
	char ch;
	char p2 = ')';
	char buf[80], cur[80];
	char inp[80];
	char c;

	/*** Instructions ***/

	/* Clear screen */
	Term_clear();

	/* Display some helpful information */
#ifdef JP
	put_str("饯ޤ('S'ľ, 'Q'λ, '?'إ)", 8, 10);
#else
	put_str("Make your charactor. ('S' Restart, 'Q' Quit, '?' Help)", 8, 10);
#endif


	/*** Quick Start ***/

	if (previous_char.quick_ok)
	{
		do_quick_start = FALSE;

		/* Extra info */
#ifdef JP
		put_str("åȤȤȰƱ饯ǻϤޤ", 11, 5);
#else
		put_str("Do you want to use the quick start function(same character as your last one).", 11, 2);
#endif

		/* Choose */
		while (1)
		{
#ifdef JP
			put_str("åȤȤޤ[y/n]", 14, 10);
#else
			put_str("Use quick start? [y/n]", 14, 10);
#endif
			c = inkey();
			if (c == 'Q') quit(NULL);
			else if (c == 'S') return (FALSE);
			else if ((c == 'y') || (c == 'Y'))
			{
				do_quick_start = TRUE;
				break;
			}
			else
			{
				do_quick_start = FALSE;
				break;
			}
		}

		if (do_quick_start)
		{
			load_prev_data(FALSE);
			init_dungeon_quests(previous_char.quests);
			init_turn();

			/* Calc hitdie, but don't roll */
			get_extra(FALSE);

			sp_ptr = &sex_info[p_ptr->psex];
			rp_ptr = &race_info[p_ptr->prace];
			cp_ptr = &class_info[p_ptr->pclass];
			mp_ptr = &m_info[p_ptr->pclass];

			/* Snatcher */
			if (p_ptr->pclass == CLASS_SNATCHER) set_first_monster_race();

			/* Calculate the bonuses and hitpoints */
			p_ptr->update |= (PU_BONUS | PU_HP);

			/* Update stuff */
			update_stuff();

			/* Fully healed */
			p_ptr->chp = p_ptr->mhp;

			/* Fully rested */
			p_ptr->csp = p_ptr->msp;

			/* Process the player name */
			process_player_name(FALSE);

			return TRUE;
		}

		/* Clean up */
		clear_from(10);
	}


	/*** Player sex ***/

	/* Extra info */
#ifdef JP
	put_str("ա̡դΰ㤤ϥۤȤɱƶڤܤޤ", 23, 5);
#else
	put_str("Note: Your 'sex' does not have any significant gameplay effects.", 23, 5);
#endif


	/* Prompt for "Sex" */
	for (n = 0; n < MAX_SEXES; n++)
	{
		/* Analyze */
		p_ptr->psex = n;
		sp_ptr = &sex_info[p_ptr->psex];

		/* Display */
#ifdef JP
		sprintf(buf, "%c%c%s", I2A(n), p2, sp_ptr->title);
#else
		sprintf(buf, "%c%c %s", I2A(n), p2, sp_ptr->title);
#endif

		put_str(buf, 12 + (n/5), 2 + 15 * (n%5));
	}

#ifdef JP
	sprintf(cur, "%c%c%s", '*', p2, "");
#else
	sprintf(cur, "%c%c %s", '*', p2, "Random");
#endif

	/* Choose */
	k = -1;
	cs = 0;
	os = MAX_SEXES;
	while (1)
	{
		if (cs != os)
		{
			put_str(cur, 12 + (os/5), 2 + 15 * (os%5));
			if(cs == MAX_SEXES)
#ifdef JP
				sprintf(cur, "%c%c%s", '*', p2, "");
#else
				sprintf(cur, "%c%c %s", '*', p2, "Random");
#endif
			else
			{
				sp_ptr = &sex_info[cs];
#ifdef JP
				sprintf(cur, "%c%c%s", I2A(cs), p2, sp_ptr->title);
#else
				sprintf(cur, "%c%c %s", I2A(cs), p2, sp_ptr->title);
#endif
			}
			c_put_str(TERM_YELLOW, cur, 12 + (cs/5), 2 + 15 * (cs%5));
			os = cs;
		}

		if (k >= 0) break;

#ifdef JP
		sprintf(buf, "̤ǲ (%c-%c) '*'ǥ, '='ǽץ: ", I2A(0), I2A(n-1));
#else
		sprintf(buf, "Choose a sex (%c-%c), * for random, or = for options: ", I2A(0), I2A(n-1));
#endif

		put_str(buf, 10, 10);
		ch = inkey();
		if (ch == '4')
		{
			if (cs > 0) cs--;
			continue;
		}
		if (ch == '6')
		{
			if (cs < MAX_SEXES) cs++;
			continue;
		}
		if (ch == ' ' || ch == '\r' || ch == '\n')
		{
			if(cs == MAX_SEXES)
				k = randint0(MAX_SEXES);
			else
				k = cs;
			break;
		}
		if (ch == '*')
		{
			k = randint0(MAX_SEXES);
			break;
		}
		if (ch == 'Q')
		{
			remove_loc();
			quit(NULL);
		}
		if (ch == 'S') return (FALSE);

		k = (islower(ch) ? A2I(ch) : -1);
		if ((k >= 0) && (k < MAX_SEXES))
		{
			cs = k;
			continue;
		}
		else k = -1;
		if (ch == '?') do_cmd_help();
		else if (ch == '=')
		{
			screen_save();
#ifdef JP
			do_cmd_options_aux(6, "ץ");
#else
			do_cmd_options_aux(6, "Startup Options");
#endif

			screen_load();
		}
		else bell();
	}

	/* Set sex */
	p_ptr->psex = k;
	sp_ptr = &sex_info[p_ptr->psex];

	/* Sex */
#ifdef JP
	put_str("        :", 3, 1);
#else
	put_str("Sex         :", 3, 1);
#endif

	c_put_str(TERM_L_BLUE, sp_ptr->title, 3, 15);

	/* Clean up */
	clear_from(10);

	/* Choose the players race */
	if (!get_player_race()) return FALSE;

	/* Clean up */
	clear_from(10);

	/* Choose the players class */
	if (!get_player_class()) return FALSE;

	/* Clean up */
	clear_from(10);

	/* Choose the magic realms */
	if (!get_player_realms()) return FALSE;

	/* Clear */
	clear_from(10);

	/*** User enters number of quests ***/
	/* Heino Vander Sanden and Jimmy De Laet */

	/* Extra info */
#ifdef JP
	put_str("ɬܤΥ(ڤ̽르)˲äơɲäΥȤ", 10, 5);
	put_str("ꤹ뤳Ȥޤ", 11, 5);
	put_str("ɲåȤԤʤʤ '0'ϤƲ", 12, 5);
	put_str("˷ꤹˤ'*'ϤƲ", 13, 5);
#else
	put_str("You can enter the number of quests you'd like to perform in addition", 10, 5);
	put_str("to the two obligatory ones ( Sauron and Mrogoth, Lord of Darkness )", 11, 5);
	put_str("In case you do not want any additional quests, just enter 0", 12, 5);
	put_str("If you want a random number of random quests, just enter *", 13, 5);
#endif


	/* Ask the number of additional quests */
	while (TRUE)
	{

#ifdef JP
		put_str(format("ɲåȤο (%uʲ) ", MAX_RANDOM_QUEST - MIN_RANDOM_QUEST + 1), 15, 5);
#else
		put_str(format("Number of additional quests? (<%u) ", MAX_RANDOM_QUEST - MIN_RANDOM_QUEST + 2), 15, 5);
#endif


		/* Get a the number of additional quest */
		while (TRUE)
		{
			/* Move the cursor */
			put_str("", 15, 40);

			/* Default */
			strcpy(inp, "10");

			/* Get a response (or escape) */
			if (!askfor_aux(inp, 2, FALSE)) strcpy(inp, "10");

			/* Quit */
			if (inp[0] == 'Q')
			{
				remove_loc();
				quit(NULL);
			}

			/* Start over */
			if (inp[0] == 'S') return (FALSE);

			/* Check for random number of quests */
			if (inp[0] == '*')
			{
				/* 0 to 10 random quests */
				number_of_rquests = randint0(11);
			}
			else
			{
				number_of_rquests = atoi(inp);
			}

			/* Break on valid input */
			if ((number_of_rquests <= MAX_RANDOM_QUEST - MIN_RANDOM_QUEST + 1) && (number_of_rquests >= 0)) break;
		}
		break;
	}

	/* Clear */
	clear_from(10);

	/* Reset turn; before auto-roll and after choosing race */
	init_turn();

	/* Done */
	return (TRUE);
}


/*
 * Initial stat costs (initial stats always range from 10 to 18 inclusive).
 */
static int birth_stat_costs[(18-10)+1] = { 0, 1, 2, 4, 7, 11, 16, 22, 30 };


/*
 * Helper function for 'player_birth()'.
 *
 * This function handles "point-based" character creation.
 *
 * The player selects, for each stat, a value from 10 to 18 (inclusive),
 * each costing a certain amount of points (as above), from a pool of 48
 * available points, to which race/class modifiers are then applied.
 *
 * Each unused point is converted into 100 gold pieces.
 */
static bool player_birth_aux_2(void)
{
	int i;
	int row = 3;
	int col = 42;
	int stat = 0;
	int stats[A_MAX];
	int cost;
	char ch;
	char buf[80];


	/* Initialize stats */
	for (i = 0; i < A_MAX; i++)
	{
		/* Initial stats */
		stats[i] = 10;
	}


	/* Roll for base hitpoints */
	get_extra(TRUE);

	/* Roll for age/height/weight */
	get_ahw(TRUE);

	/* Roll for social class */
	get_history();
	
	/* Hack -- get a chaos patron even if you are not a chaos warrior */
	p_ptr->chaos_patron = 0;

	/* Interact */
	while (1)
	{
		/* Reset cost */
		cost = 0;

		/* Process stats */
		for (i = 0; i < A_MAX; i++)
		{
			/* Variable stat maxes */
			if (maximize_mode)
			{
				/* Reset stats */
				p_ptr->stat_cur[i] = p_ptr->stat_max[i] = stats[i];

			}

			/* Fixed stat maxes */
			else
			{
				/* Obtain a "bonus" for "race" and "class" */
				int bonus = rp_ptr->r_adj[i] + cp_ptr->c_adj[i];

				/* Apply the racial/class bonuses */
				p_ptr->stat_cur[i] = p_ptr->stat_max[i] =
					modify_stat_value(stats[i], bonus);
			}

			/* Total cost */
			cost += birth_stat_costs[stats[i] - 10];
		}

		/* Restrict cost */
		if (cost > 48)
		{
			/* Warning */
			bell();

			/* Reduce stat */
			stats[stat]--;

			/* Recompute costs */
			continue;
		}

		/* Gold is inversely proportional to cost */
		p_ptr->au = (100 * (48 - cost)) + 100;

		/* Calculate the bonuses and hitpoints */
		p_ptr->update |= (PU_BONUS | PU_HP);

		/* Update stuff */
		update_stuff();

		/* Fully healed */
		p_ptr->chp = p_ptr->mhp;

		/* Fully rested */
		p_ptr->csp = p_ptr->msp;

		/* Display the player */
		display_player(0);

		/* Display the costs header */
#ifdef JP
		put_str("", row - 1, col + 32);
#else
		put_str("Cost", row - 1, col + 32);
#endif

		/* Display the costs */
		for (i = 0; i < A_MAX; i++)
		{
			/* Display cost */
			sprintf(buf, "%4d", birth_stat_costs[stats[i] - 10]);
			put_str(buf, row + i, col + 32);
		}


		/* Prompt XXX XXX XXX */
#ifdef JP
		sprintf(buf, "ȹ: %2d/48  2/8 ǰư,  4/6 ѹ,  ESC ǽλ", cost);
#else
		sprintf(buf, "Total Cost %2d/48.  Use 2/8 to move, 4/6 to modify, ESC to accept.", cost);
#endif
		prt(buf, 0, 0);

		/* Place cursor just after cost of current stat */
		Term_gotoxy(col + 36, row + stat);

		/* Get key */
		ch = inkey();

		/* Quit */
		if (ch == 'Q') quit(NULL);

		/* Start over */
		if (ch == 'S') return (FALSE);

		/* Done */
		if (ch == ESCAPE) break;

		/* Prev stat */
		if (ch == '8')
		{
			stat = (stat + 5) % 6;
		}

		/* Next stat */
		if (ch == '2')
		{
			stat = (stat + 1) % 6;
		}

		/* Decrease stat */
		if ((ch == '4') && (stats[stat] > 10))
		{
			stats[stat]--;
		}

		/* Increase stat */
		if ((ch == '6') && (stats[stat] < 18))
		{
			stats[stat]++;
		}
	}


	/* Done */
	return (TRUE);
}

#ifdef JP
/* ʸsxХܤ1ХܤɤȽꤹ */
static bool iskanji2(cptr s, int x)
{
	int i;

	for (i = 0; i < x; i++)
	{
		if (iskanji(s[i])) i++;
	}
	if ((x == i) && iskanji(s[x])) return TRUE;

	return FALSE;
}
#endif

/*
 *  Character background edit-mode
 */
static void edit_history(void)
{
	char old_history[4][60];
	int y = 0, x = 0;
	int i, j;

	/* Edit character background */
	for (i = 0; i < 4; i++)
	{
		sprintf(old_history[i], "%s", history[i]);
	}
	/* Turn 0 to space */
	for (i = 0; i < 4; i++)
	{
		for (j = 0; history[i][j]; j++) /* loop */;

		for (; j < 59; j++) history[i][j] = ' ';
		history[i][59] = '\0';
	}
	display_player(1);
#ifdef JP
	c_put_str(TERM_L_GREEN, "(饯Ω - Խ⡼)", 11, 20);
	put_str("[ 륭ǰưEnterǽλ ]", 17, 23);
#else
	c_put_str(TERM_L_GREEN, "(Character Background - Edit Mode)", 11, 20);
	put_str("[ Cursor key for Move, Enter for End ]", 17, 21);
#endif

	while (TRUE)
	{
		int skey;
		char c;

		for (i = 0; i < 4; i++)
		{
			put_str(history[i], i + 12, 10);
		}
#ifdef JP
		if (iskanji2(history[y], x))
			c_put_str(TERM_L_BLUE, format("%c%c", history[y][x],history[y][x+1]), y + 12, x + 10);
		else
#endif
		c_put_str(TERM_L_BLUE, format("%c", history[y][x]), y + 12, x + 10);

		/* Place cursor just after cost of current stat */
		Term_gotoxy(x + 10, y + 12);

		/* Get special key code */
		skey = inkey_special(TRUE);

		/* Get a character code */
		if (!(skey & SKEY_MASK)) c = (char)skey;
		else c = 0;

		if (skey == SKEY_UP || c == KTRL('p'))
		{
			y--;
			if (y < 0) y = 3;
#ifdef JP
			if ((x > 0) && (iskanji2(history[y], x-1))) x--;
#endif
		}
		else if (skey == SKEY_DOWN || c == KTRL('n'))
		{
			y++;
			if (y > 3) y = 0;
#ifdef JP
			if ((x > 0) && (iskanji2(history[y], x-1))) x--;
#endif
		}
		else if (skey == SKEY_RIGHT || c == KTRL('f'))
		{
#ifdef JP
			if (iskanji2(history[y], x)) x++;
#endif
			x++;
			if (x > 58)
			{
				x = 0;
				if (y < 3) y++;
			}
		}
		else if (skey == SKEY_LEFT || c == KTRL('b'))
		{
			x--;
			if (x < 0)
			{
				if (y)
				{
					y--;
					x = 58;
				}
				else x = 0;
			}

#ifdef JP
			if ((x > 0) && (iskanji2(history[y], x-1))) x--;
#endif
		}
		else if (c == '\r' || c == '\n')
		{
			Term_erase(0, 11, 255);
			Term_erase(0, 17, 255);
#ifdef JP
			put_str("(饯Ω - ԽѤ)", 11, 20);
#else
			put_str("(Character Background - Edited)", 11, 20);
#endif
			break;
		}
		else if (c == ESCAPE)
		{
			clear_from(11);
#ifdef JP
			put_str("(饯Ω)", 11, 25);
#else
			put_str("(Character Background)", 11, 25);
#endif

			for (i = 0; i < 4; i++)
			{
				sprintf(history[i], "%s", old_history[i]);
				put_str(history[i], i + 12, 10);
			}
			break;
		}
		else if (c == '\010')
		{
			x--;
			if (x < 0)
			{
				if (y)
				{
					y--;
					x = 58;
				}
				else x = 0;
			}

			history[y][x] = ' ';
#ifdef JP
			if ((x > 0) && (iskanji2(history[y], x - 1)))
			{
				x--;
				history[y][x] = ' ';
			}
#endif
		}
#ifdef JP
		else if (iskanji(c) || isprint(c))
#else
		else if (isprint(c)) /* BUGFIX */
#endif
		{
#ifdef JP
			if (iskanji2(history[y], x))
			{
				history[y][x+1] = ' ';
			}

			if (iskanji(c))
			{
				if (x > 57)
				{
					x = 0;
					y++;
					if (y > 3) y = 0;
				}

				if (iskanji2(history[y], x+1))
				{
					history[y][x+2] = ' ';
				}

				history[y][x++] = c;

				c = inkey();
			}
#endif
			history[y][x++] = c;
			if (x > 58)
			{
				x = 0;
				y++;
				if (y > 3) y = 0;
			}
		}
	} /* while (TRUE) */

}


/*
 * Helper function for 'player_birth()'.
 *
 * This function handles "auto-rolling" and "random-rolling".
 *
 * The delay may be reduced, but is recommended to keep players
 * from continuously rolling up characters, which can be VERY
 * expensive CPU wise.  And it cuts down on player stupidity.
 */
static bool player_birth_aux_3(void)
{
	int i, j, m, cs, os;
	int cval[A_MAX];
	
	bool flag;
	bool prev = FALSE;
	
	char ch;
	
	char b1 = '[';
	char b2 = ']';
	
	char buf[80], cur[80];
	char inp[80];
	
	
#ifdef ALLOW_AUTOROLLER
	
	s16b stat_limit[A_MAX];
	
	s32b stat_match[A_MAX];
	
	s32b auto_round = 0L;
	
	
	/*** Autoroll ***/
	
	/* Initialize */
	if (autoroller)
	{
		/* Clean up */
		clear_from(10);
		
		/* Extra info */
#ifdef JP
		put_str("ǽͤꤷƲ", 10, 15);
		put_str("2/8ǹ4/6ͤEnterǼ", 11, 15);
#else
		put_str("Set minimum stats.", 10, 15);
		put_str("2/8 for Select, 4/6 for Change value, Enter for Goto next", 11, 15);
#endif
		
#ifdef JP
		put_str("           ²        ", 13, 15);
#else
		put_str("           Base   Rac  Cla      Total  Maximum", 13, 15);
#endif
		
		/* Output the maximum stats */
		for (i = 0; i < A_MAX; i++)
		{
			/* Reset the "success" counter */
			stat_match[i] = 0;
			cval[i] = 3;
			
			/* Race/Class bonus */
			j = rp_ptr->r_adj[i] + cp_ptr->c_adj[i];
			
			/* Obtain the "maximal" stat */
			m = adjust_stat(17, j, TRUE);
			
			/* Above 18 */
			if (m > 18)
			{
#ifdef JP
				sprintf(cur, "18/%02d", (m - 18));
#else
				sprintf(cur, "18/%02d", (m - 18));
#endif
			}
			
			/* From 3 to 18 */
			else
			{
#ifdef JP
				sprintf(cur, "%2d", m);
#else
				sprintf(cur, "%2d", m);
#endif
			}
			
			/* Obtain the current stat */
			m = adjust_stat(cval[i], j, TRUE);
			
			/* Above 18 */
			if (m > 18)
			{
#ifdef JP
				sprintf(inp, "18/%02d", (m - 18));
#else
				sprintf(inp, "18/%02d", (m - 18));
#endif
			}
			
			/* From 3 to 18 */
			else
			{
#ifdef JP
				sprintf(inp, "%2d", m);
#else
				sprintf(inp, "%2d", m);
#endif
			}
			
			/* Prepare a prompt */
			sprintf(buf, "%6s       %2d   %+3d  %+3d  =  %6s  %6s",
				stat_names[i], cval[i], rp_ptr->r_adj[i], cp_ptr->c_adj[i], inp, cur);
			
			/* Dump the prompt */
			put_str(buf, 14 + i, 15);
		}
		
		/* Get a minimum stat */
		cs = 0;
		os = A_MAX;
		while (TRUE)
		{
			/* Move Cursol */
			if (cs != os)
			{
				if(os == A_MAX)
				{
#ifdef JP
					c_put_str(TERM_WHITE, "ꤹ", 21, 35);
#else
					c_put_str(TERM_WHITE, "Accept", 21, 35);
#endif
				}
				else if(os < 6)
					c_put_str(TERM_WHITE, cur, 14 + os, 15);
				
				if(cs == 6)
				{
#ifdef JP
					c_put_str(TERM_YELLOW, "ꤹ", 21, 35);
#else
					c_put_str(TERM_YELLOW, "Accept", 21, 35);
#endif
				}
				else
				{
					/* Race/Class bonus */
					j = rp_ptr->r_adj[cs] + cp_ptr->c_adj[cs];
					
					/* Obtain the current stat */
					m = adjust_stat(cval[cs], j, TRUE);
					
					/* Above 18 */
					if (m > 18)
					{
#ifdef JP
						sprintf(inp, "18/%02d", (m - 18));
#else
						sprintf(inp, "18/%02d", (m - 18));
#endif
					}
					
					/* From 3 to 18 */
					else
					{
#ifdef JP
						sprintf(inp, "%2d", m);
#else
						sprintf(inp, "%2d", m);
#endif
					}
					
					/* Prepare a prompt */
					sprintf(cur, "%6s       %2d   %+3d  %+3d  =  %6s",
						stat_names[cs], cval[cs], rp_ptr->r_adj[cs],
						cp_ptr->c_adj[cs], inp);
					c_put_str(TERM_YELLOW, cur, 14 + cs, 15);
				}
				os = cs;
			}
			
			/* Prompt for the minimum stats */
			ch = inkey();
			switch (ch) {
			case 'Q':
				remove_loc();
				quit(NULL);
				break;
			case 'S':
				return (FALSE);
			case ESCAPE:
				break;
			case ' ':
			case '\r':
			case '\n':
				if(cs < A_MAX)
				{
					ch = '2';
					cs++;
				}
				else ch = ' ';
				break;
			case '8':
			case 'k':
				if (cs > 0) cs--;
				break;
			case '2':
			case 'j':
				if (cs < A_MAX) cs++;
				break;
			case '4':
			case 'h':
				if (cs != A_MAX)
				{
					if (cval[cs] == 3)
					{
						cval[cs] = 17;
						os = 7;
					}
					else if (cval[cs] > 3)
					{
						cval[cs]--;
						os = 7;
					}
					else return FALSE;
				}
				break;
			case '6':
			case 'l':
				if (cs != A_MAX)
				{
					if (cval[cs] == 17)
					{
						cval[cs] = 3;
						os = 7;
					}
					else if (cval[cs] < 17)
					{
						cval[cs]++;
						os = 7;
					}
					else return FALSE;
				}
				break;
			case 'm':
				if(cs != 6)
				{
					cval[cs] = 17;
					os = 7;
				}
				break;
			case 'n':
				if(cs != 6)
				{
					cval[cs] = 3;
					os = 7;
				}
				break;
			case '?':
				do_cmd_help();
				break;
			case '=':
				screen_save();
#ifdef JP
				do_cmd_options_aux(6, "ץ((*)ϥ˱ƶ)");
#else
				do_cmd_options_aux(6, "Startup Opts((*)s effect score)");
#endif
				screen_load();
				break;
			default:
				bell();
				break;
			}
			if(ch == ESCAPE || (ch == ' ' && cs == A_MAX)) break;
		}
	}
	
	for (i = 0; i < 6; i++)
	{
		/* Save the minimum stat */
		stat_limit[i] = cval[i];
	}
	
#endif /* ALLOW_AUTOROLLER */
	
	/* Clean up */
	clear_from(10);
	
	
	/*** Generate ***/
	
	/* Roll */
	while (TRUE)
	{
		int col = 42;
		
		/* Feedback */
		if (autoroller)
		{
			Term_clear();
			
			/* Label */
#ifdef JP
			put_str("Ǿ", 2, col+5);
#else
			put_str(" Limit", 2, col+5);
#endif
			
			
			/* Label */
#ifdef JP
			put_str("Ψ", 2, col+13);
#else
			put_str("  Freq", 2, col+13);
#endif
			
			
			/* Label */
#ifdef JP
			put_str("", 2, col+24);
#else
			put_str("  Roll", 2, col+24);
#endif
			
			
			/* Put the minimal stats */
			for (i = 0; i < A_MAX; i++)
			{
				/* Label stats */
				put_str(stat_names[i], 3+i, col);
				
				/* Race/Class bonus */
				j = rp_ptr->r_adj[i] + cp_ptr->c_adj[i];

				/* Obtain the current stat */
				m = adjust_stat(stat_limit[i], j, TRUE);

				/* Put the stat */
				cnv_stat(m, buf);
				c_put_str(TERM_L_BLUE, buf, 3+i, col+5);
			}
			
			/* Label count */
#ifdef JP
			put_str(" :", 10, col+13);
#else
			put_str("Round:", 10, col+13);
#endif
			
			
			/* Indicate the state */
#ifdef JP
			put_str("(ESC)", 12, col+13);
#else
			put_str("(Hit ESC to stop)", 12, col+13);
#endif
			
			
			/* Auto-roll */
			while (1)
			{
				bool accept = TRUE;
				
				/* Get a new character */
				get_stats();
				
				/* Advance the round */
				auto_round++;
				
				/* Hack -- Prevent overflow */
				if (auto_round >= 1000000000L)
				{
					auto_round = 1;
					
					if (autoroller)
					{
						for( i = 0; i < 6; i ++)
						{
							stat_match[i] = 0;
						}
					}
				}
				
				/* Check and count acceptable stats */
				for (i = 0; i < A_MAX; i++)
				{
					/* This stat is okay */
					if (p_ptr->stat_max[i] >= stat_limit[i])
					{
						stat_match[i]++;
					}
					
					/* This stat is not okay */
					else
					{
						accept = FALSE;
					}
				}
				
				/* Break if "happy" */
				if (accept) break;
				
				/* Take note every 25 rolls */
				flag = (!(auto_round % AUTOROLLER_STEP));
				
				/* Update display occasionally */
				if (flag)
				{
					/* Put the stats (and percents) */
					for (i = 0; i < A_MAX; i++)
					{
						/* Put the stat */
						cnv_stat(p_ptr->stat_max[i], buf);
						c_put_str(TERM_L_GREEN, buf, 3+i, col+24);
						
						/* Put the percent */
						if (stat_match[i])
						{
							int p;
							byte attr;
							if (stat_match[i] > 1000000L)
							{
								/* Prevent overflow */
								p = stat_match[i] / (auto_round / 1000L);
							}
							else
							{
								p = 1000L * stat_match[i] / auto_round;
							}

							attr = (p < 100) ? TERM_YELLOW : TERM_L_GREEN;
							sprintf(buf, "%3d.%d%%", p/10, p%10);
							c_put_str(attr, buf, 3+i, col+13);
						}
						
						/* Never happened */
						else
						{
#ifdef JP
							c_put_str(TERM_RED, "(ʤ)", 3+i, col+13);
#else
							c_put_str(TERM_RED, "(NONE)", 3+i, col+13);
#endif
						}
					}
					
					/* Dump round */
					put_str(format("%10ld", auto_round), 10, col+20);
					
					/* Make sure they see everything */
					Term_fresh();
					
					/* Delay 1/10 second */
					if (delay_autoroll) Term_xtra(TERM_XTRA_DELAY, 100);
					
					/* Do not wait for a key */
					inkey_scan = TRUE;
					
					/* Check for a keypress */
					if (inkey()) break;
				}
			}
		}
		
		/* Otherwise just get a character */
		else
		{
			/* Get a new character */
			get_stats();
		}
		
		/* Flush input */
		flush();
		
		/*** Display ***/
		
		/* Roll for base hitpoints */
		get_extra(TRUE);
		
		/* Roll for age/height/weight */
		get_ahw(TRUE);
		
		/* Roll for social class */
		get_history();
		
		/* Roll for gold */
		get_money();
		
		/* Hack -- get a chaos patron even if you are not a chaos warrior */
		p_ptr->chaos_patron = 0;
		
		/* Input loop */
		while (TRUE)
		{
			/* Calculate the bonuses and hitpoints */
			p_ptr->update |= (PU_BONUS | PU_HP);
			
			/* Update stuff */
			update_stuff();
			
			/* Fully healed */
			p_ptr->chp = p_ptr->mhp;
			
			/* Fully rested */
			p_ptr->csp = p_ptr->msp;
			
			/* Display the player */
			display_player(0);
			
			/* Prepare a prompt (must squeeze everything in) */
			Term_gotoxy(2, 23);
			Term_addch(TERM_WHITE, b1);
#ifdef JP
			Term_addstr(-1, TERM_WHITE, "'r'Ǽο");
#else
			Term_addstr(-1, TERM_WHITE, "'r' to reroll");
#endif
			
#ifdef JP
			if (prev) Term_addstr(-1, TERM_WHITE, ", 'p'ο");
#else
			if (prev) Term_addstr(-1, TERM_WHITE, ", 'p' for prev");
#endif
			
#ifdef JP
			Term_addstr(-1, TERM_WHITE, ", EnterǤοͤ˷");
#else
			Term_addstr(-1, TERM_WHITE, ", or Enter to accept");
#endif
			
			Term_addch(TERM_WHITE, b2);
			
			/* Prompt and get a command */
			ch = inkey();
			
			/* Quit */
			if (ch == 'Q') quit(NULL);
			
			/* Start over */
			if (ch == 'S') return (FALSE);
			
			/* Escape accepts the roll */
			if (ch == ESCAPE || ch == '\r' || ch == '\n') break;
			
			/* Reroll this character */
			if ((ch == ' ') || (ch == 'r')) break;
			
			/* Previous character */
			if (prev && (ch == 'p'))
			{
				load_prev_data(TRUE);
				continue;
			}
			
			/* Help */
			if (ch == '?')
			{
				do_cmd_help();
				continue;
			}
			else if (ch == '=')
			{
				screen_save();
#ifdef JP
				do_cmd_options_aux(6, "ץ");
#else
				do_cmd_options_aux(6, "Startup Options");
#endif
				
				screen_load();
				continue;
			}
			
			/* Warning */
			bell();
		}
		
		/* Are we done? */
		if (ch == ESCAPE || ch == '\r' || ch == '\n') break;
		
		/* Save this for the "previous" character */
		save_prev_data(&previous_char);
		previous_char.quick_ok = FALSE;
		
		/* Note that a previous roll exists */
		prev = TRUE;
	}
	
	/* Clear prompt */
	clear_from(23);
	
	/* Done */
	return (TRUE);
}


static bool player_birth_aux(void)
{
	char ch;

	/* Ask questions */
	if (!player_birth_aux_1()) return FALSE;
	if (do_quick_start) return TRUE;

	/* Point based */
	if (point_based)
	{
		if (!player_birth_aux_2()) return FALSE;
	}

	/* Auto-roll */
	else
	{
		if (!player_birth_aux_3()) return FALSE;
	}

	/*** Edit character background ***/
	edit_history();

	/* Get a name, prepare savefile */
	get_character_name();

	/* Display the player */
	display_player(0);

	/* Prompt for it */
#ifdef JP
	prt("[ 'Q' , 'S' ǽᤫ, Enter ǥ೫ ]", 23, 14);
#else
	prt("['Q' to suicide, 'S' to start over, or Enter to continue]", 23, 10);
#endif


	/* Get a key */
	ch = inkey();

	/* Quit */
	if (ch == 'Q') quit(NULL);

	/* Start over */
	if (ch == 'S') return (FALSE);

	init_dungeon_quests(number_of_rquests);

	/* Save character data for quick start */
	save_prev_data(&previous_char);
	previous_char.quests = (byte)number_of_quests();
	previous_char.quick_ok = TRUE;

	/* Accept */
	return (TRUE);
}


/*
 * Create a new character.
 *
 * Note that we may be called with "junk" leftover in the various
 * fields, so we must be sure to clear them first.
 */
void player_birth(void)
{
	int i, j;


	/* Initialize Playtime */
	playtime = 0;

	/* Create a new character */
	while (1)
	{
		/* Wipe the player */
		player_wipe();

		/* Roll up a new character */
		if (player_birth_aux()) break;
	}

	/* Create a note file if that option is set */
	if (take_notes)
	{
		add_note_type(NOTE_BIRTH);
	}

	/* Note player birth in the message recall */
	message_add(" ");
	message_add("  ");
	message_add("====================");
	message_add("  ");
	message_add(" ");

	/* Init the shops */
	for (i = 1; i < max_towns; i++)
	{
		for (j = 0; j < MAX_STORES; j++)
		{
			/* Initialize */
			store_init(i, j);
		}
	}

	/* Set the message window flag as default */
	if (!window_flag[1])
		window_flag[1] |= PW_MESSAGE;

	/* Set the inv/equip window flag as default */
	if (!window_flag[2])
		window_flag[2] |= PW_INVEN;
}
