<?php
// $Id: d3forum.php,v 0.85 2011/01/31 02:39:00 yoshis Exp $
//  ------------------------------------------------------------------------ //
//                           xMobile d3forum plugin                          //
//                      Copyright (c) 2011 bluemoon inc.                     //
//                        <http://www.bluemooninc.jp/>                       //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
if(!defined('XOOPS_ROOT_PATH')) exit();

$mydirname = strtolower(basename(__FILE__,'.php'));
$Pluginname = ucfirst($mydirname);
if(!preg_match("/^\w+$/", $Pluginname))
{
	trigger_error('Invalid pluginName');
	exit();
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
eval('
class Xmobile'.$Pluginname.'Plugin extends XmobileD3forumPluginAbstract
{
	function Xmobile'.$Pluginname.'Plugin()
	{
		$this->__construct();
	}
}

class Xmobile'.$Pluginname.'PluginHandler extends XmobileD3forumPluginHandlerAbstract
{
	function Xmobile'.$Pluginname.'PluginHandler($db)
	{
		$this->__construct("'.$mydirname.'",$db);
	}
}
');
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class XmobileD3forumPluginAbstract extends XmobilePlugin
{
	function __construct()
	{
		// call parent constructor
		XmobilePlugin::XmobilePlugin();

		// define object elements
		$this->initVar('post_id', XOBJ_DTYPE_INT, null, true);
		$this->initVar('pid', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('topic_id', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('post_time', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('modified_time', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('uid', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('uid_hidden', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('poster_ip', XOBJ_DTYPE_TXTBOX, '', true, 15);
		$this->initVar('modifier_ip', XOBJ_DTYPE_TXTBOX, '', true, 15);
		$this->initVar('subject', XOBJ_DTYPE_TXTBOX, '', true, 255);
		$this->initVar('subject_waiting', XOBJ_DTYPE_TXTBOX, '', true, 255);
		$this->initVar('html', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('smiley', XOBJ_DTYPE_INT, 1, true);
		$this->initVar('xcode', XOBJ_DTYPE_INT, 1, true);
		$this->initVar('br', XOBJ_DTYPE_INT, 1, true);
		$this->initVar('number_entity', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('special_entity', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('icon', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('attachsig', XOBJ_DTYPE_INT, 1, true);
		$this->initVar('invisible', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('approval', XOBJ_DTYPE_INT, 1, true);
		$this->initVar('votes_sum', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('votes_count', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('depth_in_tree', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('order_in_tree', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('path_in_tree', XOBJ_DTYPE_TXTBOX, '', true, 255);
		$this->initVar('unique_path', XOBJ_DTYPE_TXTBOX, '', true, 255);
		$this->initVar('guest_name', XOBJ_DTYPE_TXTBOX, '', true, 25);
		$this->initVar('guest_email', XOBJ_DTYPE_TXTBOX, '', true, 60);
		$this->initVar('guest_url', XOBJ_DTYPE_TXTBOX, '', true, 100);
		$this->initVar('guest_pass_md5', XOBJ_DTYPE_TXTBOX, '', true, 40);
		$this->initVar('guest_trip', XOBJ_DTYPE_TXTBOX, '', true, 40);
		$this->initVar('post_text', XOBJ_DTYPE_TXTAREA, '', false);
		$this->initVar('post_text_waiting', XOBJ_DTYPE_TXTAREA, '', false);

		// define primary key
		$this->setKeyFields(array('post_id'));
		$this->setAutoIncrementField('post_id');
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function assignSanitizerElement()
	{
		$this->initVar('dohtml',XOBJ_DTYPE_INT,$this->getVar('html'));
		$this->initVar('dosmiley',XOBJ_DTYPE_INT,$this->getVar('smiley'));
		$this->initVar('doxcode',XOBJ_DTYPE_INT,$this->getVar('xcode'));
		$this->initVar('dobr',XOBJ_DTYPE_INT,$this->getVar('br'));
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class XmobileD3forumPluginHandlerAbstract extends XmobilePluginHandler
{
	var $template = 'xmobile_d3forum.html';
	var $moduleDir = '';
	var $categoryTableName = '';
	var $itemTableName = '';

	var $categories_table;
	var $forums_table;
	var $topics_table;
	var $posts_table;
	var $category_access;
	var $forum_mods_table;
	var $forum_access_table;
	var $users2topics_table;

	var $category_id_fld = 'topic_id';

	var $item_id_fld = 'post_id';
	var $item_cid_fld = 'topic_id';
	var $item_title_fld = 'subject';
	var $item_order_fld = 'post_time';
	var $item_date_fld = 'post_time';
	var $item_uid_fld = 'uid';

	var $level_array = array('category','forum','topic','post');
	var $levelState = null;
	var $list_pid_fld = null;
	var $list_id_fld = null;
	var $list_title_fld = null;

	var $cat_id = null;
	var $forum_id = null;
	var $topic_id = null;
	var $post_id = null;
				
	var $forum_access = array();
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function __construct($mydirname,$db)
	{
		XmobilePluginHandler::XmobilePluginHandler($db);

		$this->moduleDir = $mydirname;
		$this->categoryTableName = $mydirname.'_topics';
		$this->itemTableName = $mydirname.'_posts';

		$this->categories_table = $this->db->prefix($mydirname.'_categories');
		$this->forums_table = $this->db->prefix($mydirname.'_forums');
		$this->topics_table = $this->db->prefix($mydirname.'_topics');
		$this->posts_table = $this->db->prefix($mydirname.'_posts');
		$this->category_access_table = $this->db->prefix($mydirname.'_category_access');
		$this->forum_mods_table = $this->db->prefix($mydirname.'_forum_mods');
		$this->forum_access_table = $this->db->prefix($mydirname.'_forum_access');
		$this->users2topics_table = $this->db->prefix($mydirname.'_users2topics');
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function setItemCriteria()
	{
		$this->levelState = trim($this->utils->getGetPost('level','category'));
		$this->cat_id = intval($this->utils->getGetPost('cat_id',0));
		$this->forum_id = intval($this->utils->getGetPost('forum_id',0));
		$this->topic_id = intval($this->utils->getGetPost('topic_id',0));
		$this->post_id = intval($this->utils->getGetPost('post_id',0));

		$this->item_criteria = new CriteriaCompo();

		$user =& $this->sessionHandler->getUser();

		$item_criteria_a = new CriteriaCompo();
		$this->item_criteria->add($item_criteria_a);
		
		global $xoopsModuleConfig;
		$this->item_order_sort = $xoopsModuleConfig['title_order_sort'];
		if(!is_null($this->item_order_sort))
		{
			$this->item_criteria->setOrder($this->item_order_sort);
		}

	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
	function getDefaultView()
	{
		//$this->controller->render->template->assign('plugin_contnts',$this->getItemList());
		$this->controller->render->template->assign('plugin_contents',$this->getItemList());
		$this->controller->render->template->assign('recent_item_list',$this->getRecentList());
//		$this->controller->render->template->assign('edit_link',$this->getEditLink());
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
	function getListView()
	{
		//$this->controller->render->template->assign('plugin_contnts',$this->getItemList());
		$this->controller->render->template->assign('plugin_contents',$this->getItemList());
		$this->controller->render->template->assign('edit_link',$this->getEditLink());
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ܺٲ
// ǡܺ١Խѥ󥯤ɽ
// ǡܺ٤ϴݤHTMLitem_detailȤƽ
	function getDetailView()
	{
		global $xoopsConfig;
		$myts =& MyTextSanitizer::getInstance();
		$xoopsUser = $this->sessionHandler->getUser();
		
		$this->setBaseUrl();
		$this->setItemParameter();
		$this->setItemDetailPageNavi();


//		$sql = "SELECT DISTINCT p.post_id, p.subject, p.post_time, p.uid, p.html, p.smiley, f.cat_id, t.topic_id, f.forum_id, f.cat_id FROM ".$this->posts_table." p LEFT JOIN ".$this->topics_table." t ON p.topic_id=t.topic_id LEFT JOIN ".$this->forums_table." f ON t.forum_id=f.forum_id LEFT JOIN ".$this->forum_access_table." a ON f.forum_id=a.forum_id WHERE (".$this->item_criteria->render().") AND t.topic_id=".$this->topic_id." ORDER BY p.post_time ".$this->item_order_sort;
		$sql = "SELECT DISTINCT p.post_id, p.subject, p.post_time, p.uid, p.html, p.smiley, f.cat_id, t.topic_id, f.forum_id, f.cat_id FROM ".$this->posts_table." p LEFT JOIN ".$this->topics_table." t ON p.topic_id=t.topic_id LEFT JOIN ".$this->forums_table." f ON t.forum_id=f.forum_id LEFT JOIN ".$this->forum_access_table." a ON f.forum_id=a.forum_id WHERE t.topic_id=".$this->topic_id." ORDER BY p.post_time ".$this->item_order_sort;

		// debug
		$this->utils->setDebugMessage(__CLASS__, 'getDetailView sql', $sql);
		if(!$ret = $this->db->query($sql,$this->itemDetailPageNavi->getPerpage(),$this->itemDetailPageNavi->getStart()))
		{
			$this->utils->setDebugMessage(__CLASS__, 'getDetailView db error', $this->db->error());
			return false;
		}

		$ret_n = $this->db->getRowsNum($ret);
		if($ret_n == 0)
		{
			return false;
		}

		$detail4html = '';
		$detail4html .= $this->getNicePathFromId($this->topic_id, 'post').'<hr />';

		$detail4html .= _MD_XMOBILE_ITEM_DETAIL.'<br />';
		while($row = $this->db->fetchArray($ret))
		{
			$this->item_id = intval($row[$this->item_id_fld]);
			$this->post_id = $this->item_id;

			$url_parameter = $this->getBaseUrl();
			// ȥ
			$title = $myts->makeTboxData4Show($row[$this->item_title_fld]);
			$detail4html .= _MD_XMOBILE_TITLE.$title.'<br />';
			// 桼̾
			$uid = intval($row[$this->item_uid_fld]);
			$uname = $this->getUserLink($uid);
			$detail4html .= _MD_XMOBILE_CONTRIBUTOR.$uname.'<br />';
			// ա
			$detail4html .= _MD_XMOBILE_DATE.strftime('%Y-%m-%d %H:%M',intval($row[$this->item_date_fld])).'<br />';

			if($row['html'] == 0) $dohtml = 0; else $dohtml = 1;
			if($row['smiley'] == 0) $dosmiley = 0; else $dosmiley = 1;

			$sql = 'SELECT post_text FROM '.$this->posts_table.' WHERE post_id = '.$this->item_id;
			// debug
			$this->utils->setDebugMessage(__CLASS__, 'getDetailView select post_text sql', $sql);
			if(!$ret = $this->db->query($sql))
			{
				$this->utils->setDebugMessage(__CLASS__, 'getDetailView select post_text db error', $this->db->error());
			}
			$ret_n = $this->db->getRowsNum($ret);
			if($ret_n > 0)
			{
				list($post_text) = $this->db->fetchRow($ret);
				$detail4html .= _MD_XMOBILE_CONTENTS.'<br />';
				$detail4html .= $myts->makeTareaData4Show($post_text,$dohtml,$dosmiley,1).'<br />';
			}
		}

		// increase topic views
		$sql = 'UPDATE '.$this->topics_table.' SET topic_views=topic_views+1 WHERE topic_id='.$this->topic_id;
		// debug
		$this->utils->setDebugMessage(__CLASS__, 'getDetailView sql_increment', $sql);
		if(!$ret = $this->db->queryF($sql))
		{
			// debug
			$this->utils->setDebugMessage(__CLASS__, 'getDetailView sql_increment error', $this->db->error());
		}

		$this->controller->render->template->assign('item_detail',$detail4html);
		$this->controller->render->template->assign('item_detail_page_navi',$this->itemDetailPageNavi->renderNavi());
		//if ($xoopsUser->uid()==$uid){
			$this->controller->render->template->assign('edit_link',$this->getEditLink($this->item_id));
		//}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Խ
	function getEditView()
	{
		$this->controller->render->template->assign('item_detail',$this->renderEntryForm());
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Ʋ
	function getConfirmView()
	{
		$this->controller->render->template->assign('item_detail',$this->saveEntry());
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getItemList()
	{
		global $xoopsModuleConfig;
		$myts =& MyTextSanitizer::getInstance();

		$this->setItemCriteria();

		if(!in_array($this->levelState, $this->level_array))
		{
			trigger_error('Invalid Level');
			exit();
		}

		// debug
		$this->utils->setDebugMessage(__CLASS__, 'getItemList level', $this->levelState);

		switch($this->levelState)
		{
			case 'category':

//				$sql = "SELECT DISTINCT c.cat_id, c.cat_title, SUM(f.forum_posts_count) AS post_count FROM ".$this->categories_table." c INNER JOIN ".$this->forums_table." f ON c.cat_id=f.cat_id LEFT JOIN ".$this->forum_access_table." a ON a.forum_id=f.forum_id WHERE ".$this->item_criteria->render()." GROUP BY f.cat_id ORDER BY c.cat_weight";
				$sql = "SELECT DISTINCT c.cat_id, c.cat_title, c.cat_posts_count AS post_count FROM ".$this->categories_table." c INNER JOIN ".$this->forums_table." f ON c.cat_id=f.cat_id LEFT JOIN ".$this->forum_access_table." a ON a.forum_id=f.forum_id GROUP BY f.cat_id ORDER BY c.cat_weight";
				$this->setNextViewState('list');
				// $extraͤgetLinkUrl()htmlspecialchars()ݤΤ&amp;ǤϤʤ&ȵҤƤ
				$extra = 'level=forum';
				$baseUrl = $this->utils->getLinkUrl($this->controller->getActionState(),$this->nextViewState,$this->controller->getPluginState(),$this->sessionHandler->getSessionID(),$extra);
				$extra = 'level=category&cat_id='.$this->cat_id;
				$extra_arg = $this->utils->getLinkUrl($this->controller->getActionState(),$this->controller->getViewState(),$this->controller->getPluginState(),$this->sessionHandler->getSessionID(),$extra);
				$parent_path = '';

				$this->list_id_fld = 'cat_id';
				$this->list_title_fld = 'cat_title';
				$list_title = _MD_XMOBILE_CATEGORIES_LIST;

				break;

			case 'forum':

				//$sql = "SELECT DISTINCT f.forum_id, f.forum_title, f.forum_posts_count as post_count FROM ".$this->forums_table." f LEFT JOIN ".$this->forum_access_table." a ON a.forum_id=f.forum_id WHERE (".$this->item_criteria->render().") AND f.cat_id=".$this->cat_id." ORDER BY f.forum_weight";
				$sql = "SELECT DISTINCT f.forum_id, f.forum_title, f.forum_posts_count as post_count FROM ".$this->forums_table." f LEFT JOIN ".$this->forum_access_table." a ON a.forum_id=f.forum_id WHERE f.cat_id=".$this->cat_id." ORDER BY f.forum_weight";
				$this->setNextViewState('list');
				// $extraͤgetLinkUrl()htmlspecialchars()ݤΤ&amp;ǤϤʤ&ȵҤƤ
				$extra = 'level=topic&cat_id='.$this->cat_id;
				$baseUrl = $this->utils->getLinkUrl($this->controller->getActionState(),$this->nextViewState,$this->controller->getPluginState(),$this->sessionHandler->getSessionID(),$extra);
				$extra = 'level=forum&cat_id='.$this->cat_id.'&forum_id='.$this->forum_id;
				$extra_arg = $this->utils->getLinkUrl($this->controller->getActionState(),$this->controller->getViewState(),$this->controller->getPluginState(),$this->sessionHandler->getSessionID(),$extra);
				$parent_path = $this->getNicePathFromId($this->cat_id, $this->levelState).'<hr />';

				$this->list_pid_fld = 'cat_id';
				$this->list_id_fld = 'forum_id';
				$this->list_title_fld = 'forum_title';
				$list_title = _MD_XMOBILE_FORUM_LIST;

				break;

			case 'topic':

//				$sql = "SELECT DISTINCT t.topic_id, t.topic_title, COUNT(p.post_id) AS post_count FROM ".$this->posts_table." p LEFT JOIN ".$this->topics_table." t ON p.topic_id=t.topic_id LEFT JOIN ".$this->forums_table." f ON t.forum_id=f.forum_id LEFT JOIN ".$this->forum_access_table." a ON f.forum_id=a.forum_id WHERE (".$this->item_criteria->render().") AND t.forum_id=".$this->forum_id." GROUP BY p.topic_id ORDER BY t.topic_last_post_time ".$this->item_order_sort;
				$sql = "SELECT DISTINCT t.topic_id, t.topic_title, topic_posts_count AS post_count FROM ".$this->posts_table." p LEFT JOIN ".$this->topics_table." t ON p.topic_id=t.topic_id LEFT JOIN ".$this->forums_table." f ON t.forum_id=f.forum_id LEFT JOIN ".$this->forum_access_table." a ON f.forum_id=a.forum_id WHERE t.forum_id=".$this->forum_id." GROUP BY p.topic_id ORDER BY t.topic_last_post_time ".$this->item_order_sort;
				$this->setNextViewState('list');
				// $extraͤgetLinkUrl()htmlspecialchars()ݤΤ&amp;ǤϤʤ&ȵҤƤ
				$extra = 'level=post&cat_id='.$this->cat_id.'&forum_id='.$this->forum_id;
				$baseUrl = $this->utils->getLinkUrl($this->controller->getActionState(),$this->nextViewState,$this->controller->getPluginState(),$this->sessionHandler->getSessionID(),$extra);
				$extra = 'level=topic&cat_id='.$this->cat_id.'&forum_id='.$this->forum_id.'&topic_id='.$this->topic_id;
				$extra_arg = $this->utils->getLinkUrl($this->controller->getActionState(),$this->controller->getViewState(),$this->controller->getPluginState(),$this->sessionHandler->getSessionID(),$extra);
				$parent_path = $this->getNicePathFromId($this->forum_id, $this->levelState).'<hr />';

				$this->list_pid_fld = 'forum_id';
				$this->list_id_fld = 'topic_id';
				$this->list_title_fld = 'topic_title';
				$list_title = _MD_XMOBILE_TOPIC_LIST;

				break;

			case 'post':

//				$sql = "SELECT DISTINCT p.post_id, p.subject, p.post_time, p.uid FROM ".$this->posts_table." p LEFT JOIN ".$this->topics_table." t ON p.topic_id=t.topic_id LEFT JOIN ".$this->forums_table." f ON t.forum_id=f.forum_id LEFT JOIN ".$this->forum_access_table." a ON f.forum_id=a.forum_id WHERE (".$this->item_criteria->render().") AND p.topic_id=".$this->topic_id." ORDER BY p.post_time ".$this->item_order_sort;
				$sql = "SELECT DISTINCT p.post_id, p.subject, p.post_time, p.uid FROM ".$this->posts_table." p LEFT JOIN ".$this->topics_table." t ON p.topic_id=t.topic_id LEFT JOIN ".$this->forums_table." f ON t.forum_id=f.forum_id LEFT JOIN ".$this->forum_access_table." a ON f.forum_id=a.forum_id WHERE p.topic_id=".$this->topic_id." ORDER BY p.post_time ".$this->item_order_sort;
				$this->setNextViewState('detail');
				// $extraͤgetLinkUrl()htmlspecialchars()ݤΤ&amp;ǤϤʤ&ȵҤƤ
				$extra = 'cat_id='.$this->cat_id.'&forum_id='.$this->forum_id;
				$baseUrl = $this->utils->getLinkUrl($this->controller->getActionState(),$this->nextViewState,$this->controller->getPluginState(),$this->sessionHandler->getSessionID(),$extra);
				$extra = 'level=post&cat_id='.$this->cat_id.'&forum_id='.$this->forum_id.'&topic_id='.$this->topic_id;
				$extra_arg = $this->utils->getLinkUrl($this->controller->getActionState(),$this->controller->getViewState(),$this->controller->getPluginState(),$this->sessionHandler->getSessionID(),$extra);
				$parent_path = $this->getNicePathFromId($this->topic_id, $this->levelState).'<hr />';

				$this->list_pid_fld = 'topic_id';
				$this->list_id_fld = 'post_id';
				$this->list_title_fld = 'subject';
				$list_title = _MD_XMOBILE_POST_LIST;

				break;
		}

		// debug
		$this->utils->setDebugMessage(__CLASS__, 'getItemList', $sql);

		$list4html = $parent_path;

		$ret = $this->db->query($sql);
		$count = $this->db->getRowsNum($ret);
		if(!$ret)
		{
			// debug
			$this->utils->setDebugMessage(__CLASS__, 'getItemList db error', $this->db->error());
			return false;
		}
		else
		{
			$list4html .= $list_title.'<br />';

			$pageNavi = new XmobilePageNavigator($count, $xoopsModuleConfig['max_title_row'], 'start', $extra_arg);

			if(!$result = $this->db->query($sql,$xoopsModuleConfig['max_title_row'],$pageNavi->getStart()))
			{
				// debug
				$this->utils->setDebugMessage(__CLASS__, 'getItemList db error', $this->db->error());
			}

			$result_n = $this->db->getRowsNum($result);
			if($result_n > 0)
			{
				$number = 1;
				while($data = $this->db->fetchArray($result))
				{
					$id = intval($data[$this->list_id_fld]);

					$title = $myts->makeTboxData4Show($data[$this->list_title_fld]);
					$title = mb_strimwidth($title, 0, $xoopsModuleConfig['max_title_length'], '..', SCRIPT_CODE);

					$url_parameter = $baseUrl.'&amp;'.$this->list_id_fld.'='.$id;
					if($this->levelState == 'post')
					{
						$url_parameter = $url_parameter.'&amp;'.$this->list_pid_fld.'='.$this->topic_id;
					}
//					$list4html .= $this->getListTitleLink($number,$id,$title,$url_parameter,true,false).'<br />';
					if($xoopsModuleConfig['use_accesskey'])
					{
						$list4html .= '['.$number.']';
						$list4html .= '<a href="'.$url_parameter.'" accesskey="'.$number.'">'.$title.'</a>';
					}
					else
					{
						$list4html .= '<a href="'.$url_parameter.'">'.$title.'</a>';
					}
					if($xoopsModuleConfig['show_item_count'])
					{
						if($this->levelState != 'post')
						{
							$item_count = intval($data['post_count']);
							$list4html .= '('.sprintf(_MD_XMOBILE_NUMBER, $item_count).')';
						}
					}
					$list4html .= '<br />';
					$number++;
				}
				$list4html .= '<hr />';
				$list_page_navi = $pageNavi->renderNavi();
				if($list_page_navi != '')
				{
					$list4html .= $list_page_navi.'<hr />';
				}
			}
			else
			{
				$list4html .= _MD_XMOBILE_NO_DATA.'<hr />';
			}
			return $list4html;
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ǿμ
// ͤϥ֥ȤǤϤʤ
	function getRecentList()
	{
		global $xoopsModuleConfig;
		$myts =& MyTextSanitizer::getInstance();

		if($xoopsModuleConfig['show_recent_title'] == 0)
		{
			return false;
		}

		$this->setNextViewState('detail');
		$baseUrl = $this->utils->getLinkUrl($this->controller->getActionState(),$this->nextViewState,$this->controller->getPluginState(),$this->sessionHandler->getSessionID());

//		$sql = 'SELECT DISTINCT f.cat_id, p.pid, p.topic_id, p.post_id, p.subject, p.post_time, p.uid FROM '.$this->posts_table.' p LEFT JOIN '.$this->topics_table
//			.' t ON p.topic_id=t.topic_id LEFT JOIN '.$this->forums_table.' f ON t.forum_id=f.forum_id LEFT JOIN '.$this->forum_access_table.' a ON f.forum_id=a.forum_id WHERE '
//			.$this->item_criteria->render().' ORDER BY p.post_time '.$this->item_order_sort;
		$sql = 'SELECT DISTINCT f.cat_id, f.forum_id, p.topic_id, p.post_id, p.subject, p.post_time, p.uid FROM '.$this->posts_table.' p LEFT JOIN '.$this->topics_table
			.' t ON p.topic_id=t.topic_id LEFT JOIN '.$this->forums_table.' f ON t.forum_id=f.forum_id LEFT JOIN '.$this->forum_access_table
			.' a ON f.forum_id=a.forum_id ORDER BY p.post_time '.$this->item_order_sort;

		// debug
		$this->utils->setDebugMessage(__CLASS__, 'getRecentList sql', $sql);

		$ret = $this->db->query($sql,$xoopsModuleConfig['recent_title_row']);
		if(!$ret)
		{
			// debug
			$this->utils->setDebugMessage(__CLASS__, 'getRecentList db error', $this->db->error());
			return false;
		}

		$count = $this->db->getRowsNum($ret);
		if($count == 0) // ɽǡ̵
		{
			return false;
		}

		$recent_list = array();
		$i = 0;
		while($data = $this->db->fetchArray($ret)){
			$this->topic_id = intval($data['topic_id']);
			$id = intval($data['post_id']);
			$cat_id = intval($data['cat_id']);
			$forum_id = intval($data['forum_id']);
			$topic_id = intval($data['topic_id']);
			$title = $myts->makeTboxData4Show($data['subject']);
			$url_parameter = $baseUrl.'&cat_id='.$cat_id.'&forum_id='.$forum_id.'&topic_id='.$topic_id.'&post_id='.$id;
			$date = strftime('%Y-%m-%d %H:%M',intval($data['post_time']));

			$recent_list[$i]['title'] = $this->adjustTitle($title);
			$recent_list[$i]['url'] = $url_parameter;
			$recent_list[$i]['date'] = $date;
			$i++;
		}

		return $recent_list;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// @return array
	function checkForumAccess()
	{
		$uid = $this->sessionHandler->getUid();
		$user =& $this->sessionHandler->getUser();
		$this->forum_access['can_read'] = 0;
		$this->forum_access['can_post'] = 0;
		$this->forum_access['can_edit'] = 0;
		$this->forum_access['can_delete'] = 0;
		$this->forum_access['post_auto_approved'] = 0;
		$this->forum_access['is_moderator'] = 0;
		
		if ($this->forum_id == 0) return $this->forum_access;

		if( is_object( $user ) ) {
			$groups = $user->getGroups() ;
			if( ! empty( $groups ) ) {
				$whr4forum = "fa.`uid`=$uid || fa.`groupid` IN (".implode(",",$groups).")" ;
				$whr4cat = "`uid`=$uid || `groupid` IN (".implode(",",$groups).")" ;
			} else {
				$whr4forum = "fa.`uid`=$uid" ;
				$whr4cat = "`uid`=$uid" ;
			}
		} else {
			$whr4forum = "fa.`groupid`=".intval(XOOPS_GROUP_ANONYMOUS) ;
			$whr4cat = "`groupid`=".intval(XOOPS_GROUP_ANONYMOUS) ;
		}

		// get categories
		$sql = "SELECT distinct cat_id FROM ".$this->category_access_table." WHERE (".$whr4cat.")" ;
		$result = $this->db->query( $sql ) ;
		if( $result ) while( list( $cat_id ) = $this->db->fetchRow( $result ) ) {
			$cat_ids[] = intval( $cat_id ) ;
			// debug
			$this->utils->setDebugMessage(__CLASS__, 'checkForumAccessCat sql', $sql);
		}
		if( empty( $cat_ids ) ){
			return $this->forum_access;
		}

		// get forums
		$sql = "SELECT distinct f.forum_id FROM ".$this->forums_table." f LEFT JOIN ".$this->forum_access_table." fa ON fa.forum_id=f.forum_id WHERE (".$whr4forum.") AND f.cat_id IN (".implode(',',$cat_ids).")";
		$this->utils->setDebugMessage(__CLASS__, 'checkForumAccessForum sql', $sql);
		$result = $this->db->query( $sql ) ;
		if( $result ) while( list( $forum_id ) = $this->db->fetchRow( $result ) ) {
			$forums[] = intval( $forum_id ) ;
		}
		//
		// forums access ok 'mean can_read' proceed to post,edit,delete
		//
		if( !empty( $forums ) )	{
			$whr_read4forum = '`forum_id` IN (' . implode( "," , $forums ) . ')' ;
			$sql = 'SELECT can_post, can_edit, can_delete, post_auto_approved, is_moderator FROM '.$this->forum_access_table.' WHERE forum_id IN ('.implode(",",$forums).') AND '. $whr4cat;
			// debug
			$this->utils->setDebugMessage(__CLASS__, 'checkForumAccess sql', $sql);
			if(!$ret = $this->db->query($sql)){
				$this->utils->setDebugMessage(__CLASS__, 'checkForumAccess sql error', $this->db->error());
			}
			while($data=$this->db->fetchArray($ret)){
				$this->forum_access['can_read'] = 1;
				if ($data['can_post']==1) $this->forum_access['can_post'] = 1;
				if ($data['can_edit']==1) $this->forum_access['can_edit'] = 1;
				if ($data['can_delete']==1) $this->forum_access['can_delete'] = 1;
				if ($data['post_auto_approved']==1) $this->forum_access['post_auto_approved'] = 1;
				if ($data['is_moderator']==1) $this->forum_access['is_moderator'] = 1;
			}
		}

		// debug
		$this->utils->setDebugMessage(__CLASS__, 'forum_access can_read', $this->forum_access['can_read']);
		$this->utils->setDebugMessage(__CLASS__, 'forum_access can_post', $this->forum_access['can_post']);
		$this->utils->setDebugMessage(__CLASS__, 'forum_access can_edit', $this->forum_access['can_edit']);
		$this->utils->setDebugMessage(__CLASS__, 'forum_access can_delete', $this->forum_access['can_delete']);
		$this->utils->setDebugMessage(__CLASS__, 'forum_access post_auto_approved', $this->forum_access['post_auto_approved']);
		$this->utils->setDebugMessage(__CLASS__, 'forum_access is_moderator', $this->forum_access['is_moderator']);

		return $this->forum_access;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getItemExtraArg()
	{
		$this->cat_id = intval($this->utils->getGetPost('cat_id',0));
		$this->forum_id = intval($this->utils->getGetPost('forum_id',0));
		$this->topic_id = intval($this->utils->getGetPost('topic_id',0));
		$this->post_id = intval($this->utils->getGetPost('post_id',0));
		// $extraͤgetLinkUrl()htmlspecialchars()ݤΤ&amp;ǤϤʤ&ȵҤƤ
		$extra = '';
		if($this->cat_id){
			$extra .= '&cat_id='.$this->cat_id;
		}
		if($this->forum_id){
			$extra .= '&forum_id='.$this->forum_id;
		}
		if($this->topic_id){
			$extra .= '&topic_id='.$this->topic_id;
		}
		if($this->post_id){
//			$extra .= '&post_id='.$this->post_id;
//			$extra .= '&post_id='.$this->item_id;
		}

		$extra = preg_replace('/^\&/','',$extra);
		$item_extra_arg = $this->utils->getLinkUrl($this->controller->getActionState(),$this->controller->getViewState(),$this->controller->getPluginState(),$this->sessionHandler->getSessionID(),$extra);
		// debug
//		$this->utils->setDebugMessage(__CLASS__, 'item_extra_arg', $item_extra_arg);
		return $item_extra_arg;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getEditLink($id=0){
		$this->checkForumAccess();
		if($this->forum_access['can_post'] = 0){
			return false;
		}else{
			$edit_link = '';
			if($id != 0){
				$reply_url = $this->utils->getLinkUrl($this->controller->getActionState(),'edit',$this->controller->getPluginState(),$this->sessionHandler->getSessionID());
				$edit_link .= '<a href="'.$reply_url.'&amp;entry_type=reply_entry&amp;cat_id='.$this->cat_id.'&amp;forum_id='.$this->forum_id.'&amp;topic_id='.$this->topic_id.'&amp;post_id='.$id.'">'._REPLY.'</a>&nbsp;';
				if($this->forum_access['can_edit'] = 1){
					$edit_url = $this->utils->getLinkUrl($this->controller->getActionState(),'edit',$this->controller->getPluginState(),$this->sessionHandler->getSessionID());
					$edit_link .= '<a href="'.$edit_url.'&amp;entry_type=edit_entry&amp;cat_id='.$this->cat_id.'&amp;forum_id='.$this->forum_id.'&amp;topic_id='.$this->topic_id.'&amp;post_id='.$id.'">'._EDIT.'</a>&nbsp;';
				}
				if($this->forum_access['can_delete'] = 1){
					$delete_url = $this->utils->getLinkUrl($this->controller->getActionState(),'edit',$this->controller->getPluginState(),$this->sessionHandler->getSessionID());
					$edit_link .= '<a href="'.$delete_url.'&amp;entry_type=delete_entry&amp;cat_id='.$this->cat_id.'&amp;forum_id='.$this->forum_id.'&amp;topic_id='.$this->topic_id.'&amp;post_id='.$id.'">'._DELETE.'</a>';
				}
				$edit_link .= '<hr />';
			}
			$add_url = $this->utils->getLinkUrl($this->controller->getActionState(),'edit',$this->controller->getPluginState(),$this->sessionHandler->getSessionID());
			if ($this->forum_id>0){
				$edit_link .= '<a href="'.$add_url.'&amp;entry_type=new_entry&amp;cat_id='.$this->cat_id.'&amp;forum_id='.$this->forum_id.'&amp;topic_id='.$this->topic_id.'">'._MD_XMOBILE_POSTNEW.'</a>&nbsp;';
			}
			return $edit_link;
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getNicePathFromId($sel_id, $level, $path='')
	{
		$myts =& MyTextSanitizer::getInstance();

		$baseUrl = $this->utils->getLinkUrl($this->controller->getActionState(),'list',$this->controller->getPluginState(),$this->sessionHandler->getSessionID());
		// debug
		$this->utils->setDebugMessage(__CLASS__, 'getNicePathFromId level', $level);

		switch($level)
		{
			case 'category':
				return $path;
				break;

			case 'forum':
				$sql = 'SELECT cat_id, cat_title FROM '.$this->categories_table.' WHERE cat_id='.$sel_id;
				$previous_level = 'category';

				if(!$result = $this->db->query($sql))
				{
					// debug
					$this->utils->setDebugMessage(__CLASS__, 'getNicePathFromId forum sql', $sql);
					$this->utils->setDebugMessage(__CLASS__, 'getNicePathFromId forum db error', $this->db->error());
				}
				else
				{
					if($this->db->getRowsNum($result) == 0)
					{
						return $path;
					}
					list($parentid,$name) = $this->db->fetchRow($result);
					$name = $myts->makeTboxData4Show($name);
					$baseUrl = $baseUrl.'&amp;level=forum&amp;cat_id='.$sel_id;
					$path = '<a href="'.$baseUrl.'">'.$name.'</a>'.$path;
				}
				break;

			case 'topic':
				$sql = 'SELECT cat_id, forum_title FROM '.$this->forums_table.' WHERE forum_id='.$sel_id;
				$previous_level = 'forum';
				if(!$result = $this->db->query($sql))
				{
					// debug
					$this->utils->setDebugMessage(__CLASS__, 'getNicePathFromId topic sql', $sql);
					$this->utils->setDebugMessage(__CLASS__, 'getNicePathFromId topic db error', $this->db->error());
				}
				else
				{
					if($this->db->getRowsNum($result) == 0)
					{
						return $path;
					}
					list($parentid,$name) = $this->db->fetchRow($result);
					$name = $myts->makeTboxData4Show($name);
					$baseUrl = $baseUrl.'&amp;level=topic&amp;cat_id='.$this->cat_id.'&amp;forum_id='.$sel_id;
					$path = '<br />-<a href="'.$baseUrl.'">'.$name.'</a>'.$path;
				}
				break;

			case 'post':
				$sql = 'SELECT forum_id, topic_title FROM '.$this->topics_table.' WHERE topic_id='.$sel_id;
				$previous_level = 'topic';

				if(!$result = $this->db->query($sql)){
					// debug
					$this->utils->setDebugMessage(__CLASS__, 'getNicePathFromId post sql', $sql);
					$this->utils->setDebugMessage(__CLASS__, 'getNicePathFromId post db error', $this->db->error());
				}
				else
				{
					if($this->db->getRowsNum($result) == 0)
					{
						return $path;
					}
					list($parentid,$name) = $this->db->fetchRow($result);
					$name = $myts->makeTboxData4Show($name);
					$baseUrl = $baseUrl.'&amp;level=post&amp;cat_id='.$this->cat_id.'&amp;forum_id='.$this->forum_id.'&amp;topic_id='.$sel_id;
					$path = '<br />--<a href="'.$baseUrl.'">'.$name.'</a>';
				}
				break;
}

		$path = $this->getNicePathFromId($parentid, $previous_level, $path);

		return $path;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function setItemDetailPageNavi()
	{
//		$sql = "SELECT DISTINCT p.post_id FROM ".$this->posts_table." p LEFT JOIN ".$this->topics_table." t ON p.topic_id=t.topic_id LEFT JOIN ".$this->forums_table." f ON t.forum_id=f.forum_id LEFT JOIN ".$this->forum_access_table." a ON f.forum_id=a.forum_id WHERE (".$this->item_criteria->render().") AND t.topic_id=".$this->topic_id." ORDER BY p.post_time ".$this->item_order_sort;
		$sql = "SELECT DISTINCT p.post_id FROM ".$this->posts_table." p LEFT JOIN ".$this->topics_table." t ON p.topic_id=t.topic_id LEFT JOIN ".$this->forums_table." f ON t.forum_id=f.forum_id LEFT JOIN ".$this->forum_access_table." a ON f.forum_id=a.forum_id WHERE t.topic_id=".$this->topic_id." ORDER BY p.post_time ".$this->item_order_sort;
		// debug
		$this->utils->setDebugMessage(__CLASS__, 'setItemDetailPageNavi sql', $sql);
		if(!$result = $this->db->query($sql))
		{
			// debug
			$this->utils->setDebugMessage(__CLASS__, 'setItemDetailPageNavi db error', $this->db->error());
		}
		$total = $this->db->getRowsNum($result);

		if(!is_null($this->item_id))
		{
			$page = $this->getItemPageFromID($this->item_id);
			$_GET['start'] = $page;
		}
		$this->itemDetailPageNavi = new XmobilePageNavigator($total, 1, 'start', $this->getItemExtraArg());
		$this->item_criteria->setLimit($this->itemDetailPageNavi->getPerpage());
		$this->item_criteria->setStart($this->itemDetailPageNavi->getStart());
		// debug
		$this->utils->setDebugMessage(__CLASS__, 'setItemDetailPageNavi Limit', $this->itemDetailPageNavi->getPerpage());
		$this->utils->setDebugMessage(__CLASS__, 'setItemDetailPageNavi Start', $this->itemDetailPageNavi->getStart());
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getItemPageFromID($id)
	{
//		$sql = "SELECT DISTINCT p.post_id FROM ".$this->posts_table." p LEFT JOIN ".$this->topics_table." t ON p.topic_id=t.topic_id LEFT JOIN ".$this->forums_table." f ON t.forum_id=f.forum_id LEFT JOIN ".$this->forum_access_table." a ON f.forum_id=a.forum_id WHERE (".$this->item_criteria->render().") AND t.topic_id=".$this->topic_id." ORDER BY p.post_time ".$this->item_order_sort;
		$sql = "SELECT DISTINCT p.post_id FROM ".$this->posts_table." p LEFT JOIN ".$this->topics_table." t ON p.topic_id=t.topic_id LEFT JOIN ".$this->forums_table." f ON t.forum_id=f.forum_id LEFT JOIN ".$this->forum_access_table." a ON f.forum_id=a.forum_id WHERE t.topic_id=".$this->topic_id." ORDER BY p.post_time ".$this->item_order_sort;
		// debug
		$this->utils->setDebugMessage(__CLASS__, 'getItemPageFromID sql', $sql);
		if(!$result = $this->db->query($sql))
		{
			// debug
			$this->utils->setDebugMessage(__CLASS__, 'getItemPageFromID db error', $this->db->error());
		}
		else
		{
			if($this->db->getRowsNum($result) > 0)
			{
				$page = 0;
				while($data = $this->db->fetchArray($result))
				{
					if($id == intval($data['post_id']))
					{
						// debug
						$this->utils->setDebugMessage(__CLASS__, 'getItemPageFromID page', $page);
						return $page;
					}
					$page++;
				}
			}
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function renderEntryForm()
	{
		global $xoopsModuleConfig;
		$myts =& MyTextSanitizer::getInstance();
		$this->setItemCriteria();

		$entry_type = htmlspecialchars($this->utils->getGetPost('entry_type', ''), ENT_QUOTES);
		$this->ticket = new XoopsGTicket;
		$this->checkForumAccess();

		// debug
		$this->utils->setDebugMessage(__CLASS__, 'getEdit entry_type', $entry_type);

		$baseUrl = $this->utils->getLinkUrl($this->controller->getActionState(),'confirm',$this->controller->getPluginState(),$this->sessionHandler->getSessionID());
		$baseUrl = preg_replace('/&amp;/i','&',$baseUrl);

		$entry_form = '';
		$entry_form .= '<form action="'.$baseUrl.'" method="post">';
		$entry_form .= '<div class="form">';
		$entry_form .= $this->ticket->getTicketHtml();
		$entry_form .= '<input type="hidden" name="'.session_name().'" value="'.session_id().'" />';
		$entry_form .= '<input type="hidden" name="HTTP_REFERER" value="'.$baseUrl.'" />';

		switch($entry_type)
		{
			case 'new_entry':
				if($this->forum_access['can_post'] != 1){
					return _MD_XMOBILE_NO_PERM_MESSAGE;
				}
				$subject = '';
				$post_text = '';
				$entry_form .= '<input type="hidden" name="post_id" value="" />';
				break;

			case 'reply_entry':
				if($this->forum_access['can_post'] != 1){
					return _MD_XMOBILE_NO_PERM_MESSAGE;
				}
				$subject = '';
				$post_text = '';
				$dohtml = 0;
				$dosmiley = 0;
				$sql = "SELECT p.subject, p.post_time, p.uid, p.html, p.smiley , pt.post_text FROM ".$this->posts_table." p LEFT JOIN ".$this->posts_table." pt ON p.post_id=pt.post_id WHERE p.post_id = ".$this->post_id;
				$ret = $this->db->query($sql);
				if(!$ret)
				{
					// debug
					$this->utils->setDebugMessage(__CLASS__, 'getEdit db error', $this->db->error());
					return false;
				}
				while($data = $this->db->fetchArray($ret))
				{
					$rep_subject = $myts->makeTboxData4Show($data['subject']);
					$post_time = strftime('%Y-%m-%d %H:%M',intval($data['post_time']));
					$uname = $this->utils->getUnameFromId($data['uid']);
					if($data['html'] == 0) $dohtml = 0; else $dohtml = 1;
					if($data['smiley'] == 0) $dosmiley = 0; else $dosmiley = 1;
					$rep_post_text = $myts->makeTareaData4Show($data['post_text'],$dohtml,$dosmiley,1);
				}
				$entry_form .= _MD_XMOBILE_ITEM_DETAIL.'<br />';
				$entry_form .= _MD_XMOBILE_TITLE.$rep_subject.'<br />';
				$entry_form .= _MD_XMOBILE_CONTRIBUTOR.'&nbsp;'.$uname.'<br />';
				$entry_form .= _MD_XMOBILE_DATE.'&nbsp;'.$post_time.'<br />';
				if($rep_post_text !== '')
				{
					$entry_form .= _MD_XMOBILE_CONTENTS.'<br />';
					$entry_form .= $rep_post_text;
				}
				$entry_form .= '<hr />'._MD_XMOBILE_PRPLY_THIS.'<br />';
				$entry_form .= '<input type="hidden" name="pid" value="'.$this->post_id.'" />';
				$entry_form .= '<input type="hidden" name="post_id" value="" />';
				if(!preg_match('/^Re:/i', $rep_subject))
				{
					$subject = 'Re:'.$rep_subject;
				}
				else
				{
					$subject = $rep_subject;
				}

				break;

			case 'edit_entry':

				if($this->forum_access['can_edit'] != 1){
					return _MD_XMOBILE_NO_PERM_MESSAGE;
				}
				$sql = "SELECT p.subject, p.uid, p.smiley , pt.post_text FROM ".$this->posts_table." p LEFT JOIN ".$this->posts_table." pt ON p.post_id=pt.post_id WHERE p.post_id = ".$this->post_id;

				$ret = $this->db->query($sql);
				if(!$ret)
				{
					// debug
					$this->utils->setDebugMessage(__CLASS__, 'getEdit db error', $this->db->error());
					return false;
				}
				while($data = $this->db->fetchArray($ret))
				{
					$subject = $myts->makeTboxData4Edit($data['subject']);
					$uid = intval($data['uid']);
//					$dohtml = intval($data['html']);
					$dosmiley = intval($data['smiley']);
					$post_text = $myts->makeTareaData4Edit($data['post_text']);
				}
				$entry_form .= '<input type="hidden" name="post_id" value="'.$this->post_id.'" />';
				$entry_form .= '<input type="hidden" name="uid" value="'.$uid.'" />';
//				$entry_form .= '<input type="hidden" name="dohtml" value="'.$dohtml.'" />';
				$entry_form .= '<input type="hidden" name="dosmiley" value="'.$dosmiley.'" />';
				break;

			case 'delete_entry':

				if($this->forum_access['can_delete'] != 1){
					return _MD_XMOBILE_NO_PERM_MESSAGE;
				}

				$subject = '';
				$post_text = '';
				$dohtml = 0;
				$dosmiley = 0;
				$child_count = 0;

				$sql_has_child = 'SELECT post_id FROM '.$this->posts_table.' WHERE pid = '.$this->post_id;
				$ret_has_child = $this->db->query($sql_has_child);
				$child_count = $this->db->getRowsNum($ret_has_child);

				$sql = 'SELECT subject, post_time, uid, html, smiley FROM '.$this->posts_table.' WHERE post_id = '.$this->post_id;
				$ret = $this->db->query($sql);
				if(!$ret)
				{
					// debug
					$this->utils->setDebugMessage(__CLASS__, 'getEdit db error', $this->db->error());
					return false;
				}
				while($data = $this->db->fetchArray($ret))
				{
					$rep_subject = $myts->makeTboxData4Show($data['subject']);
					$post_time = strftime('%Y-%m-%d %H:%M',intval($data['post_time']));
					$uname = $this->utils->getUnameFromId($data['uid']);
					if($data['html'] == 0) $dohtml = 0; else $dohtml = 1;
					if($data['smiley'] == 0) $dosmiley = 0; else $dosmiley = 1;
				}
				$sql2 = 'SELECT post_text FROM '.$this->posts_table.' WHERE post_id = '.$this->post_id;
				$ret2 = $this->db->query($sql2);
				if(!$ret2)
				{
					// debug
					$this->utils->setDebugMessage(__CLASS__, 'getEdit db error', $this->db->error());
					return false;
				}
				while($data2 = $this->db->fetchArray($ret2))
				{
					$rep_post_text = $myts->makeTareaData4Show($data2['post_text'],$dohtml,$dosmiley,1);
				}

				$entry_form .= _MD_XMOBILE_ITEM_DETAIL.'<br />';
				$entry_form .= _MD_XMOBILE_TITLE.'<br />';
				$entry_form .= $rep_subject.'<hr />';
				if($rep_post_text !== '')
				{
					$entry_form .= $rep_post_text.'<hr />';
				}
				$entry_form .= _MD_XMOBILE_CONTRIBUTOR.'&nbsp;'.$uname.'<br />';
				$entry_form .= _MD_XMOBILE_DATE.'&nbsp;'.$post_time.'<br />';
				if($child_count > 0)
				{
					$entry_form .= _MD_XMOBILE_ASK_DELETE_ALL.'<hr />';
				}
				else
				{
					$entry_form .= _MD_XMOBILE_ASK_DELETE_THIS.'<hr />';
				}
				$entry_form .= '<input type="hidden" name="cat_id" value="'.$this->cat_id.'" />';
				$entry_form .= '<input type="hidden" name="forum_id" value="'.$this->forum_id.'" />';
				$entry_form .= '<input type="hidden" name="topic_id" value="'.$this->topic_id.'" />';
				$entry_form .= '<input type="hidden" name="post_id" value="'.$this->post_id.'" />';
				$entry_form .= '<input type="hidden" name="entry_type" value="delete_entry" />';
				$entry_form .= '<input type="submit" name="submit" value="'._DELETE.'" />&nbsp;';
				$entry_form .= '<input type="submit" name="cancel" value="'._CANCEL.'" />';
				$entry_form .= '</div>';
				$entry_form .= '</form>';

				return $entry_form;

				break;
		}

		if($entry_type == 'new_entry' || $entry_type == 'reply_entry')
		{
			$entry_form .= _MD_XMOBILE_CONTRIBUTOR.'<br />';
			$poster_uid = $this->sessionHandler->getUid();
			$member_handler =& xoops_gethandler('member');
			$poster =& $member_handler->getUser($poster_uid);
			if(is_object($poster))
			{
				$entry_form .= $poster->getVar('uname').'<br />';
			}
			else
			{
				$entry_form .= '<input type="text" name="poster_name" value="" /><br />';
			}
		}
		$entry_form .= _MD_XMOBILE_TITLE.'<br />';
		$entry_form .= '<input type="text" name="subject" value="'.$subject.'" /><br />';
		$entry_form .= _MD_XMOBILE_MESSAGE.'<br />';
		$entry_form .= '<textarea rows="'.$xoopsModuleConfig['tarea_rows'].'" cols="'.$xoopsModuleConfig['tarea_cols'].'" name="post_text">'.$post_text.'</textarea><br />';
		$entry_form .= '<input type="hidden" name="cat_id" value="'.$this->cat_id.'" />';
		$entry_form .= '<input type="hidden" name="forum_id" value="'.$this->forum_id.'" />';
		$entry_form .= '<input type="hidden" name="topic_id" value="'.$this->topic_id.'" />';
		$entry_form .= '<input type="hidden" name="entry_type" value="'.$entry_type.'" />';
		$entry_form .= '<input type="submit" name="submit" value="'._SUBMIT.'" />&nbsp;';
		$entry_form .= '<input type="submit" name="cancel" value="'._CANCEL.'" />';
		$entry_form .= '</div>';
		$entry_form .= '</form>';

		return $entry_form;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function saveEntry(){
		global $xoopsModuleConfig;
		$myts =& MyTextSanitizer::getInstance();
		$this->setItemCriteria();
		
		if(isset($_POST['cancel'])){
			$baseUrl = XMOBILE_URL.'/?act='.$this->controller->getActionState().'&plg='.$this->controller->getPluginState();
			if($this->sessionHandler->getSessionID() != ''){
				$baseUrl .= '&sess='.$this->sessionHandler->getSessionID();
			}
			if($this->topic_id != 0){
				$baseUrl .= '&view=detail';
				$baseUrl .= '&start='.$this->start;
				$baseUrl .= '&topic_id='.$this->topic_id;
			}elseif($this->forum_id != 0){
				$baseUrl .= '&view=list&level=topic';
				$baseUrl .= '&forum_id='.$this->forum_id;
			}
			header('Location: '.$baseUrl);
			exit();
		}

		$this->checkForumAccess();

		$entry_type = htmlspecialchars($this->utils->getGetPost('entry_type', ''), ENT_QUOTES);
		$this->ticket = new XoopsGTicket;

		// debug
		$this->utils->setDebugMessage(__CLASS__, 'getConfirmView entry_type', $entry_type);

		//åȤγǧ
//		if(!$ticket_check = $this->ticket->check())
		if( !$ticket_check = $this->ticket->check(true,'',false) ){
//			return $this->ticket->getErrors();
			return _MD_XMOBILE_TICKET_ERROR;
		}

		$allow_html = 0;
		$new_id = 0;

/*
		$sql = 'SELECT allow_html FROM '.$this->forums_table.' WHERE forum_id = '.$this->forum_id;
		$ret = $this->db->query($sql);
		if(!$ret)
		{
			$this->utils->setDebugMessage(__CLASS__, 'getConfirmView db error', $this->db->error());
			return false;
		}
		else
		{
			$row = $this->db->fetchRow($ret);
			$allow_html = intval($row[0]);
			if($allow_html == 0) $nohtml = 1; else $nohtml = 0;
		}
*/

		$pid = intval($this->utils->getPost('pid', 0));
		$post_time = time();
		$uid = $this->sessionHandler->getUid();
		$poster_ip = $myts->makeTboxData4Save($_SERVER['REMOTE_ADDR']);
		$subject = $myts->makeTboxData4Save($this->utils->getPost('subject', ''));
//		$dohtml = intval($this->utils->getPost('dohtml', 0));
//		$dosmiley = intval($this->utils->getPost('dosmiley', 0));
		$dohtml = 0;
		$dosmiley = 0;
		$icon = $myts->makeTboxData4Save($this->utils->getPost('icon', ''));
		$attachsig = intval($this->utils->getPost('attachsig', 0));
		$post_text = $myts->makeTareaData4Save($this->utils->getPost('post_text', ''));
		$poster_name = $myts->makeTareaData4Save($this->utils->getPost('poster_name', ''));
		if($poster_name != '')
		{
			$post_text = sprintf(_MD_XMOBILE_POSTERNAME,$poster_name).$post_text;
		}

		// debug
		$this->utils->setDebugMessage(__CLASS__, 'getConfirmView sql', $sql);
		$this->utils->setDebugMessage(__CLASS__, 'getConfirmView allow_html', $allow_html);
		$this->utils->setDebugMessage(__CLASS__, 'getConfirmView dohtml', $dohtml);


		if($entry_type != 'delete_entry' && $subject == '')
		{
			$body = _MD_XMOBILE_NEED_DATA;
			$body .= $this->getEditView();
			return $body;
		}

		switch($entry_type)
		{
			case 'new_entry':
				if($this->forum_access['can_post'] != 1){
					return _MD_XMOBILE_NO_PERM_MESSAGE;
				}

				$sql_insert_topics = "INSERT INTO ".$this->topics_table
					." (forum_id,topic_title,topic_first_uid,topic_last_uid,topic_first_post_time,topic_last_post_time,topic_posts_count) VALUES ("
					.$this->forum_id.",'$subject',$uid,$uid,$post_time,$post_time,1)";
				$this->utils->setDebugMessage(__CLASS__, 'sql_insert_topics', $sql_insert_topics);
				if(!$ret_insert_topics = $this->db->queryF($sql_insert_topics))
				{
					// debug
					$this->utils->setDebugMessage(__CLASS__, 'sql_insert_topics error', $this->db->error());
					return _MD_XMOBILE_INSERT_FAILED;
				}
				$new_topic_id = $this->db->getInsertId();

				$sql_insert_posts = "INSERT INTO ".$this->posts_table." (pid,topic_id,post_time,modified_time,uid,poster_ip,number_entity,subject,html,smiley,icon,attachsig,post_text) VALUES($pid,$new_topic_id,$post_time,UNIX_TIMESTAMP(),$uid,'$poster_ip',1,'$subject',$dohtml,$dosmiley,'$icon',$attachsig,'$post_text')";
				// debug
				$this->utils->setDebugMessage(__CLASS__, 'sql_insert_posts', $sql_insert_posts);
				if(!$ret_insert_posts = $this->db->queryF($sql_insert_posts))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_insert_posts error', $this->db->error());

					$sql_delete_topics = "DELETE FROM ".$this->topics_table." WHERE topic_id = $new_topic_id";
					$this->db->query($sql_delete_topics);

					return _MD_XMOBILE_INSERT_FAILED;
				}
				$new_id = $this->db->getInsertId();

				$sql_update_forums = "UPDATE ".$this->forums_table." SET forum_topics_count = forum_topics_count+1, forum_posts_count = forum_posts_count+1, forum_last_post_id = $new_id WHERE forum_id = $this->forum_id";
				$this->utils->setDebugMessage(__CLASS__, 'update_forums', $sql_update_forums);
				if(!$ret_update_forums = $this->db->query($sql_update_forums))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_update_forums error', $this->db->error());
					return _MD_XMOBILE_INSERT_FAILED;
				}

				$sql_update_topics= "UPDATE ".$this->topics_table." SET topic_last_uid = $uid, topic_first_post_id = $new_id, topic_last_post_id = $new_id WHERE topic_id = $new_topic_id";
				$this->utils->setDebugMessage(__CLASS__, 'sql_update_topics', $sql_update_topics);
				if( !$ret_update_topics = $this->db->query($sql_update_topics) ){
					$this->utils->setDebugMessage(__CLASS__, 'sql_update_topics error', $this->db->error());
					return _MD_XMOBILE_INSERT_FAILED;
				}

				$sql_incremant_posts = sprintf("UPDATE %s SET posts=posts+1 WHERE uid = %u", $this->db->prefix("users"),$uid );
				$this->utils->setDebugMessage(__CLASS__, 'sql_incremant_posts', $sql_incremant_posts);
				if(!$ret_incremant_posts = $this->db->query($sql_incremant_posts))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_incremant_posts error', $this->db->error());
					return _MD_XMOBILE_INSERT_FAILED;
				}

				$this->utils->setDebugMessage(__CLASS__, 'insert new_entry', 'Success ');

				return _MD_XMOBILE_INSERT_SUCCESS;

				break;

			case 'reply_entry':
				if($this->forum_access['can_post'] != 1){
					return _MD_XMOBILE_NO_PERM_MESSAGE;
				}

				$sql_insert_posts = "INSERT INTO ".$this->posts_table." (pid,topic_id,post_time,uid,poster_ip,subject,html,smiley,icon,attachsig,post_text) VALUES($pid,$this->topic_id,$post_time,$uid,'$poster_ip','$subject',$dohtml,$dosmiley,'$icon',$attachsig,'$post_text')";
				$this->utils->setDebugMessage(__CLASS__, 'sql_insert_posts', $sql_insert_posts);
				if(!$ret_insert_posts = $this->db->queryF($sql_insert_posts))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_insert_posts error', $this->db->error());
					return false;
				}
				$new_id = $this->db->getInsertId();

				$sql_update_topics = "UPDATE ".$this->topics_table." SET topic_last_uid=".$uid.", topic_last_post_time=".$post_time.", topic_posts_count=topic_posts_count+1, topic_last_post_id=".$new_id." WHERE topic_id=".$this->topic_id;
				$this->utils->setDebugMessage(__CLASS__, 'sql_update_topics', $sql_update_topics);
				if(!$ret_update_topics = $this->db->query($sql_update_topics))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_update_topics error', $this->db->error());
					return false;
				}

				$sql_update_forums = "UPDATE ".$this->forums_table." SET forum_posts_count = forum_posts_count+1, forum_last_post_id = $new_id WHERE forum_id = $this->forum_id";
				$this->utils->setDebugMessage(__CLASS__, 'sql_update_forums', $sql_update_forums);
				if(!$ret_update_forums = $this->db->query($sql_update_forums))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_update_forums error', $this->db->error());
					return false;
				}


				$sql_incremant_posts = sprintf("UPDATE %s SET posts=posts+1 WHERE uid = %u", $this->db->prefix("users"), $uid);
				$this->utils->setDebugMessage(__CLASS__, 'sql_incremant_posts', $sql_incremant_posts);
				if(!$ret_incremant_posts = $this->db->query($sql_incremant_posts))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_incremant_posts error', $this->db->error());
					return false;
				}

				$this->utils->setDebugMessage(__CLASS__, 'reply_entry', 'Success');

				return _MD_XMOBILE_INSERT_SUCCESS;

				break;

			case 'edit_entry':
				if($this->forum_access['can_edit'] != 1){
					return _MD_XMOBILE_NO_PERM_MESSAGE;
				}
				/* Check poster uid */
				$sql_insert_posts = "SELECT count(*) FROM ".$this->posts_table." WHERE pid=".$this->post_id ." AND uid=".$uid;
				$this->utils->setDebugMessage(__CLASS__, 'sql_insert_posts', $sql_insert_posts);
				$ret_insert_posts = $this->db->query($sql_insert_posts);
				if(!$ret_insert_posts){
					$this->utils->setDebugMessage(__CLASS__, 'sql_insert_posts error', $this->db->error());
					return _MD_XMOBILE_UPDATE_FAILED;
				}
				$sql_insert_posts = "UPDATE ".$this->posts_table.
					" SET pid=$pid, topic_id=".$this->topic_id.",post_time=$post_time,poster_ip='$poster_ip',subject='$subject',html=$dohtml,smiley=$dosmiley,icon='$icon',attachsig=$attachsig WHERE post_id="
					.$this->post_id ." AND uid=".$uid;
				$this->utils->setDebugMessage(__CLASS__, 'sql_insert_posts', $sql_insert_posts);
				$ret_insert_posts = $this->db->query($sql_insert_posts);
				if(!$ret_insert_posts){
					$this->utils->setDebugMessage(__CLASS__, 'sql_insert_posts error', $this->db->error());
					return _MD_XMOBILE_UPDATE_FAILED;
				}
				if (count($ret_insert_posts)==0) return _MD_XMOBILE_UPDATE_FAILED." -- ";
				$sql_insert_posts_text = "UPDATE ".$this->posts_table." SET post_id=".$this->post_id.",post_text='$post_text' WHERE post_id=".$this->post_id;
				$this->utils->setDebugMessage(__CLASS__, 'sql_insert_posts_text', $sql_insert_posts_text);
				if(!$ret_insert_posts_text = $this->db->query($sql_insert_posts_text))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_insert_posts_text error', $this->db->error());
					return _MD_XMOBILE_UPDATE_FAILED;
				}

				$sql_insert_topics = "UPDATE ".$this->topics_table." SET topic_last_post_time=$post_time WHERE topic_id=".$this->topic_id;
				$this->utils->setDebugMessage(__CLASS__, 'sql_insert_topics', $sql_insert_topics);
				if(!$ret_insert_topics = $this->db->query($sql_insert_topics))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_insert_topics error', $this->db->error());
					return _MD_XMOBILE_UPDATE_FAILED;
				}

				$this->utils->setDebugMessage(__CLASS__, 'edit_entry', 'Success');

				return _MD_XMOBILE_UPDATE_SUCCESS;

				break;

			case 'delete_entry':
				if($this->forum_access['can_delete'] != 1){
					return _MD_XMOBILE_NO_PERM_MESSAGE;
				}
				/* Check for child tree may not delete */
				$sql_posts = "SELECT count(*) FROM ".$this->posts_table." WHERE pid = ".$this->post_id;
				$this->utils->setDebugMessage(__CLASS__, 'sql_posts', $sql_posts);
				$ret_posts = $this->db->query($sql_posts);
				list( $count ) = $this->db->fetchRow( $ret_posts ) ;
				if( $count>0 ){
					$this->utils->setDebugMessage(__CLASS__, 'sql_posts error', $this->db->error());
					return _MD_XMOBILE_DELETE_DENIED;
				}

				$poster_uid = 0;
				$sql_posts = "SELECT uid FROM ".$this->posts_table." WHERE post_id = ".$this->post_id ." AND uid=" .$uid;
				$this->utils->setDebugMessage(__CLASS__, 'sql_posts', $sql_posts);
				if(!$ret_posts = $this->db->query($sql_posts))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_posts error', $this->db->error());
					return _MD_XMOBILE_DELETE_FAILED;
				}
				while($row = $this->db->fetchArray($ret_posts))
				{
					$poster_uid = intval($row['uid']);
				}

				$istopic = 0;
				$pid = 0;
				$sql_istopic = 'SELECT pid FROM '.$this->posts_table.' WHERE post_id = '.$this->post_id;
				if(!$ret_istopic = $this->db->query($sql_istopic))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_istopic error', $this->db->error());
					return _MD_XMOBILE_DELETE_FAILED;
				}
				while($row = $this->db->fetchArray($ret_istopic))
				{
					$pid = intval($row['pid']);
				}
				if($pid == 0)
				{
					$istopic = true;
				}

				$sql_delete_posts = "DELETE FROM ".$this->posts_table." WHERE post_id = ".$this->post_id;
				$this->utils->setDebugMessage(__CLASS__, 'sql_delete_posts', $sql_delete_posts);
				if(!$ret_delete_posts = $this->db->query($sql_delete_posts))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_delete_posts error', $this->db->error());
					return _MD_XMOBILE_DELETE_FAILED;
				}
				$sql_delete_posts_text = "DELETE FROM ".$this->posts_table." WHERE post_id = ".$this->post_id;
				$this->utils->setDebugMessage(__CLASS__, 'sql_delete_posts_text', $sql_delete_posts_text);
				if(!$ret_delete_posts_text = $this->db->query($sql_delete_posts_text))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_delete_posts_text error', $this->db->error());
					return _MD_XMOBILE_DELETE_FAILED;
				}

				$sql_decrement_posts = sprintf("UPDATE %s SET posts=posts-1 WHERE uid = %u", $this->db->prefix('users'), $poster_uid);
				$this->utils->setDebugMessage(__CLASS__, 'sql_decrement_posts', $sql_decrement_posts);
				if(!$ret_decrement_posts = $this->db->query($sql_decrement_posts))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_decrement_posts error', $this->db->error());
					return _MD_XMOBILE_DELETE_FAILED;
				}

				include_once XOOPS_ROOT_PATH.'/class/xoopstree.php';
				$child_count = 0;
				$mytree = new XoopsTree($this->posts_table, 'post_id', 'pid');
				$child_arr = $mytree->getAllChild($this->post_id);
				$child_count = count($child_arr);
				$post_count = $child_count+1;
				if($child_count > 0)
				{
					foreach($child_arr as $child)
					{
						$sql_delete_posts_child = "DELETE FROM ".$this->posts_table." WHERE pid=".$child['post_id'];
						$this->utils->setDebugMessage(__CLASS__, 'sql_delete_posts_child', $sql_delete_posts_child);
						if(!$ret_delete_posts_child = $this->db->query($sql_delete_posts_child))
						{
							$this->utils->setDebugMessage(__CLASS__, 'sql_delete_posts_child error', $this->db->error());
							return _MD_XMOBILE_DELETE_FAILED;
						}

						$sql_delete_posts_text_child = "DELETE FROM ".$this->posts_table." WHERE post_id=".$child['post_id'];
						$this->utils->setDebugMessage(__CLASS__, 'sql_delete_posts_text_child', $sql_delete_posts_text_child);
						if(!$ret_delete_posts_text_child = $this->db->query($sql_delete_posts_text_child))
						{
							$this->utils->setDebugMessage(__CLASS__, 'sql_delete_posts_text_child error', $this->db->error());
							return _MD_XMOBILE_DELETE_FAILED;
						}

						$sql_decrement_posts_child = sprintf("UPDATE %s SET posts=posts-1 WHERE uid = %u", $this->db->prefix('users'), $child['uid']);
						$this->utils->setDebugMessage(__CLASS__, 'sql_decrement_posts_child', $sql_decrement_posts_child);
						if(!$ret_decrement_posts_child = $this->db->query($sql_decrement_posts_child))
						{
							$this->utils->setDebugMessage(__CLASS__, 'sql_decrement_posts_child error', $this->db->error());
							return _MD_XMOBILE_DELETE_FAILED;
						}
					}
				}

				if($istopic)
				{
					$sql_delete_topics = "DELETE FROM ".$this->topics_table." WHERE topic_id=".$this->topic_id;
					$this->utils->setDebugMessage(__CLASS__, 'sql_delete_topics', $sql_delete_topics);
					if(!$ret_delete_topics = $this->db->query($sql_delete_topics))
					{
						$this->utils->setDebugMessage(__CLASS__, 'sql_delete_topics error', $this->db->error());
						return _MD_XMOBILE_DELETE_FAILED;
					}

					$sql_delete_users2topics = "DELETE FROM ".$this->users2topics_table." WHERE topic_id=".$this->topic_id;
					$this->utils->setDebugMessage(__CLASS__, 'sql_delete_users2topics', $sql_delete_users2topics);
					if(!$ret_delete_users2topics = $this->db->query($sql_delete_users2topics))
					{
						$this->utils->setDebugMessage(__CLASS__, 'sql_delete_users2topics error', $this->db->error());
						return _MD_XMOBILE_DELETE_FAILED;
					}

					$sql_update_forum_topics = "UPDATE ".$this->forums_table." SET forum_topics_count=forum_topics_count-1 WHERE forum_id=".$this->forum_id;
					$this->utils->setDebugMessage(__CLASS__, 'sql_update_forum_topics', $sql_update_forum_topics);
					if(!$ret_update_forum_topics = $this->db->query($sql_update_forum_topics))
					{
						$this->utils->setDebugMessage(__CLASS__, 'sql_update_forum_topics error', $this->db->error());
						return _MD_XMOBILE_DELETE_FAILED;
					}
				}
				else
				{
					$topic_last_post_id = 0;
					$topic_last_post_time = 0;
					$sql_topic_last_post_id = "SELECT post_id,post_time FROM ".$this->posts_table." WHERE topic_id=".$this->topic_id." ORDER BY post_time ".$this->item_order_sort;
					if(!$ret_topic_last_post_id = $this->db->query($sql_topic_last_post_id,1,0))
					{
						$this->utils->setDebugMessage(__CLASS__, 'sql_topic_last_post_id error', $this->db->error());
						return _MD_XMOBILE_DELETE_FAILED;
					}
					while($row = $this->db->fetchArray($ret_topic_last_post_id))
					{
						$topic_last_post_id = intval($row['post_id']);
						$topic_last_post_time = intval($row['post_time']);
					}

					$sql_update_topics = "UPDATE ".$this->topics_table." SET topic_last_post_time=".$topic_last_post_time.", topic_posts_count=topic_posts_count-".$post_count.", topic_last_post_id=".$topic_last_post_id." WHERE topic_id=".$this->topic_id;
					$this->utils->setDebugMessage(__CLASS__, 'sql_update_topics', $sql_update_topics);
					if(!$ret_update_topics = $this->db->query($sql_update_topics))
					{
						$this->utils->setDebugMessage(__CLASS__, 'sql_update_topics error', $this->db->error());
						return _MD_XMOBILE_DELETE_FAILED;
					}
				}

				$forum_last_post_id = 0;
				$sql_forum_last_post_id = "SELECT post_id FROM ".$this->posts_table." WHERE post_id=".$this->post_id." ORDER BY post_time ".$this->item_order_sort;
				if(!$ret_forum_last_post_id = $this->db->query($sql_forum_last_post_id,1,0))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_forum_last_post_id error', $this->db->error() . $sql_forum_last_post_id);
					return _MD_XMOBILE_DELETE_FAILED;
				}
				while($row = $this->db->fetchArray($ret_forum_last_post_id))
				{
					$forum_last_post_id = intval($row['post_id']);
				}

				$sql_update_forum_posts_count = "UPDATE ".$this->forums_table." SET forum_posts_count=forum_posts_count-".$post_count.", forum_last_post_id=".$forum_last_post_id." WHERE forum_id=".$this->forum_id;
				$this->utils->setDebugMessage(__CLASS__, 'sql_update_forum_posts_count', $sql_update_forum_posts_count);
				if(!$ret_update_forum_posts_count = $this->db->query($sql_update_forum_posts_count))
				{
					$this->utils->setDebugMessage(__CLASS__, 'sql_update_forum_posts_count error', $this->db->error());
					return _MD_XMOBILE_DELETE_FAILED;
				}

				$this->utils->setDebugMessage(__CLASS__, 'delete_entry', 'Success');

				return _MD_XMOBILE_DELETE_SUCCESS;

				break;
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function d3forum_get_forums_can_read(){
		$user =& $this->sessionHandler->getUser();

		if( is_object( $user ) ) {
			$uid = intval( $xoopsUser->getVar('uid') ) ;
			$groups = $xoopsUser->getGroups() ;
			if( ! empty( $groups ) ) {
				$whr4forum = "fa.`uid`=$uid || fa.`groupid` IN (".implode(",",$groups).")" ;
				$whr4cat = "`uid`=$uid || `groupid` IN (".implode(",",$groups).")" ;
			} else {
				$whr4forum = "fa.`uid`=$uid" ;
				$whr4cat = "`uid`=$uid" ;
			}
		} else {
			$whr4forum = "fa.`groupid`=".intval(XOOPS_GROUP_ANONYMOUS) ;
			$whr4cat = "`groupid`=".intval(XOOPS_GROUP_ANONYMOUS) ;
		}

		// get categories
		$sql = "SELECT distinct cat_id FROM ".$this->db->prefix($this->moduleDir."_category_access")." WHERE ($whr4cat)" ;
		$result = $this->db->query( $sql ) ;
		if( $result ) while( list( $cat_id ) = $this->db->fetchRow( $result ) ) {
			$cat_ids[] = intval( $cat_id ) ;
		}
		if( empty( $cat_ids ) ) return array(0) ;

		// get forums
		$sql = "SELECT distinct f.forum_id FROM ".$this->db->prefix($this->moduleDir."_forums")." f LEFT JOIN ".$db->prefix($mydirname."_forum_access")." fa ON fa.forum_id=f.forum_id WHERE ($whr4forum) AND f.cat_id IN (".implode(',',$cat_ids).')' ;
		$result = $this->db->query( $sql ) ;
		if( $result ) while( list( $forum_id ) = $this->db->fetchRow( $result ) ) {
			$forums[] = intval( $forum_id ) ;
		}

		if( empty( $forums ) ) return array(0) ;
		else return $forums ;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}
?>
