#!/bin/sh

AUTOCONF=autoconf
AUTOMAKE=automake-1.9
ACLOCAL=aclocal-1.9
AUTOHEADER=autoheader
LIBTOOLIZE=libtoolize

# host os check 
if [ ! -f /etc/fedora-release ]; then
   echo "running host is not Fedora Core";
   exit 1;
fi
if [ x"`cat /etc/fedora-release`" != x"Fedora Core release 5 (Bordeaux)" ]; then
   echo "running host is not Frdora Core release 5"; 
   exit 1;
fi
#UNAME=`uname -s`
#if test X"$UNAME" != X"FreeBSD" ; then
#   echo "running host is not FreeBSD";
#   exit 1;
#fi

set -x
$ACLOCAL -I macros -I config
$AUTOHEADER -I macros -I config
$LIBTOOLIZE --automake --force --copy
$AUTOMAKE --foreign --add-missing --copy
$AUTOCONF

if [ -f config.h.in ]; then
  touch config.h.in
fi

if [ -f stamp-h.in ]; then
  touch stamp-h.in
fi

tmp=`find . -name 'autom4te.cache'`
if [ x"$tmp" != x"" ]; then
  rm -rf $tmp;
fi
tmp=`find . -name 'configure.lineno'`
if [ x"$tmp" != x"" ]; then
  rm -f $tmp;
fi
tmp=`find . -name '*~'`
if [ x"$tmp" != x"" ]; then
  rm -f $tmp;
fi
