/*
 * 
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * $Revision: 1.4 $
 * 
 */

#include <stdlib.h>
#include <time.h>

#include "common.h"
#include "changelog.h"

changelog::changelog()
{
    logid = 0;
    date = 0;
    log = 0; setValue( &log, "" );
}

changelog::changelog( changelogid_t logid_, time_t date_, const char* log_ )
{
    logid = logid_;
    date = date_;
    log = 0; setValue( &log, log_ );
}

changelog::~changelog()
{
    if( log != 0 ) delete[] log;
}

changelogid_t changelog::getChangelogID( ) const { return logid; }
time_t changelog::getDate( ) const { return date; }
itemid_t changelog::getItemID( ) const { return item_id; }
const char *changelog::getLog( ) const { return log; }

void changelog::setChangelogID( changelogid_t logid_ ){ logid = logid_; }
void changelog::setDate( time_t date_ ){ date = date_; }
void changelog::setItemID( itemid_t item_id_ ){ item_id = item_id_; }
void changelog::setLog( const char* log_ ){ setValue( &this -> log, log_ ); }
