/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * 
 * $Revision: 1.118.2.7 $
 * $Log: commonal.cc,v $
 * Revision 1.118.2.7  2006/10/04 09:25:21  tani
 * activate: accept only guest session or login user's session.
 *
 * Revision 1.118.2.6  2006/10/04 08:31:05  tani
 * activate: don't valid session for activation by user.
 *
 * Revision 1.118.2.5  2006/08/24 09:59:20  aga4096
 * [ #8723 ] STABLE2 ALDB³ʸɻ  Υѥå򤢤Ƥ.
 *
 * Revision 1.118.2.4  2006/06/30 02:46:02  aga4096
 * MySQL5.0.22Ǥ certify.php Ǿ No items found. ˤʤ礬Τ.
 *
 * Revision 1.118.2.3  2006/04/12 09:20:12  aga4096
 * insert_index  item_type_id 0ˤʤ礬Τ.
 *
 * Revision 1.118.2.2  2006/02/28 04:49:17  aga4096
 * NIJC code, gueston/off񤭴Ȥ item_status ꥻåȤ.
 *
 * Revision 1.118.2.1  2006/02/14 05:13:17  aga4096
 * ƥब private/index_a  public/index_b Ͽ줿֤ǡ private/index_aȤʤΤ.
 *
 * Revision 1.118  2006/01/10 10:56:30  tani
 * selectiveHarvesting:stat.item_idorder by(asc)
 *
 * Revision 1.117  2006/01/06 05:50:32  aga4096
 *  ctype.h include.
 *
 * Revision 1.116  2005/11/22 11:29:54  tani
 * deleteItem: ƥƱRelated to.
 * getRelatedTo: isActivatedBySessionΥå򳰤(ĹʤΤ).
 *
 * Revision 1.115  2005/11/17 10:59:36  tani
 * ƥ֥󥯵ǽ: insertRelatedTo, deleteRelatedTo, getRelatedToɲ.
 *
 * Revision 1.114  2005/11/16 03:59:06  tani
 * XOONIPS_STABLEʬMergePnt_20051116֤XooNIps_STABLEνCURRENT˥ޡ.
 *
 * Revision 1.113.2.3  2005/11/01 10:36:14  tani
 * _insertItem: dierctե饰ˤäƽ񤭹վͤʬ.
 *
 * Revision 1.113.2.2  2005/10/28 07:02:52  aga4096
 * ֥ǥåޤ।ǥåκ˥顼Ф뤳ȤΤ.
 *
 * Revision 1.113.2.1  2005/10/18 09:19:53  aga4096
 * PubMed䴰ʤȤΤ.
 *
 * Revision 1.113  2005/10/11 16:20:22  orrisroot
 * SQLRowCount ͥå򸵤ˤɤ
 *
 * Revision 1.112  2005/10/07 06:22:46  aga4096
 * updateAccount()顼ФȤΤ.
 *
 * Revision 1.111  2005/09/26 02:24:34  aga4096
 * isAdmin()ưΤ.
 *
 * Revision 1.110  2005/09/09 06:26:35  aga4096
 * xnp_use_syslog().
 *
 * Revision 1.109  2005/09/09 01:29:27  aga4096
 * refresh_item_status, update_item_status顼ˤʤ뤳ȤΤ.
 *
 * Revision 1.108  2005/09/08 05:40:21  tani
 * freeStringArray.
 * selectiveHarvestingOAIPMHidentifier֤.
 * XNP_CONFIG_REPOSITORY_NIJC_CODE.
 *
 * Revision 1.107  2005/08/30 09:39:31  aga4096
 * xnp_get_item_status .
 *
 * Revision 1.106  2005/08/29 07:11:05  aga4096
 * xnp_update_item_status, xnp_selective_harvestingν.
 *
 * Revision 1.105  2005/08/29 05:27:37  aga4096
 * update_item_statusν.
 *
 * Revision 1.104  2005/08/29 02:05:34  aga4096
 * xnp_update_item_status(), xnp_refresh_item_status(), xnp_selective_harvesting() ɲ.
 *
 * Revision 1.103  2005/08/23 07:34:24  tani
 * Languageб: getItems, _insetItem, updateItem
 *
 * Revision 1.102  2005/08/23 02:19:10  tani
 * getEventsForRSSθ¥åѹ.
 *
 * Revision 1.101  2005/08/08 01:57:00  aga4096
 * 2ܰʹߤinitializeDB̵.
 * valgrindηٹкʤ.
 *
 * Revision 1.100  2005/07/21 01:47:57  tani
 * getEventsForRSS.
 *
 * Revision 1.99  2005/07/15 04:42:33  aga4096
 * getItemTypesǡDBNULL񤫤ƤȤʤΤ.
 *
 * Revision 1.98  2005/07/12 06:40:44  aga4096
 * setConfigValue˼ԤΤ.
 *
 * Revision 1.97  2005/06/30 07:21:42  aga4096
 * get_all_indexindexʤȤΤ.
 *
 * Revision 1.96  2005/06/29 00:10:18  aga4096
 * login name -> additional info ˽.
 *
 * Revision 1.95  2005/06/24 02:07:34  tani
 * insertItemDirect(Import)
 * getPrivateItemIDˡBINDER̵뤹ɲ(ĿͥХб)
 *
 * Revision 1.94  2005/06/23 07:58:12  aga4096
 * ٥ȥǽɲ.
 *
 * Revision 1.93  2005/06/14 01:02:20  aga4096
 * ĿBinder. xnp_extract_public_item_id, xnp_extract_nonbinder_item_id ɲ.
 *
 * Revision 1.92  2005/06/08 04:27:08  tani
 * default롼פ¸ߤƿ.
 *
 * Revision 1.91  2005/06/07 01:10:33  tani
 * SQLGetDataΰ.
 * SQLExecDirectSQLExecute.
 *
 * Revision 1.90  2005/05/23 08:00:30  tani
 * insertGroup, updateGroup: 롼̾ʣϥ顼ɤ֤.
 *
 * Revision 1.89  2005/05/18 10:00:17  aga4096
 * ⥸塼б.
 *
 * Revision 1.88  2005/03/17 16:02:40  orrisroot
 * UNIX ˤ SQLLEN Ƥʤн褹뤿ᡤconfigure
 * ץȤǽϤ줿 config.h 򥤥󥯥롼ɤ褦ѹ
 *  ˤ MacOS X ǥѥ
 *
 * Revision 1.87  2005/03/15 12:09:39  tani
 * deleteItem ¥å򶯲.
 * 롼ץǥå°륢ƥؤΥå򶯲.
 *
 * Revision 1.86  2005/03/15 04:49:40  tani
 * 饤ʸɲ.
 *
 * Revision 1.85  2005/03/14 09:30:50  aga4096
 * getItemCountByIndexǡԡ롼״Ԥ̤ǧƥ򥫥Ȥ褦.
 *
 * Revision 1.84  2005/03/14 06:12:11  tani
 * __BORLANDC__б.
 *
 * Revision 1.83  2005/03/11 20:00:28  orrisroot
 * - Autotoolized XooNiPs Abstract Layer projects.
 * - changelog.cc commonal.cc index.cc item.cc :
 *     included <time.h> header file for undefined data type 'time_t' error.
 *
 * Revision 1.82  2005/03/11 07:11:30  tani
 * itemid_tĹ(*iidsLen)νɲ.
 *
 * Revision 1.81  2005/03/11 00:34:57  tani
 * ƥΥåcertify_stateɲ.
 *
 * Revision 1.80  2005/03/09 07:27:37  aga4096
 * activate=0ʤloginUser˼Ԥ褦.
 *
 * Revision 1.79  2005/03/07 01:20:09  aga4096
 * getItemCountGroupByIndex̤ǧƥࡦǥåʤ褦.
 *
 * Revision 1.78  2005/03/05 02:28:05  aga4096
 * ĿΰΥǥå Private ɽ褦.
 *
 * Revision 1.77  2005/03/05 01:48:35  aga4096
 * getItemCountGroupByIndex.
 *
 * Revision 1.76  2005/03/04 06:13:28  aga4096
 * updateIndexǡƱ̾η郎뤫̾Ǥʤ饨顼ˤ.
 *
 * Revision 1.75  2005/03/03 10:13:00  aga4096
 * isValidSessiontimestamp򹹿褦.
 * sessionisValidSessionʤ¤1֤ǥॢȤ褦.
 * loginUser, createSessionǥॢȤsession褦.
 *
 * Revision 1.74  2005/02/26 05:11:31  tani
 * getGroupItemIDɲ.
 *
 * Revision 1.73  2005/02/25 07:41:35  tani
 * getGroupItemIDɲ.
 * item, indexlimitեɤϿɲ.
 *
 * Revision 1.72  2005/02/25 01:03:42  tani
 * dbtype==DBTYPE_SQLITEλνʬ.
 *
 * Revision 1.71  2005/02/24 11:32:55  aga4096
 * updateGroupǥ롼ץǥå̾ѹ褦.
 *
 * Revision 1.70  2005/02/23 06:39:28  tani
 * isGuestEnabled: ɤ߹ơ֥ѹ.
 *
 * Revision 1.69  2005/02/22 02:39:30  tani
 * public_item_target_user_allؿɲ.
 * SQLpublic_item_target_user_allӼpublic_item_target_user_allؿִ.
 * sessionơ֥LEFT JOINξsidΥåɲ.
 * DB礻ι®.
 *
 * Revision 1.68  2005/02/21 05:46:18  tani
 * getItemCountɲ.
 * dumpItemID, getItems礻®.
 *
 * Revision 1.67  2005/02/19 02:06:11  tani
 * ǧ֤θ¥å˺Ԥɲ.
 *
 * Revision 1.66  2005/02/16 10:03:13  youi
 * publication_year/month/mdayб.
 *
 * Revision 1.65  2005/02/16 07:37:17  youi
 * insertItem, updateItem, getItems: publication_dateб.
 *
 * Revision 1.64  2005/02/15 02:35:47  youi
 * SQLINTEGERSQLLENطѹ.
 *
 * Revision 1.63  2005/02/10 02:33:16  aga
 * zipCreate򥳥ȥȤƤΤᤷ.
 *
 * Revision 1.62  2005/02/09 11:11:52  youi
 * deleteItem˥ƥ˴ط륨ȥκɲ.
 *
 * Revision 1.61  2005/02/09 07:23:50  aga
 * URL to My Personal Archive DBALä.
 *
 * Revision 1.60  2005/02/09 02:14:15  aga
 * initializeDB()dbtypeɲ(SQLite).
 *
 * Revision 1.59  2005/02/08 07:15:02  youi
 * pubmedѡ:
 *
 * Revision 1.58  2005/02/08 06:40:51  youi
 * pubmedComplete:㡼ʥδʥȥpubmed_t˥å.
 *
 * Revision 1.57  2005/02/03 12:04:58  youi
 * getOwnPublicItemID.
 * binder_item_linkΥơ֥̾.
 *
 * Revision 1.56  2005/01/29 09:49:22  youi
 * syslog_printf: ǥХååϴؿ.
 * getCertifyPermission: åѤsql.
 * SQLINTEGER->SQLLENطѹ.
 * getItemPermission: ǥ졼Ǥ뤫ȽǾ.
 *
 * Revision 1.55  2005/01/28 07:01:38  youi
 * getItemIDByIndexID: оݤȤʤ륢ƥξ︫ľ.
 * SQLAllocHandleԻΥåɲ.
 *
 * Revision 1.54  2005/01/28 00:36:58  aga
 * freeString뤳ȤΤ.
 *
 * Revision 1.53  2005/01/27 08:30:35  youi
 * getIndexIDByItemID.
 *
 * Revision 1.52  2005/01/25 06:46:50  aga
 * BindersޤindexdeleteIndexԲ.
 * getItems顼ФȤΤ.
 *
 * Revision 1.51  2005/01/24 10:50:29  youi
 * freeItemType,getItemTypesؿɲä.
 *
 * Revision 1.50  2005/01/24 01:54:38  youi
 * ηѹ.
 *  dumpItemID, getItemIDByBinderID, getItemIDByIndexID
 * ؿɲ
 *  getPrivateItemID, getUncertifiedLink
 *
 * Revision 1.49  2005/01/22 09:30:58  youi
 * setLastErrorStringɲä.
 *
 * Revision 1.48  2005/01/22 04:18:22  aga
 * loginUser, insertAccountǤmd5()Ԥʤ褦.
 *
 * Revision 1.47  2005/01/22 02:41:14  aga
 * amazon䴰.
 *
 * Revision 1.46  2005/01/21 01:36:11  youi
 * pubmed䴰ǽɲä.
 *
 * Revision 1.45  2005/01/19 10:07:53  aga
 * ȥ桼ν.
 *
 * Revision 1.44  2005/01/19 06:01:59  youi
 * ؿɲ
 *  getConfigValue
 *  setConfigValue
 *  getChangeLogs
 *  insertChangeLog
 *  getItemIDByBinderID
 *  registerBinderItem
 *  unregisterBinderItem
 *  getIndexPermission
 *  freeString
 *  freeChangeLog
 * criteria_tɲ
 *  getItemIDByIndexID
 * νѹ
 *  getCertifyState
 *  setCertifyState
 *  getCertifyPermission
 * sessionID2UID,querySimple,queryGetUnsignedInt
 * insertItemPrivateIndexϿԤʤ
 * getItems: getItemPermissionȤäɤ߹߸¥å.
 *
 * Revision 1.43  2005/01/19 01:42:15  aga
 * x_xoonips_indexgid,uid0ˤʤʤ褦.
 *
 * Revision 1.42  2005/01/19 00:51:29  aga
 * insertIndexx_xoonips_index.index_idΤ.
 *
 * Revision 1.41  2005/01/19 00:06:51  aga
 * updateIndexǡƱ̾η郎뤫̾Ǥʤ饨顼ˤ.
 * createSessionǡuidPlatform桼ǤʤactivateƤʤʤ饨顼ˤ.
 *
 * Revision 1.40  2005/01/17 00:15:05  aga
 * deleteIndex, updateIndex˼Ԥ뤳ȤΤ.
 *
 * Revision 1.39  2005/01/15 05:38:10  youi
 * insertAccount: ʸХåեΥĴʤ.
 * updateAccount: ʸХåեΥĴʤ.
 * ƥؿ.
 *     insertItem, getItem, getItems, dumpItemID, updateItem, deleteItemʤ.
 * freeGID, freeUID: η.
 *
 * Revision 1.38  2005/01/15 00:39:16  aga
 * x_xoonips_item_basicι¤ѹ.
 *
 * Revision 1.37  2005/01/14 10:36:59  aga
 * indexطνɲ.
 * insertAccountprivate index褦.
 * insertGroupgroup index 褦.
 *
 * Revision 1.36  2005/01/13 04:19:22  aga
 * VPXNPѴ.
 *
 * Revision 1.35  2005/01/06 07:20:17  youi
 * WIN32Υ󥯥롼ɤɲ.
 * MySQL API˴ؤإåե.
 * deleteAccount: °Platform롼פκ¢.
 * insertAccount: 桼ϿƱ˥ǥեPlatform롼פϿ.
 * deleteMember: ǥեPlatform롼פκػߤ.
 * deleteMemberNoLimit.
 *
 * Revision 1.34  2004/12/28 04:38:14  aga
 * logoutUser()ν.
 *
 * Revision 1.33  2004/12/27 05:56:23  youi
 * odbcDiagString: STMTʳΥϥɥ褦ѹ.
 * syslogåνɲä.
 *
 * Revision 1.32  2004/12/25 09:46:47  youi
 * MySQL+MyODBCư褦˽.
 *
 * Revision 1.31  2004/12/21 11:42:59  youi
 * Ȥΰͤʤɤɲ.
 *
 * Revision 1.30  2004/12/18 10:24:54  youi
 * IMPORT_MYSQLDLLȤMYSQLDLLưŪ󥯤ץȥ
 * ͭˤʤ褦˽.
 *
 * Revision 1.29  2004/12/18 01:12:29  youi
 * freeResultδؿ̾free<ǡ>ѹ.
 *
 * Revision 1.28  2004/12/14 12:02:08  youi
 * __WIN__ȤwindowsdllɬפʽԤʤ.
 * USE_SYSLOGȤsyslogdإåϤ.
 * getAccounts: uidsLen0ΤȤνɲä.
 *
 * Revision 1.27  2004/12/06 11:34:47  aga
 * uninitializeDB()ɲ.
 *
 * Revision 1.26  2004/12/06 10:17:36  youi
 * mysql_use_resultμ̤ĤФᡤ
 * while( row = mysql_fetch_row(result) );
 *
 * Revision 1.25  2004/12/06 07:24:33  youi
 * insertAccount, insertGroup:
 *     ɲäб桼ID롼ID軰˽񤭹.
 *
 * Revision 1.24  2004/12/06 01:45:50  aga
 * ȤĤ.
 * ˺콤.
 *
 * Revision 1.23  2004/12/04 09:21:10  aga
 * xnp_config  xoonips_config.
 *
 * Revision 1.22  2004/12/03 07:17:21  youi
 * isModeratorǥǡ١ơ֥̾.
 *
 * Revision 1.21  2004/12/01 10:28:58  youi
 * DB̾ѹȼ
 *     institute -> division
 *     organizaion -> company_name
 *
 * Revis1.20  2004/12/01 04:37:04  youi
 * freeResult: unsigned int*  int* ؽ.
 * ˴ؿɵ.
 *
 * Revision 1.19  2004/11/30 06:40:11  youi
 * ؿɲ(gidExists, uidExists)
 * getGroupCount.
 * getGroupsByUid.
 * isGroupAdmin.
 * dumpGroupAdmins.
 * deleteMember.
 * insertMember.
 * getMembers.
 * isModerator.
 *
 * Revision 1.18  2004/11/30 05:46:32  aga
 * sessionremoteHost.
 *
 * Revision 1.17  2004/11/27 09:35:49  youi
 * isActivated.
 * activate.
 * dumpUid.
 *
 * Revision 1.16  2004/11/27 06:29:29  youi
 * getAccountCount.
 * dumpGids.
 * insertGroup, deleteGroup, updateGroup.
 * getGroup, getGroups.
 * ǡ١θƽФФRES_DB_NOT_INITIALIZED֤ƴؿɲ
 * (̤бδؿĤäƤ)
 *
 * Revision 1.15  2004/11/27 02:22:22  aga
 * initializeDBaddSlashes()Ƥ֤Τ.
 *
 * Revision 1.14  2004/11/27 01:07:31  youi
 * criteria2str: LIMITORDER BYν֤ؤ.
 *
 * Revision 1.13  2004/11/27 00:35:39  youi
 * getAccounts.
 * getAccountgetAccountsƤӽФ.
 * criteria2str.
 *
 * Revision 1.12  2004/11/26 09:45:28  youi
 * getAccount.
 *
 * Revision 1.11  2004/11/26 08:16:26  aga
 * getSession, loginUser, createSession, freeResult(const session_t*) .
 *
 * Revision 1.10  2004/11/26 07:57:42  youi
 * updateAccount, deleteAccount.
 * mysql_queryԻstderrإ顼ɤȥ顼å.
 *
 * Revision 1.9  2004/11/26 07:38:02  aga
 * FAILUE -> FAILURE.
 *
 * Revision 1.8  2004/11/26 06:36:55  aga
 * createSession, getSession .
 *
 * Revision 1.7  2004/11/26 04:51:47  youi
 * dbprefix.
 * insertAccount.
 * isValidSessionID.
 *
 * Revision 1.6  2004/11/26 04:35:55  aga
 * loginUser(), logoutUser().
 *
 * Revision 1.5  2004/11/26 01:08:25  aga
 * addSlashes().
 *
 * Revision 1.4  2004/11/25 12:14:29  youi
 * getUidν.
 *
 * Revision 1.3  2004/11/25 11:13:59  youi
 * getLastErrorString/setLastErrorString.
 *
 * Revision 1.2  2004/11/25 08:55:19  youi
 * η.
 * freeResultɲ.
 *
 * Revision 1.1  2004/11/25 05:14:58  youi
 * initial version
 *
 * 
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef WIN32
#include <windows.h>
#endif

#ifdef USE_SYSLOG
#include <syslog.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <string>
#include <assert.h>
#include <time.h>
#include <sql.h>
#include <sqlext.h>
#include <libxml/xmlreader.h>
#include <ctype.h>

using namespace std;

#include "common.h"
#include "account.h"
#include "group.h"
#include "session.h"
#include "item.h"
#include "itemtype.h"
#include "criteria.h"
#include "commonal.h"
#include "item.h"
#include "index.h"
#include "changelog.h"
#include "pubmed.h"
#include "amazonbook.h"

static string dbprefix; //!< XOOPSǡ١ơ֥PREFIX
static dbtype_t dbtype; //!< MySQL/SQLite
static bool useSyslogFlag = false;

static SQLHANDLE henv = NULL;
static SQLHANDLE hdbc = NULL;


static void processEsummary(xmlTextReaderPtr reader, string &title, string &title_abbr);
static bool processEsearch(xmlTextReaderPtr reader, pubmed_t* p, int* DocID );
static void processEfetch(xmlTextReaderPtr reader, pubmed_t* p);
static int streamPubmedFile(const char *filename, pubmed_t* p);
static result_t insertIndexInternal( sessionid_t sid, index_t *index, indexid_t *xid );
static string odbcDiagString( SQLSMALLINT HandleType, SQLHANDLE hstmt, SQLRETURN sqlcode );
static result_t deleteMemberNoLimit( sessionid_t sid, groupid_t gid, userid_t uid );
static result_t getXoopsModuleConfigValue( const char *module, const char *key, char **value );
static void setLastErrorString( const char* str );
static result_t checkTitleConflict( sessionid_t sid, indexid_t parentIndexID, const char *title, bool *conflict );
static result_t _insertItem( sessionid_t sid, const item_t* item, itemid_t* itemid, bool direct );
static result_t getEvents(sessionid_t sid, event_t** events, int* eventsLen, string condition );
static result_t insertMetadataEvent( metadataevent_t me, itemid_t iid );
static result_t insertMetadataEventAuto( itemid_t iid, bool isCreate = false );

static void syslog_printf( char* format, ... )
{
#ifdef USE_SYSLOG
    if ( useSyslogFlag ){
        va_list ap;
        va_start(ap, format);
        openlog( "commonal", LOG_ODELAY, LOG_USER );
        vsyslog( LOG_DEBUG, format, ap );
    }
#endif
}

void useSyslog( bool f )
{
    useSyslogFlag = f;
}

/**  ',' . implode( ',', pi ) ηʸ롣ƬcommaΤ
 * @param pi   int
 * @param len  Ĺ
 */
static string getCsvStr( const itemid_t *pi, int len ){
    char *buf = new char[(sizeof(int)*3+1)*len+1];
    buf[0] = '\0';
    char *p = buf;
    for ( int i = 0; i < len; i++ ){
        int len = sprintf( p, ",%u", pi[i] );
        p += len;
    }
    string iids_str(buf);
    delete[] buf;
    return iids_str;
}

string urlencode( string str ){
    int len = str.length();
    char *buf = new char[len*3+1];
    char *p = buf; 
    for ( int i = 0; i < len; i++ ){
        char c = str[i];
        if ( isalnum(c) || c =='$' || c == '*' || c == '_' || c =='.' )
            *p++ = c;
        else {
            sprintf( p, "%%%02X", c & 0x00ff );
            p += 3;
        }
    }
    *p = '\0';
    string encoded(buf);
    delete[] buf;
    return encoded;
}

/**
 * 
 * public_item_target_userͤ'all'ʤtrue򤫤
 * ͤμ˼Ԥ硤'all'ʳξfalse򤫤
 * 
 */
static bool public_item_target_user_all( )
{
    char* value = 0;
    bool public_item_target_user_all = false;
    if( getConfigValue( XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_KEY, &value ) == RES_OK ){
        public_item_target_user_all = ( strcmp( value, XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_ALL ) == 0 );
        freeString( value );
    }
    return public_item_target_user_all;
}

static result_t countResultRows( const char* sql, SQLLEN* count )
{
    result_t ret = RES_ERROR;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql, strlen( sql ) ) ) == SQL_SUCCESS ){
            *count = 0;
            while( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ) ( *count )++;
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in countResultRows " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += "sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }
    return ret;
}


/**
 * 
 * ǥåϿƥ๹ԤʤäȤξǧ֤νͤ
 * ƥˤä֤ޤ
 * 
 */
static certify_t getInitialCertifyStateFromConfig( )
{
    char* certify_item_val;
    certify_t ret = index::NOT_CERTIFIED;
    
    if( getConfigValue( XNP_CONFIG_CERTIFY_ITEM_KEY, &certify_item_val ) == RES_OK ){
        if( strcmp( certify_item_val, XNP_CONFIG_CERTIFY_ITEM_AUTO ) == 0 ){
            //certify automatic
            ret = index::CERTIFIED;
        }else if( strcmp( certify_item_val, XNP_CONFIG_CERTIFY_ITEM_ON ) == 0 ){
            //certify by moderator or group admin
            ret = index::CERTIFY_REQUIRED;
        }
        syslog_printf( "\ngetInitialCertifyStateFromConfig certify_item_val=%s", certify_item_val );
        freeString( certify_item_val );
    }
    return ret;
}

/**
 * 
 * åбդ줿桼Platform桼ȤActivate
 * Ƥ뤫֤
 *
 * @param sid åID
 * @return true ActivateƤ
 * @return false ActivateƤ롤ޤϥ顼
 *
 */
static bool isActivatedBySession( sessionid_t sid )
{
    const session_t* session;
    if( getSession( sid, &session ) == RES_OK ){
        userid_t sess_uid = session ->  getUID( );
        freeSession( session );
        return isActivated( sid, sess_uid );
    }
    return false;
}

/**
 * 
 * åбդ줿桼ǥ졼Ǥ뤫
 * 
 * 
 * @param sid åID
 * @return true ǥ졼
 * @return false ǥ졼Ǥʤޤϥ顼
 *
 */
static bool isModeratorBySession( sessionid_t sid )
{
    const session_t* session;
    if( getSession( sid, &session ) == RES_OK ){
        userid_t sess_uid = session ->  getUID( );
        freeSession( session );
        return isModerator( sid, sess_uid );
    }
    return false;
}


// SQLAllocHandleSQLExecDirectΥ顼hstmtγݤʤΤǥ饹
class sqlexec_t {
private:
    SQLRETURN sqlcode;
    SQLHANDLE hstmt;
public:
    SQLRETURN getSqlcode(){ return sqlcode; }
    SQLHANDLE getHstmt(){ return hstmt; }
    //SQLRETURN SQLFetch(){ return sqlcode = SQLFetch(hstmt); } // ޤwrapperꤿʤΤѻ
    
    /** 󥹥ȥ饯: SQLAllocHandle, SQLExecDirectԤʤgetSqlcode()==SQL_SUCCESS
     * @param functionName 顼˽񤯴ؿ̾
     * @param sql ¹Ԥ٤SQL
     * @param ret 顼ɤν
     */
    sqlexec_t( const char *functionName, string &sql, result_t *ret ){
        sqlcode = 0;
        hstmt = 0;
        
        if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
            if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
                return;
            }else {
                string s( "SQLExecDirect in  " );
                s += functionName;
                s += " ";
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += " sql=";
                s += string( sql );
                setLastErrorString( s.c_str( ) );
                *ret = RES_DB_QUERY_ERROR;
                return;
            }
        }else {
            string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in " );
            s += functionName;
            s += " ";
            s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
            setLastErrorString( s.c_str( ) );
            *ret = RES_ERROR;
            return;
        }
    }
    ~sqlexec_t(){
        if ( hstmt )
            SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }
};


/** SQL¹Ԥ롣̤ϼΤƤ롣
  * @param sql sql
  * @return result_t
  */
static result_t querySimple( const char *functionName, string &sql ){
    result_t ret = RES_ERROR;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), strlen( sql.c_str() ) ) ) == SQL_SUCCESS ){
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in querySimple " );
            s += functionName;
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += "sql=";
            s += sql;
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }
    else {
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in querySimple " );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/** SQL¹Ԥ1ܤκǽ(NULLʤ0Ȥߤʤ)Τ߼롣
  * @param sql sql
  * @param u   ͤѿ
  * @return result_t
  */
static result_t queryGetUnsignedInt( const char *functionName, string &sql, unsigned int *u ){
    result_t ret = RES_ERROR;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;

    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), strlen( sql.c_str() ) ) ) == SQL_SUCCESS ){
            SQLUINTEGER sInt = 0;
            SQLLEN len = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &sInt, 0, &len );
            if( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                if ( len == SQL_NULL_DATA )
                    sInt = 0;
                *u = sInt;
                ret = RES_OK;
            }else{
                string s( "SQLFetch in queryGetUnsignedInt " );
                s += functionName;
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_ERROR;
            }
        }else{
            string s( "SQLExecDirect in queryGetUnsignedInt " );
            s += functionName;
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += "sql=";
            s += sql;
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }
    else {
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in queryGetUnsignedInt " );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * ʸ󥳥ԡ
 * ʸ򥳥ԡХåեκǸNULLü롥
 * ( dstΥ >= len + 1 )Ǥ뤳
 * 
 */
static char* strncpy2( char* dst, const char* src, int len )
{
    strncpy( dst, src, len );
    dst[ len ] = '\0';
    syslog_printf( "\nstrncpy2 '%s'\n", dst );
    return dst;
}

/**
 * 
 * SQLμ¹Է̤饨顼ʸ
 * 
 * @param hstmt SQLʸΥϥɥ
 * @param sqlcode SQLExecDirect,SQLExecute
 * @return 顼ʸ
 */
static string odbcDiagString( SQLSMALLINT HandleType, SQLHANDLE hstmt, SQLRETURN sqlcode )
{
    string s;
    if( sqlcode == SQL_ERROR || sqlcode == SQL_SUCCESS_WITH_INFO ){
        SQLCHAR SQLState[6];
        SQLINTEGER NativeError;
        SQLCHAR MessageText[ 1024 ];
        SQLSMALLINT TextLength;
        SQLGetDiagRec( HandleType, hstmt, 1, SQLState, &NativeError, MessageText, 1024, &TextLength );
        
        s += string( (char*)MessageText );
        s += " SQLSTATE=";
        s += string( (char*)SQLState );
        
    }
    s += " sqlcode=";
    s += intToString( sqlcode );
    return s;
}

/** 
 * 
 * ꥫͤФƤʸ֤
 * 
 */
string getResultCol( SQLHANDLE hstmt, int col, SQLSMALLINT targetType = SQL_C_CHAR )
{
    string s;
    SQLRETURN  sqlcode;
    SQLCHAR    BinaryPtr[5000];
    SQLLEN     BinaryLenOrInd;
    SQLINTEGER NumBytes;
    
    syslog_printf( "getResultCol" );
    while ( ( sqlcode = SQLGetData(hstmt, col, targetType, BinaryPtr, sizeof(BinaryPtr),
                                   &BinaryLenOrInd)) != SQL_NO_DATA) {
        syslog_printf( "SQLGetData BinaryLenOrInd=%d", BinaryLenOrInd );
        NumBytes = (BinaryLenOrInd > 5000) || (BinaryLenOrInd == SQL_NO_TOTAL) ? 5000 : BinaryLenOrInd;
        if( NumBytes <= 0 ) break;
        else if( NumBytes > 0 ){
            s += string( (char*)BinaryPtr, NumBytes );
        }
    }
    syslog_printf( "getResultCol returns %s", s.c_str() );
    return s;
}


/** 
 * 
 * Ȥʤɤ\ǥפ
 * 
 * @param str addslashes٤ʸNULLԲġ
 * @return Ѵʸ
 */
string addSlashes( const char *str )
{
	if ( hdbc == NULL ){
		string s;
		return s;
	}else{
        string s( str );
        return s;
    }
    
	int len = strlen(str) * 3;
    char* dst = new char[ len ];
    const char* from = str;
    char* to = dst;
    while( *from != '\0' ){
        switch( *from ){
        case '\'':
        case '\"':
        case ';':
            *to = '\\'; to++;
            break;
        }
        *to = *from; to++;
        from++;
    }
    *to = '\0';
	string s( dst );
    delete[] dst;
	return s;
}

/** Xoops Module Ĵ٤
  * @param module ⥸塼dirname
  * @param key    key
  * @param value  ֤ѿ
  * @return 
  */
static result_t getXoopsModuleConfigValue( const char *module, const char *key, char **value ){
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    result_t result = RES_ERROR;
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        string sql = "SELECT conf_value "
            " from " + dbprefix + "_config as tc, " + dbprefix  + "_modules as tm "
            " where tm.mid=tc.conf_modid and tm.dirname = ? and tc.conf_name = ? ";
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        SQLLEN cbModule = SQL_NTS, cbKey = SQL_NTS;
        SQLBindParameter(hstmt,  1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, strlen(module), 0, (SQLCHAR *)module, 0, &cbModule );
        SQLBindParameter(hstmt,  2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, strlen(key),    0, (SQLCHAR *)key,    0, &cbKey );
        sqlcode = SQLExecute( hstmt );
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            if ( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                string s = getResultCol( hstmt, 1 );
                *value = new char[s.length()+1];
                strcpy( *value, s.c_str() );
                result = RES_OK;
            }
            else if ( sqlcode == SQL_NO_DATA ){
                *value = 0;
                result = RES_OK;
            }
            else {
                string s( "SQLFetch in getXoopsModuleConfig " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += "sql=";
                s += sql;
                setLastErrorString( s.c_str( ) );
                result = RES_ERROR;
            }
        }else{
            string s( "SQLExecDirect in getXoopsModuleConfig " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += "sql=";
            s += sql;
            setLastErrorString( s.c_str( ) );
            result = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }
    else {
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getXoopsModuleConfig " );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        result = RES_ERROR;
    }
    return result;
}

/** ȥ桼XooNiPsPublicʥƥ򸫤뤳ȤǤ뤫ɤ֤
  */
static bool isGuestEnabled(){
    char *value = 0;
    result_t result = getConfigValue( XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_KEY, &value );
    if ( result != RES_OK )
        return false;
    if ( value == 0 )
        return false;
    bool enabled = ( strcmp( value, XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_ALL ) == 0 );
    freeString( value );
    return enabled;
}

/** siduid롣
  * @param sid session id 
  * @param uid uidѿ
  * @return RES_OK  
  *   sidͭsessionidǤ롣ξ*uidˤͭuid롣
  *   뤤ϡƥXooNiPs桼˸ sidsession::SID_GUEST(=0)Ǥ롣ξ硢*uidˤaccount::UID_GUEST(=0)롣
  * @return ¾            顼
  */
static result_t sessionID2UID( sessionid_t sid, userid_t *uid ){
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    
    if ( sid == session::SID_GUEST ){
        if ( isGuestEnabled() ){
            *uid = account::UID_GUEST;
            return RES_OK;
        }
        return RES_NO_SUCH_SESSION;
    }
    else {
        string sql = "SELECT uid FROM " + dbprefix + "_xoonips_session WHERE sid=" + unsignedIntToString(sid);
        syslog_printf( "sql=%s", sql.c_str() );
        return queryGetUnsignedInt( "sessionID2UID", sql, uid );
    }
}



/**
 * 
 * gid¸ߤå.
 * DBΥԤʤɤfalseȤʤ롥
 * 
 * @param gid åGID
 * @return true ¸ߤ
 * @return false ¸ߤʤ
 * 
 */
static bool gidExists( groupid_t gid )
{
    string sql;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) != SQL_SUCCESS ) {
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in gidExists" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        return false;
    }

    sql = "SELECT * FROM " + dbprefix + "_xoonips_groups ";
    sql += "WHERE gid=" + string( unsignedIntToString( gid ) );
    if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) != SQL_SUCCESS ){
        setLastErrorString( "SQLExecDirect in gidExists" );
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
        return false;
    }
    
    if( ( sqlcode = SQLFetch( hstmt ) ) != SQL_SUCCESS ){
        setLastErrorString( "SQLFetch in gidExists" );
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
        return false;
    }
    
    SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    return true;
}

    
/**
 * 
 * Platform桼uid¸ߤ뤫å.
 * DBΥԤʤɤfalseȤʤ롥
 * 
 * @param uid åUID
 * @return true ¸ߤ
 * @return false ¸ߤʤ
 * 
 */
static bool uidExists( userid_t uid )
{
    bool ret = false;
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    
    sql = "SELECT * FROM " + dbprefix + "_xoonips_users ";
    sql += "WHERE uid=" + string( unsignedIntToString( uid ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            if( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                ret = true;
            }else{
                string s( "SQLFetch in uidExists ");
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += string( ", sql=" ) + string( sql );
                setLastErrorString( s.c_str( ) );
                ret = false;
            }
        }else{
            string s( "SQLExecDirect in uidExists ");
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += string( ", sql=" ) + string( sql );
            setLastErrorString( s.c_str( ) );
            ret = false;
        }
    }else{
        string s( "SQLAllocHandle in uidExists ");
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = false;
    }
    return ret;
}

    
/**
 * 
 * criteria  SQLѴ
 * 
 * 
 * 
 */
string criteria2str( criteria* cri )
{
    string sql;
    
    const orderby* odrby = cri -> headOrderBy( );
    if( odrby != 0 ){
        sql += " ORDER BY " + string( odrby -> getColumn( ) );
        sql += ( odrby -> getOrder( ) == orderby::DESC ) ? " DESC" : " ";
        while( ( odrby = cri -> nextOrderBy( ) ) != 0 ){
            sql += ", " + string( odrby -> getColumn( ) );
            sql += ( odrby -> getOrder( ) == orderby::DESC ) ? " DESC" : " ";
        }
    }

    if( cri -> getLimitStart( ) != 0 || cri -> getLimitRows( ) != 0 ){
        sql += " LIMIT " + string( intToString( cri -> getLimitStart( ) ) )
            + ", " + string( intToString( cri -> getLimitRows( ) ) );
    }
    return sql;
}

/**
 *
 * Set the character code for database connection
 *
 * @param type DBTYPE_MYSQL or DBTYPE_SQLITE
 * @return RES_OK
 * @return RES_DB_INITIALIZE_ERROR
 * @see result_t
 */
static result_t setCharset( dbtype_t type ) {
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    string sql;
    result_t ret;
    ret = RES_OK;
#ifdef USE_MYSQL_CHARSET
    if( type == DBTYPE_MYSQL ) {
        sql = "SET NAMES ";
        sql += MYSQL_CHARSET;
        if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
            if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) == SQL_SUCCESS ) ) {
                ret = RES_OK;
                syslog_printf( "setCharset succeed" );
            } else {
                string s( "SQLExecDirect in setCharset ");
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += string( ", sql=" ) + string( sql );
                setLastErrorString( s.c_str() );
                ret = RES_DB_INITIALIZE_ERROR;
            }
            SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
        } else {
            string s( "SQLAllocHandle in setCharset ");
            s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
            setLastErrorString( s.c_str() );
            ret = RES_DB_INITIALIZE_ERROR;
        }
    }
#endif
    return ret;
}


/**
 * 
 * ǡ١³
 * 
 * @param dsn ODBCDSN
 * @param user ǡ١˥桼̾
 * @param password 嵭桼Υѥ
 * @param reserve ̤(NULL)
 * @param prefix XOOPSǡ١ơ֥PREFIX
 * @param type DBTYPE_MYSQL or DBTYPE_SQLITE
 * @return RES_OK
 * @return RES_DB_INITIALIZE_ERROR
 * @return RES_DB_CONNECT_ERROR
 * @see result_t
 */
result_t initializeDB( const char* dsn, const char* user, const char* password, const char* reserve, const char* prefix, dbtype_t type )
{
    SQLRETURN sqlcode;

    // ³ʤ顢ö
    if ( hdbc != NULL ){
        SQLDisconnect( hdbc );
        hdbc = NULL;
    }
    
    dbprefix = prefix;
    dbtype = type;
    
    // ³
//    if( SQLAllocEnv( &henv ) != SQL_SUCCESS ) {
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_ENV, SQL_NULL_HANDLE, &henv ) ) != SQL_SUCCESS ) {
        string s( "SQLAllocHandle(SQL_HANDLE_ENV,...) in initializeDB" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        syslog_printf( "initializeDB %s", getLastErrorString( ) );
        return RES_DB_INITIALIZE_ERROR;
    }
    //ODBC Ver.3 Ȥƿ񤦤褦°
    SQLSetEnvAttr(henv, SQL_ATTR_ODBC_VERSION, (void*)SQL_OV_ODBC3, 0); 
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_DBC, henv, &hdbc ) ) != SQL_SUCCESS ) {
        string s( "SQLAllocHandle(SQL_HANDLE_DBC,...) in initializeDB" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        syslog_printf( "initializeDB %s", getLastErrorString( ) );
        return RES_DB_INITIALIZE_ERROR;
    }
    //5ðʾפ饿ॢȤ
    //SQLSetConnectAttr(hdbc, SQL_LOGIN_TIMEOUT, (SQLPOINTER *)5, 0);
    
    if ( ( sqlcode = SQLConnect( hdbc, (SQLCHAR*)dsn, strlen( dsn ), (SQLCHAR*)user, strlen( user ), (SQLCHAR*)password, strlen( password ) ) ) != SQL_SUCCESS ){
        string s( "SQLConnect in initializeDB " );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        syslog_printf( "initializeDB %s", getLastErrorString( ) );
        return RES_DB_CONNECT_ERROR;
    }
    syslog_printf( "initializeDB succeed" );
    return setCharset( dbtype );
}

/**
 *
 * DB³ǤС롣
 * 
 * @param ʤ
 * @return RES_OK
 */
result_t uninitializeDB()
{
    if ( hdbc != NULL ){
        SQLDisconnect( hdbc );
        hdbc = NULL;
    }
    return RES_OK;
}

/**
 * 
 * Platform桼ǧּ
 * 
 * @param sid åID
 * @param uid ֤桼UID
 * @return true ǧѤ
 * @return false ̤ǧ
 * 
 */
bool isActivated( sessionid_t sid, userid_t uid )
{
    if( hdbc == NULL ) return false;
    if( !isValidSessionID( sid ) ) return false;
    
    bool ret = false;
    string sql;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    
    sql = "SELECT * FROM " + dbprefix + "_xoonips_users ";
    sql += "WHERE activate=1 and uid=" + string( unsignedIntToString( uid ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            if( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                ret = true;
            }else{
                string s( "SQLFetch in isActivated " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += ", sql=" + sql;
                setLastErrorString( s.c_str() );
                ret = false;
            }
        }else{
            string s( "SQLExecDirect in isActivated " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=" + sql;
            setLastErrorString( s.c_str() );
            ret = false;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in isActivated" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = false;
    }
    return ret;
}

/**
 * 
 * Platform桼ǧѹ
 * 
 * @param sid åID
 * @param uid ѹ桼UID
 * @param activate ǧ(true) / ̤ǧ(false)λ
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_USER
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_NOT_INITIALIZED;
 */
result_t activate( sessionid_t sid, userid_t uid, bool activate )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( sid != session_t::SID_GUEST 
        && !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    result_t ret = RES_ERROR;
    
    sql = "UPDATE " + dbprefix + "_xoonips_users ";
    sql += "SET activate=" + string( activate ? "1" : "0" );
    sql += " WHERE uid=" + string( unsignedIntToString( uid ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLLEN count = 0;
            if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                ret = RES_OK;
            }else{
                string s( "SQLRowCount in activate ");
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += string( ", sql=" ) + string( sql );
                setLastErrorString( s.c_str( ) );
                ret = RES_NO_SUCH_USER;
            }
        }else{
            string s( "SQLExecDirect in activate " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in activate" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * ȿ롥
 * 
 * @param sid åID
 * @return ȿ(Ի0)
 * 
 */
int getAccountCount( sessionid_t sid )
{
    if( hdbc == NULL ) return 0;
    if( !isValidSessionID( sid ) ) return 0;
    
    int ret = 0;
    string sql;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    
    //ȿ
    sql = "SELECT COUNT(*) FROM " + dbprefix + "_xoonips_users ";
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLUINTEGER count = 0;
            SQLLEN len = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &count, 0, &len );
            if( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                ret = count;
            }else {
                string s( "SQLFetch in getAccountCount sql=" );
                s += string( sql );
                setLastErrorString( s.c_str( ) );
                ret = 0;
            }
        }else{
            setLastErrorString( "SQLExecDirect in getAccountCount" );
            ret = 0;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getAccountCount" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = 0;
    }
    return ret;
}

/**
 * 
 * Ⱥ
 * 롼פκȥ桼κԤʤޤ
 * 
 * @param 
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * 
 */
result_t deleteAccount( sessionid_t sid, userid_t uid )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;

    result_t ret1 = RES_ERROR, ret2 = RES_ERROR;
    criteria_t c;
    string sql;
    groupid_t* gids;
    int gidsLen;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    
    /*
      1. delete user from default platform group
      2. delete user profile from xoops_users
      3. delete platform user from xoonips_users
     */
    
    //1. delete user from platform groups
    c.clearAll();
    if( getGroupsByUid( sid, uid, &c, &gids, &gidsLen ) == RES_OK ){
        for( int i = 0; i < gidsLen; i++ )
            deleteMemberNoLimit( sid, gids[ i ], uid );
        freeGID( gids );
    }
    
    //2. delete user profile from xoops_users
    sql = "DELETE FROM " + dbprefix + "_users ";
    sql += "WHERE uid = " + string( unsignedIntToString( uid ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLLEN count = 0;
            if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                ret1 = RES_OK;
            }else{
                string s( "SQLRowCount in deleteAccount" );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += string( ", sql=" ) + string( sql );
                setLastErrorString( s.c_str( ) );
                ret1 = RES_NO_SUCH_USER;
            }
        }else{
            string s( "SQLExecDirect in deleteAccount" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret1 = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in deleteAccount" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret1 = RES_ERROR;
    }
    
    //3. delete platform user from xoonips_users
    sql = "DELETE FROM " + dbprefix + "_xoonips_users ";
    sql += "WHERE uid = " + string( unsignedIntToString( uid ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLLEN count = 0;
            if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                ret2 = RES_OK;
            }else{
                string s( "SQLRowCount in deleteAccount" );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += string( ", sql=" ) + string( sql );
                setLastErrorString( s.c_str( ) );
                ret2 = RES_NO_SUCH_USER;
            }
        }else{
            string s( "SQLExecDirect in deleteAccount" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret2 = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in deleteAccount" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret2 = RES_ERROR;
    }
    
    //Ǥ⥨顼ʤ饨顼֤
    return ret1 != RES_OK ? ret1 : ret2;
}

/**
 * 
 * Ⱦ
 * 
 * @param sid åID
 * @param uid 桼UID
 * @param acc Ⱦ(account_t)Υݥ󥿤񤭹
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_USER
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @see freeAccount
 * 
 */
result_t getAccount( sessionid_t sid, userid_t uid, const account_t** acc )
{
    int len = 0;
    static criteria c;
    result_t res = getAccounts( sid, &uid, 1, &c, acc, &len );
    if( res == RES_OK && len == 0 ) return RES_NO_SUCH_USER;
    return res;
}

/**
 * 
 * Ⱦ
 * 
 * @param sid åID
 * @param uids 桼UID
 * @param uidsLen uidsǿ
 * @param cri ̤ϰϻꡤȾ
 * @param accounts ̤Υݥ󥿤񤭹
 * @param accountsLen ̤ο(*accountsǿ)
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @see freeAccount
 * 
 */
result_t getAccounts( sessionid_t sid, const userid_t* uids, int uidsLen, criteria_t* cri, const account_t** accounts, int* accountsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( uidsLen <= 0 ){
        *accounts = new account_t[ 0 ];
        *accountsLen = 0;
    syslog_printf( "getAccounts succeed len=0" );
        return RES_OK;
    }
    
    syslog_printf( "begin of getAccounts" );
    result_t ret = RES_ERROR;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    string sql;
    account_t* dst = new account_t[ uidsLen ];
    
    sql += "SELECT u1.uid, u1.name, u1.uname, u1.email, u1.url, u1.user_avatar, u1.user_regdate, u1.user_icq, u1.user_from, u1.user_sig, u1.user_viewemail, u1.actkey, u1.user_aim, u1.user_yim, u1.user_msnm, u1.pass, u1.posts, u1.attachsig, u1.rank, u1.level, u1.theme, u1.timezone_offset, u1.last_login, u1.umode, u1.uorder, u1.notify_method, u1.notify_mode, u1.user_occ, u1.bio, u1.user_intrest, u1.user_mailok, u2.activate, u2.address, u2.division, u2.tel, u2.company_name, u2.country, u2.zipcode, u2.fax, u2.notice_mail, u2.notice_mail_since, u2.private_index_id, u2.private_item_number_limit, u2.private_index_number_limit, u2.private_item_storage_limit ";
    sql += "FROM " + dbprefix + "_users AS u1, " + dbprefix + "_xoonips_users AS u2 ";
    sql += "WHERE u1.uid = u2.uid ";
    if( uidsLen > 0 ){
        syslog_printf( "set uid[%d] value=%d to ...", 0, uids[0] );
        sql += "AND ( u1.uid=" + string( unsignedIntToString( uids[ 0 ] ) );
        for( int i = 1; i < uidsLen; i++ ){
            syslog_printf( "set uid[%d] value=%d to ...", i, uids[i] );
            sql += " OR u1.uid=" + string( unsignedIntToString( uids[ i ] ) );
        }
        sql += " ) ";
    }
    sql += criteria2str( cri );
    syslog_printf( "sql=%s", sql.c_str() );
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        syslog_printf( "SQLAllocHandle" );
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            syslog_printf( "SQLExecDirect" );
            SQLLEN cbUid = 0, cbStorageLimit = 0;
            userid_t uid = 0;
            SQLDOUBLE storage_limit = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &uid, 0, &cbUid );
            SQLBindCol( hstmt, 45, SQL_C_DOUBLE, &storage_limit, 0, &cbStorageLimit );
            syslog_printf( "SQLBindCol" );
            *accountsLen=0;
            for( int i = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS && i < uidsLen ; i++ ){
                syslog_printf( "SQLFetch" );
                dst[ i ].setUID( uid );
                dst[ i ].setName( getResultCol( hstmt, 2 ).c_str() );
                dst[ i ].setUname( getResultCol( hstmt, 3 ).c_str() );
                dst[ i ].setEmail( getResultCol( hstmt, 4 ).c_str() );
                dst[ i ].setURL( getResultCol( hstmt, 5 ).c_str() );
                dst[ i ].setUserAvatar( getResultCol( hstmt, 6 ).c_str() );
                dst[ i ].setUserRegdate( atoi( getResultCol( hstmt, 7 ).c_str() ) );
                dst[ i ].setUserIcq( getResultCol( hstmt, 8 ).c_str() );
                dst[ i ].setUserFrom( getResultCol( hstmt, 9 ).c_str() );
                dst[ i ].setUserSig( getResultCol( hstmt, 10 ).c_str() );
                dst[ i ].setUserViewemail( atoi( getResultCol( hstmt, 11 ).c_str() ));
                dst[ i ].setActkey( getResultCol( hstmt, 12 ).c_str() );
                dst[ i ].setUserAim( getResultCol( hstmt, 13 ).c_str() );
                dst[ i ].setUserYim( getResultCol( hstmt, 14 ).c_str() );
                dst[ i ].setUserMsnm( getResultCol( hstmt, 15 ).c_str() );
                dst[ i ].setPass( getResultCol( hstmt, 16 ).c_str() );
                dst[ i ].setPosts( atoi( getResultCol( hstmt, 17 ).c_str() ));
                dst[ i ].setAttachsig( atoi( getResultCol( hstmt, 18 ).c_str() ));
                dst[ i ].setRank( atoi( getResultCol( hstmt, 19 ).c_str() ));
                dst[ i ].setLevel( atoi( getResultCol( hstmt, 20 ).c_str() ));
                dst[ i ].setTheme( getResultCol( hstmt, 21 ).c_str() );
                dst[ i ].setTimezoneOffset( atof( getResultCol( hstmt, 22 ).c_str() ) );
                dst[ i ].setLastLogin( atoi( getResultCol( hstmt, 23 ).c_str() ));
                dst[ i ].setUmode( getResultCol( hstmt, 24 ).c_str() );
                dst[ i ].setUorder( atoi( getResultCol( hstmt, 25 ).c_str() ));
                dst[ i ].setNotifyMethod( atoi( getResultCol( hstmt, 26 ).c_str() ));
                dst[ i ].setNotifyMode( atoi( getResultCol( hstmt, 27 ).c_str() ));
                dst[ i ].setUserOcc( getResultCol( hstmt, 28 ).c_str() );
                dst[ i ].setBio( getResultCol( hstmt, 29 ).c_str() );
                dst[ i ].setUserIntrest( getResultCol( hstmt, 30 ).c_str() );
                dst[ i ].setUserMailok( atoi( getResultCol( hstmt, 31 ).c_str() ));
                dst[ i ].setActivate( atoi( getResultCol( hstmt, 32 ).c_str() ));
                dst[ i ].setAddress( getResultCol( hstmt, 33 ).c_str() );
                dst[ i ].setDivision( getResultCol( hstmt, 34 ).c_str() );
                dst[ i ].setTel( getResultCol( hstmt, 35 ).c_str() );
                dst[ i ].setCompanyName( getResultCol( hstmt, 36 ).c_str() );
                dst[ i ].setCountry( getResultCol( hstmt, 37 ).c_str() );
                dst[ i ].setZipcode( getResultCol( hstmt, 38 ).c_str() );
                dst[ i ].setFax( getResultCol( hstmt, 39 ).c_str() );
                dst[ i ].setNoticeMail( atoi( getResultCol( hstmt, 40 ).c_str() ));
                dst[ i ].setNoticeMailSince( atoi( getResultCol( hstmt, 41 ).c_str() ));
                dst[ i ].setPrivateIndexID( atoi( getResultCol( hstmt, 42 ).c_str() ));
                dst[ i ].setItemNumberLimit( atoi( getResultCol( hstmt, 43 ).c_str() ));
                dst[ i ].setIndexNumberLimit( atoi( getResultCol( hstmt, 44 ).c_str() ));
                dst[ i ].setItemStorageLimit( storage_limit );
                ( *accountsLen )++;
            }
            *accounts = dst;
            syslog_printf( "getAccounts succeed" );
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in getAccounts" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += string( ", sql=" ) + string( sql );
            setLastErrorString( s.c_str( ) );
            syslog_printf( "getAccounts %s", getLastErrorString( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getAccounts" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        syslog_printf( "getAccounts %s", getLastErrorString( ) );
        ret = RES_DB_QUERY_ERROR;
    }
    return ret;
}

/**
 * 
 * Ͽ
 * 
 * 桼ǡ١Ͽޤ
 * Ͽ桼б桼IDuid˳Ǽޤ
 * 
 * @param sid å
 * @param account Ͽ륢Ⱦ
 * @param uid ϿȾб桼ID
 * @return RES_OK
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * 
 */
result_t insertAccount( sessionid_t sid, const account_t* account, userid_t* uid )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    string sql;
    string tmp;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    result_t ret = RES_ERROR;
    
    /*
      1. insert user profile into xoops_users
      2. insert platform user profile into xoonips_users
      3. add user to default platform group
      4. create private index
      5. update account set private_index_id=...
     */
    
    //1.xoopsΥ桼ơ֥˽񤭹
    SQLCHAR uname[ACCOUNT_UNAME_LEN+1], name[ACCOUNT_NAME_LEN+1], email[ACCOUNT_EMAIL_LEN+1], url[ACCOUNT_URL_LEN+1], user_avatar[ACCOUNT_USER_AVATAR_LEN+1], user_icq[ACCOUNT_USER_ICQ_LEN+1], user_from[ACCOUNT_USER_FROM_LEN+1], user_sig[ACCOUNT_USER_SIG_LEN+1], actkey[ACCOUNT_ACTKEY_LEN+1], user_aim[ACCOUNT_USER_AIM_LEN+1], user_yim[ACCOUNT_USER_YIM_LEN+1], user_msnm[ACCOUNT_USER_MSNM_LEN+1], pass[ACCOUNT_PASS_LEN+1], theme[ACCOUNT_THEME_LEN+1], umode[ACCOUNT_UMODE_LEN+1], user_occ[ACCOUNT_USER_OCC_LEN+1], bio[ACCOUNT_BIO_LEN+1], user_intrest[ACCOUNT_USER_INTREST_LEN+1];
    SQLINTEGER user_regdate, user_viewemail, posts, attachsig, rank, level, last_login, uorder, notify_method, notify_mode, user_mailok;
    SQLDOUBLE timezone_offset;
    
    SQLLEN cbUname = SQL_NTS, cbName = SQL_NTS, cbEmail = SQL_NTS, cbUrl = SQL_NTS, cbUser_avatar = SQL_NTS, cbUser_icq = SQL_NTS, cbUser_from = SQL_NTS, cbUser_sig = SQL_NTS, cbActkey = SQL_NTS, cbUser_aim = SQL_NTS, cbUser_yim = SQL_NTS, cbUser_msnm = SQL_NTS, cbPass = SQL_NTS, cbTheme = SQL_NTS, cbUmode = SQL_NTS, cbUser_occ = SQL_NTS, cbBio = SQL_NTS, cbUser_intrest = SQL_NTS;
    SQLLEN cbUser_regdate = 0, cbUser_viewemail = 0, cbPosts = 0, cbAttachsig = 0, cbRank = 0, cbLevel = 0, cbLast_login = 0, cbUorder = 0, cbNotify_method = 0, cbNotify_mode = 0, cbUser_mailok = 0, cbTimezone_offset = 0;

    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        string sql;
        sql = "INSERT INTO " + dbprefix + "_users (uname, name, email, url, user_avatar, user_regdate, user_icq, user_from, user_sig, user_viewemail, actkey, user_aim, user_yim, user_msnm, pass, posts, attachsig, rank, level, theme, timezone_offset, last_login, umode, uorder, notify_method, notify_mode, user_occ, bio, user_intrest, user_mailok) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            SQLBindParameter(hstmt,  1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_UNAME_LEN, 0, uname, 0, &cbUname );
            SQLBindParameter(hstmt,  2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_NAME_LEN, 0, name, 0, &cbName );
            SQLBindParameter(hstmt,  3, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_EMAIL_LEN, 0, email, 0, &cbEmail );
            SQLBindParameter(hstmt,  4, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_URL_LEN, 0, url, 0, &cbUrl );
            SQLBindParameter(hstmt,  5, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_AVATAR_LEN, 0, user_avatar, 0, &cbUser_avatar );
            SQLBindParameter(hstmt,  6, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &user_regdate, 0, &cbUser_regdate );
            SQLBindParameter(hstmt,  7, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_ICQ_LEN, 0, user_icq, 0, &cbUser_icq );
            SQLBindParameter(hstmt,  8, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_FROM_LEN, 0, user_from, 0, &cbUser_from );
            SQLBindParameter(hstmt,  9, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_SIG_LEN, 0, user_sig, 0, &cbUser_sig );
            SQLBindParameter(hstmt, 10, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &user_viewemail, 0, &cbUser_viewemail );
            SQLBindParameter(hstmt, 11, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_ACTKEY_LEN, 0, actkey, 0, &cbActkey );
            SQLBindParameter(hstmt, 12, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_AIM_LEN, 0, user_aim, 0, &cbUser_aim );
            SQLBindParameter(hstmt, 13, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_YIM_LEN, 0, user_yim, 0, &cbUser_yim );
            SQLBindParameter(hstmt, 14, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_MSNM_LEN, 0, user_msnm, 0, &cbUser_msnm );
            SQLBindParameter(hstmt, 15, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_PASS_LEN, 0, pass, 0, &cbPass );
            SQLBindParameter(hstmt, 16, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &posts, 0, &cbPosts );
            SQLBindParameter(hstmt, 17, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &attachsig, 0, &cbAttachsig );
            SQLBindParameter(hstmt, 18, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &rank, 0, &cbRank );
            SQLBindParameter(hstmt, 19, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &level, 0, &cbLevel );
            SQLBindParameter(hstmt, 20, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_THEME_LEN, 0, theme, 0, &cbTheme );
            SQLBindParameter(hstmt, 21, SQL_PARAM_INPUT, SQL_C_DOUBLE, SQL_DOUBLE, 0, 0, &timezone_offset, 0, &cbTimezone_offset );
            SQLBindParameter(hstmt, 22, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &last_login, 0, &cbLast_login );
            SQLBindParameter(hstmt, 23, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_UMODE_LEN, 0, umode, 0, &cbUmode );
            SQLBindParameter(hstmt, 24, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &uorder, 0, &cbUorder );
            SQLBindParameter(hstmt, 25, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &notify_method, 0, &cbNotify_method );
            SQLBindParameter(hstmt, 26, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &notify_mode, 0, &cbNotify_mode );
            SQLBindParameter(hstmt, 27, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_OCC_LEN, 0, user_occ, 0, &cbUser_occ );
            SQLBindParameter(hstmt, 28, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_BIO_LEN, 0, bio, 0, &cbBio );
            SQLBindParameter(hstmt, 29, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_INTREST_LEN, 0, user_intrest, 0, &cbUser_intrest );
            SQLBindParameter(hstmt, 30, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &user_mailok, 0, &cbUser_mailok );

            strncpy2( (char*)uname, account -> getUname( ), ACCOUNT_UNAME_LEN );
            strncpy2( (char*)name, account -> getName( ), ACCOUNT_NAME_LEN );
            strncpy2( (char*)email, account -> getEmail( ), ACCOUNT_EMAIL_LEN );
            strncpy2( (char*)url, account -> getURL( ), ACCOUNT_URL_LEN );
            strncpy2( (char*)user_avatar, account -> getUserAvatar( ), ACCOUNT_USER_AVATAR_LEN );
            user_regdate = time( NULL );
            strncpy2( (char*)user_icq, account -> getUserIcq( ), ACCOUNT_USER_ICQ_LEN );
            strncpy2( (char*)user_from, account -> getUserFrom( ), ACCOUNT_USER_FROM_LEN );
            strncpy2( (char*)user_sig, account -> getUserSig( ), ACCOUNT_USER_SIG_LEN );
            user_viewemail = account -> getUserViewemail( );
            strncpy2( (char*)actkey, account -> getActkey( ), ACCOUNT_ACTKEY_LEN );
            strncpy2( (char*)user_aim, account -> getUserAim( ), ACCOUNT_USER_AIM_LEN );
            strncpy2( (char*)user_yim, account -> getUserYim( ), ACCOUNT_USER_YIM_LEN );
            strncpy2( (char*)user_msnm, account -> getUserMsnm( ), ACCOUNT_USER_MSNM_LEN );
            strncpy2( (char*)pass, account -> getPass( ), ACCOUNT_PASS_LEN );
            posts = account -> getPosts( );
            attachsig = account -> getAttachsig( );
            rank = account -> getRank( );
            level = account -> getLevel( );
            strncpy2( (char*)theme, account -> getTheme( ), ACCOUNT_THEME_LEN );
            timezone_offset = account -> getTimezoneOffset( );
            last_login = 0;
            strncpy2( (char*)umode, account -> getUmode( ), ACCOUNT_UMODE_LEN );
            uorder = account -> getUorder( );
            notify_method = account -> getNotifyMethod( );
            notify_mode = account -> getNotifyMode( );
            strncpy2( (char*)user_occ, account -> getUserOcc( ), ACCOUNT_USER_OCC_LEN );
            strncpy2( (char*)bio, account -> getBio( ), ACCOUNT_BIO_LEN );
            strncpy2( (char*)user_intrest, account -> getUserIntrest( ), ACCOUNT_USER_INTREST_LEN );
            user_mailok = account -> getUserMailok( );

            if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                SQLLEN count = 0;
                if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                    //桼ID
                    if( dbtype == DBTYPE_MYSQL ){
                        sql = "SELECT LAST_INSERT_ID()";
                    }else if( dbtype == DBTYPE_SQLITE ){
                        sql = "SELECT LAST_INSERT_ROWID()";
                    }
                    ret = queryGetUnsignedInt( "insertAccount", sql, (unsigned int*)uid );
                }else{
                    string s( "SQLRowCount in insertAccount sql=" );
                    s += string( sql );
                    setLastErrorString( s.c_str( ) );
                    ret = RES_DB_QUERY_ERROR;
                }
            }else{
                string s( "SQLExecute in insertAccount " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else{
            string s( "SQLPrepare in insertAccount " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            setLastErrorString( s.c_str( ) );
            ret = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in insertAccount" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    
    if( ret == RES_OK ){
        //2.xoonipsΥ桼ơ֥˻Ĥξ񤭹
        SQLUINTEGER activate;
        SQLCHAR address[XNP_ACCOUNT_ADDRESS_LEN+1];
        SQLCHAR division[XNP_ACCOUNT_DIVISION_LEN+1];
        SQLCHAR tel[XNP_ACCOUNT_TEL_LEN+1];
        SQLCHAR company_name[XNP_ACCOUNT_COMPANY_NAME_LEN+1];
        SQLCHAR country[XNP_ACCOUNT_COUNTRY_LEN+1];
        SQLCHAR zipcode[XNP_ACCOUNT_ZIPCODE_LEN+1];
        SQLCHAR fax[XNP_ACCOUNT_FAX_LEN+1];
        SQLLEN cbAddress = SQL_NTS, cbDivision = SQL_NTS, cbTel = SQL_NTS, cbCompany_name = SQL_NTS, cbCountry = SQL_NTS, cbZipcode = SQL_NTS, cbFax = SQL_NTS;
        SQLLEN cbUid = 0, cbActivate = 0, cbNotice_mail = 0, cbNotice_mail_since = 0, cbItem_number_limit = 0, cbIndex_number_limit = 0, cbItem_storage_limit = 0;
        SQLUINTEGER notice_mail;
        SQLUINTEGER notice_mail_since;
        SQLINTEGER item_number_limit;
        SQLINTEGER index_number_limit;
        SQLDOUBLE item_storage_limit;

        if( ret == RES_OK && ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
            string sql;
            sql = "INSERT INTO " + dbprefix + "_xoonips_users (uid, activate, address, division, tel, company_name, country, zipcode, fax, notice_mail, notice_mail_since, private_item_number_limit, private_index_number_limit, private_item_storage_limit) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
            sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
            if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
                SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_INTEGER, 0, 0, uid, 0, &cbUid);
                SQLBindParameter(hstmt, 2, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_INTEGER, 0, 0, &activate, 0, &cbActivate);
                SQLBindParameter(hstmt, 3, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ACCOUNT_ADDRESS_LEN, 0, address, 0, &cbAddress); 
                SQLBindParameter(hstmt, 4, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ACCOUNT_DIVISION_LEN, 0, division, 0, &cbDivision); 
                SQLBindParameter(hstmt, 5, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ACCOUNT_TEL_LEN, 0, tel, 0, &cbTel); 
                SQLBindParameter(hstmt, 6, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ACCOUNT_COMPANY_NAME_LEN, 0, company_name, 0, &cbCompany_name); 
                SQLBindParameter(hstmt, 7, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ACCOUNT_COUNTRY_LEN, 0, country, 0, &cbCountry); 
                SQLBindParameter(hstmt, 8, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ACCOUNT_ZIPCODE_LEN, 0, zipcode, 0, &cbZipcode); 
                SQLBindParameter(hstmt, 9, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ACCOUNT_FAX_LEN, 0, fax, 0, &cbFax); 
                SQLBindParameter(hstmt, 10, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_INTEGER, 0, 0, &notice_mail, 0, &cbNotice_mail);
                SQLBindParameter(hstmt, 11, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_INTEGER, 0, 0, &notice_mail_since, 0, &cbNotice_mail_since);
                SQLBindParameter(hstmt, 12, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_INTEGER, 0, 0, &item_number_limit, 0, &cbItem_number_limit);
                SQLBindParameter(hstmt, 13, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_INTEGER, 0, 0, &index_number_limit, 0, &cbIndex_number_limit);
                SQLBindParameter(hstmt, 14, SQL_PARAM_INPUT, SQL_C_DOUBLE, SQL_DOUBLE, 0, 0, &item_storage_limit, 0, &cbItem_storage_limit);
            
                activate = account -> getActivate() ? 1 : 0;
                strncpy2( (char*)address, account -> getAddress(), XNP_ACCOUNT_ADDRESS_LEN );
                strncpy2( (char*)division, account -> getDivision(), XNP_ACCOUNT_DIVISION_LEN );
                strncpy2( (char*)tel, account -> getTel(), XNP_ACCOUNT_TEL_LEN );
                strncpy2( (char*)company_name, account -> getCompanyName(), XNP_ACCOUNT_COMPANY_NAME_LEN );
                strncpy2( (char*)country, account -> getCountry(), XNP_ACCOUNT_COUNTRY_LEN );
                strncpy2( (char*)zipcode, account -> getZipcode(), XNP_ACCOUNT_ZIPCODE_LEN );
                strncpy2( (char*)fax, account -> getFax(), XNP_ACCOUNT_FAX_LEN );
                notice_mail = account -> getNoticeMail( );
                notice_mail_since = time( NULL );
                item_number_limit = account -> getItemNumberLimit( );
                index_number_limit = account -> getIndexNumberLimit( );
                item_storage_limit = account -> getItemStorageLimit( );
            
                if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                    SQLLEN count = 0;
                    if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                        ret = RES_OK;
                        if( ret == RES_OK ){
                            //3.add new user to default group(not a group admin)
                            ret = insertMember( sid, group_t::GID_DEFAULT, *uid, false );
                        }else{
                            //xoops_usersinsert쥳ɤ
                            sql = "DELETE FROM " + dbprefix + "_users where uid=";
                            sql += unsignedIntToString( *uid );
                            SQLHANDLE hstmt2 = NULL;
                            if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt2 ) ) == SQL_SUCCESS ) {
                                SQLExecDirect( hstmt2, (SQLCHAR*)sql.c_str(), sql.length() );
                                SQLFreeHandle( SQL_HANDLE_STMT, hstmt2 );
                            }
                            setLastErrorString( "insertMember in insertAccount" );
                            ret = RES_DB_QUERY_ERROR;
                        }
                    }else{
                        string s( "SQLRowCount in insertAccount sql=" );
                        s += string( sql );
                        setLastErrorString( s.c_str( ) );
                        ret = RES_DB_QUERY_ERROR;
                    }
                }else{
                    string s( "SQLExecute in insertAccount " );
                    s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                    setLastErrorString( s.c_str( ) );
                    ret = RES_DB_QUERY_ERROR;
                }
            }else{
                //xoops_usersinsert쥳ɤ
                sql = "DELETE FROM " + dbprefix + "_users where uid=";
                sql += unsignedIntToString( *uid );
                SQLHANDLE hstmt2 = NULL;
                if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt2 ) ) == SQL_SUCCESS ) {
                    SQLExecDirect( hstmt2, (SQLCHAR*)sql.c_str(), sql.length() );
                    SQLFreeHandle( SQL_HANDLE_STMT, hstmt2 );
                }
                string s( "SQLExecDirect in insertAccount sql=" );
                s += string( sql );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
            SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
        }else{
            string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in insertAccount" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
            ret = RES_ERROR;
        }
    }
    
    if ( ret == RES_OK ){
        //4.private index
        
        // private indexѤsort_number
        string sql = "select min(sort_number) from " + 
          dbprefix + "_xoonips_index where parent_index_id=" + unsignedIntToString(item::IID_ROOT) + 
          " and open_level=" + unsignedIntToString(index::OL_PRIVATE);
        unsigned int sortNumber;
        ret = queryGetUnsignedInt( "insertAccount", sql, &sortNumber );
        sortNumber--;
        if ( ret == RES_OK ){
            // private index
            index_t index;
            index.setParentIndexID(item::IID_ROOT);
            index.setOwnerUID(*uid);
            index.setOpenLevel(index::OL_PRIVATE);
            index.setSortNumber(sortNumber);
            index.setTitle(account->getUname());
            indexid_t privateXID;
            ret = insertIndexInternal( sid, &index, &privateXID );
            if ( ret == RES_OK ){
                // xnpaccuont_usersprivate_index_idν񤭴
                sql = "UPDATE " + dbprefix + "_xoonips_users SET private_index_id=" 
                  + unsignedIntToString(privateXID) + " WHERE uid=" + unsignedIntToString(*uid);
                ret = querySimple( "insertAccount", sql );
            }
        }
    }
    
    return ret;
}

/**
 * 
 * Ⱦѹ.
 * accountuidˡѹоݥ桼ID򥻥åȤƤ
 * 
 * @param sid åID
 * @param account ѹȾ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_USER
 * @return RES_ERROR
 * 
 */
result_t updateAccount( sessionid_t sid, const account_t* account )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( account == NULL ) return RES_ERROR;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !uidExists( account -> getUID( ) ) ) return RES_NO_SUCH_USER;

    SQLRETURN sqlcode;
    result_t ret = RES_ERROR;
    SQLHANDLE hstmt = NULL;
    
    //xoopsΥ桼ơ֥˽񤭹
    SQLCHAR uname[ACCOUNT_UNAME_LEN+1], name[ACCOUNT_NAME_LEN+1], email[ACCOUNT_EMAIL_LEN+1], url[ACCOUNT_URL_LEN+1], user_avatar[ACCOUNT_USER_AVATAR_LEN+1], user_icq[ACCOUNT_USER_ICQ_LEN+1], user_from[ACCOUNT_USER_FROM_LEN+1], user_sig[ACCOUNT_USER_SIG_LEN+1], actkey[ACCOUNT_ACTKEY_LEN+1], user_aim[ACCOUNT_USER_AIM_LEN+1], user_yim[ACCOUNT_USER_YIM_LEN+1], user_msnm[ACCOUNT_USER_MSNM_LEN+1], pass[ACCOUNT_PASS_LEN+1], theme[ACCOUNT_THEME_LEN+1], umode[ACCOUNT_UMODE_LEN+1], user_occ[ACCOUNT_USER_OCC_LEN+1], bio[ACCOUNT_BIO_LEN+1], user_intrest[ACCOUNT_USER_INTREST_LEN+1];
    SQLINTEGER uid, user_regdate, user_viewemail, posts, attachsig, rank, level, last_login, uorder, notify_method, notify_mode, user_mailok;
    SQLDOUBLE timezone_offset;
    
    SQLLEN cbUname = SQL_NTS, cbName = SQL_NTS, cbEmail = SQL_NTS, cbUrl = SQL_NTS, cbUser_avatar = SQL_NTS, cbUser_icq = SQL_NTS, cbUser_from = SQL_NTS, cbUser_sig = SQL_NTS, cbActkey = SQL_NTS, cbUser_aim = SQL_NTS, cbUser_yim = SQL_NTS, cbUser_msnm = SQL_NTS, cbPass = SQL_NTS, cbTheme = SQL_NTS, cbUmode = SQL_NTS, cbUser_occ = SQL_NTS, cbBio = SQL_NTS, cbUser_intrest = SQL_NTS;
    SQLLEN cbUid = 0, cbUser_regdate = 0, cbUser_viewemail = 0, cbPosts = 0, cbAttachsig = 0, cbRank = 0, cbLevel = 0, cbLast_login = 0, cbUorder = 0, cbNotify_method = 0, cbNotify_mode = 0, cbUser_mailok = 0, cbTimezone_offset = 0;

    SQLUINTEGER activate;
    SQLCHAR address[XNP_ACCOUNT_ADDRESS_LEN+1];
    SQLCHAR division[XNP_ACCOUNT_DIVISION_LEN+1];
    SQLCHAR tel[XNP_ACCOUNT_TEL_LEN+1];
    SQLCHAR company_name[XNP_ACCOUNT_COMPANY_NAME_LEN+1];
    SQLCHAR country[XNP_ACCOUNT_COUNTRY_LEN+1];
    SQLCHAR zipcode[XNP_ACCOUNT_ZIPCODE_LEN+1];
    SQLCHAR fax[XNP_ACCOUNT_FAX_LEN+1];
    SQLLEN cbActivate = 0, cbAddress = SQL_NTS, cbDivision = SQL_NTS, cbTel = SQL_NTS, cbCompany_name = SQL_NTS, cbCountry = SQL_NTS, cbZipcode = SQL_NTS, cbFax = SQL_NTS;
    SQLUINTEGER notice_mail, notice_mail_since;
    SQLLEN cbNotice_mail = 0, cbNotice_mail_since = 0;

    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        string sql;

        sql = "UPDATE " + dbprefix + "_users SET ";
        sql += "uname=?";
        sql += ", name=?";
        sql += ", email=?";
        sql += ", url=?";
        sql += ", user_avatar=?";
        sql += ", user_regdate=?";
        sql += ", user_icq=?";
        sql += ", user_from=?";
        sql += ", user_sig=?";
        sql += ", user_viewemail=?";
        sql += ", actkey=?";
        sql += ", user_aim=?";
        sql += ", user_yim=?";
        sql += ", user_msnm=?";
        sql += ", pass=?";
        sql += ", posts=?";
        sql += ", attachsig=?";
        sql += ", rank=?";
        sql += ", level=?";
        sql += ", theme=?";
        sql += ", timezone_offset=?";
        sql += ", last_login=?";
        sql += ", umode=?";
        sql += ", uorder=?";
        sql += ", notify_method=?";
        sql += ", notify_mode=?";
        sql += ", user_occ=?";
        sql += ", bio=?";
        sql += ", user_intrest=?";
        sql += ", user_mailok=? ";
        sql += " WHERE uid = ?";

        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            SQLBindParameter(hstmt,  1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_UNAME_LEN, 0, uname, 0, &cbUname );
            SQLBindParameter(hstmt,  2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_NAME_LEN, 0, name, 0, &cbName );
            SQLBindParameter(hstmt,  3, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_EMAIL_LEN, 0, email, 0, &cbEmail );
            SQLBindParameter(hstmt,  4, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_URL_LEN, 0, url, 0, &cbUrl );
            SQLBindParameter(hstmt,  5, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_AVATAR_LEN, 0, user_avatar, 0, &cbUser_avatar );
            SQLBindParameter(hstmt,  6, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &user_regdate, 0, &cbUser_regdate );
            SQLBindParameter(hstmt,  7, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_ICQ_LEN, 0, user_icq, 0, &cbUser_icq );
            SQLBindParameter(hstmt,  8, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_FROM_LEN, 0, user_from, 0, &cbUser_from );
            SQLBindParameter(hstmt,  9, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_SIG_LEN, 0, user_sig, 0, &cbUser_sig );
            SQLBindParameter(hstmt, 10, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &user_viewemail, 0, &cbUser_viewemail );
            SQLBindParameter(hstmt, 11, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_ACTKEY_LEN, 0, actkey, 0, &cbActkey );
            SQLBindParameter(hstmt, 12, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_AIM_LEN, 0, user_aim, 0, &cbUser_aim );
            SQLBindParameter(hstmt, 13, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_YIM_LEN, 0, user_yim, 0, &cbUser_yim );
            SQLBindParameter(hstmt, 14, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_MSNM_LEN, 0, user_msnm, 0, &cbUser_msnm );
            SQLBindParameter(hstmt, 15, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_PASS_LEN, 0, pass, 0, &cbPass );
            SQLBindParameter(hstmt, 16, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &posts, 0, &cbPosts );
            SQLBindParameter(hstmt, 17, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &attachsig, 0, &cbAttachsig );
            SQLBindParameter(hstmt, 18, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &rank, 0, &cbRank );
            SQLBindParameter(hstmt, 19, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &level, 0, &cbLevel );
            SQLBindParameter(hstmt, 20, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_THEME_LEN, 0, theme, 0, &cbTheme );
            SQLBindParameter(hstmt, 21, SQL_PARAM_INPUT, SQL_C_DOUBLE, SQL_DOUBLE, 0, 0, &timezone_offset, 0, &cbTimezone_offset );
            SQLBindParameter(hstmt, 22, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &last_login, 0, &cbLast_login );
            SQLBindParameter(hstmt, 23, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_UMODE_LEN, 0, umode, 0, &cbUmode );
            SQLBindParameter(hstmt, 24, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &uorder, 0, &cbUorder );
            SQLBindParameter(hstmt, 25, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &notify_method, 0, &cbNotify_method );
            SQLBindParameter(hstmt, 26, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &notify_mode, 0, &cbNotify_mode );
            SQLBindParameter(hstmt, 27, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_OCC_LEN, 0, user_occ, 0, &cbUser_occ );
            SQLBindParameter(hstmt, 28, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_BIO_LEN, 0, bio, 0, &cbBio );
            SQLBindParameter(hstmt, 29, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, ACCOUNT_USER_INTREST_LEN, 0, user_intrest, 0, &cbUser_intrest );
            SQLBindParameter(hstmt, 30, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &user_mailok, 0, &cbUser_mailok );
            SQLBindParameter(hstmt, 31, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &uid, 0, &cbUid );
            
            strncpy2( (char*)uname, account -> getUname( ), ACCOUNT_UNAME_LEN );
            strncpy2( (char*)name, account -> getName( ), ACCOUNT_NAME_LEN );
            strncpy2( (char*)email, account -> getEmail( ), ACCOUNT_EMAIL_LEN );
            strncpy2( (char*)url, account -> getURL( ), ACCOUNT_URL_LEN );
            strncpy2( (char*)user_avatar, account -> getUserAvatar( ), ACCOUNT_USER_AVATAR_LEN );
            user_regdate = time( NULL );
            strncpy2( (char*)user_icq, account -> getUserIcq( ), ACCOUNT_USER_ICQ_LEN );
            strncpy2( (char*)user_from, account -> getUserFrom( ), ACCOUNT_USER_FROM_LEN );
            strncpy2( (char*)user_sig, account -> getUserSig( ), ACCOUNT_USER_SIG_LEN );
            user_viewemail = account -> getUserViewemail( );
            strncpy2( (char*)actkey, account -> getActkey( ), ACCOUNT_ACTKEY_LEN );
            strncpy2( (char*)user_aim, account -> getUserAim( ), ACCOUNT_USER_AIM_LEN );
            strncpy2( (char*)user_yim, account -> getUserYim( ), ACCOUNT_USER_YIM_LEN );
            strncpy2( (char*)user_msnm, account -> getUserMsnm( ), ACCOUNT_USER_MSNM_LEN );
            strncpy2( (char*)pass, account -> getPass( ), ACCOUNT_PASS_LEN );
            posts = account -> getPosts( );
            attachsig = account -> getAttachsig( );
            rank = account -> getRank( );
            level = account -> getLevel( );
            strncpy2( (char*)theme, account -> getTheme( ), ACCOUNT_THEME_LEN );
            timezone_offset = account -> getTimezoneOffset( );
            last_login = 0;
            strncpy2( (char*)umode, account -> getUmode( ), ACCOUNT_UMODE_LEN );
            uorder = account -> getUorder( );
            notify_method = account -> getNotifyMethod( );
            notify_mode = account -> getNotifyMode( );
            strncpy2( (char*)user_occ, account -> getUserOcc( ), ACCOUNT_USER_OCC_LEN );
            strncpy2( (char*)bio, account -> getBio( ), ACCOUNT_BIO_LEN );
            strncpy2( (char*)user_intrest, account -> getUserIntrest( ), ACCOUNT_USER_INTREST_LEN );
            user_mailok = account -> getUserMailok( );
            uid = account -> getUID( );
            
            if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                SQLLEN count = 0;
                if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                    ret = RES_OK;
                }else{
                    string s( "SQLRowCount in updateAccount sql=" );
                    s += string( sql );
                    setLastErrorString( s.c_str( ) );
                    ret = RES_DB_QUERY_ERROR;
                }
            }else{
                string s( "SQLExecute in updateAccount 1 " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else{
            setLastErrorString( "SQLPrepare in updateAccount sql=" );
            ret = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
        hstmt = NULL;
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in updateAccount" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    
    if( ret != RES_OK ){
        return ret;
    }
    
    //xoonipsΥ桼ơ֥˻Ĥξ񤭤
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        string sql;

        sql = "UPDATE " + dbprefix + "_xoonips_users SET ";
        sql += "activate=?, ";
        sql += "address=?, ";
        sql += "division=?, ";
        sql += "tel=?, ";
        sql += "company_name=?, ";
        sql += "country=?, ";
        sql += "zipcode=?, ";
        sql += "fax=?, ";
        sql += "notice_mail=?, ";
        sql += "notice_mail_since=? ,";
        sql += "private_item_number_limit=" + unsignedIntToString( account -> getItemNumberLimit( ) ) + " ,";
        sql += "private_index_number_limit=" + unsignedIntToString( account -> getIndexNumberLimit( ) ) + " ,";
        sql += "private_item_storage_limit=" + doubleToString( account -> getItemStorageLimit( ) ) + " ";
        sql += "WHERE uid=?"; 
    
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_INTEGER, 0, 0, &activate, 0, &cbActivate);
            SQLBindParameter(hstmt, 2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ACCOUNT_ADDRESS_LEN, 0, address, 0, &cbAddress); 
            SQLBindParameter(hstmt, 3, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ACCOUNT_DIVISION_LEN, 0, division, 0, &cbDivision); 
            SQLBindParameter(hstmt, 4, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ACCOUNT_TEL_LEN, 0, tel, 0, &cbTel); 
            SQLBindParameter(hstmt, 5, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ACCOUNT_COMPANY_NAME_LEN, 0, company_name, 0, &cbCompany_name); 
            SQLBindParameter(hstmt, 6, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ACCOUNT_COUNTRY_LEN, 0, country, 0, &cbCountry); 
            SQLBindParameter(hstmt, 7, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ACCOUNT_ZIPCODE_LEN, 0, zipcode, 0, &cbZipcode); 
            SQLBindParameter(hstmt, 8, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ACCOUNT_FAX_LEN, 0, fax, 0, &cbFax); 
            SQLBindParameter(hstmt, 9, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_INTEGER, 0, 0, &notice_mail, 0, &cbNotice_mail);
            SQLBindParameter(hstmt, 10, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_INTEGER, 0, 0, &notice_mail_since, 0, &cbNotice_mail_since);
            SQLBindParameter(hstmt, 11, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &uid, 0, &cbUid );
            
            activate = account -> getActivate() ? 1 : 0;
            strncpy2( (char*)address, account -> getAddress( ) , XNP_ACCOUNT_ADDRESS_LEN );
            strncpy2( (char*)division, account -> getDivision(), XNP_ACCOUNT_DIVISION_LEN );
            strncpy2( (char*)tel, account -> getTel(), XNP_ACCOUNT_TEL_LEN );
            strncpy2( (char*)company_name, account -> getCompanyName(), XNP_ACCOUNT_COMPANY_NAME_LEN );
            strncpy2( (char*)country, account -> getCountry(), XNP_ACCOUNT_COUNTRY_LEN );
            strncpy2( (char*)zipcode, account -> getZipcode(), XNP_ACCOUNT_ZIPCODE_LEN );
            strncpy2( (char*)fax, account -> getFax(), XNP_ACCOUNT_FAX_LEN );
            notice_mail = account -> getNoticeMail( );
            notice_mail_since = account -> getNoticeMailSince( );
            uid = account -> getUID( );
            
            if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                SQLLEN count = 0;
                if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                    ret = RES_OK;
                }else{
                    string s( "SQLRowCount in updateAccount sql=" );
                    s += string( sql );
                    setLastErrorString( s.c_str( ) );
                    ret = RES_DB_QUERY_ERROR;
                }
            }else{
                string s( "SQLExecute in updateAccount 2 " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else{
            setLastErrorString( "SQLPrepare in updateAccount sql=" );
            ret = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in updateAccount" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * criteria_tǻꤵ줿ϰϤΥ桼ID֤.
 * 桼IDݤƤ˽񤭹ߡΥɥ쥹*uids˽񤭹.
 * Υ*uidsLen˽񤭹
 * 
 * @param sid åID
 * @param cri ̤ϰϻꡤȾ
 * @param uids 桼UIDν
 * @param uidsLen uidsǿν
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @see freeUID
 */
result_t dumpUids( sessionid_t sid, criteria_t* cri, userid_t** uids, int* uidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    result_t ret = RES_ERROR;
    userid_t* dst = 0;
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    SQLLEN count = 0;
            

    sql = "SELECT uid FROM " + dbprefix + "_xoonips_users ";
    sql += criteria2str( cri );
    if( countResultRows( sql.c_str(), &count ) == RES_OK ){
        *uidsLen = count;
        dst = new userid_t[ *uidsLen ];
        *uids = dst;
    }else{
        return RES_ERROR;
    }
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            userid_t uid = 0;
            SQLLEN len = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &uid, 0, &len );

            for( int i = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS && i < *uidsLen ; i++ ){
                dst[ i ] = uid;
            }
            
            syslog_printf( "dumpUids succeed" );
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in dumpUids " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += "sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            syslog_printf( "dumpUids %s", getLastErrorString( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in dumpUids" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        syslog_printf( "dumpUids %s", getLastErrorString( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * 롼׿֤(default롼פ).
 * ʥåIDʤ0֤.
 * 
 * @param sid åID
 * @return 롼׿
 * 
 */
int getGroupCount( sessionid_t sid )
{
    if( hdbc == NULL ) return 0;
    if( !isValidSessionID( sid ) ) return 0;
    
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    string sql;
    int ret = 0;
    
    //롼׿
    sql = "SELECT COUNT(*) FROM " + dbprefix + "_xoonips_groups";
    sql += " WHERE gid != " + unsignedIntToString( group::GID_DEFAULT );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLUINTEGER count = 0;
            SQLLEN len = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &count, 0, &len );
            if( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                ret = count;
            }else {
                string s( "SQLFetch in getGroupCount sql=" );
                s += string( sql );
                setLastErrorString( s.c_str( ) );
                ret = 0;
            }
        }else{
            setLastErrorString( "SQLExecDirect in getGroupCount" );
            ret = 0;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getGroupCount" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = 0;
    }
    return ret;
}

/**
 * 
 * °롼װ.
 * 桼°Ƥ륰롼פID(default롼פ).
 * 
 * @param sid åID
 * @param uid 桼UID
 * @param cri ̤ϰϻꡤȾ
 * @param gids 롼IDν
 * @param gidsLen gidsǿν
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_SUCH_USER
 * @return RES_DB_QUERY_ERROR
 * @return RES_OK
 * @see freeGID
 */
result_t getGroupsByUid( sessionid_t sid, userid_t uid, criteria_t* cri, groupid_t** gids, int* gidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !uidExists( uid ) ) return RES_NO_SUCH_USER; //uid¸ߤå
    
    result_t ret = RES_ERROR;
    string sql;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    SQLLEN count = 0;
    groupid_t* dst = 0;
    
    sql = "SELECT gid FROM " + dbprefix + "_xoonips_groups_users_link";
    sql += " WHERE uid=" + string( unsignedIntToString( uid ) );
    sql += " AND gid != " + unsignedIntToString( group::GID_DEFAULT );
    sql += criteria2str( cri );
    if( countResultRows( sql.c_str(), &count ) == RES_OK ){
        *gidsLen = count;
        dst = new groupid_t[ *gidsLen ];
        *gids = dst;
    }else{
        return RES_ERROR;
    }
    
    //°륰롼פκĿ
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            if( count > 0 ){
                SQLHANDLE hstmt2 = NULL;    
                if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt2 ) ) == SQL_SUCCESS ) {
                    sql = "SELECT gid, uid, is_admin FROM " + dbprefix + "_xoonips_groups_users_link";
                    sql += " WHERE uid=" + string( unsignedIntToString( uid ) );
                    sql += " AND gid != " + unsignedIntToString( group::GID_DEFAULT );
                    sql += criteria2str( cri );
                    if( ( sqlcode = SQLExecDirect( hstmt2, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
                        SQLLEN len = 0;
                        groupid_t gid = 0;
                        SQLBindCol( hstmt, 1, SQL_C_ULONG, &gid, 0, &len );
                        for( int i = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS && i < *gidsLen ; i++ ){
                            dst[ i ] = gid;
                        }
                        ret = RES_OK;
                    }else{
                        string s( "SQLExecDirect in getGroupsByUid " );
                        s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                        s += string( ", sql=" ) + string( sql );
                        setLastErrorString( s.c_str( ) );
                        ret = RES_DB_QUERY_ERROR;
                    }
                }else{
                    string s( "SQLAllocHandle in getGroupsByUid " );
                    s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
                    setLastErrorString( s.c_str( ) );
                    ret = RES_ERROR;
                }
            }else{
                ret = RES_OK;
            }
        }else{
            string s( "SQLExecDirect in getGroupsByUid " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += string( ", sql=" ) + string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
    }else{
        string s( "SQLAllocHandle in getGroupsByUid " );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * 롼״礻.
 * 桼˥롼פδ¤뤫(롼״ԤǤ뤫)䤤碌.
 * 桼䥰롼פ¸ߤʤʤɤΰ۾ξ硤false֤.
 * 
 * @param sid åID
 * @param gid 롼פUID
 * @param uid 桼UID
 * @return true ¤
 * @return false ¤ʤޤ
 * @see 
 */
bool isGroupAdmin( sessionid_t sid, groupid_t gid, userid_t uid )
{
    if( hdbc == NULL ) return false;
    if( !isValidSessionID( sid ) ) return false;
    if( !uidExists( uid ) ) return false;
    if( !gidExists( gid ) ) return false;
    
    bool ret = false;
    string sql;
    SQLLEN count = 0;
    
    sql = "SELECT * FROM " + dbprefix + "_xoonips_groups_users_link ";
    sql += "WHERE gid=" + string( unsignedIntToString( gid ) );
    sql += " AND uid=" + string( unsignedIntToString( uid ) );
    sql += " AND is_admin=1";
    if( countResultRows( sql.c_str(), &count ) == RES_OK ){
        if( count > 0 ){
            ret = true;
        }else{
            ret = false;
        }
    }else{
        ret = false;
    }
    return ret;
}

/**
 * 
 * 롼ID.
 * ϿƤ륰롼פID.
 * 
 * @param sid åID
 * @param cri ̤ϰϻꡤȾ
 * @param gids 롼IDν
 * @param gidsLen gidsǿν
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_OK
 * 
 */
result_t dumpGids( sessionid_t sid, criteria_t* cri, groupid_t** gids, int* gidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    result_t ret = RES_ERROR;
    groupid_t* dst = 0;
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    SQLLEN count = 0;
            
    sql = "SELECT gid FROM " + dbprefix + "_xoonips_groups ";
    sql += " WHERE gid != " + unsignedIntToString( group::GID_DEFAULT );
    sql += criteria2str( cri );
    if( countResultRows( sql.c_str(), &count ) == RES_OK ){
        *gidsLen = count;
        dst = new groupid_t[ *gidsLen ];
        *gids = dst;
    }else{
        return RES_ERROR;
    }
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            groupid_t gid = 0;
            SQLLEN len = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &gid, 0, &len );
            for( int i = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS && i < *gidsLen ; i++ ){
                dst[ i ] = gid;
            }
            
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in dumpGids " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += "sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }
    return ret;
}

/**
 * 
 * 롼״ID.
 * 륰롼פδԤΥ桼ID.
 * 
 * @param sid åID
 * @param gid 䤤碌륰롼פIDǻꤹ
 * @param cri ̤ϰϻꡤȾ
 * @param uids ԤUIDݥ
 * @param uidsLen uidsǿ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR 
 * 
 */
result_t dumpGroupAdmins( sessionid_t sid, groupid_t gid, criteria_t* cri, userid_t** uids, int* uidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    result_t ret = RES_ERROR;
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    SQLLEN count = 0;
            
    sql = "SELECT uid FROM " + dbprefix + "_xoonips_groups_users_link ";
    sql += " WHERE is_admin=1 and gid=" + unsignedIntToString( gid );
    if( countResultRows( sql.c_str(), &count ) == RES_OK ){
        *uidsLen = count;
        *uids = new groupid_t[ *uidsLen ];
    }else{
        return RES_ERROR;
    }
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            userid_t uid;
            SQLLEN len = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &uid, 0, &len );
            for( int i = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS && i < *uidsLen ; i++ ){
                (*uids)[ i ] = uid;
            }
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in dumpGroupAdmins " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += "sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }
    return ret;
}

/**
 * 
 * 롼׽°桼.
 * 롼פ˽°桼򡤥롼פ.
 * ǥեȥ롼פϺǤʤ
 * 
 * @param sid åID
 * @param gid ɤΥ롼פ뤫ꤹ륰롼ID
 * @param uid оݤΥ桼ID
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_SUCH_USER
 * @return RES_NO_SUCH_GROUP
 * @return RES_DB_QUERY_ERROR
 * @return RES_OK
 * @return RES_ERROR
 * 
 */
result_t deleteMember( sessionid_t sid, groupid_t gid, userid_t uid )
{
    if( gid == group_t::GID_DEFAULT ) return RES_ERROR;
    return deleteMemberNoLimit( sid, gid, uid );
}

/**
 * 
 * 롼׽°桼.
 * 롼פ˽°桼򡤥롼פ.
 * ǥեȥ롼פǤdeleteMemberȰۤʤ
 * 
 * @param sid åID
 * @param gid ɤΥ롼פ뤫ꤹ륰롼ID
 * @param uid оݤΥ桼ID
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_SUCH_USER
 * @return RES_NO_SUCH_GROUP
 * @return RES_DB_QUERY_ERROR
 * @return RES_OK
 * @return RES_ERROR
 * 
 */
static result_t deleteMemberNoLimit( sessionid_t sid, groupid_t gid, userid_t uid )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !uidExists( uid ) ) return RES_NO_SUCH_USER; //uid¸ߤå
    if( !gidExists( gid ) ) return RES_NO_SUCH_GROUP; //gid¸ߤå
    
    result_t ret = RES_ERROR;
    string sql;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    
    sql = "DELETE FROM " + dbprefix + "_xoonips_groups_users_link ";
    sql += "WHERE gid=" + string( unsignedIntToString( gid ) );
    sql += " AND uid=" + string( unsignedIntToString( uid ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLLEN count = 0;
            if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                ret = RES_OK;
            }else{
                string s( "SQLRowCount in deleteMember" );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += string( ", sql=" ) + string( sql );
                setLastErrorString( s.c_str( ) );
                ret = RES_NO_SUCH_USER;
            }
        }else{
            string s( "SQLExecDirect in deleteMember" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in deleteMember" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * 롼׽°桼ɲ.
 * 롼פΥС˥桼ɲä.
 * 
 * @param sid åID
 * @param gid °襰롼פID
 * @param uid °桼ID
 * @param admin Ը¤Ϳʤtrue
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_SUCH_USER
 * @return RES_NO_SUCH_GROUP
 * @return RES_DB_QUERY_ERROR
 * 
 */
result_t insertMember( sessionid_t sid, groupid_t gid, userid_t uid, bool admin )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !uidExists( uid ) ) return RES_NO_SUCH_USER; //uid¸ߤå
    if( !gidExists( gid ) ) return RES_NO_SUCH_GROUP; //gid¸ߤå
    
    result_t ret = RES_ERROR;
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    
    //Сɲ
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        sql = "INSERT INTO " + dbprefix + "_xoonips_groups_users_link ( gid, uid, is_admin ) VALUES (";
        sql += string( unsignedIntToString( gid ) ) + ", ";
        sql += string( unsignedIntToString( uid ) ) + ", ";
        sql += string( admin ? "1" : "0" ) + ") ";
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLLEN count = 0;
            if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                ret = RES_OK;
            }else{
                string s( "SQLRowCount in insertMember " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += string( ", sql=" ) + string( sql );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else{
            string s( "SQLExecDirect in insertMember " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += string( ", sql=" ) + string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in insertMember" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * 롼׽°桼.
 * 륰롼פν°Ƥ桼Υ桼ID
 * 
 * @param sid åID
 * @param gid ɤΥ롼פν°桼䤤碌뤫򥰥롼פIDǻ
 * @param cri ̤ϰϻꡤȾ
 * @param uids °桼UIDݥ
 * @param uidsLen uidsǿ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_SUCH_GROUP
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR 
 * 
 */
result_t getMembers( sessionid_t sid, groupid_t gid, criteria_t* cri, userid_t** uids, int* uidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !gidExists( gid ) ) return RES_NO_SUCH_GROUP; //gid¸ߤå
    
    result_t ret = RES_ERROR;
    string sql;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    userid_t* dst = 0;
    
    //how many members ?
    sql = "SELECT COUNT(*) FROM " + dbprefix + "_xoonips_groups_users_link ";
    sql += " WHERE gid=" + string( unsignedIntToString( gid ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLUINTEGER count = 0;
            SQLLEN len = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &count, 0, &len );
            if( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                dst = new userid_t[ count ];
                *uids = dst;
                *uidsLen = count;
                if( count > 0 ){
                    //retrieve member's IDs
                    SQLHANDLE hstmt2 = NULL;    
                   if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt2 ) ) == SQL_SUCCESS ) {
                        sql = "SELECT uid, gid, is_admin FROM " + dbprefix + "_xoonips_groups_users_link ";
                        sql += " WHERE gid=" + string( unsignedIntToString( gid ) );
                        sql += " " + string( criteria2str( cri ) );
                        if( ( sqlcode = SQLExecDirect( hstmt2, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
                            SQLUINTEGER uid = 0;
                            SQLLEN len = 0;
                            SQLBindCol( hstmt2, 1, SQL_C_ULONG, &uid, 0, &len );
                            for( SQLUINTEGER i = 0; ( sqlcode = SQLFetch( hstmt2 ) ) == SQL_SUCCESS && i < count ; i++ ){
                                dst[ i ] = uid;
                            }
                            ret = RES_OK;
                        }else{
                            setLastErrorString( "SQLExecDirect in getMembers" );
                            ret = RES_DB_QUERY_ERROR;
                        }
                        SQLFreeHandle( SQL_HANDLE_STMT, hstmt2 );
                    }else{
                        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getMembers" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
                        ret = RES_ERROR;
                    }
                }else{
                    ret = RES_OK;
                }
            }else{
                string s( "SQLFetch in getMembers sql=" );
                s += string( sql );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else{
            setLastErrorString( "SQLExecDirect in getMembers" );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getMembers" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * 롼פκ.
 * ǡ١饰롼פޤ.
 * 
 * @param sid åID
 * @param gid ɤΥ롼פν°桼䤤碌뤫򥰥롼פIDǻ
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_NOT_INITIALIZED
 * 
 */
result_t deleteGroup( sessionid_t sid, groupid_t gid )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    result_t ret = RES_ERROR;
    string sql;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    
    sql = "DELETE FROM " + dbprefix + "_xoonips_groups ";
    sql += "WHERE gid = " + string( unsignedIntToString( gid ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLLEN count = 0;
            if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                ret = RES_OK;
            }else{
                string s( "SQLRowCount in deleteGroup" );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += string( ", sql=" ) + string( sql );
                setLastErrorString( s.c_str( ) );
                ret = RES_NO_SUCH_USER;
            }
        }else{
            string s( "SQLExecDirect in deleteGroup" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in deleteGroup" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}


/**
 * 
 * 롼Ͽ. 
 * 롼פξǡ١˵Ͽ롥
 * Ͽ롼פб륰롼IDgid˳Ǽ롥
 * 
 * @param sid åID
 * @param group Ͽ롼פξ
 * @param gid Ͽ롼פб륰롼ID
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_GROUPNAME_ALREADY_EXISTS
 */
result_t insertGroup( sessionid_t sid, const group_t* group, groupid_t* gid )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    result_t ret = RES_ERROR;
    string sql;
    SQLCHAR gname[XNP_GROUP_GNAME_LEN+1], gdesc[XNP_GROUP_GDESC_LEN+1];
    SQLINTEGER item_number_limit;
    SQLINTEGER index_number_limit;
    SQLDOUBLE item_storage_limit;
    SQLLEN cbGname = SQL_NTS, cbGdesc = SQL_NTS, cbItem_number_limit = 0, cbIndex_number_limit = 0, cbItem_storage_limit = 0;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    
    // examine whether there is already a group name
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        string sql = "SELECT gid FROM " + dbprefix + "_xoonips_groups WHERE gname=? AND gid!=" + unsignedIntToString(group -> getGID() ) + " AND gid != " + unsignedIntToString( group::GID_DEFAULT );
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_GROUP_GNAME_LEN, 0, gname, 0, &cbGname );
            strncpy2( (char*)gname, group -> getGname(), XNP_GROUP_GNAME_LEN );
            if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                SQLLEN count = 0;
                if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS ){
                    if( count > 0 ){
                        // already exists
                        ret = RES_GROUPNAME_ALREADY_EXISTS;
                        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
                        return ret;
                    }
                }else{
                    string s( "SQLRowCount in insertGroup sql=" );
                    s += string( sql );
                    setLastErrorString( s.c_str( ) );
                    ret = RES_DB_QUERY_ERROR;
                    return ret;
                }
            }else{
                string s( "SQLExecute in insertGroup " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else{
            string s( "SQLPrepare in insertGroup " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            setLastErrorString( s.c_str( ) );
            ret = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        sql = "INSERT INTO " + dbprefix + "_xoonips_groups ( gname, gdesc, group_item_number_limit, group_index_number_limit, group_item_storage_limit ) VALUES ( ?, ?, ?, ?, ? )";
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_GROUP_GNAME_LEN, 0, gname, 0, &cbGname );
            SQLBindParameter(hstmt, 2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_GROUP_GDESC_LEN, 0, gdesc, 0, &cbGdesc );
            SQLBindParameter(hstmt, 3, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_INTEGER, 0, 0, &item_number_limit, 0, &cbItem_number_limit);
            SQLBindParameter(hstmt, 4, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_INTEGER, 0, 0, &index_number_limit, 0, &cbIndex_number_limit);
            SQLBindParameter(hstmt, 5, SQL_PARAM_INPUT, SQL_C_DOUBLE, SQL_DOUBLE, 0, 0, &item_storage_limit, 0, &cbItem_storage_limit);
            strncpy2( (char*)gname, group -> getGname( ), XNP_GROUP_GNAME_LEN );
            strncpy2( (char*)gdesc, group -> getDesc( ), XNP_GROUP_GDESC_LEN );
            item_number_limit = group -> getItemNumberLimit( );
            index_number_limit = group -> getIndexNumberLimit( );
            item_storage_limit = group -> getItemStorageLimit( );
            if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                SQLLEN count = 0;
                if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                    //롼ID
                    if( dbtype == DBTYPE_MYSQL ){
                        sql = "SELECT LAST_INSERT_ID()";
                    }else if( dbtype == DBTYPE_SQLITE ){
                        sql = "SELECT LAST_INSERT_ROWID()";
                    }
                    ret = queryGetUnsignedInt( "insertGroup", sql, (unsigned int*)gid );
                }else{
                    string s( "SQLRowCount in insertGroup sql=" );
                    s += string( sql );
                    setLastErrorString( s.c_str( ) );
                    ret = RES_DB_QUERY_ERROR;
                }
            }else{
                string s( "SQLExecute in insertGroup " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else{
            string s( "SQLPrepare in insertGroup " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            setLastErrorString( s.c_str( ) );
            ret = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in insertGroup" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    
    // 
    if ( ret == RES_OK ){
        //group index
        
        //group indexѤsort_num
        string sql = "SELECT MAX(sort_number) FROM " + 
          dbprefix + "_xoonips_index WHERE parent_index_id=" + unsignedIntToString(item::IID_ROOT) + 
          " AND (open_level=" + unsignedIntToString(index::OL_GROUP_ONLY) +
            " OR open_level=" + unsignedIntToString(index::OL_PUBLIC) + ")";
        unsigned int sortNumber;
        ret = queryGetUnsignedInt( "insertGroup", sql, &sortNumber );
        sortNumber++;
        if ( ret == RES_OK ){
            // group index
            index_t index;
            userid_t uid;
            ret = sessionID2UID( sid, &uid );
            if ( ret == RES_OK ){
                index.setParentIndexID(item::IID_ROOT);
                index.setOwnerGID(*gid);
                index.setOpenLevel(index::OL_GROUP_ONLY);
                index.setSortNumber(sortNumber);
                index.setTitle(group->getGname());
                indexid_t groupXID;
                ret = insertIndexInternal( sid, &index, &groupXID );
                if ( ret == RES_OK ){
                    // xnpaccuont_groupsgroup_index_idν񤭴
                    sql = "UPDATE " + dbprefix + "_xoonips_groups SET group_index_id=" 
                      + unsignedIntToString(groupXID) + " WHERE gid=" + unsignedIntToString(*gid);
                    ret = querySimple( "insertGroup", sql );
                }
            }
        }
    }
    
    return ret;
}

/**
 * 
 * 롼׾ѹ
 * 
 * @param sid åID
 * @param group 롼׾
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_SUCH_GROUP
 * @return RES_DB_QUERY_ERROR
 * 
 */
result_t updateGroup( sessionid_t sid, const group_t* group )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( group == NULL ) return RES_ERROR;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !gidExists( group -> getGID( ) ) ) return RES_NO_SUCH_GROUP;
    
    result_t ret = RES_ERROR;
    string sql;
    SQLCHAR gname[XNP_GROUP_GNAME_LEN+1], gdesc[XNP_GROUP_GDESC_LEN+1];
    SQLLEN cbGname = SQL_NTS, cbGdesc = SQL_NTS;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    
    // examine whether there is already a group name
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        string sql = "SELECT gid FROM " + dbprefix + "_xoonips_groups WHERE gname=? AND gid!=" + unsignedIntToString(group -> getGID() ) + " AND gid != " + unsignedIntToString( group::GID_DEFAULT );
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_GROUP_GNAME_LEN, 0, gname, 0, &cbGname );
            strncpy2( (char*)gname, group -> getGname(), XNP_GROUP_GNAME_LEN );
            if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                SQLLEN count = 0;
                if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS ){
                    if( count > 0 ){
                        // already exists
                        ret = RES_GROUPNAME_ALREADY_EXISTS;
                        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
                        return ret;
                    }
                }else{
                    string s( "SQLRowCount in updateGroup sql=" );
                    s += string( sql );
                    setLastErrorString( s.c_str( ) );
                    ret = RES_DB_QUERY_ERROR;
                    return ret;
                }
            }else{
                string s( "SQLExecute in updateGroup " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else{
            string s( "SQLPrepare in updateGroup " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            setLastErrorString( s.c_str( ) );
            ret = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        sql = "UPDATE " + dbprefix + "_xoonips_groups SET gname=?, gdesc=?, ";
        sql += "group_item_number_limit=" + unsignedIntToString( group -> getItemNumberLimit( ) ) + " ,";
        sql += "group_index_number_limit=" + unsignedIntToString( group -> getIndexNumberLimit( ) ) + " ,";
        sql += "group_item_storage_limit=" + doubleToString( group -> getItemStorageLimit( ) ) + " ";
        sql += "WHERE gid=" + string( unsignedIntToString( group -> getGID( ) ) );
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_GROUP_GNAME_LEN, 0, gname, 0, &cbGname );
            SQLBindParameter(hstmt, 2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_GROUP_GDESC_LEN, 0, gdesc, 0, &cbGdesc );
            strncpy2( (char*)gname, group -> getGname( ), XNP_GROUP_GNAME_LEN );
            strncpy2( (char*)gdesc, group -> getDesc( ), XNP_GROUP_GDESC_LEN );
            if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                SQLLEN count = 0;
                if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                    ret = RES_OK;
                }else{
                    string s( "SQLRowCount in updateGroup sql=" );
                    s += string( sql );
                    setLastErrorString( s.c_str( ) );
                    ret = RES_DB_QUERY_ERROR;
                }
            }else{
                string s( "SQLExecute in updateGroup " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else{
            setLastErrorString( "SQLPrepare in updateGroup sql=" );
            ret = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in updateGroup" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    
    if( ret == RES_OK ){
        // update٤index_id
        sql = "SELECT group_index_id from " + dbprefix + "_xoonips_groups as tg "
          " left join " + dbprefix + "_xoonips_item_basic as ti on tg.group_index_id = ti.item_id "
          " left join " + dbprefix + "_xoonips_index as tx on ti.item_id = tx.index_id "
          " where tg.gid=" +  unsignedIntToString(group->getGID()) + 
          "  and ti.item_type_id=" + unsignedIntToString(item::ITID_INDEX) +
          "  and tx.parent_index_id=" + unsignedIntToString(item::IID_ROOT);
        indexid_t xid;
        ret = queryGetUnsignedInt( "updateGroup",  sql, &xid );
        
        if ( ret == RES_OK ){
            if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
                sql = "UPDATE " + dbprefix + "_xoonips_item_basic set title=? "
                    "WHERE item_id=" + unsignedIntToString(xid);
                sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
                if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
                    cbGname = SQL_NTS;
                    SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_GROUP_GNAME_LEN, 0, gname, 0, &cbGname );
                    strncpy2( (char*)gname, group -> getGname( ), XNP_GROUP_GNAME_LEN );
                    if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                        SQLLEN count = 0;
                        if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                            ret = RES_OK;
                        }else{
                            string s( "SQLRowCount in updateGroup sql=" );
                            s += string( sql );
                            setLastErrorString( s.c_str( ) );
                            ret = RES_DB_QUERY_ERROR;
                        }
                    }else{
                        string s( "SQLExecute in updateGroup " );
                        s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                        setLastErrorString( s.c_str( ) );
                        ret = RES_DB_QUERY_ERROR;
                    }
                }else{
                    setLastErrorString( "SQLPrepare in updateGroup sql=" );
                    ret = RES_ERROR;
                }
                SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
            }else{
                string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in updateGroup" );
                s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_ERROR;
            }
        }
    }
    return RES_OK;
}

/**
 * 
 * 롼׾
 * 
 * @param sid åID
 * @param gid 롼פGID
 * @param group 롼׾Υɥ쥹񤭹ݥ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_SUCH_GROUP
 * @return RES_DB_QUERY_ERROR
 * 
 */
result_t getGroup( sessionid_t sid, groupid_t gid, const group_t** group )
{
    int len = 0;
    static criteria c;
    result_t res = getGroups( sid, &gid, 1, &c, group, &len );
    if( res == RES_OK && len == 0 ) return RES_NO_SUCH_GROUP;
    return res;
}

/**
 * 
 * ʣΥ롼׾٤˼.
 * 
 * @param sid åID
 * @param gids 롼פGID
 * @param gidsLen gidsǿ
 * @param cri ̤μϰϡȾ
 * @param groups ̤Υ롼׾Υɥ쥹񤭹ݥ
 * @param groupsLen ̤ǿ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * 
 */
result_t getGroups( sessionid_t sid, groupid_t* gids, int gidsLen, criteria_t* cri, const group_t** groups, int* groupsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;

    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    result_t ret = RES_ERROR;
    string sql;
    group_t* dst = new group_t[ gidsLen ];
    
    sql += "SELECT gid, gname, gdesc, group_index_id, group_item_number_limit, group_index_number_limit, group_item_storage_limit ";
    sql += " FROM " + dbprefix + "_xoonips_groups ";
    if( gidsLen > 0 ){
        sql += " WHERE gid in ( ";
        int i = 0;
        for( ; i < gidsLen; i++ ){
            if( gids[ i ] == group::GID_DEFAULT ) continue;
            sql += string( unsignedIntToString( gids[ i ] ) );
            break;
        }
        for( ; i < gidsLen; i++ ){
            if( gids[ i ] == group::GID_DEFAULT ) continue;
            sql += ", " + string( unsignedIntToString( gids[ i ] ) );
        }
        sql += " )";
    }
    sql += criteria2str( cri );
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLLEN len = 0;
            groupid_t gid = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &gid, 0, &len );
            *groupsLen=0;
            for( int i = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS && i < gidsLen ; i++ ){
                dst[ i ].setGID( gid );
                dst[ i ].setGname( getResultCol( hstmt, 2 ).c_str() );
                dst[ i ].setDesc( getResultCol( hstmt, 3 ).c_str() );
                dst[ i ].setGroupIndexID( atoi(getResultCol( hstmt, 4 ).c_str()) );
                dst[ i ].setItemNumberLimit( atoi(getResultCol( hstmt, 5 ).c_str()) );
                dst[ i ].setIndexNumberLimit( atoi(getResultCol( hstmt, 6 ).c_str()) );
                dst[ i ].setItemStorageLimit( strtod(getResultCol( hstmt, 7 ).c_str(), NULL) );
                ( *groupsLen )++;
            }
            *groups = dst;
            syslog_printf( "getGroups succeed" );
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in getGroups" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += string( ", sql=" ) + string( sql );
            setLastErrorString( s.c_str( ) );
            syslog_printf( "getGroups %s", getLastErrorString( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getGroups" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        syslog_printf( "getGroups %s", getLastErrorString( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * ǥ졼¤̵֤ͭ
 * 
 * @param sid åID
 * @param uid 䤤碌桼UID
 * @return true ¤
 * @return false ¤ʤ
 * 
 */
bool isModerator( sessionid_t sid, userid_t uid )
{
    if( hdbc == NULL ) return false;
    if( !isValidSessionID( sid ) ) return false;
    if( !uidExists( uid ) ) return false;
    
    bool ret = false;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    SQLLEN count = 0;
    string sql;
    groupid_t moderator_gid;
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        sql = "SELECT value FROM " + dbprefix + "_xoonips_config";
        sql += " WHERE name='moderator_gid'";
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLLEN len = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &moderator_gid, 0, &len );
            if( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                sql = "SELECT * from " + dbprefix + "_groups_users_link ";
                sql += "WHERE groupid=" + unsignedIntToString( moderator_gid );
                sql += " AND uid=" + string( unsignedIntToString( uid ) );
                if( countResultRows( sql.c_str(), &count ) == RES_OK ){
                    if( count > 0 ){
                        ret = true;
                    }
                }
            }else{
/*
                string s( "SQLFetch in isModerator " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += ", sql=";
                s += string( sql );
                setLastErrorString( s.c_str( ) );
*/
            }
        }else{
            string s( "SQLExecDirect in isModerator " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle in isModerator " );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
    }
    return ret;
}

/**
 * 
 * 桼ID
 * 
 * @param uname ID桼̾
 * @param uid IDѿΥݥ
 * @return RES_ERROR
 * @return RES_OK 
 * @see result_t
 * 
 */
result_t getUid( const char* uname, userid_t* uid )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( uname == NULL ) return RES_ERROR;
    
    result_t ret = RES_ERROR;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    string sql;
    string uname2 = addSlashes( uname );
    
    sql = "SELECT uid FROM " + dbprefix + "_users WHERE uname='" + uname2 + "';";
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            userid_t _uid = 0;
            SQLLEN len = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &_uid, 0, &len );
            sqlcode = SQLFetch( hstmt );
            if( sqlcode == SQL_SUCCESS ){
                *uid = _uid;
                ret = RES_OK;
            }else {
                string s( "SQLFetch in getUid sql=" );
                s += string( sql );
                setLastErrorString( s.c_str( ) );
                ret = RES_NO_SUCH_USER;
            }
        }else{
            setLastErrorString( "SQLExecDirect in getUid" );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getUid" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    
    return ret;
}

/**
 * 
 * åxoops_xoonips_session˽񤭹ࡣ sessionid_tsession֤
 * 
 * @param uid xoops_usersuid
 * @param session sessionid_t뤿Υݥ󥿡
 * @return RES_OK 
 * @return RES_DB_QUERY_ERROR DB䤤碌Υ顼
 */
static result_t addSession( userid_t uid, sessionid_t* session )
{
    char *functionName = "addSession";
    string sql;
    if( dbtype == DBTYPE_MYSQL ){
        sql = "INSERT INTO " + dbprefix + "_xoonips_session (uid) values (" + 
            unsignedIntToString(uid) + ")";
    }else if( dbtype == DBTYPE_SQLITE ){
        sql = "INSERT INTO " + dbprefix + "_xoonips_session (uid, timestamp) values (" + 
            unsignedIntToString(uid) + "," + unsignedIntToString( time( NULL ) ) + ")";
    }
    result_t ret = querySimple( functionName, sql );
    if ( ret == RES_OK ){
        if( dbtype == DBTYPE_MYSQL ){
            sql = "SELECT LAST_INSERT_ID()";
        }else if( dbtype == DBTYPE_SQLITE ){
            sql = "SELECT LAST_INSERT_ROWID()";
        }
        ret = queryGetUnsignedInt( functionName, sql, (unsigned int*)session );
    }
    return ret;
}

/** ƤΥॢȤå
 */
static void deleteTimeoutSession(){
    time_t now = time(NULL);
    string sql;
    if( dbtype == DBTYPE_MYSQL ){
        sql = "DELETE FROM " + dbprefix + "_xoonips_session WHERE unix_timestamp(timestamp) < " + unsignedIntToString(now-SESSION_TIMEOUT_SEC);
    }else if( dbtype == DBTYPE_SQLITE ){
        sql = "DELETE FROM " + dbprefix + "_xoonips_session WHERE timestamp < " + unsignedIntToString(now-SESSION_TIMEOUT_SEC);
    }
    querySimple( "deleteTimeoutSession", sql );
}

/**
 * 
 * ǧڤȥå
 * 
 * @param uname ̾
 * @param passwd ѥ
 * @param session sessionid_t뤿Υݥ󥿡
 * @return RES_OK sessionsessionid_t񤭹<br>
 * @return RES_LOGIN_FAILURE unameޤpasswd۾<br>
 * @return RES_DB_QUERY_ERROR DB䤤碌Υ顼
 * 
 */
result_t loginUser(const char* uname, const char* passwd, sessionid_t* session )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    
    result_t ret;
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    
    // uname, passwd -> uid
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        sql = "SELECT uid FROM " + dbprefix + "_users WHERE uname = ? and pass = ? ";
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        SQLLEN cbUname = SQL_NTS, cbPasswd = SQL_NTS;
        SQLBindParameter(hstmt,  1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, strlen(uname), 0, (SQLCHAR *)uname, 0, &cbUname );
        SQLBindParameter(hstmt,  2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, strlen(passwd),0, (SQLCHAR *)passwd,0, &cbPasswd );
        sqlcode = SQLExecute( hstmt );
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            SQLUINTEGER sUID = 0;
            SQLLEN len = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &sUID, 0, &len );
            if ( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                // activateĴ٤
                sql = "SELECT activate FROM " + dbprefix + "_xoonips_users WHERE uid=" + unsignedIntToString(sUID);
                unsigned int activate = 0;
                ret = queryGetUnsignedInt( "loginUser", sql, &activate );
                if ( ret == RES_OK ){
                    if ( activate != 0 )
                        ret = addSession( (userid_t)sUID, session );
                    else {
                        ret = RES_LOGIN_FAILURE;// not activated
                        setLastErrorString( "loginUser: not activated" );
                    }
                }
                else {
                    ;
                }
            }else if ( sqlcode == SQL_NO_DATA ){
                string s( "SQLFetch in loginUser" );
                setLastErrorString( s.c_str( ) );
                ret = RES_LOGIN_FAILURE;//illegal loginname or password
            }else{
                string s( "SQLFetch in loginUser " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += "sql=";
                s += sql;
                setLastErrorString( s.c_str( ) );
                ret = RES_ERROR;
            }
        }else{
            string s( "SQLExecDirect in loginUser " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += "sql=";
            s += sql;
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in loginUser " );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    
    deleteTimeoutSession();
    return ret;
}

/**
 * 
 * Ȥȥåλ
 * 
 * @param sid session id
 * @return ʤ
 * 
 */
void logoutUser( sessionid_t sid )
{
    if( hdbc == NULL ) return; // RES_DB_NOT_INITIALIZED;
    
    string sql;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    
    sql = "DELETE FROM " + dbprefix + "_xoonips_session WHERE sid=" + intToString((int)sid);
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            ;
        }
        else {
            setLastErrorString( "SQLExecDirect in logoutUser" );
        }
    }
    else {
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in logoutUser" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
    }
}

/**
 * 
 * åκ.
 * XOOPSsessionơ֥˵Ͽ줿sess_idȰsess_id
 * uidPlatform桼ȤactivateƤsessionid_t롣
 * ǡ١˥åȰξϿ
 * 
 * @param sessionid xoopssession_id
 * @param uid  xoops_usersuid
 * @param session sessionid_t뤿Υݥ󥿡
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_USER
 *
 */
result_t createSession( const char* sess_id, userid_t uid, sessionid_t* session )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    
    result_t ret;
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    
    sql = "SELECT count(*) from " + dbprefix + "_xoonips_users where uid=" + unsignedIntToString( uid ) + " and activate=1";
    unsigned int count;
    ret = queryGetUnsignedInt( "createSession", sql, &count );
    if ( ret != RES_OK )
        return ret;
    if ( count == 0 )
        return RES_NO_SUCH_USER; // bad uid or activate=0
    
    string escSess_id = addSlashes(sess_id);
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        sql = "SELECT sess_id from " + dbprefix + "_session where sess_id=?";
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            SQLLEN cbSess_id = SQL_NTS;
            SQLBindParameter(hstmt,  1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, strlen(sess_id), 0, (SQLCHAR*)sess_id, 0, &cbSess_id );
            if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                if( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                    ret = addSession( uid, session );
                }else{
                    ret = RES_ERROR;
                }
            }else {
                ret = RES_DB_QUERY_ERROR;
            }
        }
    }else{
        ret = RES_ERROR;
    }
    deleteTimeoutSession();
    return ret;
}

/**
 * 
 * åξܺ٤session_tǼ.
 * 
 * @param sid åID
 * @param ppsession sessionid_t*뤿Υݥ󥿡
 * @return RES_OK freeSession(*ppsession)ɬס<br>
 * @return RES_NO_SUCH_SESSION<br>
 * @return RES_DB_QUERY_ERROR<br>
 * @return RES_DB_NOT_INITIALIZED
 *
 */
result_t getSession( sessionid_t sid, const session_t** ppsession )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    result_t ret = RES_ERROR;
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    
    if( dbtype == DBTYPE_MYSQL ){
        sql = "SELECT sid, uid, unix_timestamp(timestamp) from " + dbprefix + 
            "_xoonips_session where sid=" + unsignedIntToString((unsigned int)sid);
    }else if( dbtype == DBTYPE_SQLITE ){
        sql = "SELECT sid, uid, timestamp from " + dbprefix + 
            "_xoonips_session where sid=" + unsignedIntToString((unsigned int)sid);
    }
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            userid_t uid = 0;
            SQLLEN cbUid = 0;
            unsigned long date = 0;
            SQLLEN cbDate = 0;
            SQLBindCol( hstmt, 2, SQL_C_ULONG, &uid, 0, &cbUid );
            SQLBindCol( hstmt, 3, SQL_C_ULONG, &date, 0, &cbDate );
            if( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                session_t *p = new session[ 1 ];
                p->setSessionID( sid );
                p->setUID( uid );
                p->setDate( date );  
                *ppsession = p;
                ret = RES_OK;
            }else{
                string s( "SQLFetch in getSession " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_ERROR;
            }
        }else {
            string s( "SQLExecDirect in getSession " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getSession" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
    
/*
    sql = "SELECT sid, uid, unix_timestamp(timestamp) from " + dbprefix + 
      "_xoonips_session where sid=" + unsignedIntToString((unsigned int)sid);
    if( 0 == SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ){
        MYSQL_RES* result = fp_mysql_store_result( mysql );
        if( result ){
            MYSQL_ROW row = fp_mysql_fetch_row(result);
            if( row ){
                session_t *p = new session[1];
                p->setSessionID(sid);
                p->setUserID(atoi( row[1] != NULL ? row[1] : "" ));
                p->setDate(atoi( row[2] != NULL ? row[2] : "" ));
                *ppsession = p;
                ret = RES_OK;
            }else{
                ret = RES_NO_SUCH_SESSION;
            }
            fp_mysql_free_result( result );
        }else {
            ret = RES_DB_QUERY_ERROR;
        }
    }else{
        ret = RES_DB_QUERY_ERROR;
    }
    return ret;
*/
}




/**
 * 
 * ƥ(Basic Information)Ͽ.
 * Platform桼ʾθ¤ɬ.
 * 
 * @param sid åID
 * @param item Ͽƥξ
 * @param itemid ϿƥID
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * 
 */
result_t insertItemDirect( sessionid_t sid, const item_t* item, itemid_t* itemid )
{
    return _insertItem( sid, item, itemid, true );
}

result_t insertItem( sessionid_t sid, const item_t* item, itemid_t* itemid )
{
    return _insertItem( sid, item, itemid, false );
}

/**
 * 
 * ƥ(Basic Information)Ͽ.
 * Platform桼ʾθ¤ɬ.
 * 
 * @param sid åID
 * @param item Ͽƥξ
 * @param itemid ϿƥID
 * @param direct last_update_date, creation_dateitemƤ˽ʤtrue
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * 
 */
static result_t _insertItem( sessionid_t sid, const item_t* item, itemid_t* itemid, bool direct )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !isActivatedBySession( sid ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    result_t ret = RES_ERROR;
    SQLINTEGER uid, item_type_id, creation_date, last_update_date, publication_year, publication_month, publication_mday;
    SQLLEN cbUid = 0, cbItem_type_id = 0, cbCreation_date = 0, cbLast_update_date = 0, cbPublication_year = 0, cbPublication_month = 0, cbPublication_mday = 0;
    SQLCHAR title[ XNP_ITEM_TITLE_LEN + 1 ],
        keywords[ XNP_ITEM_KEYWORDS_LEN + 1 ],
        description[ XNP_ITEM_DESCRIPTION_LEN + 1 ],
        doi[ XNP_ITEM_DOI_LEN + 1 ],
        lang[ XNP_ITEM_LANG_LEN + 1 ];
    SQLLEN cbTitle = SQL_NTS,
        cbKeywords = SQL_NTS,
        cbDescription = SQL_NTS,
        cbDOI = SQL_NTS,
        cbLang = SQL_NTS;
    indexid_t private_xid;
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        string sql;
        sql = "INSERT INTO " + dbprefix + "_xoonips_item_basic (item_type_id, title, keywords, description, doi, uid, creation_date, last_update_date, publication_year, publication_month, publication_mday, lang) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
        syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &item_type_id, 0, &cbItem_type_id );
            SQLBindParameter(hstmt, 2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ITEM_TITLE_LEN, 0, title, 0, &cbTitle );
            SQLBindParameter(hstmt, 3, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ITEM_KEYWORDS_LEN, 0, keywords, 0, &cbKeywords );
            SQLBindParameter(hstmt, 4, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ITEM_DESCRIPTION_LEN, 0, description, 0, &cbDescription );
            SQLBindParameter(hstmt, 5, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ITEM_DOI_LEN, 0, doi, 0, &cbDOI );
            SQLBindParameter(hstmt, 6, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &uid, 0, &cbUid );
            SQLBindParameter(hstmt, 7, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &creation_date, 0, &cbCreation_date );
            SQLBindParameter(hstmt, 8, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &last_update_date, 0, &cbLast_update_date );
            SQLBindParameter(hstmt, 9, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &publication_year, 0, &cbPublication_year );
            SQLBindParameter(hstmt, 10, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &publication_month, 0, &cbPublication_month );
            SQLBindParameter(hstmt, 11, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &publication_mday, 0, &cbPublication_mday );
            SQLBindParameter(hstmt, 12, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ITEM_LANG_LEN, 0, lang, 0, &cbLang );
            
            strncpy2( (char*)title, item -> getTitle(), XNP_ITEM_TITLE_LEN );
            strncpy2( (char*)keywords, item -> getKeywords(), XNP_ITEM_KEYWORDS_LEN );
            strncpy2( (char*)description, item -> getDescription(), XNP_ITEM_DESCRIPTION_LEN );
            strncpy2( (char*)doi, item -> getDOI(), XNP_ITEM_DOI_LEN );
            strncpy2( (char*)lang, item -> getLang(), XNP_ITEM_LANG_LEN );
            item_type_id = item -> getItemTypeID( );
            uid = item -> getContributorUID( );
            if( direct ){
                creation_date = item -> getCreationDate();
                last_update_date = item -> getLastUpdateDate();
            }else{
                creation_date = time( NULL );
                last_update_date = time( NULL );
            }
            publication_year = item -> getPublicationYear();
            publication_month = item -> getPublicationMonth();
            publication_mday = item -> getPublicationMday();
            
            if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                SQLLEN count = 0;
                if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                    //ƥID
                    if( dbtype == DBTYPE_MYSQL ){
                        sql = "SELECT LAST_INSERT_ID()";
                    }else if( dbtype == DBTYPE_SQLITE ){
                        sql = "SELECT LAST_INSERT_ROWID()";
                    }
                    if( ( ret = queryGetUnsignedInt( "insertItem", sql, (unsigned int*)itemid ) ) == RES_OK ){
                        if( item -> getItemTypeID( ) == item::ITID_INDEX ){
                            ;// ⤷ʤ
                        }else{
                            //insert into private index
                            sql = "SELECT private_index_id FROM " + dbprefix + "_xoonips_users ";
                            sql += " WHERE uid=" + unsignedIntToString( uid );
                            syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
                            if( ( ret = queryGetUnsignedInt( "insertItem", sql, (unsigned int*)&private_xid ) ) == RES_OK ){
                                ret = registerItem( sid, private_xid, *itemid );
                            }
                        }
                        ret = RES_OK;
                    }
                }else{
                    string s( "SQLRowCount in insertItem sql=" );
                    s += string( sql );
                    setLastErrorString( s.c_str( ) );
                    ret = RES_DB_QUERY_ERROR;
                }
            }else{
                string s( "SQLExecute in insertItem " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else{
            string s( "SQLPrepare in insertItem " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            setLastErrorString( s.c_str( ) );
            ret = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in insertItem" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    
    return ret;
}    

/**
 * 
 * ƥ.
 * ƥϡѸfreeItemǲ.
 * 
 * @see freeItem
 * @param sid åID
 * @param iid ƥID
 * @param item ̤Υƥ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_SUCH_ITEM
 * @return RES_DB_QUERY_ERROR
 * 
 */
result_t getItem( sessionid_t sid, itemid_t iid, const item_t** item )
{
    int len = 0;
    static criteria c;
    *item = 0;
    result_t res = getItems( sid, &iid, 1, &c, item, &len );
    if( len == 0 ){
        freeItem( *item );
        item = 0;
        return RES_NO_SUCH_ITEM;
    }
    return res;
}

/**
 * 
 * ƥ.
 * ƥϡѸfreeItemǲ.
 * 
 * @see freeItem
 * @param sid åID
 * @param iids ƥID
 * @param iidsLen iidsǿ
 * @param cri ̤ϰϻꡤȾ
 * @param items ̤Υݥ󥿤񤭹
 * @param itemsLen ̤ο(*itemsǿ)
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * 
 */
result_t getItems( sessionid_t sid, const itemid_t* iids, int iidsLen, criteria_t* cri, const item_t** items, int* itemsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( iidsLen <= 0 ){
        *items = new item_t[ 0 ];
        *itemsLen = 0;
        return RES_OK;
    }
    
    result_t ret = RES_ERROR;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    string sql;
    string where;
    item_t* dst = new item_t[ iidsLen ];
    userid_t uid;
    
    ret = sessionID2UID( sid, &uid );
    if( ret != RES_OK ) return ret;
    
    where = string( unsignedIntToString( iids[ 0 ] ) );
    for( int i = 1; i < iidsLen; i++ ){
        where = string( unsignedIntToString( iids[ i ] ) ) + ", " + where;
    }
    

    if( dbtype == DBTYPE_MYSQL ){
        sql = "SELECT DISTINCT ti.item_id as item_id, item_type_id, title, keywords, description, doi, ti.uid as uid, creation_date, last_update_date, publication_year, publication_month, publication_mday, lang ";
        sql+= " FROM " + dbprefix + "_xoonips_index_item_link AS tlink";
        sql+= " LEFT JOIN " + dbprefix + "_xoonips_index AS tx ON tlink.index_id = tx.index_id";
        sql+= " LEFT JOIN " + dbprefix + "_xoonips_item_basic AS ti ON tlink.item_id = ti.item_id";
    }else if( dbtype == DBTYPE_SQLITE ){
        sql = "SELECT DISTINCT xtest_xoonips_item_basic.item_id as item_id, item_type_id, title, keywords, description, doi, xtest_xoonips_item_basic.uid as uid, creation_date, last_update_date, publication_year, publication_month, publication_mday ";
        sql+= " FROM " + dbprefix + "_xoonips_index_item_link AS tlink";
        sql+= " LEFT JOIN " + dbprefix + "_xoonips_index AS tx ON tlink.index_id = tx.index_id";
        sql+= " LEFT JOIN " + dbprefix + "_xoonips_item_basic ON tlink.item_id = xtest_xoonips_item_basic.item_id";
    }
    sql+= " LEFT JOIN " + dbprefix + "_xoonips_groups_users_link as tgulink ON tx.gid=tgulink.gid";
    sql+= " LEFT JOIN " + dbprefix + "_xoonips_session AS tsess ON tsess.uid=" + unsignedIntToString( uid );
    sql+= " AND tsess.sid=" + unsignedIntToString( sid );
    sql+= " WHERE ( " + string( public_item_target_user_all( ) ? "1" : "0" );
    sql+=       " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC ) + " AND tsess.uid IS NULL";
    sql+=       " AND certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql+=    " OR " + string( !public_item_target_user_all( ) ? "1" : "0" );
    sql+=       " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC ) + " AND tsess.uid IS NOT NULL";
    sql+=       " AND certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql+=    " OR tx.open_level=" + unsignedIntToString( index::OL_GROUP_ONLY );
    sql+=      " AND tgulink.uid=" + unsignedIntToString( uid );
    sql+=      " AND ( certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql+=            string( isModerator( sid, uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
    sql+=            " OR tgulink.is_admin=1 )"; //롼״Ԥ
    if( uid != session_t::SID_GUEST ) sql+= " AND tgulink.uid=" + unsignedIntToString( uid );
    sql+=    " OR tx.open_level=" + unsignedIntToString( index::OL_PRIVATE );
    sql+=      " AND tx.uid=" + unsignedIntToString( uid );
    sql+=    " OR tx.uid IS NULL ";
    sql+=      " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC );
    sql+=      " AND ( certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql+=            string( isModerator( sid, uid ) ? " OR 1 )" : " OR 0 )" ); //ǥ졼ʤOR 1ʳ OR 0
    sql+= string( isModerator( sid, uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
    sql+=    ") AND tlink.item_id IN (" + where + ")";
    sql += criteria2str( cri );
    
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            userid_t uid = 0;
            itemid_t item_id = 0;
            itemtypeid_t item_type_id = 0;
            time_t creation_date = 0;
            time_t last_update_date = 0;
            unsigned int publication_year = 0;
            unsigned int publication_month = 0;
            unsigned int publication_mday = 0;
            SQLLEN cbUid = 0, cbItem_id = 0, cbItem_type_id = 0, cbCreation_date = 0, cbLast_update_date = 0, cbPublication_year = 0, cbPublication_month = 0, cbPublication_mday = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &item_id, 0, &cbItem_id );
            SQLBindCol( hstmt, 2, SQL_C_ULONG, &item_type_id, 0, &cbItem_type_id );
            SQLBindCol( hstmt, 7, SQL_C_ULONG, &uid, 0, &cbUid );
            SQLBindCol( hstmt, 8, SQL_C_SLONG, &creation_date, 0, &cbCreation_date );
            SQLBindCol( hstmt, 9, SQL_C_SLONG, &last_update_date, 0, &cbLast_update_date );
            SQLBindCol( hstmt, 10, SQL_C_SLONG, &publication_year, 0, &cbPublication_year );
            SQLBindCol( hstmt, 11, SQL_C_SLONG, &publication_month, 0, &cbPublication_month );
            SQLBindCol( hstmt, 12, SQL_C_SLONG, &publication_mday, 0, &cbPublication_mday );
            
            *itemsLen = 0;
            for( int i = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS && i < iidsLen ; i++ ){
                dst[ i ].setItemID( item_id );
                dst[ i ].setItemTypeID( item_type_id );
                dst[ i ].setTitle( getResultCol( hstmt, 3 ).c_str() );
                dst[ i ].setKeywords( getResultCol( hstmt, 4 ).c_str() );
                dst[ i ].setDescription( getResultCol( hstmt, 5 ).c_str() );
                dst[ i ].setDOI( getResultCol( hstmt, 6 ).c_str() );
                dst[ i ].setContributorUID( uid );
                dst[ i ].setCreationDate( creation_date );
                dst[ i ].setLastUpdateDate( last_update_date );
                dst[ i ].setPublicationYear( publication_year );
                dst[ i ].setPublicationMonth( publication_month );
                dst[ i ].setPublicationMday( publication_mday );
                dst[ i ].setLang( getResultCol( hstmt, 13 ).c_str() );
                ( *itemsLen )++;
            }
            *items = dst;
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in getItems" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += string( ", sql=" ) + string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getItems" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * Readǽʥƥο򤫤.
 * ԤȤ0򤫤ޤ
 * 
 * @param sid åID
 * @return count ƥ
 * 
 */
unsigned int getItemCount( sessionid_t sid )
{
    if( hdbc == NULL ) return 0;
    if( !isValidSessionID( sid ) ) return 0;
    
    result_t ret = RES_ERROR;
    string sql;
    string where;
    userid_t uid;
    unsigned int count;
    
    ret = sessionID2UID( sid, &uid );
    if( ret != RES_OK ) return 0;
    
    sql = "SELECT count(DISTINCT ti.item_id)";
    sql+= " FROM " + dbprefix + "_xoonips_index_item_link AS tlink";
    sql+= " LEFT JOIN " + dbprefix + "_xoonips_index AS tx ON tlink.index_id = tx.index_id";
    sql+= " LEFT JOIN " + dbprefix + "_xoonips_item_basic AS ti ON tlink.item_id = ti.item_id";
    sql+= " LEFT JOIN " + dbprefix + "_xoonips_groups_users_link as tgulink ON tx.gid=tgulink.gid";
    sql+= " LEFT JOIN " + dbprefix + "_xoonips_session AS tsess ON tsess.uid=" + unsignedIntToString( uid );
    sql+= " AND tsess.sid=" + unsignedIntToString( sid );
    sql+= " WHERE ( " + string( public_item_target_user_all( ) ? "1" : "0" );
    sql+=       " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC ) + " AND tsess.uid IS NULL";
    sql+=       " AND certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql+=    " OR " + string( !public_item_target_user_all( ) ? "1" : "0" );
    sql+=       " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC ) + " AND tsess.uid IS NOT NULL";
    sql+=       " AND certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql+=    " OR tgulink.uid=" + unsignedIntToString( uid );
    sql+=      " AND ( certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql+=            string( isModerator( sid, uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
    sql+=            " OR tgulink.is_admin=1 )"; //롼״Ԥ
    if( uid != session_t::SID_GUEST ) sql+= " AND tgulink.uid=" + unsignedIntToString( uid );
    sql+=    " OR tx.open_level=" + unsignedIntToString( index::OL_PRIVATE );
    sql+=       " AND tx.uid=" + unsignedIntToString( uid );
    sql+=    " OR tx.uid IS NULL ";
    sql+=      " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC );
    sql+=      " AND ( certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql+=            string( isModerator( sid, uid ) ? " OR 1 )" : " OR 0 )" ); //ǥ졼ʤOR 1ʳ OR 0
    sql+= string( isModerator( sid, uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
    sql+=    ") ";
    ret = queryGetUnsignedInt( "getItemCount", sql, (unsigned int*)&count );
    
    if( ret != RES_OK ) return 0;
    
    return count;
}
/**
 * 
 * ƥIDΰ.
 * ǽʥƥID֤.
 * 
 * @see freeItemID
 * @param sid åID
 * @param cri ̤ϰϻꡤȾ
 * @param iids ̤Υݥ󥿤񤭹
 * @param iidssLen ̤ο
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * 
 */
result_t dumpItemID(sessionid_t sid, criteria_t* c, const itemid_t** iids, int* iidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
        
    result_t ret = RES_ERROR;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    string sql;
    itemid_t* dst = 0;
    int dst_max = 1024;
    userid_t uid;
    
    ret = sessionID2UID( sid, &uid );
    if( ret != RES_OK ) return ret;

    sql = "SELECT DISTINCT ti.item_id as item_id";
    sql+= " FROM " + dbprefix + "_xoonips_index_item_link AS tlink";
    sql+= " LEFT JOIN " + dbprefix + "_xoonips_index AS tx ON tlink.index_id = tx.index_id";
    sql+= " LEFT JOIN " + dbprefix + "_xoonips_item_basic AS ti ON tlink.item_id = ti.item_id";
    sql+= " LEFT JOIN " + dbprefix + "_xoonips_groups_users_link as tgulink ON tx.gid=tgulink.gid";
    sql+= " LEFT JOIN " + dbprefix + "_xoonips_session AS tsess ON tsess.uid=" + unsignedIntToString( uid );
    sql+= " AND tsess.sid=" + unsignedIntToString( sid );
    sql+= " WHERE ( " + string( public_item_target_user_all( ) ? "1" : "0" );
    sql+=       " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC ) + " AND tsess.uid IS NULL";
    sql+=       " AND certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql+=    " OR " + string( !public_item_target_user_all( ) ? "1" : "0" );
    sql+=       " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC ) + " AND tsess.uid IS NOT NULL";
    sql+=       " AND certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql+=    " OR tx.open_level=" + unsignedIntToString( index::OL_GROUP_ONLY );
    sql+=      " AND tgulink.uid=" + unsignedIntToString( uid );
    sql+=      " AND ( certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql+=            string( isModerator( sid, uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
    sql+=            " OR tgulink.is_admin=1 )"; //롼״Ԥ
    if( uid != session_t::SID_GUEST ) sql+= " AND tgulink.uid=" + unsignedIntToString( uid );
    sql+=    " OR tx.open_level=" + unsignedIntToString( index::OL_PRIVATE );
    sql+=       " AND tx.uid=" + unsignedIntToString( uid );
    sql+=    " OR tx.uid IS NULL ";
    sql+=      " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC );
    sql+=      " AND ( certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql+=            string( isModerator( sid, uid ) ? " OR 1 )" : " OR 0 )" ); //ǥ졼ʤOR 1ʳ OR 0
    sql+= string( isModerator( sid, uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
    sql+=    ") ";
    sql+= " AND ti.item_type_id != " + unsignedIntToString( item::ITID_INDEX ); //
    sql+= criteria2str( c );
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    
    dst = new itemid_t[ dst_max ];
    *iids = dst;
    if( *iids == 0 ) return RES_ERROR; // out of memory
    *iidsLen = 0;
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLLEN len = 0;
            SQLUINTEGER itemid = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &itemid, 0, &len );
            *iidsLen = 0;
            for( int i = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ; i++ ){
                if( dst_max <= i ){
                    itemid_t* old_dst = dst;
                    dst = new itemid_t[ dst_max * 2 ];
                    if( dst == 0 ){
                        delete[] old_dst;
                        return RES_ERROR; // out of memory
                    }
                    memcpy( dst, old_dst, dst_max * sizeof( itemid_t ) );
                    dst_max *= 2;
                    *iids = dst;
                    delete[] old_dst;
                }
                dst[ i ] = itemid;
                (*iidsLen)++;
            }
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in dumpItemID" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += string( ", sql=" ) + string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in dumpItemID" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * ƥ(Basic Information)򹹿.
 * ˤϥƥԤǥ졼¤ɬס
 * itemitem_idåȤ뤳.
 * 
 * @param sid åID
 * @param item ƥξ
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT
 */
result_t updateItem( sessionid_t sid, const item_t* item )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !isActivatedBySession( sid ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    result_t ret = RES_ERROR;
    
    userid_t sess_uid;
    if( sessionID2UID( sid, &sess_uid ) == RES_OK ){
        if( sess_uid != item -> getContributorUID( ) && !isModeratorBySession( sid ) )
            return RES_NO_WRITE_ACCESS_RIGHT;//no permissions to delete this item
    }else{
        return RES_ERROR;
    }
    
    SQLINTEGER uid, item_type_id, last_update_date, publication_year, publication_month, publication_mday, item_id;
    SQLLEN cbUid = 0, cbItem_type_id = 0, cbLast_update_date = 0, cbPublication_year = 0, cbPublication_month = 0, cbPublication_mday = 0, cbItem_id = 0;
    SQLCHAR title[ XNP_ITEM_TITLE_LEN + 1 ],
        keywords[ XNP_ITEM_KEYWORDS_LEN + 1 ],
        description[ XNP_ITEM_DESCRIPTION_LEN + 1 ],
        doi[ XNP_ITEM_DOI_LEN + 1 ],
        lang[ XNP_ITEM_LANG_LEN + 1 ];
    SQLLEN cbTitle = SQL_NTS,
        cbKeywords = SQL_NTS,
        cbDescription = SQL_NTS,
        cbDOI = SQL_NTS,
        cbLang = SQL_NTS;
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        string sql;
        sql = "UPDATE " + dbprefix + "_xoonips_item_basic SET ";
        sql += "item_type_id=?";
        sql += ", title=?";
        sql += ", keywords=?";
        sql += ", description=?";
        sql += ", doi=?";
        sql += ", uid=?";
        sql += ", last_update_date=?";
        sql += ", publication_year=?";
        sql += ", publication_month=?";
        sql += ", publication_mday=?";
        sql += ", lang=?";
        sql += " WHERE item_id=?";
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &item_type_id, 0, &cbItem_type_id );
            SQLBindParameter(hstmt, 2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ITEM_TITLE_LEN, 0, title, 0, &cbTitle );
            SQLBindParameter(hstmt, 3, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ITEM_KEYWORDS_LEN, 0, keywords, 0, &cbKeywords );
            SQLBindParameter(hstmt, 4, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ITEM_DESCRIPTION_LEN, 0, description, 0, &cbDescription );
            SQLBindParameter(hstmt, 5, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ITEM_DOI_LEN, 0, doi, 0, &cbDOI );
            SQLBindParameter(hstmt, 6, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &uid, 0, &cbUid );
            SQLBindParameter(hstmt, 7, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &last_update_date, 0, &cbLast_update_date );
            SQLBindParameter(hstmt, 8, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &publication_year, 0, &cbPublication_year );
            SQLBindParameter(hstmt, 9, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &publication_month, 0, &cbPublication_month );
            SQLBindParameter(hstmt, 10, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &publication_mday, 0, &cbPublication_mday );
            SQLBindParameter(hstmt, 11, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ITEM_LANG_LEN, 0, lang, 0, &cbLang );
            SQLBindParameter(hstmt, 12, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &item_id, 0, &cbItem_id );
            
            strncpy2( (char*)title, item -> getTitle(), XNP_ITEM_TITLE_LEN );
            strncpy2( (char*)keywords, item -> getKeywords(), XNP_ITEM_KEYWORDS_LEN );
            strncpy2( (char*)description, item -> getDescription(), XNP_ITEM_DESCRIPTION_LEN );
            strncpy2( (char*)doi, item -> getDOI(), XNP_ITEM_DOI_LEN );
            item_type_id = item -> getItemTypeID( );
            uid = item -> getContributorUID( );
            last_update_date = time( NULL );
            publication_year = item -> getPublicationYear();
            publication_month = item -> getPublicationMonth();
            publication_mday = item -> getPublicationMday();
            strncpy2( (char*)lang, item -> getLang(), XNP_ITEM_LANG_LEN );
            item_id = item -> getItemID( );
            
            if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                SQLLEN count = 0;
                if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                    char* certify_item_val;
                    if( getConfigValue( XNP_CONFIG_CERTIFY_ITEM_KEY, &certify_item_val ) == RES_OK ){
                        SQLHANDLE hstmt2 = NULL;
                        certify_t cerity_state = index::NOT_CERTIFIED;
                        if( strcmp( certify_item_val, XNP_CONFIG_CERTIFY_ITEM_AUTO ) == 0 ){
                            cerity_state = index::CERTIFIED;
                        }else if( strcmp( certify_item_val, XNP_CONFIG_CERTIFY_ITEM_ON ) == 0 ){
                            cerity_state = index::CERTIFY_REQUIRED;
                        }
                        //update certify state
                        if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt2 ) ) == SQL_SUCCESS ) {
                            string sql;
                            sql = "SELECT index_item_link_id ";
                            sql += " FROM " + dbprefix + "_xoonips_index_item_link as tlink ";
                            sql += " LEFT JOIN " + dbprefix + "_xoonips_index as tx ON tlink.index_id=tx.index_id ";
                            sql += " LEFT JOIN " + dbprefix + "_xoonips_item_basic as ti ON tlink.item_id=ti.item_id ";
                            sql += " WHERE (tx.open_level=" + unsignedIntToString( index::OL_PUBLIC );
                            sql += " OR tx.open_level=" + unsignedIntToString( index::OL_GROUP_ONLY );
                            sql += ") AND tlink.item_id=" + unsignedIntToString( item_id );
                            syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
                            if( ( sqlcode = SQLExecDirect( hstmt2, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
                                SQLLEN len = 0;
                                SQLUINTEGER registered_index_id = 0;
                                SQLBindCol( hstmt2,1, SQL_C_ULONG, &registered_index_id, 0, &len );
                                certify_t certify_state = getInitialCertifyStateFromConfig( );
                                while ( ( sqlcode = SQLFetch( hstmt2 ) ) == SQL_SUCCESS ){
                                    string sql = "UPDATE " + dbprefix + "_xoonips_index_item_link";
                                    sql += " SET certify_state=" + unsignedIntToString( certify_state );
                                    sql += " WHERE index_item_link_id=" + unsignedIntToString( registered_index_id );
                                    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
                                    querySimple( "updateItem", sql );
                                }
                                ret = insertMetadataEventAuto( item_id, true );
                            }else{
                                string s( "SQLExecDirect in updateItem" );
                                s += odbcDiagString( SQL_HANDLE_STMT, hstmt2, sqlcode );
                                s += string( ", sql=" ) + string( sql );
                                setLastErrorString( s.c_str( ) );
                                ret = RES_DB_QUERY_ERROR;
                            }
                        }else{
                            string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in updateItem" );
                            s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
                            setLastErrorString( s.c_str( ) );
                            ret = RES_ERROR;
                        }
                        syslog_printf( "\n%08lx '%s'", certify_item_val, certify_item_val );
                        if( certify_item_val != 0 ) freeString( certify_item_val );
                        certify_item_val = 0;
                    }else{
                        string s( "getConfigValue in updateItem(key=" );
                        s += XNP_CONFIG_CERTIFY_ITEM_KEY;
                        s += "), ";
                        s += getLastErrorString( );
                        setLastErrorString( s.c_str( ) );
                        ret = RES_ERROR;
                    }
                }else{
                    string s( "SQLRowCount in updateItem sql=" );
                    s += string( sql );
                    setLastErrorString( s.c_str( ) );
                    ret = RES_DB_QUERY_ERROR;
                }
            }else{
                string s( "SQLExecute in updateItem " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else{
            string s( "SQLPrepare in updateItem " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            setLastErrorString( s.c_str( ) );
            ret = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in updateItem" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * ƥ(Basic Information).
 * ǥåɡƥ֥󥯤롥
 * 
 * 
 * @param sid åID
 * @param item ƥξ
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT
 */
result_t deleteItem( sessionid_t sid, itemid_t itemid )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !isActivatedBySession( sid ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    result_t ret = RES_ERROR;
    criteria_t c;
    string sql;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    const item_t* pitem;
    userid_t item_uid;
    
    // retrieve an item's owner uid
    if( getItem( sid, itemid, &pitem ) != RES_OK )
        return RES_NO_WRITE_ACCESS_RIGHT;//no permissions to delete this item
    item_uid = pitem -> getContributorUID();
    freeItem( pitem );
    
    userid_t sess_uid;
    if( sessionID2UID( sid, &sess_uid ) == RES_OK ){
        if( sess_uid != item_uid && !isModeratorBySession( sid ) )
            return RES_NO_WRITE_ACCESS_RIGHT;//no permissions to delete this item
    }else{
        return RES_ERROR;
    }

    /*
      1. delete item from index keywords
      2. delete item from binders
      3. delete item 
      4. delete item from related_to 
    */
    
    //1. delete item from index keywords
    sql = "DELETE FROM " + dbprefix + "_xoonips_index_item_link ";
    sql += "WHERE item_id = " + string( unsignedIntToString( itemid ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLLEN count = 0;
            if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                ret = RES_OK;
            }else{
                string s( "SQLRowCount in deleteItem" );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += string( ", sql=" ) + string( sql );
                setLastErrorString( s.c_str( ) );
                ret = RES_NO_SUCH_USER;
            }
        }else{
            string s( "SQLExecDirect in deleteItem" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in deleteItem" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    
    //2. delete item from binders
    // unregisterBinderItemȤȤϤǤʤʤʤunregisterBinderItemBinderlast_update_date񤭴Ƥޤ顥
    sql = "DELETE FROM " + dbprefix + "_xoonips_binder_item_link ";
    sql += "WHERE item_id = " + string( unsignedIntToString( itemid ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLLEN count = 0;
            if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                ret = RES_OK;
            }else{
                string s( "SQLRowCount in deleteItem" );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += string( ", sql=" ) + string( sql );
                setLastErrorString( s.c_str( ) );
                ret = RES_NO_SUCH_USER;
            }
        }else{
            string s( "SQLExecDirect in deleteItem" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in deleteItem" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    
    // 3. delete item 
    sql = "DELETE FROM " + dbprefix + "_xoonips_item_basic ";
    sql += "WHERE item_id = " + string( unsignedIntToString( itemid ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLLEN count = 0;
            if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                ret = RES_OK;
            }else{
                string s( "SQLRowCount in deleteItem" );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += string( ", sql=" ) + string( sql );
                setLastErrorString( s.c_str( ) );
                ret = RES_NO_SUCH_USER;
            }
        }else{
            string s( "SQLExecDirect in deleteItem" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in deleteItem" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    
    // 4. delete records from related_to
    sql = "DELETE FROM " + dbprefix + "_xoonips_related_to ";
    sql += "WHERE parent_id = " + string( unsignedIntToString( itemid ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() );
    }

    if ( ret == RES_OK ){
        ret = insertMetadataEventAuto( itemid );
    }
    return ret;
}

/**
 * 
 * ĿͤƥIDޤ.
 * ǥåϿǧ줿ΤϷ̤˴ޤߤޤ
 * 
 * @param sid åID
 * @param uid оݥ桼ID
 * @param iids Ͽ줿ƥID
 * @param iidsLen iids˳Ǽ줿Ŀ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
result_t getPrivateItemID( sessionid_t sid, userid_t uid, const itemid_t** iids, int* iidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    int i = 0;
    SQLHANDLE hstmt = NULL, hstmt2 = NULL;
    result_t ret = RES_ERROR;
    itemid_t* dst = 0;
    string sql;
    SQLRETURN sqlcode;
    SQLLEN count = 0;
    userid_t sess_uid;
    
    if( ( ret = sessionID2UID( sid, &sess_uid ) ) != RES_OK ) return ret;
    
    //SELECT ƥ NOT IN ( ǧ줿ƥ )
    sql = "SELECT DISTINCT tlink.item_id";
    sql += " FROM " + dbprefix + "_xoonips_index_item_link AS tlink";
    sql += " LEFT JOIN " + dbprefix + "_xoonips_index AS tx ON tlink.index_id=tx.index_id";
    sql += " LEFT JOIN " + dbprefix + "_xoonips_item_basic AS ti ON tlink.item_id=ti.item_id";
	sql += " LEFT JOIN " + dbprefix + "_xoonips_groups_users_link AS tgulink ON tgulink.gid = tx.gid";

    sql += " WHERE open_level<=" + unsignedIntToString( index::OL_GROUP_ONLY );
    sql += " AND certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql += " AND item_type_id !=" + unsignedIntToString( item::ITID_INDEX );
    sql += " AND item_type_id !=" + unsignedIntToString( item::ITID_BINDER );
    sql += " AND ( ti.uid=" + unsignedIntToString( sess_uid );
    sql +=       " OR is_admin=1 AND tgulink.uid=" + unsignedIntToString( sess_uid );
    sql += ")";
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    *iidsLen = 0;
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            itemid_t iid = 0;
            SQLLEN cbIid = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &iid, 0, &cbIid );
            
            string notin;
            sql = "SELECT item_id FROM " + dbprefix + "_xoonips_item_basic";
            sql += " WHERE item_type_id !=" + unsignedIntToString( item::ITID_INDEX );
            sql += " AND item_type_id !=" + unsignedIntToString( item::ITID_BINDER );
            sql += " AND uid=" + unsignedIntToString( sess_uid );
            for( i = 0 ; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ; i++ ){
                if( i > 0 ) notin += ", ";
                notin += unsignedIntToString( iid );
            }
            if( i > 0 ) sql += " AND item_id NOT IN ( " + notin + " )";
            syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
            
            if( countResultRows( sql.c_str(), &count ) == RES_OK ){
                dst = new itemid_t[ count ];
                *iids = dst;
            }else{
                return RES_ERROR;
            }
            
            if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt2 ) ) == SQL_SUCCESS ) {
                if( ( sqlcode = SQLExecDirect( hstmt2, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
                    itemid_t iid;
                    SQLLEN len = 0;
                    SQLBindCol( hstmt2, 1, SQL_C_ULONG, &iid, 0, &len );
                    *iidsLen = 0;
                    for( int i = 0; ( sqlcode = SQLFetch( hstmt2 ) ) == SQL_SUCCESS && i < count ; i++ ){
                        dst[ i ] = iid;
                        (*iidsLen)++;
                    }
                    ret = RES_OK;
                }else{
                    string s( "SQLExecDirect in getPrivateItemID " );
                    s += odbcDiagString( SQL_HANDLE_STMT, hstmt2, sqlcode );
                    s += "sql=";
                    s += string( sql );
                    setLastErrorString( s.c_str( ) );
                    ret = RES_DB_QUERY_ERROR;
                }
                SQLFreeHandle( SQL_HANDLE_STMT, hstmt2 );
            }else{
                string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getPrivateItemID" );
                s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_ERROR;
            }
        }else {
            string s( "SQLExecDirect in getPrivateItemID " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getPrivateItemID" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }

    return ret;
}

/**
 * 
 * ꥰ롼פOwnerΥǥåϿ졤ľǧ줿ƥIDޤ
 * 
 * @param sid åID
 * @param gid оݥ롼פID
 * @param iids Ͽ줿ƥID
 * @param iidsLen iids˳Ǽ줿Ŀ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
result_t getGroupItemID( sessionid_t sid, groupid_t gid, const itemid_t** iids, int* iidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    SQLHANDLE hstmt = NULL;
    result_t ret = RES_ERROR;
    itemid_t* dst = 0;
    int dst_max = 1024;
    string sql;
    SQLRETURN sqlcode;
    userid_t sess_uid;
    
    if( ( ret = sessionID2UID( sid, &sess_uid ) ) != RES_OK ) return ret;
    
    sql = "SELECT DISTINCT tlink.item_id";
    sql += " FROM " + dbprefix + "_xoonips_index_item_link AS tlink";
    sql += " LEFT JOIN " + dbprefix + "_xoonips_index AS tx ON tlink.index_id=tx.index_id";
    sql += " LEFT JOIN " + dbprefix + "_xoonips_item_basic AS ti ON tlink.item_id=ti.item_id";
	sql += " LEFT JOIN " + dbprefix + "_xoonips_groups_users_link AS tgulink ON tgulink.gid = tx.gid";

    sql += " WHERE open_level=" + unsignedIntToString( index::OL_GROUP_ONLY );
    sql += " AND certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql += " AND item_type_id !=" + unsignedIntToString( item::ITID_INDEX );
    sql += " AND item_type_id !=" + unsignedIntToString( item::ITID_BINDER );
    sql += " AND tx.gid=" + unsignedIntToString( gid );
    
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    dst = new itemid_t[ dst_max ];
    *iids = dst;
    *iidsLen = 0;
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            itemid_t iid = 0;
            SQLLEN cbIid = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &iid, 0, &cbIid );
            for( int i = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ; i++ ){
                if( dst_max <= i ){
                    itemid_t* old_dst = dst;
                    dst = new itemid_t[ dst_max * 2 ];
                    if( dst == 0 ){
                        delete[] old_dst;
                        return RES_ERROR; // out of memory
                    }
                    memcpy( dst, old_dst, dst_max * sizeof( itemid_t ) );
                    dst_max *= 2;
                    *iids = dst;
                    delete[] old_dst;
                }
                dst[ i ] = iid;
                (*iidsLen)++;
            }
        }else {
            string s( "SQLExecDirect in getPrivateItemID " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getPrivateItemID" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }

    return ret;
}

/**
 * 
 * ǥåϿ줿ƥIDޤ.
 * ¤̵ɤʤΤϷ̤˴ޤߤޤ
 * ̤ǧɤʤΤ̤˴ޤߤޤ
 * 
 * @param sid åID
 * @param xid оݥǥåID
 * @param cri ̤ϰϻꡤȾ
 * @param iids Ͽ줿ƥID
 * @param iidsLen iids˳Ǽ줿Ŀ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
result_t getItemIDByIndexID( sessionid_t sid, indexid_t xid, criteria_t* cri, const itemid_t** iids, int* iidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    result_t ret = RES_ERROR;
    itemid_t* dst = 0;
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    SQLLEN count = 0;
    userid_t uid;
    
    if( ( ret = sessionID2UID( sid, &uid ) ) != RES_OK ) return ret;
    sql = "SELECT DISTINCT tlink.item_id AS item_id FROM " + dbprefix + "_xoonips_index_item_link AS tlink";
    sql+= " LEFT JOIN " + dbprefix + "_xoonips_index AS tx ON tlink.index_id = tx.index_id";
    sql+= " LEFT JOIN " + dbprefix + "_xoonips_item_basic AS ti ON tlink.item_id = ti.item_id";
    sql+= " LEFT JOIN " + dbprefix + "_xoonips_groups_users_link as tgulink ON tx.gid=tgulink.gid";
    sql+= " LEFT JOIN " + dbprefix + "_xoonips_session AS tsess ON tsess.uid=" + unsignedIntToString( uid );
    sql+= " AND tsess.sid=" + unsignedIntToString( sid );
    sql+= " WHERE ( " + string( public_item_target_user_all( ) ? "1" : "0" );
    sql+=       " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC ) + " AND tsess.uid IS NULL";
    sql+=       " AND certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql+=    " OR " + string( !public_item_target_user_all( ) ? "1" : "0" );
    sql+=       " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC ) + " AND tsess.uid IS NOT NULL";
    sql+=       " AND ( certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql+=          " OR ti.uid=" + unsignedIntToString( uid ) + ")";
    sql+=    " OR tx.open_level=" + unsignedIntToString( index::OL_PRIVATE );
    sql+=       " AND tx.uid=" + unsignedIntToString( uid );
    sql+=    " OR " + string( isModerator( sid, uid ) ? "1" : "0" );
    sql+=    " OR tx.open_level=" + unsignedIntToString( index::OL_GROUP_ONLY ); //<<
    sql+=    " AND ( certify_state=" + unsignedIntToString( index::CERTIFIED ); //<<
    sql+=          " OR ti.uid=" + unsignedIntToString( uid );
    sql+=          string( isModerator( sid, uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
    sql+=          " OR tgulink.is_admin=1 )"; //롼״Ԥ
    if( uid != session_t::SID_GUEST ) sql+= " AND tgulink.uid=" + unsignedIntToString( uid );
    sql+=    " OR tx.uid IS NULL ";
    sql+=    " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC );
    sql+=    " AND ( certify_state=" + unsignedIntToString( index::CERTIFIED ); //<<
    sql+=          " OR ti.uid=" + unsignedIntToString( uid );
    sql+=          string( isModerator( sid, uid ) ? " OR 1 )" : " OR 0 )" ); //ǥ졼ʤOR 1ʳ OR 0
    sql+=    ") AND ti.item_type_id!=" + unsignedIntToString( item::ITID_INDEX );
    sql+= " AND tx.index_id=" + unsignedIntToString( xid );
    sql += criteria2str( cri );
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    if( countResultRows( sql.c_str(), &count ) == RES_OK ){
        dst = new itemid_t[ count ];
        *iids = dst;
    }else{
        return RES_ERROR;
    }
    
    *iidsLen = 0;
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            itemid_t iid;
            SQLLEN len = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &iid, 0, &len );
            *iidsLen = 0;
            for( int i = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS && i < count ; i++ ){
                dst[ i ] = iid;
                (*iidsLen)++;
            }
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in getItemIDByIndexID " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += "sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getItemIDByIndexID" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * ХϿ줿ƥIDޤ
 * @param sid åID
 * @param binderid оݥХID
 * @param cri ̤ϰϻꡤȾ
 * @param iids Ͽ줿ƥID
 * @param iidsLen iids˳Ǽ줿Ŀ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
result_t getItemIDByBinderID( sessionid_t sid, itemid_t binderid, criteria_t* cri, const itemid_t** iids, int* iidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    result_t ret = RES_ERROR;
    itemid_t* dst = 0;
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    SQLLEN count = 0;
    
    if( dbtype == DBTYPE_MYSQL ){
        sql = "SELECT t1.item_id FROM " + dbprefix + "_xoonips_item_basic as t1, "
            + dbprefix + "_xoonips_binder_item_link as t2 ";
        sql += " WHERE t1.item_id = t2.item_id";
    }else if( dbtype == DBTYPE_SQLITE ){
        sql = "SELECT " + dbprefix + "_xoonips_item_basic.item_id FROM " + dbprefix + "_xoonips_item_basic, "
            + dbprefix + "_xoonips_binder_item_link as t2 ";
        sql += " WHERE " + dbprefix + "_xoonips_item_basic.item_id = t2.item_id";
    }
    sql += " AND t2.binder_id=" + unsignedIntToString( binderid );
    sql += criteria2str( cri );
    if( countResultRows( sql.c_str(), &count ) == RES_OK ){
        dst = new itemid_t[ count ];
        *iids = dst;
    }else{
        return RES_ERROR;
    }
    
    *iidsLen = 0;
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            itemid_t iid;
            SQLLEN len = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &iid, 0, &len );
            *iidsLen = 0;
            for( int i = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS && i < count ; i++ ){
                dst[ i ] = iid;
                (*iidsLen)++;
            }
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in getItemIDByBinderID " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += "sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getItemIDByBinderID" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * ƥξǧ֤ޤ
 * @see certify_t
 * @param sid åID
 * @param xid оݥƥबϿƤ륤ǥåID
 * @param iid оݥƥID
 * @param state ǧ֤
 * @return RES_OK
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * 
 */
result_t getCertifyState( sessionid_t sid, indexid_t xid, itemid_t iid, certify_t* certify )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    
    string sql;
    
    sql = "SELECT certify_state";
    sql += " FROM " + dbprefix + "_xoonips_index_item_link";
    sql += " WHERE item_id = " + unsignedIntToString( iid );
    sql += " AND index_id = " + unsignedIntToString( xid );
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    return queryGetUnsignedInt( "getCertifyState", sql, (unsigned int*)certify );
}

/**
 * 
 * ƥξǧ֤ѹޤ
 * @see certify_t
 * @param sid åID
 * @param xid ѹоݥƥबϿƤ륤ǥåID
 * @param iid ѹоݥƥID
 * @param state ѹǧ
 * @return RES_OK
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * 
 */
result_t setCertifyState( sessionid_t sid, indexid_t xid, itemid_t iid, certify_t state )
{
    if( !getCertifyPermission( sid, xid, iid, state ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    string sql = "UPDATE " + dbprefix + "_xoonips_index_item_link SET certify_state="
        + unsignedIntToString( state )
        + " WHERE index_id=" + unsignedIntToString( xid )
        + " AND item_id=" + unsignedIntToString( iid );
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    result_t ret = querySimple( "setCertifyState", sql );
    if ( ret != RES_OK )
        return ret;
    return insertMetadataEventAuto( iid );
}

/**
 * 
 * ƥξǧ֤ѹ븢¤̵ͭĴ٤ޤ
 * @see certify_t
 * @param sid åID
 * @param xid ѹоݥƥबϿƤ륤ǥåID
 * @param iid ѹоݥƥID
 * @param state ѹǧ
 * @return true ¤
 * @return false ¤ʤ
 * 
 */
bool getCertifyPermission( sessionid_t sid, indexid_t xid, itemid_t iid, certify_t state )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    result_t ret = RES_ERROR;
    string sql;
    SQLLEN count = 0;
    userid_t sess_uid;
    
    if( ( ret = sessionID2UID( sid, &sess_uid ) ) != RES_OK ) return ret;
    
	sql = "SELECT DISTINCT tlink.index_id, tlink.item_id";
	sql += " FROM " + dbprefix + "_xoonips_index_item_link AS tlink";
	sql += " LEFT JOIN " + dbprefix + "_xoonips_index AS tx ON tlink.index_id = tx.index_id";
	sql += " LEFT JOIN " + dbprefix + "_xoonips_item_basic AS ti ON tlink.item_id = ti.item_id";
	sql += " LEFT JOIN " + dbprefix + "_xoonips_groups_users_link AS tgulink ON tgulink.gid = tx.gid";
	sql += " WHERE open_level<=" + unsignedIntToString( index::OL_GROUP_ONLY );
    sql += " AND item_type_id !=" + unsignedIntToString( item::ITID_INDEX );
	sql += " AND ti.item_id=" + unsignedIntToString( iid );
	sql += " AND tx.index_id=" + unsignedIntToString( xid );
	sql += " AND ( is_admin=1 AND tgulink.uid=" + unsignedIntToString( sess_uid );
	sql += " OR item_type_id=" + unsignedIntToString( item::ITID_BINDER ); //٤ƤΥХǧ
    if( state == index_t::NOT_CERTIFIED )
        sql += " OR ti.uid=" + unsignedIntToString( sess_uid );
    sql += string( isModerator( sid, sess_uid ) ? " OR 1)" : " OR 0)" ); //ǥ졼ʤOR 1ʳ OR 0
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );

    if( countResultRows( sql.c_str(), &count ) != RES_OK ){
        return false;
    }
    return count > 0;
}
 
/**
 * 
 * ǥå˥ƥɲä.
 * ƥ˽ǧưͭǤɲäƱ˾ǧԤʤ.
 * 
 * @param sid åID
 * @param xid оݤΥǥåID
 * @param iid ǥåɲäƥID
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_ERROR
 * 
 */
result_t registerItem( sessionid_t sid, indexid_t xid, itemid_t iid )
{
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    string sql;
    result_t ret = RES_ERROR;
    
    if( !getIndexPermission( sid, xid, index::OP_REGISTER ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    // register the item.
    sql = "INSERT INTO " + dbprefix + "_xoonips_index_item_link (index_id, item_id, certify_state) values ("
        + unsignedIntToString(xid) + ","
        + unsignedIntToString(iid) + ","
        + unsignedIntToString( getInitialCertifyStateFromConfig( ) ) + ")";
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    ret = querySimple( "registerItem", sql );
    if( ret == RES_OK ){
        // update last update date
        sql = "UPDATE " + dbprefix + "_xoonips_item_basic SET last_update_date="
            + unsignedIntToString( time( NULL ) ) + " WHERE item_id="
            + unsignedIntToString( xid );
        syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
        ret = querySimple( "registerItem", sql );
    }
    if ( ret == RES_OK ){
        ret = insertMetadataEventAuto( iid );
    }
    return ret;
}

/**
 * 
 * ǥå饢ƥ
 * 
 * @param sid åID
 * @param xid оݤΥǥåID
 * @param iid ǥåƥID
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_ERROR
 * 
 */
result_t unregisterItem( sessionid_t sid, indexid_t xid, itemid_t iid )
{
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    string sql;
    result_t ret = RES_ERROR;
    
    if( !getIndexPermission( sid, xid, index::OP_UNREGISTER ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    // unregister the item.
    sql = "DELETE FROM " + dbprefix + "_xoonips_index_item_link";
    sql += " WHERE index_id=" + unsignedIntToString(xid);
    sql += " AND item_id=" + unsignedIntToString(iid);
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    ret = querySimple( "unregisterItem", sql );
    if( ret == RES_OK ){
        // update last update date
        sql = "UPDATE " + dbprefix + "_xoonips_item_basic SET last_update_date="
            + unsignedIntToString( time( NULL ) ) + " WHERE item_id="
            + unsignedIntToString( xid );
        syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
        ret = querySimple( "unregisterItem", sql );
    }
    if ( ret == RES_OK ){
        ret = insertMetadataEventAuto( iid );
    }
    return ret;
}

/** Binderlast_update_date򹹿롥BinderƤ顢ǧԤˤ롥
 */
result_t touchBinder( const char *functionName, itemid_t binderid ){
    // update binder's last update date
    string sql = "UPDATE " + dbprefix + "_xoonips_item_basic SET last_update_date="
        + unsignedIntToString( time( NULL ) ) + " WHERE item_id="
        + unsignedIntToString( binderid );
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    result_t ret = querySimple( functionName, sql );
    
    if ( ret == RES_OK ){
        // Binder˾ǧѤߤǤļưǧOFFʤ顢BinderǧԤ֤ˤ
        certify_t certify_state = getInitialCertifyStateFromConfig();
        if ( certify_state == index::CERTIFY_REQUIRED ){
            string sql = "update " + dbprefix + "_xoonips_index_item_link "
             " set certify_state=" + unsignedIntToString(certify_state) +
             " where index_id=" + unsignedIntToString(item::IID_BINDERS) +
             "  and item_id=" + unsignedIntToString(binderid) +
             "  and certify_state=" + unsignedIntToString(index::CERTIFIED);
            ret = querySimple( functionName, sql );
        }
    }
    return ret;
}



/**
 * 
 * Х˥ƥɲä
 * 
 * @param sid åID
 * @param binderid оݤΥХID
 * @param iid ХɲäƥID
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_ERROR
 * 
 */
result_t registerBinderItem( sessionid_t sid, itemid_t binderid, itemid_t iid )
{
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    string sql;
    result_t ret = RES_ERROR;
    
    if( !getItemPermission( sid, binderid, item::OP_MODIFY ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    // register the item.
    sql = "INSERT INTO " + dbprefix + "_xoonips_binder_item_link (binder_id, item_id) values ("
        + unsignedIntToString(binderid) + ","
        + unsignedIntToString(iid) + ")";
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    ret = querySimple( "registerBinderItem", sql );
    if( ret == RES_OK ){
        ret = touchBinder("registerBinderItem", binderid);
    }
    return ret;
}

/**
 * 
 * Х饢ƥ
 * 
 * @param sid åID
 * @param binderid оݤΥХID
 * @param iid ХƥID
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_ERROR
 * 
 */
result_t unregisterBinderItem( sessionid_t sid, itemid_t binderid, itemid_t iid )
{
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    string sql;
    result_t ret = RES_OK;
    
    if( !getItemPermission( sid, binderid, item::OP_MODIFY ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    // unregister the item.
    sql = "DELETE FROM " + dbprefix + "_xoonips_binder_item_link";
    sql += " WHERE binder_id=" + unsignedIntToString(binderid);
    sql += " AND item_id=" + unsignedIntToString(iid);
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    ret = querySimple( "unregisterBinderItem", sql );
    if( ret == RES_OK ){
        ret = touchBinder("unregisterBinderItem", binderid);
    }
    return ret;
}

/**
 * 
 * ƥؤΥ¤å
 * 
 * @see itemop_t
 * @param sid åID
 * @param iid åоݤȤʤ륢ƥID
 * @param op μ
 * @return true ¤
 * @return false ¤ʤ
 * 
 */
bool getItemPermission( sessionid_t sid, itemid_t iid, itemop_t op )
{
    string sql;
    itemid_t itemid;
    userid_t uid;
    
    if( sessionID2UID( sid, &uid ) != RES_OK ) return false;
    if( op == item::OP_READ ){
        sql = "SELECT DISTINCT tlink.item_id FROM " + dbprefix + "_xoonips_index_item_link AS tlink";
        sql+= " LEFT JOIN " + dbprefix + "_xoonips_index AS tx ON tlink.index_id = tx.index_id";
        sql+= " LEFT JOIN " + dbprefix + "_xoonips_item_basic AS ti ON tlink.item_id = ti.item_id";
        sql+= " LEFT JOIN " + dbprefix + "_xoonips_groups_users_link as tgulink ON tx.gid=tgulink.gid";
        sql+= " LEFT JOIN " + dbprefix + "_xoonips_session AS tsess ON tsess.uid=" + unsignedIntToString( uid );
        sql+= " AND tsess.sid=" + unsignedIntToString( sid );
        sql+= " WHERE ( " + string( public_item_target_user_all( ) ? "1" : "0" );
        sql+=       " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC ) + " AND tsess.uid IS NULL";
        sql+=       " AND certify_state=" + unsignedIntToString( index::CERTIFIED );
        sql+=    " OR " + string( !public_item_target_user_all( ) ? "1" : "0" );
        sql+=       " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC ) + " AND tsess.uid IS NOT NULL";
        sql+=       " AND certify_state=" + unsignedIntToString( index::CERTIFIED );
        sql+=    " OR tx.open_level=" + unsignedIntToString( index::OL_GROUP_ONLY );
        sql+=      " AND tgulink.uid=" + unsignedIntToString( uid );
        sql+=      " AND ( certify_state=" + unsignedIntToString( index::CERTIFIED );
        sql+=            string( isModerator( sid, uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
        sql+=            " OR tgulink.is_admin=1 )"; //롼״Ԥ
        if( uid != session_t::SID_GUEST ) sql+= " AND tgulink.uid=" + unsignedIntToString( uid );
        sql+=    " OR tx.open_level=" + unsignedIntToString( index::OL_PRIVATE );
        sql+=       " AND tx.uid=" + unsignedIntToString( uid );
        sql+=    " OR " + string( isModerator( sid, uid ) ? "1" : "0" );
        sql+=    " OR tx.uid IS NULL ";
        sql+=    " AND tx.open_level=" + unsignedIntToString( index::OL_PUBLIC );
        sql+=    " AND ( certify_state=" + unsignedIntToString( index::CERTIFIED );
        sql+=            string( isModerator( sid, uid ) ? " OR 1 )" : " OR 0 )" ); //ǥ졼ʤOR 1ʳ OR 0
        sql += string( isModerator( sid, uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
        sql+=    ") AND tlink.item_id=" + unsignedIntToString( iid );
        syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
        if( queryGetUnsignedInt( "getItemPermission", sql, (unsigned int*)&itemid ) == RES_OK ){
            return itemid == iid;
        }
    }else if( op == item::OP_MODIFY || op == item::OP_DELETE ){
        //TODO ɲátodoʬΥƥǤ⾵ǧԤ֤ʤԽǤʤ
        sql = "SELECT item_id FROM " + dbprefix + "_xoonips_item_basic";
        sql += " WHERE uid=" + unsignedIntToString( uid );
        sql += " AND item_id=" + unsignedIntToString( iid );
        syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
        if( queryGetUnsignedInt( "getItemPermission", sql, (unsigned int*)&itemid ) == RES_OK ){
            return itemid == iid;
        }
    }
    return false;
}

/**
 * 
 * ǥåؤΥ¤å
 * 
 * @see indexop_t
 * @param sid åID
 * @param xid åоݤȤʤ륤ǥåID
 * @param op μ
 * @return true ¤
 * @return false ¤ʤ
 * 
 */
bool getIndexPermission( sessionid_t sid, indexid_t xid, indexop_t op )
{
    userid_t uid;
    unsigned int tmp;
    string sql;
    if( xid == index::IID_ROOT ) return false;
    
    if( isModeratorBySession( sid ) );
    else if( xid == item::IID_BINDERS );
    else if( sessionID2UID( sid, &uid ) == RES_OK ){
        sql = "SELECT index_id FROM " + dbprefix + "_xoonips_index as tx";
        sql += " LEFT JOIN " + dbprefix + "_xoonips_users AS tuser ON tx.uid=tuser.uid";
        sql += " LEFT JOIN " + dbprefix + "_xoonips_groups AS tgroup ON tx.gid=tgroup.gid";
        sql += " LEFT JOIN " + dbprefix + "_xoonips_groups_users_link AS tlink ON tx.gid=tlink.gid";
        sql += " WHERE ( tx.open_level=1";
        sql += " OR tx.open_level=2 AND tlink.uid=" + unsignedIntToString( uid );
        sql += " OR tx.open_level=3 AND tx.uid=" + unsignedIntToString( uid ) + " )";
        sql += " AND index_id=" + unsignedIntToString( xid );
        syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
        if( queryGetUnsignedInt( "getIndexPermission", sql, &tmp ) == RES_OK
            && tmp == xid );
        else return false;
    }
    else return false;
    return true;
}

/**
 * 
 * åå.
 * 
 * @param sid åsession
 * @return true 
 * @return false 
 *
 */
bool isValidSessionID( sessionid_t sid )
{
    if( hdbc == NULL ) return false;
    
    bool ret = false;
    string sql;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    char* value = 0;
    
    if( sid == session_t::SID_GUEST ){
        //Ȥ˥ƥʤ顤SIDǧ
        if( getConfigValue( XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_KEY, &value ) == RES_OK ){
            bool ret = ( strcmp( value, XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_ALL ) == 0 );
            freeString( value );
            return ret;
        }
    }
    
    time_t now = time(NULL);
    if( dbtype == DBTYPE_MYSQL ){
        sql = "SELECT * FROM " + dbprefix + "_xoonips_session WHERE sid=" + unsignedIntToString( sid )
            + " AND unix_timestamp(timestamp) > " + unsignedIntToString(now-SESSION_TIMEOUT_SEC);
    }else if( dbtype == DBTYPE_SQLITE ){
        sql = "SELECT * FROM " + dbprefix + "_xoonips_session WHERE sid=" + unsignedIntToString( sid )
            + " AND timestamp > " + unsignedIntToString(now-SESSION_TIMEOUT_SEC);
    }
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            if( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                syslog_printf( "isValidSessionID succeed" );
                ret = true;
            }else{
                string s( "SQLFetch in isValidSessionID " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += string( ", sql=" ) + string( sql );
                setLastErrorString( s.c_str() );
                syslog_printf( "isValidSessionID %s", getLastErrorString( ) );
                ret = false;
            }
        }else{
            string s( "SQLExecDirect in isValidSessionID " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += string( ", sql=" ) + string( sql );
            setLastErrorString( s.c_str( ) );
            syslog_printf( "isValidSessionID %s", getLastErrorString( ) );
            ret = false;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in isValidSessionID " );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        syslog_printf( "isValidSessionID %s", getLastErrorString( ) );
        ret = false;
    }
    if ( ret == true ){
        // timestamp򹹿
        if( dbtype == DBTYPE_MYSQL ){
            sql = "UPDATE " + dbprefix + "_xoonips_session set timestamp=from_unixtime(" + unsignedIntToString(now) 
              + ") WHERE sid=" + unsignedIntToString( sid );
        }else if( dbtype == DBTYPE_SQLITE ){
            sql = "UPDATE " + dbprefix + "_xoonips_session set timestamp=" + unsignedIntToString(now) 
              + " WHERE sid=" + unsignedIntToString( sid );
        }
        querySimple("isValidSession", sql);
    }
    return ret;
}


/**
 * 
 * ˰פ륤ǥåΰ롣
 * 
 * @param cond SQLξＰά0 Ｐtx(index), ti(item), tlink(group_user_link) Ѳǽ
 * @param uid  uidɤ߹߸¤Ĥ褦ʥǥåΤ߼롣
 * @param indexes ǥåΰ֤ѿ
 * @param indexesLen indexesĹ
 * @return RES_OK 
 *
 */
static result_t getIndexesInternal( sessionid_t sid, const char *cond, userid_t uid, const index_t **indexes, int *indexesLen, string &criteriaString ){
    result_t result;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    
    string groupTable = dbprefix + "_xoonips_groups";
    string groupUserLinkTable = dbprefix + "_xoonips_groups_users_link";
    string indexTable = dbprefix + "_xoonips_index";
    string itemTable = dbprefix + "_xoonips_item_basic";
    string uidString = unsignedIntToString( uid );
    if ( cond == 0 )
        cond = " 1 ";
    
    string accessRightCond = "1";
    if ( !isModerator( sid, uid ) )
        accessRightCond =
            " (  tx.open_level=1 "
            " OR tx.open_level=2 AND tlink.uid is not NULL AND tx.gid != " + unsignedIntToString( group::GID_DEFAULT ) + 
            " OR tx.open_level=3 AND tx.uid = " + uidString + ")"; // ɽSQL
    string sql = "SELECT tx.index_id "
        " FROM " + indexTable + " AS tx " + 
        " LEFT JOIN " + itemTable + " AS ti on tx.index_id = ti.item_id "
        " LEFT JOIN " + groupUserLinkTable + " AS tlink on tlink.gid = tx.gid and tlink.uid = " + uidString +
        " LEFT JOIN " + groupTable + " AS tg on tx.gid = tg.gid "
        " WHERE " + accessRightCond + " AND ( tx.open_level != 2 OR tx.open_level = 2 AND tg.gid IS NOT NULL ) AND " + cond;
    SQLLEN len = 0;
    result = countResultRows( sql.c_str(), &len );
    if ( result != RES_OK )
        return result;
    if ( len == 0 ){
        *indexes =  0;
        *indexesLen = 0;
        return result;
    }
    
    sql = "SELECT tx.index_id, tx.parent_index_id, tx.uid, tx.gid, tx.open_level, tx.sort_number "
        " , ti.item_type_id, ti.creation_date, ti.uid, ti.title, ti.keywords, ti.description, ti.last_update_date "
        " FROM " + indexTable + " AS tx " + 
        " LEFT JOIN " + itemTable + " AS ti on tx.index_id = ti.item_id "
        " LEFT JOIN " + groupUserLinkTable + " AS tlink on tlink.gid = tx.gid and tlink.uid = " + uidString +
        " LEFT JOIN " + groupTable + " AS tg on tx.gid = tg.gid "
        " WHERE " + accessRightCond + " AND ( tx.open_level != 2 OR tx.open_level = 2 AND tg.gid IS NOT NULL ) AND " + cond + criteriaString;
    SQLCHAR title[XNP_ITEM_TITLE_LEN+1], 
      keywords[XNP_ITEM_KEYWORDS_LEN+1], description[XNP_ITEM_DESCRIPTION_LEN+1];
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLUINTEGER xid = 0, parentXID = 0, ownerUID = 0, ownerGID = 0, openLevel = 0, 
             sortNumber = 0, itemTypeID = 0, contributorUID = 0, lastUpdateDate = 0, creationDate = 0;
            SQLLEN lens[14];
            memset( lens, 0, sizeof( SQLINTEGER ) * 14 );
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &xid, 0, lens+0 );
            SQLBindCol( hstmt, 2, SQL_C_ULONG, &parentXID, 0, lens+1 );
            SQLBindCol( hstmt, 3, SQL_C_ULONG, &ownerUID, 0, lens+2 );
            SQLBindCol( hstmt, 4, SQL_C_ULONG, &ownerGID, 0, lens+3 );
            SQLBindCol( hstmt, 5, SQL_C_ULONG, &openLevel, 0, lens+4 );
            SQLBindCol( hstmt, 6, SQL_C_ULONG, &sortNumber, 0, lens+5 );
            
            SQLBindCol( hstmt, 7, SQL_C_ULONG, &itemTypeID, 0, lens+6 );
            SQLBindCol( hstmt, 8, SQL_C_ULONG, &creationDate, 0, lens+7 );
            SQLBindCol( hstmt, 9, SQL_C_ULONG, &contributorUID, 0, lens+8 );
            SQLBindCol( hstmt,10, SQL_C_CHAR , &title, XNP_ITEM_TITLE_LEN+1, lens+9 );
            SQLBindCol( hstmt,11, SQL_C_CHAR , &keywords, XNP_ITEM_KEYWORDS_LEN+1, lens+10 );
            SQLBindCol( hstmt,12, SQL_C_CHAR , &description, XNP_ITEM_DESCRIPTION_LEN+1, lens+11 );
            SQLBindCol( hstmt,13, SQL_C_ULONG, &lastUpdateDate, 0, lens+12 );
            
            index_t *index = new index_t[len];
            int i = 0;
            while ( i < len && ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                if ( lens[ 9] == SQL_NULL_DATA ) title[0] = '\0';
                if ( lens[10] == SQL_NULL_DATA ) keywords[0] = '\0';
                if ( lens[11] == SQL_NULL_DATA ) description[0] = '\0';
                if ( lens[ 2] == SQL_NULL_DATA ) ownerUID = 0;
                if ( lens[ 3] == SQL_NULL_DATA ) ownerGID = 0;
                index[i].setIndexID( xid );
                index[i].setParentIndexID( parentXID );
                index[i].setOwnerUID( ownerUID );
                index[i].setOwnerGID( ownerGID );
                index[i].setOpenLevel( openLevel );
                index[i].setSortNumber( sortNumber );
                index[i].setItemTypeID( itemTypeID );
                index[i].setContributorUID( contributorUID );
                if ( parentXID == item::IID_ROOT && openLevel == index::OL_PRIVATE && ownerUID == uid )
                    index[i].setTitle( XNP_PRIVATE_INDEX_TITLE ); // "Private"
                else
                    index[i].setTitle( (char *)title );
                index[i].setKeywords( (char *)keywords );
                index[i].setDescription( (char *)description );
                index[i].setLastUpdateDate( lastUpdateDate );
                index[i].setCreationDate( creationDate );
                i++;
            }
            *indexes = index;
            *indexesLen = i;
            result = RES_OK;
        }else{
            string message( "SQLExecDirect in getIndexesInternal. sql=" );
            message = message + sql;
            setLastErrorString( message.c_str() );
            result = RES_ERROR; 
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }
    else {
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getIndexesInternal" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        result = RES_ERROR;
    }
    return result;
}

/**
 * 
 * uidοͤ(ownerUID,ownerGID,openLevel)Υǥå˽񤭹ย¤뤫ɤĴ٤롣
 * 
 * @param uid åID
 * @param ownerUID indexͭ
 * @param ownerGID indexͭ롼
 * @param openLevel 
 * @return RES_OK 
 *
 */
static bool isWritableInternal( sessionid_t sid, userid_t uid, userid_t ownerUID, groupid_t ownerGID, openlevel_t openLevel ){
    // todo: ٤褦ʤisGroupAdmin,isModeratorȤ鷺ˤʤȤ
    if ( openLevel == index::OL_PUBLIC ){
    }
    else if ( openLevel == index::OL_GROUP_ONLY ){
        if ( isGroupAdmin( sid, ownerGID, uid ) )
            return true;
    }
    else if ( openLevel == index::OL_PRIVATE ){
        if ( uid == ownerUID )
            return true;
    }
    if ( isModerator(sid, uid) )
        return true;
    char buf[100];
    sprintf( buf, "isWritableInternal: sid=%d uid=%d ownerUID=%d ownerGID=%d openLevel=%d", sid, uid, ownerUID, ownerGID, openLevel );
    setLastErrorString( buf );
    
    return false;
}

static bool isWritableInternal( sessionid_t sid, userid_t uid, const index_t *index ){
    return isWritableInternal( sid, uid, index->getOwnerUID(), index->getOwnerGID(), index->getOpenLevel() );
}

/**
 * 
 * 
 * @param sid åID
 * @param gid 롼פUID
 * @param uid 桼UID
 * @return true ¤
 * @return false ¤ʤޤ
 * 
 */
bool isGroupMemberInternal( sessionid_t sid, groupid_t gid, userid_t uid )
{
    if( hdbc == NULL ) return false;
    if( !isValidSessionID( sid ) ) return false;
    if( !uidExists( uid ) ) return false;
    if( !gidExists( gid ) ) return false;
    
    bool ret = false;
    string sql;
    SQLLEN count = 0;
    
    sql = "SELECT * FROM " + dbprefix + "_xoonips_groups_users_link ";
    sql += "WHERE gid=" + string( unsignedIntToString( gid ) );
    sql += " AND uid=" + string( unsignedIntToString( uid ) );
    if( countResultRows( sql.c_str(), &count ) == RES_OK ){
        if( count > 0 ){
            ret = true;
        }else{
            ret = false;
        }
    }else{
        ret = false;
    }
    return ret;
}


/**
 * 
 * uidοͤ(ownerUID,ownerGID,openLevel)Υǥåɤ߹ย¤뤫ɤĴ٤롣
 * 
 * @param uid åID
 * @param ownerUID indexͭ
 * @param ownerGID indexͭ롼
 * @param openLevel 
 * @return RES_OK 
 *
 */
static bool isReadableInternal( sessionid_t sid, userid_t uid, userid_t ownerUID, groupid_t ownerGID, openlevel_t openLevel ){
    // todo: ٤褦ʤisGroupMemberInternalȤ鷺ˤʤȤ
    if ( openLevel == index::OL_PUBLIC ){
        return true;
    }
    else if ( openLevel == index::OL_GROUP_ONLY ){
        if ( isGroupMemberInternal( sid, ownerGID, uid ) )
            return true;
    }
    else if ( openLevel == index::OL_PRIVATE ){
        if ( uid == ownerUID )
            return true;
    }
    if ( isModerator(sid, uid) )
        return true;
    return false;
}

static bool isReadableInternal( sessionid_t sid, userid_t uid, const index_t *index ){
    return isReadableInternal( sid, uid, index->getOwnerUID(), index->getOwnerGID(), index->getOpenLevel() );
}


/**
 * 
 * ǥåɤؤɤ߹߸Ĵ٤
 * 
 * @param sid åID
 * @param xid ǥåɤXID
 * @return 
 *
 */
bool isIndexReadable( sessionid_t sid,  indexid_t xid )
{
    result_t result;
    userid_t uid;
    if( hdbc == NULL ) return false;
    
    result = sessionID2UID( sid, &uid ); // sid  uid 
    if( result == RES_OK ){
        string criteria;
        string cond( "tx.index_id = " + unsignedIntToString( xid ) );
        const index_t *indexes;
        int indexesLen;
        // todo: ٤褦ʤ¾ˡˤ
        result = getIndexesInternal( sid, cond.c_str() , uid, &indexes, &indexesLen, criteria );
        if ( result == RES_OK ){
            freeIndex( indexes );
            if ( indexesLen != 0 ){
                return true;
            }
            else ; // xid
        }
    }
    return false;
}

/**
 * 
 * ǥåɤؤν񤭹߸Ĵ٤
 * 
 * @param sid åID
 * @param xid ǥåɤXID
 * @return 
 *
 */
bool isIndexWritable( sessionid_t sid,  indexid_t xid )
{
    result_t result;
    userid_t uid;
    if( hdbc == NULL ) return false;
    
    result = sessionID2UID( sid, &uid ); // sid  uid 
    if( result == RES_OK ){
        string criteria;
        string cond( "tx.index_id = " + unsignedIntToString( xid ) );
        const index_t *indexes;
        int indexesLen;
        // todo: ٤褦ʤ¾ˡˤ
        result = getIndexesInternal( sid, cond.c_str() , uid, &indexes, &indexesLen, criteria );
        if ( result == RES_OK ){
            bool writable = false;
            if ( indexesLen != 0 ){
                writable = isWritableInternal( sid, uid, indexes );
            }
            freeIndex( indexes );
            return writable;
        }
    }
    return false;
}




/** parentXIDľΥǥåsort_numberκ+1 . parentXIDͤͭɤȽǤʤ
  * ROOTľsort_numberۤʤΤǡδؿǤϽǤʤ
  * @param parentXID  index_id
  * @param sortNumber max(sort_number)+1
  * @return RES_OK 
  */
result_t getNewSortNumber( indexid_t parentXID, unsigned int *sortNumber ){
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    
    string sql = "SELECT max(sort_number) FROM " + dbprefix + "_xoonips_index WHERE parent_index_id=" + unsignedIntToString(parentXID);
    unsigned int u;
    result_t result = queryGetUnsignedInt( "getNewSortNumber", sql, &u );
    if ( result == RES_OK ){
        if ( u == 0 ) // NULLäĤޤparentXIDleaf node Ǥ롣
            *sortNumber = 1; // sort_number=0ͽѤߤʤΤ1Ϥޤ
        else 
            *sortNumber = u+1;
    }
    return result;
}

/**
 * 
 * ǥåɤ
 * 
 * @param sid åID
 * @param xid ǥåɤXID
 * @param index ǥå
 * @return RES_OK 
 *
 */
result_t getIndex( sessionid_t sid, indexid_t xid, const index_t **index )
{
    result_t result;
    userid_t uid;
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    result = sessionID2UID( sid, &uid ); // sid  uid 
    if( result == RES_OK ){
        string criteriaString;
        string cond( " index_id = ");
        cond += unsignedIntToString(xid);
        int indexesLen;
        result = getIndexesInternal( sid, cond.c_str(), uid, index, &indexesLen, criteriaString );
        if ( result == RES_OK && indexesLen == 0 ){
            string s = "in getIndex: no match " + cond;
            setLastErrorString( s.c_str() );
            result = RES_ERROR;
        }
    }
    return result;
}

/**
 * 
 * ƤΥǥåɤ
 * 
 * @param sid åID
 * @param cri ̤ϰϻꡤȾ
 * @param indexes indexݥ
 * @param indexesLen indexesǿ
 * @return RES_OK 
 *
 */
result_t getAllIndexes( sessionid_t sid, criteria_t *cri, const index_t **indexes, int *indexesLen )
{
    result_t result;
    userid_t uid;
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    
    result = sessionID2UID( sid, &uid ); // sid  uid 
    if( result == RES_OK ){
        string criteriaString = criteria2str( cri );
        result = getIndexesInternal( sid, 0, uid, indexes, indexesLen, criteriaString );
    }
    return result;
}

/**
 * 
 * ΥǥåɤƤλҥǥåɤ
 * 
 * @param sid åID
 * @param parentXID ΥǥåλҤ
 * @param cri ̤ϰϻꡤȾ
 * @param indexes indexݥ
 * @param indexesLen indexesǿ
 * @return RES_OK 
 *
 */
result_t getIndexes( sessionid_t sid, indexid_t parentXID, criteria_t *cri, const index_t **indexes, int *indexesLen )
{
    result_t result;
    userid_t uid;
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    
    result = sessionID2UID( sid, &uid ); // sid  uid 
    if( result == RES_OK ){
        string criteriaString = criteria2str( cri );
        string cond( " parent_index_id = ");
        cond += unsignedIntToString(parentXID);
        
        result = getIndexesInternal( sid, cond.c_str(), uid, indexes, indexesLen, criteriaString );
    }
    return result;
}

/** ǥå롣ΥåϹԤʤ
 *  item_type_id, contributor_uid 񤭤롣
  */
static result_t insertIndexInternal( sessionid_t sid, index_t *index, indexid_t *xid ){
    itemid_t iid;

    index->setItemTypeID(item::ITID_INDEX);
    index->setContributorUID(0);
    result_t result = insertItem( sid, index, &iid );
    if ( result == RES_OK ){
        string nullString("NULL");
        string sql = "INSERT INTO " + dbprefix + "_xoonips_index ( index_id, parent_index_id, uid, gid, open_level, sort_number ) values ( "
         + unsignedIntToString(iid) + ","
         + unsignedIntToString(index->getParentIndexID()) + "," 
         + ( index->getOpenLevel() == index::OL_PRIVATE    ? unsignedIntToString(index->getOwnerUID()) : nullString ) + "," 
         + ( index->getOpenLevel() == index::OL_GROUP_ONLY ? unsignedIntToString(index->getOwnerGID()) : nullString ) + "," 
         + unsignedIntToString(index->getOpenLevel()) + "," 
         + unsignedIntToString(index->getSortNumber()) + ") ";
        result = querySimple( "insertIndexInternal", sql );
        if( result == RES_OK ){
            *xid = iid;
        }
        else {
            string sql2 = "DELETE FROM " + dbprefix + "_xoonips_item_basic where item_id=" + unsignedIntToString( iid  );
            querySimple( "insertIndexInternal", sql2 );
            string message( "in insertIndexInternal: bad uid/gid/openlevel. sql=" );
            message = message + sql;
            setLastErrorString( message.c_str() );
            result = RES_ERROR; // 顼: insert˼Ԥ
        }
    }else{
        ;
    }
    return result;
}

/**
 * 
 * ǥåɤϿ
 * 
 * @param sid åID
 * @param index Ͽ륤ǥå
 * @param xid ϿǥåItemID
 * @return RES_OK 
 *
 */
result_t insertIndex( sessionid_t sid, index_t *index, indexid_t *xid )
{
    result_t result = RES_ERROR;
    userid_t uid;
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    
    result = sessionID2UID( sid, &uid ); // sid  uid 
    if( result != RES_OK ) return result;
    
    if( index->getParentIndexID() == item::IID_ROOT ||
        index->getParentIndexID() == item::IID_BINDERS ){
        setLastErrorString( "in insertIndex: parentXID must not Root/Binders " );
        return RES_ERROR; // 顼: Root/BindersľˤϺǤʤ
    }
    
    // parentXID ΥĴ٤
    const index_t *parentIndex;
    result = getIndex( sid, index->getParentIndexID(), &parentIndex );
    if ( result == RES_OK ){
        if ( !isWritableInternal( sid, uid, parentIndex ) ){
            setLastErrorString( "in insertIndex: cannot write to parentindex" );
            result = RES_ERROR;  // 顼: ƥǥåؤν񤭹߸¤̵
        }
        else {
            // Ʊ̾λҥǥåС
            /* titleξͤĤ褦20050516᡼ꡣٹPHP¦ǽФ
            bool conflict = false;
            result = checkTitleConflict( sid, index->getParentIndexID(), index->getTitle(), &conflict );
            if ( result != RES_OK ){
                ;
            }
            else if ( conflict ){
                setLastErrorString( "in insertIndex: title conflict" );
                result = RES_ERROR;  // 顼: Ʊ̾λindex¸ߤ롣
            }
            else */
            if ( index->getTitle()[0] == '\0' ){
                // titleʸˤǤʤ
                setLastErrorString( "in insertIndex: empty title" );
                result = RES_ERROR;
            }
            else {
                unsigned int sortNumber;
                result = getNewSortNumber( index->getParentIndexID(), &sortNumber );
                if ( result == RES_OK ){
                    index->setOpenLevel( parentIndex->getOpenLevel() );
                    index->setOwnerGID( parentIndex->getOwnerGID() );
                    index->setOwnerUID( parentIndex->getOwnerUID() );
                    index->setSortNumber( sortNumber );
                    // ǥå롣
                    result = insertIndexInternal( sid, index, xid );
                }
                else {
                    ; // error: getNewSortNumber failed.
                }
            }
        }
        freeIndex( parentIndex );
    }
    else {
        ; // getIndex
    }
    return result;
}

/** ǻѡxidλ¹(xidޤ)ΥǥåIDƼ.
 * delete[] *descndexIDɬס
 * @param xid о
 * @param descXID ¹
 * @param descXIDLen descXIDĹ
 */
result_t getDescendantIndexID( int xid, indexid_t **descXID, int *descXIDLen ){
    // todo
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    
    string cond = "select count(*) from " + dbprefix + "_xoonips_index";
    unsigned int allIndexCount;
    result_t result = queryGetUnsignedInt( "getDescendantIndexID", cond, &allIndexCount );
    if ( result != RES_OK )
        return result;
    
    indexid_t *p0 = new indexid_t[allIndexCount+1];
    indexid_t *p = p0;
    indexid_t *pFill = p0;
    indexid_t *pEnd = p0 + allIndexCount+1;
    *pFill++ = xid;
    /* *p  *(pFill-1) : ̤õΡɡ줬ˤʤõλ
       *pFill  *(pEnd-1) : ΰ衣줬ˤʤȡʾõǤʤΤǰ۾ｪλ
    */
    result = RES_ERROR;
    while ( true ) {
        if ( p == pFill ){
            // ⤦̤õΡɤ̵
            result = RES_OK;
            break;
        }
        else if ( pFill == pEnd ){
            // ʾõǤʤ
            result = RES_ERROR;
            setLastErrorString( "getDescendantIndexID: index buffer overflow." );
            break;
        }
        
        xid = *p++; // ̤õΡɤ1ļФ
        
        // Ҥ󤷤̤õΡɤȤɲá
        SQLRETURN sqlcode;
        SQLHANDLE hstmt = NULL;    
        if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
            string sql = "SELECT index_id FROM " + dbprefix + "_xoonips_index WHERE parent_index_id=" + unsignedIntToString(xid);
            if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
                SQLUINTEGER sXID = 0;
                SQLLEN len = 0;
                SQLBindCol( hstmt, 1, SQL_C_ULONG, &sXID, 0, &len );
                while ( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                    *pFill++ = sXID;
                    if ( pFill == pEnd )
                        break;
                }
            }else{
                string s( "SQLExecDirect in getDescendantIndexID" );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += "sql=";
                s += string( sql );
                setLastErrorString( s.c_str( ) );
                result = RES_DB_QUERY_ERROR;
                break;
            }
            SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
        }else{
            string s( "SQLAllocHandle in getDescendantIndexID" );
            s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
            setLastErrorString( s.c_str( ) );
            result = RES_ERROR;
        }
    }
    
    if ( result == RES_OK ){
        *descXID = p0;
        *descXIDLen = pFill - p0;
    }
    else {
        delete[] p0;
    }
    return result;
}


#if 0
typedef struct {
   indexid_t xid;
   indexid_t parentXID;
   int tag;
} indexLink_t;
/** Ƥ(index_id,parent_index_id)󤹤롣
 * @param links     RES_OK֤Τͭdelete[]ɬס
 * @param linksLen  linksĹ
 */
static result_t getAllIndexLink( indexLink_t **links, int *linksLen ){
    result_t result = RES_OK;
    string sql("SELECT COUNT(*) from " + dbprefix + "_xoonips_index");
    int totalIndexCount;
    result = getCountInternal( "getAllIndexLink", sql, &totalIndexCount );
    
    if ( result != RES_OK ){
        return result;
    }
    
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        string sql("SELECT index_id, parent_index_id FROM " + dbprefix + "_xoonips_index ORDER BY index_id");
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLUINTEGER xid = 0, parentXID = 0;
            SQLLEN len1 = 0, len2 = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &xid, 0, &len1 );
            SQLBindCol( hstmt, 2, SQL_C_ULONG, &parentXID, 0, &len2 );
            
            indexLink_t *p = new indexLink_t[totalIndexCount];
            int i = 0;
            while ( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                if ( i == totalIndexCount ){
                    result = RES_ERROR;
                    break;
                }
                p[i].xid = xid;
                p[i].parentXID = parentXID;
                p[i].tag = 0;
                i++;
            }
            if ( result == RES_OK ){
                *links = p;
                *linksLen = i;
                
                for ( 
                
            }
        }
        else {
            setLastErrorString( "SQLExecDirect in getAllIndexLink" );
            result = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getAllIndexLink" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        result = RES_ERROR;
    }
    return result;
}
#endif

static result_t checkTitleConflict( sessionid_t sid, indexid_t parentIndexID, const char *title, bool *conflict ){
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    result_t result = RES_ERROR;
    
    string sql( "SELECT count(*) from " + dbprefix + "_xoonips_index as tx "
      " left join " + dbprefix + "_xoonips_item_basic as ti on ti.item_id=tx.index_id "
      " where parent_index_id = " + unsignedIntToString( parentIndexID ) +
      "   and ti.title = ? " );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            SQLLEN cbTitle = SQL_NTS;
            SQLBindParameter(hstmt,  1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, strlen(title), 0, (SQLCHAR *)title, 0, &cbTitle );
            if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                SQLUINTEGER count = 0;
                SQLLEN len = 0;
                SQLBindCol( hstmt, 1, SQL_C_ULONG, &count, 0, &len );
                if( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                    if ( count == 0 ){
                        *conflict = false;
                        result = RES_OK;
                    }
                    else {
                        *conflict = true;
                        result = RES_OK;
                    }
                } else {
                    setLastErrorString( "SQLFetch in checkTitleConflict" );
                    result = RES_ERROR;
                }
            } else {
                string 
                setLastErrorString( "SQLExec in checkTitleConflict" );
                result = RES_ERROR;
            }
        } else {
            setLastErrorString( "SQLPrepare in checkTitleConflict" );
            result = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    } else {
        string s( "SQLAllocHandle in checkTitleConflict" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        result =  RES_ERROR;
    }
    return result;
}




result_t updateIndexInternal( sessionid_t sid, userid_t uid, index_t *newIndex, const index_t *oldIndex, const index_t *newParentIndex, const index_t *oldParentIndex ){
    bool move = ( newIndex->getParentIndexID() != oldIndex->getParentIndexID() );
    
    result_t result = RES_ERROR;
    
    // parent_index_id񤭴Ϲݤʥ顼åԤ
    if ( move ){
        if ( oldIndex->getItemID() == item::IID_ROOT || oldIndex->getParentIndexID() == item::IID_ROOT ){
            setLastErrorString( "in updateIndex: cannot change parent_index_id of system-created-index" );
            return RES_ERROR; //ʬRoot뤤ϿƤRootξϡXIDѹǤʤ
        }
        else if ( newIndex->getParentIndexID() == item::IID_BINDERS ){
            setLastErrorString( "in updateIndex: parent_index_id must not be BINDERS" );
            return RES_ERROR; // ƤBindersˤ뤳ȤϤǤʤ
        }
        else if ( newIndex->getParentIndexID() == item::IID_ROOT ){
            setLastErrorString( "in updateIndex: cannot change parent_index_id to ROOT" );
            return RES_ERROR; // ƤRootǤʤʤ顢ƤRootˤ뤳ȤϤǤʤ
        }
        else if ( oldIndex->getItemID() == item::IID_BINDERS && newParentIndex->getOpenLevel() != index::OL_PUBLIC ){
            setLastErrorString( "in updateIndex: BINDERS must be public" );
            return RES_ERROR; // BINDERSɬΰ֤ɬפ롣
        }
    }
    
    // ƥǥ쥯ȥ˽񤭹뤫ɤå
    if ( !isWritableInternal( sid, uid, newParentIndex ) ){
        setLastErrorString( "in updateIndex: no access right. cannot move." );
        return RES_ERROR; // ưؤν񤭹߸¤ɬס
    }
    
    // sort_numberѹϽʣ̵ɤåưϼưsort_numberΤǥåʤ
    if ( !move && newIndex->getSortNumber() != oldIndex->getSortNumber() ){
        const index_t *conflictIndexes;
        int conflictIndexesLen;
        string criteriaString;
        string cond("tx.sort_number=" + unsignedIntToString(newIndex->getSortNumber()));
        result = getIndexesInternal( sid, cond.c_str() , uid, &conflictIndexes, &conflictIndexesLen, criteriaString );
        if ( result == RES_OK ){
            freeIndex( conflictIndexes );
            if ( conflictIndexesLen != 0 ){
                setLastErrorString( "in updateIndex: sort_number conflicts" );
                return RES_ERROR; // sortNumberνʣ
            }
            else {
                ;// sortNumberνʣ̵
            }
        }
        else {
            return result; // cannot getIndexesInternal()
        }
    }
    
    // ͡titleʸʤ顢͡Ǥʤ
    if ( newIndex->getTitle()[0] == '\0' ){
        setLastErrorString( "in updateIndexInternal: empty title." );
        return RES_ERROR;
    }
    
    // ͡ࡦưtitleͤʤ顢顼
    /* titleξͤĤ褦20050516᡼ꡣٹPHP¦ǽФ
    bool conflict = false;
    result = checkTitleConflict( sid, newIndex->getParentIndexID(), newIndex->getTitle(), &conflict );
    if ( result != RES_OK )
        return result;
    if ( conflict ){
        setLastErrorString( "in updateIndexInternal: title conflict" );
        return RES_ERROR;
    }
    */
    if ( move ){
        indexid_t *descXID = 0;
        int descXIDLen;
        
        // ¹xid󡣽۴ĤΥåԤ
        result = getDescendantIndexID( oldIndex->getIndexID(), &descXID, &descXIDLen );
        if ( result != RES_OK ){
            setLastErrorString( "in updateIndexInternal: getDescendantIndexID failed" );
            return RES_ERROR;
        }
        int i;
        for ( i = 0; i < descXIDLen; i++ ){
            if ( descXID[i] == newIndex->getParentIndexID() ){
                break;
            }
        }
        freeIndexID( descXID );
        if ( i != descXIDLen ){
            // ¹IndexƤˤ褦Ȥ
            setLastErrorString( "in updateIndexInternal: circular parent" );
            return RES_ERROR;
        }
        
        // sort_number롣
        unsigned int sortNumber;
        result = getNewSortNumber(newParentIndex->getIndexID(), &sortNumber);
        if ( result != RES_OK ){
            return result;
        }
        newIndex->setSortNumber( sortNumber );
    }
    
    
    
    
    string ownerOpenLevelString = unsignedIntToString( newParentIndex->getOpenLevel() );
    string ownerUIDString = ( newParentIndex->getOpenLevel() == index::OL_PRIVATE    ? unsignedIntToString(newParentIndex->getOwnerUID()) : string( "NULL" ) );
    string ownerGIDString = ( newParentIndex->getOpenLevel() == index::OL_GROUP_ONLY ? unsignedIntToString(newParentIndex->getOwnerGID()) : string( "NULL" ) );
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        string sql("UPDATE " +  dbprefix + "_xoonips_index set"
            " parent_index_id = " + unsignedIntToString(newIndex->getParentIndexID()) + 
            ", uid = " + ownerUIDString + 
            ", gid = " + ownerGIDString + 
            ", open_level = " + ownerOpenLevelString + 
            ", sort_number = " + unsignedIntToString(newIndex->getSortNumber()) +
            " where index_id = " + unsignedIntToString(newIndex->getIndexID()) );
        
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            string sql("UPDATE " +  dbprefix + "_xoonips_item_basic set"
                " item_type_id = " + unsignedIntToString(newIndex->getItemTypeID()) + 
                ", uid = " + unsignedIntToString(newIndex->getContributorUID()) + 
                ", last_update_date = " + unsignedIntToString(newIndex->getLastUpdateDate()) + 
                ", creation_date = " + unsignedIntToString(newIndex->getCreationDate()) + 
                ", description = ?, title = ?, keywords = ? "
                " where item_id = " + unsignedIntToString(newIndex->getIndexID()) );
            sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
            if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
                SQLLEN cb1 = SQL_NTS, cb2 = SQL_NTS, cb3 = SQL_NTS;
                SQLBindParameter(hstmt,  1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ITEM_DESCRIPTION_LEN, 0, (SQLCHAR *)newIndex->getDescription(), 0, &cb1 );
                SQLBindParameter(hstmt,  2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ITEM_TITLE_LEN, 0, (SQLCHAR *)newIndex->getTitle(), 0, &cb2 );
                SQLBindParameter(hstmt,  3, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_ITEM_KEYWORDS_LEN, 0, (SQLCHAR *)newIndex->getKeywords(), 0, &cb3 );
                if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                    result = RES_OK;
                }
                else {
                    string s( "SQLExecDirect in updateIndex ");
                    s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                    s += string( ", sql=" ) + string( sql );
                    setLastErrorString( s.c_str( ) );
                    result = RES_ERROR;
                }
            }
            else {
                setLastErrorString( "SQLPrepare in updateIndex " );
                result = RES_ERROR;
            }
        }
        else {
            string s( "SQLExecDirect in updateIndex ");
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += string( ", sql=" ) + string( sql );
            setLastErrorString( s.c_str( ) );
            result = RES_ERROR;
        }
        
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }
    else {
        string s( "SQLAllocHandle in updateIndex ");
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        result = RES_ERROR;
    }
    
    if ( result == RES_OK ){
        if ( newParentIndex->getOwnerUID() != oldParentIndex->getOwnerUID() 
          || newParentIndex->getOwnerGID() != oldParentIndex->getOwnerGID() 
          || newParentIndex->getOpenLevel() != oldParentIndex->getOpenLevel() ){
            //  Ƥθΰ褬ѤϡΥǥåȤλ¹θΰѤ롣
            indexid_t *descXID = 0;
            int descXIDLen;
            result = getDescendantIndexID( oldIndex->getIndexID(), &descXID, &descXIDLen );
            if ( result != RES_OK ){
                setLastErrorString( "in updateIndexInternal: getDescendantIndexID failed" );
                return RES_ERROR;
            }
            int i;
            for ( i = 0; i < descXIDLen; i++ ){
                string sql = "UPDATE " + dbprefix + "_xoonips_index set "
                  " uid=" + ownerUIDString +
                  ", gid=" + ownerGIDString +
                  ", open_level=" + ownerOpenLevelString +
                  " WHERE index_id=" + unsignedIntToString(descXID[i]);
                querySimple( "updateIndex", sql );
            }
            freeIndexID( descXID );
            
            // todo: ǥåưϡƥνͭԤ˲餫ΤԤ(PHP)
        }
    }
    
    if ( newIndex->getOpenLevel() == index::OL_PUBLIC ){
        // newIndexʲξǧѤߥƥˤĤ insertMetadataEventAuto Ԥ
        string xid_str;
        {
            indexid_t *descXID = 0;
            int descXIDLen;
            result = getDescendantIndexID( newIndex->getIndexID(), &descXID, &descXIDLen );
            if ( result != RES_OK ){
                setLastErrorString( "in updateIndex: getDescendantIndexID failed" );
                return RES_ERROR; 
            }
            
            xid_str = getCsvStr( descXID, descXIDLen );
            delete[] descXID;
        }
        
        string sql = 
          " select distinct item_id from " + dbprefix + "_xoonips_index_item_link "
          " where certify_state = " + unsignedIntToString(index::CERTIFIED) + 
          "  and index_id in ( 0 " + xid_str + ")";
        sqlexec_t s( "updateIndex", sql, &result );
        if ( s.getSqlcode() == SQL_SUCCESS ){
            SQLUINTEGER iid = 0;
            SQLLEN cbIID = 0;
            SQLBindCol( s.getHstmt(), 1, SQL_C_ULONG, &iid       , 0, &cbIID       );
            
            result = RES_OK;
            while ( SQLFetch( s.getHstmt() ) == SQL_SUCCESS ){
                result = insertMetadataEventAuto( iid );
                if ( result != RES_OK )
                    break;
            }
        }
        else return result;
    }
    
    return result;

}

/**
 * 
 * ǥåɤѹ
 * 
 * @param sid åID
 * @param index ѹ륤ǥå
 * @return RES_OK 
 *
 */
/*
XID񤭴Ȥϡʲա
ƥǥåؤν񤭹߸¤ɬס

ʬޤϤλ¹XIDXIDȤꤹ뤳ȤϤǤʤ
Ƥθΰ褬ѤϡΥǥåȤλ¹θΰѤ롣
*/
result_t updateIndex( sessionid_t sid, index_t *newIndex )
{
    result_t result;
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    
    userid_t uid;
    result = sessionID2UID( sid, &uid ); // sid  uid 
    if( result != RES_OK ) return result;
    
    const index_t *oldIndex;
    result = getIndex( sid, newIndex->getIndexID(), &oldIndex );
    if ( result == RES_OK ){
        const index_t *newParentIndex;
        result = getIndex( sid, newIndex->getParentIndexID(), &newParentIndex );
        if ( result == RES_OK ){
            const index_t *oldParentIndex;
            result = getIndex( sid, oldIndex->getParentIndexID(), &oldParentIndex );
            if ( result == RES_OK ){
                // oldIndex, newParentIndex, oldParentIndexγ˺ɤ٤2Ź¤
                result = updateIndexInternal( sid, uid, newIndex, oldIndex, newParentIndex, oldParentIndex );
                freeIndex( oldParentIndex );
            }
            else {
                ;
            }
            freeIndex( newParentIndex );
        }
        else {
            ;
        }
        freeIndex( oldIndex );
    }
    else {
        ;
    }
    
    return result;
}

result_t deleteIndexInternal( sessionid_t sid, indexid_t xid, const index_t *&index, indexid_t *&descXID, itemid_t *&affectedIIDs )
{
    char *functionName = "deleteIndex";
    result_t result;
    userid_t uid;
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    
    result = sessionID2UID( sid, &uid ); // sid  uid 
    if( result != RES_OK ) return result;
    
    result = getIndex( sid, xid, &index );
    if ( result != RES_OK )
        return result;
    
    if ( index->getIndexID() == item::IID_ROOT || index->getParentIndexID() == item::IID_ROOT ){
        setLastErrorString( "in deleteIndex: cannot delete system-created-index." );
        return RES_ERROR;
    }
    
    if ( !isWritableInternal( sid, uid, index ) ){
        setLastErrorString( "in deleteIndex: no write access right." );
        return RES_NO_WRITE_ACCESS_RIGHT;
    }
    
    // оݤ
    int descXIDLen;
    result = getDescendantIndexID( xid, &descXID, &descXIDLen );
    if ( result != RES_OK ){
        setLastErrorString( "in deleteIndex: getDescendantIndexID failed" );
        return RES_ERROR; 
    }
    
    // оݤBindersäƤϡǤʤ
    for ( int i = 0; i < descXIDLen; i++ ){
        if ( descXID[i] == item::IID_BINDERS ){
            setLastErrorString( "in deleteIndex: target index contains Binders." );
            return RES_ERROR;
        }
    }
    
    int affectedIIDsLen = 0;
    if ( index->getOpenLevel() == index::OL_PUBLIC ){
        // newIndexʲξǧѤߥƥ򵭲Ƥ Ȥ insertMetadataEventAuto Ԥ
        string sql = "select count(*) from " + dbprefix + "_xoonips_item_basic";
        unsigned int iidsLen;
        result = queryGetUnsignedInt( "deleteIndex", sql, &iidsLen );
        if ( result != RES_OK )
            return result;
        affectedIIDs = new itemid_t[iidsLen];
        string xid_str = getCsvStr( descXID, descXIDLen );
        sql = "select item_id from " + dbprefix + "_xoonips_index_item_link "
          "where certify_state=" + unsignedIntToString(index::CERTIFIED) + 
          " and index_id in ( 0 " + xid_str + ") ";
        sqlexec_t s( "deleteIndex", sql, &result );
        if ( s.getSqlcode() != SQL_SUCCESS )
            return result;
        
        SQLUINTEGER iid = 0;
        SQLLEN cbIID = 0;
        SQLBindCol( s.getHstmt(), 1, SQL_C_ULONG, &iid       , 0, &cbIID       );
        
        for ( affectedIIDsLen = 0; affectedIIDsLen < iidsLen &&  ( SQLFetch( s.getHstmt() ) == SQL_SUCCESS ); affectedIIDsLen++ ){
            affectedIIDs[affectedIIDsLen] = iid;
        }
    }
    
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        result = RES_OK;
        string strParentXID = unsignedIntToString( index->getParentIndexID() );
        for ( int i = descXIDLen-1; i >= 0; i-- ){ // ˤơǼԤλɤdescXIDͥõ¤ǤΤǡ
            string strXID = unsignedIntToString(descXID[i]);
            string linkTable = dbprefix + "_xoonips_index_item_link";
            string indexTable = dbprefix + "_xoonips_index";
            

            // descXID[i]Privateʲ && descXID[i]ΥƥI򻲾ȤPrivateindex1Ĥʤ  I»Ҥˤʤʤ褦˿Ƥ˰ư
            if ( index->getOpenLevel() == index::OL_PRIVATE ){
                string sql( "SELECT t1.index_item_link_id, t1.item_id, count(*) "
                    " FROM " + linkTable + " AS t1 "
                    " LEFT JOIN " + linkTable + " AS t2 ON t1.item_id = t2.item_id "
                    " LEFT JOIN " + indexTable + " AS tx2 on t2.index_id = tx2.index_id "
                    " WHERE t1.index_id=" + strXID + 
                      " and tx2.open_level = " + unsignedIntToString(index::OL_PRIVATE) +
                      " group by t1.item_id " );
                if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
                    SQLUINTEGER sLinkID = 0, sItemID = 0, sCount = 0;
                    SQLLEN len1 = 0, len2 = 0, len3 = 0;
                    SQLBindCol( hstmt, 1, SQL_C_ULONG, &sLinkID, 0, &len1 );
                    SQLBindCol( hstmt, 2, SQL_C_ULONG, &sItemID, 0, &len2 );
                    SQLBindCol( hstmt, 3, SQL_C_ULONG, &sCount , 0, &len3 );
                    while ( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                        if ( sCount == 1 ){
                            string sql2( "UPDATE " + linkTable + " set index_id= " + strParentXID + " where index_item_link_id = " + unsignedIntToString(sLinkID) );
                            result = querySimple( "deleteIndex", sql2 );
                            if( result != RES_OK )
                                break;
                        }
                    }
                    if ( result != RES_OK )
                        break;
                }else{
                    string s( "SQLExecDirect in deleteIndex" );
                    s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                    s += "sql=";
                    s += string( sql );
                    setLastErrorString( s.c_str( ) );
                    result = RES_DB_QUERY_ERROR;
                }
            }
            
            // descXID[i] Υƥƺ
            string sql = "DELETE from " + linkTable + " where index_id=" + strXID;
            result = querySimple( functionName, sql );
            if ( result == RES_OK ){
                // descXID[i] 
                sql = "DELETE from " + dbprefix + "_xoonips_item_basic where item_id =" + strXID;
                result = querySimple( functionName, sql );
                if ( result == RES_OK ){
                    sql = "DELETE from " + dbprefix + "_xoonips_index      where index_id=" + strXID;
                    result = querySimple( functionName, sql );
                }
            }
            
            // SQLFreeStmtˤĤƤ  http://as400bks.rochester.ibm.com/pubs/html/as400/v4r5/ic2962/info/db2/rzadpmst62.htm#HDRFNFSTMT
            SQLFreeStmt( hstmt, SQL_CLOSE ); 
            SQLFreeStmt( hstmt, SQL_UNBIND );
        }
        
        // ƶϤΥƥ insertMetadataEventAuto
        for ( int i = 0; i < affectedIIDsLen; i++ ){
            insertMetadataEventAuto( affectedIIDs[i] );
        }
    }else{
        string s( "SQLAllocHandle in deleteIndex" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        result = RES_ERROR;
    }
    
    return result;
}

/**
 * 
 * ǥåɤ
 * 
 * @param sid åID
 * @param xid 륤ǥå
 * @return RES_OK 
 *
 */
result_t deleteIndex( sessionid_t sid,  indexid_t xid )
{
    const index_t *index = 0;
    indexid_t *descXID = 0;
    itemid_t *affectedIIDs = 0;
    result_t result =  deleteIndexInternal( sid, xid, index, descXID, affectedIIDs );
    if ( index ) freeIndex( index );
    if ( descXID ) delete[] descXID;
    if ( affectedIIDs ) delete[] affectedIIDs;
    return result;
}





/**
 * 
 * ǥåɤν֤ؤ
 * 
 * @param sid åID
 * @param xid1 ؤǥåɤXID
 * @param xid2 ؤǥåɤXID
 * @return RES_OK 
 *
 */
result_t swapIndexSortNumber( sessionid_t sid, itemid_t xid1, itemid_t xid2 )
{
    char *functionName = "swapIndexSortNumber";
    result_t result;
    userid_t uid;
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    
    result = sessionID2UID( sid, &uid ); // sid  uid 
    if( result == RES_OK ){
        /*
          xid1, xid2 οƤۤʤʤ顢顼
          xid1, xid2 ξ˽񤭹߸¤뤳Ȥǧ
          ϡ
            tmp1 = x1.sort_number; 
            tmp2 = x2.sort_number; 
            x1.sort_number = 0; // (parent_index_id,sort_number)uniqueʤΤǡö1ѹ롣
            x2.sort_number = tmp1; 
            x1.sort_number = tmp2;
        */
        const index_t *index1, *index2;
        result = getIndex( sid, xid1, &index1 );
        if ( result == RES_OK ){
            result = getIndex( sid, xid2, &index2 );
            if ( result == RES_OK ){
                if ( index1->getParentIndexID() == index2->getParentIndexID() ){
                    if ( isWritableInternal( sid, uid, index1 ) && isWritableInternal( sid, uid, index2 ) ){
                        string xid1String = unsignedIntToString(xid1);
                        string xid2String = unsignedIntToString(xid2);
                        string indexTable = dbprefix + "_xoonips_index";
                        string sql1 = "UPDATE " + indexTable + " set sort_number=0 WHERE index_id=" + xid1String;
                        string sql2 = "UPDATE " + indexTable + " set sort_number=" + unsignedIntToString(index1->getSortNumber()) + " WHERE index_id=" + xid2String;
                        string sql3 = "UPDATE " + indexTable + " set sort_number=" + unsignedIntToString(index2->getSortNumber()) + " WHERE index_id=" + xid1String;
                        
                        if( (result=querySimple(functionName,sql1)) == RES_OK ){
                            if( (result=querySimple(functionName,sql2)) == RES_OK ){
                                if( (result=querySimple(functionName,sql3)) == RES_OK ){
                                    ;
                                }
                            }
                        }
                    }
                    else {
                        setLastErrorString( "swapIndexSortNumber: not writable" );
                        result = RES_ERROR;
                    }
                }
                else {
                    setLastErrorString( "swapIndexSortNumber: not brother" );
                    result = RES_ERROR;
                }
                freeIndex( index2 );
            }
            else {
            }
            freeIndex( index1 );
        }
        else {
        }
    }
    return result;
}

/**
 * 
 * ̾keyͤvauleꤹ
 * 
 * @param key ꥭ̾
 * @param value 
 * 
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 */
result_t setConfigValue( const char* key, const char* value )
{
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    SQLHANDLE hstmt2 = NULL;    
    SQLLEN cbKey = SQL_NTS, cbValue = SQL_NTS;
    result_t ret = RES_ERROR;
    
    // nijc_code  guestON/OFF 񤭴Ȥϡitem_statusꥻåȤ롥
    bool isNijcOrGuest = ( strcmp( key, XNP_CONFIG_REPOSITORY_NIJC_CODE ) == 0 || strcmp( key, XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_KEY ) == 0 );
    char *oldValue = 0;
    if ( isNijcOrGuest )
        getConfigValue( key, &oldValue );
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        string sql( "UPDATE " + dbprefix + "_xoonips_config SET value=? WHERE name=?");
        syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, SQL_DESC_LENGTH, 0, (SQLCHAR*)value, strlen(value), &cbValue );
            SQLBindParameter(hstmt, 2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_CONFIG_NAME_LEN, 0, (SQLCHAR*)key  , strlen(key)  , &cbKey );
            sqlcode = SQLExecute( hstmt );
            syslog_printf( "\nsqlcode at %d=%d", __LINE__, sqlcode );
            if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
                SQLLEN count = 0;
                if( ( sqlcode = SQLRowCount( hstmt, &count ) ) == SQL_SUCCESS && count > 0 ){
                    ret = RES_OK;
                }else if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt2 ) ) == SQL_SUCCESS ) {
                    string sql( "INSERT INTO " + dbprefix + "_xoonips_config (name,value) VALUES (?,?)");
                    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
                    sqlcode = SQLPrepare(hstmt2, (SQLCHAR*)sql.c_str(), SQL_NTS);
                    if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
                        SQLBindParameter(hstmt2, 1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_CONFIG_NAME_LEN, 0, (SQLCHAR*)key  , strlen(key)  , &cbKey );
                        SQLBindParameter(hstmt2, 2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, SQL_DESC_LENGTH, 0, (SQLCHAR*)value, strlen(value), &cbValue );
                        sqlcode = SQLExecute( hstmt2 );
                        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
                            if( ( sqlcode = SQLRowCount( hstmt2, &count ) ) == SQL_SUCCESS && count > 0 ){
                                ret = RES_OK;
                            }else{
                                string s( "SQLRowCount in setConfigValue" );
                                s += odbcDiagString( SQL_HANDLE_STMT, hstmt2, sqlcode );
                                s += "sql=";
                                s += string( sql );
                                setLastErrorString( s.c_str( ) );
                                ret = RES_ERROR;
                            }
                        }else{
                            string s( "SQLExecDirect in setConfigValue" );
                            s += odbcDiagString( SQL_HANDLE_STMT, hstmt2, sqlcode );
                            s += "sql=";
                            s += string( sql );
                            setLastErrorString( s.c_str( ) );
                            ret = RES_DB_QUERY_ERROR;
                        }
                    }else {
                        setLastErrorString( "SQLPrepare in setConfigValue" );
                        ret = RES_ERROR;
                    }
                    SQLFreeHandle( SQL_HANDLE_STMT, hstmt2 );
                }else{
                    string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in setConfigValue" );
                    s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
                    setLastErrorString( s.c_str( ) );
                    ret = RES_ERROR;
                }
            }else{
                string s( "SQLExecDirect in setConfigValue" );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += "sql=";
                s += string( sql );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else {
            setLastErrorString( "SQLPrepare in setConfigValue" );
            ret = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in setConfigValue" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    
    // nijc_code  guestON/OFF 񤭴Ȥϡitem_statusꥻåȤ롥
    if ( ret == RES_OK && isNijcOrGuest && ( oldValue == 0 || strcmp( value, oldValue ) != 0 ) )
        refreshItemStatus();
    if ( oldValue )
        freeString( oldValue );
    
    return ret;
}

/**
 * 
 * ̾keyбͤvaule˼.
 * valueλѸfreeStringǲ롥
 * @param key ꥭ̾
 * @param value ͤݥ
 * 
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 */
result_t getConfigValue( const char* key, char** value )
{
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    SQLLEN cbKey = SQL_NTS;
    result_t ret = RES_ERROR;
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        string sql("SELECT value FROM " + dbprefix + "_xoonips_config WHERE name=?");
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            sqlcode = SQLBindParameter(hstmt,  1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_CONFIG_NAME_LEN, 0, (SQLCHAR*)key, 0, &cbKey );
            syslog_printf( "SQLBindParameter %d", sqlcode);
            if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                while( SQLFetch( hstmt ) == SQL_SUCCESS ){
                    SQLLEN length = 0;
                    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
                    if( dbtype == DBTYPE_MYSQL ){
                        // get amount of data
                        sqlcode = SQLGetData(hstmt, 1, SQL_C_BINARY, value, 0, &length);
                        syslog_printf( "sqlreturn : %d length %d", sqlcode, length);
                        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
                            // Get all the data at once.
                            *value = new char[ length + 1 ];
                            memset( *value, '\0', length + 1 );
                            syslog_printf( "\ngetConfigValue length=%d", length );
                            if( SQLGetData(hstmt, 1, SQL_C_DEFAULT, *value,
                                           length, &length) == SQL_SUCCESS ){
                                ret = RES_OK;
                                syslog_printf( "\ngetConfigValue returns '%s'", *value );
                                break;
                            }else{
                                string s( "SQLGetData in getConfigValue" );
                                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                                s += "sql=";
                                s += string( sql );
                                setLastErrorString( s.c_str( ) );
                                ret = RES_DB_QUERY_ERROR;
                            }
                        }else{
                            string s( "SQLGetData in getConfigValue" );
                            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                            s += "sql=";
                            s += string( sql );
                            setLastErrorString( s.c_str( ) );
                            ret = RES_DB_QUERY_ERROR; 
                        }
                    }else if( dbtype == DBTYPE_SQLITE ){
                        string val = getResultCol( hstmt, 1 );
                        *value = new char[ val.length() + 1 ];                    
                        strcpy( *value, val.c_str() );
                        syslog_printf( "\ngetConfigValue value=%s", *value );
                        ret = RES_OK;
                        break;
                    }
                }
            }else{
                string s( "SQLExecDirect in getConfigValue" );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += "sql=";
                s += string( sql );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else {
            string s( "SQLPrepare in getConfigValue" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += "sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getConfigValue" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * ƥѹ롥
 * 
 * @param sid åID
 * @param itemid ѹ륢ƥID
 * @param logs Ƥݥ
 * @param logsLen logs˳Ǽ줿θĿ
 * @return RES_OK 
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_READ_ACCESS_RIGHT
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_ERROR
 * 
 */
result_t getChangeLogs( sessionid_t sid, itemid_t itemid, const changelog_t** logs, int* logsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !getItemPermission( sid, itemid, item::OP_READ ) ) return RES_NO_READ_ACCESS_RIGHT;
    
    result_t ret = RES_ERROR;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    SQLLEN count = 0;
    string sql;
    SQLLEN len = 0;
    time_t log_date = 0;
    
    sql = "SELECT log_date, log FROM " +  dbprefix + "_xoonips_changelog"
        + " WHERE item_id=" + unsignedIntToString( itemid )
        + " ORDER BY log_date DESC, log_id DESC";
    if( countResultRows( sql.c_str(), &count ) == RES_OK ){
        changelog_t* logs_ = new changelog_t[ count ];
        if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
            if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
                SQLBindCol( hstmt, 1, SQL_C_ULONG, &log_date, 0, &len );
                for( *logsLen=0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS && *logsLen < count ; (*logsLen)++ ){
                    ( logs_ + *logsLen ) -> setDate( log_date );
                    ( logs_ + *logsLen ) -> setLog( getResultCol( hstmt, 2 ).c_str() );
                }
                *logs = logs_;
                ret = RES_OK;
            }else{
                string s( "SQLExecDirect in getChangeLogs ");
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += string( ", sql=" ) + string( sql );
                setLastErrorString( s.c_str( ) );
                ret = RES_ERROR;
            }
        }else {
            string s( "SQLAllocHandle in getChangeLogs ");
            s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
            setLastErrorString( s.c_str( ) );
            ret = RES_ERROR;
        }
    }
    return ret;
}


/**
 * 
 * ѹϿ롥
 * 
 * @param sid åID
 * @param itemid ѹϿ륢ƥID
 * @param log 
 * @return RES_OK 
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_ERROR
 * 
 */
result_t insertChangeLog( sessionid_t sid, itemid_t itemid, const char* log )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !getItemPermission( sid, itemid, item::OP_MODIFY ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    result_t ret = RES_ERROR;
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    time_t now;
    
    time( &now );
    // insert change log
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        SQLLEN cbLog = SQL_NTS;
        string sql;
        sql = "INSERT INTO " + dbprefix + "_xoonips_changelog (item_id, log_date, log) VALUES (";
        sql += unsignedIntToString( itemid ) + ", ";
        sql += unsignedIntToString( now ) + ", ?)";
        syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if( sqlcode == SQL_SUCCESS || sqlcode == SQL_SUCCESS_WITH_INFO ){
            SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_LONGVARCHAR, XNP_CHANGELOG_LOG_LEN, 0,
                             (SQLCHAR*)( log ), strlen( log ), &cbLog );
            if( ( sqlcode = SQLExecute( hstmt ) ) == SQL_SUCCESS ){
                // update last update date
                sql = "UPDATE " + dbprefix + "_xoonips_item_basic SET last_update_date="
                    + unsignedIntToString( now ) + " WHERE item_id="
                    + unsignedIntToString( itemid );
                syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
                querySimple( "insertChangeLog", sql );
                ret = RES_OK;
            }else{
                string s( "SQLExecute in insertChangeLog " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else{
            string s( "SQLPrepare in insertChangeLog " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            setLastErrorString( s.c_str( ) );
            ret = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }
    return ret;
}

/**
 * 
 * 
 * @param pmid PUBMEDID
 * @param pubmed ̤񤭹pubmed_tΥݥ󥿰
 * 
 * 
 * 
 */
result_t pubmedComplete( pubmedid_t pmid, const pubmed_t** pubmed )
{
    result_t ret = RES_ERROR;
    
    string url( PUBMED_EFETCH_URL_BASE );
    url += unsignedIntToString( pmid );
    *pubmed = new pubmed_t[1];
    if( streamPubmedFile( url.c_str(), ( pubmed_t* )*pubmed ) == 0 ) ret = RES_OK;
    return ret;
}

void freeIndex( const index_t* ptr ){ delete[] ptr; }
void freeIndexID( const indexid_t* ptr ){ delete[] ptr; }
void freeAccount( const account_t* ptr ){ delete[] ( account_t* )ptr; }
void freeGroup( const group_t* ptr ){ delete[] ( group_t* )ptr; }
void freeSession( const session_t* ptr ){ delete[] ( session_t* )ptr; }
void freeUID( const userid_t* ptr ){ delete[] ( userid_t* )ptr; }
void freeGID( const groupid_t* ptr ){ delete[] ( groupid_t* )ptr; }
void freeItem( const item_t* ptr ){ delete[] ( item_t* )ptr; }
void freeItemType( const itemtype_t* ptr ){ delete[] ( itemtype_t* )ptr; }
void freeItemID( const itemid_t* ptr ){ delete[] ( itemid_t* )ptr; }
void freeString( char* str ){ delete[] str; }
void freeStringArray( char** strs, int len ){ for( int i = 0; i < len; i++ ) freeString( strs[ i ] ); delete[] strs; }
void freeChangeLog( const changelog_t* ptr ){ delete[] ( changelog_t* )ptr; }
void freePubmed( const pubmed_t* ptr ){ delete[] ( pubmed_t* )ptr; }
void freeInt( const int* ptr ){ delete[] ( int* )ptr; }

static string errstr;
const char* getLastErrorString()
{
    return errstr.c_str( );
}

void setLastErrorString( const char* str )
{
    errstr = str;
    syslog_printf( "%s", str );
    syslog_printf( "\nsetLastErrorString( '%s' );", str );
}


//ߥΥΡɤΥƥȤФ
//ԻNULL
//ѸxmlFreeǲɬפ
static xmlChar* getChildText(xmlTextReaderPtr reader)
{
    if( xmlTextReaderRead(reader) == 1 ){
        if( xmlTextReaderNodeType( reader ) == XML_READER_TYPE_TEXT ){
            return xmlTextReaderValue( reader );
        }
    }
    return NULL;
}

static int streamPubmedFile(const char *filename, pubmed_t* p)
{
    xmlTextReaderPtr reader = 0;
    int ret = 0;
    int DocID = 0;
    
    reader = xmlNewTextReaderFilename(filename);
    if( reader != NULL ){
        ret = xmlTextReaderRead(reader);
        while( ret == 1 ){
            processEfetch(reader, p);
            ret = xmlTextReaderRead(reader);
        }
        xmlFreeTextReader(reader);
    }
    xmlErrorPtr err = xmlGetLastError();
    if( err != NULL ){
        setLastErrorString( err -> message );
        return ret;
    }
    
    // processEfetchjournalϾάʤΤǡάѴ
    string url = PUBMED_ESEARCH_URL_BASE;
    string journal( p -> getJournal() );
    url += urlencode("\""+journal+"\"[TA]"); // [TA] = [Title Abbreviation]
    url = urlencode(url);  // libxmlΥХ(?)Τᡢ2urlencode
    reader = xmlNewTextReaderFilename(url.c_str());
    if( reader != NULL ){
        ret = xmlTextReaderRead(reader);
        while( ret == 1 ){
            if( processEsearch(reader, p, &DocID ) ) {
                
                string title, title_abbr;
                url = PUBMED_ESUMMARY_URL_BASE;
                url += intToString( DocID );
                xmlTextReaderPtr reader2 = xmlNewTextReaderFilename(url.c_str());
                if( reader2 != NULL ){
                    ret = xmlTextReaderRead(reader2);
                    while( ret == 1 ){
                        processEsummary( reader2, title, title_abbr );
                        ret = xmlTextReaderRead( reader2 );
                    }
                    xmlFreeTextReader(reader2);
                }
                err = xmlGetLastError();
                if( err != NULL ){
                    setLastErrorString( err -> message );
                    //return ret;
                }
                if ( title_abbr == journal )
                    p -> setJournal( title.c_str() );
                
            }
            ret = xmlTextReaderRead(reader);
        }
        while( ret == 1 ){
            ret = xmlTextReaderRead(reader);
        }
        xmlFreeTextReader(reader);
    }
    err = xmlGetLastError();
    if( err != NULL ){
        setLastErrorString( err -> message );
        return ret;
    }
    
    return ret;
}

static void processEfetch(xmlTextReaderPtr reader, pubmed_t* p )
{
    xmlChar* name = NULL;
    xmlChar* value = NULL;
    
    name = xmlTextReaderName(reader);
    if( name == NULL)
        name = xmlStrdup(BAD_CAST "--");
    value = xmlTextReaderValue(reader);
    
    if( xmlTextReaderNodeType(reader) == XML_READER_TYPE_ELEMENT ){
        if( strcmp( "PMID", ( char* )name ) == 0 ){
            if( xmlTextReaderRead(reader) == 1 ){
                if( xmlTextReaderNodeType( reader ) == XML_READER_TYPE_TEXT ){
                    xmlChar* value = xmlTextReaderValue( reader );
                    //printf( "PMID=%s\n", value );
                    p -> setID( atoi( ( char* )value ) );
                    xmlFree( value );
					value = NULL;
                }
            }
        }else if( strcmp( "ArticleTitle", ( char* )name ) == 0 ){
            xmlChar* val = getChildText( reader );
            p -> setTitle( ( char* )val );
            if( val != NULL ) xmlFree( val );
        }else if( strcmp( "ForeName", ( char* )name ) == 0 ){
            xmlChar* val = getChildText( reader );
            int len = strlen( p -> getAuthor( ) ) + strlen( ( char* )val )
                + 2;// ' ', '\0'
            char* buf = new char[ len ];
            snprintf( buf, len, "%s %s", p -> getAuthor( ), val );
            p -> setAuthor( ( char* )buf );
            if( val != NULL ) xmlFree( val );
            delete[] buf;
        }else if( strcmp( "LastName", ( char* )name ) == 0 ){
            xmlChar* val = getChildText( reader );
            if( strlen( p -> getAuthor( ) ) > 0 ){
                int len = strlen( p -> getAuthor( ) ) + strlen( ( char* )val )
                    + 3;// '\n', ' ', '\0'
                char* buf = new char[ len ];
                snprintf( buf, len, "%s\n%s", p -> getAuthor( ), val );
                p -> setAuthor( ( char* )buf );
                delete[] buf;
            }else{
                p -> setAuthor( ( char* )val );
            }
            if( val != NULL ) xmlFree( val );
        }else if( strcmp( "MedlineTA", ( char* )name ) == 0 ){
            xmlChar* val = getChildText( reader );
            p -> setJournal( ( char* )val );
            if( val != NULL ) xmlFree( val );
        }else if( strcmp( "Year", ( char* )name ) == 0 ){
            xmlChar* val = getChildText( reader );
            p -> setYearOfPublication( atoi( ( char* )val ) );
            if( val != NULL ) xmlFree( val );
        }else if( strcmp( "Volume", ( char* )name ) == 0 ){
            xmlChar* val = getChildText( reader );
            p -> setVolume( atoi( ( char* )val ) );
            if( val != NULL ) xmlFree( val );
        }else if( strcmp( "Issue", ( char* )name ) == 0 ){
            xmlChar* val = getChildText( reader );
            p -> setNumber( atoi( ( char* )val ) );
            if( val != NULL ) xmlFree( val );
        }else if( strcmp( "MedlinePgn", ( char* )name ) == 0 ){
            xmlChar* val = getChildText( reader );
            p -> setPage( ( char* )val );
            if( val != NULL ) xmlFree( val );
        }else if( strcmp( "AbstractText", ( char* )name ) == 0 ){
            xmlChar* val = getChildText( reader );
            p -> setAbstract( ( char* )val );
            if( val != NULL ) xmlFree( val );
        }
    }
    xmlFree(name);
    
    if( value != NULL) xmlFree(value);
}

/**
 * 
 * @return true DocID
 * @return false DocIDʤäѡη³
 */
static bool processEsearch(xmlTextReaderPtr reader, pubmed_t* p, int* DocID )
{
    xmlChar* name = NULL;
    xmlChar* value = NULL;
    
    name = xmlTextReaderName(reader);
    if( name == NULL)
        name = xmlStrdup(BAD_CAST "--");
    value = xmlTextReaderValue(reader);
    
    if( xmlTextReaderNodeType(reader) == XML_READER_TYPE_ELEMENT ){
        if( strcmp( "Id", ( char* )name ) == 0 ){
            if( xmlTextReaderRead(reader) == 1 ){
                if( xmlTextReaderNodeType( reader ) == XML_READER_TYPE_TEXT ){
                    xmlChar* value = xmlTextReaderValue( reader );
                    *DocID = atoi( ( char* )value );
                    xmlFree( value );
                    value = NULL;
                    return true;
                }
            }
        }
    }
    xmlFree(name);
    
    if( value != NULL) xmlFree(value);
    return false;
}

/**
 * 
 * Journal Title, Journal Title Abbreviation 롥
 */
static void processEsummary(xmlTextReaderPtr reader, string &title, string &title_abbr )
{
    xmlChar* name = NULL;
    xmlChar* value = NULL;
    
    name = xmlTextReaderName(reader);
    if( name == NULL)
        name = xmlStrdup(BAD_CAST "--");
    value = xmlTextReaderValue(reader);
    
    if( xmlTextReaderNodeType(reader) == XML_READER_TYPE_ELEMENT ){
        if( strcmp( "Item", ( char* )name ) == 0 ){
            xmlChar* attr_val = xmlTextReaderGetAttribute( reader, ( xmlChar* )"Name" );
            if( attr_val != NULL ){
                if( strcmp( "Title", ( char* )attr_val ) == 0 ){
                    if( xmlTextReaderRead(reader) == 1 ){
                        if( xmlTextReaderNodeType( reader ) == XML_READER_TYPE_TEXT ){
                            xmlChar* value = xmlTextReaderValue( reader );
                            title = ( char* )value;
                            xmlFree( value );
                            value = NULL;
                        }
                    }
                }
                else if( strcmp( "MedAbbr", ( char* )attr_val ) == 0 ){
                    if( xmlTextReaderRead(reader) == 1 ){
                        if( xmlTextReaderNodeType( reader ) == XML_READER_TYPE_TEXT ){
                            xmlChar* value = xmlTextReaderValue( reader );
                            title_abbr = ( char* )value;
                            xmlFree( value );
                            value = NULL;
                        }
                    }
                }
                xmlFree( attr_val );
            }
        }
    }
    xmlFree(name);
    
    if( value != NULL) xmlFree(value);
}

static void processAsinSearch(xmlTextReaderPtr reader, amazonbook_t* p )
{
    xmlChar* name = NULL;
    xmlChar* value = NULL;
    
    name = xmlTextReaderName(reader);
    if( name == NULL)
        name = xmlStrdup(BAD_CAST "--");
    value = xmlTextReaderValue(reader);
    
    if( xmlTextReaderNodeType(reader) == XML_READER_TYPE_ELEMENT ){
        if( strcmp( "Details", (char*)name ) == 0 ){
            // <Details url="...">
            xmlChar* val = xmlTextReaderGetAttribute(reader,(xmlChar*)"url");
            if( val != NULL ){
                p -> setURL( ( char* )val );
                xmlFree( val );
            }
        }else if( strcmp( "ReleaseDate", (char*)name ) == 0 ){
            // <ReleaseDate>21 June, 2003</ReleaseDate>
            // ޤǶڤꡢ2ܤsscanf(%d)롣
            xmlChar* val = getChildText( reader );
            if ( val != NULL ){
                char *q = strchr( (char *)val, ',' );
                if ( q != NULL ){
                    int year;
                    if ( sscanf( q+1, "%d", &year ) == 1 )
                        p -> setYearOfPublication( year );
                }
                xmlFree( val );
            }
        }else if( strcmp( "Author", (char*)name ) == 0 ){
            xmlChar* val = getChildText( reader );
            if ( val != NULL ){
                // Author\nڤɲä롣
                string s( p -> getAuthor() );
                if ( s.length() == 0 ){
                    p -> setAuthor( (char*)val );
                }
                else {
                   s = s + "\n" + (char *)val;
                   p -> setAuthor( s.c_str() );
                }
                xmlFree( val );
            }
        }else if( strcmp( "Asin", (char*)name ) == 0 ){
            xmlChar* val = getChildText( reader );
            p -> setISBN( ( char* )val );
            if( val != NULL ) xmlFree( val );
        }else if( strcmp( "ProductName", (char*)name ) == 0 ){
            xmlChar* val = getChildText( reader );
            p -> setTitle( ( char* )val );
            if( val != NULL ) xmlFree( val );
        }else if( strcmp( "Manufacturer", (char*)name ) == 0 ){
            xmlChar* val = getChildText( reader );
            p -> setPublisher( ( char* )val );
            if( val != NULL ) xmlFree( val );
        }
    }
    xmlFree(name);
    
    if( value != NULL) xmlFree(value);
}

static int streamAmazonBookFile(const char *filename, amazonbook_t* p)
{
    xmlTextReaderPtr reader;
    int ret;
    
    reader = xmlNewTextReaderFilename(filename);
    if( reader != NULL ){
        ret = xmlTextReaderRead(reader);
        while( ret == 1 ){
            processAsinSearch(reader, p);
            ret = xmlTextReaderRead(reader);
        }
        xmlFreeTextReader(reader);
        if( ret != 0 ){
            //printf("%s : failed to parse\n", filename);
        }
    }else{
        ret = -1;
        //printf("Unable to open %s\n", filename);
    }
    xmlErrorPtr err = xmlGetLastError();
    if( err != NULL ){
        setLastErrorString( err -> message );
    }
    return ret;
}

/**
 * @param url amazonASIN Searchη̤URL. 
 *            ex.:http://xml.amazon.com/onca/xml3?t=chararina-22&dev-t=0H8BRF5MB0Z590ZPWA82&type=lite&f=xml&AsinSearch=081297106X
 * @param amazonbook ̤񤭹amazonbook_tΥݥ󥿰
 */
result_t amazonComplete( const char *url, const amazonbook_t** amazonbook )
{
    result_t ret = RES_ERROR;
    *amazonbook = new amazonbook_t[1];
    if( streamAmazonBookFile( url, (amazonbook_t *)*amazonbook ) == 0 ) ret = RES_OK;
    return ret;
}

/** Binderƥޤʤtrue֤ : binder_idХǤʤưݾڤʤ
 * 
 */
bool isBinderContainsNonpublicItem( sessionid_t sid, itemid_t binder_id ){
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    SQLLEN len = 0;
    
    bool ret = false;
    string sql = 
      " select tbil.item_id, count(tx.index_id) "
      "  from "      + dbprefix + "_xoonips_binder_item_link as tbil "
      "  left join " + dbprefix + "_xoonips_index_item_link as txil on tbil.item_id=txil.item_id and txil.certify_state = "     + unsignedIntToString(index::CERTIFIED ) +
      "  left join " + dbprefix + "_xoonips_index           as tx   on txil.index_id=tx.index_id and tx.open_level = "  + unsignedIntToString(index::OL_PUBLIC) +
      "  where "
      "    tbil.binder_id = " + unsignedIntToString(binder_id) +
      "  group by tbil.item_id ";
    setLastErrorString( sql.c_str( ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLUINTEGER item_id = 0;
            SQLUINTEGER ct = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &item_id, 0, &len );
            SQLBindCol( hstmt, 2, SQL_C_ULONG, &ct, 0, &len );
            while( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                syslog_printf( "\nitem_id=%d, ct=%d", item_id, ct );
                if ( ct == 0 ){
                    ret = true;
                    break;
                }
            }
        }else{
            string s( "SQLExecDirect in isBinderContainsNonpublicItem ");
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += string( ", sql=" ) + string( sql );
            setLastErrorString( s.c_str( ) );
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else {
        string s( "SQLAllocHandle in isBinderContainsNonpublicItem ");
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
    }
    return ret;
}

/**
 * iids椫ƥIDФ. 
 * 
 * @see freeItemID
 * @param sid åID
 * @param iids item_id
 * @param iidssLen iidsǿ
 * @param publicIids ̤Υݥ󥿤񤭹
 * @param publicIidsLen ̤ο
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * 
 */
// դ˸ƥʳIDФ뤳Ȥ񤷤¸ߤʤitem_id򸡽Ф뤳Ȥ񤷤Τǡ
result_t extractPublicItemId(sessionid_t sid, const itemid_t* iids, int iidsLen, itemid_t **publicIids, int* publicIidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    result_t ret = RES_ERROR;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    userid_t uid;
    
    ret = sessionID2UID( sid, &uid );
    if( ret != RES_OK ) return ret;
    
    string iids_str = getCsvStr( iids, iidsLen );
    
    string sql = 
      " select ti.item_id, count(tx.index_id) "
      "  from      " + dbprefix + "_xoonips_item_basic      as ti   "
      "  left join " + dbprefix + "_xoonips_index_item_link as txil on ti.item_id=txil.item_id and txil.certify_state = " + unsignedIntToString(index::CERTIFIED ) +
      "  left join " + dbprefix + "_xoonips_index           as tx   on txil.index_id=tx.index_id and tx.open_level = "  + unsignedIntToString(index::OL_PUBLIC) +
      "  where "
      "    ti.item_id in ( 0 " + iids_str + ")"
      "  group by ti.item_id ";
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLLEN len = 0;
            SQLUINTEGER itemid = 0;
            SQLUINTEGER ct = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &itemid, 0, &len );
            SQLBindCol( hstmt, 2, SQL_C_ULONG, &ct, 0, &len );
            
            *publicIids = new itemid_t[ iidsLen ];
            *publicIidsLen = 0;
            for( int i = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS; i++ ){
                if ( ct != 0 )
                    (*publicIids)[ (*publicIidsLen)++ ] = itemid;
            }
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in extractPublicItemId" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += string( ", sql=" ) + string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in extractPublicItemId" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * iids椫BinderʳIDФ. 
 * 
 * @see freeItemID
 * @param sid åID
 * @param iids item_id
 * @param iidssLen iidsǿ
 * @param nonbinderIids ̤Υݥ󥿤񤭹
 * @param nonbinderIidssLen ̤ο
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * 
 */
result_t extractNonbinderItemId(sessionid_t sid, const itemid_t* iids, int iidsLen, itemid_t **nonbinderIids, int* nonbinderIidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    result_t ret = RES_ERROR;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    userid_t uid;
    
    ret = sessionID2UID( sid, &uid );
    if( ret != RES_OK ) return ret;
    
    // ʸ ',' . implode( ',', iids ) 
    char *buf = new char[(sizeof(int)*3+1)*iidsLen+1];
    buf[0] = '\0';
    char *p = buf;
    for ( int i = 0; i < iidsLen; i++ ){
        int len = sprintf( p, ",%u", iids[i] );
        p += len;
    }
    string iids_str(buf);
    delete[] buf;
    
    
    string sql = 
      " select ti.item_id "
      "  from      " + dbprefix + "_xoonips_item_basic      as ti   "
      "  where "
      "    ti.item_id in ( 0 " + iids_str + ") and ti.item_type_id <> " + unsignedIntToString(item::ITID_BINDER);
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLLEN len = 0;
            SQLUINTEGER itemid = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &itemid, 0, &len );
            
            *nonbinderIids = new itemid_t[ iidsLen ];
            *nonbinderIidsLen = 0;
            for( int i = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS; i++ ){
                (*nonbinderIids)[ (*nonbinderIidsLen)++ ] = itemid;
            }
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in extractNonbinderItemId" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += string( ", sql=" ) + string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in extractNonbinderItemId" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}




/**
 * 
 * ǧԤ֤ΥƥΤǧ¤Τ륢ƥIDϿ襤ǥåIDڥǼޤ.
 * ƥiids[i]xids[i]ؤϿξǧԤ֤ˤ뤳Ȥ֤ޤ
 * 
 * @param sid åID
 * @param xids ǧԤƥϿ륤ǥåID
 * @param iids ǧԤƥID
 * @param len iids,xids˳Ǽ줿Ŀ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
result_t getUncertifiedLink( sessionid_t sid, const itemid_t** xids, const itemid_t** iids, int* len )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    int i = 0;
    SQLHANDLE hstmt = NULL;
    result_t ret = RES_ERROR;
    itemid_t* dst_iids = 0;
    indexid_t* dst_xids = 0;
    string sql;
    SQLRETURN sqlcode;
    SQLLEN count = 0;
    userid_t sess_uid;

    bool is_moderator = false;
    
    if( ( ret = sessionID2UID( sid, &sess_uid ) ) != RES_OK ) return ret;
    
    sql = "SELECT DISTINCT tlink.index_id, tlink.item_id";
    sql += " FROM " + dbprefix + "_xoonips_index_item_link AS tlink";
    sql += " LEFT JOIN " + dbprefix + "_xoonips_index AS tx ON tlink.index_id = tx.index_id";
    sql += " LEFT JOIN " + dbprefix + "_xoonips_item_basic AS ti ON tlink.item_id = ti.item_id";

    is_moderator = isModerator( sid, sess_uid );
    if( ! is_moderator ) {
        sql += " LEFT JOIN " + dbprefix + "_xoonips_groups_users_link AS tgulink ON tgulink.gid = tx.gid";
    }
    sql += " WHERE open_level<=" + unsignedIntToString( index::OL_GROUP_ONLY );
    sql += " AND certify_state=" + unsignedIntToString( index::CERTIFY_REQUIRED );
    sql += " AND item_type_id !=" + unsignedIntToString( item::ITID_INDEX );

    if( ! is_moderator ) {
        sql += " AND is_admin=1 AND tgulink.uid=" + unsignedIntToString( sess_uid );
    }

    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );

    if( countResultRows( sql.c_str(), &count ) == RES_OK ){
        dst_xids = new indexid_t[ count ];
        *xids = dst_xids;
        dst_iids = new itemid_t[ count ];
        *iids = dst_iids;
    }else{
        return RES_ERROR;
    }
    
    *len = 0;
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            indexid_t xid = 0;
            SQLLEN cbXid = 0;
            itemid_t iid = 0;
            SQLLEN cbIid = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &xid, 0, &cbXid );
            SQLBindCol( hstmt, 2, SQL_C_ULONG, &iid, 0, &cbIid );
            for( i = 0 ; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ; i++ ){
                syslog_printf( "\nxid=%d, iid=%d", xid, iid );
                if ( xid == item::IID_BINDERS ){
                    // Binderƥޤʤ顤åפ롥
                    if ( isBinderContainsNonpublicItem( sid, iid ) )
                        continue;
                }
                
                dst_xids[ *len ] = xid;
                dst_iids[ *len ] = iid;
                ( *len )++;
            }
            ret = RES_OK;
        }else {
            string s( "SQLExecDirect in getUncertifiedLink " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getUncertifiedLink" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

result_t getItemTypes( const itemtype_t** types, int* len )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    
    int i = 0;
    SQLHANDLE hstmt = NULL;
    result_t ret = RES_ERROR;
    itemtype_t* dst= 0;
    string sql;
    SQLRETURN sqlcode;
    SQLLEN count = 0;
    
	sql = "SELECT item_type_id, name, mid, display_name, viewphp ";
	sql += " FROM " + dbprefix + "_xoonips_item_type order by item_type_id";
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    if( countResultRows( sql.c_str(), &count ) == RES_OK ){
        dst = new itemtype_t[ count ];
        *types = dst;
    }else{
        return RES_ERROR;
    }
    
    *len = 0;
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            itemtypeid_t itid = 0;
            SQLINTEGER mid = 0;
            SQLCHAR name[XNP_ITEMTYPE_NAME_LEN+1];
            SQLCHAR display_name[XNP_ITEMTYPE_DISPLAY_NAME_LEN+1];
            SQLCHAR viewphp[XNP_ITEMTYPE_VIEWPHP_LEN+1];
            SQLLEN cbItid = 0, cbMid = 0, cbName=SQL_NTS, cbDisplayName=SQL_NTS, cbViewphp=SQL_NTS;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &itid, 0, &cbItid );
            SQLBindCol( hstmt, 2, SQL_C_CHAR , &name, XNP_ITEMTYPE_NAME_LEN+1, &cbName );
            SQLBindCol( hstmt, 3, SQL_C_ULONG, &mid, 0, &cbMid );
            SQLBindCol( hstmt, 4, SQL_C_CHAR , &display_name, XNP_ITEMTYPE_DISPLAY_NAME_LEN+1, &cbDisplayName );
            SQLBindCol( hstmt, 5, SQL_C_CHAR , &viewphp, XNP_ITEMTYPE_VIEWPHP_LEN+1, &cbViewphp );
            for( i = 0 ; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ; i++ ){
                if ( cbName        == SQL_NULL_DATA ) name[0] = '\0';
                if ( cbDisplayName == SQL_NULL_DATA ) display_name[0] = '\0';
                if ( cbViewphp     == SQL_NULL_DATA ) viewphp[0] = '\0';
                syslog_printf( "\nitid=%d, mid=%d, name='%s', display_name='%s'", itid, mid, name, display_name );
                dst[ i ].setItemTypeID( itid );
                dst[ i ].setModuleID( itid );
                dst[ i ].setName( ( char* )name );
                dst[ i ].setDisplayName( ( char* )display_name );
                dst[ i ].setViewphp( ( char* )viewphp );
                ( *len )++;
            }
            ret = RES_OK;
        }else {
            string s( "SQLExecDirect in getItemType " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += ", sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getItemType" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}


result_t getIndexIDByItemID( sessionid_t sid, itemid_t itemid, const indexid_t** xids, int* xidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !getItemPermission( sid, itemid, item::OP_READ ) ) return RES_NO_READ_ACCESS_RIGHT;
    
    result_t ret = RES_ERROR;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    SQLLEN count = 0;
    string sql;
    indexid_t xid = 0;
    SQLLEN len = 0;
    
    sql = "SELECT index_id FROM " +  dbprefix + "_xoonips_index_item_link"
        + " WHERE item_id=" + unsignedIntToString( itemid );
    if( countResultRows( sql.c_str(), &count ) == RES_OK ){
        indexid_t* xids_ = new indexid_t[ count ];
        if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
            if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
                SQLBindCol( hstmt, 1, SQL_C_ULONG, &xid, 0, &len );
                for( *xidsLen=0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS && *xidsLen < count ; (*xidsLen)++ ){
                    *( xids_ + *xidsLen ) = xid;
                }
                *xids = xids_;
                ret = RES_OK;
            }else{
                string s( "SQLExecDirect in getIndexIDByItemID ");
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                s += string( ", sql=" ) + string( sql );
                setLastErrorString( s.c_str( ) );
                ret = RES_ERROR;
            }
        }else {
            string s( "SQLAllocHandle in getIndexIDByItemID ");
            s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
            setLastErrorString( s.c_str( ) );
            ret = RES_ERROR;
        }
    }
    return ret;
}

/**
 * 
 * 桼κƥǡ̸Ƥ륢ƥIDޤ.
 * ̥桼ϼʬʳΥƥǤʤ
 * 
 * @param sid åID
 * @param uid оݥ桼ID
 * @param iids Ͽ줿ƥID
 * @param iidsLen iids˳Ǽ줿Ŀ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
result_t getOwnPublicItemID( sessionid_t sid, userid_t uid, const itemid_t** iids, int* iidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    
    SQLHANDLE hstmt = NULL, hstmt2 = NULL;
    result_t ret = RES_ERROR;
    itemid_t* dst = 0;
    string sql;
    SQLRETURN sqlcode;
    SQLLEN count = 0;
    userid_t sess_uid;
    
    if( ( ret = sessionID2UID( sid, &sess_uid ) ) != RES_OK ) return ret;
    if( sess_uid != uid && !isModeratorBySession( sid ) )
        return RES_NO_READ_ACCESS_RIGHT;//no permissions to access these items
    
    sql = "SELECT DISTINCT tlink.item_id";
    sql += " FROM " + dbprefix + "_xoonips_index_item_link AS tlink";
    sql += " LEFT JOIN " + dbprefix + "_xoonips_index AS tx ON tlink.index_id=tx.index_id";
    sql += " LEFT JOIN " + dbprefix + "_xoonips_item_basic AS ti ON tlink.item_id=ti.item_id";
	sql += " LEFT JOIN " + dbprefix + "_xoonips_groups_users_link AS tgulink ON ( tgulink.gid = tx.gid AND tx.open_level =" + unsignedIntToString( index::OL_GROUP_ONLY );
    sql += ") OR tx.open_level=" + unsignedIntToString( index::OL_PUBLIC );
    sql += " WHERE open_level=" + unsignedIntToString( index::OL_PUBLIC );
    sql += " AND certify_state=" + unsignedIntToString( index::CERTIFIED );
    sql += " AND item_type_id !=" + unsignedIntToString( item::ITID_INDEX );
    sql += " AND ( ti.uid=" + unsignedIntToString( sess_uid );
    sql +=       " OR is_admin=1 AND tgulink.uid=" + unsignedIntToString( sess_uid );
    sql += ")";
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    if( countResultRows( sql.c_str(), &count ) == RES_OK ){
        dst = new itemid_t[ count ];
        *iids = dst;
    }else{
        return RES_ERROR;
    }
    
    *iidsLen = 0;
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            itemid_t iid = 0;
            SQLLEN cbIid = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &iid, 0, &cbIid );
            
            *iidsLen = 0;
            for( int i = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS && i < count ; i++ ){
                dst[ i ] = iid;
                (*iidsLen)++;
            }
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in getOwnPublicItemID " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt2, sqlcode );
            s += "sql=";
            s += string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getOwnPublicItemID" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    
    return ret;
}

/**
 * ReadǽǥåΡľΥƥ롥
 * 
 * @param sid åID
 * @param xids index_idݥ
 * @param xidsLen xidsĹݥ
 * @param counts xids[]ľΥƥݥ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 */
result_t getItemCountGroupByIndex( sessionid_t sid, indexid_t **xids, int *xidsLen, int **counts ){
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    
    result_t ret;
    userid_t uid;
    ret = sessionID2UID( sid, &uid );
    if( ret != RES_OK ) return ret;
    
    string indexItemLinkTable = dbprefix + "_xoonips_index_item_link";
    string indexTable = dbprefix + "_xoonips_index";
    string itemTable = dbprefix + "_xoonips_item_basic";
    string groupsUsersLinkTable = dbprefix + "_xoonips_groups_users_link";
    string sql = "SELECT COUNT(*) FROM " + indexTable;
    unsigned int maxXIDsLen;
    ret = queryGetUnsignedInt( "getItemCountGroupByIndex", sql, &maxXIDsLen );
    if ( RES_OK != ret )
        return ret;
    
    *xids = new indexid_t [maxXIDsLen];
    *counts = new int [maxXIDsLen];
    
    // todo: item_type_idΥå򳰤
    if ( isModerator(sid, uid) ) {
        sql = "SELECT index_id, COUNT(*) from " + indexItemLinkTable + " AS tl " 
            " LEFT JOIN " + itemTable + " AS ti on ti.item_id=tl.item_id "
            " WHERE ti.item_type_id <> " +  unsignedIntToString( item::ITID_INDEX ) +
            " GROUP BY index_id";
    }
    else {
       string uidString = unsignedIntToString( uid );
       string certified = " tl.certify_state=" + unsignedIntToString( index::CERTIFIED );
       sql = "SELECT  tx.index_id, COUNT(tl.index_id) "
            "  FROM " + indexTable + " AS tx"
            "  LEFT JOIN " + groupsUsersLinkTable + " AS tgl ON tx.gid=tgl.gid AND tgl.uid=" + uidString +
            "  LEFT JOIN " + indexItemLinkTable + " AS tl ON tx.index_id=tl.index_id "
            "  LEFT JOIN " + itemTable + " AS ti ON ti.item_id=tl.item_id "
            "  WHERE "
            "   (tx.open_level=" + unsignedIntToString( index::OL_PUBLIC ) + " AND " +
                     "(" + certified + " OR ti.uid=" + uidString + " )" + 
            " OR tx.open_level=" + unsignedIntToString( index::OL_GROUP_ONLY ) + " AND tgl.uid IS NOT NULL AND " +
                     "(" + certified + " OR ti.uid=" + uidString + " OR tgl.is_admin=1 )" + 
            " OR tx.open_level=" + unsignedIntToString( index::OL_PRIVATE ) + " AND tx.uid=" + uidString +
            "  ) AND ti.item_type_id <> " +  unsignedIntToString( item::ITID_INDEX ) +
            "  GROUP BY tx.index_id";
    }
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLUINTEGER xid = 0;
            SQLUINTEGER count = 0;
            SQLLEN xidSQLLen = 0;
            SQLLEN countSQLLen = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &xid, 0, &xidSQLLen );
            SQLBindCol( hstmt, 2, SQL_C_ULONG, &count, 0, &countSQLLen );
            for( *xidsLen=0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS && *xidsLen < (int)maxXIDsLen ; (*xidsLen)++ ){
                *( *xids + *xidsLen ) = xid;
                *( *counts + *xidsLen ) = count;
            }
        }
        else {
            string s( "SQLExecDirect in getItemCountGroupByIndex " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += "sql=";
            s += sql;
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }
    else {
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getItemCountGroupByIndex " );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    
    if ( ret != RES_OK ){
        delete[] *xids;
        delete[] *counts;
    }
    return ret;
}

extern "C" {int zip_main(int, char**);}
/**
 * 
 * zipեޤ
 * 
 * @param zippath zipեΥѥ
 * @param files zipե줿ե̾
 * @param filesLen files˻ꤷեο
 * @return 0 
 * @return 0ʳ 
 * 
 */
result_t zipCreate( char* zippath, char** files, int filesLen )
{
    char** argv = new char*[filesLen+3];
    argv[ 0 ] = NULL;
    argv[ 1 ] = "-o";
    argv[ 2 ] = zippath;
    for( int i = 0; i < filesLen; i++ ){
        argv[ i + 3 ] = files[ i ];
    }
	if( !zip_main( filesLen + 3, argv ) ){
        delete[] argv;
        return RES_OK;
    }
    delete[] argv;
    return RES_ERROR;
}
result_t insertEvent(sessionid_t sid, event_t *ev )
{
    eventtypeid_t etid = ev->getEventTypeID();
    if ( etid < 1 || event::ETID_MAX < etid ){
        setLastErrorString( "invalid event_type_id in insertEvent" );
        return RES_ERROR;
    }
    
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    result_t ret = RES_ERROR;
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        string sql = "insert into " + dbprefix + "_xoonips_event_log "
         " ( event_type_id, timestamp, exec_uid, index_id, item_id, file_id, uid, gid, remote_host, search_keyword, additional_info ) "
         " values ( " 
                                    + unsignedIntToString(ev->getEventTypeID()) + "," + 
           ( ev->isValidTimestamp() ? unsignedIntToString(ev->getTimestamp  ()) : "NULL" ) + "," +
           ( ev->isValidExecUID  () ? unsignedIntToString(ev->getExecUID    ()) : "NULL" ) + "," +
           ( ev->isValidIndexID  () ? unsignedIntToString(ev->getIndexID    ()) : "NULL" ) + "," +
           ( ev->isValidItemID   () ? unsignedIntToString(ev->getItemID     ()) : "NULL" ) + "," +
           ( ev->isValidFileID   () ? unsignedIntToString(ev->getFileID     ()) : "NULL" ) + "," +
           ( ev->isValidUID      () ? unsignedIntToString(ev->getUID        ()) : "NULL" ) + "," +
           ( ev->isValidGID      () ? unsignedIntToString(ev->getGID        ()) : "NULL" ) + "," +
         " ?,?,? )";
        sqlcode = SQLPrepare(hstmt, (SQLCHAR*)sql.c_str(), SQL_NTS);
        if ( sqlcode == SQL_SUCCESS ){
            SQLLEN cbRemoteHost = SQL_NTS, cbSearchKeyword = SQL_NTS, cbAdditionalInfo = SQL_NTS;
            if ( !ev->isValidRemoteHost    () ) cbRemoteHost    = SQL_NULL_DATA;
            if ( !ev->isValidSearchKeyword () ) cbSearchKeyword = SQL_NULL_DATA;
            if ( !ev->isValidAdditionalInfo() ) cbAdditionalInfo= SQL_NULL_DATA;
            SQLBindParameter(hstmt,  1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, strlen(ev->getRemoteHost    ()), 0, (SQLCHAR *)ev->getRemoteHost    (), 0, &cbRemoteHost    );
            SQLBindParameter(hstmt,  2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, strlen(ev->getSearchKeyword ()), 0, (SQLCHAR *)ev->getSearchKeyword (), 0, &cbSearchKeyword );
            SQLBindParameter(hstmt,  3, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, strlen(ev->getAdditionalInfo()), 0, (SQLCHAR *)ev->getAdditionalInfo(), 0, &cbAdditionalInfo);
            
            sqlcode = SQLExecute( hstmt );
            if( sqlcode == SQL_SUCCESS ){
                ret = RES_OK;
            }else{
                string s( "SQLExecute in insertEvent " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else{
            setLastErrorString( "SQLPrepare in insertEvent" );
            ret = RES_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }
    else {
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in insertEvent " );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

result_t getEvents(sessionid_t sid, event_t** events, int* eventsLen, time_t startTime, time_t endTime )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !isModeratorBySession( sid ) ) return RES_NO_READ_ACCESS_RIGHT;
    
    // time condition
    string condition = " where ";
    if ( startTime != 0 ) condition += unsignedIntToString(startTime) + " <= timestamp and ";
    if ( endTime != 0 )   condition += " timestamp < " + unsignedIntToString(endTime) + " and ";
    condition += "1";
    condition += " order by timestamp asc";
    
    return getEvents(sid, events, eventsLen, condition );
}

bool isAdmin( userid_t uid )
{
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        string sql = "SELECT count(*)>0 FROM " + dbprefix + "_groups, " + dbprefix + "_groups_users_link WHERE " + dbprefix + "_groups.groupid = " + dbprefix + "_groups_users_link.groupid and group_type='Admin' and " + dbprefix + "_groups_users_link.uid=" + unsignedIntToString(uid);
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLUINTEGER isadmin = 0;
            SQLLEN isadminSQLLen = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &isadmin, 0, &isadminSQLLen );
            if( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
                if( isadmin == 1 ) return true;
            }
            SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
            return false;
        }
        return false;
    }
    return false;
}

/**
 * 
 * ǿΥ٥(ƥྵǧ롼׺Τߡˤ
 * 
 * @param sid åID
 * @param events ٥ȾΥɥ쥹ݥ
 * @param eventsLen events˵Ͽ٥Ⱦο
 * @param max events˵Ͽ祤٥ȿ
 * 
 * @return RES_OK 
 * @return RES_NO_SUCH_SESSION ʥå
 * @return RES_NO_READ_ACCESS_RIGHT RSSΥ̵(롼״̤)
 * @return ʳ ¾μ
 * 
 */
result_t getEventsForRSS(sessionid_t sid, event_t** events, int* eventsLen, int max )
{
    const session_t* session;
    userid_t sess_uid;
    
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( getSession( sid, &session ) == RES_OK ){
        sess_uid = session ->  getUID( );
        freeSession( session );
    }
    if( isAdmin( sess_uid ) );
    else if( isModeratorBySession( sid ) );
    else{
        result_t ret = RES_ERROR;
        criteria_t c;
        groupid_t *gids;
        int gidsLen;
        const session_t* session;
        userid_t uid;
        
        //retrieve uid from session
        ret = getSession( sid, &session );
        if( ret != RES_OK ) return ret;
        uid = session ->  getUID( );
        freeSession( session );
        
        //retrieve all group id
        c.clearAll();
        ret = dumpGids( sid, &c, &gids, &gidsLen );
        if( ret != RES_OK ) return ret;
        
        //is uid a group admin ?
        int i;
        for( i = 0 ; i < gidsLen; i++ ){
            if( isGroupAdmin( sid, gids[ i ], uid ) ) break;
        }
        freeGID( gids );
        if( i >= gidsLen )
            return RES_NO_READ_ACCESS_RIGHT;// uid is not a group admin
    }
    
    //retrieve events
    string condition = " where event_type_id in ( " ;
    condition += unsignedIntToString(event_t::ETID_CERTIFY_ITEM);
    condition += ", " + unsignedIntToString(event_t::ETID_INSERT_GROUP) + " )";
    condition += " order by timestamp desc";
    condition += " limit " + unsignedIntToString(max);
    
    return getEvents(sid, events, eventsLen, condition );
}

static result_t getEvents(sessionid_t sid, event_t** events, int* eventsLen, string condition )
{
    result_t ret = RES_ERROR;
    
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;    
    
    // allocate events[]
    string sql = "select count(*) from " + dbprefix + "_xoonips_event_log " + condition;
    unsigned int len;
    ret = queryGetUnsignedInt( "getEvents", sql, &len );
    if ( ret != RES_OK )
        return ret;
    
    if ( len == 0 ){
        *events = new event[1];
        *eventsLen = 0;
        return RES_OK;
    }
    *events = new event[len];
    *eventsLen = len;
    
    // get
    sql = "select event_id, event_type_id, timestamp, exec_uid, index_id, item_id, "
        " file_id, uid, gid, remote_host, search_keyword, additional_info from " + dbprefix + "_xoonips_event_log " + condition;
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            eventid_t     eventID      = 0; SQLLEN cbEventID      = 0;
            eventtypeid_t eventTypeID  = 0; SQLLEN cbEventTypeID  = 0;
            time_t        timestamp    = 0; SQLLEN cbTimestamp    = 0;
            userid_t      execUID      = 0; SQLLEN cbExecUID      = 0;
            indexid_t     indexID      = 0; SQLLEN cbIndexID      = 0;
            itemid_t      itemID       = 0; SQLLEN cbItemID       = 0;
            fileid_t      fileID       = 0; SQLLEN cbFileID       = 0;
            userid_t      uid          = 0; SQLLEN cbUid          = 0;
            groupid_t     gid          = 0; SQLLEN cbGid          = 0;
            
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &eventID      , 0, &cbEventID       );
            SQLBindCol( hstmt, 2, SQL_C_ULONG, &eventTypeID  , 0, &cbEventTypeID   );
            SQLBindCol( hstmt, 3, SQL_C_ULONG, &timestamp    , 0, &cbTimestamp     );
            SQLBindCol( hstmt, 4, SQL_C_ULONG, &execUID      , 0, &cbExecUID       );
            SQLBindCol( hstmt, 5, SQL_C_ULONG, &indexID      , 0, &cbIndexID       );
            SQLBindCol( hstmt, 6, SQL_C_ULONG, &itemID       , 0, &cbItemID        );
            SQLBindCol( hstmt, 7, SQL_C_ULONG, &fileID       , 0, &cbFileID        );
            SQLBindCol( hstmt, 8, SQL_C_ULONG, &uid          , 0, &cbUid           );
            SQLBindCol( hstmt, 9, SQL_C_ULONG, &gid          , 0, &cbGid           );
            
            for( *eventsLen = 0; ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS && *eventsLen < (int)len ; (*eventsLen)++ ){
                event *p = *events + *eventsLen;
                p->setEventID       ( (eventid_t    )eventID      );
                p->setEventTypeID   ( (eventtypeid_t)eventTypeID  );
                p->setTimestamp     ( (time_t       )timestamp    );
                p->setExecUID       ( (userid_t     )execUID      );
                p->setIndexID       ( (indexid_t    )indexID      );
                p->setItemID        ( (itemid_t     )itemID       );
                p->setFileID        ( (fileid_t     )fileID       );
                p->setUID           ( (userid_t     )uid          );
                p->setGID           ( (groupid_t    )gid          );
                p->setRemoteHost    ( getResultCol( hstmt, 10 ).c_str() );
                p->setSearchKeyword ( getResultCol( hstmt, 11, SQL_C_BINARY ).c_str() );
                p->setAdditionalInfo( getResultCol( hstmt, 12, SQL_C_BINARY ).c_str() );
            }
            ret = RES_OK;
        }else{
            string s( "SQLExecDirect in getEvents" );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            s += string( ", sql=" ) + string( sql );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getEvents" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

static result_t insertMetadataEvent( metadataevent_t me, itemid_t iid )
{
    string sql;
    
    if ( me == ME_CREATED ){
        sql = "replace " + dbprefix + "_xoonips_item_status "
         " ( item_id, created_timestamp, modified_timestamp, deleted_timestamp, is_deleted ) values "
         " ( " + unsignedIntToString(iid) + ", unix_timestamp(now()), NULL, NULL, 0 )";
    }
    else if ( me == ME_MODIFIED ){
        sql = "update " + dbprefix + "_xoonips_item_status "
         " set modified_timestamp=unix_timestamp(now()), is_deleted=0 where item_id=" + unsignedIntToString(iid);
    }
    else if ( me == ME_DELETED ){
        sql = "update " + dbprefix + "_xoonips_item_status "
         " set deleted_timestamp=unix_timestamp(now()), is_deleted=1 where item_id=" + unsignedIntToString(iid);
    }
    else {
        return RES_ERROR;
    }
    
    return querySimple( "insertMetadataEvent", sql );
}

result_t getMetadataEvent( itemid_t iid, itemstatus_t *status )
{
    result_t ret = RES_ERROR;
    
    // allocate events[]
    string sql = "select created_timestamp, modified_timestamp, deleted_timestamp, is_deleted from " 
     + dbprefix + "_xoonips_item_status where item_id=" + unsignedIntToString(iid);
    sqlexec_t s( "getMetadataEvent", sql, &ret );
    if ( s.getSqlcode() == SQL_SUCCESS ){
        SQLUINTEGER created, modified, deleted, isDeleted = 0;
        SQLLEN cbCreated = 0, cbModified = 0, cbDeleted = 0, cbIsDeleted = 0;
        SQLBindCol( s.getHstmt(), 1, SQL_C_ULONG, &created  , 0, &cbCreated   );
        SQLBindCol( s.getHstmt(), 2, SQL_C_ULONG, &modified , 0, &cbModified  );
        SQLBindCol( s.getHstmt(), 3, SQL_C_ULONG, &deleted  , 0, &cbDeleted   );
        SQLBindCol( s.getHstmt(), 4, SQL_C_ULONG, &isDeleted, 0, &cbIsDeleted );
        
        if ( SQLFetch( s.getHstmt() ) == SQL_SUCCESS ){
            status->createdTimestamp  = created;
            status->modifiedTimestamp = modified;
            status->deletedTimestamp  = deleted;
            status->isDeleted = isDeleted;
            ret = RES_OK;
        }
        else {
            ret = RES_NO_SUCH_ITEM;
        }
    }
    return ret;
}

/** ŬڤinsertMeatadataEventԤ
 * repository         item
 * is_deleted==0  &&  public    : isCreate ? ME_CREATED : ME_MODIFIED;
 * is_deleted==0  &&  nonpublic : ME_DELETED
 * is_deleted!=0  &&  public    : ME_CREATED
 * is_deleted!=0  &&  nonpubic  : -
 * 
 */
static result_t insertMetadataEventAuto( itemid_t iid, bool isCreate )
{
    itemstatus_t is;
    result_t res = getMetadataEvent( iid, &is );
    if ( res != RES_OK ){
        if ( res == RES_NO_SUCH_ITEM )
            is.isDeleted = 1;
        else
            return res;
    }
    
    bool isPublic = getItemPermission( session::SID_GUEST, iid, item::OP_READ );
    
    metadataevent_t me;
    if ( is.isDeleted == 0 ){
        if ( isPublic )
            me = isCreate ? ME_CREATED : ME_MODIFIED;
        else
            me = ME_DELETED;
    }
    else {
        if ( isPublic )
            me = ME_CREATED;
        else
            return RES_OK;
    }
    
    return insertMetadataEvent( me, iid );
}




result_t updateItemStatus()
{
    result_t ret = RES_ERROR;
    
    if ( isGuestEnabled() ){
        {
            // ƥबѤߤǡitem_statusޤ¸ߤΤΤ
            //  select distinct txil.item_id, tis.is_deleted from x_xoonips_index as tx,x_xoonips_index_item_link as txil left join x_xoonips_item_status as tis on txil.item_id = tis.item_id  where  tx.index_id=txil.index_id and  txil.certify_state = 2 and  tx.open_level = 1;
            string sql = "select distinct txil.item_id, tis.is_deleted "
              " from "      + dbprefix + "_xoonips_index as tx, "
                            + dbprefix + "_xoonips_index_item_link as txil "
              " left join " + dbprefix + "_xoonips_item_status as tis on txil.item_id = tis.item_id "
              " where  tx.index_id=txil.index_id "
                " and  txil.certify_state = " + unsignedIntToString( index::CERTIFIED ) + 
                " and  tx.open_level = " + unsignedIntToString( index::OL_PUBLIC );
            sqlexec_t s( "updateItemStatus", sql, &ret );
            if ( s.getSqlcode() == SQL_SUCCESS ){
                SQLUINTEGER iid = 0, isDeleted = 0;
                SQLLEN cbIID = 0, cbIsDeleted = 0;
                SQLBindCol( s.getHstmt(), 1, SQL_C_ULONG, &iid       , 0, &cbIID       );
                SQLBindCol( s.getHstmt(), 2, SQL_C_ULONG, &isDeleted , 0, &cbIsDeleted );
                
                ret = RES_OK;
                while ( SQLFetch( s.getHstmt() ) == SQL_SUCCESS ){
                    string sql;
                    if ( cbIsDeleted == SQL_NULL_DATA )
                        sql = "insert into " + dbprefix + "_xoonips_item_status "
                          "( item_id, created_timestamp, is_deleted ) values "
                          "( " + unsignedIntToString(iid) + ", unix_timestamp(now()), 0 )";
                    else
                        sql = "update "+ dbprefix + "_xoonips_item_status "
                          " set created_timestamp=unix_timestamp(now()), is_deleted=0 "
                          " where item_id=" + unsignedIntToString(iid);
                    ret = querySimple( "updateItemStatus", sql );
                    if ( ret ) return ret;
                }
            }
            else return ret;
        }
        {
            // ƥबǡitem_status.is_deleted=0ΤΤ
            // select tis.item_id, count(tx.index_id) as public_count from x_xoonips_item_status as tis  left join x_xoonips_index_item_link as tl on tl.item_id = tis.item_id and certify_state = 2 left join x_xoonips_index           as tx on tx.index_id =tl.index_id and tx.open_level = 1 where is_deleted=0 group by tis.item_id having pubilc_count=0 ;
            string sql = "select tis.item_id, count(tx.index_id) as public_count "
              " from "      + dbprefix + "_xoonips_item_status as tis  "
              " left join " + dbprefix + "_xoonips_index_item_link as tl on tl.item_id = tis.item_id and certify_state = " + unsignedIntToString(index::CERTIFIED) +
              " left join " + dbprefix + "_xoonips_index           as tx on tx.index_id =tl.index_id and tx.open_level = " + unsignedIntToString(index::OL_PUBLIC) + 
              " where is_deleted=0 group by tis.item_id having public_count=0 ";
            sqlexec_t s( "updateItemStatus", sql, &ret );
            if ( s.getSqlcode() == SQL_SUCCESS ){
                SQLUINTEGER iid = 0;
                SQLLEN cbIID = 0;
                SQLBindCol( s.getHstmt(), 1, SQL_C_ULONG, &iid       , 0, &cbIID       );
                
                ret = RES_OK;
                while ( SQLFetch( s.getHstmt() ) == SQL_SUCCESS ){
                    string sql;
                    sql = "update " + dbprefix + "_xoonips_item_status "
                      " set is_deleted=1, deleted_timestamp=unix_timestamp(now()) "
                      " where item_id=" + unsignedIntToString(iid);
                    ret = querySimple( "updateItemStatus", sql );
                    if ( ret ) return ret;
                }
            }
            else return ret;
        }
    }
    else {
        string sql = "delete from " + dbprefix + "_xoonips_item_status";
        ret = querySimple( "updateItemStatus", sql );
    }
    return ret;
}

/** item_statusơ֥򥯥ꥢupdateItemStatusԤ */
result_t refreshItemStatus()
{
    string sql = "delete from " + dbprefix + "_xoonips_item_status";
    result_t ret = querySimple( "refreshItemStatus", sql );
    if ( ret ) return ret;
    return updateItemStatus();
}

/** selective harvesting
 * @param from, until  ϰ  from=0ʤǤŤ狼 until=0ʤ鸽ߤޤ
 * @param startIID     startIID<=item_idǤ褦item_idΤߤ
 * @param limit        ֤item_idθĿξ
 * @param iids         item_id֤  item_idξΤ
 * @param iidsLen      iidsĹ
 */
result_t selectiveHarvesting( time_t from, time_t until, int startIID, int limit, char ***iids, int *iidsLen )
{
    result_t ret = RES_ERROR;
    if ( limit < 0 ) return RES_ERROR;
    
    char* nijc_code = 0;
    if( getConfigValue( XNP_CONFIG_REPOSITORY_NIJC_CODE, &nijc_code ) != RES_OK ){
        return RES_ERROR;
    }
    
    string sql = "select stat.item_id, item_type_id from " + dbprefix + "_xoonips_item_status as stat, "
        + dbprefix + "_xoonips_item_basic as basic where basic.item_id=stat.item_id and ";
    if ( from  != 0 )      sql += unsignedIntToString(from) + " <= unix_timestamp(timestamp) and ";
    if ( until != 0 )      sql += " unix_timestamp(timestamp) <= " + unsignedIntToString(until) + " and ";
    sql += 
        " stat.item_id >= " + unsignedIntToString(startIID) + 
        " order by stat.item_id " +
        " limit " + unsignedIntToString(limit);
    sqlexec_t s( "updateItemStatus", sql, &ret );
    //setLastErrorString( "selectiveHarvesting..." );
    //setLastErrorString( sql.c_str( ) );
    if ( s.getSqlcode() == SQL_SUCCESS ){
        SQLUINTEGER iid = 0;
        SQLLEN cbIID = 0;
        SQLUINTEGER itid = 0;
        SQLLEN cbITID = 0;
        SQLBindCol( s.getHstmt(), 1, SQL_C_ULONG, &iid       , 0, &cbIID       );
        SQLBindCol( s.getHstmt(), 2, SQL_C_ULONG, &itid      , 0, &cbITID       );
        
        *iids = new char*[limit];
        for ( *iidsLen = 0; *iidsLen < limit && SQLFetch( s.getHstmt() ) == SQL_SUCCESS; (*iidsLen)++ ){
            char* id = new char[ 256 ];
            snprintf( id, 256, "%s/%d.%d", nijc_code, itid, iid );
            (*iids)[*iidsLen] = id;
        }
        ret = RES_OK;
    }
    freeString( nijc_code );
    return ret;
}


/**
 * 
 * ƥ֥󥯾ɲä롥
 * Platform桼ʾθ¤ɬ.
 * 
 * TODO itemidǤʤƥ򤵤Ƥ硤ɲäǤʤ
 * TODO parentiditemidβ줫ޤϰؤƥब¸ߤʤȤɲäǤʤ
 * 
 * @param sid åID
 * @param parentid 󥯸ƥID
 * @param itemid ()ƥID
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT parentidԽǤʤƥ򤵤Ƥ롤<br/>ޤitemidǤʤƥؤƤ롤<br/>ޤ XooNIps桼Ǥʤ(activateԤ)
 * 
 */
result_t insertRelatedTo( sessionid_t sid, itemid_t parentid, itemid_t itemid )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !isActivatedBySession( sid ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    if( !getItemPermission( sid, parentid, item::OP_MODIFY ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    if( !getItemPermission( sid, itemid, item::OP_READ ) ) return RES_NO_READ_ACCESS_RIGHT;
    
    string sql;
    SQLHANDLE hstmt = NULL;
    SQLRETURN sqlcode;
    result_t ret = RES_ERROR;


    sql = "SELECT * FROM " + dbprefix + "_xoonips_related_to WHERE parent_id="
        + string( unsignedIntToString( parentid ) ) + " AND item_id=" + string( unsignedIntToString( itemid ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            if( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                //nothing to do because already registered
                SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
                return RES_OK;
            }
        }
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in insertRelatedTo" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        return RES_ERROR;
    }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    
    sql = "INSERT INTO " + dbprefix + "_xoonips_related_to (parent_id, item_id) VALUES ("
        + string( unsignedIntToString( parentid ) ) + ", " + string( unsignedIntToString( itemid ) ) + ")";
    
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            ret = RES_OK;
        }else{
            string s( "SQLExecuteDirect in insertRelatedTo " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in insertRelatedTo" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    
    return ret;
}    


/**
 * 
 * ƥ֥󥯾.
 * 
 * @param sid åID
 * @param parentid 󥯤Υ󥯸ƥID
 * @param itemid 󥯤Υ()ƥID
 * @return RES_OK ޤϻꤵ줿󥯾¸ߤʤä
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT XooNIps桼Ǥʤ(activateԤ)ޤparentidΥƥԽ¤̵
 */
result_t deleteRelatedTo( sessionid_t sid, itemid_t parentid, itemid_t itemid )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !isActivatedBySession( sid ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    if( !getItemPermission( sid, parentid, item::OP_MODIFY ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    result_t ret = RES_ERROR;
    string sql;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    
    sql = "DELETE FROM " + dbprefix + "_xoonips_related_to ";
    sql += "WHERE parent_id=" + string( unsignedIntToString( parentid ) )
        + " AND item_id = " + string( unsignedIntToString( itemid ) );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            ret = RES_OK;
        }else{
            string s( "SQLExecuteDirect in deleteRelatedTo " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in deleteRelatedTo" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}

/**
 * 
 * ƥ֥󥯾.
 * 襢ƥα¤̵硤Υ󥯾֤ʤ.
 * 
 * @param sid åID
 * @param parentid 󥯸ƥID
 * @param itemids ̤(paerntid󥯤Ƥ륢ƥID)
 * @param itemidsLen itemidsοѿ
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT parentidؤ˥̵, XooNIps桼Ǥʤ(activateԤ)
 */
result_t getRelatedTo( sessionid_t sid, itemid_t parentid, itemid_t** itemids, int* itemidsLen )
{
    if( hdbc == NULL ) return RES_DB_NOT_INITIALIZED;
    if( !isValidSessionID( sid ) ) return RES_NO_SUCH_SESSION;
    if( !getItemPermission( sid, parentid, item::OP_READ ) ) return RES_NO_READ_ACCESS_RIGHT;
    
    result_t ret = RES_ERROR;
    string sql;
    SQLRETURN sqlcode;
    SQLHANDLE hstmt = NULL;
    
    sql = "SELECT count(*) FROM " + dbprefix + "_xoonips_related_to ";
    sql += "WHERE parent_id=" + string( unsignedIntToString( parentid ) );
    syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt ) ) == SQL_SUCCESS ) {
        if( ( sqlcode = SQLExecDirect( hstmt, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
            SQLUINTEGER cnt_tmp = 0;//󥯤(¤̵ͭ˹ʤ)
            SQLLEN len = 0;
            SQLBindCol( hstmt, 1, SQL_C_ULONG, &cnt_tmp, 0, &len );
            if( ( sqlcode = SQLFetch( hstmt ) ) == SQL_SUCCESS ){
                int count = 0; //ǽʥƥؤΥ󥯤ο
                itemid_t *ids_tmp = new itemid_t[ cnt_tmp ];
                if( cnt_tmp > 0 ){
                    //retrieve IDs
                    SQLHANDLE hstmt2 = NULL;    
                    if( ( sqlcode = SQLAllocHandle( SQL_HANDLE_STMT, hdbc, &hstmt2 ) ) == SQL_SUCCESS ) {
                        sql = "SELECT item_id FROM " + dbprefix + "_xoonips_related_to ";
                        sql += "WHERE parent_id=" + string( unsignedIntToString( parentid ) );
                        syslog_printf( "\nsql at %d=%s", __LINE__, sql.c_str() );
                        if( ( sqlcode = SQLExecDirect( hstmt2, (SQLCHAR*)sql.c_str(), sql.length() ) ) == SQL_SUCCESS ){
                            SQLUINTEGER iid = 0;
                            SQLLEN len = 0;
                            SQLBindCol( hstmt2, 1, SQL_C_ULONG, &iid, 0, &len );
                            for( SQLUINTEGER i = 0; ( sqlcode = SQLFetch( hstmt2 ) ) == SQL_SUCCESS && i < cnt_tmp ; i++ ){
                                if( getItemPermission( sid, iid, item::OP_READ ) ){
                                    ids_tmp[ count ] = iid;
                                    count++;
                                }
                            }
                            *itemids = new itemid_t[ count ];
                            if( count > 0 ) memcpy( *itemids, ids_tmp, sizeof( itemid_t ) * count );
                            *itemidsLen = count;
                            delete[] ids_tmp;
                            ret = RES_OK;
                        }else{
                            setLastErrorString( "SQLExecDirect in getRelatedTo" );
                            ret = RES_DB_QUERY_ERROR;
                        }
                        SQLFreeHandle( SQL_HANDLE_STMT, hstmt2 );
                    }else{
                        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getRelatedTo" );
                        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
                        setLastErrorString( s.c_str( ) );
                        ret = RES_ERROR;
                    }
                }else{
                    *itemids = new itemid_t[ 0 ];
                    *itemidsLen = 0;
                    ret = RES_OK;
                }
                
            }else{
                string s( "SQLFetch in getRelatedTo " );
                s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
                setLastErrorString( s.c_str( ) );
                ret = RES_DB_QUERY_ERROR;
            }
        }else{
            string s( "SQLExecuteDirect in getRelatedTo " );
            s += odbcDiagString( SQL_HANDLE_STMT, hstmt, sqlcode );
            setLastErrorString( s.c_str( ) );
            ret = RES_DB_QUERY_ERROR;
        }
        SQLFreeHandle( SQL_HANDLE_STMT, hstmt );
    }else{
        string s( "SQLAllocHandle(SQL_HANDLE_STMT,...) in getRelatedTo" );
        s += odbcDiagString( SQL_HANDLE_DBC, hdbc, sqlcode );
        setLastErrorString( s.c_str( ) );
        ret = RES_ERROR;
    }
    return ret;
}
