/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * SQL¹Է̤ϰϻꡤ¤ؤcriteria饹
 * 
 * $Revision: 1.5 $
 * $Log: criteria.cc,v $
 * Revision 1.5  2005/08/29 02:02:56  aga4096
 * valgrindǥ顼ФΤ.
 *
 * Revision 1.4  2005/03/15 04:49:40  tani
 * 饤ʸɲ.
 *
 * Revision 1.3  2004/11/27 01:08:08  youi
 * clearAll:orderbyΥ󥹥󥹤βɲä.
 *
 * Revision 1.2  2004/11/27 00:39:57  youi
 * orderbyΥ󥹥ȥ饯columnѿνɲ.
 *
 * Revision 1.1  2004/11/24 06:54:31  youi
 * initial version
 *
 * 
 */
#include <stdlib.h>
#include <string.h>

#include "common.h"
#include "criteria.h"

/**
 * SQLORDERBY򵭲륯饹
 * 
 * @param column ̾
 * @param order 硤߽λ(̤ orderby::ASC)
 * @ref orderby::ASC
 * @ref orderby::DESC
 * 
 */
orderby::orderby( const char* column = "", int order = orderby::ASC ){
    this -> column = 0;
    setValue( &this -> column, column );
    this -> order = order;
    this -> next = 0;
}

/**
 * 
 * ǥȥ饯
 * 
 * ̾Υΰ
 * 
 */
orderby::~orderby( ){
    delete[] this -> column;
}
    
/**
 * 
 * ֤̾
 * @return ̾
 * 
 */
const char* orderby::getColumn( ) const { return column; }

/**
 * 
 * 硤ޤϹ߽֤
 * @return 硤ޤϹ߽
 * @ref orderby::ASC
 * @ref orderby::DESC
 * 
 */
order_t orderby::getOrder( ) const{ return order; }

/**
 * 
 * SQLϰϻ(LIMIT)䡤Ƚ(̾Ⱦ߽)륯
 * .
 * 
 */
criteria::criteria( )
{
    start = 0;
    rows = 0;
    indexOfOrders = 0;
    ordersLen = 0;
    ordersMax = 16;
    orders = new orderby*[ ordersMax ];
    memset( orders, 0, sizeof( orderby* ) * ordersMax );
}

/**
 * 
 * ǥȥ饯
 * 
 * addOrderByɲäorderby󥹥󥹤βԤʤ
 *
 * @ref addOrderBy
 * 
 */
criteria::~criteria( )
{
    if( orders != 0 ){
        for( int i = 0; i < ordersLen; i++ ) delete orders[ i ];
        delete[] orders;
    }
}

/**
 * 
 * SQL¹Է̤ȤƽϤϰϤ򡤳ϹԤȹԿǻꤹ. 
 * 
 * @param start Ϲ
 * @param rows Կ
 * 
 */
void criteria::setLimit( int start , int rows )
{
    this -> start = start;
    this -> rows = rows;
}

/**
 * 
 * ߽ξɲä롥SQL¹ԻϺǽɲäΤǽΥ
 * ȾȤ롥
 * 
 * @param order orderbyΥɥ쥹
 *
 */
void criteria::addOrderBy( orderby *order )
{
    if( ordersMax == ordersLen ){
        //ordersΤäѤޤǥǡΤǡĥ
        orderby** ptr = new orderby*[ ordersMax * 2 ];
        memset( ptr, 0, sizeof( orderby* ) * ordersMax * 2 );
        memcpy( ptr, orders, sizeof( orderby* ) * ordersMax );
        delete[] orders;
        ordersMax *= 2;
        orders = ptr;
    }
    orders[ ordersLen ] = order;
    ordersLen++;
}

/**
 * 
 * ǽorderbyФ. 2ܰʹߤorderbynextOrderByǼФ.<br>
 * δؿϥåɤФ(unsafe)Ǥ
 * 
 * @return ǽorderby
 * @return 0 ʾorderbyϤʤ
 * @ref nextOrderBy
 * 
 */
const orderby* criteria::headOrderBy( )
{
    indexOfOrders = 0;
    if( indexOfOrders >= ordersLen ) return 0;
    return orders[ indexOfOrders++ ];
}

/**
 * 
 * orderbyФ.<br>
 * δؿϥåɤФ(unsafe)Ǥ
 * 
 * @return orderbyΥ󥹥
 * @return 0 ʾorderbyϤʤ
 * @ref headNextOrderBy
 * 
 */
const orderby* criteria::nextOrderBy( )
{
    if( indexOfOrders >= ordersLen ) return 0;
    return orders[ indexOfOrders++ ];
}

/**
 * 
 * LIMITꡤƤORDERBYޤ.
 * 
 */
void criteria::clearAll( )
{
    for( int i = 0; i < ordersLen; i++ ) delete orders[ i ];
    memset( orders, 0, sizeof( orderby* ) * ordersMax );
    ordersLen = 0;
    start = rows = 0;
}

/**
 * 
 * LIMITγϹ
 * 
 * @return 
 * 
 */
int criteria::getLimitStart( ) const { return start; }

/**
 * 
 * LIMITιԿ
 * 
 * @return 
 * 
 */
int criteria::getLimitRows( ) const{ return rows; }
