/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * SQL¹Է̤ϰϻꡤ¤ؤcriteria饹
 * 
 * $Revision: 1.3 $
 * $Log: criteria.h,v $
 * Revision 1.3  2005/03/15 04:49:40  tani
 * 饤ʸɲ.
 *
 * Revision 1.2  2004/11/25 04:11:08  youi
 * typedefɲ.
 *
 * Revision 1.1  2004/11/24 06:54:21  youi
 * initial version
 *
 * 
 */

#if !defined( CRITERIA_H )
#define CRITERIA_H
typedef int order_t;

class orderby{
private:
    orderby* next;
    char* column;
    int order;
public:
    const static order_t ASC = 0;
    const static order_t DESC = 1;
    
    orderby( const char* column, int order );
    ~orderby( );
    
    const char* getColumn( ) const;
    order_t getOrder( ) const;
};

class criteria{
private:
    int start; //!< ϤγϹֹ
    int rows; //!< ϤιԿ(0=̵)
    orderby** orders; //!< ordersΥɥ쥹
    int ordersMax; //!< ordersκĹ
    int ordersLen; //!< ordersͭǡĿ
    int indexOfOrders; //!< ordersѤ
public:
    criteria( );
    ~criteria( );
    
    void setLimit( int start, int rows );
    void addOrderBy( orderby *order );
    void clearAll( );
    
    int getLimitStart( ) const;
    int getLimitRows( ) const;
    
    const orderby* headOrderBy( );
    const orderby* nextOrderBy( );
};

typedef criteria criteria_t;
#endif
