/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * 
 * ǥåɴѥ饹
 * 
 * $Revision: 1.6 $
 */

#if !defined( INDEX_H )
#define INDEX_H

#include "common.h"
#include "item.h"

typedef unsigned int indexid_t;
typedef unsigned int openlevel_t;
typedef unsigned int certify_t;
typedef unsigned int indexop_t;

class index : public item{
private:
    indexid_t parentXID;
    unsigned int ownerUID;
    unsigned int ownerGID;
    openlevel_t openLevel;
    unsigned int sortNumber;
public:
    const static openlevel_t OL_PUBLIC = 1;
    const static openlevel_t OL_GROUP_ONLY = 2;
    const static openlevel_t OL_PRIVATE = 3;
    
    const static certify_t NOT_CERTIFIED = 0;
    const static certify_t CERTIFY_REQUIRED = 1;
    const static certify_t CERTIFIED = 2;
    
    //IDs of index operation
    const static indexop_t OP_REGISTER = 1;
    const static indexop_t OP_UNREGISTER = 2;
    
    index();
    ~index();
    
    indexid_t getIndexID() const;
    indexid_t getParentIndexID() const;
    unsigned int getOwnerUID() const;
    unsigned int getOwnerGID() const;
    openlevel_t getOpenLevel() const;
    unsigned int getSortNumber() const;
    
    void setIndexID(indexid_t);
    void setParentIndexID(indexid_t);
    void setOwnerUID(unsigned int);
    void setOwnerGID(unsigned int);
    void setOpenLevel(openlevel_t);
    void setSortNumber(unsigned int);
    
    bool isPublic() const;
    bool isGroupOnly() const;
    bool isPrivate() const;
    
};

typedef class index index_t; // "index"Ϥɤ¾ξǻѤƤ餷

#endif
