/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * 
 * ƥ(BasicInformation)ѥ饹
 * 
 * $Revision: 1.9 $
 */

#if !defined( ITEM_H )
#define ITEM_H

#include "common.h"
#include "account.h"
#include "itemtype.h"

#define XNP_ITEM_LANG_LEN 3
#define XNP_ITEM_TITLE_LEN 255
#define XNP_ITEM_KEYWORDS_LEN 1024
#define XNP_ITEM_DESCRIPTION_LEN 1024
#define XNP_ITEM_DOI_LEN 1024

typedef unsigned int itemid_t;

class item {
private:
    itemid_t iid;
    itemtypeid_t itemTypeID;
    userid_t contributorUID;
    char *title;
    char *keywords;
    char *description;
    char* doi;
    time_t lastUpdateDate;
    time_t creationDate;
    unsigned int publicationYear;
    unsigned int publicationMonth;// 1 - 12 (0=unspecified)
    unsigned int publicationMday;// 1 - 31 (0=unspecified)
    char lang[ XNP_ITEM_LANG_LEN + 1 ]; //default value 'eng'

public:
    // reserved item_id value
    const static itemid_t IID_ROOT = 1;
    const static itemid_t IID_BINDERS = 2;
    const static itemid_t IID_PUBLIC = 3;
    
    // reserved item_type_id value
    const static itemtypeid_t ITID_INDEX = 1;
    const static itemtypeid_t ITID_BINDER = 2;
    
    //IDs of item operation
    const static itemop_t OP_READ = 1;
    const static itemop_t OP_MODIFY = 2;
    const static itemop_t OP_DELETE = 3;
    
    item();
    ~item();
    
    userid_t getContributorUID() const;
    itemid_t getItemID() const;
    itemtypeid_t getItemTypeID() const;
    const char* getTitle() const;
    const char* getKeywords() const;
    const char* getDescription() const;
    const char* getDOI() const;
    time_t getCreationDate() const;
    time_t getLastUpdateDate() const;
    unsigned int getPublicationYear() const;
    unsigned int getPublicationMonth() const;
    unsigned int getPublicationMday() const;
    const char* getLang() const;

    void setContributorUID( userid_t );
    void setItemID( itemid_t );
    void setItemTypeID( itemtypeid_t );
    void setTitle( const char* );
    void setKeywords( const char* );
    void setDescription( const char* );
    void setDOI( const char* );
    void setCreationDate( time_t );
    void setLastUpdateDate( time_t );
    void setPublicationYear( unsigned int );
    void setPublicationMonth( unsigned int );
    void setPublicationMday( unsigned int );
    void setLang( const char* );
};

typedef class item item_t;

#endif
