/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * 
 * $Revision: 1.4 $
 * $Log: itemtype.h,v $
 * Revision 1.4  2005/05/18 10:00:17  aga4096
 * ⥸塼б.
 *
 * Revision 1.3  2005/03/15 04:49:40  tani
 * 饤ʸɲ.
 *
 * Revision 1.2  2005/01/24 10:51:11  youi
 * ⥸塼IDƥॿɽ̾ΰɲä.
 *
 * Revision 1.1  2005/01/14 04:28:07  youi
 * initial version
 *
 * 
 */
#if !defined( ITEMTYPE_H )
#define ITEMTYPE_H

#define XNP_ITEMTYPE_NAME_LEN 30
#define XNP_ITEMTYPE_DISPLAY_NAME_LEN 30
#define XNP_ITEMTYPE_VIEWPHP_LEN 255

typedef int itemop_t;
typedef unsigned int itemtypeid_t;
class itemtype{
public:
    itemtype();
    ~itemtype();
    
    itemtypeid_t getItemTypeID() const;
    unsigned int getModuleID() const;
    const char* getName() const;
    const char* getDisplayName() const;
    const char* getViewphp() const;

    void setItemTypeID( itemtypeid_t x );
    void setModuleID( unsigned int x );
    void setName( const char* x );
    void setDisplayName( const char* x );
    void setViewphp( const char* x );
private:
    itemtypeid_t item_type_id;
    unsigned int mid;
    char name[ XNP_ITEMTYPE_NAME_LEN + 1 ];
    char display_name[ XNP_ITEMTYPE_DISPLAY_NAME_LEN + 1 ];
    char viewphp[ XNP_ITEMTYPE_VIEWPHP_LEN + 1 ];
};
typedef itemtype itemtype_t;
#endif
