# Configure paths for libiodbc
# Yoshihiro OKUMURA 05-03-10
# Adapted from:
# Configure paths for GLIB
# Owen Taylor     97-11-3

dnl AM_PATH_IODBC([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for IODBC, and define IODBC_CFLAGS and IODBC_LIBS
dnl
AC_DEFUN([AM_PATH_IODBC],[ 
AC_ARG_WITH([iodbc-prefix],
            [  --with-iodbc-prefix=PFX Prefix where libiodbc is installed (optional)],
            iodbc_config_prefix="$withval", iodbc_config_prefix="")
AC_ARG_WITH([iodbc-exec-prefix],
            [  --with-iodbc-exec-prefix=PFX
                          Exec prefix where libiodbc is installed (optional)],
            iodbc_config_exec_prefix="$withval", iodbc_config_exec_prefix="")
  if test x$iodbc_config_exec_prefix != x ; then
    iodbc_config_args="$iodbc_config_args"
    if test x${IODBC_CONFIG+set} != xset ; then
      IODBC_CONFIG=$iodbc_config_exec_prefix/bin/iodbc-config
    fi
  fi
  if test x$iodbc_config_prefix != x ; then
    iodbc_config_args="$iodbc_config_args --prefix=$iodbc_config_prefix"
    if test x${IODBC_CONFIG+set} != xset ; then
      IODBC_CONFIG=$iodbc_config_prefix/bin/iodbc-config
    fi
  fi

  AC_PATH_PROG(IODBC_CONFIG, iodbc-config, no)
  min_iodbc_version=ifelse([$1], ,3.0.0,[$1])
  require_major_version=`echo $min_iodbc_version | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
  require_minor_version=`echo $min_iodbc_version | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
  require_micro_version=`echo $min_iodbc_version | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

  AC_MSG_CHECKING(for libiodbc - version >= $min_iodbc_version)
  no_iodbc=""
  if test "$IODBC_CONFIG" = "no" ; then
    no_iodbc=yes
  else
    IODBC_CFLAGS=`$IODBC_CONFIG $iodbc_config_args --cflags`
    IODBC_LIBS=`$IODBC_CONFIG $iodbc_config_args --libs`
    IODBC_STATIC_LIBS=`$IODBC_CONFIG $iodbc_config_args --static-libs`
    IODBC_LIBTOOL_LIBS=`$IODBC_CONFIG $iodbc_config_args --libtool-libs`
    IODBC_ODBCVERSION=`$IODBC_CONFIG $iodbc_config_args --odbcversion`
    IODBC_ODBCINI=`$IODBC_CONFIG $iodbc_config_args --odbcini`
    IODBC_ODBCINSTINI=`$IODBC_CONFIG $iodbc_config_args --odbcinstini`
    IODBC_VERSION=`$IODBC_CONFIG $iodbc_config_args --version`
    iodbc_config_major_version=`$IODBC_CONFIG $iodbc_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    iodbc_config_minor_version=`$IODBC_CONFIG $iodbc_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    iodbc_config_micro_version=`$IODBC_CONFIG $iodbc_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test $iodbc_config_major_version -gt $require_major_version || \
         (test  $iodbc_config_major_version -eq $require_major_version && \
          test  $iodbc_config_minor_version -gt $require_minor_version) || \
         (test  $iodbc_config_major_version -eq $require_major_version && \
          test  $iodbc_config_minor_version -eq $require_minor_version && \
          test  $iodbc_config_micro_version -ge $require_micro_version); then
       version_check="yes"
    else
       version_check="no"
    fi
  fi

  if test "x$no_iodbc" = x ; then
    if test "x$version_check" = "xyes" ; then
      AC_MSG_RESULT(yes (version $iodbc_config_major_version.$iodbc_config_minor_version.$iodbc_config_micro_version))
      ac_save_cflags=$CFLAGS
      CFLAGS="$CFLAGS $IODBC_CFLAGS"
      AC_CHECK_TYPE([SQLLEN],[],[AC_DEFINE([SQLLEN], [long], [New Win64 datatype SQLLEN])],[#include <sql.h>
#include <sqlext.h>
])
      CFLAGS=$ac_save_cflags
      ifelse([$2], , :, [$2])
    else
      AC_MSG_RESULT(no (version $iodbc_config_major_version.$iodbc_config_minor_version.$iodbc_config_micro_version))
      echo "*** An old version of libiodbc $IODBC_VERSION was found."
      echo "*** You need a version of libiodbc newer than $min_iodbc_version."
      IODBC_CFLAGS=""
      IODBC_LIBS=""
      IODBC_STATIC_LIBS=""
      IODBC_LIBTOOL_LIBS=""
      IODBC_ODBCVERSION=""
      IODBC_ODBCINI=""
      IODBC_ODBCINSTINI=""
      IODBC_VERSION=""
      ifelse([$3], , :, [$3])
    fi
  else
    AC_MSG_RESULT(no)
    if test "$IODBC_CONFIG" = "no" ; then
      echo "*** The iodbc-config script installed by LIBIODBC could not be found"
      echo "*** If libiodbc was installed in PREFIX, make sure PREFIX/bin is in"
      echo "*** your path, or set the IODBC_CONFIG environment variable to the"
      echo "*** full path to iodbc-config."
    fi
    IODBC_CFLAGS=""
    IODBC_LIBS=""
    IODBC_STATIC_LIBS=""
    IODBC_LIBTOOL_LIBS=""
    IODBC_ODBCVERSION=""
    IODBC_ODBCINI=""
    IODBC_ODBCINSTINI=""
    IODBC_VERSION=""
    ifelse([$3], , :, [$3])
  fi
  AC_SUBST(IODBC_CFLAGS)
  AC_SUBST(IODBC_LIBS)
  AC_SUBST(IODBC_STATIC_LIBS)
  AC_SUBST(IODBC_LIBTOOL_LIBS)
  AC_SUBST(IODBC_ODBCVERSION)
  AC_SUBST(IODBC_ODBCINI)
  AC_SUBST(IODBC_ODBCINSTINI)
  AC_SUBST(IODBC_VERSION)
])
