# Configure paths for LIBXML2 with 2.6.19 bug check for xoonips AL
# Yoshihiro OKUMURA

dnl AM_XNI_PATH_XML2([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for XML, and define XML_CPPFLAGS and XML_LIBS and bug version check
dnl
AC_DEFUN([AM_XNI_PATH_XML2],
[

AM_PATH_XML2([$1],[$2],[$3])

AC_ARG_ENABLE([xml-query-bug-version-check],
  [AC_HELP_STRING([--disable-xml-query-bug-version-check],
     [disable library version check for GET query bug in libxml2-2.6.19])])
test "x$enable_xml_query_bug_version_check" = "x" && enable_xml_query_bug_version_check=yes

dnl checking libxml2 version for GET query problem
if test "x$enable_xml_query_bug_version_check" = "xyes" ; then
  xml_config_major_version=`$XML2_CONFIG $xml_config_args --version | \
       sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
  xml_config_minor_version=`$XML2_CONFIG $xml_config_args --version | \
       sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
  xml_config_micro_version=`$XML2_CONFIG $xml_config_args --version | \
       sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
  if test $xml_config_major_version -eq 2 && \
     test $xml_config_minor_version -eq 6 && \
     test $xml_config_micro_version -eq 19 ; then

    echo "*** libxml2-2.6.19 has GET query problem."
    echo "*** See following url for more detail information."
    echo "*** http://bugzilla.gnome.org/show_bug.cgi?id=172525"
    echo "*** If you have fixed libxml2-2.6.19 library, "
    echo "*** try --disable-xml-query-bug-version-check configure option."
    AC_MSG_ERROR([libxml2-2.6.19 has GET query problem.])
  fi
fi
])