dnl
dnl openssl.m4 -- Find the path to the openssl library.
dnl
AC_DEFUN([AM_PATH_OPENSSL],
[OPENSSL_CFLAGS=""
OPENSSL_LDFLAGS=""
OPENSSL_LIBS=""

AC_ARG_WITH([openssl-prefix], [  --with-openssl-prefix=PFX
                          Prefix where openssl is installed (optional)],
            openssl_prefix="$withval", openssl_prefix="")
if test x"$openssl_prefix" = xyes ; then
  openssl_prefix="";
fi

AC_MSG_CHECKING([for openssl location])
if test x"$openssl_prefix" = x ; then
  openssl_header_found="no"
  for dir in /usr/local /usr ; do
  if test -f "$dir/include/openssl/ssl.h" ; then
    openssl_header_found="yes"
    OPENSSL_CFLAGS="-I$dir/include"
    OPENSSL_LDFLAGS="-L$dir/lib"
    break
  fi
  done
  if test x"$openssl_header_found" = "no" ; then
    AC_MSG_RESULT([no])
    AC_MSG_ERROR([openssl header file 'openssl/ssl.h' not found.])
  fi
  AC_MSG_RESULT([$dir])
else
  OPENSSL_CFLAGS="-I$openssl_prefix/include"
  OPENSSL_LDFLAGS="-L$openssl_prefix/lib"
  AC_MSG_RESULT([$openssl_prefix])
fi

openssl_save_LDFLAGS=$LDFLAGS
LDFLAGS="$OPENSSL_LDFLAGS $LDFLAGS"
openssl_save_CFLAGS=$CFLAGS
CFLAGS="$OPENSSL_CFLAGS $CFLAGS"
AC_CHECK_LIB([rsaref], [RSAPublicEncrypt], 
  [AC_CHECK_LIB([RSAglue], [RSAPublicEncrypt], 
    [OPENSSL_LIBS="-lRSAglue -lrsaref"],,[-lrsaref])])
AC_CHECK_LIB([crypto], [BIO_new],
  [AC_CHECK_LIB([dl], [DSO_load],
    [OPENSSL_LIBS="-lcrypto -ldl $OPENSSL_LIBS"],
    [OPENSSL_LIBS="-lcrypto $OPENSSL_LIBS"], [-lcrypto $OPENSSL_LIBS])],
  [AC_MSG_ERROR(cannot link with OpenSSL)], [$OPENSSL_LIBS])
AC_CHECK_LIB([ssl], [SSL_library_init],
  [OPENSSL_LIBS="-lssl $OPENSSL_LIBS"],
  [AC_MSG_ERROR(cannot link with OpenSSL)], [$OPENSSL_LIBS])
LDFLAGS=$openssl_save_LDFLAGS
CFLAGS=$openssl_save_CFLAGS
if test x"$OPENSSL_LIBS" = x ; then
  AC_MSG_ERROR([openssl required but not found])
else
  OPENSSL_LIBS="$OPENSSL_LDFLAGS $OPENSSL_LIBS"
fi

AC_SUBST([OPENSSL_CFLAGS])
AC_SUBST([OPENSSL_LIBS])])
]
