# Configure paths for php
# Yoshihiro OKUMURA 05-03-12
# Adapted from:
# Configure paths for GLIB
# Owen Taylor     97-11-3

dnl AM_PATH_PHP([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for PHP, and define following variables:
dnl PHP_CONFIG PHP_PREFIX PHP_INCLUDES PHP_LDFLAGS PHP_LIBS 
dnl PHP_EXTENSION_DIR PHP_VERSION
dnl
AC_DEFUN([AM_PATH_PHP],[
  PHP_CONFIG=""
  PHP_PREFIX=""
  PHP_INCLUDES=""
  PHP_LDFLAGS=""
  PHP_LIBS=""
  PHP_EXTENSION_DIR=""
  PHP_VERSION=""
  AC_ARG_WITH([php-prefix],
            [  --with-php-prefix=PFX   Prefix where php is installed (optional)],
            php_config_prefix="$withval", php_config_prefix="")
  AC_ARG_WITH([php-exec-prefix],
            [  --with-php-exec-prefix=PFX
                          Exec prefix where php is installed (optional)],
            php_config_exec_prefix="$withval", php_config_exec_prefix="")
  if test x$php_config_exec_prefix != x ; then
    if test x${PHP_CONFIG} == x ; then
      PHP_CONFIG=$php_config_exec_prefix/bin/php-config
    fi
  fi
  if test x$php_config_prefix != x ; then
    if test x${PHP_CONFIG} == x ; then
      PHP_CONFIG=$php_config_prefix/bin/php-config
    fi
  fi
# checking config script
  AC_PATH_PROG(PHP_CONFIG, php-config, no)
  min_php_version=ifelse([$1],,4.3.2,[$1]) 
  require_major_version=`echo $min_php_version | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
  require_minor_version=`echo $min_php_version | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
  require_micro_version=`echo $min_php_version | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

  if test x$PHP_CONFIG = xno; then
    AC_MSG_ERROR([*** php not installed - please install first ***])
  fi
  AC_MSG_CHECKING(for php - version >= $min_php_version)
  no_php=""
  if test x$PHP_CONFIG = xno ; then
   no_php=yes
  else
    PHP_PREFIX="`$PHP_CONFIG --prefix`"
    PHP_INCLUDES="`$PHP_CONFIG --includes`"
    PHP_LDFLAGS="`$PHP_CONFIG --ldflags`"
    PHP_LIBS="`$PHP_CONFIG --libs`"
    PHP_EXTENSION_DIR="`$PHP_CONFIG --extension-dir`"
    PHP_VERSION="`$PHP_CONFIG --version`"
    php_config_major_version=`$PHP_CONFIG --version | \
          sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    php_config_minor_version=`$PHP_CONFIG --version | \
          sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    php_config_micro_version=`$PHP_CONFIG --version | \
          sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test $php_config_major_version -gt $require_major_version || \
         (test  $php_config_major_version -eq $require_major_version && \
          test  $php_config_minor_version -gt $require_minor_version) || \
         (test  $php_config_major_version -eq $require_major_version && \
          test  $php_config_minor_version -eq $require_minor_version && \
          test  $php_config_micro_version -ge $require_micro_version); then
       version_check="yes"
    else
       version_check="no"
    fi
  fi
  if test "x$no_php" = x ; then
    if test "x$version_check" = "xyes" ; then
      AC_MSG_RESULT(yes (version $php_config_major_version.$php_config_minor_version.$php_config_micro_version))
      ifelse([$2], , :, [$2])
    else
      AC_MSG_RESULT(no (version $php_config_major_version.$php_config_minor_version.$php_config_micro_version))
      echo "*** An old version of php $PHP_VERSION was found."
      echo "*** You need a version of php newer than $min_php_version."
      PHP_CONFIG=""
      PHP_PREFIX=""
      PHP_INCLUDES=""
      PHP_LDFLAGS=""
      PHP_LIBS=""
      PHP_EXTENSION_DIR=""
      PHP_VERSION=""
      ifelse([$3], , :, [$3])
    fi
  else
    AC_MSG_RESULT(no)
    if test "$PHP_CONFIG" = "no" ; then
      echo "*** The php-config script installed by PHP could not be found "
      echo "*** If php was installed in PREFIX, make sure PREFIX/bin is in"
      echo "*** your path, or set the PHP_CONFIG environment variable to the"
      echo "*** full path to php-config."
    fi
    PHP_CONFIG=""
    PHP_PREFIX=""
    PHP_INCLUDES=""
    PHP_LDFLAGS=""
    PHP_LIBS=""
    PHP_EXTENSION_DIR=""
    PHP_VERSION=""
    ifelse([$3], , :, [$3])
  fi
# exporting variables
  AC_SUBST(PHP_CONFIG)
  AC_SUBST(PHP_PREFIX)
  AC_SUBST(PHP_INCLUDES)
  AC_SUBST(PHP_LDFLAGS)
  AC_SUBST(PHP_LIBS)
  AC_SUBST(PHP_EXTENSION_DIR)
  AC_SUBST(PHP_VERSION)
])
