# Configure paths for libunixodbc
# Yoshihiro OKUMURA 05-03-10
# Adapted from:
# Configure paths for GLIB
# Owen Taylor     97-11-3

dnl AM_PATH_UNIXODBC([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for UNIXODBC, and define UNIXODBC_CFLAGS and UNIXODBC_LIBS
dnl
AC_DEFUN([AM_PATH_UNIXODBC],[ 
AC_ARG_WITH([unixodbc-prefix],
            [  --with-unixodbc-prefix=PFX
                          Prefix where libunixodbc is installed (optional)],
            unixodbc_config_prefix="$withval", unixodbc_config_prefix="")
AC_ARG_WITH([unixodbc-exec-prefix],
            [  --with-unixodbc-exec-prefix=PFX
                          Exec prefix where libunixodbc is installed (optional)],
            unixodbc_config_exec_prefix="$withval", unixodbc_config_exec_prefix="")
  if test x$unixodbc_config_exec_prefix != x ; then
    unixodbc_config_args="$unixodbc_config_args"
    if test x${UNIXODBC_CONFIG+set} != xset ; then
      UNIXODBC_CONFIG=$unixodbc_config_exec_prefix/bin/odbc_config
    fi
  fi
  if test x$unixodbc_config_prefix != x ; then
    unixodbc_config_args="$unixodbc_config_args --prefix=$unixodbc_config_prefix"
    if test x${UNIXODBC_CONFIG+set} != xset ; then
      UNIXODBC_CONFIG=$unixodbc_config_prefix/bin/odbc_config
    fi
  fi

  AC_PATH_PROG(UNIXODBC_CONFIG, odbc_config, no)
  min_unixodbc_version=ifelse([$1], ,2.2.0,[$1])
  require_major_version=`echo $min_unixodbc_version | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
  require_minor_version=`echo $min_unixodbc_version | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
  require_micro_version=`echo $min_unixodbc_version | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

  AC_MSG_CHECKING(for libunixodbc - version >= $min_unixodbc_version)
  no_unixodbc=""
  if test "$UNIXODBC_CONFIG" = "no" ; then
    no_unixodbc=yes
  else
    UNIXODBC_CFLAGS=`$UNIXODBC_CONFIG $unixodbc_config_args --cflags`
    UNIXODBC_LIBS=`$UNIXODBC_CONFIG $unixodbc_config_args --libs`
    UNIXODBC_STATIC_LIBS=`$UNIXODBC_CONFIG $unixodbc_config_args --static-libs`
    UNIXODBC_LIBTOOL_LIBS=`$UNIXODBC_CONFIG $unixodbc_config_args --libtool-libs`
    UNIXODBC_ODBCVERSION=`$UNIXODBC_CONFIG $unixodbc_config_args --odbcversion`
    UNIXODBC_ODBCINI=`$UNIXODBC_CONFIG $unixodbc_config_args --odbcini`
    UNIXODBC_ODBCINSTINI=`$UNIXODBC_CONFIG $unixodbc_config_args --odbcinstini`
    UNIXODBC_VERSION=`$UNIXODBC_CONFIG $unixodbc_config_args --version`
    unixodbc_config_major_version=`$UNIXODBC_CONFIG $unixodbc_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    unixodbc_config_minor_version=`$UNIXODBC_CONFIG $unixodbc_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    unixodbc_config_micro_version=`$UNIXODBC_CONFIG $unixodbc_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test $unixodbc_config_major_version -gt $require_major_version || \
         (test $unixodbc_config_major_version -eq $require_major_version && \
          test $unixodbc_config_minor_version -gt $require_minor_version) || \
         (test $unixodbc_config_major_version -eq $require_major_version && \
          test $unixodbc_config_minor_version -eq $require_minor_version && \
          test $unixodbc_config_micro_version -ge $require_micro_version); then
       version_check="yes"
    else
       version_check="no"
    fi
  fi

  if test "x$no_unixodbc" = x ; then
    if test "x$version_check" = "xyes" ; then
      AC_MSG_RESULT(yes (version $unixodbc_config_major_version.$unixodbc_config_minor_version.$unixodbc_config_micro_version))
      ifelse([$2], , :, [$2])
    else
      AC_MSG_RESULT(no (version $unixodbc_config_major_version.$unixodbc_config_minor_version.$unixodbc_config_micro_version))
      echo "*** An old version of unixodbc $UNIXODBC_VERSION was found."
      echo "*** You need a version of unixodbc newer than $min_unixodbc_version."
      UNIXODBC_CFLAGS=""
      UNIXODBC_LIBS=""
      UNIXODBC_STATIC_LIBS=""
      UNIXODBC_LIBTOOL_LIBS=""
      UNIXODBC_ODBCVERSION=""
      UNIXODBC_ODBCINI=""
      UNIXODBC_ODBCINSTINI=""
      UNIXODBC_VERSION=""
      ifelse([$3], , :, [$3])
    fi
  else
    AC_MSG_RESULT(no)
    if test "$UNIXODBC_CONFIG" = "no" ; then
      echo "*** The odbc_config script installed by unixODBC could not be found"
      echo "*** If unixODBC was installed in PREFIX, make sure PREFIX/bin is in"
      echo "*** your path, or set the UNIXODBC_CONFIG environment variable to the"
      echo "*** full path to odbc_config."
    fi
    UNIXODBC_CFLAGS=""
    UNIXODBC_LIBS=""
    UNIXODBC_STATIC_LIBS=""
    UNIXODBC_LIBTOOL_LIBS=""
    UNIXODBC_ODBCVERSION=""
    UNIXODBC_ODBCINI=""
    UNIXODBC_ODBCINSTINI=""
    UNIXODBC_VERSION=""
    ifelse([$3], , :, [$3])
  fi
  AC_SUBST(UNIXODBC_CFLAGS)
  AC_SUBST(UNIXODBC_LIBS)
  AC_SUBST(UNIXODBC_STATIC_LIBS)
  AC_SUBST(UNIXODBC_LIBTOOL_LIBS)
  AC_SUBST(UNIXODBC_ODBCVERSION)
  AC_SUBST(UNIXODBC_ODBCINI)
  AC_SUBST(UNIXODBC_ODBCINSTINI)
  AC_SUBST(UNIXODBC_VERSION)
])
