/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * $Revision: 1.3 $
 */

#include "pubmed.h"
#include "common.h"

#if defined(_MSC_VER)
#define snprintf _snprintf
int _fltused = 0x9875;
#endif

pubmed::pubmed()
{
    title=0; setValue( &title, "" );
    author=0; setValue( &author, "" );
    journal=0; setValue( &journal, "" );
    abstract=0; setValue( &abstract, "" );
    page=0; setValue( &page, "" );
    id = pub_year = volume = number = 0;
}

pubmed::~pubmed()
{
    delete[] title;
    delete[] author;
    delete[] journal;
    delete[] abstract;
    delete[] page;
}

pubmedid_t pubmed::getID( ) const { return id; }
const char* pubmed::getTitle( ) const { return title; }
const char* pubmed::getAuthor( ) const { return author; }
const char* pubmed::getJournal( ) const { return journal; }
int pubmed::getYearOfPublication( ) const { return pub_year; }
int pubmed::getVolume( ) const { return volume; }
int pubmed::getNumber( ) const { return number; }
const char* pubmed::getPage( ) const { return page; }
const char* pubmed::getAbstract( ) const { return abstract; }

void pubmed::setID( pubmedid_t x ){ this -> id = x; }
void pubmed::setTitle( const char* x ){ setValue( &this -> title, x ); }
void pubmed::setAuthor( const char* x ){ setValue( &this -> author, x ); }
void pubmed::setJournal( const char* x ){ setValue( &this -> journal, x ); }
void pubmed::setYearOfPublication( int x ){ this -> pub_year = x; }
void pubmed::setVolume( int x ){ this -> volume = x; }
void pubmed::setNumber( int x ){ this -> number = x; }
void pubmed::setPage( const char* x ){ setValue( &this -> page, x ); }
void pubmed::setAbstract( const char* x ){ setValue( &this -> abstract, x ); }
