/*
 *
 * commonal.ccΥƥ(cppunit)
 * 
 * $Revision: 1.25 $
 * $Log: commonal_cppunit.cc,v $
 * Revision 1.25  2005/11/17 11:00:09  tani
 * relatedToTestɲ.
 *
 * Revision 1.24  2005/08/23 07:46:38  tani
 * setLang, getLangΥƥȤɲ(compareItem, fillItem)
 *
 * Revision 1.23  2005/08/23 02:20:10  tani
 *
 * Revision 1.22  2005/05/23 08:01:11  tani
 * ⥸塼Υơ֥빽¤б.
 * 롼̾ʣưƥȤɲ.
 *
 * Revision 1.21  2005/03/14 06:12:11  tani
 * __BORLANDC__б.
 *
 * Revision 1.20  2005/02/25 07:42:06  tani
 * index, itemlimitΥƥȤɲ.
 *
 * Revision 1.19  2005/02/25 01:00:47  tani
 * SQLiteбɤɲ.
 *
 * Revision 1.18  2005/02/16 10:04:35  youi
 * publication_year/month/mdayб.
 *
 * Revision 1.17  2005/02/16 07:38:31  youi
 * ƥΥƥȤˡpublication_dateΥƥȤɲä.
 *
 * Revision 1.16  2005/02/09 11:10:27  youi
 * zipText, pubmedTestɲ.
 * itemTestpublic_item_target_userΥƥɲ.
 *
 * Revision 1.15  2005/02/09 07:30:22  aga
 * URL to My Personal Archive ä.
 *
 * Revision 1.14  2005/02/09 02:38:44  aga
 * initializeDB()DBTYPE_MYSQLɲ.
 *
 * Revision 1.13  2005/01/29 09:50:08  youi
 * getItemTypesΥƥȤɲä.
 *
 * Revision 1.12  2005/01/24 01:55:34  youi
 * getUncertifiedLink, getPrivateItemIDΥƥȤɲä.
 *
 * Revision 1.11  2005/01/22 05:36:26  youi
 * ѥɤmd5ɲä.
 *
 * Revision 1.10  2005/01/21 01:42:51  youi
 * itemTest: getItemIDByIndexIDΥƥȤɲ.
 * pubmedTestɲ.
 *
 * Revision 1.9  2005/01/19 06:15:46  youi
 * *** empty log message ***
 *
 * Revision 1.8  2005/01/15 05:40:35  youi
 * ƥϥƥȴؿɲä.
 *
 * Revision 1.7  2005/01/13 04:19:23  aga
 * VPXNPѴ.
 *
 * Revision 1.6  2005/01/06 07:28:02  youi
 * åΥƥȤɲä.
 * Ͽ桼ǥեPlatform롼פ˽°Ƥ뤳ȤƥȤ.
 * deleteMemberǤϥǥեPlatform롼פǤʤȤƥȤ.
 * °롼פΥƥȤ˥ǥեPlatform롼פν°ƥȤɲä.
 *
 * Revision 1.5  2004/12/25 09:48:54  youi
 * ƥȤ˻Ѥǡ١ѹ.
 *
 * Revision 1.4  2004/12/18 10:23:15  youi
 * ƥȤ˻Ѥơ֥̾prefixФ̾ѹ.
 * (commonal_cppunit.sql˹碌)
 * uintunsigned int˽.
 * my_socketɲä.
 * windowsunixǥ󥯥롼ɥե櫓.
 *
 * Revision 1.3  2004/12/18 01:10:05  youi
 * freeResultδؿ̾ѹʻƥƥȤ⽤.
 *
 * Revision 1.2  2004/12/06 07:21:17  youi
 * xnp_insert_account, xnp_insert_groupΰѹȼäƥƥƤѹ.
 *
 * Revision 1.1  2004/11/30 07:48:56  youi
 * initial version
 *
 * 
 */
#ifdef __WIN__
#include <winsock.h>
#define my_socket SOCKET
#else
typedef int my_socket;
#endif

#define DBPREFIX "x"
#define ODBC_DSN "cppunit_test"
#define DBTYPE DBTYPE_MYSQL
//#define DBTYPE DBTYPE_SQLITE

#include <time.h>
#include <stdio.h>
#include <string.h>
#if defined(__BORLANDC__)
#else
#include <unistd.h>
#endif
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>
#include <cppunit/TestResult.h> 
#include <cppunit/ui/text/TestRunner.h>
#include <cppunit/extensions/HelperMacros.h>

#include <string>
using namespace std;

#include "../session.h"
#include "../common.h"
#include "../commonal.h"
#include "common.h"
#include "../item.h"

#define TEST( x ) test( x, #x )

indexid_t getPrivateIndexByUID( sessionid_t sid, userid_t uid )
{
    const account_t* puser;
    if( getAccount( sid, uid, &puser ) == RES_OK ){
        indexid_t iid;
        iid = puser -> getPrivateIndexID();
        freeAccount( puser );
        //fprintf( stderr, "getPrivateIndexByUID=%d\n", iid );
        return iid;
    }
    return 0;
}

indexid_t getGroupIndexByGID( sessionid_t sid, groupid_t gid )
{
    const group_t* pgroup;
    if( getGroup( sid, gid, &pgroup ) == RES_OK ){
        indexid_t iid;
        iid = pgroup -> getGroupIndexID();
        freeGroup( pgroup );
        //fprintf( stderr, "getGroupIndexByGID=%d\n", iid );
        return iid;
    }
    return 0;
}

// Ϳ줿groupˡߡǡ򥻥åȤ
void fillGroup( int no, group_t* g )
{
    char buf[ 1024 ];
    snprintf( buf, 1024, "MyGroup No.%d", no );
    g -> setGname( buf );

    snprintf( buf, 1024, "Description of MyGroup No.%d", no );
    g -> setDesc( buf );
    
    g -> setItemNumberLimit( no );
    g -> setIndexNumberLimit( no );
    g -> setItemStorageLimit( no );
}


// Ϳ줿accountˡߡǡ򥻥åȤ
void fillAccount( int no , account_t* a )
{
    char buf[ 1024 ];
    char md5buf[ MD5_DIGEST_STRING_LENGTH ];

    snprintf( buf, 1023, "My Address %d", no );
    a -> setAddress( buf );

    snprintf( buf, 1023, "My 'Division' %d", no );
    a -> setDivision( buf );

    snprintf( buf, 1023, "My Telephone %d", no );
    a -> setTel( buf );

    snprintf( buf, 1023, "My CompanyName %d", no );
    a -> setCompanyName( buf );

    snprintf( buf, 1023, "My Country %d", no );
    a -> setCountry( buf );

    snprintf( buf, 1023, "My Zipcode %d", no );
    a -> setZipcode( buf );

    snprintf( buf, 1023, "My Fax number %d", no );
    a -> setFax( buf ); 

    snprintf( buf, 1023, "My Uname %d", no );
    a -> setUname( buf );

    snprintf( buf, 1023, "My Name %d", no );
    a -> setName( buf );

    snprintf( buf, 1023, "My Email address %d", no );
    a -> setEmail( buf );

    snprintf( buf, 1023, "My URL %d", no );
    a -> setURL( buf );

    snprintf( buf, 1023, "pass%d", no );
    a -> setPass( md5str( md5buf, ( unsigned char* )buf, strlen( buf ) ) );
    
    a -> setTimezoneOffset( 9.5 );

    a -> setItemNumberLimit( no );
    a -> setIndexNumberLimit( no );
    a -> setItemStorageLimit( no );
}

// Ϳ줿itemˡߡǡ򥻥åȤ
void fillItem( int no , item_t* a )
{
    char buf[ 1024 ];
    
    a -> setContributorUID( no );
    a -> setItemID( no );
    a -> setItemTypeID( no );
    
    snprintf( buf, 1023, "My Item Title %d", no );
    a -> setTitle( buf );
    
    snprintf( buf, 1023, "My Item Keywords %d", no );
    a -> setKeywords( buf );
    
    snprintf( buf, 1023, "My Item Description %d", no );
    a -> setDescription( buf );
    
    snprintf( buf, 1023, "My Item DOI %d", no );
    a -> setDOI( buf );
    
//    a -> setCreationDate( time( NULL ) );
//    a -> setLastUpdateDate( time( NULL ) );
    a -> setPublicationYear( no );
    a -> setPublicationMonth( no );
    a -> setPublicationMday( no );

    a -> setLang( "jpn" );
}

class AbstractLayerTest : public CppUnit::TestFixture
{ 
    CPPUNIT_TEST_SUITE( AbstractLayerTest );
    CPPUNIT_TEST( pubmedTest );
    CPPUNIT_TEST( zipTest );
    CPPUNIT_TEST( executeBeforeDBInitialize );
    CPPUNIT_TEST( invalidSessionID );
    CPPUNIT_TEST( loginUserTest );
    CPPUNIT_TEST( accountTest );
    CPPUNIT_TEST( getAccountsTest );
    CPPUNIT_TEST( dumpGroupAdminsTest );
    CPPUNIT_TEST( isGroupAdminTest );
    CPPUNIT_TEST( isModeratorTest );
    CPPUNIT_TEST( groupTest );
    CPPUNIT_TEST( getGroupsTest );
    CPPUNIT_TEST( memberTest );
    CPPUNIT_TEST( memberManipulateTest );
    CPPUNIT_TEST( getGroupsByUidTest );
    CPPUNIT_TEST( getSessionTest );
    CPPUNIT_TEST( changelogTest );
    CPPUNIT_TEST( itemTest );
    CPPUNIT_TEST( binderTest );
    CPPUNIT_TEST( isAdminTest );
    CPPUNIT_TEST( relatedToTest );
    CPPUNIT_TEST_SUITE_END();
    
public:
/*
    void errorStringTest() {
        //LastErrorStringΥƥ
        CPPUNIT_ASSERT( strcmp( getLastErrorString( ), "" ) == 0 );
        setLastErrorString( "no such user" );
        CPPUNIT_ASSERT( strcmp( getLastErrorString( ), "no such user" ) == 0 );
        setLastErrorString( "no such session" );
        CPPUNIT_ASSERT( strcmp( getLastErrorString( ), "no such session" ) == 0 );
    }
*/
    
    void executeBeforeDBInitialize( ){
        //DB˼¹Ԥȥ顼
        int len;
        criteria_t cri;
        const session_t* psession;
        groupid_t gid;
        group_t group;
        const group_t* pgroup;
        const account_t* getacc;
        userid_t *puid;
        groupid_t *pgid;
        sessionid_t sid;
        userid_t uid;
        
        uninitializeDB();
        
        CPPUNIT_ASSERT( isActivated( sid, uid ) == false );
        CPPUNIT_ASSERT( activate( sid, uid, false ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( getAccountCount( sid ) == 0 );
        CPPUNIT_ASSERT( deleteAccount( sid, uid ) == RES_DB_NOT_INITIALIZED );

        CPPUNIT_ASSERT( getAccount( sid, uid, &getacc ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( getAccounts( sid, &uid, 1, &cri, &getacc, &len ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( insertAccount( sid, getacc, &uid ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( updateAccount( sid, getacc ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( dumpUids( sid, &cri, &puid, &len ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( getGroupCount( sid ) == 0 );
        CPPUNIT_ASSERT( getGroupsByUid( sid, uid, &cri, &pgid, &len ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( isGroupAdmin( sid, gid, uid ) == false );
        CPPUNIT_ASSERT( dumpGids( sid, &cri, &pgid, &len ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( dumpGroupAdmins( sid, gid, &cri, &puid, &len ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( deleteMember( sid, gid, uid ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( insertMember( sid,  gid, uid, false ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( getMembers( sid,  gid, &cri, &puid, &len ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( deleteGroup( sid,  gid ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( insertGroup( sid, &group, &gid ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( updateGroup( sid, &group ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( getGroup( sid,  gid, &pgroup ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( getGroups( sid, &gid, len, &cri, &pgroup, &len ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( isModerator( sid, uid ) == false );
        CPPUNIT_ASSERT( getUid( "", &uid ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( loginUser( "", "", &sid ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( createSession( "", uid, &sid ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( getSession( sid, &psession ) == RES_DB_NOT_INITIALIZED );
        CPPUNIT_ASSERT( isValidSessionID( sid ) == false );
    }
    
    void invalidSessionID( ){
        sessionid_t sid;
        userid_t uid;
        
        initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK;
        
        // ʥåФ뿶
        CPPUNIT_ASSERT( isValidSessionID( sid ) == false );
        CPPUNIT_ASSERT( activate( sid, uid, false ) == RES_NO_SUCH_SESSION );
        CPPUNIT_ASSERT( isActivated( sid, uid ) == false );
        // sidʤ饢ȿϾ0
        CPPUNIT_ASSERT( getAccountCount( sid ) == 0 );
    }
    
    void loginUserTest( ){
        sessionid_t sid;
        userid_t uid;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK;
        
        // ʥѥɤѥɤФΥƥ
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"fugafuga", 8 ), &sid ) == RES_LOGIN_FAILURE );
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &sid ) == RES_OK );
        
        //åå
        CPPUNIT_ASSERT( isValidSessionID( sid ) == true );
        
        // ¸ߤʤuser="hogehoge" Фο񤤤ƥ
        CPPUNIT_ASSERT( getUid( "hogehoge", &uid ) == RES_NO_SUCH_USER );
        CPPUNIT_ASSERT( activate( sid, uid, false ) == RES_NO_SUCH_USER );
        CPPUNIT_ASSERT( isActivated( sid, uid ) == false );
        
        logoutUser( sid );
    }
    
    void accountTest( ){
        account ac;
        sessionid_t sid;
        userid_t uid;
        const account_t* getacc;
        criteria_t cri;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK;
        
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &sid ) == RES_OK );
        
        // ƥȳϻΥȿϿ
        int nAccountBase = getAccountCount( sid );
        
        //ƥ
        fillAccount( __LINE__, &ac );
        ac.setActivate( 0 );
        CPPUNIT_ASSERT( insertAccount( sid, &ac, &uid ) == RES_OK );
        //insertAccount顤Account뤳Ȥǧ
        
        // acΥ桼 Фơactivate/deactivateԤʤ
        // ξ֤Ǥ뤫ƥ
        CPPUNIT_ASSERT( getUid( ac.getUname( ), &uid ) == RES_OK );
        CPPUNIT_ASSERT( isActivated( sid, uid ) == false );
        CPPUNIT_ASSERT( activate( sid, uid, true ) == RES_OK );
        CPPUNIT_ASSERT( isActivated( sid, uid ) == true );
        CPPUNIT_ASSERT( activate( sid, uid, false ) == RES_OK );
        CPPUNIT_ASSERT( isActivated( sid, uid ) == false );
        
        //insert桼UID
        // Ƥ񤭴updateƤߤ롥
        CPPUNIT_ASSERT( getUid( ac.getUname( ), &uid ) == RES_OK );
        CPPUNIT_ASSERT( getAccount( sid, uid, &getacc ) == RES_OK );
        // insertaccountgetaccountƤ
        CPPUNIT_ASSERT( strcmp( ac.getAddress( ), getacc->getAddress( ) ) == 0 );
        CPPUNIT_ASSERT( strcmp( ac.getDivision(), getacc->getDivision() ) == 0 );
        CPPUNIT_ASSERT( strcmp( ac.getTel(), getacc->getTel() ) == 0 );
        CPPUNIT_ASSERT( strcmp( ac.getCompanyName( ), getacc->getCompanyName( ) ) == 0 );
        CPPUNIT_ASSERT( strcmp( ac.getCountry(), getacc->getCountry() ) == 0 );
        CPPUNIT_ASSERT( strcmp( ac.getZipcode(), getacc->getZipcode() ) == 0 );
        CPPUNIT_ASSERT( strcmp( ac.getFax(), getacc->getFax() ) == 0 );
        CPPUNIT_ASSERT( strcmp( ac.getUname(), getacc->getUname() ) == 0 );
        CPPUNIT_ASSERT( strcmp( ac.getName(), getacc->getName() ) == 0 );
        CPPUNIT_ASSERT( strcmp( ac.getEmail(), getacc->getEmail() ) == 0 );
        CPPUNIT_ASSERT( strcmp( ac.getURL(), getacc->getURL() ) == 0 );
        //CPPUNIT_ASSERT( strcmp( ac.getPass(), getacc->getPass() ) == 0 );
        CPPUNIT_ASSERT( ac.getTimezoneOffset( ) == getacc->getTimezoneOffset( ) );
        freeAccount( getacc );
    
        account_t ac2;
        fillAccount( __LINE__, &ac2 );
        ac.setUID( uid );
        ac.setAddress( ac2.getAddress( ) );
        ac.setDivision( ac2.getDivision() );
        ac.setTel( ac2.getTel() );
        ac.setCompanyName(  ac2.getCompanyName( ) );
        ac.setCountry( ac2.getCountry() );
        ac.setZipcode( ac2.getZipcode() );
        ac.setFax( ac2.getFax() );
        ac.setEmail( ac2.getEmail() );
        ac.setURL( ac2.getURL() );
        ac.setPass( ac2.getPass() );
        ac.setTimezoneOffset( ac2.getTimezoneOffset( ) );
        ac.setItemNumberLimit( ac2.getItemNumberLimit( ) );
        ac.setIndexNumberLimit( ac2.getIndexNumberLimit( ) );
        ac.setItemStorageLimit( ac2.getItemStorageLimit( ) );
        CPPUNIT_ASSERT( updateAccount( sid, &ac ) == RES_OK );
        
        const account_t* updated;
        CPPUNIT_ASSERT( getAccount( sid, uid, &updated ) == RES_OK );
        // updateaccountgetaccountƤ
        CPPUNIT_ASSERT( strcmp( updated->getAddress( ), ac.getAddress( ) ) == 0 );
        CPPUNIT_ASSERT( strcmp( updated->getDivision(), ac.getDivision() ) == 0 );
        CPPUNIT_ASSERT( strcmp( updated->getTel(), ac.getTel() ) == 0 );
        CPPUNIT_ASSERT( strcmp( updated->getCompanyName( ), ac.getCompanyName( ) ) == 0 );
        CPPUNIT_ASSERT( strcmp( updated->getCountry(), ac.getCountry() ) == 0 );
        CPPUNIT_ASSERT( strcmp( updated->getZipcode(), ac.getZipcode() ) == 0 );
        CPPUNIT_ASSERT( strcmp( updated->getFax(), ac.getFax() ) == 0 );
        CPPUNIT_ASSERT( strcmp( updated->getUname(), ac.getUname() ) == 0 );
        CPPUNIT_ASSERT( strcmp( updated->getName(), ac.getName() ) == 0 );
        CPPUNIT_ASSERT( strcmp( updated->getEmail(), ac.getEmail() ) == 0 );
        CPPUNIT_ASSERT( strcmp( updated->getURL(), ac.getURL() ) == 0 );
        CPPUNIT_ASSERT( strcmp( updated->getPass(), ac.getPass() ) == 0 );
        CPPUNIT_ASSERT( updated->getTimezoneOffset( ) == ac.getTimezoneOffset( ) );
        CPPUNIT_ASSERT( updated->getItemNumberLimit( ) == ac.getItemNumberLimit( ) );
        CPPUNIT_ASSERT( updated->getIndexNumberLimit( ) == ac.getIndexNumberLimit( ) );
        CPPUNIT_ASSERT( updated->getItemStorageLimit( ) == ac.getItemStorageLimit( ) );
        freeAccount( updated );
    
        CPPUNIT_ASSERT( deleteAccount( sid, uid ) == RES_OK );

        logoutUser( sid );
    }
    
    void getAccountsTest( )    //getAccountsΥƥ
    {
        account_t ac[ 4 ];
        userid_t uids[ 5 ];
        userid_t* dumpuids;
        const account_t* accounts;
        int accountsLen;
        int dumpuidsLen;
        criteria_t c;
        sessionid_t sid;
        userid_t uid;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK;
        
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &sid ) == RES_OK );
        
        for( int i = 0; i < 4; i++ ) fillAccount( __LINE__ + i, &ac[ i ] );
        for( int i = 0; i < 4; i++ ){
            insertAccount( sid, &ac[ i ], &uids[ i ] );
            getUid( ac[ i ].getUname( ), &uid );
            CPPUNIT_ASSERT( uid == uids[ i ] );
        }
        uids[ 4 ] = 99999999; //¸ߤʤUID򺮤
        
        c.clearAll( );
        c.addOrderBy( new orderby( "uid", orderby::DESC ) );
        CPPUNIT_ASSERT( dumpUids( sid, &c, &dumpuids, &dumpuidsLen ) == RES_OK );
        CPPUNIT_ASSERT( dumpuidsLen >= 4 );
        CPPUNIT_ASSERT( dumpuids[ 0 ] == uids[ 3 ] );
        CPPUNIT_ASSERT( dumpuids[ 1 ] == uids[ 2 ] );
        CPPUNIT_ASSERT( dumpuids[ 2 ] == uids[ 1 ] );
        CPPUNIT_ASSERT( dumpuids[ 3 ] == uids[ 0 ] );
        for( int i = 0; i < 4; i++ ){
            CPPUNIT_ASSERT( dumpuids[ i ] == uids[ 3 - i ] );
        }
        
        //
        c.clearAll( );
        c.addOrderBy( new orderby( "uname", orderby::ASC ) );
        CPPUNIT_ASSERT( getAccounts( sid, uids, 5, &c, &accounts, &accountsLen ) == RES_OK );
        CPPUNIT_ASSERT( accountsLen == 4 );
        for( int i = 0; i < 4; i++ ){
            CPPUNIT_ASSERT( strcmp( accounts[ i ].getUname( ), ac[ i ].getUname( ) ) == 0 );
        }
        freeAccount( accounts );
        
        //߽
        c.clearAll( );
        c.addOrderBy( new orderby( "uname", orderby::DESC ) );
        CPPUNIT_ASSERT( getAccounts( sid, uids, 5, &c, &accounts, &accountsLen ) == RES_OK );
        CPPUNIT_ASSERT( accountsLen == 4 );
        for( int i = 0; i < 4; i++ ){
            CPPUNIT_ASSERT( strcmp( accounts[ i ].getUname( ), ac[ 3 - i ].getUname( ) ) == 0 );
        }
        freeAccount( accounts );

        //criteria::clearAll, LimitΥƥ
        c.clearAll( );
        c.setLimit( 1, 2 );
        c.addOrderBy( new orderby( "uname", orderby::ASC ) );
        CPPUNIT_ASSERT( getAccounts( sid, uids, 5, &c, &accounts, &accountsLen ) == RES_OK );
        CPPUNIT_ASSERT( accountsLen == 2 );
        //ϿȤܡܤaccountsϤ
        CPPUNIT_ASSERT( strcmp( accounts[ 0 ].getUname( ), ac[ 1 ].getUname( ) ) == 0 );
        CPPUNIT_ASSERT( strcmp( accounts[ 1 ].getUname( ), ac[ 2 ].getUname( ) ) == 0 );
        freeAccount( accounts );
        
        for( int i = 0; i < 4; i++ )
            CPPUNIT_ASSERT( deleteAccount( sid, uids[ i ] ) == RES_OK );
        
        logoutUser( sid );
    }
    
    //dumpGroupAdmins
    void dumpGroupAdminsTest(){
        account_t ac[2];
        const account_t* accounts;
        userid_t uids[2];
        userid_t* dumpuids;
        criteria_t c;
        group_t grp;
        groupid_t* gids;
        int gidsLen;
        int dumpuidsLen;
        sessionid_t sid;
        groupid_t gid;
        userid_t uid;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        CPPUNIT_ASSERT( initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &sid ) == RES_OK );
        
        fillGroup( __LINE__, &grp );
        insertGroup( sid, &grp, &gid );
        
        c.clearAll( );
        c.setLimit( 0, 1 );
        c.addOrderBy( new orderby( "gid", orderby::DESC ) );
        CPPUNIT_ASSERT( dumpGids( sid, &c, &gids, &gidsLen ) == RES_OK );
        CPPUNIT_ASSERT( gids[ 0 ] == gid );

        fillAccount( __LINE__, &ac[0] );
        fillAccount( __LINE__, &ac[1] );
        CPPUNIT_ASSERT( insertAccount( sid, &ac[0], &uids[0] ) == RES_OK );
        CPPUNIT_ASSERT( insertAccount( sid, &ac[1], &uids[1] ) == RES_OK );
        CPPUNIT_ASSERT( getUid( ac[0].getUname( ), &uid ) == RES_OK );
        CPPUNIT_ASSERT( uid == uids[0] );
        CPPUNIT_ASSERT( getUid( ac[1].getUname( ), &uid ) == RES_OK );
        CPPUNIT_ASSERT( uid == uids[1] );
        
        //adminΤʤ롼
        CPPUNIT_ASSERT( insertMember( sid, gids[ 0 ], uids[0], false ) == RES_OK );
        CPPUNIT_ASSERT( isGroupAdmin( sid, gids[ 0 ], uids[0] ) == false );
        c.clearAll( );
        CPPUNIT_ASSERT( dumpGroupAdmins( sid, gids[ 0 ], &c, &dumpuids, &dumpuidsLen ) == RES_OK );
        CPPUNIT_ASSERT( dumpuidsLen == 0 );
        CPPUNIT_ASSERT( deleteMember( sid, gids[ 0 ], uids[0] ) == RES_OK );
        freeUID( dumpuids );

        //2ͤΥСΤadminͤξ
        CPPUNIT_ASSERT( insertMember( sid, gids[ 0 ], uids[0], true ) == RES_OK );
        CPPUNIT_ASSERT( dumpGroupAdmins( sid, gids[ 0 ], &c, &dumpuids, &dumpuidsLen ) == RES_OK );
        CPPUNIT_ASSERT( dumpuidsLen == 1 );
        CPPUNIT_ASSERT( dumpuids[0] == uids[0] );
        CPPUNIT_ASSERT( deleteMember( sid, gids[ 0 ], uids[0] ) == RES_OK );
        freeUID( dumpuids );

        //2ͤΥС2ͤȤ⤬adminǤ륰롼
        CPPUNIT_ASSERT( insertMember( sid, gids[ 0 ], uids[0], true ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( sid, gids[ 0 ], uids[1], true ) == RES_OK );
        CPPUNIT_ASSERT( dumpGroupAdmins( sid, gids[ 0 ], &c, &dumpuids, &dumpuidsLen ) == RES_OK );
        CPPUNIT_ASSERT( dumpuidsLen == 2 );
        CPPUNIT_ASSERT( dumpuids[0] == uids[0] );
        CPPUNIT_ASSERT( dumpuids[1] == uids[1] );
        CPPUNIT_ASSERT( deleteMember( sid, gids[ 0 ], uids[0] ) == RES_OK );
        CPPUNIT_ASSERT( deleteMember( sid, gids[ 0 ], uids[1] ) == RES_OK );
        freeUID( dumpuids );

        //ݽ
/*
        CPPUNIT_ASSERT( deleteIndex( sid, getPrivateIndexByUID( sid, uids[ 0 ] ) ) == RES_OK );
        CPPUNIT_ASSERT( deleteIndex( sid, getPrivateIndexByUID( sid, uids[ 1 ] ) ) == RES_OK );
        CPPUNIT_ASSERT( deleteIndex( sid, getGroupIndexByGID( sid, gids[ 0 ] ) ) == RES_OK );
*/
        CPPUNIT_ASSERT( deleteAccount( sid, uids[ 0 ] ) == RES_OK );
        CPPUNIT_ASSERT( deleteAccount( sid, uids[ 1 ] ) == RES_OK );
        CPPUNIT_ASSERT( deleteGroup( sid, gids[ 0 ] ) == RES_OK );
    }
    
    void isGroupAdminTest( ){
        account_t ac;
        group_t grp;
        criteria_t c;
        userid_t uid;
        groupid_t* gids;
        int gidsLen;
        sessionid_t sid;
        groupid_t gid;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        CPPUNIT_ASSERT( initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &sid ) == RES_OK );
        
        //ߡΥȤȥ롼ץǡ򥤥󥵡
        fillAccount( __LINE__, &ac );
        fillGroup( 20, &grp );
        CPPUNIT_ASSERT( insertAccount( sid, &ac, &uid ) == RES_OK );
        CPPUNIT_ASSERT( insertGroup( sid, &grp, &gid ) == RES_OK );
        c.clearAll( );
        c.setLimit( 0, 1 );
        c.addOrderBy( new orderby( "gid", orderby::DESC ) );
        CPPUNIT_ASSERT( dumpGids( sid, &c, &gids, &gidsLen ) == RES_OK );
        CPPUNIT_ASSERT( gids[ 0 ] == gid );
        CPPUNIT_ASSERT( getUid( ac.getUname( ), &uid ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( sid, gids[ 0 ], uid, false ) == RES_OK );
        CPPUNIT_ASSERT( isGroupAdmin( sid, gids[ 0 ], uid ) == false );
        CPPUNIT_ASSERT( deleteMember( sid, gids[ 0 ], uid ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( sid, gids[ 0 ], uid, true ) == RES_OK );
        CPPUNIT_ASSERT( isGroupAdmin( sid, gids[ 0 ], uid ) == true );
        CPPUNIT_ASSERT( deleteMember( sid, gids[ 0 ], uid ) == RES_OK );
        CPPUNIT_ASSERT( isGroupAdmin( sid, gids[ 0 ], uid ) == false );
            
        CPPUNIT_ASSERT( deleteGroup( sid, gids[ 0 ] ) == RES_OK );
        CPPUNIT_ASSERT( deleteAccount( sid, uid ) == RES_OK );
        freeGID( gids );
        
        logoutUser( sid );
    }
    
    void isModeratorTest( ){
        account_t ac;
        group_t grp;
        criteria_t c;
        userid_t uid;
        groupid_t* gids;
        int gidsLen;
        sessionid_t sid;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        CPPUNIT_ASSERT( initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &sid ) == RES_OK );
        
        CPPUNIT_ASSERT( isModerator( sid, 1 ) );
        CPPUNIT_ASSERT( !isModerator( sid, 3 ) );
        CPPUNIT_ASSERT( isModerator( sid, 4 ) );
        logoutUser( sid );
    }
    
    void groupTest( ){
        //롼פκ
        criteria c;
        group_t g;
        groupid_t gid;
        groupid_t *gids;
        int gidsLen = 0;
        int gidsLenBase = 0; //ƥΥ롼פ
        sessionid_t sid;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        CPPUNIT_ASSERT( initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &sid ) == RES_OK );
        
        gids = 0;
        CPPUNIT_ASSERT( dumpGids( sid, &c, &gids, &gidsLenBase ) == RES_OK );
        freeGID( gids );
        
        g.setGname( "ޥ롼" );
        g.setDesc( "ƥѤ˺ޥ롼פǤۤۤۤۤۤۤۤۤۤۤۤ" );
        CPPUNIT_ASSERT( insertGroup( sid, &g, &gid ) == RES_OK );
        //ʣ륰롼̾ϿǤʤ
        CPPUNIT_ASSERT( insertGroup( sid, &g, &gid ) == RES_GROUPNAME_ALREADY_EXISTS );
        
        CPPUNIT_ASSERT( dumpGids( sid, &c, &gids, &gidsLen ) == RES_OK );
        CPPUNIT_ASSERT( gidsLen == gidsLenBase + 1 );
        
        //롼פԽ
        const group_t* pg;
        
        CPPUNIT_ASSERT( getGroup( sid, gid, &pg ) == RES_OK );
        CPPUNIT_ASSERT( strcmp( g.getGname( ), pg -> getGname( ) ) == 0 );
        g.setGID( pg -> getGID( ) );
        freeGroup( pg );
        groupid_t gid_back = g.getGID();
        fillGroup( __LINE__, &g );
        g.setGID( gid_back );
        g.setDesc( "ޥ롼פԽޤ" );
        
        g.setGname( "default" );
        updateGroup( sid, &g );
        
        g.setGname( "ޥ롼פ̾Խޤ" );
        CPPUNIT_ASSERT( updateGroup( sid, &g ) == RES_OK );
        CPPUNIT_ASSERT( updateGroup( sid, &g ) == RES_OK );
        CPPUNIT_ASSERT( getGroup( sid, gid, &pg ) == RES_OK );
        CPPUNIT_ASSERT( strcmp( g.getGname( ), pg -> getGname( ) ) == 0 );
        CPPUNIT_ASSERT( strcmp( g.getDesc( ), pg -> getDesc( ) ) == 0 );
        CPPUNIT_ASSERT( g.getItemNumberLimit( ) == pg -> getItemNumberLimit( ) );
        CPPUNIT_ASSERT( g.getIndexNumberLimit( ) == pg -> getIndexNumberLimit( ) );
        CPPUNIT_ASSERT( g.getItemStorageLimit( ) == pg -> getItemStorageLimit( ) );
        freeGroup( pg );
        
        //롼פκ
        CPPUNIT_ASSERT( deleteGroup( sid, gid ) == RES_OK );
        //Ԥʤ줿(롼׿ƥͤä)
        CPPUNIT_ASSERT( dumpGids( sid, &c, &gids, &gidsLen ) == RES_OK );
        CPPUNIT_ASSERT( gidsLen == gidsLenBase );
        freeGID( gids );
        
        logoutUser( sid );
    }

    void getGroupsTest( ){
        group_t grp[ 4 ];
        groupid_t gids[ 4 ];
        groupid_t* gidsDump;
        groupid_t gid;
        const group_t* groups;
        int groupsLen;
        int gidsLen;
        int gidsDumpLen;
        criteria_t c;
        sessionid_t sid;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        CPPUNIT_ASSERT( initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &sid ) == RES_OK );
        
        //getGroupCountΥƥ
        //SIDʤ0
        for( sessionid_t i = 9999999 ; ; i++ ){
            if( !isValidSessionID( i ) ){
                CPPUNIT_ASSERT( getGroupCount( i ) == 0 );
                break;
            }
        }
        int gidsLenBase = getGroupCount( sid );
        
        //ߡΥ롼ץǡ򥤥󥵡
        for( int i = 0; i < 4; i++ ) fillGroup( i+10, &grp[ i ] );
        for( int i = 0; i < 4; i++ ) insertGroup( sid, &grp[ i ], &gids[ i ] );
        
        c.clearAll( );//롼פID
        c.addOrderBy( new orderby( "gid", orderby::ASC ) );
        CPPUNIT_ASSERT( dumpGids( sid, &c, &gidsDump, &gidsDumpLen ) == RES_OK );
        CPPUNIT_ASSERT( gidsDumpLen == gidsLenBase + 4 );
        
        CPPUNIT_ASSERT( getGroupCount( sid ) == gidsLenBase + 4 );    //SIDʤ饰롼פο֤
        
        //
        c.clearAll( );
        c.addOrderBy( new orderby( "gname", orderby::ASC ) );
        CPPUNIT_ASSERT( getGroups( sid, gids, 4, &c, &groups, &groupsLen ) == RES_OK );
        CPPUNIT_ASSERT( groupsLen == 4 );
        for( int i = 0; i < 4; i++ ){
            CPPUNIT_ASSERT( strcmp( groups[ i ].getGname( ), grp[ i ].getGname( ) ) == 0 );
        }
        freeGroup( groups );
        
        //߽
        c.clearAll( );
        c.addOrderBy( new orderby( "gname", orderby::DESC ) );
        CPPUNIT_ASSERT( getGroups( sid, gids, 4, &c, &groups, &groupsLen ) == RES_OK );
        CPPUNIT_ASSERT( groupsLen == 4 );
        for( int i = 0; i < 4; i++ ){
            CPPUNIT_ASSERT( strcmp( groups[ i ].getGname( ), grp[ 3 - i ].getGname( ) ) == 0 );
        }
        freeGroup( groups );
        
        //criteria::clearAll, LimitΥƥ
        c.clearAll( );
        c.setLimit( 1, 2 );
        c.addOrderBy( new orderby( "gid", orderby::ASC ) );
        CPPUNIT_ASSERT( getGroups( sid, gids, 4, &c, &groups, &groupsLen ) == RES_OK );
        CPPUNIT_ASSERT( groupsLen == 2 );
        //Ͽ롼פܡܤgroupsϤ
        CPPUNIT_ASSERT( strcmp( groups[ 0 ].getGname( ), grp[ 1 ].getGname( ) ) == 0 );
        CPPUNIT_ASSERT( strcmp( groups[ 1 ].getGname( ), grp[ 2 ].getGname( ) ) == 0 );
        freeGroup( groups );
        
        for( int i = 0; i < 4; i++ ) deleteGroup( sid, gids[ i ] );
        
        logoutUser( sid );
    }
    
    void memberTest( )    {//СɲáԤǤ̿
        account_t ac;
        const account_t* accounts;
        const userid_t* uids;
        criteria_t c;
        group_t grp;
        groupid_t* gids;
        int accountsLen;
        int dumpuidsLen;
        int gidsLen;
        sessionid_t sid;
        userid_t uid;
        userid_t* dumpuids;
        groupid_t gid;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        CPPUNIT_ASSERT( initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &sid ) == RES_OK );
        
        fillGroup( 9999, &grp );
        insertGroup( sid, &grp, &gid );
        
        c.clearAll( );
        c.setLimit( 0, 1 );
        c.addOrderBy( new orderby( "gid", orderby::DESC ) );
        CPPUNIT_ASSERT( dumpGids( sid, &c, &gids, &gidsLen ) == RES_OK );
        
        fillAccount( __LINE__, &ac );
        CPPUNIT_ASSERT( insertAccount( sid, &ac, &uid ) == RES_OK );
        CPPUNIT_ASSERT( getUid( ac.getUname( ), &uid ) == RES_OK );
            
        //롼פ˥Сɲ
        CPPUNIT_ASSERT( insertMember( sid, gids[ 0 ], uid, false ) == RES_OK );
        //롼פС
        CPPUNIT_ASSERT( deleteMember( sid, gids[ 0 ], uid ) == RES_OK );
        
        //¸ߤʤСɲá
        CPPUNIT_ASSERT( deleteAccount( sid, uid ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( sid, gids[ 0 ], uid, false ) == RES_NO_SUCH_USER );
        CPPUNIT_ASSERT( deleteMember( sid, gids[ 0 ], uid ) == RES_NO_SUCH_USER );
        
        //¸ߤʤ롼פɲá
        CPPUNIT_ASSERT( insertAccount( sid, &ac, &uid ) == RES_OK );
        CPPUNIT_ASSERT( getUid( ac.getUname( ), &uid ) == RES_OK );
        CPPUNIT_ASSERT( deleteGroup( sid, gids[ 0 ] ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( sid, gids[ 0 ], uid, false ) == RES_NO_SUCH_GROUP );
        CPPUNIT_ASSERT( deleteMember( sid, gids[ 0 ], uid ) == RES_NO_SUCH_GROUP );
        CPPUNIT_ASSERT( deleteAccount( sid, uid ) == RES_OK );
        
        logoutUser( sid );
    }
    
    void memberManipulateTest( ){//СɲáԤǤ̿
        account_t ac[ 4 ];
        const account_t* accounts;
        const group_t* groups;
        criteria_t c;
        group_t grp;
        groupid_t* gids;
        groupid_t gid;
        int accountsLen;
        int gidsLen;
        int groupsLen;
        int memberUidsLen = 0;
        int uidsLen;
        sessionid_t sid;
        userid_t uids[ 4 ];
        userid_t uid;
        userid_t* memberUids = 0;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        CPPUNIT_ASSERT( initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &sid ) == RES_OK );
        
        fillGroup( 9999, &grp ); //ƥѥ롼׺
        CPPUNIT_ASSERT( insertGroup( sid, &grp, &gid ) == RES_OK );
        
        //ƥѥϿ
        for( int i = 0; i < 4; i++ ) fillAccount( i, &ac[ i ] );
        for( int i = 0; i < 4; i++ ) CPPUNIT_ASSERT( insertAccount( sid, &ac[ i ], &uid ) == RES_OK );
        for( int i = 0; i < 4; i++ ) CPPUNIT_ASSERT( getUid( ac[ i ].getUname( ), &uids[ i ] ) == RES_OK );
        
        //can't delete a member from default platform group
        for( int i = 0; i < 4; i++ ) CPPUNIT_ASSERT( deleteMember( sid, group_t::GID_DEFAULT, uids[ i ] ) == RES_ERROR );
        
        c.clearAll( );
        c.setLimit( 0, 1 );
        c.addOrderBy( new orderby( "gid", orderby::DESC ) );
        //Ͽ롼פgid
        CPPUNIT_ASSERT( dumpGids( sid, &c, &gids, &gidsLen ) == RES_OK );
        
        //ƥȳ
        for( int i = 0; i < 4; i++ ) CPPUNIT_ASSERT( insertMember( sid, gids[ 0 ], uids[ i ], false ) == RES_OK );
        c.clearAll( );
        CPPUNIT_ASSERT( getMembers( sid, gids[ 0 ], &c, &memberUids, &memberUidsLen ) == RES_OK );
        CPPUNIT_ASSERT( memberUidsLen == 4 );
        for( int i = 0; i < memberUidsLen; i++ ) CPPUNIT_ASSERT( deleteMember( sid, gids[ 0 ], memberUids[ i ] ) == RES_OK );
        freeUID( memberUids );
        
        CPPUNIT_ASSERT( getMembers( sid, gids[ 0 ], &c, &memberUids, &memberUidsLen ) == RES_OK );
        CPPUNIT_ASSERT( memberUidsLen == 0 );
        freeUID( memberUids );
        
        for( int i = 0; i < 4; i++ )
            CPPUNIT_ASSERT( deleteAccount( sid, uids[ i ] ) == RES_OK );
        CPPUNIT_ASSERT( deleteGroup( sid, gids[ 0 ] ) == RES_OK );
        
        logoutUser( sid );
    }

    void getGroupsByUidTest( )
    {
        account_t ac[ 4 ];
        const account_t* accounts;
        const group_t* groups;
        criteria_t c;
        group_t grp[ 4 ];
        groupid_t* gids;
        groupid_t gid;
        int accountsLen;
        int gidsLen;
        int groupsLen;
        int uidsLen;
        sessionid_t sid;
        userid_t uids[ 4 ];
        userid_t uid;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        CPPUNIT_ASSERT( initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &sid ) == RES_OK );
        
        
        //ƥѥϿ
        //ac[0] .... 1Ĥ⥰롼פ°ʤҤ
        //ac[1] .... 1ĤΥ롼פ°Ҥ
        //ac[2] .... 2ĤΥ롼פ°Ҥ
        for( int i = 0; i < 4; i++ ) fillAccount( i, &ac[ i ] );
        for( int i = 0; i < 4; i++ ) CPPUNIT_ASSERT( insertAccount( sid, &ac[ i ], &uid ) == RES_OK );
        for( int i = 0; i < 4; i++ ) CPPUNIT_ASSERT( getUid( ac[ i ].getUname( ), &uids[ i ] ) == RES_OK );
        
        //ߡΥ롼ץǡ򥤥󥵡
        for( int i = 0; i < 4; i++ ) fillGroup( i+20, &grp[ i ] );
        for( int i = 0; i < 4; i++ ) insertGroup( sid, &grp[ i ], &gid );
        
        c.clearAll( );
        c.addOrderBy( new orderby( "gid", orderby::DESC ) );
        //Ͽ롼פgid
        CPPUNIT_ASSERT( dumpGids( sid, &c, &gids, &gidsLen ) == RES_OK );
        userid_t* belongToGids = 0;
        int belongToGidsLen = 0;
        
        CPPUNIT_ASSERT( insertMember( sid, gids[ 0 ], uids[ 1 ], false ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( sid, gids[ 0 ], uids[ 2 ], false ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( sid, gids[ 1 ], uids[ 2 ], false ) == RES_OK );
        
        //ƥȳ
        c.clearAll( );
        belongToGidsLen = 10;
        CPPUNIT_ASSERT( getGroupsByUid( sid, uids[ 0 ], &c, &belongToGids, &belongToGidsLen ) == RES_OK );
        CPPUNIT_ASSERT( belongToGidsLen == 0 ); // belong to no groups (default group is invisible)
        freeGID( belongToGids );
        
        belongToGidsLen = 10;
        c.clearAll( );
        c.addOrderBy( new orderby( "gid", orderby::ASC ) );
        CPPUNIT_ASSERT( getGroupsByUid( sid, uids[ 1 ], &c, &belongToGids, &belongToGidsLen ) == RES_OK );
        CPPUNIT_ASSERT( belongToGidsLen == 1 );
        CPPUNIT_ASSERT( belongToGids[ 0 ] == gids[ 0 ] );
        freeGID( belongToGids );
        
        belongToGidsLen = 10;
        c.clearAll( );
        c.addOrderBy( new orderby( "gid", orderby::DESC ) );
        CPPUNIT_ASSERT( getGroupsByUid( sid, uids[ 2 ], &c, &belongToGids, &belongToGidsLen ) == RES_OK );
        CPPUNIT_ASSERT( belongToGidsLen == 2 );
        CPPUNIT_ASSERT( belongToGids[ 0 ] == gids[ 0 ] );
        CPPUNIT_ASSERT( belongToGids[ 1 ] == gids[ 1 ] );
        freeGID( belongToGids );
        
        CPPUNIT_ASSERT( deleteMember( sid, gids[ 0 ], uids[ 1 ] ) == RES_OK );
        CPPUNIT_ASSERT( deleteMember( sid, gids[ 0 ], uids[ 2 ] ) == RES_OK );
        CPPUNIT_ASSERT( deleteMember( sid, gids[ 1 ], uids[ 2 ] ) == RES_OK );
        for( int i = 0; i < 4; i++ ) CPPUNIT_ASSERT( deleteGroup( sid, gids[ i ] ) == RES_OK );
        for( int i = 0; i < 4; i++ ) CPPUNIT_ASSERT( deleteAccount( sid, uids[ i ] ) == RES_OK );
        freeGID( gids );
        
        logoutUser( sid );
    }

    void getSessionTest( )
    {
        sessionid_t sid;
        const session_t* sess;
        const account_t* ac;
        userid_t uid;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK;
        CPPUNIT_ASSERT( getUid( "testuser", &uid ) == RES_OK );
        
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &sid ) == RES_OK );
        CPPUNIT_ASSERT( getAccount( sid, uid, &ac ) == RES_OK );
        CPPUNIT_ASSERT( getSession( sid, &sess ) == RES_OK );
        CPPUNIT_ASSERT( sess[0].getSessionID( ) == sid );
        CPPUNIT_ASSERT( sess[0].getUID( ) == ac -> getUID( ) );
        logoutUser( sid );
        
        CPPUNIT_ASSERT( getSession( sid, &sess ) != RES_OK );
        
        freeSession( sess );
        freeAccount( ac );
    }
    
    
#define MAXITEMS 5
#define compareItem( x, y )  { \
            const item_t* a = x; \
            const item_t* b = y; \
            CPPUNIT_ASSERT( a -> getContributorUID() == b -> getContributorUID() ); \
            CPPUNIT_ASSERT( a -> getItemID() == b -> getItemID() ); \
            CPPUNIT_ASSERT( a -> getItemTypeID() == b -> getItemTypeID() ); \
            CPPUNIT_ASSERT( strcmp( a -> getTitle(), b -> getTitle() ) == 0 ); \
            CPPUNIT_ASSERT( strcmp( a -> getTitle(), b -> getTitle() ) == 0 ); \
            CPPUNIT_ASSERT( strcmp( a -> getTitle(), b -> getTitle() ) == 0 ); \
            CPPUNIT_ASSERT( strcmp( a -> getKeywords(), b -> getKeywords() ) == 0 ); \
            CPPUNIT_ASSERT( strcmp( a -> getDescription(), b -> getDescription() ) == 0 ); \
            CPPUNIT_ASSERT( strcmp( a -> getDOI(), b -> getDOI() ) == 0 ); \
            CPPUNIT_ASSERT( a -> getPublicationYear() == b -> getPublicationYear() ); \
            CPPUNIT_ASSERT( a -> getPublicationMonth() == b -> getPublicationMonth() ); \
            CPPUNIT_ASSERT( a -> getPublicationMday() == b -> getPublicationMday() ); \
            CPPUNIT_ASSERT( strcmp( a -> getLang(), b -> getLang() ) == 0 ); \
        }
    
    void itemTest( ){
        certify_t state;
        itemid_t iids_test[MAXITEMS]; //itemid 
        item_t items_test[MAXITEMS];
        itemid_t iids_test256[MAXITEMS]; //itemid 
        item_t items_test256[MAXITEMS];
        const item_t* pitems;
        int pitemsLen;
        criteria_t c;
        const itemid_t* piids;
        int piidsLen;
        itemid_t itemid;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        sessionid_t mode_sid; // sid of moderator
        userid_t mode_uid;
        
        sessionid_t testuser_sid;
        
        sessionid_t test_sid;
        userid_t test_uid;
        account_t test_user;
        
        sessionid_t test256_sid;
        userid_t test256_uid;
        account_t test256_user;
        
        sessionid_t gadmin_sid;
        userid_t gadmin_uid;
        account_t gadmin_user;
        
        indexid_t pub_xid;
        
        initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK;
        
        {
            item_t i;
            CPPUNIT_ASSERT( strcmp( i.getLang(), "eng" ) == 0 );
            i.setLang( "jpn" );
            CPPUNIT_ASSERT( strcmp( i.getLang(), "jpn" ) == 0 );
            i.setLang( "japanese" );
            CPPUNIT_ASSERT( strcmp( i.getLang(), "jap" ) == 0 );
            i.setLang( "us" );
            CPPUNIT_ASSERT( strcmp( i.getLang(), "us" ) == 0 );
        }
        
        const itemtype_t* ptype;
        int len;
        CPPUNIT_ASSERT( getItemTypes( &ptype, &len ) == RES_OK );
        CPPUNIT_ASSERT( strcmp( ptype[0].getName(), "xoonips_index" ) == 0 );
        CPPUNIT_ASSERT( strcmp( ptype[1].getDisplayName(), "Binder" ) == 0 );
        freeItemType( ptype );
        
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &testuser_sid ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( "moderator", md5str( md5buf, ( unsigned char* )"mode00", 6 ), &mode_sid ) == RES_OK );
        CPPUNIT_ASSERT( getUid( "moderator", &mode_uid ) == RES_OK );
        
        fillAccount( __LINE__, &test_user );
        CPPUNIT_ASSERT( insertAccount( testuser_sid, &test_user, &test_uid ) == RES_OK );
        CPPUNIT_ASSERT( activate( testuser_sid, test_uid, true ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( test_user.getUname(), test_user.getPass(), &test_sid ) == RES_OK );
        
        fillAccount( __LINE__, &test256_user );
        CPPUNIT_ASSERT( insertAccount( testuser_sid, &test256_user, &test256_uid ) == RES_OK );
        CPPUNIT_ASSERT( activate( testuser_sid, test256_uid, true ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( test256_user.getUname(), test256_user.getPass(), &test256_sid ) == RES_OK );
        
        fillAccount( __LINE__, &gadmin_user );
        CPPUNIT_ASSERT( insertAccount( testuser_sid, &gadmin_user, &gadmin_uid ) == RES_OK );
        CPPUNIT_ASSERT( activate( testuser_sid, gadmin_uid, true ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( gadmin_user.getUname(), gadmin_user.getPass(), &gadmin_sid ) == RES_OK );
        
        //insert public index
        {
            index_t idx;
            idx.setTitle( "public index" );
            idx.setParentIndexID( item_t::IID_PUBLIC );
            idx.setItemTypeID( item_t::ITID_INDEX );
            idx.setOwnerUID( 0 );
            idx.setOwnerGID( 0 );
            idx.setOpenLevel( index_t::OL_PUBLIC );
            idx.setSortNumber( 0 );
            insertIndex( mode_sid, &idx, &pub_xid );
            CPPUNIT_ASSERT( insertIndex( mode_sid, &idx, &pub_xid ) == RES_OK );
        }
        
        //insert group
        group_t grp;
        groupid_t test_gid;
        groupid_t test256_gid;
        fillGroup( __LINE__, &grp );
        CPPUNIT_ASSERT( insertGroup( test_sid, &grp, &test_gid ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( test_sid, test_gid, test_uid, false ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( test256_sid, test_gid, test256_uid, false ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( gadmin_sid, test_gid, gadmin_uid, true ) == RES_OK );
        fillGroup( __LINE__, &grp );
        CPPUNIT_ASSERT( insertGroup( test256_sid, &grp, &test256_gid ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( test256_sid, test256_gid, test256_uid, false ) == RES_OK );
        
        //insert test by test
        for( int i = 0 ; i < MAXITEMS ; i++ ){
            fillItem( __LINE__+i, &items_test[i] );
            items_test[i].setContributorUID( test_uid );
            items_test[i].setItemTypeID( 100 );
            CPPUNIT_ASSERT( insertItem( test_sid, &items_test[i], &iids_test[i] ) == RES_OK );
            items_test[i].setItemID( iids_test[i] );
        }
        //insert test by test256
        for( int i = 0 ; i < MAXITEMS ; i++ ){
            fillItem( __LINE__+i, &items_test256[i] );
            items_test256[i].setContributorUID( test256_uid );
            items_test256[i].setItemTypeID( 100 );
            CPPUNIT_ASSERT( insertItem( test256_sid, &items_test256[i], &iids_test256[i] ) == RES_OK );
            items_test256[i].setItemID( iids_test256[i] );
        }
        c.clearAll();
        CPPUNIT_ASSERT( dumpItemID( test256_sid, &c, &piids, &piidsLen ) == RES_OK );
        CPPUNIT_ASSERT( piidsLen == MAXITEMS );
        freeItemID( piids );
        
        c.clearAll();
        CPPUNIT_ASSERT( dumpItemID( test_sid, &c, &piids, &piidsLen ) == RES_OK );
        CPPUNIT_ASSERT( piidsLen == MAXITEMS );
        freeItemID( piids );
        
        CPPUNIT_ASSERT( dumpItemID( mode_sid, &c, &piids, &piidsLen ) == RES_OK );
        CPPUNIT_ASSERT( piidsLen == MAXITEMS * 2 );
        freeItemID( piids );
        
        //can't retriveve items if not own items.
        CPPUNIT_ASSERT( getItem( test256_sid, iids_test[0], &pitems ) == RES_NO_SUCH_ITEM );
        
        CPPUNIT_ASSERT( getItem( test_sid, iids_test[0], &pitems ) == RES_OK );
        compareItem( &pitems[0], &items_test[0] );
        freeItem( pitems );
        
        CPPUNIT_ASSERT( getItem( mode_sid, iids_test[0], &pitems ) == RES_OK );
        compareItem( &pitems[0], &items_test[0] );
        freeItem( pitems );
        
        c.clearAll( );
        if( DBTYPE == DBTYPE_MYSQL ){
            c.addOrderBy( new orderby( "item_id", orderby::ASC ) );
        }else if( DBTYPE == DBTYPE_SQLITE ){
            c.addOrderBy( new orderby( DBPREFIX "_xnpaccount_item_basic.item_id", orderby::ASC ) );
        }
        CPPUNIT_ASSERT( getItems( test_sid, iids_test, MAXITEMS, &c, &pitems, &pitemsLen ) == RES_OK );
        CPPUNIT_ASSERT( pitemsLen == MAXITEMS );
        for( int i = 0 ; i < MAXITEMS ; i++ ){
            compareItem( &pitems[i], &items_test[i] );
        }
        freeItem( pitems );
        
        CPPUNIT_ASSERT( getItems( test256_sid, iids_test, MAXITEMS, &c, &pitems, &pitemsLen ) == RES_OK );
        CPPUNIT_ASSERT( pitemsLen == 0 );
        freeItem( pitems );
        
        CPPUNIT_ASSERT( getItems( mode_sid, iids_test, MAXITEMS, &c, &pitems, &pitemsLen ) == RES_OK );
        CPPUNIT_ASSERT( pitemsLen == MAXITEMS );
        for( int i = 0 ; i < MAXITEMS ; i++ ){
            compareItem( &pitems[i], &items_test[i] );
        }
        freeItem( pitems );
        
        //register item to index
        CPPUNIT_ASSERT( setConfigValue( "certify_item", "auto" ) == RES_OK ); //change to certify automatic mode
        CPPUNIT_ASSERT( registerItem( test_sid, getGroupIndexByGID( test_sid, test_gid ), iids_test[1] ) == RES_OK );
        CPPUNIT_ASSERT( getCertifyState( test_sid, getGroupIndexByGID( test_sid, test_gid ), iids_test[1], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFIED );
        CPPUNIT_ASSERT( unregisterItem( test_sid, getGroupIndexByGID( test_sid, test_gid ), iids_test[1] ) == RES_OK );
        //change to certify manually mode
        CPPUNIT_ASSERT( setConfigValue( "certify_item", "on" ) == RES_OK );
        //can't register own item to own private index because item has been already registered when inserted.
        CPPUNIT_ASSERT( registerItem( test_sid, getPrivateIndexByUID( test_sid, test_uid ), iids_test[0] ) != RES_OK );
        //can't register own item to other private index (because forbidden operation)
        CPPUNIT_ASSERT( registerItem( test_sid, getPrivateIndexByUID( test_sid, test256_uid ), iids_test[0] ) == RES_NO_WRITE_ACCESS_RIGHT );
        //register own item to group index I'm belong to.
        CPPUNIT_ASSERT( registerItem( test_sid, getGroupIndexByGID( test_sid, test_gid ), iids_test[0] ) == RES_OK );
        CPPUNIT_ASSERT( registerItem( test_sid, getGroupIndexByGID( test_sid, test_gid ), iids_test[1] ) == RES_OK );
        CPPUNIT_ASSERT( registerItem( test256_sid, getGroupIndexByGID( test_sid, test_gid ),    iids_test256[0] ) == RES_OK );
        CPPUNIT_ASSERT( registerItem( test_sid,    getGroupIndexByGID( test_sid, test256_gid ), iids_test[0] ) == RES_NO_WRITE_ACCESS_RIGHT );
        CPPUNIT_ASSERT( registerItem( test256_sid, getGroupIndexByGID( test_sid, test256_gid ), iids_test[0] ) == RES_OK );
        CPPUNIT_ASSERT( registerItem( mode_sid,    getGroupIndexByGID( test_sid, test256_gid ), iids_test[1] ) == RES_OK );
        //register item to public index
        CPPUNIT_ASSERT( registerItem( mode_sid, pub_xid, iids_test[1] ) == RES_OK );
        
        //check certify state
        CPPUNIT_ASSERT( getCertifyState( test_sid, getGroupIndexByGID( test_sid, test_gid ),    iids_test[0], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFY_REQUIRED );
        CPPUNIT_ASSERT( getCertifyState( test_sid, getGroupIndexByGID( test_sid, test_gid ), iids_test[1], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFY_REQUIRED );
        CPPUNIT_ASSERT( getCertifyState( test256_sid, getGroupIndexByGID( test_sid, test256_gid ), iids_test[0], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFY_REQUIRED );
        CPPUNIT_ASSERT( getCertifyState( mode_sid, getGroupIndexByGID( test_sid, test256_gid ), iids_test[1], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFY_REQUIRED );
        CPPUNIT_ASSERT( getCertifyState( mode_sid, pub_xid, iids_test[1], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFY_REQUIRED );
        
        //
        c.clearAll( );
        // ʬΥƥǤСǧξ֤˹餺ǽ
        CPPUNIT_ASSERT( getItemIDByIndexID( test_sid, getGroupIndexByGID( test_sid, test_gid ), &c, &piids, &piidsLen ) == RES_OK );
        CPPUNIT_ASSERT( piidsLen == 2 );
        freeItemID( piids );
        
        //getUncertifiedLink, getPrivateItemID
        {
            const itemid_t* iids;
            const indexid_t* xids;
            int iidsLen;
            CPPUNIT_ASSERT( getUncertifiedLink( test_sid, &xids, &iids, &iidsLen ) == RES_OK );
            CPPUNIT_ASSERT( iidsLen == 0 );
            freeItemID( iids );
            CPPUNIT_ASSERT( getUncertifiedLink( gadmin_sid, &xids, &iids, &iidsLen ) == RES_OK );
            CPPUNIT_ASSERT( iidsLen == 3 );
            freeItemID( iids );
            CPPUNIT_ASSERT( getUncertifiedLink( mode_sid, &xids, &iids, &iidsLen ) == RES_OK );
            CPPUNIT_ASSERT( iidsLen == 6 );
            freeItemID( iids );
            
            CPPUNIT_ASSERT( getPrivateItemID( test_sid, test_uid, &iids, &iidsLen ) == RES_OK );
            CPPUNIT_ASSERT( iidsLen == MAXITEMS );
            freeItemID( iids );
            CPPUNIT_ASSERT( getPrivateItemID( test256_sid, test256_uid, &iids, &iidsLen ) == RES_OK );
            CPPUNIT_ASSERT( iidsLen == MAXITEMS );
            freeItemID( iids );
        }
        //certify item
        CPPUNIT_ASSERT( setCertifyState( test_sid, getGroupIndexByGID( test_sid, test_gid ),    iids_test[0], index::CERTIFIED ) == RES_NO_WRITE_ACCESS_RIGHT );
        CPPUNIT_ASSERT( setCertifyState( test_sid, getGroupIndexByGID( test_sid, test_gid ), iids_test[1], index::CERTIFIED ) == RES_NO_WRITE_ACCESS_RIGHT );
        CPPUNIT_ASSERT( setCertifyState( test256_sid, getGroupIndexByGID( test_sid, test256_gid ), iids_test[0], index::CERTIFIED ) == RES_NO_WRITE_ACCESS_RIGHT );
        CPPUNIT_ASSERT( setCertifyState( mode_sid, getGroupIndexByGID( test_sid, test_gid ),    iids_test[0], index::CERTIFIED ) == RES_OK );
        CPPUNIT_ASSERT( setCertifyState( mode_sid, getGroupIndexByGID( test_sid, test_gid ), iids_test[1], index::CERTIFIED ) == RES_OK );
        CPPUNIT_ASSERT( setCertifyState( mode_sid, getGroupIndexByGID( test_sid, test256_gid ), iids_test[0], index::CERTIFIED ) == RES_OK );
        CPPUNIT_ASSERT( setCertifyState( mode_sid, getGroupIndexByGID( test_sid, test256_gid ), iids_test[1], index::CERTIFIED ) == RES_OK );
        CPPUNIT_ASSERT( setCertifyState( mode_sid, pub_xid, iids_test[1], index::CERTIFIED ) == RES_OK );
        
        //getUncertifiedLink, getPrivateItemID
        {
            const itemid_t* iids;
            const indexid_t* xids;
            int iidsLen;
            CPPUNIT_ASSERT( getUncertifiedLink( gadmin_sid, &xids, &iids, &iidsLen ) == RES_OK );
            CPPUNIT_ASSERT( iidsLen == 1 );
            CPPUNIT_ASSERT( iids[0] == iids_test256[0] );
            freeItemID( iids );
            
            CPPUNIT_ASSERT( getUncertifiedLink( mode_sid, &xids, &iids, &iidsLen ) == RES_OK );
            CPPUNIT_ASSERT( iidsLen == 1 );
            CPPUNIT_ASSERT( iids[0] == iids_test256[0] );
            freeItemID( iids );
            
            CPPUNIT_ASSERT( getPrivateItemID( test_sid, test_uid, &iids, &iidsLen ) == RES_OK );
            CPPUNIT_ASSERT( iidsLen == MAXITEMS - 2 );
            freeItemID( iids );
            CPPUNIT_ASSERT( getPrivateItemID( test256_sid, test256_uid, &iids, &iidsLen ) == RES_OK );
            CPPUNIT_ASSERT( iidsLen == MAXITEMS );
            freeItemID( iids );
        }

        //
        c.clearAll( );
        CPPUNIT_ASSERT( getItemIDByIndexID( test_sid, getGroupIndexByGID( test_sid, test_gid ), &c, &piids, &piidsLen ) == RES_OK );
        CPPUNIT_ASSERT( piidsLen == 2 );
        freeItemID( piids );
        
        //check certify state
        CPPUNIT_ASSERT( getCertifyState( test_sid, getGroupIndexByGID( test_sid, test_gid ),   iids_test[0], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFIED );
        CPPUNIT_ASSERT( getCertifyState( test_sid, getGroupIndexByGID( test_sid, test_gid ), iids_test[1], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFIED );
        CPPUNIT_ASSERT( getCertifyState( test256_sid, getGroupIndexByGID( test_sid, test256_gid ), iids_test[0], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFIED );
        CPPUNIT_ASSERT( getCertifyState( mode_sid, getGroupIndexByGID( test_sid, test256_gid ), iids_test[1], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFIED );
        CPPUNIT_ASSERT( getCertifyState( mode_sid, pub_xid, iids_test[1], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFIED );
        
        //try to retrieve public index by guest
        // if public_item_target_user is 'all'
        CPPUNIT_ASSERT( setConfigValue( XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_KEY, XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_ALL ) == RES_OK );
        CPPUNIT_ASSERT( isValidSessionID( session_t::SID_GUEST ) );
        c.clearAll( );
        CPPUNIT_ASSERT( getItemIDByIndexID( session_t::SID_GUEST, pub_xid, &c, &piids, &piidsLen ) == RES_OK );
        CPPUNIT_ASSERT( piids[0] == iids_test[1] );
        CPPUNIT_ASSERT( piidsLen == 1 );
        CPPUNIT_ASSERT( getItem( session_t::SID_GUEST, piids[0], &pitems ) == RES_OK );
        freeItem( pitems );
        freeItemID( piids );
        // if public_item_target_user is 'platform'
        CPPUNIT_ASSERT( setConfigValue( XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_KEY, XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_PLATFORM ) == RES_OK );
        CPPUNIT_ASSERT( !isValidSessionID( session_t::SID_GUEST ) );
        c.clearAll( );
        CPPUNIT_ASSERT( getItemIDByIndexID( session_t::SID_GUEST, pub_xid, &c, &piids, &piidsLen ) != RES_OK );
        
        //reset certify state
        CPPUNIT_ASSERT( setCertifyState( mode_sid, getGroupIndexByGID( test_sid, test_gid ),    iids_test[0], index::NOT_CERTIFIED ) == RES_OK );
        CPPUNIT_ASSERT( setCertifyState( mode_sid, getGroupIndexByGID( test_sid, test_gid ), iids_test[1], index::NOT_CERTIFIED ) == RES_OK );
        CPPUNIT_ASSERT( setCertifyState( mode_sid, getGroupIndexByGID( test_sid, test256_gid ), iids_test[0], index::NOT_CERTIFIED ) == RES_OK );
        CPPUNIT_ASSERT( setCertifyState( mode_sid, getGroupIndexByGID( test_sid, test256_gid ), iids_test[1], index::NOT_CERTIFIED ) == RES_OK );
        
        //update test by test
        fillItem( __LINE__, &items_test[0] );
        items_test[0].setItemID( iids_test[0] );
        items_test[0].setContributorUID( test_uid );
        CPPUNIT_ASSERT( updateItem( test256_sid, &items_test[0] ) == RES_NO_WRITE_ACCESS_RIGHT );
        //change to certify automatic mode
        CPPUNIT_ASSERT( setConfigValue( "certify_item", "auto" ) == RES_OK );
        CPPUNIT_ASSERT( updateItem( test_sid, &items_test[0] ) == RES_OK );
        CPPUNIT_ASSERT( updateItem( test_sid, &items_test[1] ) == RES_OK );
        //check certify state
        CPPUNIT_ASSERT( getCertifyState( test_sid, getGroupIndexByGID( test_sid, test_gid ),   iids_test[0], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFIED );
        CPPUNIT_ASSERT( getCertifyState( test_sid, getGroupIndexByGID( test_sid, test_gid ), iids_test[1], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFIED );
        CPPUNIT_ASSERT( getCertifyState( test256_sid, getGroupIndexByGID( test_sid, test256_gid ), iids_test[0], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFIED );
        CPPUNIT_ASSERT( getCertifyState( mode_sid, getGroupIndexByGID( test_sid, test256_gid ), iids_test[1], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFIED );
        //change to certify manually mode
        CPPUNIT_ASSERT( setConfigValue( "certify_item", "on" ) == RES_OK );
        CPPUNIT_ASSERT( updateItem( test_sid, &items_test[0] ) == RES_OK );
        CPPUNIT_ASSERT( updateItem( test_sid, &items_test[1] ) == RES_OK );
        //check certify state
        CPPUNIT_ASSERT( getCertifyState( test_sid, getGroupIndexByGID( test_sid, test_gid ), iids_test[0], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFY_REQUIRED );
        CPPUNIT_ASSERT( getCertifyState( test_sid, getGroupIndexByGID( test_sid, test_gid ), iids_test[1], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFY_REQUIRED );
        CPPUNIT_ASSERT( getCertifyState( test256_sid, getGroupIndexByGID( test_sid, test256_gid ), iids_test[0], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFY_REQUIRED );
        CPPUNIT_ASSERT( getCertifyState( mode_sid,    getGroupIndexByGID( test_sid, test256_gid ), iids_test[1], &state ) == RES_OK );
        CPPUNIT_ASSERT( state == index::CERTIFY_REQUIRED );
        
//        CPPUNIT_ASSERT( false );
        
        //unregister item to index
//        CPPUNIT_ASSERT( unregisterItem( test_sid, getPrivateIndexByUID( test_sid, test_uid ),       iids_test[0] ) == RES_OK );
        CPPUNIT_ASSERT( unregisterItem( test_sid, getPrivateIndexByUID( test256_sid, test256_uid ), iids_test[0] ) == RES_NO_WRITE_ACCESS_RIGHT );
        CPPUNIT_ASSERT( unregisterItem( test_sid,    getGroupIndexByGID( test_sid, test_gid ),    iids_test[0] ) == RES_OK );
        CPPUNIT_ASSERT( unregisterItem( test256_sid, getGroupIndexByGID( test_sid, test_gid ),    iids_test256[0] ) == RES_OK );
        CPPUNIT_ASSERT( unregisterItem( test_sid,    getGroupIndexByGID( test_sid, test256_gid ), iids_test[0] ) == RES_NO_WRITE_ACCESS_RIGHT );
        CPPUNIT_ASSERT( unregisterItem( test256_sid, getGroupIndexByGID( test_sid, test256_gid ), iids_test[0] ) == RES_OK );
        CPPUNIT_ASSERT( unregisterItem( gadmin_sid,  getGroupIndexByGID( test_sid, test_gid ),    iids_test[1] ) == RES_OK );
        CPPUNIT_ASSERT( unregisterItem( gadmin_sid,  getGroupIndexByGID( test_sid, test256_gid ), iids_test[1] ) == RES_NO_WRITE_ACCESS_RIGHT );
        CPPUNIT_ASSERT( unregisterItem( mode_sid,    getGroupIndexByGID( test_sid, test256_gid ), iids_test[1] ) == RES_OK );
        return;//
        //delete test by test
        for( int i = 0 ; i < MAXITEMS ; i++ ){
            CPPUNIT_ASSERT( deleteItem( test256_sid, iids_test[i] ) == RES_NO_WRITE_ACCESS_RIGHT );
            CPPUNIT_ASSERT( deleteItem( test_sid, iids_test[i] ) == RES_OK );
        }
        CPPUNIT_ASSERT( getItems( test_sid, iids_test, MAXITEMS, &c, &pitems, &pitemsLen ) == RES_OK );
        CPPUNIT_ASSERT( pitemsLen == 0 );
        freeItem( pitems );
        //delete test by moderator
        for( int i = 0 ; i < MAXITEMS ; i++ ){
            fillItem( __LINE__+i, &items_test[i] );
            items_test[i].setContributorUID( test_uid );
            CPPUNIT_ASSERT( insertItem( test_sid, &items_test[i], &iids_test[i] ) == RES_OK );
            items_test[i].setItemID( iids_test[i] );
        }
        for( int i = 0 ; i < MAXITEMS ; i++ ){
            CPPUNIT_ASSERT( deleteItem( mode_sid, iids_test[i] ) == RES_OK );
        }
        CPPUNIT_ASSERT( getItems( test_sid, iids_test, MAXITEMS, &c, &pitems, &pitemsLen ) == RES_OK );
        CPPUNIT_ASSERT( pitemsLen == 0 );
        freeItem( pitems );
        
        //delete group
        CPPUNIT_ASSERT( deleteGroup( test_sid, test_gid ) == RES_OK );
        CPPUNIT_ASSERT( deleteGroup( test_sid, test256_gid ) == RES_OK );
        
        //delete index
        CPPUNIT_ASSERT( deleteIndex( mode_sid, pub_xid ) == RES_OK );

        //logout test users
        logoutUser( test_sid );
        logoutUser( test256_sid );
        logoutUser( gadmin_sid );
        
        //delete account
        CPPUNIT_ASSERT( deleteAccount( testuser_sid, test_uid ) == RES_OK );
        CPPUNIT_ASSERT( deleteAccount( testuser_sid, test256_uid ) == RES_OK );
        CPPUNIT_ASSERT( deleteAccount( testuser_sid, gadmin_uid ) == RES_OK );
        
        logoutUser( testuser_sid );
        logoutUser( mode_sid );
        
        CPPUNIT_ASSERT( insertItem( testuser_sid, &items_test[0], &itemid ) == RES_NO_SUCH_SESSION );
        CPPUNIT_ASSERT( updateItem( testuser_sid, &items_test[0] ) == RES_NO_SUCH_SESSION );
        CPPUNIT_ASSERT( deleteItem( testuser_sid, iids_test[0] ) == RES_NO_SUCH_SESSION );
        CPPUNIT_ASSERT( dumpItemID( testuser_sid, &c, &piids, &piidsLen ) == RES_NO_SUCH_SESSION );
        
    }

    void binderTest(){
        itemid_t iids_insert[MAXITEMS]; //itemid 
        item_t items_insert[MAXITEMS];
        itemid_t bids_insert[MAXITEMS]; //binder itemid 
        item_t binders_insert[MAXITEMS];//binder item
        const item_t* pitems;
        int pitemsLen;
        criteria_t c;
        userid_t uid;
        const itemid_t* piids;
        int piidsLen;
        itemid_t itemid;
        const indexid_t* pxids;
        int pxidsLen;
        indexid_t private_xid;
        
        sessionid_t mode_sid; // sid of moderator
        sessionid_t testuser_sid;
        
        sessionid_t test_sid;
        userid_t test_uid;
        account_t test_user;
        
        sessionid_t test256_sid;
        userid_t test256_uid;
        account_t test256_user;
        
        sessionid_t gadmin_sid;
        userid_t gadmin_uid;
        account_t gadmin_user;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK;
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &testuser_sid ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( "moderator", md5str( md5buf, ( unsigned char* )"mode00", 6 ), &mode_sid ) == RES_OK );
        
        fillAccount( __LINE__, &test_user );
        CPPUNIT_ASSERT( insertAccount( testuser_sid, &test_user, &test_uid ) == RES_OK );
        CPPUNIT_ASSERT( activate( testuser_sid, test_uid, true ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( test_user.getUname(), test_user.getPass(), &test_sid ) == RES_OK );
        
        fillAccount( __LINE__, &test256_user );
        CPPUNIT_ASSERT( insertAccount( testuser_sid, &test256_user, &test256_uid ) == RES_OK );
        CPPUNIT_ASSERT( activate( testuser_sid, test256_uid, true ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( test256_user.getUname(), test256_user.getPass(), &test256_sid ) == RES_OK );
        
        fillAccount( __LINE__, &gadmin_user );
        CPPUNIT_ASSERT( insertAccount( testuser_sid, &gadmin_user, &gadmin_uid ) == RES_OK );
        CPPUNIT_ASSERT( activate( testuser_sid, gadmin_uid, true ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( gadmin_user.getUname(), gadmin_user.getPass(), &gadmin_sid ) == RES_OK );
        
        //insert group
        group_t grp;
        groupid_t test_gid;
        groupid_t test256_gid;
        fillGroup( __LINE__, &grp );
        CPPUNIT_ASSERT( insertGroup( test_sid, &grp, &test_gid ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( test_sid, test_gid, test_uid, false ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( test256_sid, test_gid, test256_uid, false ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( gadmin_sid, test_gid, gadmin_uid, true ) == RES_OK );
        fillGroup( __LINE__, &grp );
        CPPUNIT_ASSERT( insertGroup( test256_sid, &grp, &test256_gid ) == RES_OK );
        CPPUNIT_ASSERT( insertMember( test256_sid, test256_gid, test256_uid, false ) == RES_OK );
        
        //insert test by test
        for( int i = 0 ; i < MAXITEMS ; i++ ){
            //insert binders
            fillItem( __LINE__+i, &binders_insert[i] );
            binders_insert[i].setContributorUID( test_uid );
            binders_insert[i].setItemTypeID( item::ITID_BINDER );
            CPPUNIT_ASSERT( insertItem( test_sid, &binders_insert[i], &bids_insert[i] ) == RES_OK );
            binders_insert[i].setItemID( bids_insert[i] );
            //insert items
            fillItem( __LINE__+i, &items_insert[i] );
            items_insert[i].setContributorUID( test_uid );
            items_insert[i].setItemTypeID( 100 );
            CPPUNIT_ASSERT( insertItem( test_sid, &items_insert[i], &iids_insert[i] ) == RES_OK );
            items_insert[i].setItemID( iids_insert[i] );
        }
        
        //update test by test
        for( int i = 0 ; i < MAXITEMS ; i++ ){
            fillItem( __LINE__ + i, &binders_insert[i] );
            binders_insert[i].setItemID( bids_insert[i] );
            binders_insert[i].setContributorUID( test_uid );
            binders_insert[i].setItemTypeID( item::IID_BINDERS );
            CPPUNIT_ASSERT( updateItem( test_sid, &binders_insert[i] ) == RES_OK );
        }
        
        //compare items
        c.clearAll( );
        if( DBTYPE == DBTYPE_MYSQL ){
            c.addOrderBy( new orderby( "item_id", orderby::ASC ) );
        }else if( DBTYPE == DBTYPE_SQLITE ){
            c.addOrderBy( new orderby( DBPREFIX "_xnpaccount_item_basic.item_id", orderby::ASC ) );
        }
        CPPUNIT_ASSERT( getItems( test_sid, piids, piidsLen, &c, &pitems, &pitemsLen ) == RES_OK );
        CPPUNIT_ASSERT( pitemsLen == MAXITEMS );
        for( int i = 0 ; i < MAXITEMS ; i++ ){
            compareItem( &pitems[i], &binders_insert[i] );
        }
        freeItem( pitems );
        freeItemID( piids );
        
        //retister item to binder
        CPPUNIT_ASSERT( registerBinderItem( test_sid, bids_insert[1], iids_insert[0] ) == RES_OK );
        CPPUNIT_ASSERT( registerBinderItem( test_sid, bids_insert[2], iids_insert[0] ) == RES_OK );
        CPPUNIT_ASSERT( registerBinderItem( test_sid, bids_insert[2], iids_insert[1] ) == RES_OK );
        CPPUNIT_ASSERT( registerBinderItem( test256_sid, bids_insert[0], iids_insert[0] ) == RES_NO_WRITE_ACCESS_RIGHT );
        
        CPPUNIT_ASSERT( getItemIDByBinderID( test_sid, bids_insert[0], &c, &piids, &piidsLen ) == RES_OK );
        CPPUNIT_ASSERT( piidsLen == 0 );
        freeItemID( piids );
        CPPUNIT_ASSERT( getItemIDByBinderID( test_sid, bids_insert[1], &c, &piids, &piidsLen ) == RES_OK );
        CPPUNIT_ASSERT( piidsLen == 1 );
        CPPUNIT_ASSERT( piids[0] == iids_insert[0] );
        freeItemID( piids );
        CPPUNIT_ASSERT( getItemIDByBinderID( test_sid, bids_insert[2], &c, &piids, &piidsLen ) == RES_OK );
        CPPUNIT_ASSERT( piidsLen == 2 );
        CPPUNIT_ASSERT( piids[0] == iids_insert[0] );
        CPPUNIT_ASSERT( piids[1] == iids_insert[1] );
        freeItemID( piids );
        
        //delete test by test
        for( int i = 0 ; i < MAXITEMS ; i++ ){
            CPPUNIT_ASSERT( deleteItem( test_sid, bids_insert[i] ) == RES_OK );
        }
        //count items which is belog to binder index keyword
        CPPUNIT_ASSERT( getItemIDByBinderID( test_sid, bids_insert[0], &c, &piids, &piidsLen ) == RES_OK );
        CPPUNIT_ASSERT( piidsLen == 0 );
        freeItemID( piids );
        CPPUNIT_ASSERT( getItemIDByBinderID( test_sid, bids_insert[1], &c, &piids, &piidsLen ) == RES_OK );
        CPPUNIT_ASSERT( piidsLen == 1 );
        freeItemID( piids );
        CPPUNIT_ASSERT( getItemIDByBinderID( test_sid, bids_insert[2], &c, &piids, &piidsLen ) == RES_OK );
        CPPUNIT_ASSERT( piidsLen == 2 );
        freeItemID( piids );
        
        //delete group
        CPPUNIT_ASSERT( deleteGroup( test_sid, test_gid ) == RES_OK );
        CPPUNIT_ASSERT( deleteGroup( test_sid, test256_gid ) == RES_OK );
        
        //logout test users
        logoutUser( test_sid );
        logoutUser( test256_sid );
        logoutUser( gadmin_sid );
        
        //delete account
        CPPUNIT_ASSERT( deleteAccount( testuser_sid, test_uid ) == RES_OK );
        CPPUNIT_ASSERT( deleteAccount( testuser_sid, test256_uid ) == RES_OK );
        CPPUNIT_ASSERT( deleteAccount( testuser_sid, gadmin_uid ) == RES_OK );
        
        logoutUser( testuser_sid );
        logoutUser( mode_sid );
        
        CPPUNIT_ASSERT( getItemIDByIndexID( test_sid, item::IID_BINDERS, &c, &piids, &piidsLen ) == RES_NO_SUCH_SESSION );
    }

    void isAdminTest(){
        CPPUNIT_ASSERT( !isAdmin( 0 ) );
        CPPUNIT_ASSERT( isAdmin( 1 ) );
        CPPUNIT_ASSERT( !isAdmin( 2 ) );
    }

    void changelogTest(){
        itemid_t iids_test[MAXITEMS]; //itemid 
        item_t items_test[MAXITEMS];
        
        sessionid_t mode_sid; // sid of moderator
        sessionid_t testuser_sid;
        
        sessionid_t test_sid;
        userid_t test_uid;
        account_t test_user;
        
        sessionid_t test256_sid;
        userid_t test256_uid;
        account_t test256_user;
        
        const changelog_t* logs;
        int logsLen;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK;
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &testuser_sid ) == RES_OK ); 
        CPPUNIT_ASSERT( loginUser( "moderator", md5str( md5buf, ( unsigned char* )"mode00", 6 ), &mode_sid ) == RES_OK );
        
        fillAccount( __LINE__, &test_user );
        CPPUNIT_ASSERT( insertAccount( testuser_sid, &test_user, &test_uid ) == RES_OK );
        CPPUNIT_ASSERT( activate( testuser_sid, test_uid, true ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( test_user.getUname(), test_user.getPass(), &test_sid ) == RES_OK );
        
        fillAccount( __LINE__, &test256_user );
        CPPUNIT_ASSERT( insertAccount( testuser_sid, &test256_user, &test256_uid ) == RES_OK );
        CPPUNIT_ASSERT( activate( testuser_sid, test256_uid, true ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( test256_user.getUname(), test256_user.getPass(), &test256_sid ) == RES_OK );
        
        //insert test by test
        for( int i = 0 ; i < MAXITEMS ; i++ ){
            fillItem( __LINE__+i, &items_test[i] );
            items_test[i].setContributorUID( test_uid );
            items_test[i].setItemTypeID( 100 );//TODO
            CPPUNIT_ASSERT( insertItem( test_sid, &items_test[i], &iids_test[i] ) == RES_OK );
            items_test[i].setItemID( iids_test[i] );
        }
        
        CPPUNIT_ASSERT( insertChangeLog( test_sid, iids_test[1], "change log of test item 1-1" ) == RES_OK );
        CPPUNIT_ASSERT( insertChangeLog( test_sid, iids_test[2], "change log of test item 2-1" ) == RES_OK );
        CPPUNIT_ASSERT( insertChangeLog( test_sid, iids_test[2], "change log of test item 2-2" ) == RES_OK );
        CPPUNIT_ASSERT( insertChangeLog( test256_sid, iids_test[2], "change log of test item 2-3" ) == RES_NO_WRITE_ACCESS_RIGHT );
        
        CPPUNIT_ASSERT( getChangeLogs( test_sid, iids_test[0], &logs, &logsLen ) == RES_OK );
        CPPUNIT_ASSERT( logsLen == 0 );
        freeChangeLog( logs );
        CPPUNIT_ASSERT( getChangeLogs( test_sid, iids_test[1], &logs, &logsLen ) == RES_OK );
        CPPUNIT_ASSERT( logsLen == 1 );
        CPPUNIT_ASSERT( strcmp( "change log of test item 1-1", logs[0].getLog() ) == 0 );
        freeChangeLog( logs );
        CPPUNIT_ASSERT( getChangeLogs( test_sid, iids_test[2], &logs, &logsLen ) == RES_OK );
        CPPUNIT_ASSERT( logsLen == 2 );
        CPPUNIT_ASSERT( strcmp( "change log of test item 2-2", logs[0].getLog() ) == 0 ); //check the order
        CPPUNIT_ASSERT( strcmp( "change log of test item 2-1", logs[1].getLog() ) == 0 );
        freeChangeLog( logs );
        CPPUNIT_ASSERT( getChangeLogs( test256_sid, iids_test[2], &logs, &logsLen ) == RES_NO_READ_ACCESS_RIGHT );
        
        for( int i = 0 ; i < MAXITEMS ; i++ ){
            CPPUNIT_ASSERT( deleteItem( mode_sid, iids_test[i] ) == RES_OK );
        }
        
        //delete account
        CPPUNIT_ASSERT( deleteAccount( testuser_sid, test_uid ) == RES_OK );
        CPPUNIT_ASSERT( deleteAccount( testuser_sid, test256_uid ) == RES_OK );
        
        logoutUser( testuser_sid );
        logoutUser( mode_sid );
    }
    
    void zipTest(){
        char* files[] = { "commonal_cppunit.cc", "../commonal.cc", "../commonal.h" };
        CPPUNIT_ASSERT( zipCreate( "./zipped.zip", files, 3 ) == RES_OK );
    }
    
    void pubmedTest( ){
        const pubmed_t* p;
        CPPUNIT_ASSERT( pubmedComplete( 0, &p ) == RES_OK );
        CPPUNIT_ASSERT( pubmedComplete( 12598621, &p ) == RES_OK );
        
        printf( "'%d'\n"
                "'%s'\n"
                "'%s'\n"
                "'%s'\n"
                "'%d'\n"
                "'%d'\n"
                "'%d'\n"
                "'%s'\n"
                "'%s'\n", 
                p -> getID( ), 
                p -> getTitle( ), 
                p -> getAuthor( ), 
                p -> getJournal( ), 
                p -> getYearOfPublication( ),
                p -> getVolume( ), 
                p -> getNumber( ), 
                p -> getPage( ), 
                p -> getAbstract( ) );
        freePubmed( p );
    }

    void relatedToTest(){
        sessionid_t mode_sid; // sid of moderator
        
        sessionid_t test256_sid;
        userid_t test256_uid;
        account_t test256_user;
        
        userid_t testuser_uid;
        sessionid_t testuser_sid;
        
        itemid_t* iids = 0;
        int iidsLen;
        char md5buf[ MD5_DIGEST_STRING_LENGTH ];
        
        //backup config
        char* value = 0;
        
        CPPUNIT_ASSERT( initializeDB( ODBC_DSN, "root", "", "cppunit_test", DBPREFIX, DBTYPE ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( "moderator", md5str( md5buf, ( unsigned char* )"mode00", 6 ), &mode_sid ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( "testuser", md5str( md5buf, ( unsigned char* )"hogehoge", 8 ), &testuser_sid ) == RES_OK ); 
        CPPUNIT_ASSERT( getUid( "testuser", &testuser_uid ) == RES_OK );
        
        //create test256 user
        fillAccount( __LINE__, &test256_user );
        CPPUNIT_ASSERT( insertAccount( testuser_sid, &test256_user, &test256_uid ) == RES_OK );
        CPPUNIT_ASSERT( activate( testuser_sid, test256_uid, true ) == RES_OK );
        CPPUNIT_ASSERT( loginUser( test256_user.getUname(), test256_user.getPass(), &test256_sid ) == RES_OK );
        
        //test for guest( session_t::SID_GUEST ) can't modify related to by guest
        CPPUNIT_ASSERT( insertRelatedTo( session_t::SID_GUEST, 1, 11 ) == RES_NO_WRITE_ACCESS_RIGHT );
        
        //insert item
        itemid_t id1, id2, id3;
        item_t i1, i2, i3;
        fillItem( __LINE__, &i1 ); i1.setContributorUID( testuser_uid );
        fillItem( __LINE__, &i2 ); i2.setContributorUID( testuser_uid );
        fillItem( __LINE__, &i3 ); i3.setContributorUID( test256_uid );
        CPPUNIT_ASSERT( insertItem( testuser_sid, &i1, &id1 ) == RES_OK );
        CPPUNIT_ASSERT( insertItem( testuser_sid, &i2, &id2 ) == RES_OK );
        CPPUNIT_ASSERT( insertItem( test256_sid, &i3, &id3 ) == RES_OK );
        
        
        //test for registered user
        // link i1 -> i2(OK), i1 -> i3(NG)
        CPPUNIT_ASSERT( insertRelatedTo( testuser_sid, id1, id2 ) == RES_OK );
        CPPUNIT_ASSERT( insertRelatedTo( testuser_sid, id1, id2 ) == RES_OK );
        CPPUNIT_ASSERT( insertRelatedTo( testuser_sid, id1, id3 ) == RES_NO_WRITE_ACCESS_RIGHT );
        
        //
        CPPUNIT_ASSERT( getRelatedTo( testuser_sid, id1, &iids, &iidsLen ) == RES_OK );
        CPPUNIT_ASSERT( iidsLen == 1 );
        CPPUNIT_ASSERT( iids != 0 );
        CPPUNIT_ASSERT( iids[0] == id2 );
        if( iids != 0 ) freeItemID( iids );
        
        //test for guest( session_t::SID_GUEST ) can't modify related to by guest
        //ȥ桼ϥ󥯤ɲ/Ǥʤ
        CPPUNIT_ASSERT( insertRelatedTo( session_t::SID_GUEST, id1, id2 ) == RES_NO_WRITE_ACCESS_RIGHT );
        CPPUNIT_ASSERT( deleteRelatedTo( session_t::SID_GUEST, id1, id2 ) == RES_NO_WRITE_ACCESS_RIGHT );
        
        //ƥ
        //test256i1κԤǤϤʤΤǡi1ƤȤ󥯾Ǥʤ
        CPPUNIT_ASSERT( deleteRelatedTo( test256_sid, id1, id3 ) == RES_NO_WRITE_ACCESS_RIGHT );
        //testuseri1κԤʤΤǡi1ƤȤ󥯾Ǥ
        CPPUNIT_ASSERT( deleteRelatedTo( testuser_sid, id1, id2 ) == RES_OK );
        CPPUNIT_ASSERT( deleteRelatedTo( testuser_sid, id1, id2 ) == RES_OK );
        CPPUNIT_ASSERT( deleteRelatedTo( testuser_sid, id1, id3 ) == RES_OK );
        CPPUNIT_ASSERT( getRelatedTo( testuser_sid, id1, &iids, &iidsLen ) == RES_OK );
        CPPUNIT_ASSERT( iids != 0 );
        CPPUNIT_ASSERT( iidsLen == 0 );
        if( iids != 0 ) freeItemID( iids );
        
        //register item(i3) to public index & certify the item
        //ƥ(i3)PublicϿƾǧ롥
        CPPUNIT_ASSERT( registerItem( testuser_sid, item_t::IID_PUBLIC, id3 ) == RES_OK );
        CPPUNIT_ASSERT( setCertifyState( mode_sid, item_t::IID_PUBLIC, id3, index::CERTIFIED ) == RES_OK );
        
        //insert/delete ok when item(i3) is open(public)
        //¾ͤΥƥǤPublicʤ顤ΥƥؤΥ󥯤Ǥ
        CPPUNIT_ASSERT( insertRelatedTo( testuser_sid, id1, id3 ) == RES_OK );
        CPPUNIT_ASSERT( getRelatedTo( testuser_sid, id1, &iids, &iidsLen ) == RES_OK );
        CPPUNIT_ASSERT( iids != 0 );
        CPPUNIT_ASSERT( iidsLen == 1 );
        CPPUNIT_ASSERT( iids[0] == id3 );
        if( iids != 0 ) freeItemID( iids );
        CPPUNIT_ASSERT( deleteRelatedTo( testuser_sid, id1, id3 ) == RES_OK );
        
        //
        CPPUNIT_ASSERT( deleteItem( testuser_sid, id1 ) == RES_OK );
        CPPUNIT_ASSERT( deleteItem( testuser_sid, id2 ) == RES_OK );
        CPPUNIT_ASSERT( deleteItem( test256_sid, id3 ) == RES_OK );
        
        CPPUNIT_ASSERT( deleteAccount( testuser_sid, test256_uid ) == RES_OK );

        logoutUser( testuser_sid );
        logoutUser( test256_sid );
        logoutUser( mode_sid );
        
    }

};

int main( void )
{
    useSyslog( true );
    CppUnit::TextUi::TestRunner runner;
    runner.addTest( AbstractLayerTest::suite() );
    runner.run();
    return 0;
}
