-- MySQL dump 9.11
--
-- Host: localhost    Database: youi_xoops
-- ------------------------------------------------------
-- Server version	4.0.21-standard

--
-- Table structure for table `x_avatar`
--

DROP TABLE IF EXISTS x_avatar;
CREATE TABLE x_avatar (
  avatar_id mediumint(8) unsigned NOT NULL auto_increment,
  avatar_file varchar(30) NOT NULL default '',
  avatar_name varchar(100) NOT NULL default '',
  avatar_mimetype varchar(30) NOT NULL default '',
  avatar_created int(10) NOT NULL default '0',
  avatar_display tinyint(1) unsigned NOT NULL default '0',
  avatar_weight smallint(5) unsigned NOT NULL default '0',
  avatar_type char(1) NOT NULL default '',
  PRIMARY KEY  (avatar_id),
  KEY avatar_type (avatar_type,avatar_display)
) TYPE=MyISAM;

--
-- Dumping data for table `x_avatar`
--


--
-- Table structure for table `x_avatar_user_link`
--

DROP TABLE IF EXISTS x_avatar_user_link;
CREATE TABLE x_avatar_user_link (
  avatar_id mediumint(8) unsigned NOT NULL default '0',
  user_id mediumint(8) unsigned NOT NULL default '0',
  KEY avatar_user_id (avatar_id,user_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_avatar_user_link`
--


--
-- Table structure for table `x_banner`
--

DROP TABLE IF EXISTS x_banner;
CREATE TABLE x_banner (
  bid smallint(5) unsigned NOT NULL auto_increment,
  cid tinyint(3) unsigned NOT NULL default '0',
  imptotal mediumint(8) unsigned NOT NULL default '0',
  impmade mediumint(8) unsigned NOT NULL default '0',
  clicks mediumint(8) unsigned NOT NULL default '0',
  imageurl varchar(255) NOT NULL default '',
  clickurl varchar(255) NOT NULL default '',
  date int(10) NOT NULL default '0',
  htmlbanner tinyint(1) NOT NULL default '0',
  htmlcode text NOT NULL,
  PRIMARY KEY  (bid),
  KEY idxbannercid (cid),
  KEY idxbannerbidcid (bid,cid)
) TYPE=MyISAM;

--
-- Dumping data for table `x_banner`
--

INSERT INTO x_banner VALUES (1,1,0,2,0,'https://10.12.60.61/~youi/XooNiPs/images/banners/xoops_banner.gif','http://www.xoops.org/',1008813250,0,'');
INSERT INTO x_banner VALUES (2,1,0,3,0,'https://10.12.60.61/~youi/XooNiPs/images/banners/xoops_banner_2.gif','http://www.xoops.org/',1008813250,0,'');
INSERT INTO x_banner VALUES (3,1,0,1,0,'https://10.12.60.61/~youi/XooNiPs/images/banners/banner.swf','http://www.xoops.org/',1008813250,0,'');

--
-- Table structure for table `x_bannerclient`
--

DROP TABLE IF EXISTS x_bannerclient;
CREATE TABLE x_bannerclient (
  cid smallint(5) unsigned NOT NULL auto_increment,
  name varchar(60) NOT NULL default '',
  contact varchar(60) NOT NULL default '',
  email varchar(60) NOT NULL default '',
  login varchar(10) NOT NULL default '',
  passwd varchar(10) NOT NULL default '',
  extrainfo text NOT NULL,
  PRIMARY KEY  (cid),
  KEY login (login)
) TYPE=MyISAM;

--
-- Dumping data for table `x_bannerclient`
--

INSERT INTO x_bannerclient VALUES (1,'XOOPS','XOOPS Dev Team','webmaster@xoops.org','','','');

--
-- Table structure for table `x_bannerfinish`
--

DROP TABLE IF EXISTS x_bannerfinish;
CREATE TABLE x_bannerfinish (
  bid smallint(5) unsigned NOT NULL auto_increment,
  cid smallint(5) unsigned NOT NULL default '0',
  impressions mediumint(8) unsigned NOT NULL default '0',
  clicks mediumint(8) unsigned NOT NULL default '0',
  datestart int(10) unsigned NOT NULL default '0',
  dateend int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (bid),
  KEY cid (cid)
) TYPE=MyISAM;

--
-- Dumping data for table `x_bannerfinish`
--


--
-- Table structure for table `x_block_module_link`
--

DROP TABLE IF EXISTS x_block_module_link;
CREATE TABLE x_block_module_link (
  block_id mediumint(8) unsigned NOT NULL default '0',
  module_id smallint(5) NOT NULL default '0',
  KEY module_id (module_id),
  KEY block_id (block_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_block_module_link`
--

INSERT INTO x_block_module_link VALUES (1,0);
INSERT INTO x_block_module_link VALUES (2,0);
INSERT INTO x_block_module_link VALUES (3,0);
INSERT INTO x_block_module_link VALUES (4,0);
INSERT INTO x_block_module_link VALUES (5,0);
INSERT INTO x_block_module_link VALUES (6,0);
INSERT INTO x_block_module_link VALUES (7,0);
INSERT INTO x_block_module_link VALUES (8,0);
INSERT INTO x_block_module_link VALUES (9,0);
INSERT INTO x_block_module_link VALUES (10,0);
INSERT INTO x_block_module_link VALUES (11,0);
INSERT INTO x_block_module_link VALUES (12,0);
INSERT INTO x_block_module_link VALUES (13,0);
INSERT INTO x_block_module_link VALUES (14,0);
INSERT INTO x_block_module_link VALUES (15,0);
INSERT INTO x_block_module_link VALUES (16,-1);
INSERT INTO x_block_module_link VALUES (17,0);
INSERT INTO x_block_module_link VALUES (18,0);

--
-- Table structure for table `x_config`
--

DROP TABLE IF EXISTS x_config;
CREATE TABLE x_config (
  conf_id smallint(5) unsigned NOT NULL auto_increment,
  conf_modid smallint(5) unsigned NOT NULL default '0',
  conf_catid smallint(5) unsigned NOT NULL default '0',
  conf_name varchar(25) NOT NULL default '',
  conf_title varchar(30) NOT NULL default '',
  conf_value text NOT NULL,
  conf_desc varchar(30) NOT NULL default '',
  conf_formtype varchar(15) NOT NULL default '',
  conf_valuetype varchar(10) NOT NULL default '',
  conf_order smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (conf_id),
  KEY conf_mod_cat_id (conf_modid,conf_catid)
) TYPE=MyISAM;

--
-- Dumping data for table `x_config`
--

INSERT INTO x_config VALUES (1,0,1,'sitename','_MD_AM_SITENAME','XOOPS Site','_MD_AM_SITENAMEDSC','textbox','text',0);
INSERT INTO x_config VALUES (2,0,1,'slogan','_MD_AM_SLOGAN','Just Use it!','_MD_AM_SLOGANDSC','textbox','text',2);
INSERT INTO x_config VALUES (3,0,1,'language','_MD_AM_LANGUAGE','english','_MD_AM_LANGUAGEDSC','language','other',4);
INSERT INTO x_config VALUES (4,0,1,'startpage','_MD_AM_STARTPAGE','--','_MD_AM_STARTPAGEDSC','startpage','other',6);
INSERT INTO x_config VALUES (5,0,1,'server_TZ','_MD_AM_SERVERTZ','0','_MD_AM_SERVERTZDSC','timezone','float',8);
INSERT INTO x_config VALUES (6,0,1,'default_TZ','_MD_AM_DEFAULTTZ','0','_MD_AM_DEFAULTTZDSC','timezone','float',10);
INSERT INTO x_config VALUES (7,0,1,'theme_set','_MD_AM_DTHEME','default','_MD_AM_DTHEMEDSC','theme','other',12);
INSERT INTO x_config VALUES (8,0,1,'anonymous','_MD_AM_ANONNAME','Anonymous','_MD_AM_ANONNAMEDSC','textbox','text',15);
INSERT INTO x_config VALUES (9,0,1,'gzip_compression','_MD_AM_USEGZIP','0','_MD_AM_USEGZIPDSC','yesno','int',16);
INSERT INTO x_config VALUES (10,0,1,'usercookie','_MD_AM_USERCOOKIE','xoops_user','_MD_AM_USERCOOKIEDSC','textbox','text',18);
INSERT INTO x_config VALUES (11,0,1,'session_expire','_MD_AM_SESSEXPIRE','15','_MD_AM_SESSEXPIREDSC','textbox','int',22);
INSERT INTO x_config VALUES (12,0,1,'banners','_MD_AM_BANNERS','0','_MD_AM_BANNERSDSC','yesno','int',26);
INSERT INTO x_config VALUES (13,0,1,'debug_mode','_MD_AM_DEBUGMODE','0','_MD_AM_DEBUGMODEDSC','select','int',24);
INSERT INTO x_config VALUES (14,0,1,'my_ip','_MD_AM_MYIP','127.0.0.1','_MD_AM_MYIPDSC','textbox','text',29);
INSERT INTO x_config VALUES (15,0,1,'use_ssl','_MD_AM_USESSL','0','_MD_AM_USESSLDSC','yesno','int',30);
INSERT INTO x_config VALUES (16,0,1,'session_name','_MD_AM_SESSNAME','xoops_session','_MD_AM_SESSNAMEDSC','textbox','text',20);
INSERT INTO x_config VALUES (17,0,2,'minpass','_MD_AM_MINPASS','5','_MD_AM_MINPASSDSC','textbox','int',1);
INSERT INTO x_config VALUES (18,0,2,'minuname','_MD_AM_MINUNAME','3','_MD_AM_MINUNAMEDSC','textbox','int',2);
INSERT INTO x_config VALUES (19,0,2,'new_user_notify','_MD_AM_NEWUNOTIFY','1','_MD_AM_NEWUNOTIFYDSC','yesno','int',4);
INSERT INTO x_config VALUES (20,0,2,'new_user_notify_group','_MD_AM_NOTIFYTO','1','_MD_AM_NOTIFYTODSC','group','int',6);
INSERT INTO x_config VALUES (21,0,2,'activation_type','_MD_AM_ACTVTYPE','0','_MD_AM_ACTVTYPEDSC','select','int',8);
INSERT INTO x_config VALUES (22,0,2,'activation_group','_MD_AM_ACTVGROUP','1','_MD_AM_ACTVGROUPDSC','group','int',10);
INSERT INTO x_config VALUES (23,0,2,'uname_test_level','_MD_AM_UNAMELVL','0','_MD_AM_UNAMELVLDSC','select','int',12);
INSERT INTO x_config VALUES (24,0,2,'avatar_allow_upload','_MD_AM_AVATARALLOW','0','_MD_AM_AVATARALWDSC','yesno','int',14);
INSERT INTO x_config VALUES (27,0,2,'avatar_width','_MD_AM_AVATARW','80','_MD_AM_AVATARWDSC','textbox','int',16);
INSERT INTO x_config VALUES (28,0,2,'avatar_height','_MD_AM_AVATARH','80','_MD_AM_AVATARHDSC','textbox','int',18);
INSERT INTO x_config VALUES (29,0,2,'avatar_maxsize','_MD_AM_AVATARMAX','35000','_MD_AM_AVATARMAXDSC','textbox','int',20);
INSERT INTO x_config VALUES (30,0,1,'adminmail','_MD_AM_ADMINML','yuichit@tsubasa.co.jp','_MD_AM_ADMINMLDSC','textbox','text',3);
INSERT INTO x_config VALUES (31,0,2,'self_delete','_MD_AM_SELFDELETE','0','_MD_AM_SELFDELETEDSC','yesno','int',22);
INSERT INTO x_config VALUES (32,0,1,'com_mode','_MD_AM_COMMODE','nest','_MD_AM_COMMODEDSC','select','text',34);
INSERT INTO x_config VALUES (33,0,1,'com_order','_MD_AM_COMORDER','0','_MD_AM_COMORDERDSC','select','int',36);
INSERT INTO x_config VALUES (34,0,2,'bad_unames','_MD_AM_BADUNAMES','a:3:{i:0;s:9:\"webmaster\";i:1;s:6:\"^xoops\";i:2;s:6:\"^admin\";}','_MD_AM_BADUNAMESDSC','textarea','array',24);
INSERT INTO x_config VALUES (35,0,2,'bad_emails','_MD_AM_BADEMAILS','a:1:{i:0;s:10:\"xoops.org$\";}','_MD_AM_BADEMAILSDSC','textarea','array',26);
INSERT INTO x_config VALUES (36,0,2,'maxuname','_MD_AM_MAXUNAME','10','_MD_AM_MAXUNAMEDSC','textbox','int',3);
INSERT INTO x_config VALUES (37,0,1,'bad_ips','_MD_AM_BADIPS','a:1:{i:0;s:9:\"127.0.0.1\";}','_MD_AM_BADIPSDSC','textarea','array',42);
INSERT INTO x_config VALUES (38,0,3,'meta_keywords','_MD_AM_METAKEY','news, technology, headlines, xoops, xoop, nuke, myphpnuke, myphp-nuke, phpnuke, SE, geek, geeks, hacker, hackers, linux, software, download, downloads, free, community, mp3, forum, forums, bulletin, board, boards, bbs, php, survey, poll, polls, kernel, comment, comments, portal, odp, open, source, opensource, FreeSoftware, gnu, gpl, license, Unix, *nix, mysql, sql, database, databases, web site, weblog, guru, module, modules, theme, themes, cms, content management','_MD_AM_METAKEYDSC','textarea','text',0);
INSERT INTO x_config VALUES (39,0,3,'footer','_MD_AM_FOOTER','Powered by XOOPS 2.0 &copy; 2001-2003 <a href=\"http://www.xoops.org/\" target=\"_blank\">The XOOPS Project</a>','_MD_AM_FOOTERDSC','textarea','text',20);
INSERT INTO x_config VALUES (40,0,4,'censor_enable','_MD_AM_DOCENSOR','0','_MD_AM_DOCENSORDSC','yesno','int',0);
INSERT INTO x_config VALUES (41,0,4,'censor_words','_MD_AM_CENSORWRD','a:2:{i:0;s:4:\"fuck\";i:1;s:4:\"shit\";}','_MD_AM_CENSORWRDDSC','textarea','array',1);
INSERT INTO x_config VALUES (42,0,4,'censor_replace','_MD_AM_CENSORRPLC','#OOPS#','_MD_AM_CENSORRPLCDSC','textbox','text',2);
INSERT INTO x_config VALUES (43,0,3,'meta_robots','_MD_AM_METAROBOTS','index,follow','_MD_AM_METAROBOTSDSC','select','text',2);
INSERT INTO x_config VALUES (44,0,5,'enable_search','_MD_AM_DOSEARCH','1','_MD_AM_DOSEARCHDSC','yesno','int',0);
INSERT INTO x_config VALUES (45,0,5,'keyword_min','_MD_AM_MINSEARCH','5','_MD_AM_MINSEARCHDSC','textbox','int',1);
INSERT INTO x_config VALUES (46,0,2,'avatar_minposts','_MD_AM_AVATARMP','0','_MD_AM_AVATARMPDSC','textbox','int',15);
INSERT INTO x_config VALUES (47,0,1,'enable_badips','_MD_AM_DOBADIPS','0','_MD_AM_DOBADIPSDSC','yesno','int',40);
INSERT INTO x_config VALUES (48,0,3,'meta_rating','_MD_AM_METARATING','general','_MD_AM_METARATINGDSC','select','text',4);
INSERT INTO x_config VALUES (49,0,3,'meta_author','_MD_AM_METAAUTHOR','XOOPS','_MD_AM_METAAUTHORDSC','textbox','text',6);
INSERT INTO x_config VALUES (50,0,3,'meta_copyright','_MD_AM_METACOPYR','Copyright &copy; 2001-2003','_MD_AM_METACOPYRDSC','textbox','text',8);
INSERT INTO x_config VALUES (51,0,3,'meta_description','_MD_AM_METADESC','XOOPS is a dynamic Object Oriented based open source portal script written in PHP.','_MD_AM_METADESCDSC','textarea','text',1);
INSERT INTO x_config VALUES (52,0,2,'allow_chgmail','_MD_AM_ALLWCHGMAIL','0','_MD_AM_ALLWCHGMAILDSC','yesno','int',3);
INSERT INTO x_config VALUES (53,0,1,'use_mysession','_MD_AM_USEMYSESS','0','_MD_AM_USEMYSESSDSC','yesno','int',19);
INSERT INTO x_config VALUES (54,0,2,'reg_dispdsclmr','_MD_AM_DSPDSCLMR','1','_MD_AM_DSPDSCLMRDSC','yesno','int',30);
INSERT INTO x_config VALUES (55,0,2,'reg_disclaimer','_MD_AM_REGDSCLMR','While the administrators and moderators of this site will attempt to remove\r\nor edit any generally objectionable material as quickly as possible, it is\r\nimpossible to review every message. Therefore you acknowledge that all posts\r\nmade to this site express the views and opinions of the author and not the\r\nadministrators, moderators or webmaster (except for posts by these people)\r\nand hence will not be held liable. \r\n\r\nYou agree not to post any abusive, obscene, vulgar, slanderous, hateful,\r\nthreatening, sexually-orientated or any other material that may violate any\r\napplicable laws. Doing so may lead to you being immediately and permanently\r\nbanned (and your service provider being informed). The IP address of all\r\nposts is recorded to aid in enforcing these conditions. Creating multiple\r\naccounts for a single user is not allowed. You agree that the webmaster,\r\nadministrator and moderators of this site have the right to remove, edit,\r\nmove or close any topic at any time should they see fit. As a user you agree\r\nto any information you have entered above being stored in a database. While\r\nthis information will not be disclosed to any third party without your\r\nconsent the webmaster, administrator and moderators cannot be held\r\nresponsible for any hacking attempt that may lead to the data being\r\ncompromised. \r\n\r\nThis site system uses cookies to store information on your local computer.\r\nThese cookies do not contain any of the information you have entered above,\r\nthey serve only to improve your viewing pleasure. The email address is used\r\nonly for confirming your registration details and password (and for sending\r\nnew passwords should you forget your current one). \r\n\r\nBy clicking Register below you agree to be bound by these conditions.','_MD_AM_REGDSCLMRDSC','textarea','text',32);
INSERT INTO x_config VALUES (56,0,2,'allow_register','_MD_AM_ALLOWREG','1','_MD_AM_ALLOWREGDSC','yesno','int',0);
INSERT INTO x_config VALUES (57,0,1,'theme_fromfile','_MD_AM_THEMEFILE','0','_MD_AM_THEMEFILEDSC','yesno','int',13);
INSERT INTO x_config VALUES (58,0,1,'closesite','_MD_AM_CLOSESITE','0','_MD_AM_CLOSESITEDSC','yesno','int',26);
INSERT INTO x_config VALUES (59,0,1,'closesite_okgrp','_MD_AM_CLOSESITEOK','a:1:{i:0;s:1:\"1\";}','_MD_AM_CLOSESITEOKDSC','group_multi','array',27);
INSERT INTO x_config VALUES (60,0,1,'closesite_text','_MD_AM_CLOSESITETXT','The site is currently closed for maintainance. Please come back later.','_MD_AM_CLOSESITETXTDSC','textarea','text',28);
INSERT INTO x_config VALUES (61,0,1,'sslpost_name','_MD_AM_SSLPOST','xoops_ssl','_MD_AM_SSLPOSTDSC','textbox','text',31);
INSERT INTO x_config VALUES (62,0,1,'module_cache','_MD_AM_MODCACHE','a:1:{i:2;s:1:\"0\";}','_MD_AM_MODCACHEDSC','module_cache','array',50);
INSERT INTO x_config VALUES (63,0,1,'template_set','_MD_AM_DTPLSET','default','_MD_AM_DTPLSETDSC','tplset','other',14);
INSERT INTO x_config VALUES (64,0,6,'mailmethod','_MD_AM_MAILERMETHOD','mail','_MD_AM_MAILERMETHODDESC','select','text',4);
INSERT INTO x_config VALUES (65,0,6,'smtphost','_MD_AM_SMTPHOST','a:1:{i:0;s:0:\"\";}','_MD_AM_SMTPHOSTDESC','textarea','array',6);
INSERT INTO x_config VALUES (66,0,6,'smtpuser','_MD_AM_SMTPUSER','','_MD_AM_SMTPUSERDESC','textbox','text',7);
INSERT INTO x_config VALUES (67,0,6,'smtppass','_MD_AM_SMTPPASS','','_MD_AM_SMTPPASSDESC','password','text',8);
INSERT INTO x_config VALUES (68,0,6,'sendmailpath','_MD_AM_SENDMAILPATH','/usr/sbin/sendmail','_MD_AM_SENDMAILPATHDESC','textbox','text',5);
INSERT INTO x_config VALUES (69,0,6,'from','_MD_AM_MAILFROM','','_MD_AM_MAILFROMDESC','textbox','text',1);
INSERT INTO x_config VALUES (70,0,6,'fromname','_MD_AM_MAILFROMNAME','','_MD_AM_MAILFROMNAMEDESC','textbox','text',2);
INSERT INTO x_config VALUES (71,0,1,'sslloginlink','_MD_AM_SSLLINK','https://','_MD_AM_SSLLINKDSC','textbox','text',33);
INSERT INTO x_config VALUES (72,0,1,'theme_set_allowed','_MD_AM_THEMEOK','a:1:{i:0;s:7:\"default\";}','_MD_AM_THEMEOKDSC','theme_multi','array',13);
INSERT INTO x_config VALUES (73,0,6,'fromuid','_MD_AM_MAILFROMUID','1','_MD_AM_MAILFROMUIDDESC','user','int',3);
INSERT INTO x_config VALUES (74,2,0,'dsn','_MI_XOONIPS_CONFIG_DSN','localhost','_MI_XOONIPS_CONFIG_DSN_DESC','textbox','text',0);
INSERT INTO x_config VALUES (75,2,0,'tree_frame_width','_MI_XOONIPS_INDEX_TF_WIDTH','200','_MI_XOONIPS_INDEX_TF_WIDTH_DES','textbox','text',1);
INSERT INTO x_config VALUES (76,2,0,'tree_frame_height','_MI_XOONIPS_INDEX_TF_HEIGHT','300','_MI_XOONIPS_INDEX_TF_HEIGHT_DE','textbox','text',2);

--
-- Table structure for table `x_configcategory`
--

DROP TABLE IF EXISTS x_configcategory;
CREATE TABLE x_configcategory (
  confcat_id smallint(5) unsigned NOT NULL auto_increment,
  confcat_name varchar(25) NOT NULL default '',
  confcat_order smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (confcat_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_configcategory`
--

INSERT INTO x_configcategory VALUES (1,'_MD_AM_GENERAL',0);
INSERT INTO x_configcategory VALUES (2,'_MD_AM_USERSETTINGS',0);
INSERT INTO x_configcategory VALUES (3,'_MD_AM_METAFOOTER',0);
INSERT INTO x_configcategory VALUES (4,'_MD_AM_CENSOR',0);
INSERT INTO x_configcategory VALUES (5,'_MD_AM_SEARCH',0);
INSERT INTO x_configcategory VALUES (6,'_MD_AM_MAILER',0);

--
-- Table structure for table `x_configoption`
--

DROP TABLE IF EXISTS x_configoption;
CREATE TABLE x_configoption (
  confop_id mediumint(8) unsigned NOT NULL auto_increment,
  confop_name varchar(255) NOT NULL default '',
  confop_value varchar(255) NOT NULL default '',
  conf_id smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (confop_id),
  KEY conf_id (conf_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_configoption`
--

INSERT INTO x_configoption VALUES (1,'_MD_AM_DEBUGMODE1','1',13);
INSERT INTO x_configoption VALUES (2,'_MD_AM_DEBUGMODE2','2',13);
INSERT INTO x_configoption VALUES (3,'_NESTED','nest',32);
INSERT INTO x_configoption VALUES (4,'_FLAT','flat',32);
INSERT INTO x_configoption VALUES (5,'_THREADED','thread',32);
INSERT INTO x_configoption VALUES (6,'_OLDESTFIRST','0',33);
INSERT INTO x_configoption VALUES (7,'_NEWESTFIRST','1',33);
INSERT INTO x_configoption VALUES (8,'_MD_AM_USERACTV','0',21);
INSERT INTO x_configoption VALUES (9,'_MD_AM_AUTOACTV','1',21);
INSERT INTO x_configoption VALUES (10,'_MD_AM_ADMINACTV','2',21);
INSERT INTO x_configoption VALUES (11,'_MD_AM_STRICT','0',23);
INSERT INTO x_configoption VALUES (12,'_MD_AM_MEDIUM','1',23);
INSERT INTO x_configoption VALUES (13,'_MD_AM_LIGHT','2',23);
INSERT INTO x_configoption VALUES (14,'_MD_AM_DEBUGMODE3','3',13);
INSERT INTO x_configoption VALUES (15,'_MD_AM_INDEXFOLLOW','index,follow',43);
INSERT INTO x_configoption VALUES (16,'_MD_AM_NOINDEXFOLLOW','noindex,follow',43);
INSERT INTO x_configoption VALUES (17,'_MD_AM_INDEXNOFOLLOW','index,nofollow',43);
INSERT INTO x_configoption VALUES (18,'_MD_AM_NOINDEXNOFOLLOW','noindex,nofollow',43);
INSERT INTO x_configoption VALUES (19,'_MD_AM_METAOGEN','general',48);
INSERT INTO x_configoption VALUES (20,'_MD_AM_METAO14YRS','14 years',48);
INSERT INTO x_configoption VALUES (21,'_MD_AM_METAOREST','restricted',48);
INSERT INTO x_configoption VALUES (22,'_MD_AM_METAOMAT','mature',48);
INSERT INTO x_configoption VALUES (23,'_MD_AM_DEBUGMODE0','0',13);
INSERT INTO x_configoption VALUES (24,'PHP mail()','mail',64);
INSERT INTO x_configoption VALUES (25,'sendmail','sendmail',64);
INSERT INTO x_configoption VALUES (26,'SMTP','smtp',64);
INSERT INTO x_configoption VALUES (27,'SMTPAuth','smtpauth',64);

--
-- Table structure for table `x_group_permission`
--

DROP TABLE IF EXISTS x_group_permission;
CREATE TABLE x_group_permission (
  gperm_id int(10) unsigned NOT NULL auto_increment,
  gperm_groupid smallint(5) unsigned NOT NULL default '0',
  gperm_itemid mediumint(8) unsigned NOT NULL default '0',
  gperm_modid mediumint(5) unsigned NOT NULL default '0',
  gperm_name varchar(50) NOT NULL default '',
  PRIMARY KEY  (gperm_id),
  KEY groupid (gperm_groupid),
  KEY itemid (gperm_itemid),
  KEY gperm_modid (gperm_modid,gperm_name(10))
) TYPE=MyISAM;

--
-- Dumping data for table `x_group_permission`
--

INSERT INTO x_group_permission VALUES (1,1,1,1,'module_admin');
INSERT INTO x_group_permission VALUES (2,1,1,1,'module_read');
INSERT INTO x_group_permission VALUES (3,2,1,1,'module_read');
INSERT INTO x_group_permission VALUES (4,3,1,1,'module_read');
INSERT INTO x_group_permission VALUES (5,1,1,1,'system_admin');
INSERT INTO x_group_permission VALUES (6,1,2,1,'system_admin');
INSERT INTO x_group_permission VALUES (7,1,3,1,'system_admin');
INSERT INTO x_group_permission VALUES (8,1,4,1,'system_admin');
INSERT INTO x_group_permission VALUES (9,1,5,1,'system_admin');
INSERT INTO x_group_permission VALUES (10,1,6,1,'system_admin');
INSERT INTO x_group_permission VALUES (11,1,7,1,'system_admin');
INSERT INTO x_group_permission VALUES (12,1,8,1,'system_admin');
INSERT INTO x_group_permission VALUES (13,1,9,1,'system_admin');
INSERT INTO x_group_permission VALUES (14,1,10,1,'system_admin');
INSERT INTO x_group_permission VALUES (15,1,11,1,'system_admin');
INSERT INTO x_group_permission VALUES (16,1,12,1,'system_admin');
INSERT INTO x_group_permission VALUES (17,1,13,1,'system_admin');
INSERT INTO x_group_permission VALUES (18,1,14,1,'system_admin');
INSERT INTO x_group_permission VALUES (19,1,15,1,'system_admin');
INSERT INTO x_group_permission VALUES (20,1,1,1,'block_read');
INSERT INTO x_group_permission VALUES (21,2,1,1,'block_read');
INSERT INTO x_group_permission VALUES (22,3,1,1,'block_read');
INSERT INTO x_group_permission VALUES (23,1,2,1,'block_read');
INSERT INTO x_group_permission VALUES (24,2,2,1,'block_read');
INSERT INTO x_group_permission VALUES (25,3,2,1,'block_read');
INSERT INTO x_group_permission VALUES (26,1,3,1,'block_read');
INSERT INTO x_group_permission VALUES (27,2,3,1,'block_read');
INSERT INTO x_group_permission VALUES (28,3,3,1,'block_read');
INSERT INTO x_group_permission VALUES (29,1,4,1,'block_read');
INSERT INTO x_group_permission VALUES (30,2,4,1,'block_read');
INSERT INTO x_group_permission VALUES (31,3,4,1,'block_read');
INSERT INTO x_group_permission VALUES (32,1,5,1,'block_read');
INSERT INTO x_group_permission VALUES (33,2,5,1,'block_read');
INSERT INTO x_group_permission VALUES (34,3,5,1,'block_read');
INSERT INTO x_group_permission VALUES (35,1,6,1,'block_read');
INSERT INTO x_group_permission VALUES (36,2,6,1,'block_read');
INSERT INTO x_group_permission VALUES (37,3,6,1,'block_read');
INSERT INTO x_group_permission VALUES (38,1,7,1,'block_read');
INSERT INTO x_group_permission VALUES (39,2,7,1,'block_read');
INSERT INTO x_group_permission VALUES (40,3,7,1,'block_read');
INSERT INTO x_group_permission VALUES (41,1,8,1,'block_read');
INSERT INTO x_group_permission VALUES (42,2,8,1,'block_read');
INSERT INTO x_group_permission VALUES (43,3,8,1,'block_read');
INSERT INTO x_group_permission VALUES (44,1,9,1,'block_read');
INSERT INTO x_group_permission VALUES (45,2,9,1,'block_read');
INSERT INTO x_group_permission VALUES (46,3,9,1,'block_read');
INSERT INTO x_group_permission VALUES (47,1,10,1,'block_read');
INSERT INTO x_group_permission VALUES (48,2,10,1,'block_read');
INSERT INTO x_group_permission VALUES (49,3,10,1,'block_read');
INSERT INTO x_group_permission VALUES (50,1,11,1,'block_read');
INSERT INTO x_group_permission VALUES (51,2,11,1,'block_read');
INSERT INTO x_group_permission VALUES (52,3,11,1,'block_read');
INSERT INTO x_group_permission VALUES (53,1,12,1,'block_read');
INSERT INTO x_group_permission VALUES (54,2,12,1,'block_read');
INSERT INTO x_group_permission VALUES (55,3,12,1,'block_read');
INSERT INTO x_group_permission VALUES (56,1,2,1,'module_admin');
INSERT INTO x_group_permission VALUES (57,1,2,1,'module_read');
INSERT INTO x_group_permission VALUES (58,1,13,1,'block_read');
INSERT INTO x_group_permission VALUES (59,1,14,1,'block_read');
INSERT INTO x_group_permission VALUES (60,1,15,1,'block_read');
INSERT INTO x_group_permission VALUES (61,1,16,1,'block_read');
INSERT INTO x_group_permission VALUES (62,1,17,1,'block_read');
INSERT INTO x_group_permission VALUES (63,1,18,1,'block_read');
INSERT INTO x_group_permission VALUES (64,2,2,1,'module_read');
INSERT INTO x_group_permission VALUES (65,2,13,1,'block_read');
INSERT INTO x_group_permission VALUES (66,2,14,1,'block_read');
INSERT INTO x_group_permission VALUES (67,2,15,1,'block_read');
INSERT INTO x_group_permission VALUES (68,2,16,1,'block_read');
INSERT INTO x_group_permission VALUES (69,2,17,1,'block_read');
INSERT INTO x_group_permission VALUES (70,2,18,1,'block_read');
INSERT INTO x_group_permission VALUES (71,4,2,1,'module_read');
INSERT INTO x_group_permission VALUES (72,4,2,1,'module_read');
INSERT INTO x_group_permission VALUES (73,1,3,1,'module_admin');
INSERT INTO x_group_permission VALUES (74,1,3,1,'module_read');
INSERT INTO x_group_permission VALUES (75,2,3,1,'module_read');
INSERT INTO x_group_permission VALUES (76,1,4,1,'module_admin');
INSERT INTO x_group_permission VALUES (77,1,4,1,'module_read');
INSERT INTO x_group_permission VALUES (78,2,4,1,'module_read');
INSERT INTO x_group_permission VALUES (79,1,5,1,'module_admin');
INSERT INTO x_group_permission VALUES (80,1,5,1,'module_read');
INSERT INTO x_group_permission VALUES (81,2,5,1,'module_read');
INSERT INTO x_group_permission VALUES (82,1,6,1,'module_admin');
INSERT INTO x_group_permission VALUES (83,1,6,1,'module_read');
INSERT INTO x_group_permission VALUES (84,2,6,1,'module_read');
INSERT INTO x_group_permission VALUES (85,1,7,1,'module_admin');
INSERT INTO x_group_permission VALUES (86,1,7,1,'module_read');
INSERT INTO x_group_permission VALUES (87,2,7,1,'module_read');
INSERT INTO x_group_permission VALUES (88,1,8,1,'module_admin');
INSERT INTO x_group_permission VALUES (89,1,8,1,'module_read');
INSERT INTO x_group_permission VALUES (90,2,8,1,'module_read');
INSERT INTO x_group_permission VALUES (91,1,9,1,'module_admin');
INSERT INTO x_group_permission VALUES (92,1,9,1,'module_read');
INSERT INTO x_group_permission VALUES (93,2,9,1,'module_read');
INSERT INTO x_group_permission VALUES (94,1,10,1,'module_admin');
INSERT INTO x_group_permission VALUES (95,1,10,1,'module_read');
INSERT INTO x_group_permission VALUES (96,2,10,1,'module_read');

--
-- Table structure for table `x_groups`
--

DROP TABLE IF EXISTS x_groups;
CREATE TABLE x_groups (
  groupid smallint(5) unsigned NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  description text NOT NULL,
  group_type varchar(10) NOT NULL default '',
  PRIMARY KEY  (groupid),
  KEY group_type (group_type)
) TYPE=MyISAM;

--
-- Dumping data for table `x_groups`
--

INSERT INTO x_groups VALUES (1,'Webmasters','Webmasters of this site','Admin');
INSERT INTO x_groups VALUES (2,'Registered Users','Registered Users Group','User');
INSERT INTO x_groups VALUES (3,'Anonymous Users','Anonymous Users Group','Anonymous');
INSERT INTO x_groups VALUES (4,'moderator','platform moderator','');

--
-- Table structure for table `x_groups_users_link`
--

DROP TABLE IF EXISTS x_groups_users_link;
CREATE TABLE x_groups_users_link (
  linkid mediumint(8) unsigned NOT NULL auto_increment,
  groupid smallint(5) unsigned NOT NULL default '0',
  uid mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (linkid),
  KEY groupid_uid (groupid,uid)
) TYPE=MyISAM;

--
-- Dumping data for table `x_groups_users_link`
--

INSERT INTO x_groups_users_link VALUES (1,1,1);
INSERT INTO x_groups_users_link VALUES (2,2,1);

--
-- Table structure for table `x_image`
--

DROP TABLE IF EXISTS x_image;
CREATE TABLE x_image (
  image_id mediumint(8) unsigned NOT NULL auto_increment,
  image_name varchar(30) NOT NULL default '',
  image_nicename varchar(255) NOT NULL default '',
  image_mimetype varchar(30) NOT NULL default '',
  image_created int(10) unsigned NOT NULL default '0',
  image_display tinyint(1) unsigned NOT NULL default '0',
  image_weight smallint(5) unsigned NOT NULL default '0',
  imgcat_id smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (image_id),
  KEY imgcat_id (imgcat_id),
  KEY image_display (image_display)
) TYPE=MyISAM;

--
-- Dumping data for table `x_image`
--


--
-- Table structure for table `x_imagebody`
--

DROP TABLE IF EXISTS x_imagebody;
CREATE TABLE x_imagebody (
  image_id mediumint(8) unsigned NOT NULL default '0',
  image_body mediumblob,
  KEY image_id (image_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_imagebody`
--


--
-- Table structure for table `x_imagecategory`
--

DROP TABLE IF EXISTS x_imagecategory;
CREATE TABLE x_imagecategory (
  imgcat_id smallint(5) unsigned NOT NULL auto_increment,
  imgcat_name varchar(100) NOT NULL default '',
  imgcat_maxsize int(8) unsigned NOT NULL default '0',
  imgcat_maxwidth smallint(3) unsigned NOT NULL default '0',
  imgcat_maxheight smallint(3) unsigned NOT NULL default '0',
  imgcat_display tinyint(1) unsigned NOT NULL default '0',
  imgcat_weight smallint(3) unsigned NOT NULL default '0',
  imgcat_type char(1) NOT NULL default '',
  imgcat_storetype varchar(5) NOT NULL default '',
  PRIMARY KEY  (imgcat_id),
  KEY imgcat_display (imgcat_display)
) TYPE=MyISAM;

--
-- Dumping data for table `x_imagecategory`
--


--
-- Table structure for table `x_imgset`
--

DROP TABLE IF EXISTS x_imgset;
CREATE TABLE x_imgset (
  imgset_id smallint(5) unsigned NOT NULL auto_increment,
  imgset_name varchar(50) NOT NULL default '',
  imgset_refid mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (imgset_id),
  KEY imgset_refid (imgset_refid)
) TYPE=MyISAM;

--
-- Dumping data for table `x_imgset`
--

INSERT INTO x_imgset VALUES (1,'default',0);

--
-- Table structure for table `x_imgset_tplset_link`
--

DROP TABLE IF EXISTS x_imgset_tplset_link;
CREATE TABLE x_imgset_tplset_link (
  imgset_id smallint(5) unsigned NOT NULL default '0',
  tplset_name varchar(50) NOT NULL default '',
  KEY tplset_name (tplset_name(10))
) TYPE=MyISAM;

--
-- Dumping data for table `x_imgset_tplset_link`
--

INSERT INTO x_imgset_tplset_link VALUES (1,'default');

--
-- Table structure for table `x_imgsetimg`
--

DROP TABLE IF EXISTS x_imgsetimg;
CREATE TABLE x_imgsetimg (
  imgsetimg_id mediumint(8) unsigned NOT NULL auto_increment,
  imgsetimg_file varchar(50) NOT NULL default '',
  imgsetimg_body blob NOT NULL,
  imgsetimg_imgset smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (imgsetimg_id),
  KEY imgsetimg_imgset (imgsetimg_imgset)
) TYPE=MyISAM;

--
-- Dumping data for table `x_imgsetimg`
--


--
-- Table structure for table `x_modules`
--

DROP TABLE IF EXISTS x_modules;
CREATE TABLE x_modules (
  mid smallint(5) unsigned NOT NULL auto_increment,
  name varchar(150) NOT NULL default '',
  version smallint(5) unsigned NOT NULL default '100',
  last_update int(10) unsigned NOT NULL default '0',
  weight smallint(3) unsigned NOT NULL default '0',
  isactive tinyint(1) unsigned NOT NULL default '0',
  dirname varchar(25) NOT NULL default '',
  hasmain tinyint(1) unsigned NOT NULL default '0',
  hasadmin tinyint(1) unsigned NOT NULL default '0',
  hassearch tinyint(1) unsigned NOT NULL default '0',
  hasconfig tinyint(1) unsigned NOT NULL default '0',
  hascomments tinyint(1) unsigned NOT NULL default '0',
  hasnotification tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (mid),
  KEY hasmain (hasmain),
  KEY hasadmin (hasadmin),
  KEY hassearch (hassearch),
  KEY hasnotification (hasnotification),
  KEY dirname (dirname),
  KEY name (name(15))
) TYPE=MyISAM;

--
-- Dumping data for table `x_modules`
--

INSERT INTO x_modules VALUES (1,'System',100,1116463932,0,1,'system',0,1,0,0,0,0);
INSERT INTO x_modules VALUES (2,'XooNiPs',100,1116463958,1,1,'xoonips',1,1,0,1,0,0);
INSERT INTO x_modules VALUES (3,'XooNiPs Book Item Type Module',100,1116464909,1,1,'xnpbook',0,0,0,0,0,0);
INSERT INTO x_modules VALUES (4,'XooNiPs Data Item Type Module',100,1116464912,1,1,'xnpdata',0,0,0,0,0,0);
INSERT INTO x_modules VALUES (5,'Platform Dummy Item Type Module',100,1116464915,1,1,'xnpdummy',1,0,0,0,0,0);
INSERT INTO x_modules VALUES (6,'XooNiPs Model Item Type Module',100,1116464917,1,1,'xnpmodel',0,0,0,0,0,0);
INSERT INTO x_modules VALUES (7,'XooNiPs Paper Item Type Module',100,1116464920,1,1,'xnppaper',0,0,0,0,0,0);
INSERT INTO x_modules VALUES (8,'XooNiPs Presentation Item Type Module',100,1116464923,1,1,'xnppresentation',0,0,0,0,0,0);
INSERT INTO x_modules VALUES (9,'XooNiPs Tool Item Type Module',100,1116464926,1,1,'xnptool',0,0,0,0,0,0);
INSERT INTO x_modules VALUES (10,'XooNiPs Url Item Type Module',100,1116464929,1,1,'xnpurl',0,0,0,0,0,0);

--
-- Table structure for table `x_newblocks`
--

DROP TABLE IF EXISTS x_newblocks;
CREATE TABLE x_newblocks (
  bid mediumint(8) unsigned NOT NULL auto_increment,
  mid smallint(5) unsigned NOT NULL default '0',
  func_num tinyint(3) unsigned NOT NULL default '0',
  options varchar(255) NOT NULL default '',
  name varchar(150) NOT NULL default '',
  title varchar(255) NOT NULL default '',
  content text NOT NULL,
  side tinyint(1) unsigned NOT NULL default '0',
  weight smallint(5) unsigned NOT NULL default '0',
  visible tinyint(1) unsigned NOT NULL default '0',
  block_type char(1) NOT NULL default '',
  c_type char(1) NOT NULL default '',
  isactive tinyint(1) unsigned NOT NULL default '0',
  dirname varchar(50) NOT NULL default '',
  func_file varchar(50) NOT NULL default '',
  show_func varchar(50) NOT NULL default '',
  edit_func varchar(50) NOT NULL default '',
  template varchar(50) NOT NULL default '',
  bcachetime int(10) unsigned NOT NULL default '0',
  last_modified int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (bid),
  KEY mid (mid),
  KEY visible (visible),
  KEY isactive_visible_mid (isactive,visible,mid),
  KEY mid_funcnum (mid,func_num)
) TYPE=MyISAM;

--
-- Dumping data for table `x_newblocks`
--

INSERT INTO x_newblocks VALUES (1,1,1,'','User Menu','User Menu','',0,0,1,'S','H',1,'system','system_blocks.php','b_system_user_show','','system_block_user.html',0,1116463932);
INSERT INTO x_newblocks VALUES (2,1,2,'','Login','Login','',0,0,1,'S','H',1,'system','system_blocks.php','b_system_login_show','','system_block_login.html',0,1116463932);
INSERT INTO x_newblocks VALUES (3,1,3,'','Search','Search','',0,0,0,'S','H',1,'system','system_blocks.php','b_system_search_show','','system_block_search.html',0,1116463932);
INSERT INTO x_newblocks VALUES (4,1,4,'','Waiting Contents','Waiting Contents','',0,0,0,'S','H',1,'system','system_blocks.php','b_system_waiting_show','','system_block_waiting.html',0,1116463932);
INSERT INTO x_newblocks VALUES (5,1,5,'','Main Menu','Main Menu','',0,0,1,'S','H',1,'system','system_blocks.php','b_system_main_show','','system_block_mainmenu.html',0,1116463932);
INSERT INTO x_newblocks VALUES (6,1,6,'320|190|s_poweredby.gif|1','Site Info','Site Info','',0,0,0,'S','H',1,'system','system_blocks.php','b_system_info_show','b_system_info_edit','system_block_siteinfo.html',0,1116463932);
INSERT INTO x_newblocks VALUES (7,1,7,'','Who\'s Online','Who\'s Online','',0,0,0,'S','H',1,'system','system_blocks.php','b_system_online_show','','system_block_online.html',0,1116463932);
INSERT INTO x_newblocks VALUES (8,1,8,'10|1','Top Posters','Top Posters','',0,0,0,'S','H',1,'system','system_blocks.php','b_system_topposters_show','b_system_topposters_edit','system_block_topusers.html',0,1116463932);
INSERT INTO x_newblocks VALUES (9,1,9,'10|1','New Members','New Members','',0,0,0,'S','H',1,'system','system_blocks.php','b_system_newmembers_show','b_system_newmembers_edit','system_block_newusers.html',0,1116463932);
INSERT INTO x_newblocks VALUES (10,1,10,'10','Recent Comments','Recent Comments','',0,0,0,'S','H',1,'system','system_blocks.php','b_system_comments_show','b_system_comments_edit','system_block_comments.html',0,1116463932);
INSERT INTO x_newblocks VALUES (11,1,11,'','Notification Options','Notification Options','',0,0,0,'S','H',1,'system','system_blocks.php','b_system_notification_show','','system_block_notification.html',0,1116463932);
INSERT INTO x_newblocks VALUES (12,1,12,'0|80','Themes','Themes','',0,0,0,'S','H',1,'system','system_blocks.php','b_system_themes_show','b_system_themes_edit','system_block_themes.html',0,1116463932);
INSERT INTO x_newblocks VALUES (13,2,1,'','Quick Search','Quick Search','',1,1,1,'M','H',1,'xoonips','xoonips_blocks.php','b_xoonips_quick_search_show','','xoonips_block_quick_search.html',0,1116465702);
INSERT INTO x_newblocks VALUES (14,2,2,'','XooNiPs Moderator Menu','XooNiPs Moderator Menu','',0,3,1,'M','H',1,'xoonips','xoonips_blocks.php','b_xoonips_moderator_show','','xoonips_block_moderator.html',0,1116465706);
INSERT INTO x_newblocks VALUES (15,2,3,'','Index Tree','Index Tree','',1,2,1,'M','H',1,'xoonips','xoonips_blocks.php','b_xoonips_tree_show','','xoonips_block_tree.html',0,1116465699);
INSERT INTO x_newblocks VALUES (16,2,4,'','XooNiPs Login','XooNiPs Login','',0,0,1,'M','H',1,'xoonips','xoonips_blocks.php','b_xoonips_login_show','','xoonips_block_login.html',0,1116464556);
INSERT INTO x_newblocks VALUES (17,2,5,'','XooNiPs User Menu','XooNiPs User Menu','',0,1,1,'M','H',1,'xoonips','xoonips_blocks.php','b_xoonips_user_show','','xoonips_block_user.html',0,1116465685);
INSERT INTO x_newblocks VALUES (18,2,6,'','XooNiPs Group Admin Menu','XooNiPs Group Admin Menu','',0,2,1,'M','H',1,'xoonips','xoonips_blocks.php','b_xoonips_group_show','','xoonips_block_group.html',0,1116465708);

--
-- Table structure for table `x_online`
--

DROP TABLE IF EXISTS x_online;
CREATE TABLE x_online (
  online_uid mediumint(8) unsigned NOT NULL default '0',
  online_uname varchar(25) NOT NULL default '',
  online_updated int(10) unsigned NOT NULL default '0',
  online_module smallint(5) unsigned NOT NULL default '0',
  online_ip varchar(15) NOT NULL default '',
  KEY online_module (online_module)
) TYPE=MyISAM;

--
-- Dumping data for table `x_online`
--


--
-- Table structure for table `x_priv_msgs`
--

DROP TABLE IF EXISTS x_priv_msgs;
CREATE TABLE x_priv_msgs (
  msg_id mediumint(8) unsigned NOT NULL auto_increment,
  msg_image varchar(100) default NULL,
  subject varchar(255) NOT NULL default '',
  from_userid mediumint(8) unsigned NOT NULL default '0',
  to_userid mediumint(8) unsigned NOT NULL default '0',
  msg_time int(10) unsigned NOT NULL default '0',
  msg_text text NOT NULL,
  read_msg tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (msg_id),
  KEY to_userid (to_userid),
  KEY touseridreadmsg (to_userid,read_msg),
  KEY msgidfromuserid (msg_id,from_userid)
) TYPE=MyISAM;

--
-- Dumping data for table `x_priv_msgs`
--


--
-- Table structure for table `x_ranks`
--

DROP TABLE IF EXISTS x_ranks;
CREATE TABLE x_ranks (
  rank_id smallint(5) unsigned NOT NULL auto_increment,
  rank_title varchar(50) NOT NULL default '',
  rank_min mediumint(8) unsigned NOT NULL default '0',
  rank_max mediumint(8) unsigned NOT NULL default '0',
  rank_special tinyint(1) unsigned NOT NULL default '0',
  rank_image varchar(255) default NULL,
  PRIMARY KEY  (rank_id),
  KEY rank_min (rank_min),
  KEY rank_max (rank_max),
  KEY rankminrankmaxranspecial (rank_min,rank_max,rank_special),
  KEY rankspecial (rank_special)
) TYPE=MyISAM;

--
-- Dumping data for table `x_ranks`
--

INSERT INTO x_ranks VALUES (1,'Just popping in',0,20,0,'rank3e632f95e81ca.gif');
INSERT INTO x_ranks VALUES (2,'Not too shy to talk',21,40,0,'rank3dbf8e94a6f72.gif');
INSERT INTO x_ranks VALUES (3,'Quite a regular',41,70,0,'rank3dbf8e9e7d88d.gif');
INSERT INTO x_ranks VALUES (4,'Just can\'t stay away',71,150,0,'rank3dbf8ea81e642.gif');
INSERT INTO x_ranks VALUES (5,'Home away from home',151,10000,0,'rank3dbf8eb1a72e7.gif');
INSERT INTO x_ranks VALUES (6,'Moderator',0,0,1,'rank3dbf8edf15093.gif');
INSERT INTO x_ranks VALUES (7,'Webmaster',0,0,1,'rank3dbf8ee8681cd.gif');

--
-- Table structure for table `x_session`
--

DROP TABLE IF EXISTS x_session;
CREATE TABLE x_session (
  sess_id varchar(32) NOT NULL default '',
  sess_updated int(10) unsigned NOT NULL default '0',
  sess_ip varchar(15) NOT NULL default '',
  sess_data text NOT NULL,
  PRIMARY KEY  (sess_id),
  KEY updated (sess_updated)
) TYPE=MyISAM;

--
-- Dumping data for table `x_session`
--

INSERT INTO x_session VALUES ('296b1ff466591222f41ac8807a13dc2f',1116465721,'10.12.60.63','xoopsUserId|s:1:\"1\";xoopsUserGroups|a:2:{i:0;s:1:\"1\";i:1;s:1:\"2\";}xoopsUserTheme|s:7:\"default\";XNPSID|i:2;');

--
-- Table structure for table `x_smiles`
--

DROP TABLE IF EXISTS x_smiles;
CREATE TABLE x_smiles (
  id smallint(5) unsigned NOT NULL auto_increment,
  code varchar(50) NOT NULL default '',
  smile_url varchar(100) NOT NULL default '',
  emotion varchar(75) NOT NULL default '',
  display tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_smiles`
--

INSERT INTO x_smiles VALUES (1,':-D','smil3dbd4d4e4c4f2.gif','Very Happy',1);
INSERT INTO x_smiles VALUES (2,':-)','smil3dbd4d6422f04.gif','Smile',1);
INSERT INTO x_smiles VALUES (3,':-(','smil3dbd4d75edb5e.gif','Sad',1);
INSERT INTO x_smiles VALUES (4,':-o','smil3dbd4d8676346.gif','Surprised',1);
INSERT INTO x_smiles VALUES (5,':-?','smil3dbd4d99c6eaa.gif','Confused',1);
INSERT INTO x_smiles VALUES (6,'8-)','smil3dbd4daabd491.gif','Cool',1);
INSERT INTO x_smiles VALUES (7,':lol:','smil3dbd4dbc14f3f.gif','Laughing',1);
INSERT INTO x_smiles VALUES (8,':-x','smil3dbd4dcd7b9f4.gif','Mad',1);
INSERT INTO x_smiles VALUES (9,':-P','smil3dbd4ddd6835f.gif','Razz',1);
INSERT INTO x_smiles VALUES (10,':oops:','smil3dbd4df1944ee.gif','Embaressed',0);
INSERT INTO x_smiles VALUES (11,':cry:','smil3dbd4e02c5440.gif','Crying (very sad)',0);
INSERT INTO x_smiles VALUES (12,':evil:','smil3dbd4e1748cc9.gif','Evil or Very Mad',0);
INSERT INTO x_smiles VALUES (13,':roll:','smil3dbd4e29bbcc7.gif','Rolling Eyes',0);
INSERT INTO x_smiles VALUES (14,';-)','smil3dbd4e398ff7b.gif','Wink',0);
INSERT INTO x_smiles VALUES (15,':pint:','smil3dbd4e4c2e742.gif','Another pint of beer',0);
INSERT INTO x_smiles VALUES (16,':hammer:','smil3dbd4e5e7563a.gif','ToolTimes at work',0);
INSERT INTO x_smiles VALUES (17,':idea:','smil3dbd4e7853679.gif','I have an idea',0);

--
-- Table structure for table `x_tplfile`
--

DROP TABLE IF EXISTS x_tplfile;
CREATE TABLE x_tplfile (
  tpl_id mediumint(7) unsigned NOT NULL auto_increment,
  tpl_refid smallint(5) unsigned NOT NULL default '0',
  tpl_module varchar(25) NOT NULL default '',
  tpl_tplset varchar(50) NOT NULL default '',
  tpl_file varchar(50) NOT NULL default '',
  tpl_desc varchar(255) NOT NULL default '',
  tpl_lastmodified int(10) unsigned NOT NULL default '0',
  tpl_lastimported int(10) unsigned NOT NULL default '0',
  tpl_type varchar(20) NOT NULL default '',
  PRIMARY KEY  (tpl_id),
  KEY tpl_refid (tpl_refid,tpl_type),
  KEY tpl_tplset (tpl_tplset,tpl_file(10))
) TYPE=MyISAM;

--
-- Dumping data for table `x_tplfile`
--

INSERT INTO x_tplfile VALUES (1,1,'system','default','system_imagemanager.html','',1116463932,1116463932,'module');
INSERT INTO x_tplfile VALUES (2,1,'system','default','system_imagemanager2.html','',1116463932,1116463932,'module');
INSERT INTO x_tplfile VALUES (3,1,'system','default','system_userinfo.html','',1116463932,1116463932,'module');
INSERT INTO x_tplfile VALUES (4,1,'system','default','system_userform.html','',1116463932,1116463932,'module');
INSERT INTO x_tplfile VALUES (5,1,'system','default','system_rss.html','',1116463932,1116463932,'module');
INSERT INTO x_tplfile VALUES (6,1,'system','default','system_redirect.html','',1116463932,1116463932,'module');
INSERT INTO x_tplfile VALUES (7,1,'system','default','system_comment.html','',1116463932,1116463932,'module');
INSERT INTO x_tplfile VALUES (8,1,'system','default','system_comments_flat.html','',1116463932,1116463932,'module');
INSERT INTO x_tplfile VALUES (9,1,'system','default','system_comments_thread.html','',1116463932,1116463932,'module');
INSERT INTO x_tplfile VALUES (10,1,'system','default','system_comments_nest.html','',1116463932,1116463932,'module');
INSERT INTO x_tplfile VALUES (11,1,'system','default','system_siteclosed.html','',1116463932,1116463932,'module');
INSERT INTO x_tplfile VALUES (12,1,'system','default','system_dummy.html','Dummy template file for holding non-template contents. This should not be edited.',1116463932,1116463932,'module');
INSERT INTO x_tplfile VALUES (13,1,'system','default','system_notification_list.html','',1116463932,1116463932,'module');
INSERT INTO x_tplfile VALUES (14,1,'system','default','system_notification_select.html','',1116463932,1116463932,'module');
INSERT INTO x_tplfile VALUES (15,1,'system','default','system_block_user.html','Shows user block',1116463932,1116463932,'block');
INSERT INTO x_tplfile VALUES (16,2,'system','default','system_block_login.html','Shows login form',1116463932,1116463932,'block');
INSERT INTO x_tplfile VALUES (17,3,'system','default','system_block_search.html','Shows search form block',1116463932,1116463932,'block');
INSERT INTO x_tplfile VALUES (18,4,'system','default','system_block_waiting.html','Shows contents waiting for approval',1116463932,1116463932,'block');
INSERT INTO x_tplfile VALUES (19,5,'system','default','system_block_mainmenu.html','Shows the main navigation menu of the site',1116463932,1116463932,'block');
INSERT INTO x_tplfile VALUES (20,6,'system','default','system_block_siteinfo.html','Shows basic info about the site and a link to Recommend Us pop up window',1116463932,1116463932,'block');
INSERT INTO x_tplfile VALUES (21,7,'system','default','system_block_online.html','Displays users/guests currently online',1116463932,1116463932,'block');
INSERT INTO x_tplfile VALUES (22,8,'system','default','system_block_topusers.html','Top posters',1116463932,1116463932,'block');
INSERT INTO x_tplfile VALUES (23,9,'system','default','system_block_newusers.html','Shows most recent users',1116463932,1116463932,'block');
INSERT INTO x_tplfile VALUES (24,10,'system','default','system_block_comments.html','Shows most recent comments',1116463932,1116463932,'block');
INSERT INTO x_tplfile VALUES (25,11,'system','default','system_block_notification.html','Shows notification options',1116463932,1116463932,'block');
INSERT INTO x_tplfile VALUES (26,12,'system','default','system_block_themes.html','Shows theme selection box',1116463932,1116463932,'block');
INSERT INTO x_tplfile VALUES (27,2,'xoonips','default','xoonips_itemlist.html','item listing',1116463958,0,'module');
INSERT INTO x_tplfile VALUES (28,2,'xoonips','default','xoonips_register.html','register item',1116463959,0,'module');
INSERT INTO x_tplfile VALUES (29,2,'xoonips','default','xoonips_confirm_register.html','confirmation before register',1116463959,0,'module');
INSERT INTO x_tplfile VALUES (30,2,'xoonips','default','xoonips_certify.html','certify items',1116463959,0,'module');
INSERT INTO x_tplfile VALUES (31,2,'xoonips','default','xoonips_edit.html','edit item',1116463959,0,'module');
INSERT INTO x_tplfile VALUES (32,2,'xoonips','default','xoonips_confirm_edit.html','confirm edit item',1116463959,0,'module');
INSERT INTO x_tplfile VALUES (33,2,'xoonips','default','xoonips_detail.html','detail item',1116463959,0,'module');
INSERT INTO x_tplfile VALUES (34,2,'xoonips','default','xoonips_itemselect.html','select item form',1116463960,0,'module');
INSERT INTO x_tplfile VALUES (35,2,'xoonips','default','xoonips_publication_date.html','publication_date form',1116463960,0,'module');
INSERT INTO x_tplfile VALUES (36,2,'xoonips','default','xoonips_publication_year.html','publication_year form',1116463960,0,'module');
INSERT INTO x_tplfile VALUES (37,2,'xoonips','default','xoonips_publication_month.html','publication_month form',1116463960,0,'module');
INSERT INTO x_tplfile VALUES (38,2,'xoonips','default','xoonips_publication_mday.html','publication_mday form',1116463960,0,'module');
INSERT INTO x_tplfile VALUES (39,2,'xoonips','default','xoonips_search_date.html','search_date form',1116463960,0,'module');
INSERT INTO x_tplfile VALUES (40,2,'xoonips','default','xoonips_search_year.html','search_year form',1116463960,0,'module');
INSERT INTO x_tplfile VALUES (41,2,'xoonips','default','xoonips_search_month.html','search_month form',1116463960,0,'module');
INSERT INTO x_tplfile VALUES (42,2,'xoonips','default','xoonips_search_mday.html','search_mday form',1116463961,0,'module');
INSERT INTO x_tplfile VALUES (43,2,'xoonips','default','xoonips_advanced_search.html','advanced search form',1116463961,0,'module');
INSERT INTO x_tplfile VALUES (44,2,'xoonips','default','xoonips_main.html','xoonips main page',1116463961,0,'module');
INSERT INTO x_tplfile VALUES (45,2,'xoonips','default','xoonips_editgroups.html','edit groups',1116463961,0,'module');
INSERT INTO x_tplfile VALUES (46,2,'xoonips','default','xoonips_certifyuser.html','certify user',1116463961,0,'module');
INSERT INTO x_tplfile VALUES (47,2,'xoonips','default','xoonips_editindex.html','edit index page',1116463961,0,'module');
INSERT INTO x_tplfile VALUES (48,2,'xoonips','default','xoonips_main.html','binder test page',1116463962,0,'module');
INSERT INTO x_tplfile VALUES (49,2,'xoonips','default','xoonips_list_block.html','list block',1116463962,0,'module');
INSERT INTO x_tplfile VALUES (50,2,'xoonips','default','xoonips_register_block.html','register block',1116463962,0,'module');
INSERT INTO x_tplfile VALUES (51,2,'xoonips','default','xoonips_detail_block.html','detail block',1116463962,0,'module');
INSERT INTO x_tplfile VALUES (52,2,'xoonips','default','xoonips_confirm_block.html','confirm block',1116463962,0,'module');
INSERT INTO x_tplfile VALUES (53,2,'xoonips','default','xoonips_groupadmin.html','edit group',1116463962,0,'module');
INSERT INTO x_tplfile VALUES (54,2,'xoonips','default','registform.html','register now',1116463962,0,'module');
INSERT INTO x_tplfile VALUES (55,2,'xoonips','default','xoonips_userform.html','lost password',1116463962,0,'module');
INSERT INTO x_tplfile VALUES (56,2,'xoonips','default','xoonips_userinfo.html','account info',1116463963,0,'module');
INSERT INTO x_tplfile VALUES (57,2,'xoonips','default','xoonips_index.html','xoonips module top page',1116463963,0,'module');
INSERT INTO x_tplfile VALUES (58,13,'xoonips','default','xoonips_block_quick_search.html','Shows xoonips quick search block',1116463963,0,'block');
INSERT INTO x_tplfile VALUES (59,14,'xoonips','default','xoonips_block_moderator.html','Shows moderator menu',1116463963,0,'block');
INSERT INTO x_tplfile VALUES (60,15,'xoonips','default','xoonips_block_tree.html','browse block',1116463963,0,'block');
INSERT INTO x_tplfile VALUES (61,16,'xoonips','default','xoonips_block_login.html','Shows xoonips login block',1116463963,0,'block');
INSERT INTO x_tplfile VALUES (62,17,'xoonips','default','xoonips_block_user.html','Shows user menu',1116463963,0,'block');
INSERT INTO x_tplfile VALUES (63,18,'xoonips','default','xoonips_block_group.html','Shows group menu',1116463963,0,'block');
INSERT INTO x_tplfile VALUES (64,3,'xnpbook','default','xnpbook_list_block.html','list block',1116464909,0,'module');
INSERT INTO x_tplfile VALUES (65,3,'xnpbook','default','xnpbook_register_block.html','register block',1116464909,0,'module');
INSERT INTO x_tplfile VALUES (66,3,'xnpbook','default','xnpbook_detail_block.html','detail block',1116464910,0,'module');
INSERT INTO x_tplfile VALUES (67,3,'xnpbook','default','xnpbook_confirm_block.html','confirm block',1116464910,0,'module');
INSERT INTO x_tplfile VALUES (68,3,'xnpbook','default','xnpbook_search_block.html','search block',1116464910,0,'module');
INSERT INTO x_tplfile VALUES (69,4,'xnpdata','default','xnpdata_main.html','data test page',1116464912,0,'module');
INSERT INTO x_tplfile VALUES (70,4,'xnpdata','default','xnpdata_list_block.html','list block',1116464912,0,'module');
INSERT INTO x_tplfile VALUES (71,4,'xnpdata','default','xnpdata_register_block.html','register block',1116464912,0,'module');
INSERT INTO x_tplfile VALUES (72,4,'xnpdata','default','xnpdata_detail_block.html','detail block',1116464913,0,'module');
INSERT INTO x_tplfile VALUES (73,4,'xnpdata','default','xnpdata_confirm_block.html','confirm block',1116464913,0,'module');
INSERT INTO x_tplfile VALUES (74,4,'xnpdata','default','xnpdata_search_block.html','search block',1116464913,0,'module');
INSERT INTO x_tplfile VALUES (75,5,'xnpdummy','default','xnpdummy_main.html','dummy test page',1116464915,0,'module');
INSERT INTO x_tplfile VALUES (76,5,'xnpdummy','default','xnpdummy_list_block.html','list block',1116464915,0,'module');
INSERT INTO x_tplfile VALUES (77,5,'xnpdummy','default','xnpdummy_register_block.html','register block',1116464915,0,'module');
INSERT INTO x_tplfile VALUES (78,5,'xnpdummy','default','xnpdummy_detail_block.html','detail block',1116464915,0,'module');
INSERT INTO x_tplfile VALUES (79,5,'xnpdummy','default','xnpdummy_confirm_block.html','confirm block',1116464916,0,'module');
INSERT INTO x_tplfile VALUES (80,5,'xnpdummy','default','xnpdummy_search_block.html','search block',1116464916,0,'module');
INSERT INTO x_tplfile VALUES (81,6,'xnpmodel','default','xnpmodel_main.html','model test page',1116464917,0,'module');
INSERT INTO x_tplfile VALUES (82,6,'xnpmodel','default','xnpmodel_list_block.html','list block',1116464917,0,'module');
INSERT INTO x_tplfile VALUES (83,6,'xnpmodel','default','xnpmodel_register_block.html','register block',1116464918,0,'module');
INSERT INTO x_tplfile VALUES (84,6,'xnpmodel','default','xnpmodel_detail_block.html','detail block',1116464918,0,'module');
INSERT INTO x_tplfile VALUES (85,6,'xnpmodel','default','xnpmodel_confirm_block.html','confirm block',1116464918,0,'module');
INSERT INTO x_tplfile VALUES (86,6,'xnpmodel','default','xnpmodel_search_block.html','search block',1116464918,0,'module');
INSERT INTO x_tplfile VALUES (87,7,'xnppaper','default','xnppaper_main.html','paper test page',1116464920,0,'module');
INSERT INTO x_tplfile VALUES (88,7,'xnppaper','default','xnppaper_list_block.html','list block',1116464921,0,'module');
INSERT INTO x_tplfile VALUES (89,7,'xnppaper','default','xnppaper_register_block.html','register block',1116464921,0,'module');
INSERT INTO x_tplfile VALUES (90,7,'xnppaper','default','xnppaper_detail_block.html','detail block',1116464921,0,'module');
INSERT INTO x_tplfile VALUES (91,7,'xnppaper','default','xnppaper_confirm_block.html','confirm block',1116464921,0,'module');
INSERT INTO x_tplfile VALUES (92,7,'xnppaper','default','xnppaper_search_block.html','search block',1116464921,0,'module');
INSERT INTO x_tplfile VALUES (93,8,'xnppresentation','default','xnppresentation_main.html','presentation test page',1116464923,0,'module');
INSERT INTO x_tplfile VALUES (94,8,'xnppresentation','default','xnppresentation_list_block.html','list block',1116464923,0,'module');
INSERT INTO x_tplfile VALUES (95,8,'xnppresentation','default','xnppresentation_register_block.html','register block',1116464923,0,'module');
INSERT INTO x_tplfile VALUES (96,8,'xnppresentation','default','xnppresentation_detail_block.html','detail block',1116464924,0,'module');
INSERT INTO x_tplfile VALUES (97,8,'xnppresentation','default','xnppresentation_confirm_block.html','confirm block',1116464924,0,'module');
INSERT INTO x_tplfile VALUES (98,8,'xnppresentation','default','xnppresentation_search_block.html','search block',1116464924,0,'module');
INSERT INTO x_tplfile VALUES (99,9,'xnptool','default','xnptool_list_block.html','list block',1116464926,0,'module');
INSERT INTO x_tplfile VALUES (100,9,'xnptool','default','xnptool_register_block.html','register block',1116464926,0,'module');
INSERT INTO x_tplfile VALUES (101,9,'xnptool','default','xnptool_detail_block.html','detail block',1116464926,0,'module');
INSERT INTO x_tplfile VALUES (102,9,'xnptool','default','xnptool_confirm_block.html','confirm block',1116464927,0,'module');
INSERT INTO x_tplfile VALUES (103,9,'xnptool','default','xnptool_search_block.html','search block',1116464927,0,'module');
INSERT INTO x_tplfile VALUES (104,10,'xnpurl','default','xnpurl_main.html','url test page',1116464929,0,'module');
INSERT INTO x_tplfile VALUES (105,10,'xnpurl','default','xnpurl_list_block.html','list block',1116464929,0,'module');
INSERT INTO x_tplfile VALUES (106,10,'xnpurl','default','xnpurl_register_block.html','register block',1116464929,0,'module');
INSERT INTO x_tplfile VALUES (107,10,'xnpurl','default','xnpurl_detail_block.html','detail block',1116464929,0,'module');
INSERT INTO x_tplfile VALUES (108,10,'xnpurl','default','xnpurl_confirm_block.html','confirm block',1116464929,0,'module');
INSERT INTO x_tplfile VALUES (109,10,'xnpurl','default','xnpurl_search_block.html','search block',1116464929,0,'module');

--
-- Table structure for table `x_tplset`
--

DROP TABLE IF EXISTS x_tplset;
CREATE TABLE x_tplset (
  tplset_id int(7) unsigned NOT NULL auto_increment,
  tplset_name varchar(50) NOT NULL default '',
  tplset_desc varchar(255) NOT NULL default '',
  tplset_credits text NOT NULL,
  tplset_created int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (tplset_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_tplset`
--

INSERT INTO x_tplset VALUES (1,'default','XOOPS Default Template Set','',1116463931);

--
-- Table structure for table `x_tplsource`
--

DROP TABLE IF EXISTS x_tplsource;
CREATE TABLE x_tplsource (
  tpl_id mediumint(7) unsigned NOT NULL default '0',
  tpl_source mediumtext NOT NULL,
  KEY tpl_id (tpl_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_tplsource`
--

INSERT INTO x_tplsource VALUES (1,'<!DOCTYPE html PUBLIC \'//W3C//DTD XHTML 1.0 Transitional//EN\' \'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\'>\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"<{$xoops_langcode}>\" lang=\"<{$xoops_langcode}>\">\r\n<head>\r\n<meta http-equiv=\"content-type\" content=\"text/html; charset=<{$xoops_charset}>\" />\r\n<meta http-equiv=\"content-language\" content=\"<{$xoops_langcode}>\" />\r\n<title><{$sitename}> <{$lang_imgmanager}></title>\r\n<script type=\"text/javascript\">\r\n<!--//\r\nfunction appendCode(addCode) {\r\n	var targetDom = window.opener.xoopsGetElementById(\'<{$target}>\');\r\n	if (targetDom.createTextRange && targetDom.caretPos){\r\n  		var caretPos = targetDom.caretPos;\r\n		caretPos.text = caretPos.text.charAt(caretPos.text.length - 1) \r\n== \' \' ? addCode + \' \' : addCode;  \r\n	} else if (targetDom.getSelection && targetDom.caretPos){\r\n		var caretPos = targetDom.caretPos;\r\n		caretPos.text = caretPos.text.charat(caretPos.text.length - 1)  \r\n== \' \' ? addCode + \' \' : addCode;\r\n	} else {\r\n		targetDom.value = targetDom.value + addCode;\r\n  	}\r\n	window.close();\r\n	return;\r\n}\r\n//-->\r\n</script>\r\n<style type=\"text/css\" media=\"all\">\r\nbody {margin: 0;}\r\nimg {border: 0;}\r\ntable {width: 100%; margin: 0;}\r\na:link {color: #3a76d6; font-weight: bold; background-color: transparent;}\r\na:visited {color: #9eb2d6; font-weight: bold; background-color: transparent;}\r\na:hover {color: #e18a00; background-color: transparent;}\r\ntable td {background-color: white; font-size: 12px; padding: 0; border-width: 0; vertical-align: top; font-family: Verdana, Arial, Helvetica, sans-serif;}\r\ntable#imagenav td {vertical-align: bottom; padding: 5px;}\r\ntable#imagemain td {border-right: 1px solid silver; border-bottom: 1px solid silver; padding: 5px; vertical-align: middle;}\r\ntable#imagemain th {border: 0; background-color: #2F5376; color:white; font-size: 12px; padding: 5px; vertical-align: top; text-align:center; font-family: Verdana, Arial, Helvetica, sans-serif;}\r\ntable#header td {width: 100%; background-color: #2F5376; vertical-align: middle;}\r\ntable#header td#headerbar {border-bottom: 1px solid silver; background-color: #dddddd;}\r\ndiv#pagenav {text-align:center;}\r\ndiv#footer {text-align:right; padding: 5px;}\r\n</style>\r\n</head>\r\n\r\n<body onload=\"window.resizeTo(<{$xsize}>, <{$ysize}>);\">\r\n  <table id=\"header\" cellspacing=\"0\">\r\n    <tr>\r\n      <td><a href=\"<{$xoops_url}>/\"><img src=\"<{$xoops_url}>/images/logo.gif\" width=\"150\" height=\"80\" alt=\"\" /></a></td><td> </td>\r\n    </tr>\r\n    <tr>\r\n      <td id=\"headerbar\" colspan=\"2\"> </td>\r\n    </tr>\r\n  </table>\r\n\r\n  <form action=\"imagemanager.php\" method=\"get\">\r\n    <table cellspacing=\"0\" id=\"imagenav\">\r\n      <tr>\r\n        <td>\r\n          <select name=\"cat_id\" onchange=\"location=\'<{$xoops_url}>/imagemanager.php?target=<{$target}>&cat_id=\'+this.options[this.selectedIndex].value\"><{$cat_options}></select> <input type=\"hidden\" name=\"target\" value=\"<{$target}>\" /><input type=\"submit\" value=\"<{$lang_go}>\" />\r\n        </td>\r\n\r\n        <{if $show_cat > 0}>\r\n        <td align=\"right\"><a href=\"<{$xoops_url}>/imagemanager.php?target=<{$target}>&op=upload&imgcat_id=<{$show_cat}>\"><{$lang_addimage}></a></td>\r\n        <{/if}>\r\n\r\n      </tr>\r\n    </table>\r\n  </form>\r\n\r\n  <{if $image_total > 0}>\r\n\r\n  <table cellspacing=\"0\" id=\"imagemain\">\r\n    <tr>\r\n      <th><{$lang_imagename}></th>\r\n      <th><{$lang_image}></th>\r\n      <th><{$lang_imagemime}></th>\r\n      <th><{$lang_align}></th>\r\n    </tr>\r\n\r\n    <{section name=i loop=$images}>\r\n    <tr align=\"center\">\r\n      <td><input type=\"hidden\" name=\"image_id[]\" value=\"<{$images[i].id}>\" /><{$images[i].nicename}></td>\r\n      <td><img src=\"<{$images[i].src}>\" alt=\"\" /></td>\r\n      <td><{$images[i].mimetype}></td>\r\n      <td><a href=\"#\" onclick=\"javascript:appendCode(\'<{$images[i].lxcode}>\');\"><img src=\"<{$xoops_url}>/images/alignleft.gif\" alt=\"Left\" /></a> <a href=\"#\" onclick=\"javascript:appendCode(\'<{$images[i].xcode}>\');\"><img src=\"<{$xoops_url}>/images/aligncenter.gif\" alt=\"Center\" /></a> <a href=\"#\" onclick=\"javascript:appendCode(\'<{$images[i].rxcode}>\');\"><img src=\"<{$xoops_url}>/images/alignright.gif\" alt=\"Right\" /></a></td>\r\n    </tr>\r\n    <{/section}>\r\n  </table>\r\n\r\n  <{/if}>\r\n\r\n  <div id=\"pagenav\"><{$pagenav}></div>\r\n\r\n  <div id=\"footer\">\r\n    <input value=\"<{$lang_close}>\" type=\"button\" onclick=\"javascript:window.close();\" />\r\n  </div>\r\n\r\n  </body>\r\n</html>');
INSERT INTO x_tplsource VALUES (2,'<!DOCTYPE html PUBLIC \'//W3C//DTD XHTML 1.0 Transitional//EN\' \'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\'>\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"<{$xoops_langcode}>\" lang=\"<{$xoops_langcode}>\">\r\n<head>\r\n<meta http-equiv=\"content-type\" content=\"text/html; charset=<{$xoops_charset}>\" />\r\n<meta http-equiv=\"content-language\" content=\"<{$xoops_langcode}>\" />\r\n<title><{$xoops_sitename}> <{$lang_imgmanager}></title>\r\n<{$image_form.javascript}>\r\n<style type=\"text/css\" media=\"all\">\r\nbody {margin: 0;}\r\nimg {border: 0;}\r\ntable {width: 100%; margin: 0;}\r\na:link {color: #3a76d6; font-weight: bold; background-color: transparent;}\r\na:visited {color: #9eb2d6; font-weight: bold; background-color: transparent;}\r\na:hover {color: #e18a00; background-color: transparent;}\r\ntable td {background-color: white; font-size: 12px; padding: 0; border-width: 0; vertical-align: top; font-family: Verdana, Arial, Helvetica, sans-serif;}\r\ntable#imagenav td {vertical-align: bottom; padding: 5px;}\r\ntd.body {padding: 5px; vertical-align: middle;}\r\ntd.caption {border: 0; background-color: #2F5376; color:white; font-size: 12px; padding: 5px; vertical-align: top; text-align:left; font-family: Verdana, Arial, Helvetica, sans-serif;}\r\ntable#imageform {border: 1px solid silver;}\r\ntable#header td {width: 100%; background-color: #2F5376; vertical-align: middle;}\r\ntable#header td#headerbar {border-bottom: 1px solid silver; background-color: #dddddd;}\r\ndiv#footer {text-align:right; padding: 5px;}\r\n</style>\r\n</head>\r\n\r\n<body onload=\"window.resizeTo(<{$xsize}>, <{$ysize}>);\">\r\n  <table id=\"header\" cellspacing=\"0\">\r\n    <tr>\r\n      <td><a href=\"<{$xoops_url}>/\"><img src=\"<{$xoops_url}>/images/logo.gif\" width=\"150\" height=\"80\" alt=\"\" /></a></td><td> </td>\r\n    </tr>\r\n    <tr>\r\n      <td id=\"headerbar\" colspan=\"2\"> </td>\r\n    </tr>\r\n  </table>\r\n\r\n  <table cellspacing=\"0\" id=\"imagenav\">\r\n    <tr>\r\n      <td align=\"left\"><a href=\"<{$xoops_url}>/imagemanager.php?target=<{$target}>&cat_id=<{$show_cat}>\"><{$lang_imgmanager}></a></td>\r\n    </tr>\r\n  </table>\r\n\r\n  <form name=\"<{$image_form.name}>\" id=\"<{$image_form.name}>\" action=\"<{$image_form.action}>\" method=\"<{$image_form.method}>\" <{$image_form.extra}>>\r\n    <table id=\"imageform\" cellspacing=\"0\">\r\n    <!-- start of form elements loop -->\r\n    <{foreach item=element from=$image_form.elements}>\r\n      <{if $element.hidden != true}>\r\n      <tr valign=\"top\">\r\n        <td class=\"caption\"><{$element.caption}></td>\r\n        <td class=\"body\"><{$element.body}></td>\r\n      </tr>\r\n      <{else}>\r\n      <{$element.body}>\r\n      <{/if}>\r\n    <{/foreach}>\r\n    <!-- end of form elements loop -->\r\n    </table>\r\n  </form>\r\n\r\n\r\n  <div id=\"footer\">\r\n    <input value=\"<{$lang_close}>\" type=\"button\" onclick=\"javascript:window.close();\" />\r\n  </div>\r\n\r\n  </body>\r\n</html>');
INSERT INTO x_tplsource VALUES (3,'<{if $user_ownpage == true}>\r\n\r\n<form name=\"usernav\" action=\"user.php\" method=\"post\">\r\n\r\n<br /><br />\r\n\r\n<table width=\"70%\" align=\"center\" border=\"0\">\r\n  <tr align=\"center\">\r\n    <td><input type=\"button\" value=\"<{$lang_editprofile}>\" onclick=\"location=\'edituser.php\'\" />\r\n    <input type=\"button\" value=\"<{$lang_avatar}>\" onclick=\"location=\'edituser.php?op=avatarform\'\" />\r\n    <input type=\"button\" value=\"<{$lang_inbox}>\" onclick=\"location=\'viewpmsg.php\'\" />\r\n\r\n    <{if $user_candelete == true}>\r\n    <input type=\"button\" value=\"<{$lang_deleteaccount}>\" onclick=\"location=\'user.php?op=delete\'\" />\r\n    <{/if}>\r\n\r\n    <input type=\"button\" value=\"<{$lang_logout}>\" onclick=\"location=\'user.php?op=logout\'\" /></td>\r\n  </tr>\r\n</table>\r\n</form>\r\n\r\n<br /><br />\r\n<{elseif $xoops_isadmin != false}>\r\n\r\n<br /><br />\r\n\r\n<table width=\"70%\" align=\"center\" border=\"0\">\r\n  <tr align=\"center\">\r\n    <td><input type=\"button\" value=\"<{$lang_editprofile}>\" onclick=\"location=\'<{$xoops_url}>/modules/system/admin.php?fct=users&uid=<{$user_uid}>&op=modifyUser\'\" />\r\n    <input type=\"button\" value=\"<{$lang_deleteaccount}>\" onclick=\"location=\'<{$xoops_url}>/modules/system/admin.php?fct=users&op=delUser&uid=<{$user_uid}>\'\" />\r\n  </tr>\r\n</table>\r\n\r\n<br /><br />\r\n<{/if}>\r\n\r\n<table width=\"100%\" border=\"0\" cellspacing=\"5\">\r\n  <tr valign=\"top\">\r\n    <td width=\"50%\">\r\n      <table class=\"outer\" cellpadding=\"4\" cellspacing=\"1\" width=\"100%\">\r\n        <tr>\r\n          <th colspan=\"2\" align=\"center\"><{$lang_allaboutuser}></th>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_avatar}></td>\r\n          <td align=\"center\" class=\"even\"><img src=\"<{$user_avatarurl}>\" alt=\"Avatar\" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td class=\"head\"><{$lang_realname}></td>\r\n          <td align=\"center\" class=\"odd\"><{$user_realname}></td>\r\n        </tr>\r\n        <tr>\r\n          <td class=\"head\"><{$lang_website}></td>\r\n          <td class=\"even\"><{$user_websiteurl}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_email}></td>\r\n          <td class=\"odd\"><{$user_email}></td>\r\n        </tr>\r\n	<tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_privmsg}></td>\r\n          <td class=\"even\"><{$user_pmlink}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_icq}></td>\r\n          <td class=\"odd\"><{$user_icq}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_aim}></td>\r\n          <td class=\"even\"><{$user_aim}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_yim}></td>\r\n          <td class=\"odd\"><{$user_yim}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_msnm}></td>\r\n          <td class=\"even\"><{$user_msnm}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_location}></td>\r\n          <td class=\"odd\"><{$user_location}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_occupation}></td>\r\n          <td class=\"even\"><{$user_occupation}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_interest}></td>\r\n          <td class=\"odd\"><{$user_interest}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_extrainfo}></td>\r\n          <td class=\"even\"><{$user_extrainfo}></td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n    <td width=\"50%\">\r\n      <table class=\"outer\" cellpadding=\"4\" cellspacing=\"1\" width=\"100%\">\r\n        <tr valign=\"top\">\r\n          <th colspan=\"2\" align=\"center\"><{$lang_statistics}></th>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_membersince}></td>\r\n          <td align=\"center\" class=\"even\"><{$user_joindate}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_rank}></td>\r\n          <td align=\"center\" class=\"odd\"><{$user_rankimage}><br /><{$user_ranktitle}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_posts}></td>\r\n          <td align=\"center\" class=\"even\"><{$user_posts}></td>\r\n        </tr>\r\n	<tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_lastlogin}></td>\r\n          <td align=\"center\" class=\"odd\"><{$user_lastlogin}></td>\r\n        </tr>\r\n      </table>\r\n      <br />\r\n      <table class=\"outer\" cellpadding=\"4\" cellspacing=\"1\" width=\"100%\">\r\n        <tr valign=\"top\">\r\n          <th colspan=\"2\" align=\"center\"><{$lang_signature}></th>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"even\"><{$user_signature}></td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n</table>\r\n\r\n<!-- start module search results loop -->\r\n<{foreach item=module from=$modules}>\r\n\r\n<p>\r\n<h4><{$module.name}></h4>\r\n\r\n  <!-- start results item loop -->\r\n  <{foreach item=result from=$module.results}>\r\n\r\n  <img src=\"<{$result.image}>\" alt=\"<{$module.name}>\" /><b><a href=\"<{$result.link}>\"><{$result.title}></a></b><br /><small>(<{$result.time}>)</small><br />\r\n\r\n  <{/foreach}>\r\n  <!-- end results item loop -->\r\n\r\n<{$module.showall_link}>\r\n</p>\r\n\r\n<{/foreach}>\r\n<!-- end module search results loop -->\r\n');
INSERT INTO x_tplsource VALUES (4,'<fieldset style=\"padding: 10px;\">\r\n  <legend style=\"font-weight: bold;\"><{$lang_login}></legend>\r\n  <form action=\"user.php\" method=\"post\">\r\n    <{$lang_username}> <input type=\"text\" name=\"uname\" size=\"26\" maxlength=\"25\" value=\"<{$usercookie}>\" /><br />\r\n    <{$lang_password}> <input type=\"password\" name=\"pass\" size=\"21\" maxlength=\"32\" /><br />\r\n    <input type=\"hidden\" name=\"op\" value=\"login\" />\r\n    <input type=\"hidden\" name=\"xoops_redirect\" value=\"<{$redirect_page}>\" />\r\n    <input type=\"submit\" value=\"<{$lang_login}>\" />\r\n  </form>\r\n  <a name=\"lost\"></a>\r\n  <div><{$lang_notregister}><br /></div>\r\n</fieldset>\r\n\r\n<br />\r\n\r\n<fieldset style=\"padding: 10px;\">\r\n  <legend style=\"font-weight: bold;\"><{$lang_lostpassword}></legend>\r\n  <div><br /><{$lang_noproblem}></div>\r\n  <form action=\"lostpass.php\" method=\"post\">\r\n    <{$lang_youremail}> <input type=\"text\" name=\"email\" size=\"26\" maxlength=\"60\" />&nbsp;&nbsp;<input type=\"hidden\" name=\"op\" value=\"mailpasswd\" /><input type=\"submit\" value=\"<{$lang_sendpassword}>\" />\r\n  </form>\r\n</fieldset>');
INSERT INTO x_tplsource VALUES (5,'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<rss version=\"2.0\">\r\n  <channel>\r\n    <title><{$channel_title}></title>\r\n    <link><{$channel_link}></link>\r\n    <description><{$channel_desc}></description>\r\n    <lastBuildDate><{$channel_lastbuild}></lastBuildDate>\r\n    <docs>http://backend.userland.com/rss/</docs>\r\n    <generator><{$channel_generator}></generator>\r\n    <category><{$channel_category}></category>\r\n    <managingEditor><{$channel_editor}></managingEditor>\r\n    <webMaster><{$channel_webmaster}></webMaster>\r\n    <language><{$channel_language}></language>\r\n    <{if $image_url != \"\"}>\r\n    <image>\r\n      <title><{$channel_title}></title>\r\n      <url><{$image_url}></url>\r\n      <link><{$channel_link}></link>\r\n      <width><{$image_width}></width>\r\n      <height><{$image_height}></height>\r\n    </image>\r\n    <{/if}>\r\n    <{foreach item=item from=$items}>\r\n    <item>\r\n      <title><{$item.title}></title>\r\n      <link><{$item.link}></link>\r\n      <description><{$item.description}></description>\r\n      <pubDate><{$item.pubdate}></pubDate>\r\n      <guid><{$item.guid}></guid>\r\n    </item>\r\n    <{/foreach}>\r\n  </channel>\r\n</rss>');
INSERT INTO x_tplsource VALUES (6,'<html>\r\n<head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=<{$xoops_charset}>\" />\r\n<meta http-equiv=\"Refresh\" content=\"<{$time}>; url=<{$url}>\" />\r\n<title><{$xoops_sitename}></title>\r\n</head>\r\n<body>\r\n<div style=\"text-align:center; background-color: #EBEBEB; border-top: 1px solid #FFFFFF; border-left: 1px solid #FFFFFF; border-right: 1px solid #AAAAAA; border-bottom: 1px solid #AAAAAA; font-weight : bold;\">\r\n  <h4><{$message}></h4>\r\n  <p><{$lang_ifnotreload}></p>\r\n</div>\r\n</body>\r\n</html>');
INSERT INTO x_tplsource VALUES (7,'<!-- start comment post -->\r\n        <tr>\r\n          <td class=\"head\"><a id=\"comment<{$comment.id}>\"></a> <{$comment.poster.uname}></td>\r\n          <td class=\"head\"><div class=\"comDate\"><span class=\"comDateCaption\"><{$lang_posted}>:</span> <{$comment.date_posted}>&nbsp;&nbsp;<span class=\"comDateCaption\"><{$lang_updated}>:</span> <{$comment.date_modified}></div></td>\r\n        </tr>\r\n        <tr>\r\n\r\n          <{if $comment.poster.id != 0}>\r\n\r\n          <td class=\"odd\"><div class=\"comUserRank\"><div class=\"comUserRankText\"><{$comment.poster.rank_title}></div><img class=\"comUserRankImg\" src=\"<{$xoops_upload_url}>/<{$comment.poster.rank_image}>\" alt=\"\" /></div><img class=\"comUserImg\" src=\"<{$xoops_upload_url}>/<{$comment.poster.avatar}>\" alt=\"\" /><div class=\"comUserStat\"><span class=\"comUserStatCaption\"><{$lang_joined}>:</span> <{$comment.poster.regdate}></div><div class=\"comUserStat\"><span class=\"comUserStatCaption\"><{$lang_from}>:</span> <{$comment.poster.from}></div><div class=\"comUserStat\"><span class=\"comUserStatCaption\"><{$lang_posts}>:</span> <{$comment.poster.postnum}></div><div class=\"comUserStatus\"><{$comment.poster.status}></div></td>\r\n\r\n          <{else}>\r\n\r\n          <td class=\"odd\"> </td>\r\n\r\n          <{/if}>\r\n\r\n          <td class=\"odd\">\r\n            <div class=\"comTitle\"><{$comment.image}><{$comment.title}></div><div class=\"comText\"><{$comment.text}></div>\r\n          </td>\r\n        </tr>\r\n        <tr>\r\n          <td class=\"even\"></td>\r\n\r\n          <{if $xoops_iscommentadmin == true}>\r\n\r\n          <td class=\"even\" align=\"right\">\r\n            <a href=\"<{$editcomment_link}>&amp;com_id=<{$comment.id}>\"><img src=\"<{$xoops_url}>/images/icons/edit.gif\" alt=\"<{$lang_edit}>\" /></a><a href=\"<{$deletecomment_link}>&amp;com_id=<{$comment.id}>\"><img src=\"<{$xoops_url}>/images/icons/delete.gif\" alt=\"<{$lang_delete}>\" /></a><a href=\"<{$replycomment_link}>&amp;com_id=<{$comment.id}>\"><img src=\"<{$xoops_url}>/images/icons/reply.gif\" alt=\"<{$lang_reply}>\" /></a>\r\n          </td>\r\n\r\n          <{elseif $xoops_isuser == true && $xoops_userid == $comment.poster.id}>\r\n\r\n          <td class=\"even\" align=\"right\">\r\n            <a href=\"<{$editcomment_link}>&amp;com_id=<{$comment.id}>\"><img src=\"<{$xoops_url}>/images/icons/edit.gif\" alt=\"<{$lang_edit}>\" /></a><a href=\"<{$replycomment_link}>&amp;com_id=<{$comment.id}>\"><img src=\"<{$xoops_url}>/images/icons/reply.gif\" alt=\"<{$lang_reply}>\" /></a>\r\n          </td>\r\n\r\n          <{elseif $xoops_isuser == true || $anon_canpost == true}>\r\n\r\n          <td class=\"even\" align=\"right\">\r\n            <a href=\"<{$replycomment_link}>&amp;com_id=<{$comment.id}>\"><img src=\"<{$xoops_url}>/images/icons/reply.gif\" alt=\"<{$lang_reply}>\" /></a>\r\n          </td>\r\n\r\n          <{else}>\r\n\r\n          <td class=\"even\"> </td>\r\n\r\n          <{/if}>\r\n\r\n        </tr>\r\n<!-- end comment post -->');
INSERT INTO x_tplsource VALUES (8,'<table class=\"outer\" cellpadding=\"5\" cellspacing=\"1\">\r\n  <tr>\r\n    <th width=\"20%\"><{$lang_poster}></td>\r\n    <th><{$lang_thread}></td>\r\n  </tr>\r\n  <{foreach item=comment from=$comments}>\r\n    <{include file=\"db:system_comment.html\" comment=$comment}>\r\n  <{/foreach}>\r\n</table>');
INSERT INTO x_tplsource VALUES (9,'<{section name=i loop=$comments}>\r\n<br />\r\n<table cellspacing=\"1\" class=\"outer\">\r\n  <tr>\r\n    <th width=\"20%\"><{$lang_poster}></th>\r\n    <th><{$lang_thread}></th>\r\n  </tr>\r\n  <{include file=\"db:system_comment.html\" comment=$comments[i]}>\r\n</table>\r\n\r\n<{if $show_threadnav == true}>\r\n<div style=\"text-align:left; margin:3px; padding: 5px;\">\r\n<a href=\"<{$comment_url}>\"><{$lang_top}></a> | <a href=\"<{$comment_url}>&amp;com_id=<{$comments[i].pid}>&amp;com_rootid=<{$comments[i].rootid}>#newscomment<{$comments[i].pid}>\"><{$lang_parent}></a>\r\n</div>\r\n<{/if}>\r\n\r\n<{if $comments[i].show_replies == true}>\r\n<!-- start comment tree -->\r\n<br />\r\n<table cellspacing=\"1\" class=\"outer\">\r\n  <tr>\r\n    <th width=\"50%\"><{$lang_subject}></th>\r\n    <th width=\"20%\" align=\"center\"><{$lang_poster}></th>\r\n    <th align=\"right\"><{$lang_posted}></th>\r\n  </tr>\r\n  <{foreach item=reply from=$comments[i].replies}>\r\n  <tr>\r\n    <td class=\"even\"><{$reply.prefix}> <a href=\"<{$comment_url}>&amp;com_id=<{$reply.id}>&amp;com_rootid=<{$reply.root_id}>\"><{$reply.title}></a></td>\r\n    <td class=\"odd\" align=\"center\"><{$reply.poster.uname}></td>\r\n    <td class=\"even\" align=\"right\"><{$reply.date_posted}></td>\r\n  </tr>\r\n  <{/foreach}>\r\n</table>\r\n<!-- end comment tree -->\r\n<{/if}>\r\n\r\n<{/section}>');
INSERT INTO x_tplsource VALUES (10,'<{section name=i loop=$comments}>\r\n<br />\r\n<table cellspacing=\"1\" class=\"outer\">\r\n  <tr>\r\n    <th width=\"20%\"><{$lang_poster}></th>\r\n    <th><{$lang_thread}></th>\r\n  </tr>\r\n  <{include file=\"db:system_comment.html\" comment=$comments[i]}>\r\n</table>\r\n\r\n<!-- start comment replies -->\r\n<{foreach item=reply from=$comments[i].replies}>\r\n<br />\r\n<table cellspacing=\"0\" border=\"0\">\r\n  <tr>\r\n    <td width=\"<{$reply.prefix}>\"></td>\r\n    <td>\r\n      <table class=\"outer\" cellspacing=\"1\">\r\n        <tr>\r\n          <th width=\"20%\"><{$lang_poster}></th>\r\n          <th><{$lang_thread}></th>\r\n        </tr>\r\n        <{include file=\"db:system_comment.html\" comment=$reply}>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n</table>\r\n<{/foreach}>\r\n<!-- end comment tree -->\r\n<{/section}>');
INSERT INTO x_tplsource VALUES (11,'<!DOCTYPE html PUBLIC \'//W3C//DTD XHTML 1.0 Transitional//EN\' \'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\'>\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"<{$xoops_langcode}>\" lang=\"<{$xoops_langcode}>\">\r\n<head>\r\n<meta http-equiv=\"content-type\" content=\"text/html; charset=<{$xoops_charset}>\" />\r\n<meta http-equiv=\"content-language\" content=\"<{$xoops_langcode}>\" />\r\n<title><{$xoops_sitename}></title>\r\n<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"<{$xoops_url}>/xoops.css\" />\r\n\r\n</head>\r\n<body>\r\n  <table cellspacing=\"0\">\r\n    <tr id=\"header\">\r\n      <td style=\"width: 150px; background-color: #2F5376; vertical-align: middle; text-align:center;\"><a href=\"<{$xoops_url}>/\"><img src=\"<{$xoops_imageurl}>logo.gif\" width=\"150\" alt=\"\" /></a></td>\r\n      <td style=\"width: 100%; background-color: #2F5376; vertical-align: middle; text-align:center;\">&nbsp;</td>\r\n    </tr>\r\n    <tr>\r\n      <td style=\"height: 8px; border-bottom: 1px solid silver; background-color: #dddddd;\" colspan=\"2\">&nbsp;</td>\r\n    </tr>\r\n  </table>\r\n\r\n  <table cellspacing=\"1\" align=\"center\" width=\"80%\" border=\"0\" cellpadding=\"10px;\">\r\n    <tr>\r\n      <td align=\"center\"><div style=\"background-color: #DDFFDF; color: #136C99; text-align: center; border-top: 1px solid #DDDDFF; border-left: 1px solid #DDDDFF; border-right: 1px solid #AAAAAA; border-bottom: 1px solid #AAAAAA; font-weight: bold; padding: 10px;\"><{$lang_siteclosemsg}></div></td>\r\n    </tr>\r\n  </table>\r\n  \r\n  <form action=\"<{$xoops_url}>/user.php\" method=\"post\">\r\n    <table cellspacing=\"0\" align=\"center\" style=\"border: 1px solid silver; width: 200px;\">\r\n      <tr>\r\n        <th style=\"background-color: #2F5376; color: #FFFFFF; padding : 2px; vertical-align : middle;\" colspan=\"2\"><{$lang_login}></th>\r\n      </tr>\r\n      <tr>\r\n        <td style=\"padding: 2px;\"><{$lang_username}></td><td style=\"padding: 2px;\"><input type=\"text\" name=\"uname\" size=\"12\" value=\"\" /></td>\r\n      </tr>\r\n      <tr>\r\n        <td style=\"padding: 2px;\"><{$lang_password}></td><td style=\"padding: 2px;\"><input type=\"password\" name=\"pass\" size=\"12\" /></td>\r\n      </tr>\r\n      <tr>\r\n        <td style=\"padding: 2px;\">&nbsp;</td>\r\n        <td style=\"padding: 2px;\"><input type=\"hidden\" name=\"xoops_login\" value=\"1\" /><input type=\"submit\" value=\"<{$lang_login}>\" /></td>\r\n      </tr>\r\n    </table>\r\n  </form>\r\n\r\n  <table cellspacing=\"0\" width=\"100%\">\r\n    <td style=\"height:8px; border-bottom: 1px solid silver; border-top: 1px solid silver; background-color: #dddddd;\" colspan=\"2\">&nbsp;</td>\r\n  </table>\r\n\r\n  </body>\r\n</html>');
INSERT INTO x_tplsource VALUES (12,'<{$dummy_content}>');
INSERT INTO x_tplsource VALUES (13,'<h4><{$lang_activenotifications}></h4>\r\n<form name=\"notificationlist\" action=\"notifications.php\" method=\"post\">\r\n<table class=\"outer\">\r\n  <tr>\r\n    <th><input name=\"allbox\" id=\"allbox\" onclick=\"xoopsCheckGroup(\'notificationlist\', \'allbox\', \'del_mod[]\');\" type=\"checkbox\" value=\"<{$lang_checkall}>\" /></th>\r\n    <th><{$lang_event}></th>\r\n    <th><{$lang_category}></th>\r\n    <th><{$lang_itemid}></th>\r\n    <th><{$lang_itemname}></th>\r\n  </tr>\r\n  <{foreach item=module from=$modules}>\r\n  <tr>\r\n    <td class=\"head\"><input name=\"del_mod[<{$module.id}>]\" id=\"del_mod[]\" onclick=\"xoopsCheckGroup(\'notificationlist\', \'del_mod[<{$module.id}>]\', \'del_not[<{$module.id}>][]\');\" type=\"checkbox\" value=\"<{$module.id}>\" /></td>\r\n    <td class=\"head\" colspan=\"4\"><{$lang_module}>: <{$module.name}></td>\r\n  </tr>\r\n  <{foreach item=category from=$module.categories}>\r\n  <{foreach item=item from=$category.items}>\r\n  <{foreach item=notification from=$item.notifications}>\r\n  <tr>\r\n    <{cycle values=odd,even assign=class}>\r\n    <td class=\"<{$class}>\"><input type=\"checkbox\" name=\"del_not[<{$module.id}>][]\" id=\"del_not[<{$module.id}>][]\" value=\"<{$notification.id}>\" /></td>\r\n    <td class=\"<{$class}>\"><{$notification.event_title}></td>\r\n    <td class=\"<{$class}>\"><{$notification.category_title}></td>\r\n    <td class=\"<{$class}>\"><{if $item.id != 0}><{$item.id}><{/if}></td>\r\n    <td class=\"<{$class}>\"><{if $item.id != 0}><{if $item.url != \'\'}><a href=\"<{$item.url}>\"><{/if}><{$item.name}><{if $item.url != \'\'}></a><{/if}><{/if}></td>\r\n  </tr>\r\n  <{/foreach}>\r\n  <{/foreach}>\r\n  <{/foreach}>\r\n  <{/foreach}>\r\n  <tr>\r\n    <td class=\"foot\" colspan=\"5\">\r\n      <input type=\"submit\" name=\"delete_cancel\" value=\"<{$lang_cancel}>\" />\r\n      <input type=\"reset\" name=\"delete_reset\" value=\"<{$lang_clear}>\" />\r\n      <input type=\"submit\" name=\"delete\" value=\"<{$lang_delete}>\" />\r\n    </td>\r\n  </tr>\r\n</table>\r\n</form>\r\n');
INSERT INTO x_tplsource VALUES (14,'<{if $xoops_notification.show}>\r\n<form name=\"notification_select\" action=\"<{$xoops_notification.target_page}>\" method=\"post\">\r\n<h4 style=\"text-align:center;\"><{$lang_activenotifications}></h4>\r\n<input type=\"hidden\" name=\"not_redirect\" value=\"<{$xoops_notification.redirect_script}>\" />\r\n<table class=\"outer\">\r\n  <tr><th colspan=\"3\"><{$lang_notificationoptions}></th></tr>\r\n  <tr>\r\n    <td class=\"head\"><{$lang_category}></td>\r\n    <td class=\"head\"><input name=\"allbox\" id=\"allbox\" onclick=\"xoopsCheckAll(\'notification_select\',\'allbox\');\" type=\"checkbox\" value=\"<{$lang_checkall}>\" /></td>\r\n    <td class=\"head\"><{$lang_events}></td>\r\n  </tr>\r\n  <{foreach name=outer item=category from=$xoops_notification.categories}>\r\n  <{foreach name=inner item=event from=$category.events}>\r\n  <tr>\r\n    <{if $smarty.foreach.inner.first}>\r\n    <td class=\"even\" rowspan=\"<{$smarty.foreach.inner.total}>\"><{$category.title}></td>\r\n    <{/if}>\r\n    <td class=\"odd\">\r\n    <{counter assign=index}>\r\n    <input type=\"hidden\" name=\"not_list[<{$index}>][params]\" value=\"<{$category.name}>,<{$category.itemid}>,<{$event.name}>\" />\r\n    <input type=\"checkbox\" id=\"not_list[]\" name=\"not_list[<{$index}>][status]\" value=\"1\" <{if $event.subscribed}>checked=\"checked\"<{/if}> />\r\n    </td>\r\n    <td class=\"odd\"><{$event.caption}></td>\r\n  </tr>\r\n  <{/foreach}>\r\n  <{/foreach}>\r\n  <tr>\r\n    <td class=\"foot\" colspan=\"3\" align=\"center\"><input type=\"submit\" name=\"not_submit\" value=\"<{$lang_updatenow}>\" /></td>\r\n  </tr>\r\n</table>\r\n<div align=\"center\">\r\n<{$lang_notificationmethodis}>:&nbsp;<{$user_method}>&nbsp;&nbsp;[<a href=\"<{$editprofile_url}>\"><{$lang_change}></a>]\r\n</div>\r\n</form>\r\n<{/if}>');
INSERT INTO x_tplsource VALUES (15,'<table cellspacing=\"0\">\r\n  <tr>\r\n    <td id=\"usermenu\">\r\n      <a class=\"menuTop\" href=\"<{$xoops_url}>/user.php\"><{$block.lang_youraccount}></a>\r\n      <a href=\"<{$xoops_url}>/edituser.php\"><{$block.lang_editaccount}></a>\r\n      <a href=\"<{$xoops_url}>/notifications.php\"><{$block.lang_notifications}></a>\r\n      <a href=\"<{$xoops_url}>/user.php?op=logout\"><{$block.lang_logout}></a>\r\n      <{if $block.new_messages > 0}>\r\n        <a class=\"highlight\" href=\"<{$xoops_url}>/viewpmsg.php\"><{$block.lang_inbox}> (<span style=\"color:#ff0000; font-weight: bold;\"><{$block.new_messages}></span>)</a>\r\n      <{else}>\r\n        <a href=\"<{$xoops_url}>/viewpmsg.php\"><{$block.lang_inbox}></a>\r\n      <{/if}>\r\n\r\n      <{if $xoops_isadmin}>\r\n        <a href=\"<{$xoops_url}>/admin.php\"><{$block.lang_adminmenu}></a>\r\n      <{/if}>\r\n    </td>\r\n  </tr>\r\n</table>\r\n');
INSERT INTO x_tplsource VALUES (16,'<form style=\"margin-top: 0px;\" action=\"<{$xoops_url}>/user.php\" method=\"post\">\r\n    <{$block.lang_username}><br />\r\n    <input type=\"text\" name=\"uname\" size=\"12\" value=\"<{$block.unamevalue}>\" maxlength=\"25\" /><br />\r\n    <{$block.lang_password}><br />\r\n    <input type=\"password\" name=\"pass\" size=\"12\" maxlength=\"32\" /><br />\r\n    <!-- <input type=\"checkbox\" name=\"rememberme\" value=\"On\" class =\"formButton\" /><{$block.lang_rememberme}><br /> //-->\r\n    <input type=\"hidden\" name=\"xoops_redirect\" value=\"<{$xoops_requesturi}>\" />\r\n    <input type=\"hidden\" name=\"op\" value=\"login\" />\r\n    <input type=\"submit\" value=\"<{$block.lang_login}>\" /><br />\r\n    <{$block.sslloginlink}>\r\n</form>\r\n<a href=\"<{$xoops_url}>/user.php#lost\"><{$block.lang_lostpass}></a>\r\n<br /><br />\r\n<a href=\"<{$xoops_url}>/register.php\"><{$block.lang_registernow}></a>');
INSERT INTO x_tplsource VALUES (17,'<form style=\"margin-top: 0px;\" action=\"<{$xoops_url}>/search.php\" method=\"get\">\r\n  <input type=\"text\" name=\"query\" size=\"14\" /><input type=\"hidden\" name=\"action\" value=\"results\" /><br /><input type=\"submit\" value=\"<{$block.lang_search}>\" />\r\n</form>\r\n<a href=\"<{$xoops_url}>/search.php\"><{$block.lang_advsearch}></a>');
INSERT INTO x_tplsource VALUES (18,'<ul>\r\n  <{foreach item=module from=$block.modules}>\r\n  <li><a href=\"<{$module.adminlink}>\"><{$module.lang_linkname}></a>: <{$module.pendingnum}></li>\r\n  <{/foreach}>\r\n</ul>');
INSERT INTO x_tplsource VALUES (19,'<table cellspacing=\"0\">\r\n  <tr>\r\n    <td id=\"mainmenu\">\r\n      <a class=\"menuTop\" href=\"<{$xoops_url}>/\"><{$block.lang_home}></a>\r\n      <!-- start module menu loop -->\r\n      <{foreach item=module from=$block.modules}>\r\n      <a class=\"menuMain\" href=\"<{$xoops_url}>/modules/<{$module.directory}>/\"><{$module.name}></a>\r\n        <{foreach item=sublink from=$module.sublinks}>\r\n          <a class=\"menuSub\" href=\"<{$sublink.url}>\"><{$sublink.name}></a>\r\n        <{/foreach}>\r\n      <{/foreach}>\r\n      <!-- end module menu loop -->\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (20,'<table class=\"outer\" cellspacing=\"0\">\r\n\r\n  <{if $block.showgroups == true}>\r\n\r\n  <!-- start group loop -->\r\n  <{foreach item=group from=$block.groups}>\r\n  <tr>\r\n    <th colspan=\"2\"><{$group.name}></th>\r\n  </tr>\r\n\r\n  <!-- start group member loop -->\r\n  <{foreach item=user from=$group.users}>\r\n  <tr>\r\n    <td class=\"even\" valign=\"middle\" align=\"center\"><img src=\"<{$user.avatar}>\" alt=\"\" width=\"32\" /><br /><a href=\"<{$xoops_url}>/userinfo.php?uid=<{$user.id}>\"><{$user.name}></a></td><td class=\"odd\" width=\"20%\" align=\"right\" valign=\"middle\"><{$user.msglink}></td>\r\n  </tr>\r\n  <{/foreach}>\r\n  <!-- end group member loop -->\r\n\r\n  <{/foreach}>\r\n  <!-- end group loop -->\r\n  <{/if}>\r\n</table>\r\n\r\n<br />\r\n\r\n<div style=\"margin: 3px; text-align:center;\">\r\n  <img src=\"<{$block.logourl}>\" alt=\"\" border=\"0\" /><br /><{$block.recommendlink}>\r\n</div>');
INSERT INTO x_tplsource VALUES (21,'<{$block.online_total}><br /><br /><{$block.lang_members}>: <{$block.online_members}><br /><{$block.lang_guests}>: <{$block.online_guests}><br /><br /><{$block.online_names}> <a href=\"javascript:openWithSelfMain(\'<{$xoops_url}>/misc.php?action=showpopups&amp;type=online\',\'Online\',420,350);\"><{$block.lang_more}></a>');
INSERT INTO x_tplsource VALUES (22,'<table cellspacing=\"1\" class=\"outer\">\r\n  <{foreach item=user from=$block.users}>\r\n  <tr class=\"<{cycle values=\"even,odd\"}>\" valign=\"middle\">\r\n    <td><{$user.rank}></td>\r\n    <td align=\"center\">\r\n      <{if $user.avatar != \"\"}>\r\n      <img src=\"<{$user.avatar}>\" alt=\"\" width=\"32\" /><br />\r\n      <{/if}>\r\n      <a href=\"<{$xoops_url}>/userinfo.php?uid=<{$user.id}>\"><{$user.name}></a>\r\n    </td>\r\n    <td align=\"center\"><{$user.posts}></td>\r\n  </tr>\r\n  <{/foreach}>\r\n</table>\r\n');
INSERT INTO x_tplsource VALUES (23,'<table cellspacing=\"1\" class=\"outer\">\r\n  <{foreach item=user from=$block.users}>\r\n    <tr class=\"<{cycle values=\"even,odd\"}>\" valign=\"middle\">\r\n      <td align=\"center\">\r\n      <{if $user.avatar != \"\"}>\r\n      <img src=\"<{$user.avatar}>\" alt=\"\" width=\"32\" /><br />\r\n      <{/if}>\r\n      <a href=\"<{$xoops_url}>/userinfo.php?uid=<{$user.id}>\"><{$user.name}></a>\r\n      </td>\r\n      <td align=\"center\"><{$user.joindate}></td>\r\n    </tr>\r\n  <{/foreach}>\r\n</table>\r\n');
INSERT INTO x_tplsource VALUES (24,'<table width=\"100%\" cellspacing=\"1\" class=\"outer\">\r\n  <{foreach item=comment from=$block.comments}>\r\n  <tr class=\"<{cycle values=\"even,odd\"}>\">\r\n    <td align=\"center\"><img src=\"<{$xoops_url}>/images/subject/<{$comment.icon}>\" alt=\"\" /></td>\r\n    <td><{$comment.title}></td>\r\n    <td align=\"center\"><{$comment.module}></td>\r\n    <td align=\"center\"><{$comment.poster}></td>\r\n    <td align=\"right\"><{$comment.time}></td>\r\n  </tr>\r\n  <{/foreach}>\r\n</table>');
INSERT INTO x_tplsource VALUES (25,'<form action=\"<{$block.target_page}>\" method=\"post\">\r\n<table class=\"outer\">\r\n  <{foreach item=category from=$block.categories}>\r\n  <{foreach name=inner item=event from=$category.events}>\r\n  <{if $smarty.foreach.inner.first}>\r\n  <tr>\r\n    <td class=\"head\" colspan=\"2\"><{$category.title}></td>\r\n  </tr>\r\n  <{/if}>\r\n  <tr>\r\n    <td class=\"odd\"><{counter assign=index}><input type=\"hidden\" name=\"not_list[<{$index}>][params]\" value=\"<{$category.name}>,<{$category.itemid}>,<{$event.name}>\" /><input type=\"checkbox\" name=\"not_list[<{$index}>][status]\" value=\"1\" <{if $event.subscribed}>checked=\"checked\"<{/if}> /></td>\r\n    <td class=\"odd\"><{$event.caption}></td>\r\n  </tr>\r\n  <{/foreach}>\r\n  <{/foreach}>\r\n  <tr>\r\n    <td class=\"foot\" colspan=\"2\"><input type=\"hidden\" name=\"not_redirect\" value=\"<{$block.redirect_script}>\"><input type=\"submit\" name=\"not_submit\" value=\"<{$block.submit_button}>\" /></td>\r\n  </tr>\r\n</table>\r\n</form>');
INSERT INTO x_tplsource VALUES (26,'<div style=\"text-align: center;\">\r\n<form action=\"index.php\" method=\"post\">\r\n<{$block.theme_select}>\r\n</form>\r\n</div>');
INSERT INTO x_tplsource VALUES (27,'<{*\r\n\r\n$i                   \r\n$indecies\r\n$index\r\n$index_path\r\n$item\r\n$item_count_label\r\n$item_count_select\r\n$item_htmls\r\n$itemcount\r\n$num_of_items\r\n$maxpage\r\n$order_by_label\r\n$order_by_select\r\n$page\r\n$page_no_label\r\n$pages\r\n$title_page\r\n$title_register\r\n\r\n\r\n*}>\r\n<script type=\'text/javascript\'>\r\n<!--\r\nfunction submit_add_to_index()\r\n{\r\n    var form = document.getElementById(\'xoonips_add_to_index_form\');\r\n    form.submit();\r\n    return false;\r\n}\r\n// -->\r\n</script>\r\n\r\n<p>\r\n<h3><{$title_page}></h3>\r\n</p>\r\n\r\n<p>\r\n<h4><{$title_register}></h4>\r\n<center>\r\n<form action=\"\">\r\n<table width=\"100%\" border=\"0\" cellspacing=\"5\">\r\n  <tr valign=\"top\" class=\"odd\">\r\n    <td>\r\n     <{$order_by_label}>\r\n     <select name=\"orderby\" onchange=\"submit();\">\r\n<{foreach key=key item=item from=$order_by_select}>\r\n      <option value=\"<{$key}>\" <{if $key==$orderby}> selected <{/if}> ><{$item}></option>\r\n<{/foreach}>\r\n     </select>\r\n    </td>\r\n    <td>\r\n     <{$item_count_label}>\r\n     <select name=\"itemcount\" onchange=\"submit();\">\r\n<{foreach item=i from=$item_count_select}>\r\n      <option value=\"<{$i}>\" <{if $i==$itemcount }> selected <{/if}> ><{$i}></option>\r\n<{/foreach}>\r\n     </select>\r\n    </td>\r\n  </tr>\r\n</table> \r\n</center>\r\n<input type=\"hidden\" name=\"page\" value=\"1\" />\r\n<input type=\"hidden\" name=\"num_of_items\" value=\"<{$num_of_items}>\" />\r\n<{if $index_id > 0}>\r\n<input type=\"hidden\" name=\"index_id\" value=\"<{$index_id}>\" />\r\n<{/if}>\r\n</form>\r\n</p>\r\n\r\n<{if isset($index_path) }>\r\n<p>\r\n<{foreach item=index from=$index_path}>\r\n / <a href=\"listitem.php?index_id=<{$index.item_id}>\"><{$index.title|escape}></a>\r\n<{/foreach}>\r\n<{* ROOT, Binders ξϡAddܥɽʤ *}>\r\n<{if $index_id != $smarty.const.IID_ROOT && $index_id != $smarty.const.IID_BINDERS }>\r\n &nbsp;&nbsp;\r\n <input type=\'button\' name=\'add\' value=\'<{$smarty.const._MD_XOONIPS_ITEM_ADD_ITEM_BUTTON_LABEL}>\' onClick=\'submit_add_to_index();\'>\r\n<{/if}>\r\n</p>\r\n<{/if}>\r\n\r\n<p>\r\n<{$page_no_label}>\r\n</p>\r\n\r\n<{if $maxpage > 1}>\r\n<div align=\"right\">\r\n<{if $page > 1}>\r\n<{if $index_id > 0}>\r\n<a href=\"?index_id=<{$index_id}>&page=<{$prevpage}>&orderby=<{$orderby}>&itemcount=<{$itemcount}>&num_of_items=<{$num_of_items}>\">PREV</a>\r\n<{else}>\r\n<a href=\"?page=<{$prevpage}>&orderby=<{$orderby}>&itemcount=<{$itemcount}>&num_of_items=<{$num_of_items}>\">PREV</a>\r\n<{/if}>\r\n<{else}>\r\nPREV&nbsp;\r\n<{/if}>\r\n\r\n<{foreach item=i from=$pages}>\r\n<{if $i==$page}>\r\n<{$i}>\r\n<{else}>\r\n <{if $index_id > 0}>\r\n<a href=\"?index_id=<{$index_id}>&page=<{$i}>&orderby=<{$orderby}>&itemcount=<{$itemcount}>&num_of_items=<{$num_of_items}>\"><{$i}></a>\r\n <{else}>\r\n<a href=\"?page=<{$i}>&orderby=<{$orderby}>&itemcount=<{$itemcount}>&num_of_items=<{$num_of_items}>\"><{$i}></a>\r\n <{/if}>\r\n<{/if}>\r\n&nbsp;\r\n<{/foreach}>\r\n\r\n<{if $page < $maxpage }>\r\n <{if $index_id > 0}>\r\n<a href=\"?index_id=<{$index_id}>&page=<{$nextpage}>&orderby=<{$orderby}>&itemcount=<{$itemcount}>&num_of_items=<{$num_of_items}>\">NEXT</a>\r\n <{else}>\r\n<a href=\"?page=<{$nextpage}>&orderby=<{$orderby}>&itemcount=<{$itemcount}>&num_of_items=<{$num_of_items}>\">NEXT</a>\r\n <{/if}>\r\n<{else}>\r\nNEXT\r\n<{/if}>\r\n</div>\r\n<{/if}>\r\n\r\n<table width=\"100%\" border=\"0\" cellspacing=\"5\">\r\n<{foreach item=i from=$item_htmls}>\r\n  <tr valign=\"top\" class=\"<{cycle values=\"odd,even\"}>\">\r\n    <td>\r\n     <{$i}>\r\n    </td>\r\n  </tr>\r\n<{/foreach}>\r\n</table>\r\n\r\n<{if $maxpage > 1}>\r\n<div align=\"right\">\r\n<{if $page > 1}>\r\n<{if $index_id > 0}>\r\n<a href=\"?index_id=<{$index_id}>&page=<{$prevpage}>&orderby=<{$orderby}>&itemcount=<{$itemcount}>&num_of_items=<{$num_of_items}>\">PREV</a>\r\n<{else}>\r\n<a href=\"?page=<{$prevpage}>&orderby=<{$orderby}>&itemcount=<{$itemcount}>&num_of_items=<{$num_of_items}>\">PREV</a>\r\n<{/if}>\r\n<{else}>\r\nPREV&nbsp;\r\n<{/if}>\r\n\r\n<{foreach item=i from=$pages}>\r\n<{if $i==$page}>\r\n<{$i}>\r\n<{else}>\r\n <{if $index_id > 0}>\r\n<a href=\"?index_id=<{$index_id}>&page=<{$i}>&orderby=<{$orderby}>&itemcount=<{$itemcount}>&num_of_items=<{$num_of_items}>\"><{$i}></a>\r\n <{else}>\r\n<a href=\"?page=<{$i}>&orderby=<{$orderby}>&itemcount=<{$itemcount}>&num_of_items=<{$num_of_items}>\"><{$i}></a>\r\n <{/if}>\r\n<{/if}>\r\n&nbsp;\r\n<{/foreach}>\r\n\r\n<{if $page < $maxpage }>\r\n <{if $index_id > 0}>\r\n<a href=\"?index_id=<{$index_id}>&page=<{$nextpage}>&orderby=<{$orderby}>&itemcount=<{$itemcount}>&num_of_items=<{$num_of_items}>\">NEXT</a>\r\n <{else}>\r\n<a href=\"?page=<{$nextpage}>&orderby=<{$orderby}>&itemcount=<{$itemcount}>&num_of_items=<{$num_of_items}>\">NEXT</a>\r\n <{/if}>\r\n<{else}>\r\nNEXT\r\n<{/if}>\r\n</div>\r\n<{/if}>\r\n\r\n<br />\r\n\r\n</form>\r\n\r\n<form action=\"advanced_search_add_to_index.php\" method=\"POST\" id=\"xoonips_add_to_index_form\">\r\n<input type=\'hidden\' name=\'jumpto_url\' value=\'index.php\'>\r\n<input type=\"hidden\" name=\"jumpto_var[]\" value=\"add_to_index\"/>\r\n<input type=\'hidden\' name=\'add_to_index\' value=\'<{$page}>,<{$itemcount}>,<{$orderby}>,<{$index_id}>\'>\r\n<input type=\"hidden\" name=\"add_to_index_id\" value=\"<{$index_id}>\"/>\r\n<input type=\"hidden\" name=\"checkbox\" value=\"on\"/>\r\n</form>\r\n<!-- end module search results loop -->');
INSERT INTO x_tplsource VALUES (28,'<!-- begin of register.html -->\r\n<script type=\"text/javascript\" src=\"treelib.js\">\r\n</script>\r\n<script type=\"text/javascript\">\r\n<!--\r\nfunction getCheckedIndexes( form1 ){\r\n	var previewobj = form1.preview;\r\n	if ( previewobj != null ){\r\n		if ( previewobj.value != null && previewobj.value != \"\" ){\r\n			window.alert( \'error: preview file \"\' + previewobj.value + \'\" will not be uploaded. \\npush Upload button first.\' );\r\n			return false;\r\n		}\r\n	}\r\n	\r\n	xoonipsGetDocTreeView2();\r\n	xoonipsSaveTreeState2(xoonipsDocTreeView2);\r\n	form1.xoonipsCheckedXID.value = xoonipsCheckState2;\r\n	return true;\r\n}\r\nfunction xnpSubmitFileUpload( obj, name ){\r\n	document.getElementsByName(\'mode\').item(0).value = \'Upload\';\r\n	var fileobj = document.getElementsByName(name).item(0);\r\n	if ( fileobj.value == null || fileobj.value == \"\" ){\r\n		window.alert( \'error: no file specified.\' );\r\n		return false;\r\n	}\r\n	obj.form.action = \'\';\r\n	obj.form.submit();\r\n}\r\nfunction xnpSubmitFileDelete( obj, name, fileID ){\r\n	document.getElementsByName(\'mode\').item(0).value = \'Delete\';\r\n	document.getElementsByName(\'fileID\').item(0).value = fileID;\r\n	obj.form.action = \'\';\r\n	obj.form.submit();\r\n}\r\n\r\n//return true if all required parameters are filled\r\nfunction onSubmitItem( form1 ){\r\n	if( form1.title.value == \'\' ){\r\n		alert( \"<{$smarty.const._MD_XOONIPS_ITEM_TITLE_REQUIRED}>\" );\r\n		return false;\r\n	}\r\n	return true;\r\n}\r\n\r\nfunction xnpOpenTextFileInputWindow( name, itemID ){\r\n	window.open( \'<{$smarty.const.XOOPS_URL}>/modules/xoonips/input_text_file.php?name=\' + name, \'inputTextFile\', \r\n		\"dependent,menubar=no,location=no,personalbar=no,directories=no,toolbar=no,resizable=yes,scrollbars=no,innerHeight=220,innerWidth=480\");\r\n	// todo: iconƤʤ顢Υɬפ롥\r\n	return false;\r\n}\r\n\r\n//-->\r\n</script>\r\n\r\n<p><{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_PLATFORM_USER}>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR}>\r\n<{$smarty.const._MI_XOONIPS_ITEM_PANKUZU_REGISTER_ITEM}></p>\r\n\r\n<p>\r\n<h3><{$smarty.const._MD_XOONIPS_ITEM_REGISTER_ITEM_TITLE}></h3>\r\n</p>\r\n\r\n<{*\r\nƥϿ̥ƥץ졼\r\n\r\n$Revision: 1.5 $\r\n\r\n$body	ƥϿեHTML\r\n$select_item_type[]	ǽʥƥॿפ(̾=>item_type_id)\r\n$next_url	إܥ󲡲ΥURL\r\n$item_type_id	Ͽ륢ƥΥ\r\n$index_checked_id	򤵤줿ǥåID(Ⱦѥ(,)ڤ)\r\n$system_message	ƥ¦Υå顼ʤ(ά)\r\n$num_of_items_current	ߤϿƥ(ƥ)\r\n$num_of_items_max	Ͽǽʥƥκ\r\n$storage_of_items_current	ߤϿƥźեե(ƥ)\r\n$storage_of_items_max	Ͽǽʥƥźեեκ\r\n*}>\r\n\r\n\r\n<center>\r\n<form name=\"registerform\" action=\"<{$next_url}>\" method=\"post\"\r\nonSubmit=\"return onSubmitItemType(this) && onSubmitItem(this) && getCheckedIndexes(this)\" enctype=\"multipart/form-data\" accept-charst=\"*\">\r\n<input type=\'hidden\' name=\'mode\' value=\'\'>\r\n<input type=\'hidden\' name=\'fileID\' value=\'\'>\r\n<{if !empty( $select_item_type )}>\r\n<{$smarty.const._MD_XOONIPS_ITEM_SELECT_ITEM_TYPE_LABEL}>\r\n<select name=\"item_type_id\" onchange=\"action=\'register.php\'; submit();\">\r\n<{foreach key=name item=id from=$select_item_type}>\r\n <option value=\"<{$id}>\" <{if $id==$item_type_id}> selected <{/if}> ><{$name}></option>\r\n<{/foreach}>\r\n</select>\r\n<{/if}>\r\n</center>\r\n<br /><br />\r\n<{$system_message}>\r\n<br /><br />\r\n<{if !empty( $num_of_items_current ) && !empty( $num_of_items_max ) }>\r\n<{$smarty.const._MD_XOONIPS_ITEM_NUM_OF_ITEM}>: <{$num_of_items_current}> / <{$num_of_items_max}><br />\r\n<{/if}>\r\n<{if !empty( $storage_of_items_current ) && !empty( $storage_of_items_max ) }>\r\n<{$smarty.const._MD_XOONIPS_ITEM_STORAGE_OF_ITEM}>: <{$storage_of_items_current}>MB / <{$storage_of_items_max}>MB<br />\r\n<{/if}>\r\n<{if !empty( $body ) }>\r\n<{$body}>\r\n<{/if}>\r\n\r\n<br /><br />\r\n\r\n<{* <input type=\'hidden\' name=\'xoonipsForm\' value=\'<{$xoonipsForm}>\'> *}>\r\n <input type=\'hidden\' name=\'xoonipsCheckedXID\' value=\'<{$index_checked_id}>\'>\r\n <{* To pass basic informations to next pages *}>\r\n <input type=\'hidden\' name=\'jumpto_var[]\' value=\'title\'>\r\n <input type=\'hidden\' name=\'jumpto_var[]\' value=\'keywords\'>\r\n <input type=\'hidden\' name=\'jumpto_var[]\' value=\'description\'>\r\n <input type=\'hidden\' name=\'jumpto_var[]\' value=\'doi\'>\r\n <input type=\'hidden\' name=\'jumpto_var[]\' value=\'change_log\'>\r\n<{*  <input type=\'hidden\' name=\'jumpto_var[]\' value=\'xoonipsForm\'> *}>\r\n\r\n<{if !empty( $body ) || !empty( $select_item_type )}>\r\n<center>\r\n <input type=\"submit\" name=\"nextButton\"\r\n value=\"<{$smarty.const._MD_XOONIPS_ITEM_NEXT_BUTTON_LABEL}>\"/>\r\n</center>\r\n<{/if}>\r\n</form>\r\n<!-- end of register.html -->');
INSERT INTO x_tplsource VALUES (29,'<p>\r\n<h3><{$smarty.const._MD_XOONIPS_ITEM_REGISTER_ITEM_CONFIRM}></h3>\r\n</p>\r\n\r\n<{*\r\nƥϿǧ̥ƥץ졼\r\n\r\n$Revision: 1.5 $\r\n\r\n$body	ƥϿǧեHTML\r\n$http_vars	ڡѥ᡼Υϥåơ֥(ƥʤ)\r\n$system_message	ƥ¦Υå顼ʤ(ά)\r\n*}>\r\n\r\n\r\n<br /><br />\r\n\r\n<{$smarty.const._MD_XOONIPS_ITEM_REGISTER_ITEM_CONFIRM_MESSAGE}>\r\n<br/>\r\n\r\n<form name=\'confirm\' action=\"confirm_register.php\" method=\"POST\">\r\n\r\n<{$system_message}>\r\n<{$body}>\r\n\r\n<br /><br />\r\n\r\n<{foreach key=k item=v from=$http_vars}>\r\n <input type=\"hidden\" name=\"<{$k}>\" value=\"<{$v}>\"/>\r\n<{/foreach}>\r\n\r\n<input type=\"hidden\" name=\"op\" value=\"register\"/>\r\n\r\n<center>\r\n <input type=\"submit\" value=\"<{$smarty.const._MD_XOONIPS_ITEM_REGISTER_BUTTON_LABEL}>\"/>\r\n <input type=\"button\" value=\"<{$smarty.const._MD_XOONIPS_ITEM_BACK_BUTTON_LABEL}>\" onclick=\"document.confirm.action=\'register.php\'; submit();\"/>\r\n</center>\r\n</form>');
INSERT INTO x_tplsource VALUES (30,'<{if !empty( $pankuzu )}>\r\n<p><{$pankuzu}></p>\r\n<{/if}>\r\n<p>\r\n<h3><{$smarty.const._MD_XOONIPS_ITEM_CERTIFY_ITEM_TITLE}></h3>\r\n</p>\r\n\r\n<{*\r\nƥྵǧ̥ƥץ졼\r\n\r\n$Revision: 1.5 $\r\n\r\n$items[]	ǧ륢ƥ\r\n                array( item_id=>ƥID, index_id=>Ͽ륤ǥåID, \r\n                       item_body=>ǧ륢ƥγɽHTML,\r\n                       index_body=>ǥåΥѥ) η֤\r\n*}>\r\n\r\n\r\n <{foreach item=i from=$items}>\r\n   <form name=\'certify<{$i.item_id}>_<{$i.index_id}>\'\r\n   action=\"certify.php<{if !empty($menu_id)}>?menu_id=<{$menu_id}><{/if}>\" method=\"post\">\r\n    <input type=\'hidden\' name=\'item_id\' value=\'<{$i.item_id}>\'>\r\n    <input type=\'hidden\' name=\'index_id\' value=\'<{$i.index_id}>\'>\r\n    <input type=\'hidden\' name=\'op\' value=\'certify\'>\r\n   </form>\r\n   <form name=\'uncertify<{$i.item_id}>_<{$i.index_id}>\'\r\n   action=\"certify.php<{if !empty($menu_id)}>?menu_id=<{$menu_id}><{/if}>\" method=\"post\">\r\n    <input type=\'hidden\' name=\'item_id\' value=\'<{$i.item_id}>\'>\r\n    <input type=\'hidden\' name=\'index_id\' value=\'<{$i.index_id}>\'>\r\n    <input type=\'hidden\' name=\'op\' value=\'uncertify\'>\r\n   </form>\r\n <{/foreach}>\r\n\r\n<br /><br />\r\n\r\n<{if !empty( $items ) }>\r\n<table >\r\n <{foreach item=i from=$items}>\r\n <tr class=\"<{cycle values=\"odd,even\"}>\">\r\n  <td>\r\n   <table>\r\n    <tr>\r\n     <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_ITEM_LABEL}></td>\r\n     <td><{$i.item_body}></td>\r\n     <td rowspan=\'2\' valign=\'middle\' align=\'right\'>\r\n      <form action=\"\">\r\n      <input type=\"button\" value=\"<{$smarty.const._MD_XOONIPS_ITEM_CERTIFY_BUTTON_LABEL}>\" onclick=\"document.certify<{$i.item_id}>_<{$i.index_id}>.submit();\"/>\r\n      <input type=\"button\" value=\"<{$smarty.const._MD_XOONIPS_ITEM_UNCERTIFY_BUTTON_LABEL}>\" onclick=\"document.uncertify<{$i.item_id}>_<{$i.index_id}>.submit();\"/>\r\n      </form>\r\n     </td>\r\n    </tr>\r\n    <tr>\r\n     <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_INDEX_LABEL}></td>\r\n     <td><{$i.index_body}></td>\r\n    </tr>\r\n   </table>\r\n  </td>\r\n  </div>\r\n  </td>\r\n   </tr>\r\n <{/foreach}>\r\n</table>\r\n<{else}>\r\n   <p>\r\n   <{$smarty.const._MD_XOONIPS_ITEM_NO_CERTIFY_ITEMS}>\r\n   </p>\r\n<{/if}>');
INSERT INTO x_tplsource VALUES (31,'<script type=\"text/javascript\" src=\"treelib.js\">\r\n</script>\r\n<script type=\"text/javascript\">\r\n<!--\r\nfunction getCheckedIndexes( form1 ){\r\n	var previewobj = form1.preview;\r\n	if ( previewobj != null ){\r\n		if ( previewobj.value != null && previewobj.value != \"\" ){\r\n			window.alert( \'error: preview file \"\' + previewobj.value + \'\" will not be uploaded. \\npush Upload button first.\' );\r\n			return false;\r\n		}\r\n	}\r\n	\r\n	xoonipsGetDocTreeView2();\r\n	xoonipsSaveTreeState2(xoonipsDocTreeView2);\r\n	form1.xoonipsCheckedXID.value = xoonipsCheckState2;\r\n	return true;\r\n}\r\nfunction xnpSubmitFileUpload( obj, name ){\r\n	document.getElementsByName(\'mode\').item(0).value = \'Upload\';\r\n	var fileobj = document.getElementsByName(name).item(0);\r\n	if ( fileobj.value == null || fileobj.value == \"\" ){\r\n		window.alert( \'error: no file specified.\' );\r\n		return false;\r\n	}\r\n	obj.form.action = \'\';\r\n	obj.form.submit();\r\n}\r\nfunction xnpSubmitFileDelete( obj, name, fileID ){\r\n	document.getElementsByName(\'mode\').item(0).value = \'Delete\';\r\n	document.getElementsByName(\'fileID\').item(0).value = fileID;\r\n	obj.form.action = \'\';\r\n	obj.form.submit();\r\n}\r\n\r\n//return true if all required parameters are filled\r\nfunction onSubmitItem( form1 ){\r\n	if( form1.title.value == \'\' ){\r\n		alert( \"<{$smarty.const._MD_XOONIPS_ITEM_TITLE_REQUIRED}>\" );\r\n		return false;\r\n	}\r\n	return true;\r\n}\r\n\r\nfunction xnpOpenTextFileInputWindow( name, itemID ){\r\n	window.open( \'<{$smarty.const.XOOPS_URL}>/modules/xoonips/input_text_file.php?name=\' + name, \'inputTextFile\', \r\n		\"dependent,menubar=no,location=no,personalbar=no,directories=no,toolbar=no,resizable=yes,scrollbars=no,innerHeight=220,innerWidth=480\");\r\n	// todo: iconƤʤ顢Υɬפ롥\r\n	return false;\r\n}\r\n\r\n\r\n//-->\r\n</script>\r\n\r\n<p>\r\n<h3><{$smarty.const._MD_XOONIPS_ITEM_MODIFY_ITEM_TITLE}></h3>\r\n</p>\r\n\r\n<{*\r\nƥԽ̥ƥץ졼\r\n\r\n$Revision: 1.5 $\r\n\r\n$item_id	ԽоݤΥƥID\r\n$body	ƥԽեHTML\r\n$next_url	إܥ󲡲ΥURL\r\n$xoonipsCheckedXID	ΥǥåID(\',\'ڤ)\r\n$num_of_items_current	ߤϿƥ(ƥ)\r\n$num_of_items_max	Ͽǽʥƥκ\r\n$storage_of_items_current	ߤϿƥźեե(ƥ)\r\n$storage_of_items_max	Ͽǽʥƥźեեκ\r\n*}>\r\n\r\n\r\n<br /><br />\r\n\r\n<form name=\"editform\" action=\"<{$next_url}>\" method=\"post\"\r\nonSubmit=\"return onSubmitItemType(this) && onSubmitItem(this) && getCheckedIndexes(this)\" enctype=\"multipart/form-data\">\r\n<input type=\'hidden\' name=\'mode\' value=\'\'>\r\n<input type=\'hidden\' name=\'fileID\' value=\'\'>\r\n\r\n<{if !empty( $num_of_items_current ) && !empty( $num_of_items_max ) }>\r\n<{$smarty.const._MD_XOONIPS_ITEM_NUM_OF_ITEM}>: <{$num_of_items_current}> / <{$num_of_items_max}><br />\r\n<{/if}>\r\n<{if !empty( $storage_of_items_current ) && !empty( $storage_of_items_max ) }>\r\n<{$smarty.const._MD_XOONIPS_ITEM_STORAGE_OF_ITEM}>: <{$storage_of_items_current}>MB / <{$storage_of_items_max}>MB<br />\r\n<{/if}>\r\n<{if !empty( $body ) }>\r\n<{$body}>\r\n<{/if}>\r\n\r\n <input type=\'hidden\' name=\'xoonipsCheckedXID\' value=\'<{$xoonipsCheckedXID}>\'>\r\n <{* To pass basic informations to next pages *}>\r\n <input type=\'hidden\' name=\'jumpto_var[]\' value=\'title\'>\r\n <input type=\'hidden\' name=\'jumpto_var[]\' value=\'keywords\'>\r\n <input type=\'hidden\' name=\'jumpto_var[]\' value=\'description\'>\r\n <input type=\'hidden\' name=\'jumpto_var[]\' value=\'doi\'>\r\n <input type=\'hidden\' name=\'jumpto_var[]\' value=\'change_log\'>\r\n <input type=\'hidden\' name=\'item_id\' value=\'<{$item_id}>\'>\r\n\r\n<center>\r\n <input type=\"submit\" value=\"<{$smarty.const._MD_XOONIPS_ITEM_NEXT_BUTTON_LABEL}>\"/>\r\n</center>\r\n</form>');
INSERT INTO x_tplsource VALUES (32,'<p>\r\n<h3><{$smarty.const._MD_XOONIPS_ITEM_MODIFY_ITEM_TITLE}></h3>\r\n</p>\r\n\r\n<{*\r\nƥԽǧ̥ƥץ졼\r\n\r\n$Revision: 1.5 $\r\n\r\n$item_id	ԽоݤΥƥID\r\n$body	ƥԽǧեHTML\r\n$http_vars	ڡѥ᡼Υϥåơ֥(ƥʤ)\r\n$system_message	ƥ¦Υå顼ʤ(ά)\r\n*}>\r\n\r\n<br /><br />\r\n\r\n<{$smarty.const._MD_XOONIPS_ITEM_MODIFY_ITEM_CONFIRM_MESSAGE}>\r\n<br/>\r\n\r\n<form name=\'confirm\' action=\"confirm_edit.php\" method=\"POST\">\r\n\r\n<{$system_message}>\r\n<{$body}>\r\n\r\n<br /><br />\r\n\r\n<{foreach key=k item=v from=$http_vars}>\r\n <input type=\"hidden\" name=\"<{$k}>\" value=\"<{$v}>\"/>\r\n<{/foreach}>\r\n\r\n <input type=\"hidden\" name=\"op\" value=\"update\"/>\r\n <input type=\'hidden\' name=\'item_id\' value=\'<{$item_id}>\'>\r\n\r\n<center>\r\n <input type=\"submit\" value=\"<{$smarty.const._MD_XOONIPS_ITEM_UPDATE_BUTTON_LABEL}>\"/>\r\n <input type=\"button\" value=\"<{$smarty.const._MD_XOONIPS_ITEM_BACK_BUTTON_LABEL}>\" onclick=\"document.confirm.action=\'edit.php\'; submit();\"/>\r\n</center>\r\n</form>');
INSERT INTO x_tplsource VALUES (33,'<p>\r\n<h3><{$smarty.const._MD_XOONIPS_ITEM_DETAIL_ITEM_TITLE}></h3>\r\n</p>\r\n\r\n<{*\r\nƥܺٲ̥ƥץ졼\r\n\r\n$Revision: 1.5 $\r\n\r\n$item_id	ƥID\r\n$body	ܺٲ̤HTML\r\n$delete_button_visible	1:deleteܥɽ\r\n$modify_button_visible	1:modifyܥɽ\r\n$print_button_visible	1:printܥɽ\r\n*}>\r\n\r\n<SCRIPT language=\"JavaScript\">\r\nfunction delete_confirm(){\r\n    if(confirm(\"<{$smarty.const._MD_XOONIPS_ITEM_DELETE_CONFIRMATION_MESSAGE}>\"))\r\n        document.delete_item.submit();\r\n}\r\nfunction accept_certify_confirm(xid, item_id){\r\ndocument.accept_certify.index_id.value=xid;\r\ndocument.accept_certify.item_id.value=item_id;\r\n    if(confirm(\"<{$smarty.const._MD_XOONIPS_ITEM_ACCEPT_CERTIFY_CONFIRMATION_MESSAGE}>\"))\r\n        document.accept_certify.submit();\r\n}\r\nfunction cancel_certify_confirm(xid, item_id){\r\ndocument.cancel_certify.index_id.value=xid;\r\ndocument.cancel_certify.item_id.value=item_id;\r\n    if(confirm(\"<{$smarty.const._MD_XOONIPS_ITEM_CANCEL_CERTIFY_CONFIRMATION_MESSAGE}>\"))\r\n        document.cancel_certify.submit();\r\n}\r\n</SCRIPT>\r\n\r\n<br/>\r\n\r\n<{if $modify_button_visible==1}>\r\n<form name=\'modify\' action=\"edit.php\" method=\"POST\">\r\n<input type=\"hidden\" name=\"item_id\" value=\"<{$item_id}>\"/>\r\n</form>\r\n<{/if}>\r\n\r\n<{if $delete_button_visible==1}>\r\n<form name=\'delete_item\' action=\"detail.php\" method=\"POST\">\r\n<input type=\"hidden\" name=\"item_id\" value=\"<{$item_id}>\"/>\r\n<input type=\"hidden\" name=\"op\" value=\"delete\"/>\r\n</form>\r\n<{/if}>\r\n\r\n<{if $print_button_visible==1}>\r\n<form name=\'print\' action=\"detail.php\" method=\"POST\" target=\"blank\">\r\n<input type=\"hidden\" name=\"item_id\" value=\"<{$item_id}>\"/>\r\n<input type=\"hidden\" name=\"op\" value=\"print\"/>\r\n</form>\r\n<{/if}>\r\n\r\n<form name=\'cancel_certify\' action=\"detail.php\" method=\"GET\">\r\n<input type=\"hidden\" name=\"index_id\"/>\r\n<input type=\"hidden\" name=\"item_id\"/>\r\n<input type=\"hidden\" name=\"op\" value=\"cancel_certify\"/>\r\n</form>\r\n\r\n<form name=\'accept_certify\' action=\"detail.php\" method=\"GET\">\r\n<input type=\"hidden\" name=\"index_id\"/>\r\n<input type=\"hidden\" name=\"item_id\"/>\r\n<input type=\"hidden\" name=\"op\" value=\"accept_certify\"/>\r\n</form>\r\n\r\n<form action=\"detail.php\" name=\"detail_form\" method=\"POST\">\r\n<{if $modify_button_visible==1}>\r\n<input type=\"button\" value=\"<{$smarty.const._MD_XOONIPS_ITEM_MODIFY_BUTTON_LABEL}>\" onClick=\"document.modify.submit();\"/>\r\n<{/if}>\r\n<{if $delete_button_visible==1}>\r\n<input type=\"button\" value=\"<{$smarty.const._MD_XOONIPS_ITEM_DELETE_BUTTON_LABEL}>\" onClick=\"delete_confirm()\"/>\r\n<{/if}>\r\n<{if $print_button_visible==1}>\r\n<input type=\"button\" value=\"<{$smarty.const._MD_XOONIPS_ITEM_PRINT_FRIENDLY_BUTTON_LABEL}>\" onClick=\"document.print.submit();\"/>\r\n<{/if}>\r\n</form>\r\n\r\n\r\n<br/><br/>\r\n\r\n<{$body}>\r\n\r\n<br /><br />\r\n\r\n<{foreach key=k item=v from=$http_vars}>\r\n <input type=\"hidden\" name=\"<{$k}>\" value=\"<{$v}>\"/>\r\n<{/foreach}>\r\n\r\n <input type=\"hidden\" name=\"item_id\" value=\"<{$item_id}>\"/>\r\n <input type=\'hidden\' name=\'index_id\'/>\r\n\r\n</form>');
INSERT INTO x_tplsource VALUES (34,'<{*\r\n\r\n$http_vars	ڡžѥ᡼Ϣ\r\n$i	\r\n$indecies\r\n$index\r\n$index_path\r\n$item\r\n$item_count_label\r\n$item_count_select\r\n$item_htmls	ƥƥξ(Ϣ)Ϣι¤ϰʲ\r\n    array( \'selected\' => (1:åޡ 0:åޡʤ),\r\n           \'html\'     => (ƥγפɽ魯HTML),\r\n           \'item_id\'  => ƥID )\r\n$itemcount	ڡɽ륢ƥ\r\n$jumpto_url	Submit˥פURL\r\n$jumpto_var[]	Submitѥ᡼̾\r\n$maxpage\r\n$order_by_label\r\n$order_by_select\r\n$page\r\n$page_no_label\r\n$pages\r\n$search_var[]	Submitѥ᡼̾\r\n$selected\r\n$title_edit\r\n$title_page\r\n$title_register\r\n$url_for_get	Υڡľɽ뤿URL\r\n\r\n*}>\r\n\r\n<script>\r\nfunction mysubmit(page)\r\n{\r\n    document.getElementsByName( \'page\').item(0).value=page;\r\n//    window.alert(\"mysubmit\");\r\n    document.getElementsByName( \'itemselectform\').item(0).submit();\r\n    return false;\r\n}\r\n</script>\r\n\r\n<{if !empty( $pankuzu )}>\r\n<p><{$pankuzu}></p>\r\n<{/if}>\r\n\r\n<p>\r\n<h3><{$title_page}></h3>\r\n</p>\r\n\r\n<p>\r\n<h4><{$title_register}></h4>\r\n<center>\r\n\r\n<form name=\"itemselectform\" action=\"<{$jumpto_url}>\" method=\"POST\">\r\n<table width=\"100%\" border=\"0\" cellspacing=\"5\">\r\n  <tr valign=\"top\" class=\"odd\">\r\n    <td>\r\n     <{$order_by_label}>\r\n     <select name=\"orderby\" onchange=\"action=\'\'; submit();\">\r\n<{foreach key=key item=item from=$order_by_select}>\r\n      <option value=\"<{$key}>\" <{if $key==$orderby}> selected <{/if}> ><{$item}></option>\r\n<{/foreach}>\r\n     </select>\r\n    </td>\r\n    <td>\r\n     <{$item_count_label}>\r\n     <select name=\"itemcount\" onchange=\"action=\'\'; submit();\">\r\n<{foreach item=i from=$item_count_select}>\r\n      <option value=\"<{$i}>\" <{if $i==$itemcount }> selected <{/if}> ><{$i}></option>\r\n<{/foreach}>\r\n     </select>\r\n    </td>\r\n  </tr>\r\n<{if !empty($url_for_get) }>\r\n  <tr class=\"even\">\r\n    <td colspan=\'2\'>\r\n      <input type=\'text\' name=\'url_for_get\' value=\'<{$url_for_get}>\' size=\'80\' readonly />\r\n    </td>\r\n  </tr>\r\n<{/if}>\r\n</table> \r\n</center>\r\n<input type=\"hidden\" name=\"page\" value=\"1\" />\r\n</p>\r\n\r\n\r\n<p>\r\n<h4><{$title_edit}></h4>\r\n<{foreach item=index from=$index_path}>\r\n/ <a href=\"\"><{$index}></a>\r\n<{/foreach}>\r\n</p>\r\n\r\n<p>\r\n<{$page_no_label}>\r\n</p>\r\n\r\n<{if $maxpage > 1}>\r\n<div align=\"right\">\r\n<{if $page > 1}>\r\n<a href=\"javascript:void(0);\" onclick=\"action=\'\'; return mysubmit(<{$prevpage}>);\">PREV</a>\r\n<{else}>\r\nPREV&nbsp;\r\n<{/if}>\r\n\r\n<{foreach item=i from=$pages}>\r\n<{if $i==$page}>\r\n<{$i}>\r\n<{else}>\r\n<a href=\"javascript:void(0);\" onclick=\"action=\'\'; return mysubmit(<{$i}>);\"><{$i}></a>\r\n<{/if}>\r\n&nbsp;\r\n<{/foreach}>\r\n\r\n<{if $page < $maxpage }>\r\n<a href=\"javascript:void(0);\" onclick=\"action=\'\'; return mysubmit(<{$nextpage}>);\">NEXT</a>\r\n<{else}>\r\nNEXT\r\n<{/if}>\r\n</div>\r\n<{/if}>\r\n\r\n<table width=\"100%\" border=\"0\" cellspacing=\"5\">\r\n<{foreach item=i from=$item_htmls}>\r\n  <tr valign=\"top\" class=\"<{cycle values=\"odd,even\"}>\">\r\n<{if $checkbox==\'on\'}>\r\n    <td alingn=\'center\'>\r\n     <{if $i.selected==1}>\r\n     <input type=\'checkbox\' name=\'selected[]\' value=\'<{$i.item_id}>\' checked/>\r\n     <{else}>\r\n     <input type=\'checkbox\' name=\'selected[]\' value=\'<{$i.item_id}>\'/>\r\n     <{/if}>\r\n    </td>\r\n<{/if}>\r\n    <td>\r\n     <{$i.html}>\r\n    </td>\r\n  </tr>\r\n<{/foreach}>\r\n</table>\r\n\r\n<{if $maxpage > 1}>\r\n<div align=\"right\">\r\n<{if $page > 1}>\r\n<a href=\"javascript:void(0);\" onclick=\"action=\'\'; return mysubmit(<{$prevpage}>);\">PREV</a>\r\n<{else}>\r\nPREV&nbsp;\r\n<{/if}>\r\n\r\n<{foreach item=i from=$pages}>\r\n<{if $i==$page}>\r\n<{$i}>\r\n<{else}>\r\n<a href=\"javascript:void(0);\" onclick=\"action=\'\'; return mysubmit(<{$i}>);\"><{$i}></a>\r\n<{/if}>\r\n&nbsp;\r\n<{/foreach}>\r\n\r\n<{if $page < $maxpage }>\r\n<a href=\"javascript:void(0);\" onclick=\"action=\'\'; return mysubmit(<{$nextpage}>);\">NEXT</a>\r\n<{else}>\r\nNEXT\r\n<{/if}>\r\n</div>\r\n<{/if}>\r\n\r\n<br />\r\n\r\n<{foreach key=k item=v from=$http_vars}>\r\n <input type=\"hidden\" name=\"<{$k}>\" value=\"<{$v}>\"/>\r\n<{/foreach}>\r\n<{foreach item=id from=$selected}>\r\n <input type=\"hidden\" name=\"selected[]\" value=\"<{$id}>\"/>\r\n<{/foreach}>\r\n<{foreach item=id from=$initially_selected}>\r\n <input type=\"hidden\" name=\"initially_selected[]\" value=\"<{$id}>\"/>\r\n<{/foreach}>\r\n<{foreach item=i from=$jumpto_var}>\r\n <input type=\"hidden\" name=\"jumpto_var[]\" value=\"<{$i}>\"/>\r\n<{/foreach}>\r\n<{foreach item=i from=$search_var}>\r\n <input type=\"hidden\" name=\"search_var[]\" value=\"<{$i}>\"/>\r\n<{/foreach}>\r\n <input type=\"hidden\" name=\"jumpto_url\" value=\"<{$jumpto_url}>\"/>\r\n\r\n<input type=\"hidden\" name=\"index_id\" value=\"<{$index_id}>\" />\r\n<input type=\"hidden\" name=\"op\" value=\"<{$op}>\"/>\r\n<{if $checkbox==\'on\'}>\r\n <input type=\"submit\"\r\n value=\"<{$smarty.const._MD_XOONIPS_ITEM_SELECT_BUTTON_LABEL}>\" onclick=\"op.value=\'add_selected_item\'\"/>\r\n<{/if}>\r\n<input type=\"hidden\" name=\"checkbox\" value=\"<{$checkbox}>\"/>\r\n<input type=\"hidden\" name=\"add_to_index_id\" value=\"<{$add_to_index_id}>\"/>\r\n</form>\r\n\r\n<!-- end module search results loop -->');
INSERT INTO x_tplsource VALUES (35,'<{* 򥳥ȥ(publication_date) *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<{html_select_date year_as_text=\"true\" month_format=\"%b\" prefix=\"publicationDate\" time=$gmtime}>');
INSERT INTO x_tplsource VALUES (36,'<{* 򥳥ȥ(publication_year) *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<{html_select_date year_as_text=true prefix=\"publicationDate\" time=$gmtime display_days=false display_months=false}>');
INSERT INTO x_tplsource VALUES (37,'<{* 򥳥ȥ(publication_month) *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<{html_select_date month_format=\"%b\" prefix=\"publicationDate\" time=$gmtime display_days=false display_years=false}>');
INSERT INTO x_tplsource VALUES (38,'<{* 򥳥ȥ(publication_mday) *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<{html_select_date prefix=\"publicationDate\" time=$gmtime display_months=false display_years=false}>');
INSERT INTO x_tplsource VALUES (39,'<{* 򥳥ȥ() *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table>\r\n <tr>\r\n  <td><input type=\'checkbox\' name=\'<{$prefixFrom}>\'/><{$smarty.const._MD_XOONIPS_ITEM_FROM_LABEL}></td>\r\n  <td><{html_select_date year_as_text=\"true\" month_format=\"%b\" prefix=$prefixFrom time=$gmtimeFrom}></td>\r\n </tr>\r\n <tr>\r\n  <td><input type=\'checkbox\' name=\'<{$prefixTo}>\'/><{$smarty.const._MD_XOONIPS_ITEM_TO_LABEL}></td>\r\n  <td><{html_select_date year_as_text=\"true\" month_format=\"%b\" prefix=$prefixTo time=$gmtimeTo}></td>\r\n </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (40,'<{* 򥳥ȥ(publication_year) *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table>\r\n <tr>\r\n  <td><input type=\'checkbox\' name=\'<{$prefixFrom}>\'/><{$smarty.const._MD_XOONIPS_ITEM_FROM_LABEL}></td>\r\n  <td><{html_select_date year_as_text=true prefix=$prefixFrom time=$gmtime display_days=false display_months=false}></td>\r\n </tr>\r\n <tr>\r\n  <td><input type=\'checkbox\' name=\'<{$prefixTo}>\'/><{$smarty.const._MD_XOONIPS_ITEM_TO_LABEL}></td>\r\n  <td><{html_select_date year_as_text=true prefix=$prefixTo time=$gmtime display_days=false display_months=false}></td>\r\n </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (41,'<{* 򥳥ȥ(publication_month) *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table>\r\n <tr>\r\n  <td><input type=\'checkbox\' name=\'<{$prefixFrom}>\'/><{$smarty.const._MD_XOONIPS_ITEM_FROM_LABEL}></td>\r\n  <td><{html_select_date month_format=\"%b\" prefix=$prefixFrom time=$gmtime display_days=false display_years=false}></td>\r\n </tr>\r\n <tr>\r\n  <td><input type=\'checkbox\' name=\'<{$prefixTo}>\'/><{$smarty.const._MD_XOONIPS_ITEM_TO_LABEL}></td>\r\n  <td><{html_select_date month_format=\"%b\" prefix=$prefixTo time=$gmtime display_days=false display_years=false}></td>\r\n </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (42,'<{* 򥳥ȥ(publication_mday) *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table>\r\n <tr>\r\n  <td><input type=\'checkbox\' name=\'<{$prefixFrom}>\'/><{$smarty.const._MD_XOONIPS_ITEM_FROM_LABEL}></td>\r\n  <td><{html_select_date prefix=$prefixFrom time=$gmtime display_months=false display_years=false}></td>\r\n </tr>\r\n <tr>\r\n  <td><input type=\'checkbox\' name=\'<{$prefixTo}>\'/><{$smarty.const._MD_XOONIPS_ITEM_TO_LABEL}></td>\r\n  <td><{html_select_date prefix=$prefixTo time=$gmtime display_months=false display_years=false}></td>\r\n </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (43,'<{*\r\n  $Revision: 1.5 $\r\n*}>\r\n\r\n<{if !empty( $pankuzu )}>\r\n<p><{$pankuzu}></p>\r\n<{/if}>\r\n\r\n<h3><{$smarty.const._MD_XOONIPS_ITEM_ADVANCED_SEARCH_TITLE}></h3>\r\n<form action=\'<{$itemselect_url}>\' method=\'POST\'>\r\n\r\n<center>\r\n <input type=\'submit\' value=\'<{$smarty.const._MD_XOONIPS_ITEM_SEARCH_BUTTON_LABEL}>\'/>\r\n</center>\r\n<br>\r\n\r\n<{foreach item=block from=$search_blocks}>\r\n<{$block}>\r\n<br>\r\n<{/foreach}>\r\n\r\n<center>\r\n <input type=\'submit\' value=\'<{$smarty.const._MD_XOONIPS_ITEM_SEARCH_BUTTON_LABEL}>\'/>\r\n</center>\r\n\r\n<input type=\'hidden\' name=\'op\' value=\'advancedsearch\'>\r\n<input type=\"hidden\" name=\"checkbox\" value=\"<{$checkbox}>\"/>\r\n<input type=\"hidden\" name=\"add_to_index_id\" value=\"<{$add_to_index_id}>\"/>\r\n<input type=\"hidden\" name=\"jumpto_url\" value=\"<{$jumpto_url}>\"/>\r\n<{foreach item=i from=$jumpto_var}>\r\n <input type=\"hidden\" name=\"jumpto_var[]\" value=\"<{$i}>\"/>\r\n<{/foreach}>\r\n<{foreach key=name item=value from=$jumpto_var_var}>\r\n <input type=\"hidden\" name=\"<{$name}>\" value=\"<{$value}>\"/>\r\n<{/foreach}>\r\n<{foreach item=i from=$search_var}>\r\n <input type=\"hidden\" name=\"search_var[]\" value=\"<{$i}>\"/>\r\n<{/foreach}>\r\n\r\n</form>');
INSERT INTO x_tplsource VALUES (44,'<{*  *}>\r\n<{* $Revision: 1.5 $ *}>');
INSERT INTO x_tplsource VALUES (45,'<{* $Revision: 1.5 $ *}>\r\n\r\n<p>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_MODERATOR}>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR}>\r\n<{$smarty.const._MI_XOONIPS_MODERATOR_PANKUZU_EDIT_GROUPS}>\r\n<{if !empty( $gname )}>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR}>\r\n<{$gname}>\r\n<{/if}>\r\n</p>\r\n\r\n<{if $op eq \"\" or $op eq \"list\" or $op eq \"register\" or $op eq \"update\" or $op eq \"delete\" }>\r\n<p>\r\n<table class=\"outer\" cellspacing=\"1\" cellpadding=\"4\">\r\n  <tr>\r\n    <th><{$smarty.const._MD_XOONIPS_MODERATOR_GNAME}></th>\r\n    <th><{$smarty.const._MD_XOONIPS_MODERATOR_GDESC}></th>\r\n    <th><{$smarty.const._MD_XOONIPS_MODERATOR_OPERATION}></th>\r\n  </tr>\r\n<{foreach from=$groups item=grp}>\r\n  <tr>\r\n    <td class=\"head\"><{$grp.gname|escape}></td>\r\n    <td class=\"<{cycle name=\"row1\" values=\"even,odd\"}>\"><{$grp.gdesc|escape}></td>\r\n    <td class=\"<{cycle name=\"row2\" values=\"even,odd\"}>\">\r\n      <a href=\'editgroups.php?op=edit&gid=<{$grp.gid}>\'><{$smarty.const._MD_XOONIPS_MODERATOR_EDIT}></a> /\r\n      <a href=\'editgroups.php?op=delete&gid=<{$grp.gid}>\' onClick=\"return askDeleteGroup(<{$grp.gid}>)\"><{$smarty.const._MD_XOONIPS_MODERATOR_DELETE}></a>\r\n<!--      <a onClick=askDeleteGroup(<{$grp.gid}>)><{$smarty.const._MD_XOONIPS_MODERATOR_DELETE}></a> -->\r\n    </td>\r\n  </tr>\r\n<{/foreach}>\r\n</table>\r\n</p>\r\n<{/if}>\r\n\r\n<{if $op eq \"\" or $op eq \"list\" or $op eq \"register\" or $op eq \"update\" or $op eq \"edit\" or $op eq \"delete\" }>\r\n<p>\r\n<form name=\'groupinfo\' action=\'editgroups.php\' onsubmit=\'return xoopsFormValidate_groupinfo();\' method=\'post\'>\r\n<table class=\"outer\" cellspacing=\"1\" cellpadding=\"4\">\r\n <tr>\r\n  <th colspan=\"2\">\r\n<{if $op eq \"edit\"}>\r\n<{$smarty.const._MD_XOONIPS_MODERATOR_EDIT_GROUP}>\r\n<input type=\'hidden\' name=\'op\' value=\'update\'>\r\n<input type=\'hidden\' name=\'gid\' value=\'<{$gid}>\'>\r\n<{else}>\r\n<{$smarty.const._MD_XOONIPS_MODERATOR_CREATE_GROUP}>\r\n<input type=\'hidden\' name=\'op\' value=\'register\'>\r\n<{/if}>\r\n  </th>\r\n </tr>\r\n <tr>\r\n  <td class=\"head\"><{$smarty.const._MD_XOONIPS_MODERATOR_GNAME}></td>\r\n  <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\"><input type=\'text\' name=\'gname\' value=\'<{$gname|escape}>\'></td>\r\n </tr>\r\n <tr>\r\n  <td class=\"head\"><{$smarty.const._MD_XOONIPS_MODERATOR_GDESC}></td>\r\n  <td class=\"<{cycle name=\"oddeven\"}>\"><textarea name=\'gdesc\'><{$gdesc|escape}></textarea></td>\r\n </tr>\r\n <tr>\r\n  <td class=\"head\"><{$smarty.const._MD_XOONIPS_MODERATOR_GROUP_ADMIN}></td>\r\n  <td class=\"<{cycle name=\"oddeven\"}>\">\r\n   <select name=\"gadmins[]\" size=\"10\" multiple=\"multiple\">\r\n    <{foreach from=$gadmins item=user}>\r\n    <option value=\"<{$user.uid}>\"<{if $user.isadmin eq 1}>selected<{/if}>><{$user.uname|escape}></option>\r\n    <{/foreach}>\r\n   </select>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td class=\"head\"><{$smarty.const._MD_XOONIPS_MODERATOR_ITEM_NUMBER_LIMIT}></td>\r\n  <td class=\"<{cycle name=\"oddeven\"}>\"><input type=\'text\' name=\'item_number_limit\' value=\'<{$item_number_limit}>\'></td>\r\n </tr>\r\n <tr>\r\n  <td class=\"head\"><{$smarty.const._MD_XOONIPS_MODERATOR_INDEX_NUMBER_LIMIT}></td>\r\n  <td class=\"<{cycle name=\"oddeven\"}>\"><input type=\'text\' name=\'index_number_limit\' value=\'<{$index_number_limit}>\'></td>\r\n </tr>\r\n <tr>\r\n  <td class=\"head\"><{$smarty.const._MD_XOONIPS_MODERATOR_ITEM_STORAGE_LIMIT}></td>\r\n  <td class=\"<{cycle name=\"oddeven\"}>\"><input type=\'text\' name=\'item_storage_limit\' value=\'<{$item_storage_limit}>\'></td>\r\n </tr>\r\n <tr>\r\n  <td class=\"head\" colspan=\"2\">\r\n   <input type=\'submit\' name=\'submit\' value=\'<{$smarty.const._US_SUBMIT}>\'>\r\n  </td>\r\n </tr>\r\n</table>\r\n</form>\r\n</p>\r\n<{/if}>\r\n\r\n<script type=\'text/javascript\'>\r\n<!--//\r\nfunction xoopsFormValidate_groupinfo() {\r\n	myform = window.document.groupinfo;\r\n	if ( myform.gname.value == \"\" ) { window.alert(\"<{$smarty.const._MD_XOONIPS_MODERATOR_ENTER_GROUP_NAME}>\"); myform.gname.focus(); return false; }\r\n	return true;\r\n}\r\nfunction askDeleteGroup(gid){\r\n	if( confirm(\'<{$smarty.const._MD_XOONIPS_MODERATOR_REALLY_DELETE}>\')){\r\n		//document.location=\'editgroups.php?op=delete&gid=\' . gid;\r\n		return true;\r\n	}\r\n	return false;\r\n}\r\n//--></script>');
INSERT INTO x_tplsource VALUES (46,'<{* 桼ǧڡ *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<p>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_MODERATOR}>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR}>\r\n<{$smarty.const._MI_XOONIPS_MODERATOR_PANKUZU_CERTIFY_USERS}>\r\n</p>\r\n\r\n<{if !empty( $users ) }>\r\n<table class=\"outer\" cellspacing=\"1\" cellpadding=\"4\">\r\n  <tr>\r\n    <th><{$smarty.const._US_USERNAME}></th>\r\n    <th><{$smarty.const._US_REALNAME}></th>\r\n    <th><{$smarty.const._US_EMAIL}></th>\r\n    <th><{$smarty.const._MD_XOONIPS_MODERATOR_DETAIL}></th>\r\n    <th><{$smarty.const._MD_XOONIPS_MODERATOR_CERTIFY}></th>\r\n  </tr>\r\n<{foreach from=$users item=user}>\r\n  <tr>\r\n    <td class=\"head\"><{$user.uname}></td>\r\n    <td class=\"<{cycle name=\"row1\" values=\"even,odd\"}>\"><{$user.name}></td>\r\n    <td class=\"<{cycle name=\"row2\" values=\"even,odd\"}>\"><a href=\'mailto:<{$user.email}>\'>mail</a></td>\r\n    <td class=\"<{cycle name=\"row3\" values=\"even,odd\"}>\"><a href=\'userinfo.php?uid=<{$user.uid}>\'><{$smarty.const._MD_XOONIPS_MODERATOR_DETAIL}></a></td>\r\n    <td class=\"<{cycle name=\"row4\" values=\"even,odd\"}>\"><a href=\'certifyuser.php?op=certify&certify_uid=<{$user.uid}>\'><{$smarty.const._MD_XOONIPS_MODERATOR_CERTIFY}></a></td>\r\n    </td>\r\n  </tr>\r\n<{/foreach}>\r\n</table>\r\n<{else}>\r\n   <p>\r\n   <{$smarty.const._MD_XOONIPS_MODERATOR_NO_CERTIFY_USERS}>\r\n   </p>\r\n<{/if}>');
INSERT INTO x_tplsource VALUES (47,'<{* ǥåԽڡ *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<p>\r\n<{if $open_level == 2 || $xid == 1 }><{* group_only or ROOT index *}>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_GROUP_ADMINISTRATOR}>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR}>\r\n<{$smarty.const._MI_XOONIPS_INDEX_PANKUZU_EDIT_GROUP_INDEX_KEYWORD}>\r\n<{elseif $open_level == 1 }>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_MODERATOR}>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR}>\r\n<{$smarty.const._MI_XOONIPS_INDEX_PANKUZU_EDIT_PUBLIC_INDEX_KEYWORD}>\r\n<{elseif $open_level == 3 }>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_PLATFORM_USER}>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR}>\r\n<{$smarty.const._MI_XOONIPS_INDEX_PANKUZU_EDIT_PRIVATE_INDEX_KEYWORD}>\r\n<{/if}>\r\n</p>\r\n\r\n<p>\r\n<h3><{$smarty.const._MD_XOONIPS_INDEX_TITLE_EDIT}></h3>\r\n</p>\r\n\r\n<p>\r\n<{* ֤߰ɽ *}>\r\n<{foreach item=index from=$index_path}>\r\n<{$index.title|escape}> /\r\n<{/foreach}>\r\n</p>\r\n<p>\r\n<hr />\r\n</p>\r\n\r\n<{if $xid != 1 }>\r\n<h4><{$smarty.const._MD_XOONIPS_INDEX_TITLE_ADD}></h4>\r\n<form action=\"editindex.php?op=register\" method=\"POST\">\r\n<{if $limitLabel }>\r\n<{$limitLabel}>: <{$indexCount}> (max=<{$indexNumberLimit}>)<br/>\r\n<{/if}>\r\n<{if $indexCount > $indexNumberLimit }>\r\n<font color=\'red\'><{$smarty.const._MD_XOONIPS_INDEX_TOO_MANY_INDEXES}></font>\r\n<{/if}>\r\n<input type=\"hidden\" name=\"xid\" value=\"<{$xid}>\"/>\r\n<table width=\"100%\" border=\"0\" cellspacing=\"5\">\r\n  <tr valign=\"top\" class=\"head\">\r\n    <th colspan=\"2\"><{$smarty.const._MD_XOONIPS_INDEX_TITLE_NEW_INDEX_KEYWORD}></th>\r\n  </tr>\r\n  <tr valign=\"top\" class=\"odd\">\r\n    <td><input type=\"text\" name=\"new_index_name\" size=30 /></td>\r\n    <td><input type=\"submit\" value=\"<{$smarty.const._MD_XOONIPS_INDEX_BUTTON_REGISTER}>\" /></td>\r\n  </tr>\r\n</table> \r\n</form>\r\n\r\n<p>\r\n<hr />\r\n</p>\r\n<{/if}>\r\n\r\n<h4><{$smarty.const._MD_XOONIPS_INDEX_TITLE_MODIFY}></h4>\r\n<{if $childCount == 0 }>\r\n<{$smarty.const._MD_XOONIPS_INDEX_NO_INDEX}>\r\n<{else}>\r\n<{if $error_message}>\r\n<{foreach item=error_message from=$error_message}>\r\n  <font color=\'red\'><{$error_message|escape}></font><br>\r\n<{/foreach}>\r\n<{/if}>\r\n<script type=\"text/javascript\">\r\n<!--\r\n// checkboxonrenameʤ顢顼ˤ롥\r\nfunction canRename(submit){\r\n    var form = submit.form;\r\n    var elements = form.elements;\r\n    var elementsLen = elements.length;\r\n    var i;\r\n    var error = false;\r\n    \r\n    for ( i = 0; i < elementsLen; i++ ){\r\n        var element = elements.item(i);\r\n        if ( element.id.substring(0,13) == \'xoonipsCheck\' && element.checked ){\r\n            var xid = element.id.substring(13);\r\n            var rename = document.getElementById(\'xoonipsRename\' + xid);\r\n            if ( rename != undefined ){\r\n                if ( rename.value == \"\" ){\r\n                    error = true;\r\n                }\r\n            }\r\n        }\r\n    }\r\n    \r\n    if ( error ){\r\n        window.alert(\"<{$smarty.const._MD_XOONIPS_INDEX_NAME_CANNOT_BE_EMPTY}>\");\r\n        return false;\r\n    }\r\n    return true;\r\n}\r\n\r\nfunction xoonipsUpDown( op, updown_xid ) {\r\n	document.getElementById(\'xoonips_op\').value = op;\r\n	document.getElementById(\'xoonips_updown_xid\').value = updown_xid;\r\n	document.getElementById(\'xoonips_updown_xid\').value = updown_xid;\r\n	document.getElementById(\'xoonips_modify_form\').submit();\r\n	return false;\r\n}\r\n\r\n//-->\r\n</script>\r\n\r\n<form action=\"editindex.php\" method=\"POST\" id=\"xoonips_modify_form\">\r\n<input type=\"hidden\" name=\"xid\" value=\"<{$xid}>\"/>\r\n<input type=\"hidden\" name=\"updown_xid\" value=\"\" id=\"xoonips_updown_xid\"/>\r\n<input type=\"hidden\" name=\"op\" value=\"\" id=\"xoonips_op\"/>\r\n<table width=\"100%\" border=\"0\" cellspacing=\"5\">\r\n  <tr valign=\"top\">\r\n    <th></th>\r\n    <th><{$smarty.const._MD_XOONIPS_INDEX_INDEX_KEYWORD}></th>\r\n    <th><{$smarty.const._MD_XOONIPS_INDEX_RENAME_TO}></th>\r\n    <th><{$smarty.const._MD_XOONIPS_INDEX_LABEL_UPDOWN}></th>\r\n  </tr>\r\n<{foreach item=index from=$child_indexes}>\r\n  <tr valign=\"top\" class=\"<{cycle values=\"even,odd\"}>\">\r\n    <td><input type=\"checkbox\" name=\"check[]\" value=\"<{$index.item_id}>\" id=\"xoonipsCheck<{$index.item_id}>\"/></td>\r\n    <td><{$index.title|escape}></td>\r\n    <td><input type=\"text\" name=\"rename[<{$index.item_id}>]\" size=25 id=\"xoonipsRename<{$index.item_id}>\"/></td>\r\n    <td>\r\n      <select name=\"steps[<{$index.item_id}>]\">\r\n      <{html_options options=$updown_options selected=1}>\r\n      </select>\r\n      <a href=\"\" onClick=\"return xoonipsUpDown(\'up\',<{$index.item_id}>)\"><{$smarty.const._MD_XOONIPS_INDEX_LABEL_UP}></a>\r\n    / <a href=\"\" onClick=\"return xoonipsUpDown(\'down\',<{$index.item_id}>)\"><{$smarty.const._MD_XOONIPS_INDEX_LABEL_DOWN}></a></td>\r\n\r\n  </tr>\r\n<{/foreach}>\r\n  <tr>\r\n    <td><img src=\"images/arrow_ltr.png\"></td>\r\n    <td colspan=3>\r\n      <table><tr>\r\n      <td>\r\n        <{$smarty.const._MD_XOONIPS_INDEX_LABEL_WITH_SELECTED}>\r\n      </td>\r\n      <td>\r\n        <input type=\"submit\" value=\"<{$smarty.const._MD_XOONIPS_INDEX_BUTTON_RENAME}>\" name=\"op_rename\" onclick=\"return canRename(this)\"/> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n      </td>\r\n      <td>\r\n        <input type=\"submit\" value=\"<{$smarty.const._MD_XOONIPS_INDEX_BUTTON_DELETE}>\" name=\"op_delete\"/> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n      </td>\r\n      <td>\r\n        <input type=\"submit\" value=\"<{$smarty.const._MD_XOONIPS_INDEX_BUTTON_MOVETO}>\" name=\"op_moveto\"/>\r\n      </td>\r\n      <td>\r\n        <select name=\"moveto\">\r\n        <{foreach item=to from=$index_tree}>\r\n        <option value=\"<{$to.item_id}>\"><{$to.indent_html}><{$to.select_label|escape}></option>\r\n        <{/foreach}>\r\n        </select>\r\n      </td>\r\n      </tr></table>\r\n    </td>\r\n  </tr>\r\n</table>\r\n<br />\r\n<{/if}>\r\n\r\n</form>\r\n<!-- end module search results loop -->');
INSERT INTO x_tplsource VALUES (48,'<{*  *}>\r\n<{* $Revision: 1.5 $ *}>');
INSERT INTO x_tplsource VALUES (49,'<{* xoonips list block\r\n\r\n$item_detail.itemcount	ƥ\r\n$item_detail.items[]	ХϿƤ륢ƥδܾ\r\n\r\n *}>\r\n<{* $Revision *}>\r\n\r\n<table>\r\n <tr>\r\n  <td width=\'10%\' style=\'vertical-align:middle; text-align:center;\'>\r\n   <img src=\"<{$smarty.const.XOOPS_URL}>/modules/xoonips/images/icon_binder.gif\">\r\n  </td> \r\n  <td width=\'90%\'>\r\n   <a href=\"<{$xoops_url}>/modules/xoonips/detail.php?item_id=<{$item_basic.item_id}>\"><{$item_basic.title|escape}></a><br>\r\n   <{$item_basic.description|escape}><br>\r\n  </td>\r\n  <td>\r\n    <{if !empty($pending) && $pending}>(Pending)<{/if}>\r\n  </td>\r\n </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (50,'<{* xoonips register block\r\n$detail	ХϿͽΥƥξ\r\n	array(\'html\'=>ƥHTML\'item_id\' => ƥID)\r\n$jumpto_url	ɲä륢ƥڡURL\r\n*}>\r\n<{* $Revision: 1.5 $ *}>\r\n<!-- begin of xoonips_register_block.html -->\r\n\r\n<script type=\"text/javascript\">\r\n//return true if all required parameters are filled\r\n<!--\r\nfunction onSubmitItemType( ){\r\n	return true;\r\n}\r\n//-->\r\n</script>\r\n\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n<{*\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.item_type.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.item_type.value}></td>\r\n  </tr>\r\n*}>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_log.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_log.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n<{*\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n*}>\r\n</table>\r\n\r\n<h4><{$smarty.const._MD_XOONIPS_BINDER_ITEMS_TO_REGISTER_TITLE}></h4>\r\n\r\n<p>\r\n<center>\r\n <input type=\'hidden\' name=\'jumpto_url\' value=\'<{$jumpto_url}>\'>\r\n <input type=\'hidden\' name=\'jumpto_var[]\' value=\'item_id\'>\r\n <input type=\'hidden\' name=\'jumpto_var[]\' value=\'xoonips_item_id\'>\r\n <input type=\'hidden\' name=\'jumpto_var[]\' value=\'checkbox\'>\r\n <input type=\'hidden\' name=\'checkbox\' vaue=\'off\'/>\r\n \r\n <input type=\'hidden\' name=\'index_id\'>\r\n <table class=\"outer\">\r\n  <tr>\r\n   <th colspan=3>\r\n    <{$smarty.const._MI_XOONIPS_BINDER_ADD_FROM_COLUMN_LABEL}>\r\n   </th>\r\n  </tr>\r\n  <tr>\r\n   <td>\r\n    <input type=\"button\" name=\"add_from_item_list\"\r\n    value=\"<{$smarty.const._MI_XOONIPS_BINDER_ADD_FROM_ITEM_LIST_BUTTON_LABEL}>\"\r\n    onclick=\"checkbox.value=\'on\'; op.value=\'useritem\'; jumpto_url.value=\'<{$jumpto_url}>\'; action=\'<{$smarty.const.XOOPS_URL}>/modules/xoonips/itemselect_register.php\'; submit();\"/>\r\n   </td>\r\n   <td>\r\n    <input type=\"button\" name=\"add_from_index\"\r\n    value=\"<{$smarty.const._MI_XOONIPS_BINDER_ADD_FROM_INDEX_BUTTON_LABEL}>\"\r\n    onclick=\"index_id.value=1; checkbox.value=\'on\'; op.value=\'index\'; jumpto_url.value=\'<{$jumpto_url}>\'; action=\'<{$smarty.const.XOOPS_URL}>/modules/xoonips/itemselect_register.php\'; submit();\"/>\r\n   </td>\r\n   <td>\r\n    <input type=\"button\" name=\"add_from_search\"\r\n    value=\"<{$smarty.const._MI_XOONIPS_BINDER_ADD_FROM_SEARCH_BUTTON_LABEL}>\"\r\n    onclick=\"checkbox.value=\'on\'; jumpto_url.value=\'<{$jumpto_url}>\'; action=\'<{$smarty.const.XOOPS_URL}>/modules/xoonips/advanced_search_register.php\'; submit();\"/>\r\n   </td>\r\n  </tr>\r\n </table>\r\n</center>\r\n</p>\r\n\r\n<!-- Binder Item Detail Information -->\r\n<table width=\"100%\" border=\"0\" cellspacing=\"5\">\r\n<{foreach item=i from=$detail}>\r\n  <tr valign=\"top\" class=\"<{cycle values=\"odd,even\"}>\">\r\n    <td alingn=\'center\'>\r\n     <input type=\'checkbox\' name=\'selected[]\' value=\'<{$i.item_id}>\'/>\r\n    </td>\r\n    <td>\r\n     <{$i.html}>\r\n    </td>\r\n  </tr>\r\n<{/foreach}>\r\n</table>\r\n<{foreach item=i from=$detail}>\r\n  <input type=\'hidden\' name=\'xoonips_item_id[]\' value=\'<{$i.item_id}>\'/>\r\n<{/foreach}>\r\n<input type=\'hidden\' name=\'op\'\'/>\r\n<input type=\"button\" name=\"delete_item\"\r\n value=\"<{$smarty.const._MI_XOONIPS_BINDER_DELETE_CHECKED_ITEM_BUTTON_LABEL}>\" onclick=\"op.value=\'delete\'; action=\'<{$jumpto_url}>\'; submit();\"/>\r\n\r\n<!-- end of xoonips_register_block.html -->');
INSERT INTO x_tplsource VALUES (51,'<{*\r\n xoonips detail block\r\n*}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"odd\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"even\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"odd\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"odd\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"even\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"odd\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.item_type.name}></td>\r\n    <td class=\"even\"><{$basic.item_type.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"odd\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n<{*\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"even\"><{$index.value}></td>\r\n  </tr>\r\n*}>\r\n</table>\r\n\r\n<!-- Dummy Item Detail Information -->\r\n<h4><{$smarty.const._MD_XOONIPS_BINDER_REGISTERED_ITEMS_TITLE}></h4>\r\n<!-- Binder Item Detail Information -->\r\n<table width=\"100%\" border=\"0\" cellspacing=\"5\">\r\n<{foreach item=i from=$detail}>\r\n  <tr valign=\"top\" class=\"<{cycle values=\"odd,even\"}>\">\r\n    <td>\r\n     <{$i.html}>\r\n    </td>\r\n  </tr>\r\n<{/foreach}>\r\n\r\n</table>');
INSERT INTO x_tplsource VALUES (52,'<{* xoonips confirm block\r\n\r\n$detail	ХϿ줿ƥξ\r\n	array(\'html\'=>ƥHTML\'item_id\' => ƥID)\r\n\r\n *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"odd\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"even\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"odd\" ><{$basic.description.value}></td>\r\n  </tr>\r\n<{*\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"odd\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"even\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"odd\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.item_type.name}></td>\r\n    <td class=\"even\"><{$basic.item_type.value}></td>\r\n  </tr>\r\n*}>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_log.name}></td>\r\n    <td class=\"odd\" ><{$basic.change_log.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"odd\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n</table>\r\n\r\n\r\n<h4><{$smarty.const._MD_XOONIPS_BINDER_ITEMS_TO_REGISTER_TITLE}></h4>\r\n<!-- Binder Item Detail Information -->\r\n<table width=\"100%\" border=\"0\" cellspacing=\"5\">\r\n<{foreach item=i from=$detail}>\r\n  <tr valign=\"top\" class=\"<{cycle values=\"odd,even\"}>\">\r\n    <td>\r\n     <{$i.html}>\r\n    </td>\r\n  </tr>\r\n<{/foreach}>\r\n</table>\r\n<{foreach item=i from=$detail}>\r\n<input type=\'hidden\' name=\'xoonips_item_id[]\' value=\'<{$i.item_id}>\'/>\r\n<{/foreach}>');
INSERT INTO x_tplsource VALUES (53,'<{* 롼״ԸΥڡ *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<p>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_GROUP_ADMINISTRATOR}>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR}>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_EDIT_GROUPS}>\r\n<{if !empty( $gname )}>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR}>\r\n<{$gname}>\r\n<{/if}>\r\n</p>\r\n\r\n<{if $op eq \"\" or $op eq \"list\"}>\r\n\r\n<{* оݥ롼 *}>\r\n<table class=\'outer\' cellspacing=\'1\'>\r\n	<tr>\r\n		<th align=\"center\"><{$smarty.const._MD_XOONIPS_ACCOUNT_GROUPADMIN_GROUP_LIST}></th>\r\n	</tr>\r\n<{foreach from=$groups item=group}>\r\n	<tr>\r\n		<td class=\"<{cycle name=\"row1\" values=\"even,odd\"}>\">\r\n			<a href=\'groupadmin.php?op=modify&gid=<{$group.gid}>\'><{$group.gname|escape}></a>\r\n		</td>\r\n	</tr>\r\n<{/foreach}>\r\n</table>\r\n\r\n<{else}>\r\n\r\n<{* Сɲú *}>\r\n<table class=\"outer\" cellspacing=\"1\">\r\n	<tr>\r\n		<th align=\"center\"><{$smarty.const._MD_XOONIPS_ACCOUNT_GROUPADMIN_NON_MEMBERS}></th>\r\n		<th></th>\r\n		<th align=\"center\"><{$smarty.const._MD_XOONIPS_ACCOUNT_GROUPADMIN_MEMBERS}></th>\r\n	</tr>\r\n	\r\n	<tr>\r\n		<td class=\"even\">\r\n			<form action=\"groupadmin.php\" method=\"POST\">\r\n			<select name=\"uids[]\" size=\"10\" multiple=\"multiple\">\r\n<{foreach from=$nonmembers item=user}>\r\n				<option value=\"<{$user.uid}>\"><{$user.uname}></option>\r\n<{/foreach}>\r\n			</select>\r\n		</td>\r\n		<td align=\"center\" class=\"odd\">\r\n			<input type=\"hidden\" name=\"op\" value=\"addUser\">\r\n			<input type=\"hidden\" name=\"gid\" value=\"<{$gid}>\">\r\n			<input type=\"submit\" name=\"submit\" value=\"<{$smarty.const._MD_XOONIPS_ACCOUNT_GROUPADMIN_ADD_BUTTON}>\">\r\n			</form><br />\r\n			<form action=\"groupadmin.php\" method=\"POST\">\r\n			<input type=\"hidden\" name=\"op\" value=\"delUser\">\r\n			<input type=\"hidden\" name=\"gid\" value=\"<{$gid}>\">\r\n			<input type=\"submit\" name=\"submit\" value=\"<{$smarty.const._MD_XOONIPS_ACCOUNT_GROUPADMIN_DELETE_BUTTON}>\">\r\n		</td>\r\n		<td class=\"even\">\r\n			<select name=\"uids[]\" size=\"10\" multiple=\"multiple\">\r\n<{foreach from=$members item=user}>\r\n				<option value=\"<{$user.uid}>\"><{$user.uname}></option>\r\n<{/foreach}>\r\n			</select>\r\n		</td>\r\n	</tr>\r\n</form>\r\n</table>\r\n<{/if}>');
INSERT INTO x_tplsource VALUES (55,'<{* pX[hYꂽlEpX[hԈႦlp̃y[W *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<fieldset style=\"padding: 10px;\">\r\n  <legend style=\"font-weight: bold;\"><{$smarty.const._LOGIN}></legend>\r\n  <form action=\"user.php\" method=\"post\">\r\n    <{$smarty.const._USERNAME}> <input type=\"text\" name=\"uname\" size=\"26\" maxlength=\"25\" value=\"<{$usercookie}>\" /><br />\r\n    <{$smarty.const._PASSWORD}> <input type=\"password\" name=\"pass\" size=\"21\" maxlength=\"32\" /><br />\r\n    <input type=\"hidden\" name=\"op\" value=\"login\" />\r\n    <input type=\"hidden\" name=\"xoops_redirect\" value=\"<{$redirect_page}>\" />\r\n    <input type=\"submit\" value=\"<{$smarty.const._LOGIN}>\" />\r\n  </form>\r\n  <a name=\"lost\"></a>\r\n  <div><{$smarty.const._MD_XOONIPS_ACCOUNT_NOTREGISTERED1}>\r\n    <a href=\'registeruser.php\'><{$smarty.const._MD_XOONIPS_ACCOUNT_NOTREGISTERED2}></a><br /></div>\r\n</fieldset>\r\n\r\n<br />\r\n\r\n<fieldset style=\"padding: 10px;\">\r\n  <legend style=\"font-weight: bold;\"><{$smarty.const._US_LOSTPASSWORD}></legend>\r\n  <div><br /><{$smarty.const._US_NOPROBLEM}></div>\r\n  <form action=\"lostpass.php\" method=\"post\">\r\n    <{$smarty.const._US_YOUREMAIL}> <input type=\"text\" name=\"email\" size=\"26\" maxlength=\"60\" />&nbsp;&nbsp\r\n    <input type=\"hidden\" name=\"op\" value=\"mailpasswd\" /><input type=\"submit\" value=\"<{$smarty.const._US_SENDPASSWORD}>\" />\r\n  </form>\r\n</fieldset>');
INSERT INTO x_tplsource VALUES (56,'<{* 桼ɽڡ *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<{if $user_ownpage == true}>\r\n\r\n<p>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_PLATFORM_USER}>\r\n<{$smarty.const._MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR}>\r\n<{$smarty.const._MI_XOONIPS_ITEM_PANKUZU_VIEW_ACCOUNT}>\r\n</p>\r\n\r\n<form name=\"usernav\" action=\"user.php\" method=\"post\">\r\n\r\n<br /><br />\r\n\r\n<table width=\"70%\" align=\"center\" border=\"0\">\r\n  <tr align=\"center\">\r\n    <td><input type=\"button\" value=\"<{$lang_editprofile}>\" onclick=\"location=\'edituser.php\'\" />\r\n    <{if $user_candelete == true}>\r\n    <input type=\"button\" value=\"<{$lang_deleteaccount}>\" onclick=\"location=\'../../user.php?op=delete\'\" />\r\n    <{/if}>\r\n\r\n    <input type=\"button\" value=\"<{$lang_logout}>\" onclick=\"location=\'../../user.php?op=logout\'\" /></td>\r\n  </tr>\r\n</table>\r\n</form>\r\n\r\n<br /><br />\r\n<{elseif $xoops_isadmin != false}>\r\n\r\n<br /><br />\r\n\r\n<table width=\"70%\" align=\"center\" border=\"0\">\r\n  <tr align=\"center\">\r\n    <td><input type=\"button\" value=\"<{$lang_editprofile}>\" onclick=\"location=\'<{$xoops_url}>/modules/system/admin.php?fct=users&uid=<{$user_uid}>&op=modifyUser\'\" />\r\n    <input type=\"button\" value=\"<{$lang_deleteaccount}>\" onclick=\"location=\'<{$xoops_url}>/modules/system/admin.php?fct=users&op=delUser&uid=<{$user_uid}>\'\" />\r\n  </tr>\r\n</table>\r\n\r\n<br /><br />\r\n<{/if}>\r\n\r\n<table width=\"100%\" border=\"0\" cellspacing=\"5\">\r\n  <tr valign=\"top\">\r\n    <td width=\"50%\">\r\n      <table class=\"outer\" cellpadding=\"4\" cellspacing=\"1\" width=\"100%\">\r\n        <tr>\r\n          <th colspan=\"2\" align=\"center\"><{$lang_allaboutuser}></th>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_avatar}></td>\r\n          <td align=\"center\" class=\"even\"><img src=\"<{$user_avatarurl}>\" alt=\"Avatar\" /></td>\r\n        </tr>\r\n        <tr>\r\n          <td class=\"head\"><{$lang_realname}></td>\r\n          <td align=\"center\" class=\"odd\"><{$user_realname}></td>\r\n        </tr>\r\n        <tr>\r\n          <td class=\"head\"><{$lang_website}></td>\r\n          <td class=\"even\"><{$user_websiteurl}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_email}></td>\r\n          <td class=\"odd\"><{$user_email}></td>\r\n        </tr>\r\n	<tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_privmsg}></td>\r\n          <td class=\"even\"><{$user_pmlink}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_icq}></td>\r\n          <td class=\"odd\"><{$user_icq}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_aim}></td>\r\n          <td class=\"even\"><{$user_aim}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_yim}></td>\r\n          <td class=\"odd\"><{$user_yim}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_msnm}></td>\r\n          <td class=\"even\"><{$user_msnm}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_location}></td>\r\n          <td class=\"odd\"><{$user_location}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_occupation}></td>\r\n          <td class=\"even\"><{$user_occupation}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_interest}></td>\r\n          <td class=\"odd\"><{$user_interest}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_extrainfo}></td>\r\n          <td class=\"even\"><{$user_extrainfo}></td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n    <td width=\"50%\">\r\n      <table class=\"outer\" cellpadding=\"4\" cellspacing=\"1\" width=\"100%\">\r\n        <tr valign=\"top\">\r\n          <th colspan=\"2\" align=\"center\"><{$lang_statistics}></th>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_membersince}></td>\r\n          <td align=\"center\" class=\"even\"><{$user_joindate}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_rank}></td>\r\n          <td align=\"center\" class=\"odd\"><{$user_rankimage}><br /><{$user_ranktitle}></td>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_posts}></td>\r\n          <td align=\"center\" class=\"even\"><{$user_posts}></td>\r\n        </tr>\r\n	<tr valign=\"top\">\r\n          <td class=\"head\"><{$lang_lastlogin}></td>\r\n          <td align=\"center\" class=\"odd\"><{$user_lastlogin}></td>\r\n        </tr>\r\n      </table>\r\n      <br />\r\n      <table class=\"outer\" cellpadding=\"4\" cellspacing=\"1\" width=\"100%\">\r\n        <tr valign=\"top\">\r\n          <th colspan=\"2\" align=\"center\"><{$lang_signature}></th>\r\n        </tr>\r\n        <tr valign=\"top\">\r\n          <td class=\"even\"><{$user_signature}></td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n</table>\r\n\r\n<br />\r\n\r\n<{if $xnp_user_ownpage == true}>\r\n<table width=\"100%\" border=\"0\" cellspacing=\"5\">\r\n  <tr valign=\"top\">\r\n    <td>\r\n\r\n<table class=\"outer\" cellpadding=\"4\" cellspacing=\"1\" width=\"100%\">\r\n  <tr valign=\"top\">\r\n    <th colspan=\"2\" align=\"center\"><{$smarty.const._MD_XOONIPS_ACCOUNT_XNP_USER_INFO}></th>\r\n  </tr>\r\n  <tr valign=\"top\">\r\n    <td class=\"head\" width=\'50%\'><{$smarty.const._MD_XOONIPS_ACCOUNT_ADDRESS}></td>\r\n    <td class=\"even\" width=\'50%\'><{$xnp_user_address}></td>\r\n  </tr>\r\n  <tr valign=\"top\">\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ACCOUNT_DIVISION}></td>\r\n    <td class=\"odd\"><{$xnp_user_division}></td>\r\n  </tr>\r\n  <tr valign=\"top\">\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ACCOUNT_TEL}></td>\r\n    <td class=\"even\"><{$xnp_user_tel}></td>\r\n  </tr>\r\n  <tr valign=\"top\">\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ACCOUNT_COMPANY_NAME}></td>\r\n    <td class=\"odd\"><{$xnp_user_company_name}></td>\r\n  </tr>\r\n  <tr valign=\"top\">\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ACCOUNT_COUNTRY}></td>\r\n    <td class=\"even\"><{$xnp_user_country}></td>\r\n  </tr>\r\n  <tr valign=\"top\">\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ACCOUNT_ZIPCODE}></td>\r\n    <td class=\"odd\"><{$xnp_user_zipcode}></td>\r\n  </tr>\r\n  <tr valign=\"top\">\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ACCOUNT_FAX}></td>\r\n    <td class=\"even\"><{$xnp_user_fax}></td>\r\n  </tr>\r\n  <tr valign=\"top\">\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ACCOUNT_NOTICE_MAIL}></td>\r\n    <td class=\"odd\"><{$xnp_user_notice_mail}></td>\r\n  </tr>\r\n</table>\r\n    </td>\r\n  </tr>\r\n</table>\r\n\r\n<{/if}>\r\n<!-- start module search results loop -->\r\n<{foreach item=module from=$modules}>\r\n\r\n<p>\r\n<h4><{$module.name}></h4>\r\n\r\n  <!-- start results item loop -->\r\n  <{foreach item=result from=$module.results}>\r\n\r\n  <img src=\"<{$result.image}>\" alt=\"<{$module.name}>\" /><b><a href=\"<{$result.link}>\"><{$result.title}></a></b><br /><small>(<{$result.time}>)</small><br />\r\n\r\n  <{/foreach}>\r\n  <!-- end results item loop -->\r\n\r\n<{$module.showall_link}>\r\n</p>\r\n\r\n<{/foreach}>\r\n<!-- end module search results loop -->');
INSERT INTO x_tplsource VALUES (57,'<{* xoonips main page *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\nxoonips module top page');
INSERT INTO x_tplsource VALUES (58,'<{* quick search block *}>\r\n<{* $Revision *}>\r\n<form style=\"margin-top: 0px;\" action=\"<{$xoops_url}>/modules/xoonips/itemselect.php\" method=\"POST\">\r\n    <input type=\"hidden\" name=\"op\" value=\"quicksearch\">\r\n    <input type=\"text\" name=\"keyword\" size=\"16\" value=\"<{$block.keyword|escape}>\" /><br />\r\n    <select name=\"search_itemtype\">\r\n        <{html_options options=$block.search_itemtypes selected=$block.search_itemtypes_selected}>\r\n    </select>\r\n    <input type=\"submit\" value=\"<{$block.lang_search}>\" /><br />\r\n</form>');
INSERT INTO x_tplsource VALUES (59,'<table cellspacing=\"0\">\r\n  <tr>\r\n    <td id=\"usermenu\">\r\n      <a class=\"menuTop\" href=\"<{$xoops_url}>/modules/xoonips/editgroups.php\"><{$block.lang_edit_group}></a>\r\n      <a href=\"<{$xoops_url}>/modules/xoonips/certifyuser.php\"><{$block.lang_certify_users}></a>\r\n      <a href=\"<{$xoops_url}>/modules/xoonips/certify.php?menu_id=1\"><{$block.lang_certify_items}></a>\r\n      <a href=\"<{$xoops_url}>/modules/xoonips/editindex.php?xid=<{$block.xid}>&op=open\"><{$block.lang_edit_public_index}></a>\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (60,'<{* tree-block *}>\r\n<{* input: block.indexes, block.mode *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<p>\r\n<h3><{$message}></h3>\r\n</p>\r\n<script type=\"text/javascript\">\r\n<!--\r\n\r\nvar  xoonipsDocTreeView = 0;\r\nvar  xoonipsBrowserType = \"IE\";\r\n\r\nfunction xoonipsGetDocTreeView(){\r\n	var ua = navigator.userAgent;\r\n	\r\n	var treeFrames = window.document.getElementsByName( \'treeFrame\' );\r\n	if ( treeFrames.length == 1 ){\r\n		var treeFrame = treeFrames.item(0);\r\n		xoonipsDocTreeView = treeFrame.contentDocument;\r\n	}\r\n	\r\n	if ( xoonipsDocTreeView == undefined ){\r\n		xoonipsDocTreeView = window.document.treeFrame.document;\r\n	}\r\n	\r\n	//window.alert(xoonipsDocTreeView);\r\n/*\r\n	if ( ua.indexOf(\"MSIE\") >= 0 ||\r\n	     ua.indexOf(\"MSN\") >= 0 ){\r\n		xoonipsBrowserType = \"IE\";\r\n		xoonipsDocTreeView = window.document.treeFrame.document;\r\n	}\r\n	else if ( ua.indexOf(\"Netscape\") >= 0 ||\r\n	          ua.indexOf(\"Mozilla\") >= 0 ){\r\n		xoonipsBrowserType = \"Moz\";\r\n		var treeFrames = window.document.getElementsByName( \'treeFrame\' );\r\n		if ( treeFrames.length != 1 ){\r\n			alert( \"no treeFrame\" );\r\n			return 0;\r\n		}\r\n		var treeFrame = treeFrames.item(0);\r\n		xoonipsDocTreeView = treeFrame.contentDocument;\r\n	}\r\n*/\r\n	//window.alert( \"browser : \" + xoonipsBrowserType );\r\n}\r\n\r\n\r\n\r\nfunction xoonipsFindNodeById( nodeid ){\r\n	return xoonipsDocTreeView.getElementById( nodeid );\r\n}\r\n\r\nfunction xoonipsFindNodeByName( nodename ){\r\n	var elements = xoonipsDocTreeView.getElementsByName( nodename );\r\n	return elements.item(0);\r\n}\r\n\r\nfunction xoonipsOnSubmit(){\r\n}\r\n\r\nfunction xoonipsOpenAll(){\r\n    xoonipsGetDocTreeView();\r\n    var nodes = xoonipsDocTreeView.getElementsByTagName( \'div\' );\r\n    var len = nodes.length;\r\n    var i;\r\n    \r\n    for ( i = 0; i < len; i++ ){\r\n    	var str = nodes[i].id;\r\n    	if ( str.substr(0,1) == \"f\" || str.substr(0,1) == \"t\" )\r\n	    	nodes[i].style.display = \'block\';\r\n    }\r\n}\r\n\r\nfunction xoonipsCloseAll(){\r\n    xoonipsGetDocTreeView();\r\n    var nodes = xoonipsDocTreeView.getElementsByTagName( \'div\' );\r\n    var len = nodes.length;\r\n    var i;\r\n    \r\n    for ( i = 0; i < len; i++ ){\r\n    	var str = nodes[i].id;\r\n    	if ( str.substr(0,1) == \"f\" || str.substr(0,1) == \"t\" )\r\n	    	nodes[i].style.display = \'none\';\r\n	}\r\n}\r\n\r\nfunction xoonipsClearCheck(){\r\n    xoonipsGetDocTreeView();\r\n    var nodes = xoonipsDocTreeView.getElementsByTagName( \'input\' );\r\n    var len = nodes.length;\r\n    var i;\r\n    \r\n    for ( i = 0; i < len; i++ )\r\n    	nodes[i].checked = false;\r\n}\r\n\r\nfunction xoonipsOpenTab(id){\r\n    if ( xoonipsDocTreeView == 0 )\r\n        xoonipsGetDocTreeView();\r\n    var tops = new Array();\r\n<{foreach item=x from=$block.indexes name=xx}>\r\n    tops[<{$smarty.foreach.xx.iteration}>-1] = new Array( \'xoonipsTab<{$x.item_id}>\', \'ppage<{$x.item_id}>\', \'<{$x.title}>\' );\r\n<{/foreach}>\r\n\r\n    for ( i = 0; i < tops.length; i++ ){\r\n        var l = window.document.getElementById( tops[i][0] );\r\n        if ( id == tops[i][0] ){\r\n            l.style.background = \'black\';\r\n            l.style.color = \'white\';\r\n        }\r\n        else {\r\n            l.style.background = \'white\';\r\n            l.style.color = \'black\';\r\n        }\r\n    }\r\n    for ( i = 0; i < tops.length; i++ ){\r\n        var node = xoonipsFindNodeById(tops[i][1]);\r\n        if ( node == null )\r\n            continue;\r\n        if ( id == tops[i][0] )\r\n            node.style.display = \'block\';\r\n        else\r\n            node.style.display = \'none\';\r\n    }\r\n    return false;\r\n}\r\n\r\n//-->\r\n</script>\r\n<{foreach item=index from=$block.indexes}>\r\n  <input type=\'hidden\' name=\'xoonipsTabId\' value=\'<{$index.item_id}>\'>\r\n  <span id=\'xoonipsTab<{$index.item_id}>\' name=\'xoonipsTab\'>\r\n    <a href=\'\' onClick=\"return xoonipsOpenTab(\'xoonipsTab<{$index.item_id}>\')\"><{$index.title|escape}></a>\r\n  </span>\r\n<{/foreach}>\r\n<br>\r\n<button onClick=\"xoonipsOpenAll();\">open all</button>\r\n<button onClick=\"xoonipsCloseAll();\">close all</button>\r\n<{if $block.checkbox }>\r\n<button onClick=\"xoonipsClearCheck();\">claer</button>\r\n<{/if}>\r\n<hr>\r\n<iframe src=\"<{$xoops_url}>/modules/xoonips/tree.php?checkbox=<{$block.checkbox}>&form=<{$block.form}>&hide_binders=<{$block.hide_binders}>&edit=<{$block.edit}><{$block.urlquery}>\" name=\"treeFrame\" \r\n  width=\"<{$block.tree_frame_width}>\" height=\"<{$block.tree_frame_height}>\" \r\n  marginwidth=\"0\" marginheight=\"0\" frameborder=\"1\" scrolling=\"yes\" align=\"top\" hspace=\"0\" vspace=\"0\">\r\nTo view this page, your browser must support inline frames.\r\n</iframe>');
INSERT INTO x_tplsource VALUES (61,'<{* login block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<form style=\"margin-top: 0px;\" action=\"<{$xoops_url}>/modules/xoonips/user.php\" method=\"post\">\r\n    <{$block.lang_username}><br />\r\n    <input type=\"text\" name=\"uname\" size=\"12\" value=\"<{$block.unamevalue}>\" maxlength=\"25\" /><br />\r\n    <{$block.lang_password}><br />\r\n    <input type=\"password\" name=\"pass\" size=\"12\" maxlength=\"32\" /><br />\r\n    <!-- <input type=\"checkbox\" name=\"rememberme\" value=\"On\" class =\"formButton\" /><{$block.lang_rememberme}><br /> //-->\r\n    <input type=\"hidden\" name=\"xoops_redirect\" value=\"<{$xoops_requesturi}>\" />\r\n    <input type=\"hidden\" name=\"op\" value=\"login\" />\r\n    <input type=\"submit\" value=\"<{$block.lang_login}>\" /><br />\r\n    <{$block.sslloginlink}>\r\n</form>\r\n<a href=\"<{$xoops_url}>/modules/xoonips/user.php?op=lostpass\"><{$block.lang_lostpass}></a>\r\n<br /><br />\r\n<a href=\"<{$xoops_url}>/modules/xoonips/registeruser.php\"><{$block.lang_registernow}></a>');
INSERT INTO x_tplsource VALUES (62,'<table cellspacing=\"0\">\r\n  <tr>\r\n    <td id=\"usermenu\">\r\n      <a class=\"menuTop\" href=\"<{$xoops_url}>/modules/xoonips/user.php\"><{$block.lang_youraccount}></a>\r\n      <a href=\"<{$xoops_url}>/modules/xoonips/edituser.php\"><{$block.lang_editaccount}></a>\r\n      <a href=\"<{$xoops_url}>/notifications.php\"><{$block.lang_notifications}></a>\r\n      <{if $block.new_messages > 0}>\r\n        <a class=\"highlight\" href=\"<{$xoops_url}>/viewpmsg.php\"><{$block.lang_inbox}> (<span style=\"color:#ff0000; font-weight: bold;\"><{$block.new_messages}></span>)</a>\r\n      <{else}>\r\n        <a href=\"<{$xoops_url}>/viewpmsg.php\"><{$block.lang_inbox}></a>\r\n      <{/if}>\r\n      \r\n      <a href=\"<{$xoops_url}>/modules/xoonips/editindex.php?xid=<{$block.xid}>&op=open\"><{$block.lang_edit_index}></a>\r\n      <a href=\"<{$xoops_url}>/modules/xoonips/advanced_search.php\"><{$block.lang_advanced_search}></a>\r\n      <a href=\"<{$xoops_url}>/modules/xoonips/register.php\"><{$block.lang_register_item}></a>\r\n\r\n      <a href=\"<{$xoops_url}>/modules/xoonips/user.php?op=logout\"><{$block.lang_logout}></a>\r\n\r\n      <{if $xoops_isadmin}>\r\n        <a href=\"<{$xoops_url}>/admin.php\"><{$block.lang_adminmenu}></a>\r\n      <{/if}>\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (63,'<table cellspacing=\"0\">\r\n  <tr>\r\n    <td id=\"usermenu\">\r\n      <a class=\"menuTop\" href=\"<{$xoops_url}>/modules/xoonips/groupadmin.php\"><{$block.lang_edit_group}></a>\r\n      <a href=\"<{$xoops_url}>/modules/xoonips/certify.php?menu_id=2\"><{$block.lang_certify_group_items}></a>\r\n      <a href=\"<{$xoops_url}>/modules/xoonips/editindex.php?xid=<{$block.xid}>&op=open\"><{$block.lang_edit_group_index}></a>\r\n    </td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (64,'<{* xnpbook list block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<table>\r\n <tr>\r\n  <td width=\'10%\' style=\'vertical-align:middle; text-align:center;\'>\r\n   <img src=\"<{$smarty.const.XOOPS_URL}>/modules/xnpbook/images/icon_book.gif\">\r\n  </td> \r\n  <td width=\'90%\'>\r\n   <a href=\"<{$xoops_url}>/modules/xoonips/detail.php?item_id=<{$item_basic.item_id}>\"><{$item_basic.title|escape}></a><br>\r\n   <{$item_detail.author.value|escape}><br>\r\n  </td>\r\n  <td>\r\n    <{if !empty($pending) && $pending}>(Pending)<{/if}>\r\n  </td>\r\n </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (65,'<{* xnpbook register block\r\n$detail BookClassԡԼԡǼҡȯǯISBNURL\r\n	$detail = array(\r\n        \'classification\' => array(\r\n            \'value\' => 饹̾\r\n            \'select\' => 饹̾ʸ ),\r\n        \'author\' => array( \r\n            \'value\' => ̾ ),\r\n        \'editor\' => array(\r\n            \'value\' => Խ̾),\r\n        \'publisher\' => array(\r\n            \'value\' => ȯԼ̾ ),\r\n        \'year\' => array(\r\n            \'value\' => ȯǯ ),\r\n        \'isbn\' => array(\r\n            \'value\' => ISBN ),\r\n        \'url\' => array(\r\n            \'value\' => Ҥ˴ؤURL ) )\r\n )\r\n*}>\r\n<{* $Revision: 1.5 $ *}>\r\n<!-- begin of xnpbook_register_block.html -->\r\n\r\n<script type=\"text/javascript\">\r\n//return true if all required parameters are filled\r\n<!--\r\nfunction onSubmitItemType( form1 ){\r\n	result = true;\r\n	if( form1.editor.value == \'\' ){\r\n		alert( \"<{$smarty.const._MD_XNPBOOK_EDITOR_REQUIRED}>\" );\r\n		result = false;\r\n	}\r\n	if( form1.publisher.value == \'\' ){\r\n		alert( \"<{$smarty.const._MD_XNPBOOK_PUBLISHER_REQUIRED}>\" );\r\n		result = false;\r\n	}\r\n	if( form1.publicationDateYear.value == \'\' ){\r\n		alert( \"<{$smarty.const._MD_XNPBOOK_YEAR_REQUIRED}>\" );\r\n		result = false;\r\n	}\r\n	return result;\r\n}\r\n\r\n// ISBN complete request\r\nfunction xnpbookComplete(button){\r\n    var form = button.form;\r\n    document.getElementsByName(\'isbnComplete\').item(0).value = \'1\';\r\n    form.action = \'\';\r\n    form.submit();\r\n}\r\n\r\n//-->\r\n</script>\r\n<{$system_message}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n<{*\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.item_type.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.item_type.value}></td>\r\n  </tr>\r\n*}>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_log.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_log.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  <!-- Book Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_BOOK_CLASSIFICATION_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" >\r\n      <select name=\"classification\">\r\n<{html_options options=$detail.classification.select selected=$detail.classification.value}>\r\n      </select>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_AUTHOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'author\' value=\'<{$detail.author.value|escape}>\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_EDITOR_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'editor\' value=\'<{$detail.editor.value|escape}>\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_PUBLISHER_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'publisher\' value=\'<{$detail.publisher.value|escape}>\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_YEAR_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.publication_year.value}></td>\r\n<{*    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'publicationDateYear\' value=\'<{$basic.publication_year.value}>\'></td> *}>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_URL_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input size=50 type=\'text\' name=\'url\' value=\'<{$detail.url.value|escape}>\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_ISBN_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" >\r\n     <input type=\'text\' name=\'isbn\' value=\'<{$detail.isbn.value|escape}>\'/>\r\n     <input type=\'hidden\' name=\'isbnComplete\' value=\'\'/>\r\n     <button type=\'button\' onclick=\'xnpbookComplete(this);\'><{$smarty.const._MD_XNPBOOK_ISBN_COMPLETE_LABEL}></button>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_PDF_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$attachment.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>\r\n\r\n<!-- end of xnpbook_register_block.html -->');
INSERT INTO x_tplsource VALUES (66,'<{*\r\nxnpbook detail block\r\n$detail BookClassԡԼԡǼҡȯǯISBNURL\r\n	$detail = array(\r\n        \'classification\' => array(\r\n            \'value\' => 饹̾\r\n            \'select\' => 饹̾ʸ ),\r\n        \'author\' => array( \r\n            \'value\' => ̾ ),\r\n        \'editor\' => array(\r\n            \'value\' => Խ̾),\r\n        \'publisher\' => array(\r\n            \'value\' => ȯԼ̾ ),\r\n        \'isbn\' => array(\r\n            \'value\' => ISBN ),\r\n        \'url\' => array(\r\n            \'value\' => Ҥ˴ؤURL ) )\r\n )\r\n*}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.item_type.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.item_type.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Book Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_BOOK_CLASSIFICATION_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.classification.display_value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_AUTHOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.author.value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_EDITOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.editor.value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_PUBLISHER_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.publisher.value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_YEAR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.publication_year.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_URL_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.url.value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_ISBN_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.isbn.value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_PDF_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$attachment.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (67,'<{*\r\nxnpbook confirm block\r\n$detail BookClassԡԼԡǼҡȯǯISBNURL\r\n	$detail = array(\r\n        \'classification\' => array(\r\n            \'value\' => 饹̾\r\n            \'display_value\' => 饹̾(ɽ̾)\r\n            \'select\' => 饹̾ʸ ),\r\n        \'author\' => array( \r\n            \'value\' => ̾ ),\r\n        \'editor\' => array(\r\n            \'value\' => Խ̾),\r\n        \'publisher\' => array(\r\n            \'value\' => ȯԼ̾ ),\r\n        \'isbn\' => array(\r\n            \'value\' => ISBN ),\r\n        \'url\' => array(\r\n            \'value\' => Ҥ˴ؤURL ) )\r\n )\r\n*}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.item_type.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.item_type.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_log.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_log.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Book Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_BOOK_CLASSIFICATION_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.classification.display_value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_AUTHOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.author.value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_EDITOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.editor.value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_PUBLISHER_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.publisher.value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_YEAR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.publication_year.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_URL_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.url.value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_ISBN_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.isbn.value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_PDF_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$attachment.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n\r\n<input type=\'hidden\' name=\'classification\' value=\'<{$detail.classification.value|escape}>\'/>\r\n<input type=\'hidden\' name=\'author\'         value=\'<{$detail.author.value|escape}>\'/>\r\n<input type=\'hidden\' name=\'editor\'         value=\'<{$detail.editor.value|escape}>\'/>\r\n<input type=\'hidden\' name=\'publisher\'      value=\'<{$detail.publisher.value|escape}>\'/>\r\n<input type=\'hidden\' name=\'year\'           value=\'<{$detail.year.value}>\'/>\r\n<input type=\'hidden\' name=\'isbn\'           value=\'<{$detail.isbn.value}>\'/>\r\n<input type=\'hidden\' name=\'url\'            value=\'<{$detail.url.value|escape}>\'/>\r\n\r\n</table>');
INSERT INTO x_tplsource VALUES (68,'<{* xnpbook register block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<table class=\"outer\">\r\n  <tr>\r\n   <th colspan=2 align=\'left\'><input type=\'checkbox\' name=\'<{$module_name}>\' value=\'on\'/><{$module_display_name}></th>\r\n  </tr>\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td class=\"head\" width=\"30%\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Book Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_BOOK_CLASSIFICATION_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\">\r\n     <select name=\'<{$module_name}>_classification\'>\r\n      <option value=\"\">Any</option>\r\n      <{html_options options=$classification_option}>\r\n     </select>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_AUTHOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_author\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_EDITOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_editor\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_PUBLISHER_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_publisher\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_YEAR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.publication_year.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPBOOK_ISBN_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_isbn\' value=\'\'></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (70,'<{* xnpdata list block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table>\r\n <tr>\r\n  <td width=\'10%\' style=\'vertical-align:middle; text-align:center;\'>\r\n   <img src=\"<{$smarty.const.XOOPS_URL}>/modules/xnpdata/images/icon_data.gif\">\r\n  </td>\r\n  <td width=\'90%\'>\r\n    <a href=\"<{$xoops_url}>/modules/xoonips/detail.php?item_id=<{$item_basic.item_id}>\"><{$item_basic.title|escape}></a><br>\r\n    <{$item_detail.data_type_str|escape}><br>\r\n    <{$item_detail.experimenter|escape}>\r\n  </td>\r\n  <td>\r\n    <{if !empty($pending) && $pending}>(Pending)<{/if}>\r\n  </td>\r\n </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (71,'<{* xnpdata register block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Data Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDATA_DATE_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.publication_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDATA_DATA_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" >\r\n      <select name=\'data_type\'>\r\n        <{html_options options=$data_type selected=$data_type_selected}>\r\n      </select>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\">\r\n        <{$smarty.const._MD_XNPDATA_EXPERIMENTER_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'experimenter\' value=\'<{$detail.experimenter|escape}>\'></td>\r\n  </tr>\r\n  <!-- file -->\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDATA_DATA_FILE_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$data_file.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>\r\n\r\n<script type=\"text/javascript\">\r\n<!--\r\nfunction onSubmitItemType(form){\r\n	var result = true;\r\n	if ( form.experimenter.value == \'\' ){\r\n		window.alert( \"<{$smarty.const._MD_XNPDATA_EXPERIMENTER_REQUIRED}>\" );\r\n		result = false;\r\n	}\r\n	return result;\r\n}\r\n//-->\r\n</script>');
INSERT INTO x_tplsource VALUES (72,'<{* xnpdata detail block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDATA_DATE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.publication_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Data Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDATA_DATA_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$detail.data_type_str|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDATA_EXPERIMENTER_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$detail.experimenter|escape}></td>\r\n  </tr>\r\n  \r\n  <!-- file -->\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDATA_DATA_FILE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$data_file.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  \r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (73,'<{* xnpdata confirm block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDATA_DATE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.publication_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Data Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDATA_DATA_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$detail.data_type_str|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDATA_EXPERIMENTER_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$detail.experimenter|escape}></td>\r\n  </tr>\r\n  \r\n  <!-- file -->\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDATA_DATA_FILE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$data_file.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>\r\n<input type=\'hidden\' name=\'classification\' value=\'<{$detail.classification|escape}>\'>\r\n<input type=\'hidden\' name=\'data_type\'      value=\'<{$detail.data_type|escape}>\'>\r\n<input type=\'hidden\' name=\'experimenter\'   value=\'<{$detail.experimenter|escape}>\'>');
INSERT INTO x_tplsource VALUES (74,'<{* xnpdata search block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<table class=\"outer\">\r\n  <tr>\r\n   <th colspan=2 align=\'left\'><input type=\'checkbox\' name=\'<{$module_name}>\' value=\'on\'/><{$module_display_name}></th>\r\n  </tr>\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Data Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDATA_DATA_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" >\r\n      <select name=\'<{$module_name}>_data_type\'>\r\n        <{html_options options=$data_type selected=$data_type_selected}>\r\n      </select>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\">\r\n        <{$smarty.const._MD_XNPDATA_EXPERIMENTER_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_experimenter\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDATA_DATE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.publication_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDATA_CAPTION_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_caption\' value=\'\'></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (75,'<{* xnpdummy main page *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\nmain page.\r\n<{$html}>');
INSERT INTO x_tplsource VALUES (76,'<{* xnpdummy list block *}>\r\n<{* $Revision: 1.5 $ *}>\r\ntitle: <a href=\"<{$xoops_url}>/modules/xnpitem/detail.php?item_id=<{$item_basic.item_id}>\"><{$item_basic.title|escape}></a><br>\r\ndetail: <{$item_detail.detail_text|escape}><br>');
INSERT INTO x_tplsource VALUES (77,'<{* xnpdummy register block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<script type=\"text/javascript\">\r\n<!-- // Hide script from old browsers\r\n\r\n// Nextܥ򲡤Ȥ˸ƤФ롣\r\nfunction onSubmitItemType(form){\r\n	var result = true;\r\n\r\n	return result;\r\n}\r\n// End script hiding -->    \r\n</script>\r\n\r\n\r\n\r\n\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Dummy Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDUMMY_DETAIL_TEXT}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><textarea name=\'detail_text\'><{$detail_text|escape}></textarea></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDUMMY_DUMMY_FILE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$attachment.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (78,'<{* xnpdummy detail block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.item_type.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.item_type.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Dummy Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDUMMY_DETAIL_TEXT}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail_text|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDUMMY_DUMMY_FILE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$attachment.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (79,'<{* xnpdummy confirm block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.item_type.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.item_type.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_log.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_log.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Dummy Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDUMMY_DETAIL_TEXT}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail_text|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDUMMY_DUMMY_FILE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$attachment.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>\r\n<input type=\'hidden\' name=\'detail_text\' value=\'<{$detail_text|escape}>\'>');
INSERT INTO x_tplsource VALUES (80,'<{* xnpdummy register block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<table class=\"outer\">\r\n  <tr>\r\n   <th colspan=2 align=\'left\'><input type=\'checkbox\' name=\'<{$module_name}>\' value=\'on\'/><{$module_display_name}></th>\r\n  </tr>\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td class=\"head\" width=\"30%\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.publication_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.publication_date.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Dummy Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDUMMY_DETAIL_TEXT}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><input type=\'text\' name=\'<{$module_name}>_detail_text\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPDUMMY_DUMMY_FILE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_dummyfile\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_readme\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_license\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_rights\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPITEM_CAPTION_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_caption\' value=\'\'></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (82,'<{* xnpmodel list block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table>\r\n <tr>\r\n  <td width=\'10%\' style=\'vertical-align:middle; text-align:center;\'>\r\n   <img src=\"<{$smarty.const.XOOPS_URL}>/modules/xnpmodel/images/icon_model.gif\">\r\n  </td> \r\n  <td width=\'90%\'>\r\n   <a href=\"<{$xoops_url}>/modules/xoonips/detail.php?item_id=<{$item_basic.item_id}>\"><{$item_basic.title|escape}></a><br>\r\n   <{$item_detail.model_type.display_value|escape}><br>\r\n  </td>\r\n  <td>\r\n    <{if !empty($pending) && $pending}>(Pending)<{/if}>\r\n  </td>\r\n </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (83,'<{* xnpmodel register block\r\n$detail ǥ륿סꥨ\r\n	$detail = array(\r\n        \'model_type\' => array(\r\n            \'value\' => ȥǥ륿(ά)\r\n            \'select\' => ǥ륿פʸ ),\r\n        \'creator\' => array(\r\n            \'value\' => ꥨ̾(ά) ) )\r\n$jumpto_url	ɲä륢ƥڡURL\r\n*}>\r\n<{* $Revision: 1.5 $ *}>\r\n<!-- begin of xnpmodel_register_block.html -->\r\n\r\n<script type=\"text/javascript\">\r\n//return true if all required parameters are filled\r\n<!--\r\nfunction onSubmitItemType( form1 ){\r\n	result = true;\r\n	if( form1.model_data.value == \'\' && form1.model_dataFileID.value == \'\' ){\r\n		alert( \"<{$smarty.const._MD_XNPMODEL_MODEL_FILE_REQUIRED}>\" );\r\n		result = false;\r\n	}\r\n	if( form1.creator.value == \'\' ){\r\n		alert( \"<{$smarty.const._MD_XNPMODEL_CREATOR_REQUIRED}>\" );\r\n		result = false;\r\n	}\r\n	return result;\r\n}\r\n//-->\r\n</script>\r\n\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n<{*\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.item_type.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.item_type.value}></td>\r\n  </tr>\r\n*}>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_log.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_log.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  <!-- Dummy Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPMODEL_MODEL_TYPE_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" >\r\n      <select name=\"model_type\">\r\n<{html_options options=$detail.model_type.select selected=$detail.model_type.value}>\r\n      </select>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPMODEL_CREATOR_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'creator\' value=\'<{$detail.creator.value|escape}>\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPMODEL_MODEL_FILE_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$attachment.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>\r\n\r\n<!-- end of xnpmodel_register_block.html -->');
INSERT INTO x_tplsource VALUES (84,'<{* xnpmodel detail block\r\n$detail ǥ륿סꥨ\r\n	$detail = array(\r\n        \'model_type\' => array(\r\n            \'display_value\' => ȥǥ륿(ɽ̾) )\r\n        \'creator\' => array(\r\n            \'value\' => ꥨ̾ ) )\r\n*}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.item_type.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.item_type.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Model Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPMODEL_MODEL_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.model_type.display_value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPMODEL_CREATOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.creator.value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPMODEL_MODEL_FILE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$attachment.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (85,'<{*\r\nxnpdummy confirm block\r\n$detail ǥ륿סꥨ\r\n    $detail = array(\r\n        \'model_type\' => array(\r\n            \'value\' => ȥǥ륿(̾ά),\r\n            \'display_value\' => ȥǥ륿(ɽ̾ά) ),\r\n        \'creator\' => array(\r\n            \'value\' => ꥨ̾(ά) ) )\r\n*}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.item_type.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.item_type.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_log.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_log.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Dummy Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPMODEL_MODEL_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.model_type.display_value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPMODEL_CREATOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.creator.value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPMODEL_MODEL_FILE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$attachment.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n\r\n<input type=\'hidden\' name=\'jumpto_url\' value=\'<{$jumpto_url}>\'>\r\n<input type=\'hidden\' name=\'jumpto_var[]\' value=\'item_id\'>\r\n<input type=\'hidden\' name=\'model_type\' value=\'<{$detail.model_type.value|escape}>\'/>\r\n<input type=\'hidden\' name=\'creator\' value=\'<{$detail.creator.value|escape}>\'/>\r\n\r\n</table>');
INSERT INTO x_tplsource VALUES (86,'<{* xnpmodel register block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<table class=\"outer\">\r\n  <tr>\r\n   <th colspan=2 align=\'left\'><input type=\'checkbox\' name=\'<{$module_name}>\' value=\'on\'/><{$module_display_name}></th>\r\n  </tr>\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td class=\"head\" width=\"30%\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Model Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPMODEL_MODEL_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\">\r\n     <select name=\'<{$module_name}>_model_type\'>\r\n      <option value=\"\">Any</option>\r\n      <{html_options options=$model_type_option}>\r\n     </select>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPMODEL_CREATOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_creator\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPMODEL_CAPTION_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_caption\' value=\'\'></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (88,'<{* xnppaper list block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table>\r\n <tr>\r\n  <td width=\'10%\' style=\'vertical-align:middle; text-align:center;\'>\r\n   <img src=\"<{$smarty.const.XOOPS_URL}>/modules/xnppaper/images/icon_paper.gif\">\r\n  </td>\r\n  <td width=\'90%\'>\r\n   <a href=\"<{$xoops_url}>/modules/xoonips/detail.php?item_id=<{$item_basic.item_id}>\"><{$item_basic.title|escape}></a><br>\r\n   <{$item_detail.author_str|escape}><br>\r\n    <{$item_detail.journal|escape}>\r\n    <{$item_basic.publication_year|escape}>;\r\n    <{$item_detail.volume|escape}>\r\n   (<{$item_detail.number|escape}>):\r\n    <{$item_detail.page|escape}>\r\n  </td>\r\n  <td>\r\n    <{if !empty($pending) && $pending}>(Pending)<{/if}>\r\n  </td>\r\n </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (89,'<{* xnppaper register block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\'30%\' class=\"head\"><{$smarty.const._MD_XNPPAPER_PUBMED_ID_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" >\r\n        <input type=\'text\' name=\'pubmed_id\' value=\'<{$detail.pubmed_id|escape}>\'>\r\n        <input type=\'hidden\' name=\'xnppaperCompleteFlag\' value=\'\'>\r\n        <button type=\'button\' onclick=\'xnppaperComplete(this);\'>Complete</button>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <!-- Paper Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\">\r\n        <{$smarty.const._MD_XNPPAPER_AUTHOR_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\">\r\n      <table>\r\n        <tr>\r\n          <td><textarea name=\'author\' rows=\'4\'><{$detail.author|escape}></textarea></td>\r\n          <td>Please write 1 person per line.<br>e.g. <br>Smith J<br>Brown MN</td>\r\n        </tr>\r\n      </table>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_JOURNAL_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input size=50 type=\'text\' name=\'journal\' value=\'<{$detail.journal|escape}>\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_YEAR_OF_PUBLICATION_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input size=8 type=\'text\' name=\'publicationDateYear\' value=\'<{$detail.publication_year|escape}>\'>\r\n      <input type=\'hidden\' name=\'publicationDateMonth\' value=\'0\'>\r\n      <input type=\'hidden\' name=\'publicationDateDay\' value=\'0\'>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_VOLUME_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'volume\' value=\'<{$detail.volume|escape}>\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_NUMBER_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'number\' value=\'<{$detail.number|escape}>\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_PAGE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'page\' value=\'<{$detail.page|escape}>\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_ABSTRACT_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><textarea name=\'abstract\' rows=\'4\' cols=\'40\'><{$detail.abstract|escape}></textarea></td>\r\n  </tr>\r\n<{* \r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_PDF_REPRINT_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$paper_pdf_reprint.value}></td>\r\n  </tr>\r\n*}>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>\r\n\r\n<script type=\"text/javascript\">\r\n<!--\r\n// \r\nfunction onSubmitItemType(form){\r\n	var result = true;\r\n	if ( form.author.value == \'\' ){\r\n		result = false;\r\n		window.alert(\"<{$smarty.const._MD_XNPPAPER_AUTHOR_REQUIRED}>\");\r\n	}\r\n	if ( form.journal.value == \'\' ){\r\n		result = false;\r\n		window.alert(\"<{$smarty.const._MD_XNPPAPER_JOURNAL_REQUIRED}>\");\r\n	}\r\n	if ( form.publicationDateYear.value == \'\' ){\r\n		result = false;\r\n		window.alert(\"<{$smarty.const._MD_XNPPAPER_YEAR_OF_PUBLICATION_REQUIRED}>\");\r\n	}\r\n	return result;\r\n}\r\n\r\n// pubmed complete request\r\nfunction xnppaperComplete(button){\r\n    var form = button.form;\r\n    document.getElementsByName(\'xnppaperCompleteFlag\').item(0).value = \'1\';\r\n    form.action = \'\';\r\n    form.submit();\r\n}\r\n\r\n//-->\r\n</script>');
INSERT INTO x_tplsource VALUES (90,'<{* xnppaper detail block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_PUBMED_ID_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$detail.pubmed_id|escape}></td>\r\n  </tr>\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Paper Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_AUTHOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$detail.author_str|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_JOURNAL_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.journal|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_YEAR_OF_PUBLICATION_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.publication_year|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_VOLUME_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.volume|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_NUMBER_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.number|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_PAGE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.page|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_ABSTRACT_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.abstract|escape}></td>\r\n  </tr>\r\n<{* \r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_PDF_REPRINT_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$paper_pdf_reprint.value}></td>\r\n  </tr>\r\n*}>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (91,'<{* xnppaper confirm block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_PUBMED_ID_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$detail.pubmed_id|escape}></td>\r\n  </tr>\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Paper Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_AUTHOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$detail.author_str|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_JOURNAL_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.journal|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_YEAR_OF_PUBLICATION_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.publication_year|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_VOLUME_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.volume|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_NUMBER_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.number|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_PAGE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.page|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_ABSTRACT_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.abstract|escape}></td>\r\n  </tr>\r\n<{* \r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_PDF_REPRINT_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$paper_pdf_reprint.value}></td>\r\n  </tr>\r\n*}>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>\r\n<input type=\'hidden\' name=\'author\'              value=\'<{$detail.author|escape}>\'>\r\n<input type=\'hidden\' name=\'journal\'             value=\'<{$detail.journal|escape}>\'>\r\n<input type=\'hidden\' name=\'volume\'              value=\'<{$detail.volume|escape}>\'>\r\n<input type=\'hidden\' name=\'number\'              value=\'<{$detail.number|escape}>\'>\r\n<input type=\'hidden\' name=\'page\'                value=\'<{$detail.page|escape}>\'>\r\n<input type=\'hidden\' name=\'abstract\'            value=\'<{$detail.abstract|escape}>\'>\r\n<input type=\'hidden\' name=\'pubmed_id\'           value=\'<{$detail.pubmed_id|escape}>\'>\r\n<input type=\'hidden\' name=\'publication_year\'    value=\'<{$detail.publication_year|escape}>\'>');
INSERT INTO x_tplsource VALUES (92,'<{* xnpdummy register block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<table class=\"outer\">\r\n  <tr>\r\n   <th colspan=2 align=\'left\'><input type=\'checkbox\' name=\'<{$module_name}>\' value=\'on\'/><{$module_display_name}></th>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_PUBMED_ID_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\"><input type=\'text\' name=\'<{$module_name}>_pubmed_id\' value=\'\'></td>\r\n  </tr>\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td class=\"head\" width=\"30%\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Dummy Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_AUTHOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><input type=\'text\' name=\'<{$module_name}>_author\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_JOURNAL_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><input type=\'text\' name=\'<{$module_name}>_journal\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_YEAR_OF_PUBLICATION_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.publication_year.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_VOLUME_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><input type=\'text\' name=\'<{$module_name}>_volume\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_NUMBER_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><input type=\'text\' name=\'<{$module_name}>_number\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPAPER_PAGE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_page\' value=\'\'></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (94,'<{* xnppresentation list block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table>\r\n <tr>\r\n  <td width=\'10%\' style=\'vertical-align:middle; text-align:center;\'>\r\n   <img src=\"<{$smarty.const.XOOPS_URL}>/modules/xnppresentation/images/icon_presentation.gif\">\r\n  </td>\r\n  <td width=\'90%\'>\r\n   <a href=\"<{$xoops_url}>/modules/xoonips/detail.php?item_id=<{$item_basic.item_id}>\"><{$item_basic.title|escape}></a><br>\r\n   <{$item_detail.presentation_type_str|escape}><br>\r\n   <{$item_detail.creator|escape}>\r\n  </td>\r\n  <td>\r\n    <{if !empty($pending) && $pending}>(Pending)<{/if}>\r\n  </td>\r\n </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (95,'<{* xnppresentation register block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPRESENTATION_DATE_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.publication_date.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Presentation Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPRESENTATION_PRESENTATION_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" >\r\n      <select name=\'presentation_type\'>\r\n        <{html_options options=$presentation_type selected=$presentation_type_selected}>\r\n      </select>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\">\r\n        <{$smarty.const._MD_XNPPRESENTATION_CREATOR_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'creator\' value=\'<{$detail.creator|escape}>\'></td>\r\n  </tr>\r\n  <!-- file -->\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPRESENTATION_PRESENTATION_FILE_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$presentation_file.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>\r\n\r\n<script type=\"text/javascript\">\r\n<!--\r\nfunction onSubmitItemType(form){\r\n	var result = true;\r\n	if ( form.creator.value == \'\' ){\r\n		window.alert( \"<{$smarty.const._MD_XNPPRESENTATION_EXPERIMENTER_REQUIRED}>\" );\r\n		result = false;\r\n	}\r\n	if ( form.publicationDateYear.value == \'\' ){\r\n		window.alert( \"<{$smarty.const._MD_XNPPRESENTATION_YEAR_REQUIRED}>\" );\r\n		result = false;\r\n	}\r\n	if ( form.presentation_file.value == \'\' && form.presentation_fileFileID.value == \'\' ){\r\n		window.alert( \"<{$smarty.const._MD_XNPPRESENTATION_PRESENTATION_FILE_REQUIRED}>\" );\r\n		result = false;\r\n	}\r\n	return result;\r\n}\r\n//-->\r\n</script>');
INSERT INTO x_tplsource VALUES (96,'<{* xnppresentation detail block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPRESENTATION_DATE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.publication_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Presentation Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPRESENTATION_PRESENTATION_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$detail.presentation_type_str|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPRESENTATION_CREATOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$detail.creator|escape}></td>\r\n  </tr>\r\n  \r\n  <!-- file -->\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPRESENTATION_PRESENTATION_FILE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$presentation_file.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  \r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (97,'<{* xnppresentation confirm block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPRESENTATION_DATE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.publication_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Presentation Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPRESENTATION_PRESENTATION_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$detail.presentation_type_str|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPRESENTATION_CREATOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$detail.creator|escape}></td>\r\n  </tr>\r\n  \r\n  <!-- file -->\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPRESENTATION_PRESENTATION_FILE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$presentation_file.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>\r\n<input type=\'hidden\' name=\'classification\' value=\'<{$detail.classification|escape}>\'>\r\n<input type=\'hidden\' name=\'presentation_type\'      value=\'<{$detail.presentation_type|escape}>\'>\r\n<input type=\'hidden\' name=\'creator\'        value=\'<{$detail.creator|escape}>\'>\r\n<input type=\'hidden\' name=\'year\'           value=\'<{$detail.year|escape}>\'>\r\n<input type=\'hidden\' name=\'month\'          value=\'<{$detail.month|escape}>\'>\r\n<input type=\'hidden\' name=\'day_of_month\'   value=\'<{$detail.day_of_month|escape}>\'>');
INSERT INTO x_tplsource VALUES (98,'<{* xnppresentation register block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<table class=\"outer\">\r\n  <tr>\r\n   <th colspan=2 align=\'left\'><input type=\'checkbox\' name=\'<{$module_name}>\' value=\'on\'/><{$module_display_name}></th>\r\n  </tr>\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPRESENTATION_PRESENTATION_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" >\r\n      <select name=\'<{$module_name}>_presentation_type\'>\r\n        <{html_options options=$presentation_type selected=$presentation_type_selected}>\r\n      </select>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\">\r\n        <{$smarty.const._MD_XNPPRESENTATION_CREATOR_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_creator\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPPRESENTATION_DATE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.publication_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_CAPTION_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_caption\' value=\'\'></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (99,'<{* xnptool list block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table>\r\n <tr>\r\n  <td width=\'10%\' style=\'vertical-align:middle; text-align:center;\'>\r\n   <img src=\"<{$smarty.const.XOOPS_URL}>/modules/xnptool/images/icon_tool.gif\">\r\n  </td> \r\n  <td width=\'90%\'>\r\n   <a href=\"<{$xoops_url}>/modules/xoonips/detail.php?item_id=<{$item_basic.item_id}>\"><{$item_basic.title|escape}></a><br>\r\n   <{$item_detail.tool_type.display_value|escape}><br>\r\n  </td>\r\n  <td>\r\n    <{if !empty($pending) && $pending}>(Pending)<{/if}>\r\n  </td>\r\n </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (100,'<{* xnptool register block\r\n$detail ġ륿סȯԾ\r\n	$detail = array(\r\n        \'tool_type\' => array(\r\n            \'value\' => ȥġ륿(̾)\r\n            \'display_value\' => ȥġ륿(ɽ̾)\r\n            \'select\' => ġ륿פʸ ),\r\n        \'developer\' => array(\r\n            \'value\' => ȯԤ̾(ά) ) );\r\n$gmtime	Dateեɤνͤ򥷥ƥ֤ǻꤹ\r\n )\r\n*}>\r\n<{* $Revision: 1.5 $ *}>\r\n<!-- begin of xnptool_register_block.html -->\r\n\r\n<script type=\"text/javascript\">\r\n//return true if all required parameters are filled\r\n<!--\r\nfunction onSubmitItemType( form1 ){\r\n	result = true;\r\n	if( form1.tool_data.value == \'\' && form1.tool_dataFileID.value == \'\' ){\r\n		alert( \"<{$smarty.const._MD_XNPTOOL_TOOL_FILE_REQUIRED}>\" );\r\n		result = false;\r\n	}\r\n	if( form1.developer.value == \'\' ){\r\n		alert( \"<{$smarty.const._MD_XNPTOOL_DEVELOPER_REQUIRED}>\" );\r\n		result = false;\r\n	}\r\n	return result;\r\n}\r\n//-->\r\n</script>\r\n\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_DATE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.publication_date.value}></td>\r\n  </tr>\r\n<{*\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.item_type.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.item_type.value}></td>\r\n  </tr>\r\n*}>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_log.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_log.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  <!-- Tool Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_TOOL_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" >\r\n      <select name=\"tool_type\">\r\n<{html_options options=$detail.tool_type.select selected=$detail.tool_type.value}>\r\n<{*\r\n<{foreach key=name item=value from=$detail.tool_type.select}>\r\n        <option value=\"<{$name}>\" <{if $detail.tool_type.value==$name}> selected <{/if}> ><{$value|escape}></option>\r\n<{/foreach}>\r\n*}>\r\n      </select>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_DEVELOPER_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'developer\' value=\'<{$detail.developer.value|escape}>\'></td>\r\n  </tr>\r\n<{*\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_DATE_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{html_select_date year_as_text=\"true\" month_format=\"%b\" field_array=\"tool_date\" time=\"$gmtime\"}></td>\r\n  </tr>\r\n*}>\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_TOOL_FILE}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$attachment.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>\r\n\r\n<!-- end of xnptool_register_block.html -->');
INSERT INTO x_tplsource VALUES (101,'<{*\r\nxnptool confirm block\r\n$detail ġ륿סȯԾ\r\n$detail = array(\r\n    \'tool_type\' => array( \'display_value\' => ȥġ륿(ɽ̾) ),\r\n    \'developer\' => array( \'value\' => ȯԤ̾(ά) )\r\n    \'tool_date\' => array( \'value\' => ġDateեɤΥƥ\r\n    ) );\r\n*}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_DATE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.publication_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.item_type.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.item_type.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Tool Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_TOOL_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.tool_type.display_value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_DEVELOPER_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.developer.value|escape}></td>\r\n  </tr>\r\n<{*\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_DATE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.tool_date.value|date_format:\"%b %d %Y\"}></td>\r\n  </tr>\r\n*}>\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_TOOL_FILE}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$attachment.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (102,'<{*\r\nxnptool confirm block\r\n$detail ġ륿סȯԾ\r\n	$detail = array(\r\n        \'tool_type\' => array( \'value\' => ȥġ륿(ά) ),\r\n        \'developer\' => array( \'value\' => ȯԤ̾(ά) )\r\n        \'tool_date\' => array( \'value\' => ġDateեɤΥƥ\r\n        ) );\r\n$tool_date	$detail[\'tool_type\']ΤȤ\r\n	(BackܥΤȤڡͤ򻲾Ȥ)\r\n	$tool_date =array( Date_Year => ǯ, \r\n                       Date_Month => , \r\n                       Date_Day =>  ) \r\n*}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_DATE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.publication_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.item_type.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.item_type.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_log.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_log.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Tool Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_TOOL_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.tool_type.display_value|escape}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_DEVELOPER_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.developer.value|escape}></td>\r\n  </tr>\r\n<{*\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_DATE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$detail.tool_date.value|date_format:\"%b %d %Y\"}></td>\r\n  </tr>\r\n*}>\r\n  <tr>\r\n    <td class=\"head\"><{$preview.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$preview.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_TOOL_FILE}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$attachment.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_README_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$readme.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_LICENSE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$license.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XOONIPS_ITEM_RIGHTS_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$rights.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n\r\n<input type=\'hidden\' name=\'jumpto_url\' value=\'<{$jumpto_url}>\'>\r\n<input type=\'hidden\' name=\'jumpto_var[]\' value=\'item_id\'>\r\n<input type=\'hidden\' name=\'tool_type\' value=\'<{$detail.tool_type.value|escape}>\'/>\r\n<input type=\'hidden\' name=\'developer\' value=\'<{$detail.developer.value|escape}>\'/>\r\n<input type=\'hidden\' name=\'tool_date[Date_Year]\' value=\'<{$tool_date.Date_Year}>\'/>\r\n<input type=\'hidden\' name=\'tool_date[Date_Month]\' value=\'<{$tool_date.Date_Month}>\'/>\r\n<input type=\'hidden\' name=\'tool_date[Date_Day]\' value=\'<{$tool_date.Date_Day}>\'/>\r\n\r\n</table>');
INSERT INTO x_tplsource VALUES (103,'<{* xnptool register block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<table class=\"outer\">\r\n  <tr>\r\n   <th colspan=2 align=\'left\'><input type=\'checkbox\' name=\'<{$module_name}>\' value=\'on\'/><{$module_display_name}></th>\r\n  </tr>\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td class=\"head\" width=\"30%\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Tool Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_TOOL_TYPE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\">\r\n     <select name=\'<{$module_name}>_tool_type\'>\r\n      <option value=\"\">Any</option>\r\n      <{html_options options=$tool_type_option}>\r\n     </select>\r\n    </td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_DEVELOPER_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_developer\' value=\'\'></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_DATE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.publication_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPTOOL_CAPTION_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_caption\' value=\'\'></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (105,'<{* xnpurl list block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table>\r\n <tr>\r\n  <td width=\'10%\' style=\'vertical-align:middle; text-align:center;\'>\r\n   <img src=\"<{$smarty.const.XOOPS_URL}>/modules/xnpurl/images/icon_url.gif\">\r\n  </td>\r\n  <td width=\'90%\'>\r\n   <a href=\"<{$xoops_url}>/modules/xoonips/detail.php?item_id=<{$item_basic.item_id}>\"><{$item_basic.title|escape}></a><br>\r\n  </td>\r\n  <td>\r\n    <{if !empty($pending) && $pending}>(Pending)<{/if}>\r\n  </td>\r\n </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (106,'<{* xnpurl register block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Url Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPURL_URL_LABEL}><{$smarty.const._MD_XOONIPS_ITEM_REQUIRED_MARK}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" >\r\n      <input size=50 type=\'text\' name=\'url\' value=\'<{$detail.url|escape}>\'>\r\n    </td>\r\n  </tr>\r\n  <!-- file -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPURL_URL_BANNER_FILE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$url_banner_file.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>\r\n\r\n<script type=\"text/javascript\">\r\n<!--\r\nfunction onSubmitItemType(form){\r\n	var result = true;\r\n	if ( form.url.value == \'\' ){\r\n		window.alert( \"<{$smarty.const._MD_XNPURL_URL_REQUIRED}>\" );\r\n		result = false;\r\n	}\r\n	return result;\r\n}\r\n//-->\r\n</script>');
INSERT INTO x_tplsource VALUES (107,'<{* xnpurl detail block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Url Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPURL_URL_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><a href=\'<{$detail.url|escape}>\'><{$detail.url|escape}></a></td>\r\n  </tr>\r\n  <!-- file -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPURL_URL_BANNER_FILE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$url_banner_file.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>');
INSERT INTO x_tplsource VALUES (108,'<{* xnpurl confirm block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n<table class=\"outer\">\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.last_update_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.last_update_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.creation_date.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.creation_date.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.contributor.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.contributor.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.change_logs.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.change_logs.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Url Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPURL_URL_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$detail.url|escape}></td>\r\n  </tr>\r\n  <!-- file -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPURL_URL_BANNER_FILE_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$url_banner_file.value}></td>\r\n  </tr>\r\n  <!-- index -->\r\n  <tr>\r\n    <td class=\"head\"><{$index.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$index.value}></td>\r\n  </tr>\r\n</table>\r\n<input type=\'hidden\' name=\'url\' value=\'<{$detail.url|escape}>\'>');
INSERT INTO x_tplsource VALUES (109,'<{* xnpurl register block *}>\r\n<{* $Revision: 1.5 $ *}>\r\n\r\n<table class=\"outer\">\r\n  <tr>\r\n   <th colspan=2 align=\'left\'><input type=\'checkbox\' name=\'<{$module_name}>\' value=\'on\'/><{$module_display_name}></th>\r\n  </tr>\r\n  <!-- Basic Information -->\r\n  <tr>\r\n    <td width=\"30%\" class=\"head\"><{$basic.title.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\" values=\"odd,even\"}>\" ><{$basic.title.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.keywords.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.keywords.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.description.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><{$basic.description.value}></td>\r\n  </tr>\r\n  <tr>\r\n    <td class=\"head\"><{$basic.doi.name}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\"><{$basic.doi.value}></td>\r\n  </tr>\r\n  \r\n  <!-- Url Item Detail Information -->\r\n  <tr>\r\n    <td class=\"head\"><{$smarty.const._MD_XNPURL_URL_LABEL}></td>\r\n    <td class=\"<{cycle name=\"oddeven\"}>\" ><input type=\'text\' name=\'<{$module_name}>_url\' value=\'\'></td>\r\n  </tr>\r\n</table>\r\n\r\n<script type=\"text/javascript\">\r\n</script>');

--
-- Table structure for table `x_users`
--

DROP TABLE IF EXISTS x_users;
CREATE TABLE x_users (
  uid mediumint(8) unsigned NOT NULL auto_increment,
  name varchar(60) NOT NULL default '',
  uname varchar(25) NOT NULL default '',
  email varchar(60) NOT NULL default '',
  url varchar(100) NOT NULL default '',
  user_avatar varchar(30) NOT NULL default 'blank.gif',
  user_regdate int(10) unsigned NOT NULL default '0',
  user_icq varchar(15) NOT NULL default '',
  user_from varchar(100) NOT NULL default '',
  user_sig tinytext NOT NULL,
  user_viewemail tinyint(1) unsigned NOT NULL default '0',
  actkey varchar(8) NOT NULL default '',
  user_aim varchar(18) NOT NULL default '',
  user_yim varchar(25) NOT NULL default '',
  user_msnm varchar(100) NOT NULL default '',
  pass varchar(32) NOT NULL default '',
  posts mediumint(8) unsigned NOT NULL default '0',
  attachsig tinyint(1) unsigned NOT NULL default '0',
  rank smallint(5) unsigned NOT NULL default '0',
  level tinyint(3) unsigned NOT NULL default '1',
  theme varchar(100) NOT NULL default '',
  timezone_offset float(3,1) NOT NULL default '0.0',
  last_login int(10) unsigned NOT NULL default '0',
  umode varchar(10) NOT NULL default '',
  uorder tinyint(1) unsigned NOT NULL default '0',
  notify_method tinyint(1) NOT NULL default '1',
  notify_mode tinyint(1) NOT NULL default '0',
  user_occ varchar(100) NOT NULL default '',
  bio tinytext NOT NULL,
  user_intrest varchar(150) NOT NULL default '',
  user_mailok tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (uid),
  KEY uname (uname),
  KEY email (email),
  KEY uiduname (uid,uname),
  KEY unamepass (uname,pass)
) TYPE=MyISAM;

--
-- Dumping data for table `x_users`
--

INSERT INTO x_users VALUES (1,'','root','yuichit@tsubasa.co.jp','https://10.12.60.61/~youi/XooNiPs/','blank.gif',1116463932,'','','',1,'','','','','63a9f0ea7bb98050796b649e85481845',0,0,7,5,'default',0.0,1116463932,'thread',0,1,0,'','','',0);

--
-- Table structure for table `x_xnpbook_item_detail`
--

DROP TABLE IF EXISTS x_xnpbook_item_detail;
CREATE TABLE x_xnpbook_item_detail (
  book_id int(10) unsigned NOT NULL auto_increment,
  classification varchar(30) default NULL,
  author varchar(255) default NULL,
  editor varchar(255) default NULL,
  publisher varchar(255) default NULL,
  year int(4) unsigned default NULL,
  isbn varchar(10) default NULL,
  url blob,
  PRIMARY KEY  (book_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xnpbook_item_detail`
--


--
-- Table structure for table `x_xnpdata_item_detail`
--

DROP TABLE IF EXISTS x_xnpdata_item_detail;
CREATE TABLE x_xnpdata_item_detail (
  data_id int(10) unsigned NOT NULL default '0',
  data_type varchar(30) NOT NULL default '',
  experimenter varchar(255) NOT NULL default '',
  rights text,
  license text,
  readme text,
  PRIMARY KEY  (data_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xnpdata_item_detail`
--


--
-- Table structure for table `x_xnpdummy_item_detail`
--

DROP TABLE IF EXISTS x_xnpdummy_item_detail;
CREATE TABLE x_xnpdummy_item_detail (
  dummy_id int(10) unsigned NOT NULL auto_increment,
  detail_text text,
  readme text,
  license text,
  rights text,
  PRIMARY KEY  (dummy_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xnpdummy_item_detail`
--


--
-- Table structure for table `x_xnpmodel_item_detail`
--

DROP TABLE IF EXISTS x_xnpmodel_item_detail;
CREATE TABLE x_xnpmodel_item_detail (
  model_id int(10) unsigned NOT NULL default '0',
  model_type varchar(30) default NULL,
  creator varchar(255) default NULL,
  readme text,
  license text,
  rights text,
  PRIMARY KEY  (model_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xnpmodel_item_detail`
--


--
-- Table structure for table `x_xnppaper_item_detail`
--

DROP TABLE IF EXISTS x_xnppaper_item_detail;
CREATE TABLE x_xnppaper_item_detail (
  paper_id int(10) unsigned NOT NULL default '0',
  author varchar(255) NOT NULL default '',
  journal varchar(255) NOT NULL default '',
  volume int(10) unsigned default NULL,
  number int(10) unsigned default NULL,
  page varchar(30) default NULL,
  abstract text,
  pubmed_id varchar(30) default NULL,
  PRIMARY KEY  (paper_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xnppaper_item_detail`
--


--
-- Table structure for table `x_xnppresentation_item_detail`
--

DROP TABLE IF EXISTS x_xnppresentation_item_detail;
CREATE TABLE x_xnppresentation_item_detail (
  presentation_id int(10) unsigned NOT NULL default '0',
  presentation_type varchar(30) NOT NULL default '',
  creator varchar(255) NOT NULL default '',
  rights text,
  license text,
  readme text,
  PRIMARY KEY  (presentation_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xnppresentation_item_detail`
--


--
-- Table structure for table `x_xnptool_item_detail`
--

DROP TABLE IF EXISTS x_xnptool_item_detail;
CREATE TABLE x_xnptool_item_detail (
  tool_id int(10) unsigned NOT NULL default '0',
  tool_type varchar(30) default NULL,
  developer varchar(255) default NULL,
  readme text,
  license text,
  rights text,
  PRIMARY KEY  (tool_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xnptool_item_detail`
--


--
-- Table structure for table `x_xnpurl_item_detail`
--

DROP TABLE IF EXISTS x_xnpurl_item_detail;
CREATE TABLE x_xnpurl_item_detail (
  url_id int(10) unsigned NOT NULL default '0',
  url varchar(255) NOT NULL default '',
  PRIMARY KEY  (url_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xnpurl_item_detail`
--


--
-- Table structure for table `x_xoonips_binder_item_link`
--

DROP TABLE IF EXISTS x_xoonips_binder_item_link;
CREATE TABLE x_xoonips_binder_item_link (
  binder_item_link_id int(10) unsigned NOT NULL auto_increment,
  binder_id int(10) unsigned NOT NULL default '0',
  item_id int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (binder_item_link_id),
  UNIQUE KEY binder_id (binder_id,item_id),
  KEY index_id (binder_id),
  KEY item_id (item_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoonips_binder_item_link`
--


--
-- Table structure for table `x_xoonips_changelog`
--

DROP TABLE IF EXISTS x_xoonips_changelog;
CREATE TABLE x_xoonips_changelog (
  log_id int(10) unsigned NOT NULL auto_increment,
  uid int(10) unsigned NOT NULL default '0',
  item_id int(10) unsigned NOT NULL default '0',
  log_date int(10) unsigned NOT NULL default '0',
  log text,
  PRIMARY KEY  (log_id),
  KEY item_id (item_id),
  KEY log_date (log_date)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoonips_changelog`
--


--
-- Table structure for table `x_xoonips_config`
--

DROP TABLE IF EXISTS x_xoonips_config;
CREATE TABLE x_xoonips_config (
  id int(10) unsigned NOT NULL auto_increment,
  name varchar(255) binary NOT NULL default '',
  value blob NOT NULL,
  PRIMARY KEY  (id),
  KEY name (name)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoonips_config`
--

INSERT INTO x_xoonips_config VALUES (1,'certify_user','on');
INSERT INTO x_xoonips_config VALUES (2,'certify_item','on');
INSERT INTO x_xoonips_config VALUES (3,'public_item_target_user','all');
INSERT INTO x_xoonips_config VALUES (4,'upload_dir','/var/tmp');
INSERT INTO x_xoonips_config VALUES (5,'account_address_optional','off');
INSERT INTO x_xoonips_config VALUES (6,'account_division_optional','off');
INSERT INTO x_xoonips_config VALUES (7,'account_tel_optional','off');
INSERT INTO x_xoonips_config VALUES (8,'account_company_optional','off');
INSERT INTO x_xoonips_config VALUES (9,'account_country_optional','off');
INSERT INTO x_xoonips_config VALUES (10,'account_zipcode_optional','off');
INSERT INTO x_xoonips_config VALUES (11,'account_fax_optional','on');
INSERT INTO x_xoonips_config VALUES (12,'private_item_number_limit','100');
INSERT INTO x_xoonips_config VALUES (13,'private_index_number_limit','50');
INSERT INTO x_xoonips_config VALUES (14,'private_item_storage_limit','50000000');
INSERT INTO x_xoonips_config VALUES (15,'group_item_number_limit','300');
INSERT INTO x_xoonips_config VALUES (16,'group_index_number_limit','200');
INSERT INTO x_xoonips_config VALUES (17,'group_item_storage_limit','100000000');
INSERT INTO x_xoonips_config VALUES (18,'amazon_associates_id','');
INSERT INTO x_xoonips_config VALUES (19,'moderator_gid','4');

--
-- Table structure for table `x_xoonips_file`
--

DROP TABLE IF EXISTS x_xoonips_file;
CREATE TABLE x_xoonips_file (
  file_id int(10) unsigned NOT NULL auto_increment,
  item_id int(10) unsigned default NULL,
  original_file_name varchar(255) default NULL,
  mime_type varchar(255) default NULL,
  file_name varchar(255) default NULL,
  file_size int(10) unsigned NOT NULL default '0',
  thumbnail_file blob,
  caption varchar(255) default NULL,
  sid int(10) unsigned default NULL,
  file_type_id int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (file_id),
  KEY item_id (item_id),
  KEY sid (sid)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoonips_file`
--


--
-- Table structure for table `x_xoonips_file_type`
--

DROP TABLE IF EXISTS x_xoonips_file_type;
CREATE TABLE x_xoonips_file_type (
  file_type_id int(10) unsigned NOT NULL auto_increment,
  name varchar(30) default NULL,
  mid int(10) unsigned default NULL,
  display_name varchar(30) default NULL,
  PRIMARY KEY  (file_type_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoonips_file_type`
--

INSERT INTO x_xoonips_file_type VALUES (1,'preview',NULL,'Preview');
INSERT INTO x_xoonips_file_type VALUES (2,'readme',NULL,'ReadMe');
INSERT INTO x_xoonips_file_type VALUES (3,'license',NULL,'License');
INSERT INTO x_xoonips_file_type VALUES (4,'rights',NULL,'Rights');
INSERT INTO x_xoonips_file_type VALUES (5,'book_pdf',3,'PDF File(Book)');
INSERT INTO x_xoonips_file_type VALUES (6,'data_file',4,'Data File');
INSERT INTO x_xoonips_file_type VALUES (7,'model_data',6,'Model Data');
INSERT INTO x_xoonips_file_type VALUES (8,'paper_pdf_reprint',7,'PDF Reprint');
INSERT INTO x_xoonips_file_type VALUES (9,'presentation_file',8,'Presentation File');
INSERT INTO x_xoonips_file_type VALUES (10,'tool_data',9,'Tool Data');
INSERT INTO x_xoonips_file_type VALUES (11,'url_banner_file',10,'Banner');

--
-- Table structure for table `x_xoonips_groups`
--

DROP TABLE IF EXISTS x_xoonips_groups;
CREATE TABLE x_xoonips_groups (
  gid int(10) unsigned NOT NULL auto_increment,
  gname varchar(255) binary NOT NULL default '',
  gdesc varchar(255) binary NOT NULL default '',
  group_index_id int(10) unsigned NOT NULL default '0',
  group_item_number_limit int(10) unsigned default NULL,
  group_index_number_limit int(10) unsigned default NULL,
  group_item_storage_limit double default NULL,
  PRIMARY KEY  (gid)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoonips_groups`
--

INSERT INTO x_xoonips_groups VALUES (1,'default','default group',5,NULL,NULL,NULL);

--
-- Table structure for table `x_xoonips_groups_users_link`
--

DROP TABLE IF EXISTS x_xoonips_groups_users_link;
CREATE TABLE x_xoonips_groups_users_link (
  gid int(10) unsigned NOT NULL default '0',
  uid int(10) unsigned NOT NULL default '0',
  is_admin tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (gid,uid)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoonips_groups_users_link`
--


--
-- Table structure for table `x_xoonips_index`
--

DROP TABLE IF EXISTS x_xoonips_index;
CREATE TABLE x_xoonips_index (
  index_id int(10) unsigned NOT NULL auto_increment,
  parent_index_id int(10) unsigned default NULL,
  uid int(10) unsigned default NULL,
  gid int(10) unsigned default NULL,
  open_level tinyint(3) NOT NULL default '0',
  sort_number int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (index_id),
  KEY parent_index_id (parent_index_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoonips_index`
--

INSERT INTO x_xoonips_index VALUES (1,0,NULL,NULL,1,1);
INSERT INTO x_xoonips_index VALUES (2,3,NULL,NULL,1,1);
INSERT INTO x_xoonips_index VALUES (3,1,NULL,NULL,1,1);
INSERT INTO x_xoonips_index VALUES (4,1,1,NULL,3,2147483646);
INSERT INTO x_xoonips_index VALUES (5,1,NULL,1,2,2);

--
-- Table structure for table `x_xoonips_index_item_link`
--

DROP TABLE IF EXISTS x_xoonips_index_item_link;
CREATE TABLE x_xoonips_index_item_link (
  index_item_link_id int(10) unsigned NOT NULL auto_increment,
  index_id int(10) unsigned NOT NULL default '0',
  item_id int(10) unsigned NOT NULL default '0',
  certify_state tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (index_item_link_id),
  UNIQUE KEY index_id_2 (index_id,item_id),
  KEY index_id (index_id),
  KEY item_id (item_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoonips_index_item_link`
--


--
-- Table structure for table `x_xoonips_item_basic`
--

DROP TABLE IF EXISTS x_xoonips_item_basic;
CREATE TABLE x_xoonips_item_basic (
  item_id int(10) unsigned NOT NULL auto_increment,
  item_type_id int(10) unsigned NOT NULL default '0',
  uid int(10) unsigned NOT NULL default '0',
  title varchar(255) default NULL,
  keywords text,
  description text,
  doi text,
  last_update_date int(10) unsigned NOT NULL default '0',
  creation_date int(10) unsigned NOT NULL default '0',
  publication_year int(10) default NULL,
  publication_month int(10) default NULL,
  publication_mday int(10) default NULL,
  lang char(3) default 'eng',
  PRIMARY KEY  (item_id),
  KEY title (title)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoonips_item_basic`
--

INSERT INTO x_xoonips_item_basic VALUES (1,1,0,'Root',NULL,NULL,NULL,0,0,NULL,NULL,NULL,'eng');
INSERT INTO x_xoonips_item_basic VALUES (2,1,0,'Binders',NULL,NULL,NULL,0,0,NULL,NULL,NULL,'eng');
INSERT INTO x_xoonips_item_basic VALUES (3,1,0,'Public',NULL,NULL,NULL,0,0,NULL,NULL,NULL,'eng');
INSERT INTO x_xoonips_item_basic VALUES (4,1,1,'root',NULL,NULL,NULL,0,0,NULL,NULL,NULL,'eng');
INSERT INTO x_xoonips_item_basic VALUES (5,1,1,'default',NULL,NULL,NULL,0,0,NULL,NULL,NULL,'eng');

--
-- Table structure for table `x_xoonips_item_type`
--

DROP TABLE IF EXISTS x_xoonips_item_type;
CREATE TABLE x_xoonips_item_type (
  item_type_id int(10) unsigned NOT NULL auto_increment,
  name varchar(30) default NULL,
  mid int(10) unsigned default NULL,
  display_name varchar(30) default NULL,
  viewphp varchar(255) default NULL,
  PRIMARY KEY  (item_type_id)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoonips_item_type`
--

INSERT INTO x_xoonips_item_type VALUES (1,'xoonips_index',NULL,'Index',NULL);
INSERT INTO x_xoonips_item_type VALUES (2,'xoonips_binder',NULL,'Binder','xoonips/include/binderview.php');
INSERT INTO x_xoonips_item_type VALUES (3,'xnpbook',3,'Book','xnpbook/include/view.php');
INSERT INTO x_xoonips_item_type VALUES (4,'xnpdata',4,'Data','xnpdata/include/view.php');
INSERT INTO x_xoonips_item_type VALUES (5,'xnpmodel',6,'Model','xnpmodel/include/view.php');
INSERT INTO x_xoonips_item_type VALUES (6,'xnppaper',7,'Paper','xnppaper/include/view.php');
INSERT INTO x_xoonips_item_type VALUES (7,'xnppresentation',8,'Presentation','xnppresentation/include/view.php');
INSERT INTO x_xoonips_item_type VALUES (8,'xnptool',9,'Tool','xnptool/include/view.php');
INSERT INTO x_xoonips_item_type VALUES (9,'xnpurl',10,'Url','xnpurl/include/view.php');

--
-- Table structure for table `x_xoonips_session`
--

DROP TABLE IF EXISTS x_xoonips_session;
CREATE TABLE x_xoonips_session (
  sid int(10) unsigned NOT NULL auto_increment,
  uid int(10) unsigned NOT NULL default '0',
  timestamp timestamp(14) NOT NULL,
  remote_host int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (sid)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoonips_session`
--

INSERT INTO x_xoonips_session VALUES (1,1,20050519100350,0);
INSERT INTO x_xoonips_session VALUES (2,1,20050519102201,0);

--
-- Table structure for table `x_xoonips_users`
--

DROP TABLE IF EXISTS x_xoonips_users;
CREATE TABLE x_xoonips_users (
  uid int(10) unsigned NOT NULL default '0',
  activate tinyint(1) unsigned NOT NULL default '0',
  address varchar(255) binary default NULL,
  division varchar(255) binary default NULL,
  tel varchar(32) binary NOT NULL default '',
  company_name varchar(255) binary default NULL,
  country varchar(255) binary NOT NULL default '',
  zipcode varchar(32) binary NOT NULL default '',
  fax varchar(32) binary NOT NULL default '',
  base_url varchar(255) binary default NULL,
  notice_mail int(10) unsigned default NULL,
  notice_mail_since int(10) unsigned default '0',
  private_index_id int(10) unsigned NOT NULL default '0',
  private_item_number_limit int(10) unsigned default NULL,
  private_index_number_limit int(10) unsigned default NULL,
  private_item_storage_limit double default NULL,
  PRIMARY KEY  (uid),
  KEY activate (activate)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoonips_users`
--

INSERT INTO x_xoonips_users VALUES (1,1,NULL,NULL,'',NULL,'','','',NULL,NULL,0,4,NULL,NULL,NULL);

--
-- Table structure for table `x_xoopscomments`
--

DROP TABLE IF EXISTS x_xoopscomments;
CREATE TABLE x_xoopscomments (
  com_id mediumint(8) unsigned NOT NULL auto_increment,
  com_pid mediumint(8) unsigned NOT NULL default '0',
  com_rootid mediumint(8) unsigned NOT NULL default '0',
  com_modid smallint(5) unsigned NOT NULL default '0',
  com_itemid mediumint(8) unsigned NOT NULL default '0',
  com_icon varchar(25) NOT NULL default '',
  com_created int(10) unsigned NOT NULL default '0',
  com_modified int(10) unsigned NOT NULL default '0',
  com_uid mediumint(8) unsigned NOT NULL default '0',
  com_ip varchar(15) NOT NULL default '',
  com_title varchar(255) NOT NULL default '',
  com_text text NOT NULL,
  com_sig tinyint(1) unsigned NOT NULL default '0',
  com_status tinyint(1) unsigned NOT NULL default '0',
  com_exparams varchar(255) NOT NULL default '',
  dohtml tinyint(1) unsigned NOT NULL default '0',
  dosmiley tinyint(1) unsigned NOT NULL default '0',
  doxcode tinyint(1) unsigned NOT NULL default '0',
  doimage tinyint(1) unsigned NOT NULL default '0',
  dobr tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (com_id),
  KEY com_pid (com_pid),
  KEY com_itemid (com_itemid),
  KEY com_uid (com_uid),
  KEY com_title (com_title(40))
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoopscomments`
--


--
-- Table structure for table `x_xoopsnotifications`
--

DROP TABLE IF EXISTS x_xoopsnotifications;
CREATE TABLE x_xoopsnotifications (
  not_id mediumint(8) unsigned NOT NULL auto_increment,
  not_modid smallint(5) unsigned NOT NULL default '0',
  not_itemid mediumint(8) unsigned NOT NULL default '0',
  not_category varchar(30) NOT NULL default '',
  not_event varchar(30) NOT NULL default '',
  not_uid mediumint(8) unsigned NOT NULL default '0',
  not_mode tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (not_id),
  KEY not_modid (not_modid),
  KEY not_itemid (not_itemid),
  KEY not_class (not_category),
  KEY not_uid (not_uid),
  KEY not_event (not_event)
) TYPE=MyISAM;

--
-- Dumping data for table `x_xoopsnotifications`
--


