/*
 *
 * commonal.ccΥƥ
 * 
 * gcc -o test_commonal test_commonal.cc common.cc ../criteria.cc ../account.cc ../group.cc ../session.cc ../commonal.cc ../common.cc -lmysqlclient -I/usr/include/mysql/ -lstdc++
 * 
 * $Revision: 1.13 $
 * $Log: test_commonal.cc,v $
 * Revision 1.13  2004/11/30 06:43:34  youi
 * createSessionΰ򸺤餹.
 *
 * Revision 1.12  2004/11/30 06:36:26  youi
 * isGroupAdminΥƥȤɲ.
 * СϤΥƥȤɲ.
 * ƥƥȤȤѿͤʤ褦˥֥åʬ.
 *
 * Revision 1.11  2004/11/27 09:29:38  youi
 * getGroupsΥƥȤɲ.
 *
 * Revision 1.10  2004/11/27 06:26:22  youi
 * ǡ١ͤΥƥȤɲ.
 * getAccountCountΥƥȤɲ.
 * insertGroup, updateGroup, deleteGroup, getGroupΥƥȤɲ.
 *
 * Revision 1.9  2004/11/27 01:07:01  youi
 * getAccountsȤäcriteriaLimitΥƥȤɲ.
 *
 * Revision 1.8  2004/11/27 00:37:27  youi
 * getAccountsΥƥȤɲ.
 *
 * Revision 1.7  2004/11/26 09:45:01  youi
 * *** empty log message ***
 *
 * Revision 1.6  2004/11/26 07:58:24  youi
 * ƥȤν֤ѹ.
 *
 * Revision 1.5  2004/11/26 07:04:31  youi
 * deleteAccountΥƥȤ1ɲ.
 *
 * Revision 1.4  2004/11/26 04:52:22  youi
 * isValidSessionIDΥƥȤɲ.
 *
 * Revision 1.3  2004/11/25 12:16:21  youi
 * getUidΥƥȹܤɲä.
 *
 * Revision 1.2  2004/11/25 11:14:29  youi
 * getLastErrorString/setLastErrorStringΥƥȤɲ.
 *
 * Revision 1.1  2004/11/25 08:56:13  youi
 * initial version
 *
 * 
 */
#include <time.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include "../session.h"
#include "../common.h"
#include "../commonal.h"
#include "common.h"

#define TEST( x ) test( x, #x )

// Ϳ줿groupˡߡǡ򥻥åȤ
void fillGroup( int no, group_t* g )
{
    char buf[ 1024 ];
    snprintf( buf, 1024, "MyGroup No.%d", no );
    g -> setGname( buf );

    snprintf( buf, 1024, "Description of MyGroup No.%d", no );
    g -> setDesc( buf );
}

// Ϳ줿accountˡߡǡ򥻥åȤ
void fillAccount( int no, account_t* a )
{
    char buf[ 1024 ];

    snprintf( buf, 1023, "My Address %d", no );
    a -> setAddress( buf );

    snprintf( buf, 1023, "My Institute %d", no );
    a -> setInstitute( buf );

    snprintf( buf, 1023, "My Telephone %d", no );
    a -> setTel( buf );

    snprintf( buf, 1023, "My Organization %d", no );
    a -> setOrganization( buf );

    snprintf( buf, 1023, "My Country %d", no );
    a -> setCountry( buf );

    snprintf( buf, 1023, "My Zipcode %d", no );
    a -> setZipcode( buf );

    snprintf( buf, 1023, "My Fax number %d", no );
    a -> setFax( buf ); 

    snprintf( buf, 1023, "My BaseURL %d", no );
    a -> setBaseURL( buf );

    snprintf( buf, 1023, "My Uname %d", no );
    a -> setUname( buf );

    snprintf( buf, 1023, "My Name %d", no );
    a -> setName( buf );

    snprintf( buf, 1023, "My Email address %d", no );
    a -> setEmail( buf );

    snprintf( buf, 1023, "My URL %d", no );
    a -> setURL( buf );

    snprintf( buf, 1023, "pass%d", no );
    a -> setPass( buf );
    
    a -> setTimezoneOffset( no );
}

void isGroupAdminTest( )
{
    account_t ac;
    group_t grp;
    criteria_t c;
    userid_t uid;
    groupid_t* gids;
    int gidsLen;
    sessionid_t sid;
        
    TEST( initializeDB( "localhost", "", "", "aga_xoops", "x" ) == RES_OK );
    TEST( loginUser( "youi", "hogehoge", &sid ) == RES_OK );
        
    //ߡΥȤȥ롼ץǡ򥤥󥵡
    fillAccount( 345, &ac );
    fillGroup( 20, &grp );
    if( TEST( insertAccount( sid, &ac ) == RES_OK )
        && TEST( insertGroup( sid, &grp ) == RES_OK ) ){
        c.clearAll( );
        c.setLimit( 0, 1 );
        c.addOrderBy( new orderby( "gid", orderby::DESC ) );
        if( TEST( dumpGids( sid, &c, &gids, &gidsLen ) == RES_OK ) ){
            TEST( getUid( ac.getUname( ), &uid ) == RES_OK );
            TEST( insertMember( sid, gids[ 0 ], uid, false ) == RES_OK );
            TEST( isGroupAdmin( sid, gids[ 0 ], uid ) == false );
            TEST( deleteMember( sid, gids[ 0 ], uid ) == RES_OK );
            TEST( insertMember( sid, gids[ 0 ], uid, true ) == RES_OK );
            TEST( isGroupAdmin( sid, gids[ 0 ], uid ) == true );
            TEST( deleteMember( sid, gids[ 0 ], uid ) == RES_OK );
            TEST( isGroupAdmin( sid, gids[ 0 ], uid ) == false );
            
            deleteGroup( sid, gids[ 0 ] );
            deleteAccount( sid, uid );
            freeResult( gids );
        }
    }
        
    logoutUser( sid );
}

void main( void )
{
    
    isGroupAdminTest( );
    
    //LastErrorStringΥƥ
    TEST( strcmp( getLastErrorString( ), "" ) == 0 );
    setLastErrorString( "no such user" );
    TEST( strcmp( getLastErrorString( ), "no such user" ) == 0 );
    setLastErrorString( "no such session" );
    TEST( strcmp( getLastErrorString( ), "no such session" ) == 0 );
    
    //DB˼¹Ԥȥ顼
    {
        int len;
        criteria_t cri;
        const session_t* psession;
        groupid_t gid;
        group_t group;
        const group_t* pgroup;
        const account_t* getacc;
        userid_t *puid;
        groupid_t *pgid;
        sessionid_t sid;
        userid_t uid;
        
        TEST( isActivated( sid, uid ) == false );
        TEST( activate( sid, uid, false ) == RES_DB_NOT_INITIALIZED );
        TEST( getAccountCount( sid ) == 0 );
        TEST( deleteAccount( sid, uid ) == RES_DB_NOT_INITIALIZED );
        TEST( getAccount( sid, uid, &getacc ) == RES_DB_NOT_INITIALIZED );
        TEST( getAccounts( sid, &uid, 1, &cri, &getacc, &len ) == RES_DB_NOT_INITIALIZED );
        TEST( insertAccount( sid, getacc ) == RES_DB_NOT_INITIALIZED );
        TEST( updateAccount( sid, getacc ) == RES_DB_NOT_INITIALIZED );
        TEST( dumpUids( sid, &cri, &puid, &len ) == RES_DB_NOT_INITIALIZED );
        TEST( getGroupCount( sid ) == 0 );
        TEST( getGroupsByUid( sid, uid, &cri, &pgid, &len ) == RES_DB_NOT_INITIALIZED );
        TEST( isGroupAdmin( sid, gid, uid ) == RES_DB_NOT_INITIALIZED );
        TEST( dumpGids( sid, &cri, &pgid, &len ) == RES_DB_NOT_INITIALIZED );
        TEST( dumpGroupAdmins( sid, gid, &cri, &puid, &len ) == RES_DB_NOT_INITIALIZED );
        TEST( deleteMember( sid, gid, uid ) == RES_DB_NOT_INITIALIZED );
        TEST( insertMember( sid,  gid, uid, false ) == RES_DB_NOT_INITIALIZED );
        TEST( getMembers( sid,  gid, &cri, &puid, &len ) == RES_DB_NOT_INITIALIZED );
        TEST( deleteGroup( sid,  gid ) == RES_DB_NOT_INITIALIZED );
        TEST( insertGroup( sid, &group ) == RES_DB_NOT_INITIALIZED );
        TEST( updateGroup( sid, &group ) == RES_DB_NOT_INITIALIZED );
        TEST( getGroup( sid,  gid, &pgroup ) == RES_DB_NOT_INITIALIZED );
        TEST( getGroups( sid, &gid, len, &cri, &pgroup, &len ) == RES_DB_NOT_INITIALIZED );
        TEST( isModerator( sid, uid ) == RES_DB_NOT_INITIALIZED );
        TEST( getUid( "", &uid ) == RES_DB_NOT_INITIALIZED );
        TEST( loginUser( "", "", &sid ) == RES_DB_NOT_INITIALIZED );
        TEST( createSession( "", uid, &sid ) == RES_DB_NOT_INITIALIZED );
        TEST( getSession( sid, &psession ) == RES_DB_NOT_INITIALIZED );
        TEST( isValidSessionID( sid ) == false );
    }
    TEST( initializeDB( "localhost", "", "", "aga_xoops", "x" ) == RES_OK );

    {
        sessionid_t sid;
        userid_t uid;
    
        // ʥåФ뿶
        TEST( isValidSessionID( sid ) == false );
        TEST( activate( sid, uid, false ) == RES_NO_SUCH_SESSION );
        TEST( isActivated( sid, uid ) == false );
        // sidʤ饢ȿϾ0
        TEST( getAccountCount( sid ) == 0 );
    }
    
    {
        sessionid_t sid;
        userid_t uid;
        
        // ʥѥɤѥɤФΥƥ
        TEST( loginUser( "youi", "fugafuga", &sid ) == RES_LOGIN_FAILURE );
        TEST( loginUser( "youi", "hogehoge", &sid ) == RES_OK );
    
        //åå
        TEST( isValidSessionID( sid ) == true );
        
        // ¸ߤʤuser="hogehoge" Фο񤤤ƥ
        TEST( getUid( "hogehoge", &uid ) == RES_NO_SUCH_USER );
        TEST( activate( sid, uid, false ) == RES_NO_SUCH_USER );
        TEST( isActivated( sid, uid ) == false );
        
        logoutUser( sid );
    }
    
    {
        sessionid_t sid;
        userid_t uid;
        const account_t* getacc;
        
        TEST( loginUser( "youi", "hogehoge", &sid ) == RES_OK );
        
        // ƥȳϻΥȿϿ
        int nAccountBase = getAccountCount( sid );
    
        //ƥ
        account ac;
        ac.setAddress("赵2-25-14");
        ac.setInstitute("㥷ƥ");
        ac.setTel("03-3638-3081");
        ac.setOrganization("ʤ");
        ac.setCountry("");
        ac.setZipcode("136-0071");
        ac.setFax("03-3638-3083"); 
        ac.setBaseURL("http://10.12.60.61/~youi/");
        ac.setUname("youi2");
        ac.setName("YUICHIRO TANIGUCHI2");
        ac.setEmail("yuchit@tsubasa.co.jp");
        ac.setURL("http://www.tsubasa.co.jp/");
        ac.setPass("hogehoge");
        ac.setTimezoneOffset( 9.0 );
        if( TEST( insertAccount( sid, &ac ) == RES_OK ) ){
            //insertAccount顤Account뤳Ȥǧ
            TEST( getAccountCount( sid ) == nAccountBase + 1 );

        // user="youi2" Фơactivate/deactivateԤʤ
        // ξ֤Ǥ뤫ƥ
            TEST( getUid( "youi2", &uid ) == RES_OK );
            printf( "youi2's uid is %d\n", uid );
            TEST( isActivated( sid, uid ) == false );
            TEST( activate( sid, uid, true ) == RES_OK );
            TEST( isActivated( sid, uid ) == true );
            TEST( activate( sid, uid, false ) == RES_OK );
            TEST( isActivated( sid, uid ) == false );
        
            //insert桼UID
            // Ƥ񤭴updateƤߤ롥
            if( TEST( getUid( "youi2", &uid ) == RES_OK ) ){
                if( TEST( getAccount( sid, uid, &getacc ) == RES_OK ) ){
                    // insertaccountgetaccountƤ
                    TEST( strcmp( ac.getAddress( ), getacc->getAddress( ) ) == 0 );
                    TEST( strcmp( ac.getInstitute(), getacc->getInstitute() ) == 0 );
                    TEST( strcmp( ac.getTel(), getacc->getTel() ) == 0 );
                    TEST( strcmp( ac.getOrganization( ), getacc->getOrganization( ) ) == 0 );
                    TEST( strcmp( ac.getCountry(), getacc->getCountry() ) == 0 );
                    TEST( strcmp( ac.getZipcode(), getacc->getZipcode() ) == 0 );
                    TEST( strcmp( ac.getFax(), getacc->getFax() ) == 0 );
                    TEST( strcmp( ac.getBaseURL(), getacc->getBaseURL() ) == 0 );
                    TEST( strcmp( ac.getUname(), getacc->getUname() ) == 0 );
                    TEST( strcmp( ac.getName(), getacc->getName() ) == 0 );
                    TEST( strcmp( ac.getEmail(), getacc->getEmail() ) == 0 );
                    TEST( strcmp( ac.getURL(), getacc->getURL() ) == 0 );
                    TEST( strcmp( ac.getPass(), getacc->getPass() ) == 0 );
                    TEST( ac.getTimezoneOffset( ) == getacc->getTimezoneOffset( ) );
                    freeResult( getacc );
                }
        
                account_t ac2;
                fillAccount( 220, &ac2 );
                ac.setUID( uid );
                ac.setAddress( ac2.getAddress( ) );
                ac.setInstitute( ac2.getInstitute() );
                ac.setTel( ac2.getTel() );
                ac.setOrganization(  ac2.getOrganization( ) );
                ac.setCountry( ac2.getCountry() );
                ac.setZipcode( ac2.getZipcode() );
                ac.setFax( ac2.getFax() );
                ac.setBaseURL( ac2.getBaseURL() );
                ac.setEmail( ac2.getEmail() );
                ac.setURL( ac2.getURL() );
                ac.setPass( ac2.getPass() );
                ac.setTimezoneOffset( ac2.getTimezoneOffset( ) );
                if( TEST( updateAccount( sid, &ac ) == RES_OK ) ){
                    const account_t* updated;
                    if( TEST( getAccount( sid, uid, &updated ) == RES_OK ) ){
                        // updateaccountgetaccountƤ
                        TEST( strcmp( updated->getAddress( ), ac.getAddress( ) ) == 0 );
                        TEST( strcmp( updated->getInstitute(), ac.getInstitute() ) == 0 );
                        TEST( strcmp( updated->getTel(), ac.getTel() ) == 0 );
                        TEST( strcmp( updated->getOrganization( ), ac.getOrganization( ) ) == 0 );
                        TEST( strcmp( updated->getCountry(), ac.getCountry() ) == 0 );
                        TEST( strcmp( updated->getZipcode(), ac.getZipcode() ) == 0 );
                        TEST( strcmp( updated->getFax(), ac.getFax() ) == 0 );
                        TEST( strcmp( updated->getBaseURL(), ac.getBaseURL() ) == 0 );
                        TEST( strcmp( updated->getUname(), ac.getUname() ) == 0 );
                        TEST( strcmp( updated->getName(), ac.getName() ) == 0 );
                        TEST( strcmp( updated->getEmail(), ac.getEmail() ) == 0 );
                        TEST( strcmp( updated->getURL(), ac.getURL() ) == 0 );
                        TEST( strcmp( updated->getPass(), ac.getPass() ) == 0 );
                        TEST( updated->getTimezoneOffset( ) == ac.getTimezoneOffset( ) );
                        freeResult( updated );
                    }
                }
                TEST( deleteAccount( sid, uid ) == RES_OK );
            }
        }
        logoutUser( sid );
    }

    
    
    //getAccountsΥƥ
    {
        account_t ac[ 4 ];
        userid_t uids[ 5 ];
        userid_t* dumpuids;
        const account_t* accounts;
        int accountsLen;
        int dumpuidsLen;
        criteria_t c;
        sessionid_t sid;
        
        TEST( loginUser( "youi", "hogehoge", &sid ) == RES_OK );
        
        for( int i = 0; i < 4; i++ ) fillAccount( i, &ac[ i ] );
        for( int i = 0; i < 4; i++ ) insertAccount( sid, &ac[ i ] );
        for( int i = 0; i < 4; i++ ) getUid( ac[ i ].getUname( ), &uids[ i ] );
        uids[ 4 ] = 99999999; //¸ߤʤUID򺮤
        
        c.clearAll( );
        c.addOrderBy( new orderby( "uid", orderby::ASC ) );
        TEST( dumpUids( sid, &c, &dumpuids, &dumpuidsLen ) == RES_OK );
        TEST( dumpuidsLen == 4 );
        for( int i = 0; i < 4; i++ ){
            TEST( dumpuids[ i ] == uids[ i ] );
        }
        
        //
        c.clearAll( );
        c.addOrderBy( new orderby( "uname", orderby::ASC ) );
        if( TEST( getAccounts( sid, uids, 5, &c, &accounts, &accountsLen ) == RES_OK ) ){
            if( TEST( accountsLen == 4 ) ){
                for( int i = 0; i < 4; i++ ){
                    TEST( strcmp( accounts[ i ].getUname( ), ac[ i ].getUname( ) ) == 0 );
                }
            }
            freeResult( accounts );
        }
        
        //߽
        c.clearAll( );
        c.addOrderBy( new orderby( "uname", orderby::DESC ) );
        if( TEST( getAccounts( sid, uids, 5, &c, &accounts, &accountsLen ) == RES_OK ) ){
            TEST( accountsLen == 4 );
            for( int i = 0; i < 4; i++ ){
                TEST( strcmp( accounts[ i ].getUname( ), ac[ 3 - i ].getUname( ) ) == 0 );
            }
            freeResult( accounts );
        }

        //criteria::clearAll, LimitΥƥ
        c.clearAll( );
        c.setLimit( 1, 2 );
        c.addOrderBy( new orderby( "uname", orderby::ASC ) );
        if( TEST( getAccounts( sid, uids, 5, &c, &accounts, &accountsLen ) == RES_OK ) ){
            TEST( accountsLen == 2 );
            //ϿȤܡܤaccountsϤ
            TEST( strcmp( accounts[ 0 ].getUname( ), ac[ 1 ].getUname( ) ) == 0 );
            TEST( strcmp( accounts[ 1 ].getUname( ), ac[ 2 ].getUname( ) ) == 0 );
            freeResult( accounts );
        }
        
        for( int i = 0; i < 4; i++ ) deleteAccount( sid, uids[ i ] );
        
        logoutUser( sid );
    }
    
    
    //롼פΥƥ
    {
        //롼פκ
        criteria c;
        group_t g;
        groupid_t *gids;
        int gidsLen = 0;
        int gidsLenBase = 0; //ƥΥ롼פ
        sessionid_t sid;
        
        TEST( loginUser( "youi", "hogehoge", &sid ) == RES_OK );

        gids = 0;
        if( dumpGids( sid, &c, &gids, &gidsLenBase ) == RES_OK ){
            freeResult( gids );
        }
        
        g.setGname( "ޥ롼" );
        g.setDesc( "ƥѤ˺ޥ롼פǤۤۤۤۤۤۤۤۤۤۤۤ" );
        TEST( insertGroup( sid, &g ) == RES_OK );
    
        if( TEST( dumpGids( sid, &c, &gids, &gidsLen ) == RES_OK ) ){
            TEST( gidsLen == gidsLenBase + 1 );
        
            //롼פԽ
            for( int i = 0; i < gidsLen; i++ ){
                const group_t* pg;
            
                if( TEST( getGroup( sid, gids[ i ], &pg ) == RES_OK )
                    && strcmp( g.getGname( ), pg -> getGname( ) ) == 0 ){
                    g.setGID( pg -> getGID( ) );
                    freeResult( pg );
                    g.setGname( "ޥ롼פ̾Խޤ" );
                    g.setDesc( "ޥ롼פԽޤ" );
                    TEST( updateGroup( sid, &g ) == RES_OK );
                    if( TEST( getGroup( sid, gids[ i ], &pg ) == RES_OK ) ){
                        TEST( strcmp( g.getGname( ), pg -> getGname( ) ) == 0 );
                        TEST( strcmp( g.getDesc( ), pg -> getDesc( ) ) == 0 );
                        freeResult( pg );
                    }
                }
            }
        
            //롼פκ
            for( int i = 0; i < gidsLen; i++ ){
                const group_t* pg;
                if( TEST( getGroup( sid, gids[ i ], &pg ) == RES_OK ) ){
                    if( strcmp( g.getGname( ), pg -> getGname( ) ) == 0 ){
                        TEST( deleteGroup( sid, gids[ i ] ) == RES_OK );
                    }
                    freeResult( pg );
                }
            }
            freeResult( gids );
        }
        if( TEST( dumpGids( sid, &c, &gids, &gidsLen ) == RES_OK ) ){
            freeResult( gids );
        }
        TEST( gidsLen == gidsLenBase );
    }
    
    //getGroupsΥƥ
    {
        group_t grp[ 4 ];
        groupid_t* gids;
        const group_t* groups;
        int groupsLen;
        int gidsLen;
        criteria_t c;
        sessionid_t sid;
        
        TEST( loginUser( "youi", "hogehoge", &sid ) == RES_OK );
        
        //getGroupCountΥƥ
        //SIDʤ0
        for( sessionid_t i = 9999999 ; ; i++ ){
            if( !isValidSessionID( i ) ){
                TEST( getGroupCount( i ) == 0 );
                break;
            }
        }
        int gidsLenBase = getGroupCount( sid );
        
        //ߡΥ롼ץǡ򥤥󥵡
        for( int i = 0; i < 4; i++ ) fillGroup( i+10, &grp[ i ] );
        for( int i = 0; i < 4; i++ ) insertGroup( sid, &grp[ i ] );
        
        c.clearAll( );//롼פID
        c.addOrderBy( new orderby( "gid", orderby::ASC ) );
        TEST( dumpGids( sid, &c, &gids, &gidsLen ) == RES_OK );
        TEST( gidsLen == gidsLenBase + 4 );
        
        TEST( getGroupCount( sid ) == gidsLenBase + 4 );    //SIDʤ饰롼פο֤
        
        //
        c.clearAll( );
        c.addOrderBy( new orderby( "gname", orderby::ASC ) );
        if( TEST( getGroups( sid, gids, 5, &c, &groups, &groupsLen ) == RES_OK ) ){
            if( TEST( groupsLen == 4 ) ){
                for( int i = 0; i < 4; i++ ){
                    TEST( strcmp( groups[ i ].getGname( ), grp[ i ].getGname( ) ) == 0 );
                }
            }
            freeResult( groups );
        }
        
        //߽
        c.clearAll( );
        c.addOrderBy( new orderby( "gname", orderby::DESC ) );
        if( TEST( getGroups( sid, gids, 5, &c, &groups, &groupsLen ) == RES_OK ) ){
            TEST( groupsLen == 4 );
            for( int i = 0; i < 4; i++ ){
                TEST( strcmp( groups[ i ].getGname( ), grp[ 3 - i ].getGname( ) ) == 0 );
            }
            freeResult( groups );
        }

        //criteria::clearAll, LimitΥƥ
        c.clearAll( );
        c.setLimit( 1, 2 );
        c.addOrderBy( new orderby( "gid", orderby::ASC ) );
        if( TEST( getGroups( sid, gids, 5, &c, &groups, &groupsLen ) == RES_OK ) ){
            TEST( groupsLen == 2 );
            //Ͽ롼פܡܤgroupsϤ
            TEST( strcmp( groups[ 0 ].getGname( ), grp[ 1 ].getGname( ) ) == 0 );
            TEST( strcmp( groups[ 1 ].getGname( ), grp[ 2 ].getGname( ) ) == 0 );
            freeResult( groups );
        }
        for( int i = 0; i < 4; i++ ) deleteGroup( sid, gids[ i ] );
        freeResult( gids );
        
        logoutUser( sid );
    }
    {//СɲáԤǤ̿
        group_t grp;
        groupid_t* gids;
        int gidsLen;
        const userid_t* uids;
        sessionid_t sid;
        criteria_t c;
        
        TEST( loginUser( "youi", "hogehoge", &sid ) == RES_OK );
        
        fillGroup( 9999, &grp );
        insertGroup( sid, &grp );
        
        c.clearAll( );
        c.setLimit( 0, 1 );
        c.addOrderBy( new orderby( "gid", orderby::DESC ) );
        if( dumpGids( sid, &c, &gids, &gidsLen ) == RES_OK ){
            account_t ac;
            userid_t* dumpuids;
            userid_t uid;
            const account_t* accounts;
            int accountsLen;
            int dumpuidsLen;
            
            fillAccount( 100, &ac );
            insertAccount( sid, &ac );
            getUid( ac.getUname( ), &uid );
            
            //롼פ˥Сɲ
            TEST( insertMember( sid, gids[ 0 ], uid, false ) == RES_OK );
            //롼פС
            TEST( deleteMember( sid, gids[ 0 ], uid ) == RES_OK );

            //¸ߤʤСɲá
            deleteAccount( sid, uid );
            TEST( insertMember( sid, gids[ 0 ], uid, false ) == RES_NO_SUCH_USER );
            TEST( deleteMember( sid, gids[ 0 ], uid ) == RES_NO_SUCH_USER );
            
            //¸ߤʤ롼פɲá
            insertAccount( sid, &ac );
            getUid( ac.getUname( ), &uid );
            TEST( deleteGroup( sid, gids[ 0 ] ) == RES_OK );
            TEST( insertMember( sid, gids[ 0 ], uid, false ) == RES_NO_SUCH_GROUP );
            TEST( deleteMember( sid, gids[ 0 ], uid ) == RES_NO_SUCH_GROUP );
            deleteAccount( sid, uid );
        }
        logoutUser( sid );
    }
    
    //getMembers
    {
        account_t ac[ 4 ];
        userid_t uids[ 4 ];
        const account_t* accounts;
        int accountsLen;
        int uidsLen;
        
        group_t grp;
        groupid_t* gids;
        const group_t* groups;
        int groupsLen;
        int gidsLen;
        sessionid_t sid;
        criteria_t c;
        
        TEST( loginUser( "youi", "hogehoge", &sid ) == RES_OK );

        fillGroup( 9999, &grp ); //ƥѥ롼׺
        TEST( insertGroup( sid, &grp ) == RES_OK );
        
        //ƥѥϿ
        for( int i = 0; i < 4; i++ ) fillAccount( i, &ac[ i ] );
        for( int i = 0; i < 4; i++ ) TEST( insertAccount( sid, &ac[ i ] ) == RES_OK );
        for( int i = 0; i < 4; i++ ) TEST( getUid( ac[ i ].getUname( ), &uids[ i ] ) == RES_OK );
        
        c.clearAll( );
        c.setLimit( 0, 1 );
        c.addOrderBy( new orderby( "gid", orderby::DESC ) );
        //Ͽ롼פgid
        if( TEST( dumpGids( sid, &c, &gids, &gidsLen ) == RES_OK ) ){
            userid_t* memberUids = 0;
            int memberUidsLen = 0;
            
            //ƥȳ
            for( int i = 0; i < 4; i++ ) TEST( insertMember( sid, gids[ 0 ], uids[ i ], false ) == RES_OK );
            c.clearAll( );
            TEST( getMembers( sid, gids[ 0 ], &c, &memberUids, &memberUidsLen ) == RES_OK );
            TEST( memberUidsLen == 4 );
            for( int i = 0; i < memberUidsLen; i++ ) TEST( deleteMember( sid, gids[ 0 ], memberUids[ i ] ) == RES_OK );
            freeResult( memberUids );
            
            TEST( getMembers( sid, gids[ 0 ], &c, &memberUids, &memberUidsLen ) == RES_OK );
            TEST( memberUidsLen == 0 );
            freeResult( memberUids );
        }
        for( int i = 0; i < 4; i++ ) deleteAccount( sid, uids[ i ] );
        deleteGroup( sid, gids[ 0 ] );
        
        logoutUser( sid );
    }

    //getGroupsByUid
    {
        account_t ac[ 4 ];
        const account_t* accounts;
        const group_t* groups;
        criteria_t c;
        group_t grp[ 4 ];
        groupid_t* gids;
        int accountsLen;
        int gidsLen;
        int groupsLen;
        int uidsLen;
        sessionid_t sid;
        userid_t uids[ 4 ];
        
        TEST( loginUser( "youi", "hogehoge", &sid ) == RES_OK );
        
        
        //ƥѥϿ
        //ac[0] .... 1Ĥ⥰롼פ°ʤҤ
        //ac[1] .... 1ĤΥ롼פ°Ҥ
        //ac[2] .... 2ĤΥ롼פ°Ҥ
        for( int i = 0; i < 4; i++ ) fillAccount( i, &ac[ i ] );
        for( int i = 0; i < 4; i++ ) TEST( insertAccount( sid, &ac[ i ] ) == RES_OK );
        for( int i = 0; i < 4; i++ ) TEST( getUid( ac[ i ].getUname( ), &uids[ i ] ) == RES_OK );
        
        //ߡΥ롼ץǡ򥤥󥵡
        for( int i = 0; i < 4; i++ ) fillGroup( i+20, &grp[ i ] );
        for( int i = 0; i < 4; i++ ) insertGroup( sid, &grp[ i ] );
        
        c.clearAll( );
        c.addOrderBy( new orderby( "gid", orderby::DESC ) );
        //Ͽ롼פgid
        if( TEST( dumpGids( sid, &c, &gids, &gidsLen ) == RES_OK ) ){
            userid_t* belongToGids = 0;
            int belongToGidsLen = 0;
            
            insertMember( sid, gids[ 0 ], uids[ 1 ], false );
            insertMember( sid, gids[ 0 ], uids[ 2 ], false );
            insertMember( sid, gids[ 1 ], uids[ 2 ], false );
            
            //ƥȳ
            c.clearAll( );
            belongToGidsLen = 10;
            if( TEST( getGroupsByUid( sid, uids[ 0 ], &c, &belongToGids, &belongToGidsLen ) == RES_OK ) ){
                TEST( belongToGidsLen == 0 );
                freeResult( belongToGids );
            }

            belongToGidsLen = 10;
            if( TEST( getGroupsByUid( sid, uids[ 1 ], &c, &belongToGids, &belongToGidsLen ) == RES_OK ) ){
                TEST( belongToGidsLen == 1 );
                TEST( belongToGids[ 0 ] == gids[ 0 ] );
                freeResult( belongToGids );
            }
            
            belongToGidsLen = 10;
            c.clearAll( );
            c.addOrderBy( new orderby( "gid", orderby::DESC ) );
            if( TEST( getGroupsByUid( sid, uids[ 2 ], &c, &belongToGids, &belongToGidsLen ) == RES_OK ) ){
                TEST( belongToGidsLen == 2 );
                TEST( belongToGids[ 0 ] == gids[ 0 ] );
                TEST( belongToGids[ 1 ] == gids[ 1 ] );
                freeResult( belongToGids );
            }

            deleteMember( sid, gids[ 0 ], uids[ 1 ] );
            deleteMember( sid, gids[ 0 ], uids[ 2 ] );
            deleteMember( sid, gids[ 1 ], uids[ 2 ] );
            for( int i = 0; i < 4; i++ ) deleteGroup( sid, gids[ i ] );
            for( int i = 0; i < 4; i++ ) deleteAccount( sid, uids[ i ] );
            freeResult( gids );
        }
        logoutUser( sid );
    }
    
    
}
