/*
 * criteria饹Υƥ
 * 
 * gcc -o test_criteria test_criteria.cc common.cc ../criteria.cc ../common.cc
 * 
 * $Revision: 1.1 $
 * $Log: test_criteria.cc,v $
 * Revision 1.1  2004/11/24 06:54:44  youi
 * initial version
 *
 * 
 */
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "../criteria.h"
#include "common.h"

#define TEST( x ) test( x, #x );

void main( void )
{
    criteria* c = new criteria( );

    c -> setLimit( 100, 10 );
    TEST( c -> getLimitStart( ) == 100 );
    TEST( c -> getLimitRows( ) == 10 );
    
    TEST( c -> headOrderBy( ) == 0 );
    TEST( c -> nextOrderBy( ) == 0 );
    
    c -> addOrderBy( new orderby( "col1", orderby::ASC ) );
    c -> addOrderBy( new orderby( "col2", orderby::DESC ) );
    c -> addOrderBy( new orderby( "col3", orderby::ASC ) );
    
    TEST( strcmp( c -> headOrderBy( ) -> getColumn( ), "col1" ) == 0 );
    TEST( c -> headOrderBy( ) -> getOrder( ) == orderby::ASC );
    
    const orderby* odrby_2nd = c -> nextOrderBy( );
    const orderby* odrby_3rd = c -> nextOrderBy( );
    const orderby* odrby_4th = c -> nextOrderBy( );
    TEST( strcmp( odrby_2nd -> getColumn( ), "col2" ) == 0 );
    TEST( odrby_2nd -> getOrder( ) == orderby::DESC );
    TEST( strcmp( odrby_3rd -> getColumn( ), "col3" ) == 0 );
    TEST( odrby_3rd -> getOrder( ) == orderby::ASC );
    TEST( odrby_4th == 0 );
    
    c -> clearAll( );
    TEST( c -> getLimitStart( ) == 0 );
    TEST( c -> getLimitRows( ) == 0 );
    TEST( c -> headOrderBy( ) == 0 );
    TEST( c -> nextOrderBy( ) == 0 );
    
    delete c;
}
