/*
 *
 * loginUser, logoutUserΥƥȡ
 * 
 * g++ -I/usr/local/include -I. -I/usr/include/mysql -DCOMPILE_DL=1 -o test_login_logout test_login_logout.cc common.cc \
   ../account.cc ../group.cc ../session.cc ../commonal.cc ../common.cc  -lmysqlclient
 * $Revision: 1.3 $
 * $Log: test_login_logout.cc,v $
 * Revision 1.3  2004/12/06 01:45:50  aga
 * ȤĤ.
 * ˺콤.
 *
 * Revision 1.2  2004/11/27 02:25:15  aga
 * createSession, getSessionΥƥȤɲ.
 *
 * Revision 1.1  2004/11/27 00:29:04  aga
 * commonalloginUser,logoutUserΥƥȥץ.
 *
 * 
 */

/* :
[aga@psx test]$ ./test_login_logout
ret_initdb == RES_OK .... ok
ret == RES_LOGIN_FAILURE .... ok
s == 0 .... ok
ret_login3 == RES_OK .... ok
s != 0 .... ok
ret == RES_OK .... ok
userID=2
ret == RES_OK .... ok
userID=2
ret != RES_OK .... ok
*/

#include <time.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <mysql.h>
#include <netinet/in.h>

#include "../session.h"
#include "../common.h"
#include "../commonal.h"
#include "common.h"

#define TEST( x ) test( x, #x );

static MYSQL *mysql = NULL;


void printSession( const session_t *psession ){
    if ( psession == 0 )
        printf("psession==0\n");
    else
//        printf("sessionID=%x remoteHost=%x timestamp=%u userID=%d\n", 
//          (unsigned int)psession->getSessionID(), (unsigned int)psession->getRemoteHost(),
//          (unsigned int)psession->getDate(), (int)psession->getUserID() );
        printf("userID=%d\n", (int)psession->getUserID() );
}

int main( void )
{
	char *sql;

    // initialize tester mysql
    mysql = mysql_init(NULL);
    if ( mysql == NULL ){
        return 1;
    }
    char *unix_socket = NULL; // ?
    uint flag = 0;       // ?
    if ( NULL == mysql_real_connect( mysql, "localhost", "", "", "aga_xoops", 0, unix_socket, flag ) ){
        return 2;
    }
    
    if ( 0 != mysql_query( mysql, "replace x_session ( sess_id, sess_ip ) values ('testsess_id', '127.0.0.1')" ) ){
        return 3;
    }
/*  // mysql_query(NULL,"...")㳰򵯤ΤǡˤϸƤФʤȤˤ롣
    // loginUser, valid account, before initializeDB
    {
        sessionid_t s = 0;
        result_t ret = loginUser("testuser","testpassword", &s);
        TEST( ret != RES_OK );
        printf( "ret=%d\n", ret );
        TEST( s == 0 );
    }
    
    // createSession, valid sess_id, before initializeDB
    {
        sessionid_t s = 0;
        result_t ret = createSession("testsess_id",2,(unsigned long)INADDR_LOOPBACK, &s);
        TEST( ret != RES_OK );
        TEST( s == 0 );
    }
*/
    
    // initializeDB
    {
        result_t ret = initializeDB( "localhost", "", "", "aga_xoops", "x" );
        TEST( ret == RES_OK );
    }
    
    // loginUser, invalid account
    {
        sessionid_t s = 0;
        result_t ret = loginUser("testuser","badpassword", &s);
        TEST( ret == RES_LOGIN_FAILURE );
        TEST( s == 0 );
    }
    
    sessionid_t s0;
    // loginUser, valid account
    {
        sessionid_t s = 0;
        result_t ret = loginUser("testuser","testpassword", &s);
        TEST( ret == RES_OK );
        TEST( s != 0 );
        s0 = s;
    }
    
    // getSession
    {
        const session_t *psession = 0;
        result_t ret = getSession(s0,&psession);
        TEST( ret == RES_OK );
        printSession(psession);
        freeResult(psession);
    }
    
    
    // logoutUser, invalid sessionid
    {
        sessionid_t s = 123;
        logoutUser(s);
    }
    
    // getSession
    {
        const session_t *psession = 0;
        result_t ret = getSession(s0,&psession);
        TEST( ret == RES_OK );
        printSession(psession);
        freeResult(psession);
    }

    // logoutUser, invalid sessionid
    {
        logoutUser(s0);
    }
    
    // getSession
    {
        const session_t *psession = 0;
        result_t ret = getSession(s0,&psession);
        TEST( ret != RES_OK );
        printf( "ret=%d\n", ret );
    }
    
    // createSession, invalid sess_id
    {
        sessionid_t s = 0;
        result_t ret = createSession("badsess_id",2,(unsigned long)INADDR_LOOPBACK, &s);
        TEST( ret != RES_OK );
        printf( "ret=%d\n", ret );
        TEST( s == 0 );
    }
    
    // createSession, valid sess_id
    {
        sessionid_t s = 0;
        result_t ret = createSession("testsess_id",2,(unsigned long)INADDR_LOOPBACK, &s);
        TEST( ret == RES_OK );
        TEST( s != 0 );
        s0 = s;
    }
    
    // getSession
    {
        const session_t *psession = 0;
        result_t ret = getSession(s0,&psession);
        TEST( ret == RES_OK );
        
        time_t session_time = psession->getDate();
        printf( "remoteHost=%x uid=%d,  sessionid=%d, date=%s,\n",
           (int)psession->getRemoteHost(), (int)psession->getUserID(),
           (int)psession->getSessionID(), ctime(&session_time) );
        freeResult(psession);
    }
    
    // logoutUser, valid sessionid
    {
        logoutUser(s0);
    }
    
    // getSession
    {
        const session_t *psession = 0;
        result_t ret = getSession(s0,&psession);
        TEST( ret == RES_NO_SUCH_SESSION );
    }
    

}
