<?php
//  $Revision: 1.43.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

global $xoopsConfig;
if ( file_exists( XOOPS_ROOT_PATH.'/modules/xnpdata/language/' . $xoopsConfig['language'] . '/main.php') ){
	include_once( XOOPS_ROOT_PATH.'/modules/xnpdata/language/' . $xoopsConfig['language'] . '/main.php' );
}
else {
	include_once( XOOPS_ROOT_PATH.'/modules/xnpdata/language/english/main.php' );
}


function xnpdataGetTypes(){
	return array( 'excel'=>'Excel', 'movie'=>'Movie', 'text'=>'Text', 'picture'=>'Picture', 'other'=>'Other' );
}

/** get DetailInformation by item_id
  * 
  */
function xnpdataGetDetailInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'data_type'       =>'',
			'experimenter'    =>'',
			'attachment_dl_limit' => '',
			'rights' => '',
			'readme' => '',
			'use_cc' => '',
			'cc_commercial_use' => '',
			'cc_modification' => ''
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnpdata_item_detail") . " where data_id=$item_id";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	
	$types = xnpdataGetTypes();
	$detail = $xoopsDB->fetchArray($result);
	$detail['data_type_str'] = $types[$detail['data_type']];
	return $detail;
}


function xnpdataGetMetaInformation( $item_id ){
	$ret = array();
	$basic = xnpGetBasicInformationArray($item_id);
	$detail = xnpdataGetDetailInformation( $item_id );
	if ( !empty( $basic ) ){
		$ret[_MD_XOONIPS_ITEM_TITLE_LABEL] = $basic['title'];
		$ret[_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL] = $basic['contributor'];
		$ret[_MD_XOONIPS_ITEM_KEYWORDS_LABEL] = $basic['keywords'];
		$ret[_MD_XOONIPS_ITEM_DESCRIPTION_LABEL] = $basic['description'];
		$ret[_MD_XOONIPS_ITEM_DOI_LABEL] = $basic['doi'];
		$ret[_MD_XOONIPS_ITEM_CREATION_DATE_LABEL] = $basic['creation_date'];
		$ret[_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL] = $basic['last_update_date'];
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XNPDATA_DATA_TYPE_LABEL   ] = $detail['data_type_str'   ];
		$ret[_MD_XNPDATA_EXPERIMENTER_LABEL] = $detail['experimenter'];
	}
	if ( !empty( $basic ) ){
		$publication_gmt = mktime(0,0,0,$basic['publication_month'],$basic['publication_mday'],$basic['publication_year']);
		$ret[_MD_XNPDATA_DATE_LABEL        ] = date(DATE_FORMAT,$publication_gmt);
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XOONIPS_ITEM_README_LABEL      ] = $detail['readme' ];
		$ret[_MD_XOONIPS_ITEM_RIGHTS_LABEL      ] = $detail['rights'];
	}
	return $ret;
}

function xnpdataGetListBlock( $item_basic ){
	$item_id = $item_basic['item_id'];
	
	// get DetailInformation
	$item_detail = xnpdataGetDetailInformation( $item_id );
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'item_basic', $item_basic );
	$tpl->assign( 'item_detail', $item_detail );
	if( xnpIsPending( $item_basic['item_id'] ) ) $tpl->assign( 'pending', 'true' );
    
	// return as HTML
	//return $tpl->fetch( XOOPS_ROOT_PATH . "/modules/xnpdata/templates/xnpdata_list_block.html" );
	return $tpl->fetch( "db:xnpdata_list_block.html" );
}

function xnpdataGetPrinterFriendlyListBlock( $item_basic ){
	return xnpdataGetListBlock( $item_basic );
}


function xnpdataGetDetailBlock( $item_id ){
	
	// get DetailInformation
	$item_detail = xnpdataGetDetailInformation( $item_id );
	
	// get BasicInformation / Preview / IndexKeywords block
	$basic   = xnpGetBasicInformationDetailBlock( $item_id );
	$preview = xnpGetPreviewDetailBlock( $item_id );
	$index   = xnpGetIndexDetailBlock( $item_id );
	$data_file = xnpGetAttachmentDetailBlock( $item_id, 'data_file' );
	$readme  = xnpGetTextFileDetailBlock( $item_id, 'readme' , $item_detail['readme' ] );
	$rights = xnpGetRightsDetailBlock( $item_id, $item_detail['use_cc'], $item_detail['rights'], $item_detail['cc_commercial_use'], $item_detail['cc_modification'] );
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'editable', xnp_get_item_permission( $_SESSION['XNPSID'], $item_id, OP_MODIFY ) );
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'data_file', $data_file );
	$tpl->assign( 'detail', $item_detail );
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'rights', $rights );
	
	
	// return as HTML
	return $tpl->fetch( "db:xnpdata_detail_block.html" );
}

function xnpdataGetPrinterFriendlyDetailBlock( $item_id ){
	$myts =& MyTextsanitizer::getInstance();
	
	// get DetailInformation
	$item_detail = xnpdataGetDetailInformation( $item_id );
	
	// get BasicInformation / Preview / IndexKeywords block
	$basic   = xnpGetBasicInformationPrinterFriendlyBlock( $item_id );
	$preview = xnpGetPreviewPrinterFriendlyBlock( $item_id );
	$index   = xnpGetIndexPrinterFriendlyBlock( $item_id );
	$data_file = xnpGetAttachmentPrinterFriendlyBlock( $item_id, 'data_file' );
	$readme  = xnpGetTextFilePrinterFriendlyBlock( $item_id, 'readme',  $item_detail['readme']  );
	$rights = xnpGetRightsPrinterFriendlyBlock( $item_id, $item_detail['use_cc'], $item_detail['rights'] );
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'data_file', $data_file );
	$tpl->assign( 'detail', $item_detail );
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'rights', $rights );
	
	
	// return as HTML
	return $tpl->fetch( "db:xnpdata_detail_block.html" );
}

function xnpdataGetRegisterBlock(){
	global $xoopsDB;
	$myts =& MyTextSanitizer::getInstance();
	
	// get DetailInformation
	if ( isset( $_POST['data_type'] ) ){
		$detail = array(
			'data_type'     =>$myts->stripSlashesGPC($_POST['data_type'     ]),
			'experimenter'  =>$myts->stripSlashesGPC($_POST['experimenter'  ])
		);
	}
	else
		$detail = array( 'data_type'=>'text' );
	
	// get BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationRegisterBlock();
	$preview = xnpGetPreviewRegisterBlock();
	$index = xnpGetIndexRegisterBlock();
	$data_file = xnpGetAttachmentRegisterBlock( 'data_file' );
	$readme  = xnpGetTextFileRegisterBlock( 'readme'  );
	$rights = xnpGetRightsRegisterBlock();
	$attachment_dl_limit = xnpGetDownloadLimitationOptionRegisterBlock( 'xnpdata' );
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment_dl_limit', $attachment_dl_limit );
	$tpl->assign( 'data_file', $data_file );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'rights', $rights );
	$tpl->assign( 'data_type', xnpdataGetTypes() );
	$tpl->assign( 'data_type_selected', $detail['data_type'] );
	// return as HTML
	return $tpl->fetch( "db:xnpdata_register_block.html" );
}

function xnpdataGetEditBlock( $item_id ){
	global $xoopsDB;

	// get BasicInformation / Preview / index block
	$basic   = xnpGetBasicInformationEditBlock( $item_id );
	$preview = xnpGetPreviewEditBlock( $item_id );
	$index = xnpGetIndexEditBlock( $item_id );
	$data_file = xnpGetAttachmentEditBlock( $item_id, 'data_file' );
	// get DetailInformation
	if ( isset( $_POST['data_type'] ) ){
		$myts =& MyTextSanitizer::getInstance();
		$detail = array(
			'data_type'     =>$myts->stripSlashesGPC($_POST['data_type'     ]),
			'experimenter'  =>$myts->stripSlashesGPC($_POST['experimenter'  ]),
			'readme'  => '',
			'rights' => '',
			'use_cc'  => '',
			'cc_commercial_use' => '',
			'cc_modification'  => ''
		);
	}
	else if ( !empty( $item_id ) ){
		$detail = xnpdataGetDetailInformation( $item_id );
	}
	else
		$detail = array();
	$readme  = xnpGetTextFileEditBlock( $item_id, 'readme' , $detail['readme' ] );
	$rights = xnpGetRightsEditBlock( $item_id, $detail['use_cc'], $detail['rights'], $detail['cc_commercial_use'], $detail['cc_modification'] );
	$attachment_dl_limit = xnpGetDownloadLimitationOptionEditBlock( 'xnpdata', xnpdataGetAttachmentDownloadLimitOption( $item_id ) );
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment_dl_limit', $attachment_dl_limit );
	$tpl->assign( 'data_file', $data_file );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'rights', $rights );
	$tpl->assign( 'data_type', xnpdataGetTypes() );
	$tpl->assign( 'data_type_selected', $detail['data_type'] );

	
	// return as HTML
	return $tpl->fetch( "db:xnpdata_register_block.html" );
}


function xnpdataGetConfirmBlock( $item_id ){
	// get BasicInformation / Preview / index block
	$basic   = xnpGetBasicInformationConfirmBlock( $item_id );
	$preview = xnpGetPreviewConfirmBlock( $item_id );
	$index   = xnpGetIndexConfirmBlock( $item_id );
	$data_file = xnpGetAttachmentConfirmBlock( $item_id, 'data_file' );
	$readme  = xnpGetTextFileConfirmBlock( $item_id, 'readme' );
	$rights = xnpGetRightsConfirmBlock( $item_id );
	$attachment_dl_limit = xnpGetDownloadLimitationOptionConfirmBlock( 'xnpdata' );
	// get DetailInformation
	if ( isset( $_POST['experimenter'] ) ){
		$myts =& MyTextSanitizer::getInstance();
/*
		$detail = array(
			'data_type'     =>$myts->stripSlashesGPC($_POST['data_type'     ]),
			'experimenter'  =>$myts->stripSlashesGPC($_POST['experimenter'  ])
		);
*/
		$detail = array(
			'data_type'     =>$myts->stripSlashesGPC($_POST['data_type'     ]),
			'experimenter'  =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['experimenter'  ]) )
		);
		$types = xnpdataGetTypes();
		$detail['data_type_str'] = $types[$detail['data_type']];
	}
	else if ( !empty( $item_id ) )
		$detail = xnpdataGetDetailInformation( $item_id );
	else
		$detail = array();
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment_dl_limit', $attachment_dl_limit );
	$tpl->assign( 'data_file', $data_file );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'rights', $rights );
	// return as HTML
	return $tpl->fetch( "db:xnpdata_confirm_block.html" );
}

/** check DetailInformation input
 * called from confirm/registered page
 */
function xnpdataCheckRegisterParameters( &$message ){
	$xnpsid = $_SESSION['XNPSID'];
	$messages = array();
	if ( empty( $_POST['experimenter'] ) )  $messages[] = _MD_XNPDATA_EXPERIMENTER_REQUIRED;
	if ( empty( $_POST['data_fileFileID'  ]) && empty( $_FILES['data_file']['name']) ) $messages[] = _MD_XNPDATA_DATA_FILE_REQUIRED;
	
	// require Readme and License if register to public indexes
	$xids = explode( ',', $_POST['xoonipsCheckedXID'] );
	$indexes = array( );
	if( $xids[0] != $_POST['xoonipsCheckedXID'] ) {
		foreach( $xids as $i ) {
			$index = array( );
			if( xnp_get_index( $xnpsid, $i, $index ) == RES_OK ) {
				$indexes[] = $index;
			} else {
				$messages[] = "<font color='#ff0000'>".xnp_get_last_error_string( )."</font>";
				$result = false;
				break;
			}
		}
	}
	if( count( $indexes ) > 0 ) {
		foreach( $indexes as $i ) {
			if( $i['open_level'] <= OL_GROUP_ONLY ) {
				if( $_POST['readmeEncText'] == '' ) {
					//readme is not filled
					$messages[] = "<font color='#ff0000'>"._MD_XNPDATA_README_REQUIRED."</font>";
				}
				if( $_POST['rightsEncText'] == '' && $_POST['rightsUseCC'] == '0' ) {
					//rights is not filled
					$messages[] = "<font color='#ff0000'>"._MD_XNPDATA_RIGHTS_REQUIRED."</font>";
				}
				break;
			}
		}
	}
	if ( count($messages) == 0 )
		return true;
	$message = "<br>\n" . implode( "<br>\n", $messages );
	return false;
}

/** check DetailInformation input
 */
function xnpdataCheckEditParameters( &$message ){
	return xnpdataCheckRegisterParameters( $message );
}

function xnpdataInsertItem(){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// register BasicInformation, Index, Attachment
	$item_id = 0;
	$result = xnpInsertBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'data_file' );
				if ( $result ){
				}
			}
		}
		if ( !$result )
			xnpDeleteBasicInformation( $xnpsid, $item_id );
	}
	if ( !$result )
		return false;
	
	// register DetailInformation
	list( $rights, $use_cc, $cc_commercial_use, $cc_modification ) = xnpGetRights();
	$myts =& MyTextSanitizer::getInstance();
	$keys = implode( ",", array(
		'data_type'     ,
		'experimenter'  ,
		'attachment_dl_limit',
		'readme',
		'rights', 'use_cc', 'cc_commercial_use', 'cc_modification'
	) );
	$vals = implode( "','", array(
		$myts->addSlashes($_POST['data_type'     ]),
		$myts->addSlashes($_POST['experimenter'  ]),
		$myts->addSlashes($_POST['attachment_dl_limit'  ]),
		$myts->addSlashes(xnpGetTextFile( 'readme'  )),
		addslashes($rights),
		$use_cc, $cc_commercial_use, $cc_modification
	) );
	
	$sql = "insert into " . $xoopsDB->prefix("xnpdata_item_detail") . " ( data_id, $keys ) values ( $item_id, '$vals' ) ";
	$result = $xoopsDB->queryF( $sql );
	if ( $result == false ){
		echo "cannot insert item_detail";
		return false;
	}
	
	return true;
}

function xnpdataUpdateItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	$myts =& MyTextSanitizer::getInstance();
	
	// edit BasicInformation, Index, Preview, Attachment 
	$result = xnpUpdateBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'data_file' );
				if ( $result ){
					$result = xnp_insert_change_log( $xnpsid, $item_id, $myts->stripSlashesGPC( $_POST['change_log'] ) );
					$result = !$result;
					if( !$result )
						echo " xnp_insert_change_log failed.";
				}
				else echo " xnpUpdateAttachment failed.";
			}
			else echo " xnpUpdatePreview failed.";
		}
		else echo " xnpUpdateIndex failed.";
	}
	else echo " xnpUpdateBasicInformation failed.";
	if ( !$result )
		return false;
	
	// register DetailInformation
	list( $rights, $use_cc, $cc_commercial_use, $cc_modification ) = xnpGetRights();
	
	$sql = implode( ',', array(
		'data_type'      ."='".$myts->addSlashes($_POST['data_type'     ])."'",
		'experimenter'   ."='".$myts->addSlashes($_POST['experimenter'  ])."'",
		'attachment_dl_limit'."='".$myts->addSlashes($_POST['attachment_dl_limit'  ])."'",
		'readme'             ."='".$myts->addSlashes(xnpGetTextFile( 'readme' ))."'",
		'rights'            ."='".addslashes( $rights )."'",
		'use_cc'             ."='".$use_cc           ."'",
		'cc_commercial_use'  ."='".$cc_commercial_use."'",
		'cc_modification'   ."='".$cc_modification ."'"
	) );
	$sql = "update " . $xoopsDB->prefix("xnpdata_item_detail") . " set $sql where data_id = $item_id ";
	$result = $xoopsDB->queryF( $sql );
	if ( $result == false ){
		echo $sql;
		return false;
	}
	return true;
}

function xnpdataDeleteItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// delete BasicInformation, Index, Preview, Attachment 
	if( !xnpDeleteBasicInformation( $item_id ) ){
		echo "cannot delete model item";
		return false;
	}
	
	// delete DetailInformation
	$sql = "delete from " . $xoopsDB->prefix("xnpdata_item_detail")
		. " where data_id=$item_id";
	$xoopsDB->queryF( $sql );
	return true;
}




function xnpdataGetDetailInformationQuickSearchQuery(&$wheres, &$join, $keywords){
	global $xoopsDB;
	$data_table = $xoopsDB->prefix('xnpdata_item_detail');
	$file_table  = $xoopsDB->prefix('xoonips_file');
	
	$wheres = xnpGetKeywordsQueries( array("$data_table.experimenter","$file_table.caption"), $keywords );
	return true;
}


function xnpdataGetAdvancedSearchQuery(&$where, &$join){
	global $xoopsDB;
	$basic_table =$xoopsDB->prefix('xoonips_item_basic');
	$data_table = $xoopsDB->prefix('xnpdata_item_detail');
	$file_table = $xoopsDB->prefix('xoonips_file');
	
	$wheres = array();
	$joins = array();
	$w = xnpGetBasicInformationAdvancedSearchQuery('xnpdata');                  if ( $w ) $wheres[] = $w;
	if ( !empty($_POST['xnpdata_data_type']) ){
		$myts =& MyTextSanitizer::getInstance();
		$wheres[] = $data_table.'.data_type = \'' . $myts->addSlashes($_POST['xnpdata_data_type']) . "'";
	}
	$w = xnpGetKeywordQuery($data_table.'.experimenter', 'xnpdata_experimenter'  ); if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($file_table. '.caption', 'xnpdata_caption');
	if ( $w ){
		$wheres[] = $w;
		$wheres[] = " $file_table.file_type_id = 1";
	}

	$where = implode( ' and ', $wheres );
	$join = implode( ' ', $joins );
}

function xnpdataGetAdvancedSearchBlock(&$search_var){
	// get BasicInformation / Preview / IndexKeywords block
	$basic   = xnpGetBasicInformationAdvancedSearchBlock('xnpdata',$search_var);
	$search_var[] = 'xnpdata_data_type'   ;
	$search_var[] = 'xnpdata_experimenter';
	$search_var[] = 'xnpdata_data_file'   ;
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	

	$tpl->assign( 'data_type', array_merge( array(''=>'Any'), xnpdataGetTypes()) );
	$tpl->assign( 'data_type_selected', 'none' );
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'module_name', 'xnpdata' );
	$types = array( );
	if( xnp_get_item_types( $types ) == RES_OK ) {
		foreach( $types as $i ) {
			if( $i['name'] == 'xnpdata' ) {
				$tpl->assign( 'module_display_name', $i['display_name'] );
			}
		}
	} else {
		$tpl->assign( 'module_display_name', 'xnpdata' );
	}
	
	// return as HTML
	return $tpl->fetch( "db:xnpdata_search_block.html" );
}

function xnpdataGetDetailInformationTotalSize($iids){
	return xnpGetTotalFileSize($iids);
}

/**
 * 
 * create XML for exporting detail information
 * 
 * @param fhdl file handle to output
 * @param item_id item_id of an item to export
 * @param attachment true if exporting attachment or image file
 * @return true:success, false:failure
 */
function xnpdataExportItem($fhdl, $item_id, $attachment )
{
	global $xoopsDB;

    if( !$fhdl ) return false;

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpdata_item_detail" )." where data_id=$item_id" );
	if( !$result ) return false;
    $detail = $xoopsDB->fetchArray( $result );
	if( !fwrite( $fhdl, "<detail id=\"${item_id}\">\n"
        ."<data_type>".xnpHtmlspecialchars( $detail['data_type'], ENT_QUOTES )."</data_type>\n"
        ."<experimenter>".xnpHtmlspecialchars( $detail['experimenter'], ENT_QUOTES )."</experimenter>\n"
        ."<rights>".xnpHtmlspecialchars( $detail['rights'], ENT_QUOTES )."</rights>\n"
        ."<readme>".xnpHtmlspecialchars( $detail['readme'], ENT_QUOTES )."</readme>\n"
        ."<use_cc>"           .$detail['use_cc']           ."</use_cc>\n"
        ."<cc_commercial_use>".$detail['cc_commercial_use']."</cc_commercial_use>\n"
        ."<cc_modification>"  .$detail['cc_modification']  ."</cc_modification>\n"
         ) ) return false;
    if( !( $attachment ? xnpExportFile( $fhdl, $item_id ) : true ) ) return false;
    if( !fwrite( $fhdl, "</detail>\n" ) ) return false;

    return true;
}

function xnpdataGetLicenseRequired( $item_id )
{
	global $xoopsDB;

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpdata_item_detail" )." where data_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    return isset( $detail['rights'] ) && $detail['rights'] != '';
}
function xnpdataGetLicenseStatement( $item_id )
{
	global $xoopsDB;

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpdata_item_detail" )." where data_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    return array( isset( $detail['rights'] ) ? $detail['rights'] : '', $detail['use_cc'] );;
}

function xnpdataStartElement($parser, $name, $attribs, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $parser_hash['detail'] = array();
        break;
    case "/ITEM/DETAIL/DATA_TYPE":
    case "/ITEM/DETAIL/EXPERIMENTER": 
    case "/ITEM/DETAIL/RIGHTS": 
    case "/ITEM/DETAIL/README": 
    case "/ITEM/DETAIL/USE_CC": 
    case "/ITEM/DETAIL/CC_COMMERCIAL_USE": 
    case "/ITEM/DETAIL/CC_MODIFICATION": 
        $parser_hash['detail'][end($parser_hash['tagstack'])] = '';
        break;
    }
//    echo("<b><font color=\"#0000ff\">&lt$name&gt</font></b><br>"); 
}
function xnpdataEndElement($parser, $name, &$parser_hash)
{
	global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    $myts =& MyTextSanitizer::getInstance( );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
//        print_r( $parser_hash['detail'] );
        $keys = implode( ",", array( 'data_type', 'experimenter', 'readme', 'rights', 'use_cc', 'cc_commercial_use', 'cc_modification' ) );
        $vals = implode( "','", array( $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['DATA_TYPE'] ) ),
                                       $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['EXPERIMENTER'] ) ),
                                       addslashes( encodeClient2Server( $parser_hash['detail']['README'] ) ),
                                       addslashes( encodeClient2Server( $parser_hash['detail']['RIGHTS'] ) ),
                                       (int)$parser_hash['detail']['USE_CC'],
                                       (int)$parser_hash['detail']['CC_COMMERCIAL_USE'],
                                       (int)$parser_hash['detail']['CC_MODIFICATION'],
            ) );
        
        // register DetailInformation
        $myts =& MyTextSanitizer::getInstance( );
        $sql = "insert into ".$xoopsDB->prefix( "xnpdata_item_detail" )." ( data_id, $keys ) values ( ".$parser_hash['id_table'][$parser_hash['basic']['ID']].", '$vals' ) ";
        $result = $xoopsDB->queryF( $sql );
        if( $result == false ) {
            echo "cannot insert item_detail\n";
            return false;
        }
        break;
    }
//    echo("<br><b><font color=\"#0000ff\">&lt/$name&gt</font></b><br><br>"); 
}

function xnpdataCharacterData($parser, $data, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/DETAIL/DATA_TYPE":
    case "/ITEM/DETAIL/EXPERIMENTER": 
    case "/ITEM/DETAIL/RIGHTS": 
    case "/ITEM/DETAIL/README": 
    case "/ITEM/DETAIL/USE_CC": 
    case "/ITEM/DETAIL/CC_COMMERCIAL_USE": 
    case "/ITEM/DETAIL/CC_MODIFICATION": 
        if( !array_key_exists( end($parser_hash['tagstack']), $parser_hash['detail'] ) ){
            $parser_hash['detail'][end($parser_hash['tagstack'])] = $data;
        }else{
            $parser_hash['detail'][end($parser_hash['tagstack'])] .= $data;
        }
        break; 
    } 
//    echo($data); 
}

function xnpdataGetImportHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnpdataStartElement", "xnpdataEndElement", "xnpdataCharacterData" ) );
}

function xnpdataGetModifiedFields( $item_id )
{
    $ret = array();
    $basic = xnpGetBasicInformationArray($item_id);
    if( $basic ){
        if( mktime(0,0,0,$basic['publication_month'],$basic['publication_mday'],$basic['publication_year'] )
            != mktime(0,0,0,$_POST['publicationDateMonth'],$_POST['publicationDateDay'],$_POST['publicationDateYear']) )
            array_push( $ret, _MD_XNPDATA_DATE_LABEL );
    }
    $detail = xnpdataGetDetailInformation( $item_id );
    if( $detail ){
        $myts =& MyTextSanitizer::getInstance( );
        foreach( array( 'data_type' => _MD_XNPDATA_DATA_TYPE_LABEL,
                        'experimenter' => _MD_XNPDATA_EXPERIMENTER_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) array_push( $ret, $v );
        }
        foreach( array( 'readme' => _MD_XOONIPS_ITEM_README_LABEL,
                        'rights' => _MD_XOONIPS_ITEM_RIGHTS_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( "${k}EncText", $_POST ) ) continue;
            if( urldecode($_POST[ "${k}EncText" ]) != $detail[ $k ] ) array_push( $ret, $v );
        }
        
        // was data file modified?
        if( xnpIsAttachmentModified( 'data_file', $item_id ) ){
            array_push( $ret, _MD_XNPDATA_DATA_FILE_LABEL );
        }
    }
    return $ret;
}

function xnpdataGetTopBlock( $itemtype ){
	return xnpGetTopBlock( $itemtype['name'], $itemtype['display_name'], 'images/icon_data.gif', _MD_XNPDATA_EXPLANATION, 'xnpdata_data_type', xnpdataGetTypes() );
}

//return 1 if downloadable for login user only
//return 0 if downloadable for everyone
function xnpdataGetAttachmentDownloadLimitOption( $item_id )
{
	global $xoopsDB;
    $sql = "select attachment_dl_limit from ".$xoopsDB->prefix( "xnpdata_item_detail" )." where data_id=${item_id}";
    $result = $xoopsDB->query( $sql );
    if( $result ){
        list( $option ) = $xoopsDB->fetchRow( $result );
        return $option;
    }
    return 0;
}

function xnpdataSupportMetadataFormat( $metadataPrefix, $item_id )
{
    if( $metadataPrefix == 'oai_dc' || $metadataPrefix == 'junii' ) return true;
    return false;
}

function xnpdataGetMetadata( $metadataPrefix, $item_id )
{
    $meta_basic = xnpGetBasicInformationMetadata( $metadataPrefix, $item_id );
    if( $meta_basic ){
		$basic = array();
		if( xnp_get_item( $_SESSION['XNPSID'], $item_id, $basic ) != RES_OK )
			return false;
		
        $detail = xnpdataGetDetailInformation( $item_id );
		$lines = array();
		if( $metadataPrefix == 'junii' ){
            $lines[] = "<metadata>";
            $lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii.xsd">';
            $lines[] = $meta_basic;
//            $lines[] = "<type xsi:type=\"NII\">&#65279;&#30740;&#31350;&#36039;&#28304;&#8722;&#12487;&#12540;&#12479;</type>";
            $lines[] = "<type xsi:type=\"NII\">".xnpGetMetadataJunii(21)."</type>";
//            $lines[] = "<type>dataType:".htmlspecialchars($detail['data_type'])."</type>";
            $lines[] = "<type>dataType:".xnpHtmlspecialchars($detail['data_type'])."</type>";
//            $lines[] = "<creator>".htmlspecialchars($detail['experimenter'])."</creator>";
            $lines[] = "<creator>".xnpHtmlspecialchars($detail['experimenter'])."</creator>";
            $lines[] = "<date xsi:type=\"ISO8601\">"
                .date( "Y-m-d", mktime( 0, 0, 0,
                                        $basic['publication_month'],
                                        $basic['publication_mday'],
                                        $basic['publication_year'] ) )
                ."</date>";
//            $lines[] = "<description>readme:".htmlspecialchars($detail['readme'])."</description>";
            $lines[] = "<description>readme:".xnpHtmlspecialchars($detail['readme'])."</description>";
//            $lines[] = "<description>rights:".htmlspecialchars($detail['rights'])."</description>";
            $lines[] = "<description>rights:".xnpHtmlspecialchars($detail['rights'])."</description>";
            $lines[] = "</meta>";
            $lines[] = "</metadata>";
        }
		else if ( $metadataPrefix == 'oai_dc' ) {
			$lines = array();
			$lines[] = "<metadata>";
			$lines[] = '<oai_dc:dc 
               xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/" 
               xmlns:dc="http://purl.org/dc/elements/1.1/" 
               xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
               xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/ 
               http://www.openarchives.org/OAI/2.0/oai_dc.xsd">';
			$lines[] = $meta_basic;
//			$lines[] = "<dc:type>dataType:".htmlspecialchars($detail['data_type'])."</dc:type>";
			$lines[] = "<dc:type>dataType:".xnpHtmlspecialchars($detail['data_type'])."</dc:type>";
//			$lines[] = "<dc:creator>".htmlspecialchars($detail['experimenter'])."</dc:creator>";
			$lines[] = "<dc:creator>".xnpHtmlspecialchars($detail['experimenter'])."</dc:creator>";
			$lines[] = "<dc:date>"
			    .date( "Y-m-d", mktime( 0, 0, 0,
			                            $basic['publication_month'],
			                            $basic['publication_mday'],
			                            $basic['publication_year'] ) )
			    ."</dc:date>";
//			$lines[] = "<dc:rights>".htmlspecialchars($detail['rights'])."</dc:rights>";
			$lines[] = "<dc:rights>".xnpHtmlspecialchars($detail['rights'])."</dc:rights>";
//			$lines[] = "<dc:description>readme:".htmlspecialchars($detail['readme'])."</dc:description>";
			$lines[] = "<dc:description>readme:".xnpHtmlspecialchars($detail['readme'])."</dc:description>";
			$lines[] = "</oai_dc:dc>";
			$lines[] = "</metadata>";
		}
		return implode( "\n", $lines )."\n";
    }
    return false;
}
?>
