<?php
//  $Revision: 1.26 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

global $xoopsConfig;
if ( file_exists( XOOPS_ROOT_PATH.'/modules/xnpdummy/language/' . $xoopsConfig['language'] . '/main.php') ){
	include_once( XOOPS_ROOT_PATH.'/modules/xnpdummy/language/' . $xoopsConfig['language'] . '/main.php' );
}
else {
	include_once( XOOPS_ROOT_PATH.'/modules/xnpdummy/language/english/main.php' );
}


/** item_id  DetailInformation롣
  * @return DetailInformationϢ
  */
function xnpdummyGetDetailInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array( 'detail_text'=>'' );
	
	$sql = "select * from " . $xoopsDB->prefix("xnpdummy_item_detail") . " where dummy_id=$item_id";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	return $xoopsDB->fetchArray($result);
}


function xnpdummyGetListBlock( $item_basic ){
 	$item_id = $item_basic['item_id'];
	
	// DetailInformation
	$item_detail = xnpdummyGetDetailInformation( $item_id );
	
	// template˥åȤ
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // xoopsTpl˥åȤ줿ѿ($xoops_urlȤ)$tpl˥ԡ롣
	
	$tpl->assign( 'item_basic', $item_basic );
	$tpl->assign( 'item_detail', $item_detail );
	if( xnpIsPending( $item_basic['item_id'] ) ) $tpl->assign( 'pending', 'true' );
	
	// HTMLˤ֤
	return $tpl->fetch( "db:xnpdummy_list_block.html" );
}


function xnpdummyGetDetailBlock( $item_id ){
	
	// DetailInformation롣
	$item_detail = xnpdummyGetDetailInformation( $item_id );
	
	// BasicInformation / Preview / IndexKeywords  block롣
	$basic   = xnpGetBasicInformationDetailBlock( $item_id );
	$preview = xnpGetPreviewDetailBlock( $item_id );
	$index   = xnpGetIndexDetailBlock( $item_id );
	$attachment = xnpGetAttachmentDetailBlock( $item_id, 'dummyfile' );
	$readme  = xnpGetTextFileDetailBlock( $item_id, 'readme',  $item_detail['readme']  );
	$license = xnpGetTextFileDetailBlock( $item_id, 'license', $item_detail['license'] );
	$rights  = xnpGetTextFileDetailBlock( $item_id, 'rights',  $item_detail['rights']  );
	
	
	// template˥åȤ
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // xoopsTpl˥åȤ줿ѿ($xoops_urlȤ)$tpl˥ԡ롣
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'detail_text', $item_detail['detail_text'] );
	$tpl->assign( 'readme' , $readme  );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights  );
	
	
	// HTMLˤ֤
	return $tpl->fetch( "db:xnpdummy_detail_block.html" );
}

// todo
function xnpdummyGetPrinterFriendlyDetailBlock( $item_id ){
	
	// DetailInformation롣
	$item_detail = xnpdummyGetDetailInformation( $item_id );
	
	// BasicInformation / Preview / IndexKeywords  block롣
	$basic   = xnpGetBasicInformationPrinterFriendlyBlock( $item_id );
	$preview = xnpGetPreviewPrinterFriendlyBlock( $item_id );
	$index   = xnpGetIndexPrinterFriendlyBlock( $item_id );
	$attachment = xnpGetAttachmentPrinterFriendlyBlock( $item_id, 'dummyfile' );
	$readme  = xnpGetTextFilePrinterFriendlyBlock( $item_id, 'readme',  $item_detail['readme']  );
	$license = xnpGetTextFilePrinterFriendlyBlock( $item_id, 'license', $item_detail['license'] );
	$rights  = xnpGetTextFilePrinterFriendlyBlock( $item_id, 'rights',  $item_detail['rights']  );
	
	
	// template˥åȤ
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // xoopsTpl˥åȤ줿ѿ($xoops_urlȤ)$tpl˥ԡ롣
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'detail_text', $item_detail['detail_text'] );
	$tpl->assign( 'readme' , $readme  );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights  );
	
	
	// HTMLˤ֤
	return $tpl->fetch( "db:xnpdummy_detail_block.html" );
}

function xnpdummyGetRegisterBlock(){
	global $xoopsDB;

	// BasicInformation / Preview / index block롣
	$basic   = xnpGetBasicInformationRegisterBlock();
	$preview = xnpGetPreviewRegisterBlock();
	$index = xnpGetIndexRegisterBlock();
	$attachment = xnpGetAttachmentRegisterBlock('dummyfile' );
	$readme  = xnpGetTextFileRegisterBlock( 'readme'  );
	$license = xnpGetTextFileRegisterBlock( 'license' );
	$rights  = xnpGetTextFileRegisterBlock( 'rights'  );
	
	// DetailInformation롣
	$item_detail = array();
	if ( isset( $_POST['detail_text'] ) )
		$item_detail = array( 'detail_text' => $_POST['detail_text'] );
	
	// template˥åȤ
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // xoopsTpl˥åȤ줿ѿ($xoops_urlȤ)$tpl˥ԡ롣
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'detail_text', $item_detail['detail_text'] );
	$tpl->assign( 'readme' , $readme  );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights  );
	// HTMLˤ֤
	return $tpl->fetch( "db:xnpdummy_register_block.html" );
}

function xnpdummyGetEditBlock( $item_id ){
	global $xoopsDB;

	// BasicInformation / Preview / index block롣
	$basic   = xnpGetBasicInformationEditBlock( $item_id );
	$preview = xnpGetPreviewEditBlock( $item_id );
	$index = xnpGetIndexEditBlock( $item_id );
	$attachment = xnpGetAttachmentEditBlock( $item_id, 'dummyfile' );
	
	// DetailInformation롣
	$item_detail = xnpdummyGetDetailInformation( $item_id );
	if ( isset( $_POST['detail_text'] ) )
		$item_detail = array( 'detail_text' => $_POST['detail_text'] );
	$readme  = xnpGetTextFileEditBlock( $item_id, 'readme' , $item_detail['readme' ] );
	$license = xnpGetTextFileEditBlock( $item_id, 'license', $item_detail['license'] );
	$rights  = xnpGetTextFileEditBlock( $item_id, 'rights' , $item_detail['rights' ] );
	
	// template˥åȤ
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // xoopsTpl˥åȤ줿ѿ($xoops_urlȤ)$tpl˥ԡ롣

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'detail_text', $item_detail['detail_text'] );
	$tpl->assign( 'readme' , $readme  );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights  );
	
	// HTMLˤ֤
	return $tpl->fetch( "db:xnpdummy_register_block.html" );
}


function xnpdummyGetConfirmBlock( $item_id ){
	var_dump( $_POST );
	// BasicInformation / Preview / index block롣
	$basic	  = xnpGetBasicInformationConfirmBlock( $item_id );
	$preview	= xnpGetPreviewConfirmBlock( $item_id );
	$index	  = xnpGetIndexConfirmBlock( $item_id );
	$attachment = xnpGetAttachmentConfirmBlock( $item_id, 'dummyfile' );
	$readme  = xnpGetTextFileConfirmBlock( $item_id, 'readme'  );
	$license = xnpGetTextFileConfirmBlock( $item_id, 'license' );
	$rights  = xnpGetTextFileConfirmBlock( $item_id, 'rights'  );
	
	// DetailInformation롣
	if ( isset( $_POST['detail_text'] ) )
		$item_detail = array( 'detail_text'=>$_POST['detail_text']);
	else if ( !empty( $item_id ) )
		$item_detail = xnpdummyGetDetailInformation( $item_id );
	else
		$item_detail = array();
	
	// template˥åȤ
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // xoopsTpl˥åȤ줿ѿ($xoops_urlȤ)$tpl˥ԡ롣
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'detail_text', $item_detail['detail_text'] );
	$tpl->assign( 'readme' , $readme  );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights  );
	
	// HTMLˤ֤
	return $tpl->fetch( "db:xnpdummy_confirm_block.html" );
}

/** DetailInformationϥåԤ
 * Ͽǧ̡Ͽλ̤2꤫ƤФ롣
 * @param message Ϥ٤顼å
 * @return 顼̵ʤtrue. 顼ʤfalse.
 */
function xnpdummyCheckRegisterParameters( &$message ){
	return true;
}

/** DetailInformationϥåԤ
 * Ͽǧ̡Ͽλ̤2꤫ƤФ롣
 * @param message Ϥ٤顼å
 * @return 顼̵ʤtrue. 顼ʤfalse.
 */
function xnpdummyCheckEditParameters( &$message ){
	return true;
}

function xnpdummyInsertItem(){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// BasicInformation, Index, Preview, AttachmentϿ
	$item_id = 0;
	$result = xnpInsertBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'dummyfile' );
				if ( $result ){
				}
			}
		}
		if ( !$result )
			xnpDeleteBasicInformation( $xnpsid, $item_id );
	}
	if ( !$result )
		return false;
	
	
	
	// DetailInformationϿ
	$myts =& MyTextSanitizer::getInstance();
	$esc_detail_text = $myts->addSlashes( $_POST['detail_text'] );
	$esc_readme  = addslashes( xnpGetTextFile( 'readme' ) );
	$esc_license = addslashes( xnpGetTextFile( 'license' ) );
	$esc_rights  = addslashes( xnpGetTextFile( 'rights' ) );
	$sql = "insert into " . $xoopsDB->prefix("xnpdummy_item_detail") . " ( dummy_id, detail_text, readme, license, rights ) values ( $item_id, '$esc_detail_text', '$esc_readme', '$esc_license', '$esc_rights' ) ";
	$result = $xoopsDB->queryF( $sql );
	if ( $result == false ){
		echo "cannot insert item_detail";
		return false;
	}
	
	return true;
}

function xnpdummyUpdateItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	$myts =& MyTextSanitizer::getInstance();
	
	// BasicInformation, Index, Preview, Attachment Խ
	$result = xnpUpdateBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'dummyfile' );
				if ( $result ){
					$result = xnp_insert_change_log( $xnpsid, $item_id, $myts->stripSlashesGPC( $_POST['change_log'] ) );
					$result = !$result;
					if( !$result )
						echo " xnp_insert_change_log failed.";
				}
				else echo " xnpUpdateAttachment failed.";
			}
			else echo " xnpUpdatePreview failed.";
		}
		else echo " xnpUpdateIndex failed.";
	}
	else echo " xnpUpdateBasicInformation failed.";
	if ( !$result )
		return false;
	
	// DetailInformationϿ
	$esc_detail_text = $myts->addSlashes( $_POST['detail_text'] );
	$esc_readme  = addslashes( xnpGetTextFile( 'readme' ) );
	$esc_license = addslashes( xnpGetTextFile( 'license' ) );
	$esc_rights  = addslashes( xnpGetTextFile( 'rights' ) );
	$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnpdummy_item_detail") . " set detail_text = '$esc_detail_text', readme='$esc_readme', license='$esc_license', rights='$esc_rights' where dummy_id = $item_id " );
	if ( $result == false ){
		echo "update " . $xoopsDB->prefix("xnpdummy_item_detail") . " set detail_text = '$esc_detail_text', readme='$esc_readme', license='$esc_license', rights='$esc_rights' where dummy_id = $item_id ";
		return false;
	}
	return true;
}

function xnpdummyDeleteItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// BasicInformation, Index, Preview, Attachment κ
	if( !xnpDeleteBasicInformation( $item_id ) ){
		echo "cannot delete model item";
		return false;
	}
	
	// DetailInformationκ
	$sql = "delete from " . $xoopsDB->prefix("xnpdummy_item_detail")
		. " where dummy_id=$item_id";
	$xoopsDB->queryF( $sql );
	return true;
}



function xnpdummyGetDetailInformationQuickSearchQuery(&$wheres, &$join, $keywords){
	global $xoopsDB;
	$dummy_table = $xoopsDB->prefix('xnpdummy_item_detail');
	$file_table  = $xoopsDB->prefix('xnpaccount_file');
	
	$join = "";
	$wheres = xnpGetKeywordsQueries( array("$dummy_table.detail_text"/*, "$file_table.original_file_name"*/), $keywords );
	return true;
}



function xnpdummyGetAdvancedSearchQuery(&$where, &$join){
	global $xoopsDB;
	$basic_table = $xoopsDB->prefix('xnpaccount_item_basic');
	$dummy_table = $xoopsDB->prefix('xnpdummy_item_detail');
	$file_table  = $xoopsDB->prefix('xnpaccount_file');
	
	$wheres = array();
	$joins = array();
	$w = xnpGetBasicInformationAdvancedSearchQuery('xnpdummy');                     if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($dummy_table.'.detail_text'   ,'xnpdummy_detail_text'); if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($dummy_table.'.readme'        ,'xnpdummy_readme'     ); if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($dummy_table.'.license'       ,'xnpdummy_license'    ); if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($dummy_table.'.rights'        ,'xnpdummy_rights'     ); if ( $w ) $wheres[] = $w;
	
	$w = xnpGetKeywordQuery($file_table. '.original_file_name' ,'xnpdummy_dummyfile');
	if ( $w ){
		$wheres[] = $w;
		
		// dummyfile  file_type_id Ｐ˲ä
		$file_type_table = $xoopsDB->prefix('xnpaccount_file_type');
		$result = $xoopsDB->query( "select file_type_id from $file_type_table where name='dummyfile'" );
		list($dummy_file_type_id) = $xoopsDB->fetchRow($result);
		$wheres[] = " $file_table.file_type_id = $dummy_file_type_id";
	}
	
	$file_table2 = 'xnpdummy_file'; // captionΤˡ⤦1xnpaccount_filejoin
	$w = xnpGetKeywordQuery($file_table2.'.caption' ,'xnpdummy_caption');
	if ( $w ){
		$wheres[] = $w;
		$joins[] = " left join $file_table as $file_table2 on $basic_table.item_id=$file_table2.item_id and $file_table2.file_type_id=1 ";
	}
	$where = implode( ' and ', $wheres );
	$join = implode( ' ', $joins );
}

function xnpdummyGetAdvancedSearchBlock(&$search_var){
	// BasicInformation / Preview / IndexKeywords  block롣
	$basic   = xnpGetBasicInformationAdvancedSearchBlock('xnpdummy',$search_var);
	$search_var[] = 'xnpdummy_detail_text';
	$search_var[] = 'xnpdummy_readme';
	$search_var[] = 'xnpdummy_license';
	$search_var[] = 'xnpdummy_rights';
	$search_var[] = 'xnpdummy_dummyfile';
	
	// template˥åȤ
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // xoopsTpl˥åȤ줿ѿ($xoops_urlȤ)$tpl˥ԡ롣
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'module_name', 'xnpdummy' );
	$types = array( );
	if( xnp_get_item_types( $types ) == RES_OK ) {
		foreach( $types as $i ) {
			if( $i['name'] == 'xnpdummy' ) {
				$tpl->assign( 'module_display_name', $i['display_name'] );
			}
		}
	} else {
		$tpl->assign( 'module_display_name', 'xnpdummy' );
	}
	
	// HTMLˤ֤
	return $tpl->fetch( "db:xnpdummy_search_block.html" );
}

function xnpdummyGetDetailInformationTotalSize($iids){
	return xnpGetTotalFileSize($iids);
}

?>
