<?php
//  $Revision: 1.1.2.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

global $xoopsConfig;
if ( file_exists( XOOPS_ROOT_PATH.'/modules/xnpfiles/language/' . $xoopsConfig['language'] . '/main.php') ){
	include_once( XOOPS_ROOT_PATH.'/modules/xnpfiles/language/' . $xoopsConfig['language'] . '/main.php' );
}
else {
	include_once( XOOPS_ROOT_PATH.'/modules/xnpfiles/language/english/main.php' );
}

function xnpfilesGetTypes(){
//	return array( 'excel'=>'Excel', 'movie'=>'Movie', 'text'=>'Text', 'picture'=>'Picture', 'other'=>'Other' );
	$files = xnpfilesGetDetailDistinctInfo( "data_file_filetype" );
	$html = array();
	if ( count( $files ) == 0 ){
	}
	else {
		$mimetypes = $files;
		foreach( $mimetypes as $key => $value ){
//			$html[$value[0]]= ucfirst($value[0]);
			if ($value[0] == '') {
				$html[$value[0]]= "none";
			}
			else {
				$html[$value[0]]= $value[0];
			}
		}
	}
	return $html;
}

/** get DetailInformation by item_id
  * 
  */
function xnpfilesGetDetailInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
/*
		return array(
			'data_type'       =>'',
			'experimenter'    =>''
		);
*/
		return array(
			'data_file_name'       =>'',
			'data_file_mimetype'    =>'',
			'data_file_filetype'    =>''
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnpfiles_item_detail") . " where files_id=$item_id";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	
//	$types = xnpfilesGetTypes();
	$detail = $xoopsDB->fetchArray($result);
//	$detail['data_type_str'] = $types[$detail['data_type']];
	return $detail;
}

function xnpfilesGetDetailDistinctInfo( $columns ){
	global $xoopsDB;
	
	$sql = "select distinct($columns) from " . $xoopsDB->prefix("xnpfiles_item_detail") . " order by $columns";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}

	$files = array();
	while ( false != ( $row = $xoopsDB->fetchRow($result) ) )
		$files[] = $row;
	return $files;
}


function xnpfilesGetMetaInformation( $item_id ){
	$ret = array();
	$basic = xnpGetBasicInformationArray($item_id);
	$detail = xnpfilesGetDetailInformation( $item_id );
	if ( !empty( $basic ) ){
		$ret[_MD_XOONIPS_ITEM_TITLE_LABEL] = $basic['title'];
		$ret[_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL] = $basic['contributor'];
		$ret[_MD_XOONIPS_ITEM_KEYWORDS_LABEL] = $basic['keywords'];
		$ret[_MD_XOONIPS_ITEM_DESCRIPTION_LABEL] = $basic['description'];
		$ret[_MD_XOONIPS_ITEM_DOI_LABEL] = $basic['doi'];
		$ret[_MD_XOONIPS_ITEM_CREATION_DATE_LABEL] = $basic['creation_date'];
		$ret[_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL] = $basic['last_update_date'];
	}
/*
	if ( !empty( $detail ) ){
		$ret[_MD_XNPFILES_DATA_TYPE_LABEL   ] = $detail['data_type_str'   ];
		$ret[_MD_XNPFILES_EXPERIMENTER_LABEL] = $detail['experimenter'];
	}
*/
	if ( !empty( $basic ) ){
		$publication_gmt = mktime(0,0,0,$basic['publication_month'],$basic['publication_mday'],$basic['publication_year']);
		$ret[_MD_XNPFILES_DATE_LABEL        ] = date(DATE_FORMAT,$publication_gmt);
	}
	if ( !empty( $detail ) ){
/*
		$ret[_MD_XOONIPS_ITEM_README_LABEL      ] = $detail['readme' ];
		$ret[_MD_XOONIPS_ITEM_LICENSE_LABEL     ] = $detail['license'];
		$ret[_MD_XOONIPS_ITEM_RIGHTS_LABEL      ] = $detail['rights' ];
*/
	}
	return $ret;
}

function xnpfilesGetListBlock( $item_basic ){
	$item_id = $item_basic['item_id'];
	
	$basic   = xnpGetBasicInformationDetailBlock( $item_id );
	// get DetailInformation
//	$item_detail = xnpfilesGetDetailInformation( $item_id );
	$contributor = $basic['contributor'];
	$data_file_mimetype = xnpGetAttachmentMimetypeBlock( $item_id, 'data_file' );
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'item_basic', $item_basic );
//	$tpl->assign( 'item_detail', $item_detail );
//	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'contributor', $contributor );
	$tpl->assign( 'data_file_mimetype', $data_file_mimetype );
	if( xnpIsPending( $item_basic['item_id'] ) ) $tpl->assign( 'pending', 'true' );
    
	// return as HTML
	//return $tpl->fetch( XOOPS_ROOT_PATH . "/modules/xnpfiles/templates/xnpfiles_list_block.html" );
	return $tpl->fetch( "db:xnpfiles_list_block.html" );
}

function xnpfilesGetPrinterFriendlyListBlock( $item_basic ){
	return xnpfilesGetListBlock( $item_basic );
}


function xnpfilesGetDetailBlock( $item_id ){
	
	// get DetailInformation
	$item_detail = xnpfilesGetDetailInformation( $item_id );
	
	// get BasicInformation / Preview / IndexKeywords block
	$basic   = xnpGetBasicInformationDetailBlock( $item_id );
//	$preview = xnpGetPreviewDetailBlock( $item_id );
	$index   = xnpGetIndexDetailBlock( $item_id );
	$data_file = xnpGetAttachmentDetailBlock( $item_id, 'data_file' );
	$data_file_name = xnpGetAttachmentFilenameBlock( $item_id, 'data_file' );
	$data_file_mimetype = xnpGetAttachmentMimetypeBlock( $item_id, 'data_file' );
	$data_file_filetype = xnpGetAttachmentFiletypeBlock( $item_id, 'data_file' );
/*
	$readme  = xnpGetTextFileDetailBlock( $item_id, 'readme' , $item_detail['readme' ] );
	$license = xnpGetTextFileDetailBlock( $item_id, 'license', $item_detail['license'] );
	$rights  = xnpGetTextFileDetailBlock( $item_id, 'rights' , $item_detail['rights' ] );
*/
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'basic', $basic );
//	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'data_file', $data_file );
	$tpl->assign( 'data_file_name', $data_file_name );
	$tpl->assign( 'data_file_mimetype', $data_file_mimetype );
	$tpl->assign( 'data_file_filetype', $data_file_filetype );
	$tpl->assign( 'detail', $item_detail );
/*
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights );
*/
	
	
	// return as HTML
	return $tpl->fetch( "db:xnpfiles_detail_block.html" );
}

function xnpfilesGetPrinterFriendlyDetailBlock( $item_id ){
	$myts =& MyTextsanitizer::getInstance();
	
	// get DetailInformation
	$item_detail = xnpfilesGetDetailInformation( $item_id );
	
	// get BasicInformation / Preview / IndexKeywords block
	$basic   = xnpGetBasicInformationPrinterFriendlyBlock( $item_id );
//	$preview = xnpGetPreviewPrinterFriendlyBlock( $item_id );
	$index   = xnpGetIndexPrinterFriendlyBlock( $item_id );
	$data_file = xnpGetAttachmentPrinterFriendlyBlock( $item_id, 'data_file' );
	$data_file_name = xnpGetAttachmentFilenameBlock( $item_id, 'data_file' );
	$data_file_mimetype = xnpGetAttachmentMimetypeBlock( $item_id, 'data_file' );
	$data_file_filetype = xnpGetAttachmentFiletypeBlock( $item_id, 'data_file' );
/*
	$readme  = xnpGetTextFilePrinterFriendlyBlock( $item_id, 'readme',  $item_detail['readme']  );
	$license = xnpGetTextFilePrinterFriendlyBlock( $item_id, 'license', $item_detail['license'] );
	$rights  = xnpGetTextFilePrinterFriendlyBlock( $item_id, 'rights',  $item_detail['rights']  );
*/
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'basic', $basic );
//	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'data_file', $data_file );
	$tpl->assign( 'data_file_name', $data_file_name );
	$tpl->assign( 'data_file_mimetype', $data_file_mimetype );
	$tpl->assign( 'data_file_filetype', $data_file_filetype );
	$tpl->assign( 'detail', $item_detail );
/*
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights );
*/
	
	
	// return as HTML
	return $tpl->fetch( "db:xnpfiles_detail_block.html" );
}

function xnpfilesGetRegisterBlock(){
	global $xoopsDB;
	$myts =& MyTextSanitizer::getInstance();
	
	// get DetailInformation
/*
	if ( isset( $_POST['data_type'] ) ){
		$detail = array(
			'data_type'     =>$myts->stripSlashesGPC($_POST['data_type'     ]),
			'experimenter'  =>$myts->stripSlashesGPC($_POST['experimenter'  ])
		);
	}
	else
		$detail = array( 'data_type'=>'text' );
*/

	// get BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationRegisterBlock();
	if( $basic['title'] == '' ){
		$basic['title'] = " ";
	}
//	$preview = xnpGetPreviewRegisterBlock();
	$index = xnpGetIndexRegisterBlock();
//	$title_data_file_name = xnpGetBasicInformationTitleRegisterBlock( $item_id );
	$data_file = xnpGetAttachmentRegisterBlock( 'data_file' );

//	$data_file_name = xnpGetAttachmentFilenameBlock( $item_id, 'data_file' );
	if ( isset($_POST['data_file_name' ]) ) $data_file_name  = array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $_POST['data_file_name' ] );
	else $data_file_name  = '';
//	$data_file_mimetype = xnpGetAttachmentMimetypeBlock( $item_id, 'data_file' );
	if ( isset($_POST['data_file_mimetype' ]) ) $data_file_mimetype  = array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $_POST['data_file_mimetype' ] );
	else $data_file_mimetype  = '';
//	$data_file_filetype = xnpGetAttachmentFiletypeBlock( $item_id, 'data_file' );
	if ( isset($_POST['data_file_filetype' ]) ) $data_file_filetype  = array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $_POST['data_file_filetype' ] );
	else $data_file_filetype  = '';
/*
	$readme  = xnpGetTextFileRegisterBlock( 'readme'  );
	$license = xnpGetTextFileRegisterBlock( 'license' );
	$rights  = xnpGetTextFileRegisterBlock( 'rights'  );
	$attachment_dl_limit = xnpGetDownloadLimitationOptionRegisterBlock( 'xnpfiles' );
*/
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'basic', $basic );
//	$tpl->assign( 'title_data_file_name', $title_data_file_name );
//	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
//	$tpl->assign( 'attachment_dl_limit', $attachment_dl_limit );
	$tpl->assign( 'data_file', $data_file );
	$tpl->assign( 'data_file_name', $data_file_name );
	$tpl->assign( 'data_file_mimetype', $data_file_mimetype );
	$tpl->assign( 'data_file_filetype', $data_file_filetype );
//	$tpl->assign( 'detail', $detail );
/*
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights );
*/
/*
	$tpl->assign( 'data_type', xnpfilesGetTypes() );
	$tpl->assign( 'data_type_selected', $detail['data_type'] );
*/
	// return as HTML
	return $tpl->fetch( "db:xnpfiles_register_block.html" );
}

function xnpfilesGetEditBlock( $item_id ){
	global $xoopsDB;

	// get BasicInformation / Preview / index block
	$basic   = xnpGetBasicInformationEditBlock( $item_id );
//	$preview = xnpGetPreviewEditBlock( $item_id );
	$index = xnpGetIndexEditBlock( $item_id );
	$data_file = xnpGetAttachmentEditBlock( $item_id, 'data_file' );
	$data_file_name = xnpGetAttachmentFilenameBlock( $item_id, 'data_file' );
	if ( isset($_POST['data_file_name' ]) ) $data_file_name  = array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $_POST['data_file_name' ] );
	else $data_file_name  = '';
	$data_file_mimetype = xnpGetAttachmentMimetypeBlock( $item_id, 'data_file' );
	if ( isset($_POST['data_file_mimetype' ]) ) $data_file_mimetype  = array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $_POST['data_file_mimetype' ] );
	else $data_file_mimetype  = '';
	$data_file_filetype = xnpGetAttachmentFiletypeBlock( $item_id, 'data_file' );
	if ( isset($_POST['data_file_filetype' ]) ) $data_file_filetype  = array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $_POST['data_file_filetype' ] );
	else $data_file_filetype  = '';
	// get DetailInformation
/*
	if ( isset( $_POST['data_type'] ) ){
		$myts =& MyTextSanitizer::getInstance();
		$detail = array(
			'data_type'     =>$myts->stripSlashesGPC($_POST['data_type'     ]),
			'experimenter'  =>$myts->stripSlashesGPC($_POST['experimenter'  ]),
			'readme'  => '',
			'license' => '',
			'rights'  => ''
		);
		$detail = array(
			'data_type'     =>$myts->stripSlashesGPC($_POST['data_type'     ]),
			'experimenter'  =>$myts->stripSlashesGPC($_POST['experimenter'  ])
		);
	}
	else if ( !empty( $item_id ) ){
*/
	if ( !empty( $item_id ) ){
		$detail = xnpfilesGetDetailInformation( $item_id );
	}
	else
		$detail = array();
/*
	$readme  = xnpGetTextFileEditBlock( $item_id, 'readme' , $detail['readme' ] );
	$license = xnpGetTextFileEditBlock( $item_id, 'license', $detail['license'] );
	$rights  = xnpGetTextFileEditBlock( $item_id, 'rights' , $detail['rights' ] );
	$attachment_dl_limit = xnpGetDownloadLimitationOptionEditBlock( 'xnpfiles', xnpfilesGetAttachmentDownloadLimitOption( $item_id ) );
*/
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'basic', $basic );
//	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
//	$tpl->assign( 'attachment_dl_limit', $attachment_dl_limit );
	$tpl->assign( 'data_file', $data_file );
	$tpl->assign( 'data_file_name', $data_file_name );
	$tpl->assign( 'data_file_mimetype', $data_file_mimetype );
	$tpl->assign( 'data_file_filetype', $data_file_filetype );
	$tpl->assign( 'detail', $detail );
/*
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights );
	$tpl->assign( 'data_type', xnpfilesGetTypes() );
	$tpl->assign( 'data_type_selected', $detail['data_type'] );
*/

	
	// return as HTML
	return $tpl->fetch( "db:xnpfiles_register_block.html" );
}


function xnpfilesGetConfirmBlock( $item_id ){
	// get BasicInformation / Preview / index block
	$basic   = xnpGetBasicInformationConfirmBlock( $item_id );
//	$basic['title'] = mb_convert_encoding($basic['title'],UTF-8,mb_detect_encoding($basic['title']));
//	$basic['title'] = mb_convert_encoding($basic['title'],UTF-8,EUC-JP);
//	$preview = xnpGetPreviewConfirmBlock( $item_id );
	$index   = xnpGetIndexConfirmBlock( $item_id );
	$data_file = xnpGetAttachmentConfirmBlock( $item_id, 'data_file' );
	$data_file_name = xnpGetAttachmentFilenameConfirmBlock( $item_id, 'data_file' );
//	$data_file_name = mb_convert_encoding($htmlFileName,UTF-8,mb_detect_encoding($data_file_name));
//	$data_file_name = mb_convert_encoding($htmlFileName,UTF-8,EUC-JP);
	$data_file_mimetype = xnpGetAttachmentMimetypeConfirmBlock( $item_id, 'data_file' );
	$data_file_filetype = xnpGetAttachmentFiletypeConfirmBlock( $item_id, 'data_file' );
/*
	$readme  = xnpGetTextFileConfirmBlock( $item_id, 'readme' );
	$license = xnpGetTextFileConfirmBlock( $item_id, 'license');
	$rights  = xnpGetTextFileConfirmBlock( $item_id, 'rights' );
	$attachment_dl_limit = xnpGetDownloadLimitationOptionConfirmBlock( 'xnpfiles' );
*/
	// get DetailInformation
/*
	if ( isset( $_POST['experimenter'] ) ){
		$myts =& MyTextSanitizer::getInstance();
		$detail = array(
			'data_type'     =>$myts->stripSlashesGPC($_POST['data_type'     ]),
			'experimenter'  =>$myts->stripSlashesGPC($_POST['experimenter'  ])
		);
		$types = xnpfilesGetTypes();
		$detail['data_type_str'] = $types[$detail['data_type']];
	}
	else if ( !empty( $item_id ) )
*/
	if ( !empty( $item_id ) )
		$detail = xnpfilesGetDetailInformation( $item_id );
	else
		$detail = array();
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'basic', $basic );
//	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
//	$tpl->assign( 'attachment_dl_limit', $attachment_dl_limit );
	$tpl->assign( 'data_file', $data_file );
	$tpl->assign( 'data_file_name', $data_file_name );
	$tpl->assign( 'data_file_mimetype', $data_file_mimetype );
	$tpl->assign( 'data_file_filetype', $data_file_filetype );
	$tpl->assign( 'detail', $detail );
/*
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights );
*/
	// return as HTML
	return $tpl->fetch( "db:xnpfiles_confirm_block.html" );
}

/** check DetailInformation input
 * called from confirm/registered page
 */
function xnpfilesCheckRegisterParameters( &$message ){
	$xnpsid = $_SESSION['XNPSID'];
	$messages = array();
//	if ( empty( $_POST['experimenter'] ) )  $messages[] = _MD_XNPFILES_EXPERIMENTER_REQUIRED;
	if ( empty( $_POST['data_fileFileID'  ]) && empty( $_FILES['data_file']['name']) ) $messages[] = _MD_XNPFILES_DATA_FILE_REQUIRED;
	if( $_POST['title'] == " " ){
		$fileName = $_FILES['data_file']['name'];
		if (xnpChkServerLang()) {
			if ( mb_substr_count( $fileName, "." ) > 0 ){
				$fileName = mb_substr( $fileName, 0, mb_strrpos( $fileName, "." ) );
			}
		}
		else {
			if ( substr_count( $fileName, "." ) > 0 ){
				$fileName = substr($fileName,0,strlen($fileName) - strlen(strrchr($fileName,".")));
			}
		}
//		$fileName = mb_convert_encoding($fileName,UTF-8,mb_detect_encoding($fileName));
		$_POST['title'] = $fileName;
	}
//	$fileName = htmlspecialchars($_FILES['data_file']['name']);
//	$fileName = mb_substr($fileName,0,mb_strrpos($fileName,"."));
//	$_POST['title'] = "$fileName";
	
	// require Readme, License and Rights if register to public indexes
	$xids = explode( ',', $_POST['xoonipsCheckedXID'] );
	$indexes = array( );
	if( $xids[0] != $_POST['xoonipsCheckedXID'] ) {
		foreach( $xids as $i ) {
			$index = array( );
			if( xnp_get_index( $xnpsid, $i, $index ) == RES_OK ) {
				$indexes[] = $index;
			} else {
				$messages[] = "<font color='#ff0000'>".xnp_get_last_error_string( )."</font>";
				$result = false;
				break;
			}
		}
	}
/*
	if( count( $indexes ) > 0 ) {
		foreach( $indexes as $i ) {
			if( $i['open_level'] <= OL_GROUP_ONLY ) {
				if( $_POST['readmeEncText'] == '' ) {
					//readme is not filled
					$messages[] = "<font color='#ff0000'>"._MD_XNPFILES_README_REQUIRED."</font>";
				}
				if( $_POST['licenseEncText'] == '' ) {
					//license is not filled
					$messages[] = "<font color='#ff0000'>"._MD_XNPFILES_LICENSE_REQUIRED."</font>";
				}
				if( $_POST['rightsEncText'] == '' ) {
					//rights is not filled
					$messages[] = "<font color='#ff0000'>"._MD_XNPFILES_RIGHTS_REQUIRED."</font>";
				}
				break;
			}
		}
	}
*/
	if ( count($messages) == 0 )
		return true;
	$message = "<br>\n" . implode( "<br>\n", $messages );
	return false;
}

/** check DetailInformation input
 */
function xnpfilesCheckEditParameters( &$message ){
	return xnpfilesCheckRegisterParameters( $message );
}

function xnpfilesInsertItem(){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// register BasicInformation, Index, Attachment
	$item_id = 0;
	$result = xnpInsertBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'data_file' );
				if ( $result ){
				}
			}
		}
		if ( !$result )
			xnpDeleteBasicInformation( $xnpsid, $item_id );
	}
	if ( !$result )
		return false;
	
	$myts =& MyTextSanitizer::getInstance();
/*
	$keys = implode( ",", array(
		'data_type'     ,
		'experimenter'  ,
		'attachment_dl_limit'  
	) );
*/
	$keys = implode( ",", array(
		'data_file_name',
		'data_file_mimetype',
		'data_file_filetype'
	) );
/*
	$vals = implode( "','", array(
		$myts->addSlashes($_POST['data_type'     ]),
		$myts->addSlashes($_POST['experimenter'  ]),
		$myts->addSlashes($_POST['attachment_dl_limit'  ])
	) );
*/
//	$data_file_name = xnpGetAttachmentFilenameBlock( $item_id, 'data_file' );
//	$data_file_mimetype = xnpGetAttachmentMimetypeBlock( $item_id, 'data_file' );
//	$data_file_filetype = xnpGetAttachmentFiletypeBlock( $item_id, 'data_file' );
	$vals = implode( "','", array(
		$myts->addSlashes($_POST['data_file_name'     ]),
		$myts->addSlashes($_POST['data_file_mimetype'  ]),
		$myts->addSlashes($_POST['data_file_filetype'  ])
	) );
	
	
	// register DetailInformation
/*
	$myts =& MyTextSanitizer::getInstance();
	$esc_readme  = addslashes( xnpGetTextFile( 'readme'  ) );
	$esc_license = addslashes( xnpGetTextFile( 'license' ) );
	$esc_rights  = addslashes( xnpGetTextFile( 'rights'  ) );
*/
//	$sql = "insert into " . $xoopsDB->prefix("xnpfiles_item_detail") . " ( files_id, readme, license, rights, $keys ) values ( $item_id, '$esc_readme', '$esc_license', '$esc_rights', '$vals' ) ";
	$sql = "insert into " . $xoopsDB->prefix("xnpfiles_item_detail") . " ( files_id, $keys ) values ( $item_id, '$vals' ) ";
	$result = $xoopsDB->queryF( $sql );
	if ( $result == false ){
		echo "cannot insert item_detail";
		return false;
	}
	
	return true;
}

function xnpfilesUpdateItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	$myts =& MyTextSanitizer::getInstance();
	
	// edit BasicInformation, Index, Preview, Attachment 
	$result = xnpUpdateBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'data_file' );
				if ( $result ){
					$result = xnp_insert_change_log( $xnpsid, $item_id, $myts->stripSlashesGPC( $_POST['change_log'] ) );
					$result = !$result;
					if( !$result )
						echo " xnp_insert_change_log failed.";
				}
				else echo " xnpUpdateAttachment failed.";
			}
			else echo " xnpUpdatePreview failed.";
		}
		else echo " xnpUpdateIndex failed.";
	}
	else echo " xnpUpdateBasicInformation failed.";
	if ( !$result )
		return false;
	
	// register DetailInformation
/*
	$esc_readme  = addslashes( xnpGetTextFile( 'readme' ) );
	$esc_license = addslashes( xnpGetTextFile( 'license' ) );
	$esc_rights  = addslashes( xnpGetTextFile( 'rights' ) );
*/
/*
	$sql = implode( ',', array(
		'data_type'      ."='".$myts->addSlashes($_POST['data_type'     ])."'",
		'experimenter'   ."='".$myts->addSlashes($_POST['experimenter'  ])."'",
		'attachment_dl_limit'."='".$myts->addSlashes($_POST['attachment_dl_limit'  ])."'"
	) );
*/
//	$data_file_name = xnpGetAttachmentFilenameBlock( $item_id, 'data_file' );
//	$data_file_mimetype = xnpGetAttachmentMimetypeBlock( $item_id, 'data_file' );
//	$data_file_filetype = xnpGetAttachmentFiletypeBlock( $item_id, 'data_file' );
	$sql = implode( ',', array(
		'data_file_name'      ."='".$myts->addSlashes($_POST['data_file_name'     ])."'",
		'data_file_mimetype'   ."='".$myts->addSlashes($_POST['data_file_mimetype'     ])."'",
		'data_file_filetype'."='".$myts->addSlashes($_POST['data_file_filetype'     ])."'"
	) );
//	$sql = "update " . $xoopsDB->prefix("xnpfiles_item_detail") . " set readme='$esc_readme', license='$esc_license', rights='$esc_rights', $sql where files_id = $item_id ";
	$sql = "update " . $xoopsDB->prefix("xnpfiles_item_detail") . " set $sql where files_id = $item_id ";
	$result = $xoopsDB->queryF( $sql );
	if ( $result == false ){
		echo $sql;
		return false;
	}
	return true;
}

function xnpfilesDeleteItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// delete BasicInformation, Index, Preview, Attachment 
	if( !xnpDeleteBasicInformation( $item_id ) ){
		echo "cannot delete model item";
		return false;
	}
	
	// delete DetailInformation
	$sql = "delete from " . $xoopsDB->prefix("xnpfiles_item_detail")
		. " where files_id=$item_id";
	$xoopsDB->queryF( $sql );
	return true;
}




function xnpfilesGetDetailInformationQuickSearchQuery(&$wheres, &$join, $keywords){
	global $xoopsDB;
	$data_table = $xoopsDB->prefix('xnpfiles_item_detail');
	$file_table  = $xoopsDB->prefix('xoonips_file');
	
//	$wheres = xnpGetKeywordsQueries( array("$data_table.experimenter","$file_table.caption"), $keywords );
	$wheres = xnpGetKeywordsQueries( array("$data_table.data_file_name","$data_table.data_file_mimetype","$data_table.data_file_filetype",), $keywords );
	return true;
}


function xnpfilesGetAdvancedSearchQuery(&$where, &$join){
	global $xoopsDB;
	$basic_table =$xoopsDB->prefix('xoonips_item_basic');
	$data_table = $xoopsDB->prefix('xnpfiles_item_detail');
	$file_table = $xoopsDB->prefix('xoonips_file');
	
	$wheres = array();
	$joins = array();
	$w = xnpGetBasicInformationAdvancedSearchQuery('xnpfiles');                  if ( $w ) $wheres[] = $w;
	if ( !empty($_POST['xnpfiles_data_file_filetype']) ){
		$myts =& MyTextSanitizer::getInstance();
		$wheres[] = $data_table.'.data_file_filetype = \'' . $myts->addSlashes($_POST['xnpfiles_data_file_filetype']) . "'";
	}
/*
	$w = xnpGetKeywordQuery($data_table.'.experimenter', 'xnpfiles_experimenter'  ); if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($file_table. '.caption', 'xnpfiles_caption');
	if ( $w ){
		$wheres[] = $w;
		$wheres[] = " $file_table.file_type_id = 1";
	}
*/
	if ( !empty($_POST['data_file_name']) ){
		$myts =& MyTextSanitizer::getInstance();
		$wheres[] = $data_table.'.data_file_name = \'' . $myts->addSlashes($_POST['data_file_name']) . "'";
	}
	$w = xnpGetKeywordQuery($data_table.'.data_file_mimetype', 'data_file_mimetype'  ); if ( $w ) $wheres[] = $w;
	$w = "";
	foreach ($_POST as $key => $value) {
		if (substr($key,0,19) == "data_file_filetype_"){
			if ($w != "") $w .= ' or ';
			$w .= $data_table.".data_file_filetype = '".substr($key,19)."'";
		}
	}
	if ( $w ){
		$wheres[] = $w;
	}

	$where = implode( ' and ', $wheres );
	$join = implode( ' ', $joins );
}

function xnpfilesGetAdvancedSearchBlock(&$search_var){
	// get BasicInformation / Preview / IndexKeywords block
	$basic   = xnpGetBasicInformationAdvancedSearchBlock('xnpfiles',$search_var);
	$data_file_name = xnpfilesGetAttachmentFilenameAdvancedSearchBlock( 'data_file_name' );
	$data_file_mimetype = xnpfilesGetAttachmentMimetypeAdvancedSearchBlock( 'data_file_mimetype' );
	$data_file_filetype = xnpfilesGetAttachmentFiletypeAdvancedSearchBlock( 'data_file_filetype' );
/*
	$search_var[] = 'xnpfiles_data_type'   ;
	$search_var[] = 'xnpfiles_experimenter';
*/
	$search_var[] = 'data_file_mimetype'   ;
	$search_var[] = 'data_file_filetype';
	$search_var[] = 'xnpfiles_data_file'   ;
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	

/*
	$tpl->assign( 'data_type', array_merge( array(''=>'Any'), xnpfilesGetTypes()) );
	$tpl->assign( 'data_type_selected', 'none' );
*/
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'module_name', 'xnpfiles' );
	$tpl->assign( 'data_file_name', $data_file_name );
	$tpl->assign( 'data_file_mimetype', $data_file_mimetype );
	$tpl->assign( 'data_file_filetype', $data_file_filetype );
	$types = array( );
	if( xnp_get_item_types( $types ) == RES_OK ) {
		foreach( $types as $i ) {
			if( $i['name'] == 'xnpfiles' ) {
				$tpl->assign( 'module_display_name', $i['display_name'] );
			}
		}
	} else {
		$tpl->assign( 'module_display_name', 'xnpfiles' );
	}
	
	// return as HTML
	return $tpl->fetch( "db:xnpfiles_search_block.html" );
}

function xnpfilesGetAttachmentFilenameAdvancedSearchBlock( $name ){
	// create html
	$html = "<input type='text' name='${name}' value='' />";
	return array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $html );
}

function xnpfilesGetAttachmentMimetypeAdvancedSearchBlock( $name ){
	// get attachment file
	// create html
	$files = xnpfilesGetDetailDistinctInfo( "data_file_mimetype" );
	if ( count( $files ) == 0 ){
		$html = '<select name="data_file_mimetype">
				</select>';
	}
	else {
		$mimetypes = $files;
		$html = '<select name="data_file_mimetype">';
		$html .= '<option value="">Any</option>
		';
		foreach( $mimetypes as $key => $value ){
			$html .= '<option label="'.$value[0].'" value="'.$value[0].'">'.$value[0].'</option>
			';
		}
		$html .= '</select>';
	}
	return array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $html );
}

function xnpfilesGetAttachmentFiletypeAdvancedSearchBlock( $name ){
	// get attachment file
	// create html
	$files = xnpfilesGetDetailDistinctInfo( "data_file_filetype" );
	if ( count( $files ) == 0 ){
		$html = '<select name="data_file_filetype">
				</select>';
	}
	else {
		$mimetypes = $files;
		$html = '<table><tr>';
		$html .= '<td><input type="checkbox" name="data_file_filetype_Any" value="any">Any</td>
		';
		$cnt = 1;
		foreach( $mimetypes as $key => $value ){
			if ($value[0] == '') {
				$html .= '<td><input type="checkbox" name="data_file_filetype_'.$value[0].'">none</td>
				';
			}
			else {
				$html .= '<td><input type="checkbox" name="data_file_filetype_'.$value[0].'">'.$value[0].'</td>
				';
			}
			$cnt++;
			if ($cnt >= 10) {
				$html .= '</tr><tr>';
				$cnt = 0;
			}
		}
		$html .= '</tr></table>';
	}
	return array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $html );
}


function xnpfilesGetDetailInformationTotalSize($iids){
	return xnpGetTotalFileSize($iids);
}

function xnpfilesExportItem($item_id, $attachment )
{
	global $xoopsDB;

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpfiles_item_detail" )." where files_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
/*
	return "<detail id=\"${item_id}\">\n"
        ."<data_type>".htmlspecialchars( $detail['data_type'], ENT_QUOTES )."</data_type>\n"
        ."<experimenter>".htmlspecialchars( $detail['experimenter'], ENT_QUOTES )."</experimenter>\n"
        ."<rights>".htmlspecialchars( $detail['rights'], ENT_QUOTES )."</rights>\n"
        ."<license>".htmlspecialchars( $detail['license'], ENT_QUOTES )."</license>\n"
        ."<readme>".htmlspecialchars( $detail['readme'], ENT_QUOTES )."</readme>\n"
        .( $attachment ? xnpExportFile( $item_id ) : '' )
        ."</detail>\n";
*/
	return "<detail id=\"${item_id}\">\n"
        ."<data_file_name>".xnpHtmlspecialchars( $detail['data_file_name'], ENT_QUOTES )."</data_file_name>\n"
        ."<data_file_mimetype>".xnpHtmlspecialchars( $detail['data_file_mimetype'], ENT_QUOTES )."</data_file_mimetype>\n"
        ."<data_file_filetype>".xnpHtmlspecialchars( $detail['data_file_filetype'], ENT_QUOTES )."</data_file_filetype>\n"
        .( $attachment ? xnpExportFile( $item_id ) : '' )
        ."</detail>\n";
}

function xnpfilesGetLicenseRequired( $item_id )
{
	global $xoopsDB;

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpfiles_item_detail" )." where files_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    return isset( $detail['license'] ) && $detail['license'] != '';
}
function xnpfilesGetLicenseStatement( $item_id )
{
	global $xoopsDB;

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpfiles_item_detail" )." where files_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    return isset( $detail['license'] ) ? $detail['license'] : '';
}

function xnpfilesStartElement($parser, $name, $attribs, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $parser_hash['detail'] = array();
        break;
/*
    case "/ITEM/DETAIL/DATA_TYPE":
    case "/ITEM/DETAIL/EXPERIMENTER": 
    case "/ITEM/DETAIL/RIGHTS": 
    case "/ITEM/DETAIL/LICENSE": 
    case "/ITEM/DETAIL/README": 
*/
    case "/ITEM/DETAIL/DATA_FILE_NAME": 
    case "/ITEM/DETAIL/DATA_FILE_MIMETYPE": 
    case "/ITEM/DETAIL/DATA_FILE_FILETYPE": 
        $parser_hash['detail'][end($parser_hash['tagstack'])] = '';
        break;
    }
//    echo("<b><font color=\"#0000ff\">&lt$name&gt</font></b><br>"); 
}
function xnpfilesEndElement($parser, $name, &$parser_hash)
{
	global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    $myts =& MyTextSanitizer::getInstance( );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
//        print_r( $parser_hash['detail'] );
//        $keys = implode( ",", array( 'data_type', 'experimenter', 'rights', 'license', 'readme' ) );
        $keys = implode( ",", array( 'data_file_name', 'data_file_mimetype', 'data_file_filetype' ) );
/*
        $vals = implode( "','", array( $myts->addSlashes( $parser_hash['detail']['DATA_TYPE'] ),
                                       $myts->addSlashes( $parser_hash['detail']['EXPERIMENTER'] ),
                                       addslashes( $parser_hash['detail']['RIGHTS'] ),
                                       addslashes( $parser_hash['detail']['LICENSE'] ),
                                       addslashes( $parser_hash['detail']['README'] )
            ) );
*/
        $vals = implode( "','", array( $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['DATA_FILE_NAME'] ) ),
                                       $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['DATA_FILE_MIMETYPE'] ) ),
                                       $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['DATA_FILE_FILETYPE'] ) )
            ) );
        
        // register DetailInformation
        $myts =& MyTextSanitizer::getInstance( );
        $sql = "insert into ".$xoopsDB->prefix( "xnpfiles_item_detail" )." ( files_id, $keys ) values ( ".$parser_hash['id_table'][$parser_hash['basic']['ID']].", '$vals' ) ";
        $result = $xoopsDB->queryF( $sql );
        if( $result == false ) {
            echo "cannot insert item_detail\n";
            return false;
        }
        break;
    }
//    echo("<br><b><font color=\"#0000ff\">&lt/$name&gt</font></b><br><br>"); 
}

function xnpfilesCharacterData($parser, $data, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
/*
    case "/ITEM/DETAIL/DATA_TYPE":
    case "/ITEM/DETAIL/EXPERIMENTER": 
    case "/ITEM/DETAIL/RIGHTS": 
    case "/ITEM/DETAIL/LICENSE": 
    case "/ITEM/DETAIL/README": 
*/
    case "/ITEM/DETAIL/DATA_FILE_NAME":
    case "/ITEM/DETAIL/DATA_FILE_MIMETYPE":
    case "/ITEM/DETAIL/DATA_FILE_FILETYPE":
        if( !array_key_exists( end($parser_hash['tagstack']), $parser_hash['detail'] ) ){
            $parser_hash['detail'][end($parser_hash['tagstack'])] = $data;
        }else{
            $parser_hash['detail'][end($parser_hash['tagstack'])] .= $data;
        }
        break; 
    } 
//    echo($data); 
}

function xnpfilesGetImportHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnpfilesStartElement", "xnpfilesEndElement", "xnpfilesCharacterData" ) );
}

function xnpfilesGetModifiedFields( $item_id )
{
    $ret = array();
    $basic = xnpGetBasicInformationArray($item_id);
    if( $basic ){
        if( mktime(0,0,0,$basic['publication_month'],$basic['publication_mday'],$basic['publication_year'] )
            != mktime(0,0,0,$_POST['publicationDateMonth'],$_POST['publicationDateDay'],$_POST['publicationDateYear']) )
            array_push( $ret, _MD_XNPFILES_DATE_LABEL );
    }
    $detail = xnpfilesGetDetailInformation( $item_id );
    if( $detail ){
/*
        $myts =& MyTextSanitizer::getInstance( );
        foreach( array( 'data_type' => _MD_XNPFILES_DATA_TYPE_LABEL,
                        'experimenter' => _MD_XNPFILES_EXPERIMENTER_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) array_push( $ret, $v );
        }
        foreach( array( 'readme' => _MD_XOONIPS_ITEM_README_LABEL,
                        'license' => _MD_XOONIPS_ITEM_LICENSE_LABEL,
                        'rights' => _MD_XOONIPS_ITEM_RIGHTS_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( "${k}EncText", $_POST ) ) continue;
            if( urldecode($_POST[ "${k}EncText" ]) != $detail[ $k ] ) array_push( $ret, $v );
        }
*/
        foreach( array( 'data_file_name' => _MD_XNPFILES_DATA_FILE_NAME,
                        'data_file_mimetype' => _MD_XNPFILES_DATA_FILE_MIMETYPE,
                        'data_file_filetype' => _MD_XNPFILES_DATA_FILE_FILETYPE ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) array_push( $ret, $v );
        }
        
        // was data file modified?
        if( xnpIsAttachmentModified( 'data_file', $item_id ) ){
            array_push( $ret, _MD_XNPFILES_DATA_FILE_LABEL );
        }
    }
    return $ret;
}

function xnpfilesGetTopBlock( $itemtype ){
	return xnpGetTopBlock( $itemtype['name'], $itemtype['display_name'], 'images/icon_files.gif', _MD_XNPFILES_EXPLANATION, 'xnpfiles_data_file_filetype', xnpfilesGetTypes() );
}

//return 1 if downloadable for login user only
//return 0 if downloadable for everyone
/*
function xnpfilesGetAttachmentDownloadLimitOption( $item_id )
{
	global $xoopsDB;
    $sql = "select attachment_dl_limit from ".$xoopsDB->prefix( "xnpfiles_item_detail" )." where files_id=${item_id}";
    $result = $xoopsDB->query( $sql );
    if( $result ){
        list( $option ) = $xoopsDB->fetchRow( $result );
        return $option;
    }
    return 0;
}
*/

function xnpfilesSupportMetadataFormat( $metadataPrefix, $item_id )
{
    if( $metadataPrefix == 'oai_dc' || $metadataPrefix == 'junii' ) return true;
    return false;
}

function xnpfilesGetMetadata( $metadataPrefix, $item_id )
{
    $meta_basic = xnpGetBasicInformationMetadata( $metadataPrefix, $item_id );
    if( $meta_basic ){
		$basic = array();
		if( xnp_get_item( $_SESSION['XNPSID'], $item_id, $basic ) != RES_OK )
			return false;
//		$basic_item   = xnpGetBasicInformationDetailBlock( $item_id );
        $detail = xnpfilesGetDetailInformation( $item_id );
		$lines = array();
		if( $metadataPrefix == 'junii' ){
            $lines[] = "<metadata>";
            $lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii.xsd">';
            $lines[] = $meta_basic;
//            $lines[] = "<type xsi:type=\"NII\">&#65279;&#30740;&#31350;&#36039;&#28304;&#8722;&#12487;&#12540;&#12479;</type>";
            $lines[] = "<type xsi:type=\"NII\">".xnpGetMetadataJunii(20)."</type>";
            $lines[] = "<format xsi:type=\"IMT\">".xnpHtmlspecialchars($detail['data_file_mimetype'])."</format>";
/*
            $lines[] = "<type>dataType:".htmlspecialchars($detail['data_type'])."</type>";
            $lines[] = "<creator>".htmlspecialchars($detail['experimenter'])."</creator>";
*/
//            $lines[] = "<creator>".htmlspecialchars($basic_item['contributor'])."</creator>";
            $lines[] = "<date xsi:type=\"ISO8601\">"
                .date( "Y-m-d", mktime( 0, 0, 0,
                                        $basic['publication_month'],
                                        $basic['publication_mday'],
                                        $basic['publication_year'] ) )
                ."</date>";
/*
            $lines[] = "<description>readme:".htmlspecialchars($detail['readme'])."</description>";
            $lines[] = "<description>rights:".htmlspecialchars($detail['rights'])."</description>";
            $lines[] = "<description>license:".htmlspecialchars($detail['license'])."</description>";
*/
            $lines[] = "</meta>";
            $lines[] = "</metadata>";
        }
		else if ( $metadataPrefix == 'oai_dc' ) {
			$lines = array();
			$lines[] = "<metadata>";
			$lines[] = '<oai_dc:dc 
               xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/" 
               xmlns:dc="http://purl.org/dc/elements/1.1/" 
               xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
               xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/ 
               http://www.openarchives.org/OAI/2.0/oai_dc.xsd">';
			$lines[] = $meta_basic;
            $lines[] = "<dc:format>IMT:".xnpHtmlspecialchars($detail['data_file_mimetype'])."</dc:format>";
/*
			$lines[] = "<dc:type>dataType:".htmlspecialchars($detail['data_type'])."</dc:type>";
			$lines[] = "<dc:creator>".htmlspecialchars($detail['experimenter'])."</dc:creator>";
*/
            $lines[] = "<dc:creator>".xnpHtmlspecialchars($basic_item['contributor'])."</dc:creator>";
			$lines[] = "<dc:date>"
			    .date( "Y-m-d", mktime( 0, 0, 0,
			                            $basic['publication_month'],
			                            $basic['publication_mday'],
			                            $basic['publication_year'] ) )
			    ."</dc:date>";
/*
			$lines[] = "<dc:rights>".htmlspecialchars($detail['rights'])."</dc:rights>";
			$lines[] = "<dc:description>readme:".htmlspecialchars($detail['readme'])."</dc:description>";
			$lines[] = "<dc:description>license:".htmlspecialchars($detail['license'])."</dc:description>";
*/
			$lines[] = "</oai_dc:dc>";
			$lines[] = "</metadata>";
		}
		return implode( "\n", $lines )."\n";
    }
    return false;
}
?>
