<?php
//  $Revision: 1.1.2.1 $                                                            //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

global $xoopsConfig;
if ( file_exists( XOOPS_ROOT_PATH.'/modules/xnpmemo/language/' . $xoopsConfig['language'] . '/main.php') ){
	include_once( XOOPS_ROOT_PATH.'/modules/xnpmemo/language/' . $xoopsConfig['language'] . '/main.php' );
}
else {
	include_once( XOOPS_ROOT_PATH.'/modules/xnpmemo/language/english/main.php' );
}

/** get DetailInformation by item_id
  * 
  */
function xnpmemoGetDetailInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'item_link'    => ''
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnpmemo_item_detail") . " where memo_id=$item_id";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	return $xoopsDB->fetchArray($result);
}

function xnpmemoGetMetaInformation( $item_id ){
	$ret = array();
	$basic = xnpGetBasicInformationArray( $item_id );
	$detail = xnpmemoGetDetailInformation( $item_id );
	
	if ( !empty( $basic ) ){
		$ret[_MD_XOONIPS_ITEM_TITLE_LABEL] = $basic['title'];
		$ret[_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL] = $basic['contributor'];
		$ret[_MD_XOONIPS_ITEM_KEYWORDS_LABEL] = $basic['keywords'];
		$ret[_MD_XOONIPS_ITEM_DESCRIPTION_LABEL] = $basic['description'];
		$ret[_MD_XOONIPS_ITEM_DOI_LABEL] = $basic['doi'];
		$ret[_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL] = $basic['last_update_date'];
		$ret[_MD_XOONIPS_ITEM_CREATION_DATE_LABEL] = $basic['creation_date'];
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XNPMEMO_ITEM_LINK_LABEL] = $detail['item_link'];
	}
	
	return $ret;
}

function xnpmemoGetListBlock( $item_basic ){
	$item_id = $item_basic['item_id'];
	
	// get DetailInformation
	$item_detail = xnpmemoGetDetailInformation( $item_id );
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'item_basic', $item_basic );
	$tpl->assign( 'item_detail', $item_detail );
	if( xnpIsPending( $item_basic['item_id'] ) ) $tpl->assign( 'pending', 'true' );
	
	// return as HTML
	//return $tpl->fetch( XOOPS_ROOT_PATH . "/modules/xnpmemo/templates/xnpmemo_list_block.html" );
	return $tpl->fetch( "db:xnpmemo_list_block.html" );
}

function xnpmemoGetPrinterFriendlyListBlock( $item_basic ){
	return xnpmemoGetListBlock( $item_basic );
}

function xnpmemoGetDetailBlock( $item_id ){
	
	// get DetailInformation
	$item_detail = xnpmemoGetDetailInformation( $item_id );
	
	// get BasicInformation / Preview / IndexKeywords block
	$basic     = xnpGetBasicInformationDetailBlock( $item_id );
		// $preview   = xnpGetPreviewDetailBlock( $item_id );
	$index     = xnpGetIndexDetailBlock( $item_id );
	$memo_file = xnpGetAttachmentDetailBlock( $item_id, 'memo_file' );
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'editable', xnp_get_item_permission( $_SESSION['XNPSID'], $item_id, OP_MODIFY ) );
	$tpl->assign( 'basic', $basic );
		// $tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'memo_file', $memo_file );
	$tpl->assign( 'detail', $item_detail );
	
	
	// return as HTML
	return $tpl->fetch( "db:xnpmemo_detail_block.html" );
}

function xnpmemoGetPrinterFriendlyDetailBlock( $item_id )
{
	//retrive variables from GET/POST array
	$myts =& MyTextsanitizer::getInstance();

	// get DetailInformation
	$item_detail = xnpmemoGetDetailInformation( $item_id );
	
	// get BasicInformation / Preview / IndexKeywords block
	$basic   = xnpGetBasicInformationPrinterFriendlyBlock( $item_id );
		// $preview = xnpGetPreviewPrinterFriendlyBlock( $item_id );
	$index   = xnpGetIndexPrinterFriendlyBlock( $item_id );
	$memo_file = xnpGetAttachmentPrinterFriendlyBlock( $item_id, 'memo_file' );
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'basic', $basic );
		// $tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'memo_file', $memo_file );
	$tpl->assign( 'detail', $item_detail );
	
	
	// return as HTML
	return $tpl->fetch( "db:xnpmemo_detail_block.html" );
}

function xnpmemoGetRegisterBlock(){
	global $xoopsDB;
	$myts =& MyTextSanitizer::getInstance();
	
	// get DetailInformation
	if ( isset( $_POST['item_link'] ) ){
		$detail = array(
			'item_link'     =>$myts->stripSlashesGPC($_POST['item_link'])
		);
	}
	else if ( !empty( $item_id ) ){
		$detail = xnpmemoGetDetailInformation( $item_id );
	}
	else
		$detail = array();
	
	// get BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationRegisterBlock();
		// $preview = xnpGetPreviewRegisterBlock();
	$index = xnpGetIndexRegisterBlock();
	$memo_file = xnpGetAttachmentRegisterBlock( 'memo_file' );
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'basic', $basic );
		// $tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'memo_file', $memo_file );
	$tpl->assign( 'detail', $detail );
	// return as HTML
	return $tpl->fetch( "db:xnpmemo_register_block.html" );
}

function xnpmemoGetEditBlock( $item_id ){
	global $xoopsDB;

	// get BasicInformation / Preview / index block
	$basic   = xnpGetBasicInformationEditBlock( $item_id );
		// $preview = xnpGetPreviewEditBlock( $item_id );
	$index = xnpGetIndexEditBlock( $item_id );
	$memo_file = xnpGetAttachmentEditBlock( $item_id, 'memo_file' );
	
	// get DetailInformation
	if ( isset( $_POST['item_link'] ) ){
		$myts =& MyTextSanitizer::getInstance();
		$detail = array(
			'item_link'     =>$myts->stripSlashesGPC($_POST['item_link'])
		);
	}
	else if ( !empty( $item_id ) ){
		$detail = xnpmemoGetDetailInformation( $item_id );
	}
	else
		$detail = array();
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'basic', $basic );
		// $tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'memo_file', $memo_file );
	$tpl->assign( 'detail', $detail );

	
	// return as HTML
	return $tpl->fetch( "db:xnpmemo_register_block.html" );
}

function xnpmemoGetConfirmBlock( $item_id ){
	// get BasicInformation / Preview / index block
	$basic   = xnpGetBasicInformationConfirmBlock( $item_id );
		// $preview = xnpGetPreviewConfirmBlock( $item_id );
	$index   = xnpGetIndexConfirmBlock( $item_id );
	$memo_file = xnpGetAttachmentConfirmBlock( $item_id, 'memo_file' );
	// get DetailInformation
	if ( isset( $_POST['item_link'] ) ){
		$myts =& MyTextSanitizer::getInstance();
/*
		$detail = array(
			'item_link'     =>$myts->stripSlashesGPC($_POST['item_link'     ])
		);
*/
		$detail = array(
			'item_link'     =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['item_link'     ]) )
		);
	}
	else if ( !empty( $item_id ) )
		$detail = xnpmemoGetDetailInformation( $item_id );
	else
		$detail = array();
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'basic', $basic );
		// $tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'memo_file', $memo_file );
	$tpl->assign( 'detail', $detail );
	// return as HTML
	return $tpl->fetch( "db:xnpmemo_confirm_block.html" );
}


/** check DetailInformation input
 * called from confirm/registered page
*/
function xnpmemoCheckRegisterParameters( &$message ){

	$messages = array();
	//if ( empty( $_POST['item_link'] ) )  $messages[] = "item_link required.";
	//if ( empty( $_POST['url_banner_fileFileID'  ]) && empty( $_FILES['url_banner_file']['name']) ) $messages[] = "banner file required.";
	if ( count($messages) == 0 )
		return true;
	$message = "<br>\n" . implode( "<br>\n", $messages );
	return false;

}


/** check DetailInformation input
 */
function xnpmemoCheckEditParameters( &$message ){
	return xnpmemoCheckRegisterParameters( $message );
}

function xnpmemoInsertItem(){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// register BasicInformation, Index, Attachment
	$item_id = 0;
	$result = xnpInsertBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'memo_file' );
				if ( $result ){
				}
		}
		if ( !$result )
			xnpDeleteBasicInformation( $xnpsid, $item_id );
	}
	if ( !$result )
		return false;
	
	$myts =& MyTextSanitizer::getInstance();
	$escval = $myts->addSlashes($_POST['item_link'     ]);
	
	// register DetailInformation
	$myts =& MyTextSanitizer::getInstance();
	$sql = "insert into " . $xoopsDB->prefix("xnpmemo_item_detail") . " ( memo_id, item_link ) values ( $item_id, '$escval' ) ";
	$result = $xoopsDB->queryF( $sql );
	if ( $result == false ){
		echo "cannot insert item_detail";
		return false;
	}
	
	return true;
}

function xnpmemoUpdateItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	$myts =& MyTextSanitizer::getInstance();
	
	// edit BasicInformation, Index, Preview, Attachment 
	$result = xnpUpdateBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'memo_file' );
				if ( $result ){
					$result = xnp_insert_change_log( $xnpsid, $item_id, $myts->stripSlashesGPC( $_POST['change_log'] ) );
					$result = !$result;
					if( !$result )
						echo " xnp_insert_change_log failed.";
				}
				else echo " xnpUpdateAttachment failed.";
		}
		else echo " xnpUpdateIndex failed.";
	}
	else echo " xnpUpdateBasicInformation failed.";
	if ( !$result )
		return false;
	
	// register DetailInformation
	$sql = implode( ',', array(
		'item_link'      ."='".$myts->addSlashes($_POST['item_link'     ])."'"
	) );
	$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnpmemo_item_detail") . " set $sql where memo_id = $item_id " );
	if ( $result == false )
		return false;
	
	return true;
}

function xnpmemoDeleteItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// delete BasicInformation, Index, Preview, Attachment 
	if( !xnpDeleteBasicInformation( $item_id ) ){
		echo "cannot delete memo item";
		return false;
	}
	
	// delete DetailInformation
	$sql = "delete from " . $xoopsDB->prefix("xnpmemo_item_detail")
		. " where memo_id=$item_id";
	$xoopsDB->queryF( $sql );
	return true;
}



function xnpmemoGetDetailInformationQuickSearchQuery(&$wheres, &$join, $keywords){
	global $xoopsDB;
	//$memo_table = $xoopsDB->prefix('xnpmemo_item_detail');
	//$file_table  = $xoopsDB->prefix('xoonips_file');
	
	$join = "";
	//$wheres = xnpGetKeywordsQueries( array("$memo_table.item_link", "$file_table.original_file_name"), $keywords );
	return true;
}



function xnpmemoGetAdvancedSearchQuery(&$where, &$join){
	global $xoopsDB;
	$memo_table = $xoopsDB->prefix('xnpmemo_item_detail');
	$file_table  = $xoopsDB->prefix('xoonips_file');
	
	$wheres = array();
	$w = xnpGetBasicInformationAdvancedSearchQuery('xnpmemo'); if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($memo_table.'.item_link', 'xnpmemo_item_link'); if( $w ) $wheres[] = $w;

	$where = implode( ' and ', $wheres );
	$join = "";
}

function xnpmemoGetAdvancedSearchBlock(&$search_var){
	// get BasicInformation / Preview / IndexKeywords block
	$basic   = xnpGetBasicInformationAdvancedSearchBlock('xnpmemo',$search_var);
	$search_var[] = 'xnpmemo_url'   ;
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'module_name', 'xnpmemo' );
	$tpl->assign( 'module_display_name', 'MEMO' ); // todo:get from DB
	
	// return as HTML
	return $tpl->fetch( "db:xnpmemo_search_block.html" );
}

function xnpmemoGetDetailInformationTotalSize($iids){
	return xnpGetTotalFileSize($iids);
}

/**
 * 
 * create XML for exporting detail information
 * 
 * @param fhdl file handle to output
 * @param item_id item_id of an item to export
 * @param attachment true if exporting attachment or image file
 * @return true:success, false:failure
 */
function xnpmemoExportItem($fhdl, $item_id, $attachment )
{
	global $xoopsDB;

    if( !$fhdl ) return false;

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpmemo_item_detail" )." where memo_id=$item_id" );
	if( !$result ) return false;
    $detail = $xoopsDB->fetchArray( $result );
	if( !fwrite( $fhdl, "<detail id=\"${item_id}\">\n"
        ."<item_link>".xnpHtmlspecialchars( $detail['item_link'], ENT_QUOTES )."</item_link>\n" ) ) return false;
    if( !( $attachment ? xnpExportFile( $fhdl, $item_id ) : true ) ) return false;
    if( !fwrite( $fhdl, "</detail>\n" ) ) return false;

    return true;
}

function xnpmemoGetImportHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnpmemoStartElement", "xnpmemoEndElement", "xnpmemoCharacterData" ) );
}

/**
 * bool xnpurlGetLicenseRequired( int item_id )
 * 
 * 
 */
/*
function xnpurlGetLicenseRequired( $item_id )
{
    return false;
}
*/

/**
 * string xnpurlGetLicenseStatement( int item_id )
 * 
 * 
 */
/*
function xnpurlGetLicenseStatement( $item_id )
{
    return ''
}
*/

function xnpmemoGetModifiedFields( $item_id )
{
    $ret = array();
    $detail = xnpmemoGetDetailInformation( $item_id );
    if( $detail ){
        $myts =& MyTextSanitizer::getInstance( );
        foreach( array( 'item_link' => _MD_XNPMEMO_ITEM_LINK_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) array_push( $ret, $v );
        }
        // was banner file modified?
        if( xnpIsAttachmentModified( 'memo_file', $item_id ) ){
            array_push( $ret, _MD_XNPMEMO_MEMO_FILE_LABEL );
        }
    }
    return $ret;
}

function xnpmemoGetTopBlock( $itemtype ){
	return xnpGetTopBlock( $itemtype['name'], $itemtype['display_name'], 'images/icon_memo.gif', _MD_XNPMEMO_EXPLANATION, false, false );
}

function xnpmemoSupportMetadataFormat( $metadataPrefix, $item_id )
{
    if( $metadataPrefix == 'oai_dc' || $metadataPrefix == 'junii' ) return true;
    return false;
}

function xnpmemoGetMetadata( $metadataPrefix, $item_id )
{
    $meta_basic = xnpGetBasicInformationMetadata( $metadataPrefix, $item_id );
    if( $meta_basic ){
		$basic = array();
		if( xnp_get_item( $_SESSION['XNPSID'], $item_id, $basic ) != RES_OK )
			return false;
		
		$lines = array();
		if( $metadataPrefix == 'junii' ){
            $lines[] = "<metadata>";
            $lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii.xsd">';
            $lines[] = $meta_basic;
//            $lines[] = "<type xsi:type=\"NII\">&#65279;&#21442;&#32771;&#24773;&#22577;</type>";
			$metadatajunii = xnpGetMetadataJunii(70);
            $lines[] = "<type xsi:type=\"NII\">".$metadatajunii."</type>";
            $lines[] = "</meta>";
            $lines[] = "</metadata>";
        }
		else if ( $metadataPrefix == 'oai_dc' ){
			$detail =xnpmemoGetDetailInformation($item_id);
			$lines[] = "<metadata>";
			$lines[] = '<oai_dc:dc 
                 xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/" 
                 xmlns:dc="http://purl.org/dc/elements/1.1/" 
                 xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
                 xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/ 
                 http://www.openarchives.org/OAI/2.0/oai_dc.xsd">';
			$lines[] = $meta_basic;
//			$lines[] = "<dc:identifier>".htmlspecialchars($detail['url'])."</dc:identifier>";
			$lines[] = "<dc:identifier>".xnpHtmlspecialchars($detail['item_link'])."</dc:identifier>";
			$lines[] = "</oai_dc:dc>";
			$lines[] = "</metadata>";
		}
		return implode( "\n", $lines )."\n";
    }
    return false;
}

function xnpmemoStartElement($parser, $name, $attribs, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $parser_hash['detail'] = array();
        break;
    case "/ITEM/DETAIL/ITEM_LINK":
        $parser_hash['detail'][end($parser_hash['tagstack'])] = '';
        break;
    }
}
function xnpmemoEndElement($parser, $name, &$parser_hash)
{
	global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    $myts =& MyTextSanitizer::getInstance( );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $keys = implode( ",", array( 'item_link' ) );
        $vals = implode( "','", array( addslashes( encodeClient2Server( $parser_hash['detail']['ITEM_LINK'] ) ) ) );
        
        // register DetailInformation
        $myts =& MyTextSanitizer::getInstance( );
        $sql = "insert into ".$xoopsDB->prefix( "xnpmemo_item_detail" )." ( memo_id, $keys ) values ( ".$parser_hash['id_table'][$parser_hash['basic']['ID']].", '$vals' ) ";
        $result = $xoopsDB->queryF( $sql );
        if( $result == false ) {
            echo "cannot insert item_detail\n";
            return false;
        }
        break;
    }
}

function xnpmemoCharacterData($parser, $data, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/DETAIL/ITEM_LINK": 
        if( !array_key_exists( end($parser_hash['tagstack']), $parser_hash['detail'] ) ){
            $parser_hash['detail'][end($parser_hash['tagstack'])] = $data;
        }else{
            $parser_hash['detail'][end($parser_hash['tagstack'])] .= $data;
        }
        break; 
    } 
}

?>
