<?php
//  $Revision: 1.36.2.3 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

global $xoopsConfig;
if ( file_exists( XOOPS_ROOT_PATH.'/modules/xnppresentation/language/' . $xoopsConfig['language'] . '/main.php') ){
	include_once( XOOPS_ROOT_PATH.'/modules/xnppresentation/language/' . $xoopsConfig['language'] . '/main.php' );
}
else {
	include_once( XOOPS_ROOT_PATH.'/modules/xnppresentation/language/english/main.php' );
}

function xnppresentationGetTypes(){
	return array( 'powerpoint'=>'PowerPoint', 'lotus'=>'Lotus', 'justsystem'=>'JustSystem', 'html'=>'HTML', 'pdf'=>'PDF', 'other'=>'Other' );
}

/** retrieve Detail Information that specified by item_id
  * 
  */
function xnppresentationGetDetailInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'presentation_type'       =>'',
			'creator'         =>'',
			'attachment_dl_limit'         =>'',
			'rights' => '',
			'readme' => '',
			'use_cc' => '',
			'cc_commercial_use' => '',
			'cc_modification' => ''
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnppresentation_item_detail") . " where presentation_id=$item_id";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$types = xnppresentationGetTypes();
	$detail = $xoopsDB->fetchArray($result);
	$detail['presentation_type_str'] = $types[$detail['presentation_type']];
	return $detail;
}

function xnppresentationGetMetaInformation( $item_id ){
	$ret = array();
	$basic = xnpGetBasicInformationArray($item_id);
	$detail = xnppresentationGetDetailInformation( $item_id );
	if ( !empty( $basic ) ){
		$ret[_MD_XOONIPS_ITEM_TITLE_LABEL] = $basic['title'];
		$ret[_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL] = $basic['contributor'];
		$ret[_MD_XOONIPS_ITEM_KEYWORDS_LABEL] = $basic['keywords'];
		$ret[_MD_XOONIPS_ITEM_DESCRIPTION_LABEL] = $basic['description'];
		$ret[_MD_XOONIPS_ITEM_DOI_LABEL] = $basic['doi'];
		$ret[_MD_XOONIPS_ITEM_CREATION_DATE_LABEL] = $basic['creation_date'];
		$ret[_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL] = $basic['last_update_date'];
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XNPPRESENTATION_PRESENTATION_TYPE_LABEL ] = $detail['presentation_type_str'];
		$ret[_MD_XNPPRESENTATION_CREATOR_LABEL           ] = $detail['creator'          ];
	}
	if ( !empty( $basic ) ){
		$publication_gmt = mktime(0,0,0,$basic['publication_month'],$basic['publication_mday'],$basic['publication_year']);
		$ret[_MD_XNPPRESENTATION_DATE_LABEL              ] = date( DATE_FORMAT, $publication_gmt );
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XOONIPS_ITEM_README_LABEL      ] = $detail['readme' ];
		$ret[_MD_XOONIPS_ITEM_RIGHTS_LABEL     ] = $detail['rights'];
	}
	return $ret;
}

function xnppresentationGetListBlock( $item_basic ){
	$item_id = $item_basic['item_id'];
	
	// retrieve detail information
	$item_detail = xnppresentationGetDetailInformation( $item_id );
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to tpl
	
	$tpl->assign( 'item_basic', $item_basic );
	$tpl->assign( 'item_detail', $item_detail );
	if( xnpIsPending( $item_basic['item_id'] ) ) $tpl->assign( 'pending', 'true' );
	
	// return HTML content
	//return $tpl->fetch( XOOPS_ROOT_PATH . "/modules/xnppresentation/templates/xnppresentation_list_block.html" );
	return $tpl->fetch( "db:xnppresentation_list_block.html" );
}

function xnppresentationGetPrinterFriendlyListBlock( $item_basic ){
	return xnppresentationGetListBlock( $item_basic );
}


function xnppresentationGetDetailBlock( $item_id ){
	
	// retrieve detail information
	$item_detail = xnppresentationGetDetailInformation( $item_id );
	
	// retrieve blocks of BasicInformation / Preview / IndexKeywords
	$basic   = xnpGetBasicInformationDetailBlock( $item_id );
	$preview = xnpGetPreviewDetailBlock( $item_id );
	$index   = xnpGetIndexDetailBlock( $item_id );
	$presentation_file = xnpGetAttachmentDetailBlock( $item_id, 'presentation_file' );
	$readme  = xnpGetTextFileDetailBlock( $item_id, 'readme' , $item_detail['readme' ] );
	$rights = xnpGetRightsDetailBlock( $item_id, $item_detail['use_cc'], $item_detail['rights'], $item_detail['cc_commercial_use'], $item_detail['cc_modification'] );
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to tpl
	
	$tpl->assign( 'editable', xnp_get_item_permission( $_SESSION['XNPSID'], $item_id, OP_MODIFY ) );
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'presentation_file', $presentation_file );
	$tpl->assign( 'detail', $item_detail );
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'rights', $rights );
	
	
	// return HTML content
	return $tpl->fetch( "db:xnppresentation_detail_block.html" );
}

// todo
function xnppresentationGetPrinterFriendlyDetailBlock( $item_id )
{
	$myts =& MyTextsanitizer::getInstance();

	// retrieve detail information
	$item_detail = xnppresentationGetDetailInformation( $item_id );
	
	// retrieve blocks of BasicInformation / Preview / IndexKeywords
	$basic   = xnpGetBasicInformationDetailBlock( $item_id );
	$preview = xnpGetPreviewPrinterFriendlyBlock( $item_id );
	$index   = xnpGetIndexPrinterFriendlyBlock( $item_id );
	$presentation_file = xnpGetAttachmentPrinterFriendlyBlock( $item_id, 'presentation_file' );
	$readme  = xnpGetTextFilePrinterFriendlyBlock( $item_id, 'readme',  $item_detail['readme']  );
	$rights = xnpGetRightsPrinterFriendlyBlock( $item_id, $item_detail['use_cc'], $item_detail['rights'] );
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to tpl
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'presentation_file', $presentation_file );
	$tpl->assign( 'detail', $item_detail );
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'rights', $rights );
	
	
	// return HTML content
	return $tpl->fetch( "db:xnppresentation_detail_block.html" );
}

function xnppresentationGetRegisterBlock(){
	global $xoopsDB;
	$myts =& MyTextSanitizer::getInstance();
	
	// retrieve detail information
	if ( isset( $_POST['presentation_type'] ) ){
		$detail = array(
			'presentation_type'     =>$myts->stripSlashesGPC($_POST['presentation_type'     ]),
			'creator'  =>$myts->stripSlashesGPC($_POST['creator'  ])
		);
	}
	else
		$detail = array( 'presentation_type' => 'other' );
	
	// retrieve blocks of BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationRegisterBlock();
	$preview = xnpGetPreviewRegisterBlock();
	$index = xnpGetIndexRegisterBlock();
	$presentation_file = xnpGetAttachmentRegisterBlock( 'presentation_file' );
	$readme  = xnpGetTextFileRegisterBlock( 'readme'  );
	$rights = xnpGetRightsRegisterBlock();
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to tpl
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'presentation_file', $presentation_file );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionRegisterBlock( 'xnppresentation' ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'rights', $rights );
	$tpl->assign( 'presentation_type', xnppresentationGetTypes() );
	$tpl->assign( 'presentation_type_selected', $detail['presentation_type'] );
	// return HTML content
	return $tpl->fetch( "db:xnppresentation_register_block.html" );
}

function xnppresentationGetEditBlock( $item_id ){
	global $xoopsDB;

	// retrieve blocks of BasicInformation / Preview / index block
	$basic   = xnpGetBasicInformationEditBlock( $item_id );
	$preview = xnpGetPreviewEditBlock( $item_id );
	$index = xnpGetIndexEditBlock( $item_id );
	$presentation_file = xnpGetAttachmentEditBlock( $item_id, 'presentation_file' );
	
	// retrieve detail information
	if ( isset( $_POST['presentation_type'] ) ){
		$myts =& MyTextSanitizer::getInstance();
		$detail = array(
			'presentation_type'     =>$myts->stripSlashesGPC($_POST['presentation_type'     ]),
			'creator'  =>$myts->stripSlashesGPC($_POST['creator'  ]),
			'readme'  => '',
			'rights' => '',
			'use_cc'  => '',
			'cc_commercial_use' => '',
			'cc_modification'  => ''
		);
	}
	else if ( !empty( $item_id ) ){
		$detail = xnppresentationGetDetailInformation( $item_id );
	}
	else
		$detail = array();
	$readme  = xnpGetTextFileEditBlock( $item_id, 'readme' , isset( $detail['readme' ] ) ? $detail['readme' ] : '' );
	$rights = xnpGetRightsEditBlock( $item_id, $detail['use_cc'], $detail['rights'], $detail['cc_commercial_use'], $detail['cc_modification'] );
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'presentation_file', $presentation_file );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionEditBlock( 'xnppresentation', xnppresentationGetAttachmentDownloadLimitOption( $item_id ) ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'rights', $rights );
	$tpl->assign( 'presentation_type', xnppresentationGetTypes() );
	$tpl->assign( 'presentation_type_selected', $detail['presentation_type'] );

	
	// return HTML content
	return $tpl->fetch( "db:xnppresentation_register_block.html" );
}


function xnppresentationGetConfirmBlock( $item_id ){
	// retrieve blocks of BasicInformation / Preview / index block
	$basic   = xnpGetBasicInformationConfirmBlock( $item_id );
	$preview = xnpGetPreviewConfirmBlock( $item_id );
	$index   = xnpGetIndexConfirmBlock( $item_id );
	$presentation_file = xnpGetAttachmentConfirmBlock( $item_id, 'presentation_file' );
	$readme  = xnpGetTextFileConfirmBlock( $item_id, 'readme' );
	$rights = xnpGetRightsConfirmBlock( $item_id );
	// retrieve detail information
	if ( isset( $_POST['creator'] ) ){
		$myts =& MyTextSanitizer::getInstance();
/*
		$detail = array(
			'presentation_type'     =>$myts->stripSlashesGPC($_POST['presentation_type'     ]),
			'creator'  =>$myts->stripSlashesGPC($_POST['creator'  ])
		);
*/
		$detail = array(
			'presentation_type'     =>$myts->stripSlashesGPC($_POST['presentation_type'     ]),
			'creator'  =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['creator'  ]) )
		);
		$types = xnppresentationGetTypes();
		$detail['presentation_type_str'] = $types[$detail['presentation_type']];
	}
	else if ( !empty( $item_id ) )
		$detail = xnppresentationGetDetailInformation( $item_id );
	else
		$detail = array();
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to tpl
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'presentation_file', $presentation_file );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionConfirmBlock( 'xnppresentation' ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'rights', $rights );
	// return HTML content
	return $tpl->fetch( "db:xnppresentation_confirm_block.html" );
}

/** make sure that enterd detail information is correctly or not.
 * called from register confirmation and edit confirmation
 */
function xnppresentationCheckRegisterParameters( &$message ){
	$xnpsid = $_SESSION['XNPSID'];
	$messages = array();
	if ( empty( $_POST['creator'] ) ) $messages[] = _MD_XNPPRESENTATION_CREATOR_REQUIRED;
	if ( empty( $_POST['presentation_fileFileID'  ]) && empty( $_FILES['presentation_file']['name']) ) $messages[] = _MD_XNPPRESENTATION_PRESENTATION_FILE_REQUIRED;
	
	// notify that license statement is required when register into public indexes.
	$xids = explode( ',', $_POST['xoonipsCheckedXID'] );
	$indexes = array( );
	if( $xids[0] != $_POST['xoonipsCheckedXID'] ) {
		foreach( $xids as $i ) {
			$index = array( );
			if( xnp_get_index( $xnpsid, $i, $index ) == RES_OK ) {
				$indexes[] = $index;
			} else {
				$messages[] = "<font color='#ff0000'>".xnp_get_last_error_string( )."</font>";
				$result = false;
				break;
			}
		}
	}
	if( count( $indexes ) > 0 ) {
		foreach( $indexes as $i ) {
			if( $i['open_level'] <= OL_GROUP_ONLY ) {
				if( $_POST['readmeEncText'] == '' ) {
					//readme is not filled
					$messages[] = "<font color='#ff0000'>"._MD_XNPPRESENTATION_README_REQUIRED."</font>";
				}
				if( $_POST['rightsEncText'] == '' && $_POST['rightsUseCC'] == '0' ) {
					//license is not filled
					$messages[] = "<font color='#ff0000'>"._MD_XNPPRESENTATION_RIGHTS_REQUIRED."</font>";
				}
				break;
			}
		}
	}
	
	if ( count($messages) == 0 )
		return true;
	$message = "<br>\n" . implode( "<br>\n", $messages );
	return false;
}

/** make sure that enterd detail information is correctly or not.
 */
function xnppresentationCheckEditParameters( &$message ){
	return xnppresentationCheckRegisterParameters( $message );
}

function xnppresentationInsertItem(){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// retister BasicInformation, Index and Attachment
	$item_id = 0;
	$result = xnpInsertBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'presentation_file' );
				if ( $result ){
				}
			}
		}
		if ( !$result )
			xnpDeleteBasicInformation( $xnpsid, $item_id );
	}
	if ( !$result )
		return false;
	
	// register detail information
	list( $rights, $use_cc, $cc_commercial_use, $cc_modification ) = xnpGetRights();
	$myts =& MyTextSanitizer::getInstance();
	$keys = implode( ",", array(
		'presentation_type'     ,
		'creator',
		'attachment_dl_limit',
		'readme',
		'rights', 'use_cc', 'cc_commercial_use', 'cc_modification'
	) );
	$vals = implode( "','", array(
		$myts->addSlashes($_POST['presentation_type'     ]),
		$myts->addSlashes($_POST['creator'       ]),
		$myts->addSlashes($_POST['attachment_dl_limit'       ]),
		$myts->addSlashes(xnpGetTextFile( 'readme'  )),
		addslashes($rights),
		$use_cc, $cc_commercial_use, $cc_modification
	) );
	
	$sql = "insert into " . $xoopsDB->prefix("xnppresentation_item_detail") . " ( presentation_id, $keys ) values ( $item_id, '$vals' ) ";
	$result = $xoopsDB->queryF( $sql );
	if ( $result == false ){
		echo "cannot insert item_detail";
		return false;
	}
	
	return true;
}

function xnppresentationUpdateItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	$myts =& MyTextSanitizer::getInstance();
	
	// modify BasicInformation, Index, Preview and Attachment.
	$result = xnpUpdateBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'presentation_file' );
				if ( $result ){
					$result = xnp_insert_change_log( $xnpsid, $item_id, $myts->stripSlashesGPC( $_POST['change_log'] ) );
					$result = !$result;
					if( !$result )
						echo " xnp_insert_change_log failed.";
				}
				else echo " xnpUpdateAttachment failed.";
			}
			else echo " xnpUpdatePreview failed.";
		}
		else echo " xnpUpdateIndex failed.";
	}
	else echo " xnpUpdateBasicInformation failed.";
	if ( !$result )
		return false;
	
	// register detail information
	list( $rights, $use_cc, $cc_commercial_use, $cc_modification ) = xnpGetRights();
	$sql = implode( ',', array(
		'presentation_type'  ."='".$myts->addSlashes($_POST['presentation_type'     ])."'",
		'creator'            ."='".$myts->addSlashes($_POST['creator'       ])."'",
		'attachment_dl_limit'."='".$myts->addSlashes($_POST['attachment_dl_limit'       ])."'",
		'readme'             ."='".$myts->addSlashes(xnpGetTextFile( 'readme' ))."'",
		'rights'            ."='".addslashes( $rights )."'",
		'use_cc'             ."='".$use_cc           ."'",
		'cc_commercial_use'  ."='".$cc_commercial_use."'",
		'cc_modification'   ."='".$cc_modification ."'"
	) );
	$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnppresentation_item_detail") . " set $sql where presentation_id = $item_id " );
	if ( $result == false )
		return false;
	
	return true;
}

function xnppresentationDeleteItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// remove BasicInformation, Index, Preview and Attachment.
	if( !xnpDeleteBasicInformation( $item_id ) ){
		echo "cannot delete model item";
		return false;
	}
	
	// remove detail information
	$sql = "delete from " . $xoopsDB->prefix("xnppresentation_item_detail")
		. " where presentation_id=$item_id";
	$xoopsDB->queryF( $sql );
	return true;
}




function xnppresentationGetDetailInformationQuickSearchQuery(&$wheres, &$join, $keywords){
	global $xoopsDB;
	$presentation_table = $xoopsDB->prefix('xnppresentation_item_detail');
	$file_table  = $xoopsDB->prefix('xoonips_file');
	
	$join = "";
	$wheres = xnpGetKeywordsQueries( array("$presentation_table.creator","$file_table.caption"), $keywords );
	return true;
}



function xnppresentationGetAdvancedSearchQuery(&$where, &$join){
	global $xoopsDB;
	$basic_table = $xoopsDB->prefix('xoonips_item_basic');
	$presentation_table = $xoopsDB->prefix('xnppresentation_item_detail');
	$file_table  = $xoopsDB->prefix('xoonips_file');
	
	$wheres = array();
	$joins = array();

	$w  = xnpGetBasicInformationAdvancedSearchQuery('xnppresentation'); if ( $w ) $wheres[] = $w;
	if ( !empty($_POST['xnppresentation_presentation_type']) ){
		$myts =& MyTextSanitizer::getInstance();
		$wheres[] = $presentation_table.'.presentation_type = \'' . $myts->addSlashes($_POST['xnppresentation_presentation_type']) . "'";
	}
	$w = xnpGetKeywordQuery($presentation_table.'.creator', 'xnppresentation_creator' ); if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($file_table. '.caption' ,'xnppresentation_caption');
	if ( $w ){
		$wheres[] = $w;
		$wheres[] = " $file_table.file_type_id = 1";
	}

	$where = implode( ' and ', $wheres );
	$join = ''; 
}

function xnppresentationGetAdvancedSearchBlock(&$search_var){
	// retrieve blocks of BasicInformation / Preview / IndexKeywords
	$basic   = xnpGetBasicInformationAdvancedSearchBlock('xnppresentation',$search_var);
	$search_var[] = 'xnppresentation_presentation_type';
	$search_var[] = 'xnppresentation_creator'          ;
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to tpl
	

	$tpl->assign( 'presentation_type', array_merge( array(''=>'Any'), xnppresentationGetTypes()) );
	$tpl->assign( 'presentation_type_selected', 'none' );
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'module_name', 'xnppresentation' );
	$tpl->assign( 'module_display_name', 'Presentation' ); // todo:retrieve from DB
	
	// return HTML content
	return $tpl->fetch( "db:xnppresentation_search_block.html" );
}

function xnppresentationGetDetailInformationTotalSize($iids){
	return xnpGetTotalFileSize($iids);
}


function xnppresentationGetLicenseRequired( $item_id )
{
	global $xoopsDB;

	// retrieve detail information
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnppresentation_item_detail" )." where presentation_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    return isset( $detail['rights'] ) && $detail['rights'] != '';
}

function xnppresentationGetLicenseStatement( $item_id )
{
	global $xoopsDB;

	// retrieve detail information
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnppresentation_item_detail" )." where presentation_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    return array( isset( $detail['rights'] ) ? $detail['rights'] : '', $detail['use_cc'] );;
}

/**
 * 
 * generate XML of detail information for exporting.
 * 
 * @param fhdl file handle to write results
 * @param item_id item id that is exported
 * @param attachment true if exporting with attachments and images
 * @return true:succeed, false:failed
 */
function xnppresentationExportItem($fhdl, $item_id, $attachment )
{
	global $xoopsDB;

    if( !$fhdl ) return false;

	// retrieve detail information
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnppresentation_item_detail" )." where presentation_id=$item_id" );
	if( !$result ) return false;
    $detail = $xoopsDB->fetchArray( $result );
	if( !fwrite( $fhdl, "<detail id=\"${item_id}\">\n"
        ."<presentation_type>".xnpHtmlspecialchars( $detail['presentation_type'], ENT_QUOTES )."</presentation_type>\n"
        ."<creator>".xnpHtmlspecialchars( $detail['creator'], ENT_QUOTES )."</creator>\n"
        ."<readme>".xnpHtmlspecialchars( $detail['readme'], ENT_QUOTES )."</readme>\n"
        ."<rights>".xnpHtmlspecialchars( $detail['rights'], ENT_QUOTES )."</rights>\n"
        ."<use_cc>"           .$detail['use_cc']           ."</use_cc>\n"
        ."<cc_commercial_use>".$detail['cc_commercial_use']."</cc_commercial_use>\n"
        ."<cc_modification>"  .$detail['cc_modification']  ."</cc_modification>\n"
         ) ) return false;
    if( !( $attachment ? xnpExportFile( $fhdl, $item_id ) : true ) ) return false;
    if( !fwrite( $fhdl, "</detail>\n" ) ) return false;

    return true;
}

function xnppresentationStartElement($parser, $name, $attribs, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $parser_hash['detail'] = array();
        break;
    case "/ITEM/DETAIL/PRESENTATION_TYPE":
    case "/ITEM/DETAIL/CREATOR": 
    case "/ITEM/DETAIL/README": 
    case "/ITEM/DETAIL/RIGHTS": 
    case "/ITEM/DETAIL/USE_CC": 
    case "/ITEM/DETAIL/CC_COMMERCIAL_USE": 
    case "/ITEM/DETAIL/CC_MODIFICATION": 
        $parser_hash['detail'][end($parser_hash['tagstack'])] = '';
        break;
    }
//    echo("<b><font color=\"#0000ff\">&lt$name&gt</font></b><br>"); 
}
function xnppresentationEndElement($parser, $name, &$parser_hash)
{
	global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    $myts =& MyTextSanitizer::getInstance( );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
//        print_r( $parser_hash['detail'] );
        $keys = implode( ",", array( 'presentation_type', 'creator', 'readme', 'rights', 'use_cc', 'cc_commercial_use', 'cc_modification' ) );
        $vals = implode( "','", array( $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['PRESENTATION_TYPE'] ) ),
                                       $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['CREATOR'] ) ),
                                       addslashes( encodeClient2Server( $parser_hash['detail']['README'] ) ),
                                       addslashes( encodeClient2Server( $parser_hash['detail']['RIGHTS'] ) ),
                                       (int)$parser_hash['detail']['USE_CC'],
                                       (int)$parser_hash['detail']['CC_COMMERCIAL_USE'],
                                       (int)$parser_hash['detail']['CC_MODIFICATION'],
            ) );
        
        // register detail information
        $myts =& MyTextSanitizer::getInstance( );
        $sql = "insert into ".$xoopsDB->prefix( "xnppresentation_item_detail" )." ( presentation_id, $keys ) values ( ".$parser_hash['id_table'][$parser_hash['basic']['ID']].", '$vals' ) ";
        $result = $xoopsDB->queryF( $sql );
        if( $result == false ) {
            echo "cannot insert item_detail\n";
            return false;
        }
        break;
    }
//    echo("<br><b><font color=\"#0000ff\">&lt/$name&gt</font></b><br><br>"); 
}

function xnppresentationCharacterData($parser, $data, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/DETAIL/PRESENTATION_TYPE":
    case "/ITEM/DETAIL/CREATOR": 
    case "/ITEM/DETAIL/RIGHTS": 
    case "/ITEM/DETAIL/README": 
    case "/ITEM/DETAIL/USE_CC": 
    case "/ITEM/DETAIL/CC_COMMERCIAL_USE": 
    case "/ITEM/DETAIL/CC_MODIFICATION": 
        if( !array_key_exists( end($parser_hash['tagstack']), $parser_hash['detail'] ) ){
            $parser_hash['detail'][end($parser_hash['tagstack'])] = $data;
        }else{
            $parser_hash['detail'][end($parser_hash['tagstack'])] .= $data;
        }
        break; 
    } 
//    echo($data); 
}

function xnppresentationGetImportHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnppresentationStartElement", "xnppresentationEndElement", "xnppresentationCharacterData" ) );
}

function xnppresentationGetModifiedFields( $item_id )
{
    $ret = array();
    $basic = xnpGetBasicInformationArray($item_id);
    if( $basic ){
        if( mktime(0,0,0,$basic['publication_month'],$basic['publication_mday'],$basic['publication_year'] )
            != mktime(0,0,0,$_POST['publicationDateMonth'],$_POST['publicationDateDay'],$_POST['publicationDateYear']) )
            array_push( $ret, _MD_XNPPRESENTATION_DATE_LABEL );
    }
    $detail = xnppresentationGetDetailInformation( $item_id );
    if( $detail ){
        $myts =& MyTextSanitizer::getInstance( );
        foreach( array( 'presentation_type' => _MD_XNPPRESENTATION_PRESENTATION_TYPE_LABEL,
                        'creator' => _MD_XNPPRESENTATION_CREATOR_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) array_push( $ret, $v );
        }
        foreach( array( 'readme' => _MD_XOONIPS_ITEM_README_LABEL,
                        'rights' => _MD_XOONIPS_ITEM_RIGHTS_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( "${k}EncText", $_POST ) ) continue;
            if( urldecode($_POST[ "${k}EncText" ]) != $detail[ $k ] ) array_push( $ret, $v );
        }
        
        // is modified data files ?
        if( xnpIsAttachmentModified( 'presentation_file', $item_id ) ){
            array_push( $ret, _MD_XNPPRESENTATION_PRESENTATION_FILE_LABEL );
        }
    }
    return $ret;
}

function xnppresentationGetTopBlock( $itemtype ){
	return xnpGetTopBlock( $itemtype['name'], $itemtype['display_name'], 'images/icon_presentation.gif', _MD_XNPPRESENTATION_EXPLANATION, 'xnppresentation_presentation_type', xnppresentationGetTypes() );
}

//return 1 if downloadable for login user only
//return 0 if downloadable for everyone
function xnppresentationGetAttachmentDownloadLimitOption( $item_id )
{
	global $xoopsDB;
    $sql = "select attachment_dl_limit from ".$xoopsDB->prefix( "xnppresentation_item_detail" )." where presentation_id=${item_id}";
    $result = $xoopsDB->query( $sql );
    if( $result ){
        list( $option ) = $xoopsDB->fetchRow( $result );
        return $option;
    }
    return 0;
}

function xnppresentationSupportMetadataFormat( $metadataPrefix, $item_id )
{
    if( $metadataPrefix == 'oai_dc' || $metadataPrefix == 'junii' ) return true;
    return false;
}

function xnppresentationGetMetadata( $metadataPrefix, $item_id )
{
    $meta_basic = xnpGetBasicInformationMetadata( $metadataPrefix, $item_id );
    if( $meta_basic ){
		$basic = array();
		if( xnp_get_item( $_SESSION['XNPSID'], $item_id, $basic ) != RES_OK )
			return false;
		
        $detail = xnppresentationGetDetailInformation( $item_id );
		$lines = array();
		if( $metadataPrefix == 'junii' ){
            $lines[] = "<metadata>";
            $lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii.xsd">';
            $lines[] = $meta_basic;
//            $lines[] = "<type xsi:type=\"NII\">&#65279;&#30740;&#31350;&#36039;&#28304;&#8722;&#35542;&#25991;&#20197;&#22806;</type>";
            $lines[] = "<type xsi:type=\"NII\">".xnpGetMetadataJunii(2)."</type>";
//            $lines[] = "<type>presentationType:".htmlspecialchars($detail['presentation_type'])."</type>";
            $lines[] = "<type>presentationType:".xnpHtmlspecialchars($detail['presentation_type'])."</type>";
//            $lines[] = "<creator>".htmlspecialchars($detail['creator'])."</creator>";
            $lines[] = "<creator>".xnpHtmlspecialchars($detail['creator'])."</creator>";
            $lines[] = "<date xsi:type=\"ISO8601\">"
                .date( "Y-m-d", mktime( 0, 0, 0,
                                        $basic['publication_month'],
                                        $basic['publication_mday'],
                                        $basic['publication_year'] ) )
                ."</date>";
//            $lines[] = "<description>readme:".htmlspecialchars($detail['readme'])."</description>";
            $lines[] = "<description>readme:".xnpHtmlspecialchars($detail['readme'])."</description>";
//            $lines[] = "<description>rights:".htmlspecialchars($detail['rights'])."</description>";
            $lines[] = "<description>rights:".xnpHtmlspecialchars($detail['rights'])."</description>";
            $lines[] = "</meta>";
            $lines[] = "</metadata>";
        }
		else if ( $metadataPrefix == 'oai_dc' ) {
			$lines = array();
			$lines[] = "<metadata>";
			$lines[] = '<oai_dc:dc 
               xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/" 
               xmlns:dc="http://purl.org/dc/elements/1.1/" 
               xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
               xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/ 
               http://www.openarchives.org/OAI/2.0/oai_dc.xsd">';
			$lines[] = $meta_basic;
//			$lines[] = "<dc:type>presentationType:".htmlspecialchars($detail['presentation_type'])."</dc:type>";
			$lines[] = "<dc:type>presentationType:".xnpHtmlspecialchars($detail['presentation_type'])."</dc:type>";
//			$lines[] = "<dc:creator>".htmlspecialchars($detail['creator'])."</dc:creator>";
			$lines[] = "<dc:creator>".xnpHtmlspecialchars($detail['creator'])."</dc:creator>";
			$lines[] = "<dc:date>"
			    .date( "Y-m-d", mktime( 0, 0, 0,
			                            $basic['publication_month'],
			                            $basic['publication_mday'],
			                            $basic['publication_year'] ) )
			    ."</dc:date>";
//			$lines[] = "<dc:rights>".htmlspecialchars($detail['rights'])."</dc:rights>";
			$lines[] = "<dc:rights>".xnpHtmlspecialchars($detail['rights'])."</dc:rights>";
//			$lines[] = "<dc:description>readme:".htmlspecialchars($detail['readme'])."</dc:description>";
			$lines[] = "<dc:description>readme:".xnpHtmlspecialchars($detail['readme'])."</dc:description>";
			$lines[] = "</oai_dc:dc>";
			$lines[] = "</metadata>";
		}
		return implode( "\n", $lines )."\n";
    }
    return false;
}
?>
