<?php
//  Install script for presentation module                                      //
//  $Revision: 1.9.2.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

function xoops_module_install_xnppresentation( $xoopsMod ) {
	global $xoopsDB;
	
	// register itemtype
	$table = $xoopsDB->prefix('xoonips_item_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "INSERT INTO $table ( name, display_name, mid, viewphp ) VALUES ( 'xnppresentation', 'Presentation', $mid, 'xnppresentation/include/view.php' )";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot register itemtype
		return false;
	}
	
	// register filetype
	$table = $xoopsDB->prefix('xoonips_file_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "INSERT INTO $table ( name, display_name, mid ) VALUES ( 'presentation_file', 'Presentation File', $mid )";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot register itemtype
		return false;
	}

	// Delete 'Module Access Rights' from all groups
	// This allows to remove redundant module name in Main Menu
	$member_handler =& xoops_gethandler('member');
	$gperm_handler =& xoops_gethandler('groupperm');
	$groups =& $member_handler->getGroupList();
	foreach ($groups as $groupid2 => $groupname) {
		if ($gperm_handler->checkRight('module_read', $mid, $groupid2)) {
			$criteria = new CriteriaCompo();
			$criteria->add( new Criteria( 'gperm_groupid', $groupid2 ) );
			$criteria->add( new Criteria( 'gperm_itemid', $mid ) );
			$criteria->add( new Criteria( 'gperm_name', 'module_read' ) );
			
			$objects = $gperm_handler->getObjects($criteria);
			if ( count( $objects ) == 1 ){
				$gperm_handler->delete( $objects[0] );
			}
		}
	}
	
	//$item_type_id = $xoopsDB->getInsertId();
	return true;
} 

function xoops_module_uninstall_xnppresentation( $xoopsMod ) {
	global $xoopsDB;
	
	$item_type_id = -1;
	$table = $xoopsDB->prefix('xoonips_item_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "SELECT item_type_id FROM $table where mid = $mid";
	$result = $xoopsDB->query($sql);
	if ( $result ){
		list($item_type_id) = $xoopsDB->fetchRow($result);
	}else{
		echo mysql_error();
		echo $sql;
		return false;
	}
	
	//make item_status.is_deleted to be Deleted
	$table = $xoopsDB->prefix('xoonips_item_basic');
	$sql = "SELECT item_id from ${table} WHERE item_type_id = $item_type_id";
	$result = $xoopsDB->query($sql);
	if ( !$result ){
		echo mysql_error();
		echo $sql;
		return false;
	}
	$ids = array( );
	while( list( $item_id ) = $xoopsDB->fetchRow($result) ){
		$ids[] = $item_id;
	}
	if( count( $ids ) > 0 ){
		$table = $xoopsDB->prefix('xoonips_item_status');
		$sql = "UPDATE ${table} SET deleted_timestamp=UNIX_TIMESTAMP(NOW()), is_deleted=1 WHERE item_id in ( ".implode( ",", $ids ).")";
		if ( $xoopsDB->query($sql) == FALSE ){
			echo mysql_error();
			echo $sql;
			return false;
		}
	}
	
	// remove basic information
	$table = $xoopsDB->prefix('xoonips_item_basic');
	$sql = "DELETE FROM $table where item_type_id = $item_type_id";
	if ( $xoopsDB->query($sql) == FALSE ){
		echo mysql_error();
		echo $sql;
		return false;
	}

	// unregister itemtype
	$table = $xoopsDB->prefix('xoonips_item_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "DELETE FROM $table where mid = $mid";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot unregister itemtype
		return false;
	}
	$table = $xoopsDB->prefix('xoonips_file_type');
	$sql = "DELETE FROM $table where mid = $mid";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot unregister filetype
		return false;
	}
	return true;
}

function xoops_module_update_xnppresentation ( $xoopsMod, $oldversion) {
	global $xoopsDB;
	$table = $xoopsDB->prefix("xnppresentation_item_detail");

	switch ($oldversion) { //remember that version is multiplied with 100 to get an integer
	case 100: //perform actions to upgrade from version 1.00
		$sql = "ALTER TABLE $table ADD attachment_dl_limit int(1) unsigned default 0";
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: " . $xoopsDB->error();
			return false;
		}
	case 101:
		$result1 = $xoopsDB->query("alter table $table add column use_cc            tinyint(3) not null");
		$result2 = $xoopsDB->query("alter table $table add column cc_commercial_use tinyint(3)");
		$result3 = $xoopsDB->query("alter table $table add column cc_modification   tinyint(3)");
		$result4 = $xoopsDB->query("alter table $table drop column license");
		if ( $result1 == false || $result2 == false || $result3 == false || $result4 == false ){
			echo "ERROR: " . $xoopsDB->error();
			return false;
		}
	case 102:
		$xoopsDB->query("alter table $table change column cc_modifications cc_modification tinyint(3)");
	case 103:
		$xoopsDB->query("alter table $table change column license rights text");
		
	default:
		return true;
	}
	return true;
}
?>
