<?php
//  $Revision: 1.1.2.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

global $xoopsConfig;
if( file_exists( XOOPS_ROOT_PATH.'/modules/xnpstimulus/language/'.$xoopsConfig['language'].'/main.php' ) ) {
	include_once( XOOPS_ROOT_PATH.'/modules/xnpstimulus/language/'.$xoopsConfig['language'].'/main.php' );
} else {
	include_once( XOOPS_ROOT_PATH.'/modules/xnpstimulus/language/english/main.php' );
}


/**
 * 
 * return an array ov available simulator types.<br/>
 * that structue is shown below.<br/>
 * array( value of simulator type for processing => value of simulator type for displaying, ... )<br/>
 * values of displaying are defined by _MD_XNPSIMULATOR_SIMULATOR_TYPE_SELECT.<br/>
 * _MD_XNPSIMULATOR_SIMULATOR_TYPE_SELECT is tab(\t) separated value.<br/>
 * _MD_XNPSIMULATOR_SIMULATOR_TYPE_SELECT has four values which correspond to values for displaying as below.<br/>
 * matlab, mathematica, program, other
 * <br/>
 * number of values for displaying != number of values for processing then return false.<br/>
 * <br/>
 * 
 */
function
xnpstimulus_get_type_array( )
{
	$key = array( 'picture', 'movie', 'program', 'other' );
	$value = explode( "\t", _MD_XNPSTIMULUS_STIMULUS_TYPE_SELECT );
	$ret = array( );
	if( count( $key ) != count( $value ) )
		return FALSE;
	for( $i = 0; $i < count( $key ); $i++ ) {
		$ret[$key[$i]] = $value[$i];
	}
	return $ret;
}

/** retrieve Detail Information that specified by item_id
  * return array of items which registered into binder specified by item_id.
  * return array(only keys, no values) if item_id is wrong.
  * @return array as result
  * @return false if failed
  */
function
xnpstimulusGetDetailInformation( $item_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];
	$item = array( );

	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpstimulus_item_detail" )." where stimulus_id=$item_id" );
	$item = $xoopsDB->fetchArray( $result );

//  if( $item ){
	$stimulus_types = xnpstimulus_get_type_array( );
	$myts =& MyTextsanitizer::getInstance( );
	return array( 'stimulus_type' => array( 'value' => $item['stimulus_type'],
										'select' => xnpstimulus_get_type_array( ),
										'display_value' => $myts->htmlspecialchars( $stimulus_types[$item['stimulus_type']] ) ),
				  'developer' => array( 'value' => $item['developer'] ),
				  'readme' => array( 'value' => $item['readme'] ),
				  'rights' => array( 'value' => $item['rights'] ),
				  'use_cc'  => array( 'value' => $item['use_cc'] ),
				  'cc_commercial_use' => array( 'value' => $item['cc_commercial_use'] ),
				  'cc_modification'  => array( 'value' => $item['cc_modification'] ) );
//  }   
	return false;
}

function
xnpstimulusGetListBlock( $item_basic )
{
	$item_id = $item_basic['item_id'];

	// retrieve detail information
	$detail = xnpstimulusGetDetailInformation( $item_id );

	// assign to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// variables assigned to xoopsTpl are copied to tpl

	$tpl->assign( 'item_basic', $item_basic );
	$tpl->assign( 'item_detail', $detail );
	if( xnpIsPending( $item_basic['item_id'] ) ) $tpl->assign( 'pending', 'true' );

	// return HTML content
	return $tpl->fetch( "db:xnpstimulus_list_block.html" );
}

function
xnpstimulusGetPrinterFriendlyListBlock( $item_basic ){
	return xnpstimulusGetListBlock( $item_basic );
}

function
xnpstimulusGetDetailBlock( $item_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	// retrieve detail information
	$detail = xnpstimulusGetDetailInformation( $item_id );

	//retrive developer, stimulus_type, readme, license from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'stimulus_type', 'developer', 'readme', 'rights', 'use_cc', 'cc_commercial_use', 'cc_modification' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$detail[$k]['value'] = $_GET[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$detail[$k]['value'] = $_POST[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_POST[$k] );
			}
		}
	}

	// retrieve blocks ofBasicInformation / RegisteredItem
	$basic = xnpGetBasicInformationDetailBlock( $item_id );

	$preview = xnpGetPreviewDetailBlock( $item_id );
	$index = xnpGetIndexDetailBlock( $item_id );
	$attachment = xnpGetAttachmentDetailBlock( $item_id, 'stimulus_data' );
	$readme = xnpGetTextFileDetailBlock( $item_id, 'readme', $detail['readme']['value'] );
	$rights = xnpGetRightsDetailBlock( $item_id, $detail['use_cc']['value'], $detail['rights']['value'] );
	
	// assign to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// variables assigned to xoopsTpl are copied to tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );

	// return HTML content
	return $tpl->fetch( "db:xnpstimulus_detail_block.html" );
}

function
xnpstimulusGetPrinterFriendlyDetailBlock( $item_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	// retrieve detail information
	$detail = xnpstimulusGetDetailInformation( $item_id );

	//retrive developer, stimulus_type, readme, license from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'stimulus_type', 'developer', 'readme', 'rights' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$detail[$k]['value'] = $_GET[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$detail[$k]['value'] = $_POST[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_POST[$k] );
			}
		}
	}

	// retrieve blocks ofBasicInformation / RegisteredItem
	$basic = xnpGetBasicInformationDetailBlock( $item_id );

	$preview = xnpGetPreviewPrinterFriendlyBlock( $item_id );
	$index = xnpGetIndexPrinterFriendlyBlock( $item_id );
	$attachment = xnpGetAttachmentPrinterFriendlyBlock( $item_id, 'stimulus_data' );
	$readme = xnpGetTextFilePrinterFriendlyBlock( $item_id, 'readme', $detail['readme']['value'] );
	$rights = xnpGetRightsPrinterFriendlyBlock( $item_id, $detail['use_cc']['value'], $detail['rights']['value'] );

	// assign to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// variables assigned to xoopsTpl are copied to tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );

	// return HTML content
	return $tpl->fetch( "db:xnpstimulus_detail_block.html" );
}

function
xnpstimulusGetRegisterBlock( )
{
	global $xoopsDB;

	//retrive developer, stimulus_type from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'stimulus_type', 'developer', 'readme', 'rights' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$$k = $_GET[$k];
			} else {
				$$k = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$$k = $_POST[$k];
			} else {
				$$k = $myts->stripSlashesGPC( $_POST[$k] );
			}
		} else {
			$$k = false;
		}
	}

	// retrieve blocks of BasicInformation / Preview / Readme / License / index
	$basic = xnpGetBasicInformationRegisterBlock( );
	$stimulus_types = xnpstimulus_get_type_array( );
	if ( $stimulus_type == false ){
		list( $stimulus_type ) = each( $stimulus_types );
	}
	$detail = array( 'stimulus_type' => array( 'value' => $stimulus_type,
										   'display_value' => $stimulus_types[$stimulus_type],
										   'select' => $stimulus_types ), 'developer' => array( 'value' => $developer ) );
	$preview = xnpGetPreviewRegisterBlock( );
	$index = xnpGetIndexRegisterBlock( );
	$attachment = xnpGetAttachmentRegisterBlock( 'stimulus_data' );
	$readme = xnpGetTextFileRegisterBlock( 'readme' );
	$rights = xnpGetRightsRegisterBlock();

	// assign to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// variables assigned to xoopsTpl are copied to tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionRegisterBlock( 'xnpstimulus' ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );
	$tpl->assign( 'jumpto_url', 'register.php' );
	if( isset( $stimulus_date ) ) {
		$tpl->assign( 'gmtime', mktime( 0, 0, 0, $stimulus_date['Date_Month'], $stimulus_date['Date_Day'], $stimulus_date['Date_Year'] ) );
	} else {
		$tpl->assign( 'gmtime', time( ) );
	}
	// return HTML content
	return $tpl->fetch( "db:xnpstimulus_register_block.html" );
}

function
xnpstimulusGetEditBlock( $item_id )
{
	global $xoopsDB;

	// retrieve detail information
	$detail = xnpstimulusGetDetailInformation( $item_id );

	//retrive developer, stimulus_type, readme, license from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'stimulus_type', 'developer', 'readme', 'rights' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$detail[$k]['value'] = $_GET[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$detail[$k]['value'] = $_POST[$k];
			} else {
				$detail[$k]['value'] = $myts->stripSlashesGPC( $_POST[$k] );
			}
		}
	}
	$stimulus_types = xnpstimulus_get_type_array( );
	$detail['stimulus_type']['display_value'] = $stimulus_types[$detail['stimulus_type']['value']];
	$detail['stimulus_type']['select'] = $stimulus_types;

	// retrieve blocks of BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationEditBlock( $item_id );

	$preview = xnpGetPreviewEditBlock( $item_id );
	$index = xnpGetIndexEditBlock( $item_id );
	$attachment = xnpGetAttachmentEditBlock( $item_id, 'stimulus_data' );

	$readme = xnpGetTextFileEditBlock( $item_id, 'readme', $detail['readme']['value'] );
	$rights = xnpGetRightsEditBlock( $item_id, $detail['use_cc']['value'], $detail['rights']['value'], $detail['cc_commercial_use']['value'], $detail['cc_modification']['value'] );

	$attachment['name'] = _MD_XNPSTIMULUS_STIMULUS_FILE;

	// assign to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// variables assigned to xoopsTpl are copied to tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionEditBlock( 'xnpstimulus', xnpstimulusGetAttachmentDownloadLimitOption( $item_id ) ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );
	$tpl->assign( 'jumpto_url', 'edit.php' );

	// return HTML content
	return $tpl->fetch( "db:xnpstimulus_register_block.html" );
}


function
xnpstimulusGetConfirmBlock( $item_id )
{

	//retrive developer, stimulus_type from GET/POST array
	$myts =& MyTextsanitizer::getInstance( );
	foreach( array( 'stimulus_type', 'developer', 'readme', 'rights' ) as $k ) {
		if( array_key_exists( $k, $_GET ) ) {
			if( is_array( $_GET[$k] ) ) {
				$$k = $_GET[$k];
			} else {
				$$k = $myts->stripSlashesGPC( $_GET[$k] );
			}
		} else if( array_key_exists( $k, $_POST ) ) {
			if( is_array( $_POST[$k] ) ) {
				$$k = $_POST[$k];
			} else {
				$$k = $myts->stripSlashesGPC( $_POST[$k] );
			}
		}
	}

	// retrieve blocks of BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationConfirmBlock( $item_id );
	$stimulus_types = xnpstimulus_get_type_array( );
/*
	$detail = array( 'stimulus_type' => array( 'value' => $stimulus_type,
										   'display_value' => $myts->htmlspecialchars( $stimulus_types[$stimulus_type] ) ),
					 'developer' => array( 'value' => $developer ) );
*/
	$detail = array( 'stimulus_type' => array( 'value' => $stimulus_type,
										   'display_value' => $myts->htmlspecialchars( $stimulus_types[$stimulus_type] ) ),
					 'developer' => array( 'value' => xnpHtmlspecialchars( $developer ) ) );
	if( isset( $stimulus_date ) ) {
		$detail['stimulus_date'] = array( 'value' => mktime( 0, 0, 0,
														 $stimulus_date['Date_Month'],
														 $stimulus_date['Date_Day'], $stimulus_date['Date_Year'] ) );
	} else {
		$detail['stimulus_date'] = array( 'value' => time( ) );
	}

	$preview = xnpGetPreviewConfirmBlock( $item_id );
	$attachment = xnpGetAttachmentConfirmBlock( $item_id, 'stimulus_data' );
	$index = xnpGetIndexConfirmBlock( $item_id );
	$readme = xnpGetTextFileConfirmBlock( $item_id, 'readme' );
	$rights = xnpGetRightsConfirmBlock( $item_id );

	// assign to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// variables assigned to xoopsTpl are copied to tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'attachment', $attachment );
	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionConfirmBlock( 'xnpstimulus' ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'readme', $readme );
	$tpl->assign( 'rights', $rights );
	if( isset( $stimulus_date ) ){
		$tpl->assign( 'stimulus_date', $stimulus_date );
		if( $stimulus_date['Date_Year'] )
			$tpl->assign( 'system_message', $tpl->get_template_vars( 'system_message' )
						  ."<br/><font color='#ff0000'>"._MD_XOONIPS_ITEM_TITLE_REQUIRED."</font>" );
	}
	
	// return HTML content
	return $tpl->fetch( "db:xnpstimulus_confirm_block.html" );
}

function
xnpstimulusInsertItem( )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	// retister BasicInformation, Index and Attachment
	$item_id = 0;
	$result = xnpInsertBasicInformation( $item_id );
	if( $result ) {
		$result = xnpUpdateIndex( $item_id );
		if( $result ) {
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
                $result = xnpUpdateAttachment( $item_id, 'stimulus_data' );
                if( $result ) {
                }
            }
		}
		if( !$result )
			xnpDeleteBasicInformation( $xnpsid, $item_id );
	}
	if( !$result )
		return false;

	// register detail information
	list( $rights, $use_cc, $cc_commercial_use, $cc_modification ) = xnpGetRights();
	
	$stimulus_date = $_POST['stimulus_date'];

	$myts =& MyTextSanitizer::getInstance( );
	$keys = implode( ",", array( 'stimulus_type', 'developer', 'readme', 'rights', 'use_cc', 'cc_commercial_use', 'cc_modification', 'attachment_dl_limit' ) );
	$vals = implode( "','", array( $myts->addSlashes( $_POST['stimulus_type'] ),
								   $myts->addSlashes( $_POST['developer'] ),
								   $myts->addSlashes( xnpGetTextFile( 'readme' ) ),
								   addslashes( $rights ),
								   $use_cc, $cc_commercial_use, $cc_modification, 
								   $myts->addSlashes( $_POST['attachment_dl_limit'] )
					  ) );

	$sql = "insert into ".$xoopsDB->prefix( "xnpstimulus_item_detail" )." ( stimulus_id, $keys ) values ( $item_id, '$vals' ) ";
	$result = $xoopsDB->queryF( $sql );
	if( $result == false ) {
		echo "cannot insert item_detail: ".$xoopsDB->error();
		return false;
	}

	return true;
}

function
xnpstimulusUpdateItem( $stimulus_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];
	$myts =& MyTextSanitizer::getInstance( );

	// modify BasicInformation, Index, Preview and Attachment.
	$result = xnpUpdateBasicInformation( $stimulus_id );
	if( $result ) {
		$result = xnpUpdateIndex( $stimulus_id );
		if( $result ) {
			$result = xnpUpdatePreview( $stimulus_id );
			if ( $result ){
                $result = xnpUpdateAttachment( $stimulus_id, 'stimulus_data' );
                if( $result ) {
                    $result = xnp_insert_change_log( $xnpsid, $stimulus_id, $myts->stripSlashesGPC( $_POST['change_log'] ) );
                    $result = !$result;
                    if( !$result )
                        echo " xnp_insert_change_log failed.";
                } else
                    echo " xnpUpdateAttachment failed.";
			}
			else echo " xnpUpdatePreview failed.";
		} else
			echo " xnpUpdateIndex failed.";
	} else
		echo " xnpUpdateBasicInformation failed.";
	if( !$result )
		return false;

	$stimulus_date = $_POST['stimulus_date'];
	list( $rights, $use_cc, $cc_commercial_use, $cc_modification ) = xnpGetRights();
	$myts =& MyTextSanitizer::getInstance( );
	$keyval = array( "stimulus_type='".$myts->addSlashes( $_POST['stimulus_type'] )."'",
					 "developer='".$myts->addSlashes( $_POST['developer'] )."'",
					 "readme='"   .$myts->addSlashes(xnpGetTextFile( 'readme' ))."'",
					 "rights='"  .addslashes( $rights )."'",
					 "use_cc='"           .$use_cc           ."'",
					 "cc_commercial_use='".$cc_commercial_use."'",
					 "cc_modification='" .$cc_modification ."'",
					 "attachment_dl_limit='".$myts->addSlashes( $_POST['attachment_dl_limit'] )."'" );

	// modify detail information
	$myts =& MyTextSanitizer::getInstance( );
	$sql = "update ".$xoopsDB->prefix( "xnpstimulus_item_detail" )
		." set ".implode( ", ", $keyval )
		." where stimulus_id=$stimulus_id";
	$result = $xoopsDB->queryF( $sql );
	if( $result == false ) {
		echo "cannot update item_detail";
		echo "\n$sql";
		return false;
	}

	return true;
}

function
xnpstimulusDeleteItem( $stimulus_id )
{
	global $xoopsDB;

	$xnpsid = $_SESSION['XNPSID'];

	// remove BasicInformation, Index, Preview and Attachment.
	if( !xnpDeleteBasicInformation( $stimulus_id ) ) {
		echo "cannot delete stimulus item";
		return false;
	}
	// remove detail information
	$sql = "delete from ".$xoopsDB->prefix( "xnpstimulus_item_detail" )
		." where stimulus_id=$stimulus_id";
	$xoopsDB->queryF( $sql );
	return true;
}




function
xnpstimulusGetSearchBlock( $item_id )
{
	// todo: details to be defnied
}

function
xnpstimulusCheckRegisterParameters( &$msg )
{
	$xnpsid = $_SESSION['XNPSID'];
	$result = true;
	if( $_POST['developer'] == '' ) {
		//developer is not filled
		$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPSTIMULUS_DEVELOPER_REQUIRED."</font>";
		$result = false;
	}
	if( (empty($_FILES['stimulus_data']) || $_FILES['stimulus_data']['name'] == '') && $_POST['stimulus_dataFileID'] == '' ) {
		//stimulus_data is not filled
		$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPSTIMULUS_STIMULUS_DATA_REQUIRED."</font>";
		$result = false;
	}
	// notify that license statement is required when register into public indexes.
	$xids = explode( ',', $_POST['xoonipsCheckedXID'] );
	$indexes = array( );
	if( $xids[0] != $_POST['xoonipsCheckedXID'] ) {
		foreach( $xids as $i ) {
			$index = array( );
			if( xnp_get_index( $xnpsid, $i, $index ) == RES_OK ) {
				$indexes[] = $index;
			} else {
				$msg = $msg."<br/><font color='#ff0000'>".xnp_get_last_error_string( )."</font>";
				$result = false;
				break;
			}
		}
	}
	if( count( $indexes ) > 0 ) {
		foreach( $indexes as $i ) {
			if( $i['open_level'] <= OL_GROUP_ONLY ) {
				if( $_POST['readmeEncText'] == '' ) {
					//readme is not filled
					$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPSTIMULUS_README_REQUIRED."</font>";
					$result = false;
				}
				if( $_POST['rightsEncText'] == '' && $_POST['rightsUseCC'] == '0' ) {
					//license is not filled
					$msg = $msg."<br/><font color='#ff0000'>"._MD_XNPSTIMULUS_RIGHTS_REQUIRED."</font>";
					$result = false;
				}
				break;
			}
		}
	}
	return $result;
}

function
xnpstimulusCheckEditParameters( &$msg )
{
	return xnpstimulusCheckRegisterParameters( $msg );
}

function
xnpstimulusGetMetaInformation( $item_id )
{
	$ret = array( );
	$basic = xnpGetBasicInformationArray( $item_id );
	$detail = xnpstimulusGetDetailInformation( $item_id );

	if ( !empty( $basic ) ){
		$ret[_MD_XOONIPS_ITEM_TITLE_LABEL] = $basic['title'];
		$ret[_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL] = $basic['contributor'];
		$ret[_MD_XOONIPS_ITEM_KEYWORDS_LABEL] = $basic['keywords'];
		$ret[_MD_XOONIPS_ITEM_DESCRIPTION_LABEL] = $basic['description'];
		$ret[_MD_XOONIPS_ITEM_DOI_LABEL] = $basic['doi'];
		$ret[_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL] = $basic['last_update_date'];
		$ret[_MD_XOONIPS_ITEM_CREATION_DATE_LABEL] = $basic['creation_date'];
		$ret[_MD_XNPSTIMULUS_DATE_LABEL] =
			date( DATE_FORMAT,
				  mktime( 0, 0, 0, $basic['publication_month'], $basic['publication_mday'], $basic['publication_year'] ) );
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XNPSTIMULUS_STIMULUS_TYPE_LABEL] = $detail['stimulus_type']['display_value'];
		$ret[_MD_XNPSTIMULUS_DEVELOPER_LABEL] = $detail['developer']['value'];
		$ret[_MD_XOONIPS_ITEM_README_LABEL] = $detail['readme']['value'];
		$ret[_MD_XOONIPS_ITEM_RIGHTS_LABEL] = $detail['rights']['value'];
	}
	return $ret;
}

function
xnpstimulusGetAdvancedSearchBlock( &$search_var )
{

	$basic = xnpGetBasicInformationAdvancedSearchBlock( 'xnpstimulus', $search_var );

	$search_var[] = 'xnpstimulus_stimulus_type';
	$search_var[] = 'xnpstimulus_developer';
	$search_var[] = 'xnpstimulus_caption';

	// assign to template
	global $xoopsTpl;

	$tpl = new xoopsTpl( );
	$tpl->assign( $xoopsTpl->get_template_vars( ) );	// variables assigned to xoopsTpl are copied to tpl
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'module_name', 'xnpstimulus' );
	$stimulus_type = xnpstimulus_get_type_array( );
	$tpl->assign( 'stimulus_type_option', $stimulus_type );
	$types = array( );
	if( xnp_get_item_types( $types ) == RES_OK ) {
		foreach( $types as $i ) {
			if( $i['name'] == 'xnpstimulus' ) {
				$tpl->assign( 'module_display_name', $i['display_name'] );
			}
		}
	} else {
		$tpl->assign( 'module_display_name', 'xnpstimulus' );
	}

	// return HTML content
	return $tpl->fetch( "db:xnpstimulus_search_block.html" );
}

function
xnpstimulusGetAdvancedSearchQuery( &$where, &$join )
{
	global $xoopsDB;
	$stimulus_table = $xoopsDB->prefix( 'xnpstimulus_item_detail' );
	$file_table = $xoopsDB->prefix( 'xoonips_file' );

	$wheres = array( );
	$joins = array();
	$w = xnpGetBasicInformationAdvancedSearchQuery( 'xnpstimulus' );
	if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery( $stimulus_table.'.stimulus_type', 'xnpstimulus_stimulus_type' );
	if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery( $stimulus_table.'.developer', 'xnpstimulus_developer' );
	if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery( $file_table.'.caption', 'xnpstimulus_caption' );
	if( $w ){
		$wheres[] = $w;
		$wheres[] = " $file_table.file_type_id = 1";
	}
	$where = implode( ' and ', $wheres );
	$join = "";
}

function
xnpstimulusGetDetailInformationQuickSearchQuery( &$wheres, &$join, $keywords )
{
	global $xoopsDB;
	$stimulus_table = $xoopsDB->prefix( 'xnpstimulus_item_detail' );
	$file_table  = $xoopsDB->prefix('xoonips_file');
	
	$colnames = array( "$stimulus_table.developer", "$file_table.caption" );
	$wheres = xnpGetKeywordsQueries( $colnames, $keywords );
	return true;
}

function
xnpstimulusGetDetailInformationTotalSize( $iids ){
	return xnpGetTotalFileSize( $iids );
}

function xnpstimulusGetLicenseRequired( $item_id )
{
	global $xoopsDB;

	// retrieve detail information
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpstimulus_item_detail" )." where stimulus_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    return isset( $detail['rights'] ) && $detail['rights'] != '';
}

function xnpstimulusGetLicenseStatement( $item_id )
{
	global $xoopsDB;

	// retrieve detail information
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpstimulus_item_detail" )." where stimulus_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    return array( isset( $detail['rights'] ) ? $detail['rights'] : '', $detail['use_cc'] );;
}

function xnpstimulusExportItem($item_id, $attachment )
{
	global $xoopsDB;

	// retrieve detail information
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpstimulus_item_detail" )." where stimulus_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
/*
	return "<detail id=\"${item_id}\">\n"
        ."<stimulus_type>".htmlspecialchars( $detail['stimulus_type'], ENT_QUOTES )."</stimulus_type>\n"
        ."<developer>".htmlspecialchars( $detail['developer'], ENT_QUOTES )."</developer>\n"
        ."<readme>".htmlspecialchars( $detail['readme'], ENT_QUOTES )."</readme>\n"
        ."<rights>".htmlspecialchars( $detail['rights'], ENT_QUOTES )."</rights>\n"
        ."<use_cc>"           .$detail['use_cc']           ."</use_cc>\n"
        ."<cc_commercial_use>".$detail['cc_commercial_use']."</cc_commercial_use>\n"
        ."<cc_modification>"  .$detail['cc_modification']  ."</cc_modification>\n"
        .( $attachment ? xnpExportFile( $item_id ) : '' )
        ."</detail>\n";
*/
	return "<detail id=\"${item_id}\">\n"
        ."<stimulus_type>".xnpHtmlspecialchars( $detail['stimulus_type'], ENT_QUOTES )."</stimulus_type>\n"
        ."<developer>".xnpHtmlspecialchars( $detail['developer'], ENT_QUOTES )."</developer>\n"
        ."<readme>".xnpHtmlspecialchars( $detail['readme'], ENT_QUOTES )."</readme>\n"
        ."<rights>".xnpHtmlspecialchars( $detail['rights'], ENT_QUOTES )."</rights>\n"
        ."<use_cc>"           .$detail['use_cc']           ."</use_cc>\n"
        ."<cc_commercial_use>".$detail['cc_commercial_use']."</cc_commercial_use>\n"
        ."<cc_modification>"  .$detail['cc_modification']  ."</cc_modification>\n"
        .( $attachment ? xnpExportFile( $item_id ) : '' )
        ."</detail>\n";
}

function xnpstimulusStartElement($parser, $name, $attribs, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $parser_hash['detail'] = array();
        break;
    case "/ITEM/DETAIL/STIMULUS_TYPE":
    case "/ITEM/DETAIL/DEVELOPER": 
    case "/ITEM/DETAIL/README": 
    case "/ITEM/DETAIL/RIGHTS": 
    case "/ITEM/DETAIL/USE_CC": 
    case "/ITEM/DETAIL/CC_COMMERCIAL_USE": 
    case "/ITEM/DETAIL/CC_MODIFICATION": 
        $parser_hash['detail'][end($parser_hash['tagstack'])] = '';
        break;
    }
//    echo("<b><font color=\"#0000ff\">&lt$name&gt</font></b><br>"); 
}
function xnpstimulusEndElement($parser, $name, &$parser_hash)
{
	global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    $myts =& MyTextSanitizer::getInstance( );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
//        print_r( $parser_hash['detail'] );
        $keys = implode( ",", array( 'stimulus_type', 'developer', 'readme', 'rights', 'use_cc', 'cc_commercial_use', 'cc_modification' ) );
/*
        $vals = implode( "','", array( $myts->addSlashes( $parser_hash['detail']['STIMULUS_TYPE'] ),
                                       $myts->addSlashes( $parser_hash['detail']['DEVELOPER'] ),
                                       addslashes( $parser_hash['detail']['README'] ),
                                       addslashes( $parser_hash['detail']['RIGHTS'] ),
                                       (int)$parser_hash['detail']['USE_CC'],
                                       (int)$parser_hash['detail']['CC_COMMERCIAL_USE'],
                                       (int)$parser_hash['detail']['CC_MODIFICATION'],
            ) );
*/
        $vals = implode( "','", array( $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['STIMULUS_TYPE'] ) ),
                                       $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['DEVELOPER'] ) ),
                                       addslashes( encodeClient2Server( $parser_hash['detail']['README'] ) ),
                                       addslashes( encodeClient2Server( $parser_hash['detail']['RIGHTS'] ) ),
                                       (int)$parser_hash['detail']['USE_CC'],
                                       (int)$parser_hash['detail']['CC_COMMERCIAL_USE'],
                                       (int)$parser_hash['detail']['CC_MODIFICATION'],
            ) );
        
        // register detail information
        $myts =& MyTextSanitizer::getInstance( );
        $sql = "insert into ".$xoopsDB->prefix( "xnpstimulus_item_detail" )." ( stimulus_id, $keys ) values ( ".$parser_hash['id_table'][$parser_hash['basic']['ID']].", '$vals' ) ";
        $result = $xoopsDB->queryF( $sql );
        if( $result == false ) {
            echo "cannot insert item_detail\n $sql";
            return false;
        }
        break;
    }
//    echo("<br><b><font color=\"#0000ff\">&lt/$name&gt</font></b><br><br>"); 
}

function xnpstimulusCharacterData($parser, $data, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/DETAIL/STIMULUS_TYPE":
    case "/ITEM/DETAIL/DEVELOPER": 
    case "/ITEM/DETAIL/RIGHTS": 
    case "/ITEM/DETAIL/README": 
    case "/ITEM/DETAIL/USE_CC": 
    case "/ITEM/DETAIL/CC_COMMERCIAL_USE": 
    case "/ITEM/DETAIL/CC_MODIFICATION": 
        if( !array_key_exists( end($parser_hash['tagstack']), $parser_hash['detail'] ) ){
            $parser_hash['detail'][end($parser_hash['tagstack'])] = $data;
        }else{
            $parser_hash['detail'][end($parser_hash['tagstack'])] .= $data;
        }
        break; 
    } 
//    echo($data); 
}

function xnpstimulusGetImportHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnpstimulusStartElement", "xnpstimulusEndElement", "xnpstimulusCharacterData" ) );
}

function xnpstimulusGetModifiedFields( $item_id )
{
    $ret = array();
    $basic = xnpGetBasicInformationArray($item_id);
    if( $basic ){
        if( mktime(0,0,0,$basic['publication_month'],$basic['publication_mday'],$basic['publication_year'] )
            != mktime(0,0,0,$_POST['publicationDateMonth'],$_POST['publicationDateDay'],$_POST['publicationDateYear']) )
            array_push( $ret, _MD_STIMULUS_DATE_LABEL );
    }
    $detail = xnpstimulusGetDetailInformation( $item_id );
    if( $detail ){
        $myts =& MyTextSanitizer::getInstance( );
        foreach( array( 'stimulus_type' => _MD_XNPSTIMULUS_STIMULUS_TYPE,
                        'developer' => _MD_XNPSTIMULUS_DEVELOPER ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) array_push( $ret, $v );
        }
        foreach( array( 'readme' => _MD_XOONIPS_ITEM_README_LABEL,
                        'rights' => _MD_XOONIPS_ITEM_RIGHTS_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( "${k}EncText", $_POST ) ) continue;
            if( urldecode($_POST[ "${k}EncText" ]) != $detail[ $k ] ) array_push( $ret, $v );
        }
        
        // is modified data files ?
        if( xnpIsAttachmentModified( 'stimulus_data', $item_id ) ){
            array_push( $ret, _MD_XNPSTIMULUS_STIMULUS_FILE );
        }
    }
    return $ret;
}

function xnpstimulusGetTopBlock( $itemtype ){
	return xnpGetTopBlock( $itemtype['name'], $itemtype['display_name'], 'images/icon_stimulus.gif', _MD_XNPSTIMULUS_EXPLANATION, 'xnpstimulus_stimulus_type', xnpstimulus_get_type_array() );
}


//return 1 if downloadable for login user only
//return 0 if downloadable for everyone
function xnpstimulusGetAttachmentDownloadLimitOption( $item_id )
{
	global $xoopsDB;
    $sql = "select attachment_dl_limit from ".$xoopsDB->prefix( "xnpstimulus_item_detail" )." where stimulus_id=${item_id}";
    $result = $xoopsDB->query( $sql );
    if( $result ){
        list( $option ) = $xoopsDB->fetchRow( $result );
        return $option;
    }
    return 0;
}

function xnpstimulusSupportMetadataFormat( $metadataPrefix, $item_id )
{
    if( $metadataPrefix == 'oai_dc' || $metadataPrefix == 'junii' ) return true;
    return false;
}

function xnpstimulusGetMetadata( $metadataPrefix, $item_id )
{
    $meta_basic = xnpGetBasicInformationMetadata( $metadataPrefix, $item_id );
    if( $meta_basic ){
		$basic = array();
		if( xnp_get_item( $_SESSION['XNPSID'], $item_id, $basic ) != RES_OK )
			return false;
		
        $detail = xnpstimulusGetDetailInformation( $item_id );
		$lines = array();
		if( $metadataPrefix == 'junii' ){
            $lines[] = "<metadata>";
            $lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii.xsd">';
            $lines[] = $meta_basic;
            $lines[] = "<type xsi:type=\"NII\">".xnpGetMetadataJunii(22)."</type>";
//            $lines[] = "<type>stimulusType:".htmlspecialchars($detail['stimulus_type']['value'])."</type>";
            $lines[] = "<type>stimulusType:".xnpHtmlspecialchars($detail['stimulus_type']['value'])."</type>";
//            $lines[] = "<creator>".htmlspecialchars($detail['developer']['value'])."</creator>";
            $lines[] = "<creator>".xnpHtmlspecialchars($detail['developer']['value'])."</creator>";
            $lines[] = "<date xsi:type=\"ISO8601\">"
                .date( "Y-m-d", mktime( 0, 0, 0,
                                        $basic['publication_month'],
                                        $basic['publication_mday'],
                                        $basic['publication_year'] ) )
                ."</date>";
//            $lines[] = "<description>readme:".htmlspecialchars($detail['readme']['value'])."</description>";
            $lines[] = "<description>readme:".xnpHtmlspecialchars($detail['readme']['value'])."</description>";
//            $lines[] = "<description>rights:".htmlspecialchars($detail['rights']['value'])."</description>";
            $lines[] = "<description>rights:".xnpHtmlspecialchars($detail['rights']['value'])."</description>";
            $lines[] = "</meta>";
            $lines[] = "</metadata>";
        }
		else if ( $metadataPrefix == 'oai_dc' ) {
			$lines = array();
			$lines[] = "<metadata>";
			$lines[] = '<oai_dc:dc 
               xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/" 
               xmlns:dc="http://purl.org/dc/elements/1.1/" 
               xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
               xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/ 
               http://www.openarchives.org/OAI/2.0/oai_dc.xsd">';
			$lines[] = $meta_basic;
//			$lines[] = "<dc:type>stimulusType:".htmlspecialchars($detail['stimulus_type']['value'])."</dc:type>";
			$lines[] = "<dc:type>stimulusType:".xnpHtmlspecialchars($detail['stimulus_type']['value'])."</dc:type>";
//			$lines[] = "<dc:creator>".htmlspecialchars($detail['developer']['value'])."</dc:creator>";
			$lines[] = "<dc:creator>".xnpHtmlspecialchars($detail['developer']['value'])."</dc:creator>";
			$lines[] = "<dc:date>"
			    .date( "Y-m-d", mktime( 0, 0, 0,
			                            $basic['publication_month'],
			                            $basic['publication_mday'],
			                            $basic['publication_year'] ) )
			    ."</dc:date>";
//			$lines[] = "<dc:rights>".htmlspecialchars($detail['rights']['value'])."</dc:rights>";
			$lines[] = "<dc:rights>".xnpHtmlspecialchars($detail['rights']['value'])."</dc:rights>";
//			$lines[] = "<dc:description>readme:".htmlspecialchars($detail['readme']['value'])."</dc:description>";
			$lines[] = "<dc:description>readme:".xnpHtmlspecialchars($detail['readme']['value'])."</dc:description>";
			$lines[] = "</oai_dc:dc>";
			$lines[] = "</metadata>";
		}
		return implode( "\n", $lines )."\n";
    }
    return false;
}
?>
