<?php
//  $Revision: 1.23.2.3 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

include '../../../include/cp_header.php';
$language = $xoopsConfig['language'];
if ( file_exists(XOOPS_ROOT_PATH."/language/$language/user.php") ) {
	include XOOPS_ROOT_PATH."/language/$language/user.php";
}

if ( file_exists("../language/$language/main.php") ) {
	include "../language/$language/main.php";
} else {
	include "../language/english/main.php";
}

if ( file_exists(XOOPS_ROOT_PATH."/modules/system/language/$language/admin.php") ) {
	include XOOPS_ROOT_PATH."/modules/system/language/$language/admin.php";
} else {
	include XOOPS_ROOT_PATH."/modules/system/language/english/admin.php";
}

include_once '../condefs.php';
include_once '../include/lib.php';
require_once '../include/create_session.php';
require_once XOOPS_ROOT_PATH.'/class/xoopsblock.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

include_once '../install_funcs.php'; // for xoonips_get_default_configs()

include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";

$myts =& MyTextSanitizer::getInstance();

xoops_cp_header();

$configs = xoonips_get_default_configs();

foreach( $configs as $k => $v ){
    if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v['value'];
    }
}

if ( isset($_POST['op']) && $_POST['op'] == 'update' ) {
    //update RSS if rss_file_path is modified
    $val = '';
    
    if( preg_match( "/\.\./", $rss_file_path ) ){
        redirect_header( 'config.php', 3, _MD_XOONIPS_ACCOUNT_RSS_FILE_PATH_TITLE_PARENT_DIR_ERROR );
    }
    if( $rss_file_path != ''
        && !is_writable( XOOPS_ROOT_PATH.'/'.$rss_file_path ) ){
        redirect_header( 'config.php', 3, _MD_XOONIPS_ACCOUNT_RSS_FILE_PATH_TITLE_NOT_WRITABLE_ERROR );
    }
    xnp_get_config_value( 'rss_file_path', $val );
    if( $val != $rss_file_path ){
        xnpGenerateRSS( XOOPS_ROOT_PATH.'/'.$rss_file_path );
    }else{
        xnp_get_config_value( 'rss_item_max', $val );
        if( $val != $rss_item_max ){
            xnpGenerateRSS( XOOPS_ROOT_PATH.'/'.$rss_file_path, $rss_item_max );
        }
    }
    
    if( $rss_item_max == '' || $rss_item_max < 0 ){
        //set default value if value is out of range
        $rss_item_max = $configs['rss_item_max']['value'];
    }
    
	// Insert into database.
	foreach ( $configs as $name => $config ){
		$val = $$name;
		$type = $config['type'];
		if ( $type == 's' ){
			$val = $myts->stripSlashesGPC($val);
		}
		else if ( $type == 'i' ){
			if ( !empty($val) )
				$val = (int)$val;
		}
		else if ( $type == 'dm' ){
			if ( !empty($val) )
				$val = (double)$val*1000000.0;
		}
		
		$old_val = null;
		xnp_get_config_value( $name, $old_val );
		xnp_set_config_value( $name, "$val" );
		
		// If moderator_gid changes, the right to access moderator menu block is changed. 
		if ( $name == 'moderator_gid' && "$old_val" != "$val" ){
			$moderator_gid = $val;
			$old_moderator_gid = $old_val;
			
			$gperm_handler =& xoops_gethandler('groupperm');
			
			$module =& $module_handler->getByDirname('xoonips');
			$mid = $module->getVar('mid'); // $xoopsMod->getVar('mid');
			$block_objects =& XoopsBlock::getByModule( $mid );
			$bid = null;
			foreach( $block_objects as $o )
				if ( $o->getVar('show_func') == 'b_xoonips_moderator_show' )
					$bid = $o->getVar('bid');
			if ( $bid ){
				// Delete the right to access moderator block from old_gid.
				$criteria = new CriteriaCompo();
				$criteria->add( new Criteria( 'gperm_groupid', $old_moderator_gid ) );
				$criteria->add( new Criteria( 'gperm_itemid', $bid ) );
				$criteria->add( new Criteria( 'gperm_name', 'block_read' ) );
				
				$objects = $gperm_handler->getObjects($criteria);
				foreach ( $objects as $object )
					$gperm_handler->delete( $object );
				
				// If there is no right to access moderator block in new_gid, the right gives new_gid.
				if ( !$gperm_handler->checkRight( 'block_read' , $bid, $moderator_gid ) )
					$gperm_handler->addRight( 'block_read' , $bid, $moderator_gid );
			}
		}
		
	}
	redirect_header('config.php', 3, _MD_AM_DBUPDATED );
	exit;
}

// Config data is read from database.
$ar = $configs;
foreach ( $configs as $key => $config ){
	$val = "";
	if ( RES_OK == xnp_get_config_value( $key, $val ) ){
		$ar[$key]['value'] = $val;
	}
}

// make form elements and characters in display.
$form = new XoopsThemeForm( _MD_XOONIPS_ACCOUNT_CONFIG, "config", "config.php" );

$form -> addElement( new XoopsFormSelectGroup(_MD_XOONIPS_ACCOUNT_MODERATOR_GROUP_TITLE, 'moderator_gid', true, $ar['moderator_gid']['value']) );

// certify_user
$certify_user_select = new XoopsFormSelect(_MD_XOONIPS_ACCOUNT_CERTIFY_USER_TITLE, 'certify_user', $ar['certify_user']['value']);
$certify_user_select -> addOptionArray( array( 'auto'=>_MD_XOONIPS_ACCOUNT_CERTIFY_USER_AUTO, 'on'=>_MD_XOONIPS_ACCOUNT_CERTIFY_USER_ON ) );
$form->addElement( $certify_user_select );

// certify_item
$certify_item_select = new XoopsFormSelect(_MD_XOONIPS_ACCOUNT_CERTIFY_ITEM_TITLE, 'certify_item', $ar['certify_item']['value']);
$certify_item_select -> addOptionArray( array( 'auto'=>_MD_XOONIPS_ACCOUNT_CERTIFY_ITEM_AUTO, 'on'=>_MD_XOONIPS_ACCOUNT_CERTIFY_ITEM_ON ) );
$form->addElement( $certify_item_select );

// public_item_target_user
$public_item_target_user_select = new XoopsFormSelect(_MD_XOONIPS_ACCOUNT_PUBLIC_ITEM_TITLE, 'public_item_target_user', $ar['public_item_target_user']['value']);
$public_item_target_user_select -> addOptionArray( array( 'platform'=>_MD_XOONIPS_ACCOUNT_PUBLIC_ITEM_PLATFORM, 'all'=>_MD_XOONIPS_ACCOUNT_PUBLIC_ITEM_ALL ) );
$form->addElement( $public_item_target_user_select );

// upload_dir
$upload_dir_text = new XoopsFormText(_MD_XOONIPS_ACCOUNT_UPLOAD_DIR_TITLE, 'upload_dir', 40, 255, $ar['upload_dir']['value']);
$form->addElement( $upload_dir_text );


// optional items in account
function xoonips_addradio( &$form, $title, $key, $value ){
	$radio = new XoopsFormRadio($title, $key, $value);
	$radio -> addOptionArray( array( 'on'=>_MD_XOONIPS_ACCOUNT_OPTIONAL, 'off'=>_MD_XOONIPS_ACCOUNT_REQUIRED ) );
	$form->addElement( $radio );
}
xoonips_addradio( $form, _MD_XOONIPS_ACCOUNT_REALNAME_OPTIONAL_TITLE, 'account_realname_optional', $ar['account_realname_optional' ]['value'] );
xoonips_addradio( $form, _MD_XOONIPS_ACCOUNT_ADDRESS_OPTIONAL_TITLE,  'account_address_optional' , $ar['account_address_optional'  ]['value'] );
xoonips_addradio( $form, _MD_XOONIPS_ACCOUNT_DIVISION_OPTIONAL_TITLE, 'account_division_optional', $ar['account_division_optional' ]['value'] );
xoonips_addradio( $form, _MD_XOONIPS_ACCOUNT_TEL_OPTIONAL_TITLE,      'account_tel_optional'     , $ar['account_tel_optional'      ]['value'] );
xoonips_addradio( $form, _MD_XOONIPS_ACCOUNT_COMPANY_OPTIONAL_TITLE,  'account_company_name_optional' , $ar['account_company_name_optional'  ]['value'] );
xoonips_addradio( $form, _MD_XOONIPS_ACCOUNT_COUNTRY_OPTIONAL_TITLE,  'account_country_optional' , $ar['account_country_optional'  ]['value'] );
xoonips_addradio( $form, _MD_XOONIPS_ACCOUNT_ZIPCODE_OPTIONAL_TITLE,  'account_zipcode_optional' , $ar['account_zipcode_optional'  ]['value'] );
xoonips_addradio( $form, _MD_XOONIPS_ACCOUNT_FAX_OPTIONAL_TITLE,      'account_fax_optional'     , $ar['account_fax_optional'      ]['value'] );

if ( !empty($ar['private_item_storage_limit']['value']) )
	$ar['private_item_storage_limit']['value'] /= 1000000.0;
if ( !empty($ar['group_item_storage_limit']['value']) )
	$ar['group_item_storage_limit']['value'] /= 1000000.0;

$private_item_number_limit = new XoopsFormText(_MD_XOONIPS_ACCOUNT_DEFAULT_PRIVATE_ITEM_NUMBER_LIMIT_TITLE, 'private_item_number_limit', 40, 255, $ar['private_item_number_limit']['value']);
$form->addElement( $private_item_number_limit );
$private_index_number_limit = new XoopsFormText(_MD_XOONIPS_ACCOUNT_DEFAULT_PRIVATE_INDEX_NUMBER_LIMIT_TITLE, 'private_index_number_limit', 40, 255, $ar['private_index_number_limit']['value']);
$form->addElement( $private_index_number_limit );
$private_item_storage_limit = new XoopsFormText(_MD_XOONIPS_ACCOUNT_DEFAULT_PRIVATE_ITEM_STORAGE_LIMIT_TITLE, 'private_item_storage_limit', 40, 255, $ar['private_item_storage_limit']['value']);
$form->addElement( $private_item_storage_limit );
$group_item_number_limit = new XoopsFormText(_MD_XOONIPS_ACCOUNT_DEFAULT_GROUP_ITEM_NUMBER_LIMIT_TITLE, 'group_item_number_limit', 40, 255, $ar['group_item_number_limit']['value']);
$form->addElement( $group_item_number_limit );
$group_index_number_limit = new XoopsFormText(_MD_XOONIPS_ACCOUNT_DEFAULT_GROUP_INDEX_NUMBER_LIMIT_TITLE, 'group_index_number_limit', 40, 255, $ar['group_index_number_limit']['value']);
$form->addElement( $group_index_number_limit );
$group_item_storage_limit = new XoopsFormText(_MD_XOONIPS_ACCOUNT_DEFAULT_GROUP_ITEM_STORAGE_LIMIT_TITLE, 'group_item_storage_limit', 40, 255, $ar['group_item_storage_limit']['value']);
$form->addElement( $group_item_storage_limit );

$amazon_associates_id_text = new XoopsFormText(_MD_XOONIPS_ACCOUNT_AMAZON_ASSOCIATES_ID_TITLE, 'amazon_associates_id', 40, 255, $ar['amazon_associates_id']['value']);
$form->addElement( $amazon_associates_id_text );

$download_file_compression_radio = new XoopsFormRadio( _MD_XOONIPS_DOWNLOAD_FILE_COMPRESSION, 'download_file_compression', $ar['download_file_compression']['value'] );
$download_file_compression_radio -> addOptionArray( array( 'on'=>_MD_XOONIPS_DOWNLOAD_FILE_COMPRESSION_YES, 'off'=>_MD_XOONIPS_DOWNLOAD_FILE_COMPRESSION_NO ) );
$form->addElement( $download_file_compression_radio );

$export_enabled_radio = new XoopsFormRadio( _MD_XOONIPS_EXPORT_ENABLED, 'export_enabled', $ar['export_enabled']['value'] );
$export_enabled_radio -> addOptionArray( array( 'on'=>_YES, 'off'=>_NO ) );
$form->addElement( $export_enabled_radio );

$export_attachment_radio = new XoopsFormRadio( _MD_XOONIPS_EXPORT_ATTACHMENT, 'export_attachment', $ar['export_attachment']['value'] );
$export_attachment_radio -> addOptionArray( array( 'on'=>_YES, 'off'=>_NO ) );
$form->addElement( $export_attachment_radio );

$private_import_enabled_radio = new XoopsFormRadio( _MD_XOONIPS_PRIVATE_IMPORT_ENABLED, 'private_import_enabled', $ar['private_import_enabled']['value'] );
$private_import_enabled_radio -> addOptionArray( array( 'on'=>_YES, 'off'=>_NO ) );
$form->addElement( $private_import_enabled_radio );

$rss_file_path_text = new XoopsFormText(_MD_XOONIPS_ACCOUNT_RSS_FILE_PATH_TITLE, 'rss_file_path', 40, 255, $ar['rss_file_path']['value']);
$form->addElement( $rss_file_path_text );

$rss_item_max_text = new XoopsFormText(_MD_XOONIPS_ACCOUNT_DEFAULT_RSS_ITEM_MAX_TITLE, 'rss_item_max', 5, 255, $ar['rss_item_max']['value']);
$form->addElement( $rss_item_max_text );

$tree_frame_width_text = new XoopsFormText(_MD_XOONIPS_INDEX_TF_WIDTH, 'tree_frame_width', 5, 255, $ar['tree_frame_width']['value']);
$form->addElement( $tree_frame_width_text );

$tree_frame_height_text = new XoopsFormText(_MD_XOONIPS_INDEX_TF_HEIGHT, 'tree_frame_height', 5, 255, $ar['tree_frame_height']['value']);
$form->addElement( $tree_frame_height_text );

$printer_friendly_header_text = new XoopsFormTextArea(_MD_XOONIPS_PRINT_HEADER, 'printer_friendly_header', $ar['printer_friendly_header']['value'], 5, 40 );
$form->addElement( $printer_friendly_header_text );

// 
$repository_name_text = new XoopsFormText(_MD_XOONIPS_REPOSITORY_NAME_TITLE, 'repository_name', 40, 255, $ar['repository_name']['value']);
$form->addElement( $repository_name_text );

$repository_nijc_code_text = new XoopsFormText(_MD_XOONIPS_REPOSITORY_NIJC_CODE_TITLE, 'repository_nijc_code', 40, 255, $ar['repository_nijc_code']['value']);
$form->addElement( $repository_nijc_code_text );

$repository_deletion_track_text = new XoopsFormText(_MD_XOONIPS_REPOSITORY_DELETION_TRACK_TITLE, 'repository_deletion_track', 5, 10, $ar['repository_deletion_track']['value']);
$form->addElement( $repository_deletion_track_text );

// repository_institution
$repository_institution_text = new XoopsFormText(_MD_XOONIPS_REPOSITORY_INSTITUTION_TITLE, 'repository_institution', 40, 255, $ar['repository_institution']['value']);
$form->addElement( $repository_institution_text );

// repository_publisher
$repository_publisher_text = new XoopsFormText(_MD_XOONIPS_REPOSITORY_PUBLISHER_TITLE, 'repository_publisher', 40, 255, $ar['repository_publisher']['value']);
$form->addElement( $repository_publisher_text );

// display in form
$form -> addElement( new XoopsFormHidden( "op", "update" ) );
$form -> addElement( new XoopsFormButton("", "submit", _US_SUBMIT, "submit"));
$form -> display();

xoops_cp_footer();
?>
